#!/usr/bin/perl

package eBay::API::XML::Call::SetShippingDiscountProfiles::SetShippingDiscountProfilesRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetShippingDiscountProfilesRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetShippingDiscountProfiles::SetShippingDiscountProfilesRequestType

=head1 DESCRIPTION

Enables a seller to define shipping cost discount profiles and a few additional
parameters related to combined payment, such as shipping insurance and packaging handling costs.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetShippingDiscountProfiles::SetShippingDiscountProfilesRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::CalculatedHandlingDiscountType;
use eBay::API::XML::DataType::CalculatedShippingDiscountType;
use eBay::API::XML::DataType::FlatShippingDiscountType;
use eBay::API::XML::DataType::PromotionalShippingDiscountDetailsType;
use eBay::API::XML::DataType::ShippingInsuranceType;
use eBay::API::XML::DataType::Enum::CombinedPaymentPeriodCodeType;
use eBay::API::XML::DataType::Enum::CurrencyCodeType;
use eBay::API::XML::DataType::Enum::ModifyActionCodeType;


my @gaProperties = ( [ 'CalculatedHandlingDiscount', 'ns:CalculatedHandlingDiscountType', ''
	     ,'eBay::API::XML::DataType::CalculatedHandlingDiscountType', '1' ]
	, [ 'CalculatedShippingDiscount', 'ns:CalculatedShippingDiscountType', ''
	     ,'eBay::API::XML::DataType::CalculatedShippingDiscountType', '1' ]
	, [ 'CombinedDuration', 'ns:CombinedPaymentPeriodCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CombinedPaymentPeriodCodeType', '' ]
	, [ 'CurrencyID', 'ns:CurrencyCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CurrencyCodeType', '' ]
	, [ 'FlatShippingDiscount', 'ns:FlatShippingDiscountType', ''
	     ,'eBay::API::XML::DataType::FlatShippingDiscountType', '1' ]
	, [ 'InternationalShippingInsurance', 'ns:ShippingInsuranceType', ''
	     ,'eBay::API::XML::DataType::ShippingInsuranceType', '1' ]
	, [ 'ModifyActionCode', 'ns:ModifyActionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ModifyActionCodeType', '' ]
	, [ 'PromotionalShippingDiscountDetails', 'ns:PromotionalShippingDiscountDetailsType', ''
	     ,'eBay::API::XML::DataType::PromotionalShippingDiscountDetailsType', '1' ]
	, [ 'ShippingInsurance', 'ns:ShippingInsuranceType', ''
	     ,'eBay::API::XML::DataType::ShippingInsuranceType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCalculatedHandlingDiscount()

The data for the specific packaging/handling cost details for combined payment.

  RequiredInput: No
#    Argument: 'ns:CalculatedHandlingDiscountType'

=cut

sub setCalculatedHandlingDiscount {
  my $self = shift;
  $self->{'CalculatedHandlingDiscount'} = shift
}

=head2 getCalculatedHandlingDiscount()

#    Returns: 'ns:CalculatedHandlingDiscountType'

=cut

sub getCalculatedHandlingDiscount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CalculatedHandlingDiscount'
		,'eBay::API::XML::DataType::CalculatedHandlingDiscountType');
}


=head2 setCalculatedShippingDiscount()

Details of a shipping cost discount profile for calculated shipping.
If this is provided, FlatShippingDiscount and PromotionalShippingDiscountDetails
should be omitted.

  RequiredInput: No
#    Argument: 'ns:CalculatedShippingDiscountType'

=cut

sub setCalculatedShippingDiscount {
  my $self = shift;
  $self->{'CalculatedShippingDiscount'} = shift
}

=head2 getCalculatedShippingDiscount()

#    Returns: 'ns:CalculatedShippingDiscountType'

=cut

sub getCalculatedShippingDiscount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CalculatedShippingDiscount'
		,'eBay::API::XML::DataType::CalculatedShippingDiscountType');
}


=head2 setCombinedDuration()

Only those items purchased within CombinedDuration days of each other can
be combined into an order and benefit from any shipping discounts.

  RequiredInput: Yes
#    Argument: 'ns:CombinedPaymentPeriodCodeType'

=cut

sub setCombinedDuration {
  my $self = shift;
  $self->{'CombinedDuration'} = shift
}

=head2 getCombinedDuration()

#    Returns: 'ns:CombinedPaymentPeriodCodeType'

=cut

sub getCombinedDuration {
  my $self = shift;
  return $self->{'CombinedDuration'};
}


=head2 setCurrencyID()

The ID of the currency to be used for shipping cost discounts and
insurance for combined payment. A discount profile can only be
associated with a listing if the currency ID of the profile matches the
currency ID of the listing.
Required if the user creates flat rate shipping discount profiles, a promotional
discount, a packaging/handling cost profile based on a variable
discount rule, or if the user defines shipping insurance range/fee pairs.
<br><br>
Note: There is a currencyID attribute on many elements of SetShippingDiscountProfiles.
To avoid an error, be sure to use the same value of CurrencyCodeType in each
occurrence within the same request.

  RequiredInput: Conditionally
#    Argument: 'ns:CurrencyCodeType'

=cut

sub setCurrencyID {
  my $self = shift;
  $self->{'CurrencyID'} = shift
}

=head2 getCurrencyID()

#    Returns: 'ns:CurrencyCodeType'

=cut

sub getCurrencyID {
  my $self = shift;
  return $self->{'CurrencyID'};
}


=head2 setFlatShippingDiscount()

Details of a shipping cost discount profile for flat rate shipping.
If this is provided, CalculatedShippingDiscount and PromotionalShippingDiscountDetails
should be omitted.

  RequiredInput: No
#    Argument: 'ns:FlatShippingDiscountType'

=cut

sub setFlatShippingDiscount {
  my $self = shift;
  $self->{'FlatShippingDiscount'} = shift
}

=head2 getFlatShippingDiscount()

#    Returns: 'ns:FlatShippingDiscountType'

=cut

sub getFlatShippingDiscount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'FlatShippingDiscount'
		,'eBay::API::XML::DataType::FlatShippingDiscountType');
}


=head2 setInternationalShippingInsurance()

Information establishing what fee to apply for international shipping
insurance for combined payment depending on which range the order item-
total price falls into.

  RequiredInput: No
#    Argument: 'ns:ShippingInsuranceType'

=cut

sub setInternationalShippingInsurance {
  my $self = shift;
  $self->{'InternationalShippingInsurance'} = shift
}

=head2 getInternationalShippingInsurance()

#    Returns: 'ns:ShippingInsuranceType'

=cut

sub getInternationalShippingInsurance {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InternationalShippingInsurance'
		,'eBay::API::XML::DataType::ShippingInsuranceType');
}


=head2 setModifyActionCode()

Indicates what action to take on the specified flat shipping discount,
calculated shipping discount or promotional discount.
If the action is Delete and if a flat rate or calculated shipping discount
profile is specified, the discount profile identified by
DiscountProfile.DiscountProfileID is deleted
(see DiscountProfile.MappedDiscountProfileID for related details).

  RequiredInput: Yes
#    Argument: 'ns:ModifyActionCodeType'

=cut

sub setModifyActionCode {
  my $self = shift;
  $self->{'ModifyActionCode'} = shift
}

=head2 getModifyActionCode()

#    Returns: 'ns:ModifyActionCodeType'

=cut

sub getModifyActionCode {
  my $self = shift;
  return $self->{'ModifyActionCode'};
}


=head2 setPromotionalShippingDiscountDetails()

The data for the promotional shipping discount.
If this is provided, FlatShippingDiscount and CalculatedShippingDiscount
should be omitted.

  RequiredInput: No
#    Argument: 'ns:PromotionalShippingDiscountDetailsType'

=cut

sub setPromotionalShippingDiscountDetails {
  my $self = shift;
  $self->{'PromotionalShippingDiscountDetails'} = shift
}

=head2 getPromotionalShippingDiscountDetails()

#    Returns: 'ns:PromotionalShippingDiscountDetailsType'

=cut

sub getPromotionalShippingDiscountDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PromotionalShippingDiscountDetails'
		,'eBay::API::XML::DataType::PromotionalShippingDiscountDetailsType');
}


=head2 setShippingInsurance()

Information establishing what fee to apply for domestic shipping insurance
for combined payment depending on which range the order item-total price
falls into.

  RequiredInput: No
#    Argument: 'ns:ShippingInsuranceType'

=cut

sub setShippingInsurance {
  my $self = shift;
  $self->{'ShippingInsurance'} = shift
}

=head2 getShippingInsurance()

#    Returns: 'ns:ShippingInsuranceType'

=cut

sub getShippingInsurance {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingInsurance'
		,'eBay::API::XML::DataType::ShippingInsuranceType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
