

/*############################################################################
 # ============================>  dvicom.h  <=============================== #
 #***************************************************************************#
 #         The dvicom.h file holds all file pointers and definitions         #
 #                             used commonly                                 #
 #            in all versions of dvixx.c DVI driver programmes.              #
 ############################################################################*/

/*===========================================================================
  =         global files used in all dvixx.c programmes                     =
  ===========================================================================*/

  FILE *bitfile;
  FILE *geninput;
  FILE *pkfile;
  FILE *usgfile;
  FILE *tfmfile;
  FILE *dvifile;


/*****************************************************************************
 * Here comes some code, that could be optimized in respect to system-depen- *
 * dencies. The general function definitions should be system independent,   *
 * but they need addional overhead in calling them. So in using macros in-   *
 * stead speeds up the program, but makes the program less portable. E. g.,  *
 * the macros work fine on HP9000 Serie 500 and 800 computers but not on     *
 * Serie 300. Make the changes in the macros you need for your system, or    *
 * use the slightly less efficient functions instead for your system!        *
 *****************************************************************************/

#define getbyte() getc(dvifile)
#define signedquad() getw(dvifile)

#ifndef MACROS
getpair()
{ register int a;
  a = getbyte();
  return( (a << 8) + getbyte());
}

gettrio()
{ register int a;
  a = getbyte();
  a = (a << 8) + getbyte();
  return ( (a << 8) + getbyte());
}

signedbyte()
{ register int a;
  return ( (a = getbyte()) < 128 ? a : a - 256);
}

signedpair()
{ register int a, b ;
  b = (a = getbyte()) < 128 ? a : a - 256;
  return( (b << 8) + getbyte());
}

signedtrio()
{ register int a, b ;
  b = (a = getbyte()) < 128 ? a : a - 256;
  b = (b << 8) + getbyte();
  return( (b << 8) + getbyte());
}

#else

#define getpair() (getbyte() << 8) + getbyte()
#define gettrio() ((getpair()) << 8) + getbyte()
#define signedbyte() (_a = getbyte()) < 128 ? _a : _a - 256
#define signedpair() ((signedbyte()) << 8) + getbyte()
#define signedtrio() ((signedpair()) << 8) + getbyte()

#endif


/*===========================================================================
 = ===> rulepixels(x)                                                       =
 = This macro computes the number of pixel in the height or width, rounded  =
 = to the nearest integer for a rule                                        =
 ============================================================================*/

#define rulepixels(x)  (!(_a = round(convdot * x)) ? 1 : _a)



/*===========================================================================
  =    Define all DVI commands by symbolic names                            =
  ===========================================================================*/

#define set_char_0   0
#define set1       128
#define set2       129
#define set3       130
#define set4       131
#define set_rule   132
#define put1       133
#define put2       134
#define put3       135
#define put4       136
#define put_rule   137
#define nop        138
#define bop        139
#define eop        140
#define push       141
#define pop        142
#define right1     143
#define right2     144
#define right3     145
#define right4     146
#define w0         147
#define w1         148
#define w2         149
#define w3         150
#define w4         151
#define x0         152
#define x1         153
#define x2         154
#define x3         155
#define x4         156
#define down1      157
#define down2      158
#define down3      159
#define down4      160
#define y0         161
#define y1         162
#define y2         163
#define y3         164
#define y4         165
#define z0         166
#define z1         167
#define z2         168
#define z3         169
#define z4         170
#define fnt_num_0  171
#define fnt_num_63 234
#define fnt1       235
#define fnt2       236
#define fnt3       237
#define fnt4       238
#define xxx1       239
#define xxx2       240
#define xxx3       241
#define xxx4       242
#define fnt_def1   243
#define fnt_def2   244
#define fnt_def3   245
#define fnt_def4   246
#define pre        247
#define post       248
#define postpost   249
#define undef0     250
#define undef1     251
#define undef2     252
#define undef3     253
#define undef4     254
#define undef5     255

  


/*==========================================================================*
 *                 global type definitions                                  *
 *==========================================================================*/

typedef struct                       /* internal character information */
      { unsigned short pk_char;
        short pxl_width;
        long  tfm_width;
        long use_count;
      } charfmt;
typedef struct                       /* internal font information */
      { long  checksum;
        long  scaled_size;
        long  design_size;
        long  space;
        short dir_size;
        short height;
        short down;
        short name; 
        short bc,ec;
        charfmt chr[256];
      } fontfmt;
typedef struct                       /* internal graphic char information */
      { short pxl_bytes,pxl_rows;
        short x_offset,y_offset;
        byte *pxl_pattern;
      } gcharfmt;
typedef gcharfmt (*gfontfmt)[256];   /* internal graphic font information */

typedef struct                       /* header part of TFM file */
      { short lf,lh,bc,ec,nw,nh,nd,ni,nl,nk,ne,np;
        long  cs,ds;
      } tfmfmt;
  

