/*
 * Decompiled with CFR 0.152.
 */
package nts.align;

import nts.base.Glue;
import nts.command.Token;
import nts.command.TokenList;

public class Preamble {
    public static final Entry NULL_ENTRY;
    public final Glue firstSkip;
    public final String skipName;
    public final Token endTemplate;
    private final Entry[] records;
    private final int loopIndex;

    public int length() {
        return this.records.length;
    }

    public boolean periodic() {
        return this.loopIndex >= 0;
    }

    public boolean hasRecord(int i) {
        return i >= 0 && (i < this.records.length || this.loopIndex >= 0);
    }

    public TokenList getUPart(int i) {
        Entry ent = this.getEntry(i);
        return ent != null ? ent.uPart : null;
    }

    public TokenList getVPart(int i) {
        Entry ent = this.getEntry(i);
        return ent != null ? ent.vPart : null;
    }

    public Glue getSkip(int i) {
        Entry ent = this.getEntry(i);
        return ent != null ? ent.skip : null;
    }

    private Entry getEntry(int i) {
        if (i >= 0) {
            if (i < this.records.length) {
                return this.records[i];
            }
            if (this.loopIndex >= 0) {
                return this.records[this.loopIndex + (i - this.loopIndex) % (this.records.length - this.loopIndex)];
            }
        }
        return null;
    }

    public Preamble(Glue firstSkip, String skipName, Token endTemplate, Entry[] records, int loopIndex) {
        this.firstSkip = firstSkip;
        this.skipName = skipName;
        this.endTemplate = endTemplate;
        this.records = records;
        this.loopIndex = loopIndex;
        if (loopIndex >= records.length) {
            throw new RuntimeException("invalid Preamble loopIndex");
        }
    }

    public static class Entry {
        private TokenList uPart;
        private TokenList vPart;
        private Glue skip;

        public Entry(TokenList uPart, TokenList vPart, Glue skip) {
            this.uPart = uPart;
            this.vPart = vPart;
            this.skip = skip;
        }
    }
}

