/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.command.ParamToken;
import nts.command.Token;
import nts.command.TokenList;
import nts.io.CharCode;
import nts.io.Log;
import nts.io.Name;

public class MacroBody
extends TokenList {
    public static final MacroBody NULL;
    public static final MacroBody EMPTY;
    private static final String PREP = "->";
    private static final int PLEN;

    public void addOn(Log log) {
        log.add(PREP);
        super.addOn(log);
    }

    public void addOn(Log log, int maxCount) {
        if (maxCount > PLEN) {
            log.add(PREP);
            super.addOn(log, maxCount - PLEN);
        } else if (maxCount > 0) {
            log.add(PREP.substring(0, maxCount));
        }
    }

    public void addContext(Log left, Log right, int pos, int maxCount) {
        if (maxCount > PLEN) {
            left.add(PREP);
            super.addContext(left, right, pos, maxCount - PLEN);
        } else if (maxCount > 0) {
            left.add(PREP.substring(0, maxCount));
        }
    }

    public MacroBody() {
    }

    public MacroBody(Token[] tokens) {
        super(tokens);
    }

    public MacroBody(Token[] tokens, int offset, int count) {
        super(tokens, offset, count);
    }

    public MacroBody(Token tok) {
        super(tok);
    }

    public MacroBody(String str) {
        super(str);
    }

    public MacroBody(Name name) {
        super(name);
    }

    static {
        EMPTY = new MacroBody();
        PLEN = PREP.length();
    }

    public static class Buffer
    extends TokenList.Buffer {
        public TokenList.Buffer appendParam(int digit, CharCode matchCode) {
            return this.append(new ParamToken(digit, matchCode));
        }

        public MacroBody toMacroBody() {
            if (super.length() == 0) {
                return EMPTY;
            }
            Object[] tokens = new Token[super.length()];
            this.data.copyInto(tokens);
            return new MacroBody((Token[])tokens);
        }

        public TokenList toTokenList() {
            return this.toMacroBody();
        }

        public Buffer() {
        }

        public Buffer(int initCap) {
            super(initCap);
        }

        public Buffer(int initCap, int capIncrement) {
            super(initCap, capIncrement);
        }
    }
}

