/*
 * Decompiled with CFR 0.152.
 */
package nts.tex;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import nts.base.Dimen;
import nts.base.Num;
import nts.base.PairKey;
import nts.command.CommandBase;
import nts.command.FileName;
import nts.dvi.DviTypeSetter;
import nts.io.Log;
import nts.io.Loggable;
import nts.io.Name;
import nts.node.FontMetric;
import nts.node.TypeSetter;
import nts.tex.InfoTeXFontMetric;
import nts.tex.TeXIOHandler;
import nts.tfm.BadTeXFmException;
import nts.tfm.TeXFm;
import nts.tfm.TeXFontMetric;
import nts.typo.NullFontMetric;
import nts.typo.TypoCommand;

public class TeXFontHandler
extends CommandBase
implements TypoCommand.TypoHandler,
DviTypeSetter.FontInformator {
    protected static final TeXFmGroup NULL_GROUP;
    private static final int[] rTab;
    private Config config;
    private TeXIOHandler ioHand;
    private HashMap groupTab;
    private Sequencer sequencer;
    private HashMap paramTab = new HashMap();

    public Object getSeed() {
        return new Seed(this.groupTab, this.sequencer);
    }

    /*
     * WARNING - void declaration
     */
    public FontMetric getMetric(FileName name, Dimen size, Num scale, Name ident, Loggable tok) {
        String path = name.getPath();
        TeXFmGroup group = (TeXFmGroup)this.groupTab.get(path);
        if (group == null) {
            void tfm;
            Name groupName = name.baseName();
            try {
                TeXFm teXFm = TeXFm.readFrom(this.ioHand.openTeXFm(name));
            }
            catch (FileNotFoundException e) {
                this.fontError("TFMnotFound", path, size, scale, tok);
                return null;
            }
            catch (BadTeXFmException e) {
                this.fontError("TFMisBad", path, size, scale, tok);
                return null;
            }
            catch (IOException e) {
                System.err.println(e + "when reading " + name);
                return null;
            }
            group = new TeXFmGroup(groupName, (TeXFm)tfm, path);
            this.groupTab.put(path, group);
        }
        return group.get(size, scale, ident, this.config, this.sequencer);
    }

    private void fontError(String err, String path, Dimen size, Num scale, Loggable tok) {
        TeXFontHandler teXFontHandler = this;
        if (teXFontHandler == null) {
            throw null;
        }
        CommandBase.error(err, new Loggable(teXFontHandler, path, tok, size, scale){
            private final /* synthetic */ TeXFontHandler this$0;
            private final /* synthetic */ String val$path;
            private final /* synthetic */ Loggable val$tok;
            private final /* synthetic */ Dimen val$size;
            private final /* synthetic */ Num val$scale;

            public void addOn(Log log) {
                log.add(this.val$tok).add('=').add(this.val$path);
                if (this.val$size != null) {
                    log.add(" at " + this.val$size + "pt");
                }
                if (this.val$scale != null) {
                    log.add(" scaled " + this.val$scale);
                }
            }
            {
                this.val$path = val$path;
                this.val$tok = val$tok;
                this.val$size = val$size;
                this.val$scale = val$scale;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TeXFontHandler teXFontHandler) {
            }
        });
    }

    public TypoCommand.FontDimen getFontDimen(FontMetric metric, int num) {
        int idx = num - 1;
        int maxDefined = -1;
        if (TeXFontHandler.validRawDimIdx(idx)) {
            if (this.getRawDimPar(metric, idx) != null) {
                return this.makeFontDimen(metric, idx);
            }
            if (metric == this.sequencer.lastLoaded) {
                this.defineRawDimParsUpTo(metric, idx);
                return this.makeFontDimen(metric, idx);
            }
        } else {
            Num max = (Num)this.paramTab.get(metric);
            if (max != null) {
                maxDefined = max.intVal();
            }
            if (idx > maxDefined && metric == this.sequencer.lastLoaded) {
                this.defineRawDimParsUpTo(metric, idx);
                maxDefined = idx;
                this.paramTab.put(metric, Num.valueOf(maxDefined));
            }
            if (idx >= 0 && idx <= maxDefined) {
                return this.makeFontDimen(new PairKey(metric, Num.valueOf(idx)));
            }
        }
        if (maxDefined < 0) {
            maxDefined = this.maxDefinedRawDimPar(metric);
        }
        CommandBase.error("TooBigFontdimenNum", CommandBase.esc(metric.getIdent()), CommandBase.num(maxDefined + 1));
        TeXFontHandler teXFontHandler = this;
        if (teXFontHandler == null) {
            throw null;
        }
        return new TypoCommand.FontDimen(teXFontHandler){
            private final /* synthetic */ TeXFontHandler this$0;

            public Dimen get() {
                return Dimen.ZERO;
            }

            public void set(Dimen dim) {
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TeXFontHandler teXFontHandler) {
            }
        };
    }

    private TypoCommand.FontDimen makeFontDimen(FontMetric metric, int idx) {
        TeXFontHandler teXFontHandler = this;
        if (teXFontHandler == null) {
            throw null;
        }
        return new TypoCommand.FontDimen(teXFontHandler, metric, idx){
            private final /* synthetic */ TeXFontHandler this$0;
            private final /* synthetic */ FontMetric val$metric;
            private final /* synthetic */ int val$idx;

            public Dimen get() {
                return TeXFontHandler.access$0(this.this$0, this.val$metric, this.val$idx);
            }

            public void set(Dimen dim) {
                TeXFontHandler.access$1(this.this$0, this.val$metric, this.val$idx, dim);
            }
            {
                this.val$metric = val$metric;
                this.val$idx = val$idx;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TeXFontHandler teXFontHandler) {
            }
        };
    }

    private TypoCommand.FontDimen makeFontDimen(PairKey key) {
        TeXFontHandler teXFontHandler = this;
        if (teXFontHandler == null) {
            throw null;
        }
        return new TypoCommand.FontDimen(teXFontHandler, key){
            private final /* synthetic */ TeXFontHandler this$0;
            private final /* synthetic */ PairKey val$key;

            public Dimen get() {
                Dimen dim = (Dimen)TeXFontHandler.access$2(this.this$0).get(this.val$key);
                return dim != null ? dim : Dimen.ZERO;
            }

            public void set(Dimen dim) {
                TeXFontHandler.access$2(this.this$0).put(this.val$key, dim);
            }
            {
                this.val$key = val$key;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TeXFontHandler teXFontHandler) {
            }
        };
    }

    private static boolean validRawDimIdx(int idx) {
        return idx >= 0 && idx < rTab.length && rTab[idx] >= 0;
    }

    private Dimen getRawDimPar(FontMetric metric, int idx) {
        return metric.getDimenParam(rTab[idx]);
    }

    private void setRawDimPar(FontMetric metric, int idx, Dimen val) {
        int lTab = TeXFontMetric.numberOfRawDimenPars();
        int i = 0;
        while (i < lTab) {
            if (TeXFontMetric.rawDimenParNumber(i) == idx) {
                metric.setDimenParam(i, val);
            }
            ++i;
        }
    }

    private int maxDefinedRawDimPar(FontMetric metric) {
        int i = rTab.length;
        while (--i >= 0) {
            if (rTab[i] < 0 || metric.getDimenParam(rTab[i]) == null) continue;
            return i;
        }
        return -1;
    }

    private void defineRawDimParsUpTo(FontMetric metric, int idx) {
        int lTab = TeXFontMetric.numberOfRawDimenPars();
        int i = 0;
        while (i < lTab) {
            if (TeXFontMetric.rawDimenParNumber(i) <= idx && metric.getDimenParam(i) == null) {
                metric.setDimenParam(i, Dimen.ZERO);
            }
            ++i;
        }
    }

    public TypeSetter getSetter() {
        return this.ioHand.getTypeSetter(this);
    }

    public DviTypeSetter.FontInfo getInfo(FontMetric metric) {
        if (metric instanceof InfoTeXFontMetric) {
            return (InfoTeXFontMetric)metric;
        }
        throw new RuntimeException("No info about a font metric");
    }

    static /* synthetic */ Dimen access$0(TeXFontHandler teXFontHandler, FontMetric fontMetric, int n) {
        return teXFontHandler.getRawDimPar(fontMetric, n);
    }

    static /* synthetic */ void access$1(TeXFontHandler teXFontHandler, FontMetric fontMetric, int n, Dimen dimen) {
        teXFontHandler.setRawDimPar(fontMetric, n, dimen);
    }

    static /* synthetic */ HashMap access$2(TeXFontHandler teXFontHandler) {
        return teXFontHandler.paramTab;
    }

    public TeXFontHandler(Config config, TeXIOHandler ioHand, Object seed) {
        this.config = config;
        this.ioHand = ioHand;
        if (seed != null && seed instanceof Seed) {
            Seed s = (Seed)seed;
            this.groupTab = s.groupTab;
            this.sequencer = s.sequencer;
        } else {
            this.groupTab = new HashMap();
            this.sequencer = new Sequencer();
        }
    }

    public TeXFontHandler(Config config, TeXIOHandler ioHand) {
        this(config, ioHand, null);
    }

    static {
        int lTab = TeXFontMetric.numberOfRawDimenPars();
        int mTab = -1;
        int i = 0;
        while (i < lTab) {
            if (mTab < TeXFontMetric.rawDimenParNumber(i)) {
                mTab = TeXFontMetric.rawDimenParNumber(i);
            }
            ++i;
        }
        rTab = new int[mTab + 1];
        i = 0;
        while (i < rTab.length) {
            TeXFontHandler.rTab[i++] = -1;
        }
        i = 0;
        while (i < lTab) {
            int j = TeXFontMetric.rawDimenParNumber(i);
            if (j >= 0) {
                TeXFontHandler.rTab[j] = i;
            }
            ++i;
        }
    }

    private static final class Sequencer
    implements Serializable {
        public int nextIdNum = 0;
        public FontMetric lastLoaded = NullFontMetric.METRIC;

        Sequencer() {
        }
    }

    protected static class TeXFmGroup
    implements Serializable {
        private final Name name;
        private final TeXFm tfm;
        private final byte[] dirName;
        private final byte[] fileName;
        private final Vector members = new Vector();

        public Name getName() {
            return this.name;
        }

        public TeXFm getTfm() {
            return this.tfm;
        }

        public FontMetric get(Dimen size, Num scale, Name ident, Config config, Sequencer seq) {
            TeXFontMetric metric;
            if (size == null) {
                size = Dimen.valueOf(this.tfm.getDesignSize());
            }
            if (scale != null) {
                size = size.times(scale.intVal(), 1000);
            }
            int i = 0;
            while (i < this.members.size()) {
                metric = (TeXFontMetric)this.members.elementAt(i);
                if (size.equals(metric.getAtSize())) {
                    metric.setIdent(ident);
                    return metric;
                }
                ++i;
            }
            metric = new InfoTeXFontMetric(this.name, this.tfm, size, ident, seq.nextIdNum++, this.dirName, this.fileName);
            metric.setNumParam(0, config.defaultHyphenChar());
            metric.setNumParam(1, config.defaultSkewChar());
            this.members.addElement(metric);
            seq.lastLoaded = metric;
            return metric;
        }

        public TeXFmGroup(Name name, TeXFm tfm, String path) {
            this.name = name;
            this.tfm = tfm;
            String fname = new File(path).getName();
            int i = path.lastIndexOf(fname);
            this.dirName = i > 0 ? path.substring(0, i).getBytes() : new byte[]{};
            i = fname.length();
            while (--i > 0 && fname.charAt(i) != '.') {
            }
            this.fileName = (i > 0 ? fname.substring(0, i) : fname).getBytes();
        }
    }

    private static class Seed
    implements Serializable {
        public final HashMap groupTab;
        public final Sequencer sequencer;

        public Seed(HashMap tab, Sequencer seq) {
            this.groupTab = tab;
            this.sequencer = seq;
        }
    }

    public static interface Config {
        public Num defaultHyphenChar();

        public Num defaultSkewChar();
    }
}

