#!/bin/sh

echo "Trying to determine CLDR version"
java -jar /tmp/cldr-code.jar > /dev/null || exit 1
CLDR_VERSION=$($(java -jar /tmp/cldr-code.jar) | fgrep GEN_VERSION | cut -d= -f2 | cut -d. -f1)
rm -f /tmp/cldr-code.jar
echo "CLDR_VERSION=${CLDR_VERSION}"
CLDR_OLDVERSION=$(expr ${CLDR_VERSION} - 1)

cat > config/cldr.properties <<EOT
# Generated by ${0}
CLDR_VAP=admin_vap
CLDR_TESTPW=letmein
CLDR_HEADER=Welcome to dockerized SurveyTool
CLDR_NEWVERSION=${CLDR_VERSION}
CLDR_OLDVERSION=${CLDR_OLDVERSION}
CLDR_PHASE=${CLDR_PHASE}
CLDR_DIR=/srv/st/src/cldr
CLDR_WEBDRIVER_PASSWORD=pw-for-docker-webdriver
EOT
