// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +sve \
// RUN: -disable-O0-optnone \
// RUN:  -emit-llvm -o - %s | opt -S -passes=sroa | FileCheck %s

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// CHECK-LABEL: @lshift_i8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 16 x i8> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 16 x i8> [[SHL]]
//
svint8_t lshift_i8(svint8_t a, svint8_t b) {
  return a << b;
}

// CHECK-LABEL: @rshift_i8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHR:%.*]] = ashr <vscale x 16 x i8> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 16 x i8> [[SHR]]
//
svint8_t rshift_i8(svint8_t a, svint8_t b) {
  return a >> b;
}

// CHECK-LABEL: @lshift_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 16 x i8> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 16 x i8> [[SHL]]
//
svuint8_t lshift_u8(svuint8_t a, svuint8_t b) {
  return a << b;
}

// CHECK-LABEL: @rshift_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHR:%.*]] = lshr <vscale x 16 x i8> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 16 x i8> [[SHR]]
//
svuint8_t rshift_u8(svuint8_t a, svuint8_t b) {
  return a >> b;
}

// CHECK-LABEL: @lshift_i16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 8 x i16> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 8 x i16> [[SHL]]
//
svint16_t lshift_i16(svint16_t a, svint16_t b) {
  return a << b;
}

// CHECK-LABEL: @rshift_i16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHR:%.*]] = ashr <vscale x 8 x i16> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 8 x i16> [[SHR]]
//
svint16_t rshift_i16(svint16_t a, svint16_t b) {
  return a >> b;
}

// CHECK-LABEL: @lshift_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 8 x i16> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 8 x i16> [[SHL]]
//
svuint16_t lshift_u16(svuint16_t a, svuint16_t b) {
  return a << b;
}

// CHECK-LABEL: @rshift_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHR:%.*]] = lshr <vscale x 8 x i16> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 8 x i16> [[SHR]]
//
svuint16_t rshift_u16(svuint16_t a, svuint16_t b) {
  return a >> b;
}

// CHECK-LABEL: @lshift_i32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 4 x i32> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 4 x i32> [[SHL]]
//
svint32_t lshift_i32(svint32_t a, svint32_t b) {
  return a << b;
}

// CHECK-LABEL: @rshift_i32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHR:%.*]] = ashr <vscale x 4 x i32> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 4 x i32> [[SHR]]
//
svint32_t rshift_i32(svint32_t a, svint32_t b) {
  return a >> b;
}

// CHECK-LABEL: @lshift_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 4 x i32> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 4 x i32> [[SHL]]
//
svuint32_t lshift_u32(svuint32_t a, svuint32_t b) {
  return a << b;
}

// CHECK-LABEL: @rshift_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHR:%.*]] = lshr <vscale x 4 x i32> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 4 x i32> [[SHR]]
//
svuint32_t rshift_u32(svuint32_t a, svuint32_t b) {
  return a >> b;
}

// CHECK-LABEL: @lshift_i64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 2 x i64> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 2 x i64> [[SHL]]
//
svint64_t lshift_i64(svint64_t a, svint64_t b) {
  return a << b;
}

// CHECK-LABEL: @rshift_i64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHR:%.*]] = ashr <vscale x 2 x i64> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 2 x i64> [[SHR]]
//
svint64_t rshift_i64(svint64_t a, svint64_t b) {
  return a >> b;
}

// CHECK-LABEL: @lshift_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 2 x i64> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 2 x i64> [[SHL]]
//
svuint64_t lshift_u64(svuint64_t a, svuint64_t b) {
  return a << b;
}

// CHECK-LABEL: @rshift_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHR:%.*]] = lshr <vscale x 2 x i64> [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    ret <vscale x 2 x i64> [[SHR]]
//
svuint64_t rshift_u64(svuint64_t a, svuint64_t b) {
  return a >> b;
}

// CHECK-LABEL: @lshift_i8_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 16 x i8> poison, i8 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 16 x i8> [[SPLAT_SPLATINSERT]], <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 16 x i8> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 16 x i8> [[SHL]]
//
svint8_t lshift_i8_rsplat(svint8_t a, int8_t b) {
  return a << b;
}

// CHECK-LABEL: @lshift_i8_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 16 x i8> poison, i8 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 16 x i8> [[SPLAT_SPLATINSERT]], <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 16 x i8> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 16 x i8> [[SHL]]
//
svint8_t lshift_i8_lsplat(svint8_t a, int8_t b) {
  return b << a;
}

// CHECK-LABEL: @rshift_i8_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 16 x i8> poison, i8 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 16 x i8> [[SPLAT_SPLATINSERT]], <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = ashr <vscale x 16 x i8> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 16 x i8> [[SHR]]
//
svint8_t rshift_i8_rsplat(svint8_t a, int8_t b) {
  return a >> b;
}

// CHECK-LABEL: @rshift_i8_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 16 x i8> poison, i8 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 16 x i8> [[SPLAT_SPLATINSERT]], <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = ashr <vscale x 16 x i8> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 16 x i8> [[SHR]]
//
svint8_t rshift_i8_lsplat(svint8_t a, int8_t b) {
  return b >> a;
}

// CHECK-LABEL: @lshift_u8_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 16 x i8> poison, i8 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 16 x i8> [[SPLAT_SPLATINSERT]], <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 16 x i8> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 16 x i8> [[SHL]]
//
svuint8_t lshift_u8_rsplat(svuint8_t a, uint8_t b) {
  return a << b;
}

// CHECK-LABEL: @lshift_u8_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 16 x i8> poison, i8 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 16 x i8> [[SPLAT_SPLATINSERT]], <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 16 x i8> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 16 x i8> [[SHL]]
//
svuint8_t lshift_u8_lsplat(svuint8_t a, uint8_t b) {
  return b << a;
}

// CHECK-LABEL: @rshift_u8_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 16 x i8> poison, i8 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 16 x i8> [[SPLAT_SPLATINSERT]], <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = lshr <vscale x 16 x i8> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 16 x i8> [[SHR]]
//
svuint8_t rshift_u8_rsplat(svuint8_t a, uint8_t b) {
  return a >> b;
}

// CHECK-LABEL: @rshift_u8_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 16 x i8> poison, i8 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 16 x i8> [[SPLAT_SPLATINSERT]], <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = lshr <vscale x 16 x i8> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 16 x i8> [[SHR]]
//
svuint8_t rshift_u8_lsplat(svuint8_t a, uint8_t b) {
  return b >> a;
}

// CHECK-LABEL: @lshift_i16_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 8 x i16> poison, i16 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 8 x i16> [[SPLAT_SPLATINSERT]], <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 8 x i16> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 8 x i16> [[SHL]]
//
svint16_t lshift_i16_rsplat(svint16_t a, int16_t b) {
  return a << b;
}

// CHECK-LABEL: @lshift_i16_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 8 x i16> poison, i16 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 8 x i16> [[SPLAT_SPLATINSERT]], <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 8 x i16> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 8 x i16> [[SHL]]
//
svint16_t lshift_i16_lsplat(svint16_t a, int16_t b) {
  return b << a;
}

// CHECK-LABEL: @rshift_i16_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 8 x i16> poison, i16 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 8 x i16> [[SPLAT_SPLATINSERT]], <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = ashr <vscale x 8 x i16> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 8 x i16> [[SHR]]
//
svint16_t rshift_i16_rsplat(svint16_t a, int16_t b) {
  return a >> b;
}

// CHECK-LABEL: @rshift_i16_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 8 x i16> poison, i16 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 8 x i16> [[SPLAT_SPLATINSERT]], <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = ashr <vscale x 8 x i16> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 8 x i16> [[SHR]]
//
svint16_t rshift_i16_lsplat(svint16_t a, int16_t b) {
  return b >> a;
}

// CHECK-LABEL: @lshift_u16_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 8 x i16> poison, i16 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 8 x i16> [[SPLAT_SPLATINSERT]], <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 8 x i16> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 8 x i16> [[SHL]]
//
svuint16_t lshift_u16_rsplat(svuint16_t a, uint16_t b) {
  return a << b;
}

// CHECK-LABEL: @lshift_u16_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 8 x i16> poison, i16 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 8 x i16> [[SPLAT_SPLATINSERT]], <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 8 x i16> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 8 x i16> [[SHL]]
//
svuint16_t lshift_u16_lsplat(svuint16_t a, uint16_t b) {
  return b << a;
}

// CHECK-LABEL: @rshift_u16_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 8 x i16> poison, i16 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 8 x i16> [[SPLAT_SPLATINSERT]], <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = lshr <vscale x 8 x i16> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 8 x i16> [[SHR]]
//
svuint16_t rshift_u16_rsplat(svuint16_t a, uint16_t b) {
  return a >> b;
}

// CHECK-LABEL: @rshift_u16_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 8 x i16> poison, i16 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 8 x i16> [[SPLAT_SPLATINSERT]], <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = lshr <vscale x 8 x i16> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 8 x i16> [[SHR]]
//
svuint16_t rshift_u16_lsplat(svuint16_t a, uint16_t b) {
  return b >> a;
}

// CHECK-LABEL: @lshift_i32_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 4 x i32> poison, i32 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 4 x i32> [[SPLAT_SPLATINSERT]], <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 4 x i32> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 4 x i32> [[SHL]]
//
svint32_t lshift_i32_rsplat(svint32_t a, int32_t b) {
  return a << b;
}

// CHECK-LABEL: @lshift_i32_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 4 x i32> poison, i32 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 4 x i32> [[SPLAT_SPLATINSERT]], <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 4 x i32> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 4 x i32> [[SHL]]
//
svint32_t lshift_i32_lsplat(svint32_t a, int32_t b) {
  return b << a;
}

// CHECK-LABEL: @rshift_i32_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 4 x i32> poison, i32 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 4 x i32> [[SPLAT_SPLATINSERT]], <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = ashr <vscale x 4 x i32> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 4 x i32> [[SHR]]
//
svint32_t rshift_i32_rsplat(svint32_t a, int32_t b) {
  return a >> b;
}

// CHECK-LABEL: @rshift_i32_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 4 x i32> poison, i32 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 4 x i32> [[SPLAT_SPLATINSERT]], <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = ashr <vscale x 4 x i32> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 4 x i32> [[SHR]]
//
svint32_t rshift_i32_lsplat(svint32_t a, int32_t b) {
  return b >> a;
}

// CHECK-LABEL: @lshift_u32_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 4 x i32> poison, i32 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 4 x i32> [[SPLAT_SPLATINSERT]], <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 4 x i32> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 4 x i32> [[SHL]]
//
svuint32_t lshift_u32_rsplat(svuint32_t a, uint32_t b) {
  return a << b;
}

// CHECK-LABEL: @lshift_u32_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 4 x i32> poison, i32 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 4 x i32> [[SPLAT_SPLATINSERT]], <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 4 x i32> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 4 x i32> [[SHL]]
//
svuint32_t lshift_u32_lsplat(svuint32_t a, uint32_t b) {
  return b << a;
}

// CHECK-LABEL: @rshift_u32_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 4 x i32> poison, i32 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 4 x i32> [[SPLAT_SPLATINSERT]], <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = lshr <vscale x 4 x i32> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 4 x i32> [[SHR]]
//
svuint32_t rshift_u32_rsplat(svuint32_t a, uint32_t b) {
  return a >> b;
}

// CHECK-LABEL: @rshift_u32_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 4 x i32> poison, i32 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 4 x i32> [[SPLAT_SPLATINSERT]], <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = lshr <vscale x 4 x i32> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 4 x i32> [[SHR]]
//
svuint32_t rshift_u32_lsplat(svuint32_t a, uint32_t b) {
  return b >> a;
}

// CHECK-LABEL: @lshift_i64_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 2 x i64> poison, i64 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 2 x i64> [[SPLAT_SPLATINSERT]], <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 2 x i64> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 2 x i64> [[SHL]]
//
svint64_t lshift_i64_rsplat(svint64_t a, int64_t b) {
  return a << b;
}

// CHECK-LABEL: @lshift_i64_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 2 x i64> poison, i64 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 2 x i64> [[SPLAT_SPLATINSERT]], <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 2 x i64> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 2 x i64> [[SHL]]
//
svint64_t lshift_i64_lsplat(svint64_t a, int64_t b) {
  return b << a;
}

// CHECK-LABEL: @rshift_i64_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 2 x i64> poison, i64 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 2 x i64> [[SPLAT_SPLATINSERT]], <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = ashr <vscale x 2 x i64> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 2 x i64> [[SHR]]
//
svint64_t rshift_i64_rsplat(svint64_t a, int64_t b) {
  return a >> b;
}

// CHECK-LABEL: @rshift_i64_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 2 x i64> poison, i64 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 2 x i64> [[SPLAT_SPLATINSERT]], <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = ashr <vscale x 2 x i64> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 2 x i64> [[SHR]]
//
svint64_t rshift_i64_lsplat(svint64_t a, int64_t b) {
  return b >> a;
}

// CHECK-LABEL: @lshift_u64_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 2 x i64> poison, i64 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 2 x i64> [[SPLAT_SPLATINSERT]], <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 2 x i64> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 2 x i64> [[SHL]]
//
svuint64_t lshift_u64_rsplat(svuint64_t a, uint64_t b) {
  return a << b;
}

// CHECK-LABEL: @lshift_u64_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 2 x i64> poison, i64 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 2 x i64> [[SPLAT_SPLATINSERT]], <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL:%.*]] = shl <vscale x 2 x i64> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 2 x i64> [[SHL]]
//
svuint64_t lshift_u64_lsplat(svuint64_t a, uint64_t b) {
  return b << a;
}

// CHECK-LABEL: @rshift_u64_rsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 2 x i64> poison, i64 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 2 x i64> [[SPLAT_SPLATINSERT]], <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = lshr <vscale x 2 x i64> [[A:%.*]], [[SPLAT_SPLAT]]
// CHECK-NEXT:    ret <vscale x 2 x i64> [[SHR]]
//
svuint64_t rshift_u64_rsplat(svuint64_t a, uint64_t b) {
  return a >> b;
}

// CHECK-LABEL: @rshift_u64_lsplat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <vscale x 2 x i64> poison, i64 [[B:%.*]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <vscale x 2 x i64> [[SPLAT_SPLATINSERT]], <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR:%.*]] = lshr <vscale x 2 x i64> [[SPLAT_SPLAT]], [[A:%.*]]
// CHECK-NEXT:    ret <vscale x 2 x i64> [[SHR]]
//
svuint64_t rshift_u64_lsplat(svuint64_t a, uint64_t b) {
  return b >> a;
}
