/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 12:38:47 GMT 2018
 */

package uk.ac.sanger.artemis.components.genebuilder.ortholog;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.util.List;
import javax.swing.JPasswordField;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.gmod.schema.sequence.Feature;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.chado.FeatureLocLazyQualifierValue;
import uk.ac.sanger.artemis.components.genebuilder.ortholog.OrthoParalogTable;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.DatabaseStreamFeature;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierLazyLoading;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.j2ssh.SshLogin;
import uk.ac.sanger.artemis.util.DatabaseDocument;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class OrthoParalogTable_ESTest extends OrthoParalogTable_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier();
      // Undeclared exception!
      try { 
        OrthoParalogTable.hasCluster(qualifier0, qualifier0, (GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.OrthoParalogTable", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      StringVector stringVector0 = new StringVector();
      // Undeclared exception!
      try { 
        OrthoParalogTable.containsStringInStringVector("", stringVector0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // Array index out of range: 0
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      String[] stringArray0 = new String[1];
      stringArray0[0] = "M:s-";
      StringVector stringVector0 = new StringVector(stringArray0);
      boolean boolean0 = OrthoParalogTable.containsStringInStringVector("M:s-", stringVector0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      String[] stringArray0 = new String[1];
      StringVector stringVector0 = new StringVector(stringArray0);
      // Undeclared exception!
      try { 
        OrthoParalogTable.containsStringInStringVector("M:s-", stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.StringVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      StringVector stringVector0 = new StringVector();
      boolean boolean0 = OrthoParalogTable.containsStringInStringVector("m+D^,VtN]H", stringVector0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      // Undeclared exception!
      try { 
        OrthoParalogTable.containsStringInStringVector("cluster_name", (StringVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.OrthoParalogTable", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("9`~]4J9>/%B1#ue&", (List) null);
      // Undeclared exception!
      try { 
        OrthoParalogTable.hasOrthoParlaog(qualifierLazyLoading0, qualifierLazyLoading0, (GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.QualifierLazyLoading", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("yFC+^4Nc", " was found when ");
      Key key0 = Key.CDS;
      Range range0 = new Range(82, 82);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      QualifierVector qualifierVector0 = new QualifierVector();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(key0, location0, qualifierVector0);
      boolean boolean0 = OrthoParalogTable.hasCluster((Qualifier) null, qualifier0, databaseStreamFeature0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("yFC+^4Nc", " was found when ");
      Key key0 = Key.CDS;
      Range range0 = new Range(82, 82);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      boolean boolean0 = OrthoParalogTable.hasOrthoParlaog(qualifier0, qualifier0, gFFStreamFeature0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = blastEntryInformation0.getDefaultKey();
      Range range0 = new Range(0);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      QualifierVector qualifierVector0 = new QualifierVector();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(key0, location0, qualifierVector0);
      OrthoParalogTable.hasOrthoParlaog((Qualifier) null, (Qualifier) null, databaseStreamFeature0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField(40);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, "VIEW", "V1Q{'k\\S~", true);
      Feature feature0 = new Feature();
      FeatureLocLazyQualifierValue featureLocLazyQualifierValue0 = new FeatureLocLazyQualifierValue(feature0, 40);
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("", featureLocLazyQualifierValue0);
      OrthoParalogTable orthoParalogTable0 = null;
      try {
        orthoParalogTable0 = new OrthoParalogTable(databaseDocument0, qualifierLazyLoading0, qualifierLazyLoading0, (uk.ac.sanger.artemis.Feature) null, true);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.chado.FeatureLocLazyQualifierValue cannot be cast to uk.ac.sanger.artemis.chado.ClusterLazyQualifierValue
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.OrthoParalogTable", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      SshLogin sshLogin0 = new SshLogin();
      JPasswordField jPasswordField0 = sshLogin0.getJPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("f%-Q@=", jPasswordField0, "", "", true);
      Qualifier qualifier0 = new Qualifier("0", (String) null);
      OrthoParalogTable orthoParalogTable0 = null;
      try {
        orthoParalogTable0 = new OrthoParalogTable(databaseDocument0, qualifier0, qualifier0, (uk.ac.sanger.artemis.Feature) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.StringVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("", 0);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, "Program", "Program", true);
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      uk.ac.sanger.artemis.Feature feature0 = new uk.ac.sanger.artemis.Feature(emblStreamFeature0);
      OrthoParalogTable orthoParalogTable0 = null;
      try {
        orthoParalogTable0 = new OrthoParalogTable(databaseDocument0, (Qualifier) null, (Qualifier) null, feature0, false);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("javax.swing.JTable", e);
      }
  }
}
