from typing import NamedTuple, Tuple, Type, Union, IO, Iterator, Any

API_VERSION: str

PATH_OR_FILE = Union[str, IO]

class ChunkIndexEntry(NamedTuple):
    refcount: int
    size: int

CIE = Union[Tuple[int, int], Type[ChunkIndexEntry]]

class ChunkIndex:
    def add(self, key: bytes, refs: int, size: int) -> None: ...
    def iteritems(self, marker: bytes = ...) -> Iterator: ...
    def __contains__(self, key: bytes) -> bool: ...
    def __getitem__(self, key: bytes) -> Type[ChunkIndexEntry]: ...
    def __setitem__(self, key: bytes, value: CIE) -> None: ...

class NSIndex1Entry(NamedTuple):
    segment: int
    offset: int

class NSIndex1:  # legacy
    def iteritems(self, *args, **kwargs) -> Iterator: ...
    def __contains__(self, key: bytes) -> bool: ...
    def __getitem__(self, key: bytes) -> Any: ...
    def __setitem__(self, key: bytes, value: Any) -> None: ...

class FuseVersionsIndexEntry(NamedTuple):
    version: int
    hash: bytes

class FuseVersionsIndex:
    def __contains__(self, key: bytes) -> bool: ...
    def __getitem__(self, key: bytes) -> Any: ...
    def __setitem__(self, key: bytes, value: Any) -> None: ...
