/* application.c generated by valac 0.56.17, the Vala compiler
 * generated from application.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2017-2025 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <ibus.h>
#include <glib-object.h>
#include <stdio.h>
#include <ibuswaylandim.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <errno.h>
#include <glib/gstdio.h>
#include <pwd.h>
#include <unistd.h>
#include <gdk/gdk.h>
#include <gdk/gdkwayland.h>
#include <gobject/gvaluecollector.h>

#define IBUS_WAYLAND_VERSION "1.1"
#define G_USEC_PER_SEC ((gulong) 1000000L)
#define SLEEP_DIV_PER_SEC ((gulong) 100L)
#define MAX_DISPLAY_IDLE_TIME (((G_USEC_PER_SEC * SLEEP_DIV_PER_SEC) * 60) * 3)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_PANEL (panel_get_type ())
#define PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PANEL, Panel))
#define PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PANEL, PanelClass))
#define IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PANEL))
#define IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PANEL))
#define PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PANEL, PanelClass))

typedef struct _Panel Panel;
typedef struct _PanelClass PanelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))
typedef struct _ParamSpecApplication ParamSpecApplication;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Application {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GTypeClass parent_class;
	void (*finalize) (Application *self);
};

struct _ApplicationPrivate {
	Panel* m_panel;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
};

struct _ParamSpecApplication {
	GParamSpec parent_instance;
};

VALA_EXTERN gchar* prgname;
gchar* prgname = NULL;
VALA_EXTERN IBusBus* bus;
IBusBus* bus = NULL;
static gint Application_private_offset;
static gpointer application_parent_class = NULL;
static FILE* application_m_log;
static FILE* application_m_log = NULL;
static gboolean application_m_verbose;
static gboolean application_m_verbose = FALSE;
static gboolean application_m_enable_wayland_im;
static gboolean application_m_enable_wayland_im = FALSE;
static gulong application_m_realize_surface_id;
static gulong application_m_realize_surface_id = 0UL;
static gulong application_m_ibus_focus_in_id;
static gulong application_m_ibus_focus_in_id = 0UL;
static gulong application_m_ibus_focus_out_id;
static gulong application_m_ibus_focus_out_id = 0UL;
static gchar* application_m_user;
static gchar* application_m_user = NULL;
static IBusWaylandIM* application_m_wayland_im;
static IBusWaylandIM* application_m_wayland_im = NULL;
static gboolean application_m_exec_daemon;
static gboolean application_m_exec_daemon = FALSE;
static gchar* application_m_daemon_args;
static gchar* application_m_daemon_args = NULL;

VALA_EXTERN gpointer application_ref (gpointer instance);
VALA_EXTERN void application_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_application (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_application (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_application (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_application (const GValue* value);
VALA_EXTERN GType application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Application, application_unref)
VALA_EXTERN GType panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Panel, g_object_unref)
VALA_EXTERN Application* application_new (void);
VALA_EXTERN Application* application_construct (GType object_type);
static void application_bus_connected (Application* self,
                                IBusBus* bus);
static void _application_bus_connected_ibus_bus_connected (IBusBus* _sender,
                                                    gpointer self);
static void application_bus_disconnected (Application* self,
                                   IBusBus* bus);
static void _application_bus_disconnected_ibus_bus_disconnected (IBusBus* _sender,
                                                          gpointer self);
static void application_bus_global_shortcut_key_cb (Application* self,
                                             IBusBus* bus,
                                             guint8 type,
                                             guint keyval,
                                             guint keycode,
                                             guint state,
                                             gboolean is_backward);
static void _application_bus_global_shortcut_key_cb_ibus_bus_global_shortcut_key_responded (IBusBus* _sender,
                                                                                     guint8 type,
                                                                                     guint keyval,
                                                                                     guint keycode,
                                                                                     guint state,
                                                                                     gboolean is_backward,
                                                                                     gpointer self);
static void application_init (Application* self);
static void application_bus_name_acquired_cb (Application* self,
                                       GDBusConnection* connection,
                                       const gchar* sender_name,
                                       const gchar* object_path,
                                       const gchar* interface_name,
                                       const gchar* signal_name,
                                       GVariant* parameters);
static void _application_bus_name_acquired_cb_gd_bus_signal_callback (GDBusConnection* connection,
                                                               const gchar* sender_name,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* signal_name,
                                                               GVariant* parameters,
                                                               gpointer self);
static void application_bus_name_lost_cb (Application* self,
                                   GDBusConnection* connection,
                                   const gchar* sender_name,
                                   const gchar* object_path,
                                   const gchar* interface_name,
                                   const gchar* signal_name,
                                   GVariant* parameters);
static void _application_bus_name_lost_cb_gd_bus_signal_callback (GDBusConnection* connection,
                                                           const gchar* sender_name,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* signal_name,
                                                           GVariant* parameters,
                                                           gpointer self);
VALA_EXTERN gint application_run (Application* self);
VALA_EXTERN Panel* panel_new (IBusBus* bus,
                  gboolean is_wayland_im);
VALA_EXTERN Panel* panel_construct (GType object_type,
                        IBusBus* bus,
                        gboolean is_wayland_im);
VALA_EXTERN void panel_set_log (Panel* self,
                    FILE* log,
                    gboolean verbose);
static void __lambda115_ (Application* self,
                   Panel* w,
                   void* s);
static void application_set_wayland_surface (Application* self,
                                      void* surface);
static void ___lambda115__panel_realize_surface (Panel* _sender,
                                          void* surface,
                                          gpointer self);
static void __lambda116_ (Application* self,
                   IBusWaylandIM* w,
                   const gchar* o);
VALA_EXTERN void panel_set_wayland_object_path (Panel* self,
                                    const gchar* object_path);
static void ___lambda116__ibus_wayland_im_ibus_focus_in (IBusWaylandIM* _sender,
                                                  const gchar* object,
                                                  gpointer self);
static void __lambda117_ (Application* self,
                   IBusWaylandIM* w,
                   const gchar* o);
static void ___lambda117__ibus_wayland_im_ibus_focus_out (IBusWaylandIM* _sender,
                                                   const gchar* object,
                                                   gpointer self);
VALA_EXTERN void panel_load_settings (Panel* self);
VALA_EXTERN void panel_disconnect_signals (Panel* self);
VALA_EXTERN void panel_set_global_shortcut_key_state (Panel* self,
                                          IBusBusGlobalBindingType type,
                                          guint keyval,
                                          guint keycode,
                                          guint state,
                                          gboolean is_backward);
static gboolean application_open_log (void);
static void application_check_ps (void);
static gboolean application_run_ibus_daemon (void);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void application_make_wayland_im (void);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN gboolean binding_common_default_is_xdisplay (void);
static void ___lambda118_ (Block1Data* _data1_,
                    IBusBus* bus);
static void ____lambda118__ibus_bus_connected (IBusBus* _sender,
                                        gpointer self);
VALA_EXTERN void application_show_version (void);
static void application_main (gchar** argv,
                       gint argv_length1);
static void application_finalize (Application * obj);
static GType application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
application_get_instance_private (Application* self)
{
	return G_STRUCT_MEMBER_P (self, Application_private_offset);
}

static void
_application_bus_connected_ibus_bus_connected (IBusBus* _sender,
                                               gpointer self)
{
	application_bus_connected ((Application*) self, _sender);
}

static void
_application_bus_disconnected_ibus_bus_disconnected (IBusBus* _sender,
                                                     gpointer self)
{
	application_bus_disconnected ((Application*) self, _sender);
}

static void
_application_bus_global_shortcut_key_cb_ibus_bus_global_shortcut_key_responded (IBusBus* _sender,
                                                                                guint8 type,
                                                                                guint keyval,
                                                                                guint keycode,
                                                                                guint state,
                                                                                gboolean is_backward,
                                                                                gpointer self)
{
	application_bus_global_shortcut_key_cb ((Application*) self, _sender, type, keyval, keycode, state, is_backward);
}

Application*
application_construct (GType object_type)
{
	Application* self = NULL;
	IBusBus* _tmp0_;
	IBusBus* _tmp2_;
	IBusBus* _tmp3_;
	IBusBus* _tmp4_;
	IBusBus* _tmp5_;
	IBusBus* _tmp6_;
	self = (Application*) g_type_create_instance (object_type);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = bus;
	if (_tmp0_ == NULL) {
		IBusBus* _tmp1_;
		_tmp1_ = ibus_bus_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (bus);
		bus = _tmp1_;
	}
	_tmp2_ = bus;
	g_signal_connect (_tmp2_, "connected", (GCallback) _application_bus_connected_ibus_bus_connected, self);
	_tmp3_ = bus;
	g_signal_connect (_tmp3_, "disconnected", (GCallback) _application_bus_disconnected_ibus_bus_disconnected, self);
	_tmp4_ = bus;
	ibus_bus_set_watch_ibus_signal (_tmp4_, TRUE);
	_tmp5_ = bus;
	g_signal_connect (_tmp5_, "global-shortcut-key-responded", (GCallback) _application_bus_global_shortcut_key_cb_ibus_bus_global_shortcut_key_responded, self);
	_tmp6_ = bus;
	if (ibus_bus_is_connected (_tmp6_)) {
		application_init (self);
	}
	return self;
}

Application*
application_new (void)
{
	return application_construct (TYPE_APPLICATION);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_application_bus_name_acquired_cb_gd_bus_signal_callback (GDBusConnection* connection,
                                                          const gchar* sender_name,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* signal_name,
                                                          GVariant* parameters,
                                                          gpointer self)
{
	application_bus_name_acquired_cb ((Application*) self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}

static void
_application_bus_name_lost_cb_gd_bus_signal_callback (GDBusConnection* connection,
                                                      const gchar* sender_name,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* signal_name,
                                                      GVariant* parameters,
                                                      gpointer self)
{
	application_bus_name_lost_cb ((Application*) self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}

static void
application_init (Application* self)
{
	GDBusConnection* connection = NULL;
	IBusBus* _tmp0_;
	GDBusConnection* _tmp1_;
	GDBusConnection* _tmp2_;
	IBusBusNameFlag flags = 0U;
	IBusBus* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bus;
	_tmp1_ = ibus_bus_get_connection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	connection = _tmp2_;
	g_dbus_connection_signal_subscribe (connection, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameAcquired", "/org/freedesktop/DBus", IBUS_SERVICE_PANEL, G_DBUS_SIGNAL_FLAGS_NONE, _application_bus_name_acquired_cb_gd_bus_signal_callback, application_ref (self), application_unref);
	g_dbus_connection_signal_subscribe (connection, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameLost", "/org/freedesktop/DBus", IBUS_SERVICE_PANEL, G_DBUS_SIGNAL_FLAGS_NONE, _application_bus_name_lost_cb_gd_bus_signal_callback, application_ref (self), application_unref);
	flags = IBUS_BUS_NAME_FLAG_ALLOW_REPLACEMENT | IBUS_BUS_NAME_FLAG_REPLACE_EXISTING;
	_tmp3_ = bus;
	ibus_bus_request_name (_tmp3_, IBUS_SERVICE_PANEL, (guint32) flags);
	_g_object_unref0 (connection);
}

gint
application_run (Application* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	gtk_main ();
	result = 0;
	return result;
}

static void
__lambda115_ (Application* self,
              Panel* w,
              void* s)
{
	g_return_if_fail (w != NULL);
	application_set_wayland_surface (self, s);
}

static void
___lambda115__panel_realize_surface (Panel* _sender,
                                     void* surface,
                                     gpointer self)
{
	__lambda115_ ((Application*) self, _sender, surface);
}

static void
__lambda116_ (Application* self,
              IBusWaylandIM* w,
              const gchar* o)
{
	Panel* _tmp0_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (o != NULL);
	_tmp0_ = self->priv->m_panel;
	panel_set_wayland_object_path (_tmp0_, o);
}

static void
___lambda116__ibus_wayland_im_ibus_focus_in (IBusWaylandIM* _sender,
                                             const gchar* object,
                                             gpointer self)
{
	__lambda116_ ((Application*) self, _sender, object);
}

static void
__lambda117_ (Application* self,
              IBusWaylandIM* w,
              const gchar* o)
{
	Panel* _tmp0_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (o != NULL);
	_tmp0_ = self->priv->m_panel;
	panel_set_wayland_object_path (_tmp0_, NULL);
}

static void
___lambda117__ibus_wayland_im_ibus_focus_out (IBusWaylandIM* _sender,
                                              const gchar* object,
                                              gpointer self)
{
	__lambda117_ ((Application*) self, _sender, object);
}

static void
application_bus_name_acquired_cb (Application* self,
                                  GDBusConnection* connection,
                                  const gchar* sender_name,
                                  const gchar* object_path,
                                  const gchar* interface_name,
                                  const gchar* signal_name,
                                  GVariant* parameters)
{
	IBusBus* _tmp0_;
	Panel* _tmp1_;
	FILE* _tmp2_;
	Panel* _tmp5_;
	gulong _tmp6_;
	IBusWaylandIM* _tmp7_;
	gulong _tmp8_;
	IBusWaylandIM* _tmp9_;
	gulong _tmp10_;
	Panel* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	g_debug ("application.vala:99: signal_name = %s", signal_name);
	_tmp0_ = bus;
	_tmp1_ = panel_new (_tmp0_, application_m_enable_wayland_im);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->m_panel);
	self->priv->m_panel = _tmp1_;
	_tmp2_ = application_m_log;
	if (_tmp2_ != NULL) {
		Panel* _tmp3_;
		FILE* _tmp4_;
		_tmp3_ = self->priv->m_panel;
		_tmp4_ = application_m_log;
		panel_set_log (_tmp3_, _tmp4_, application_m_verbose);
	}
	_tmp5_ = self->priv->m_panel;
	_tmp6_ = g_signal_connect (_tmp5_, "realize-surface", (GCallback) ___lambda115__panel_realize_surface, self);
	application_m_realize_surface_id = _tmp6_;
	_tmp7_ = application_m_wayland_im;
	_tmp8_ = g_signal_connect (_tmp7_, "ibus-focus-in", (GCallback) ___lambda116__ibus_wayland_im_ibus_focus_in, self);
	application_m_ibus_focus_in_id = _tmp8_;
	_tmp9_ = application_m_wayland_im;
	_tmp10_ = g_signal_connect (_tmp9_, "ibus-focus-out", (GCallback) ___lambda117__ibus_wayland_im_ibus_focus_out, self);
	application_m_ibus_focus_out_id = _tmp10_;
	_tmp11_ = self->priv->m_panel;
	panel_load_settings (_tmp11_);
}

static void
application_bus_name_lost_cb (Application* self,
                              GDBusConnection* connection,
                              const gchar* sender_name,
                              const gchar* object_path,
                              const gchar* interface_name,
                              const gchar* signal_name,
                              GVariant* parameters)
{
	Panel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	g_debug ("application.vala:126: signal_name = %s", signal_name);
	_tmp0_ = self->priv->m_panel;
	panel_disconnect_signals (_tmp0_);
	if (application_m_realize_surface_id != ((gulong) 0)) {
		Panel* _tmp1_;
		_tmp1_ = self->priv->m_panel;
		g_signal_handler_disconnect (_tmp1_, application_m_realize_surface_id);
		application_m_realize_surface_id = (gulong) 0;
	}
	if (application_m_ibus_focus_in_id != ((gulong) 0)) {
		IBusWaylandIM* _tmp2_;
		_tmp2_ = application_m_wayland_im;
		g_signal_handler_disconnect (_tmp2_, application_m_ibus_focus_in_id);
		application_m_ibus_focus_in_id = (gulong) 0;
	}
	if (application_m_ibus_focus_out_id != ((gulong) 0)) {
		IBusWaylandIM* _tmp3_;
		_tmp3_ = application_m_wayland_im;
		g_signal_handler_disconnect (_tmp3_, application_m_ibus_focus_out_id);
		application_m_ibus_focus_out_id = (gulong) 0;
	}
	_g_object_unref0 (self->priv->m_panel);
	self->priv->m_panel = NULL;
}

static void
application_bus_disconnected (Application* self,
                              IBusBus* bus)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus != NULL);
	g_debug ("application.vala:148: connection is lost.");
	gtk_main_quit ();
}

static void
application_bus_connected (Application* self,
                           IBusBus* bus)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus != NULL);
	application_init (self);
}

static void
application_bus_global_shortcut_key_cb (Application* self,
                                        IBusBus* bus,
                                        guint8 type,
                                        guint keyval,
                                        guint keycode,
                                        guint state,
                                        gboolean is_backward)
{
	Panel* _tmp0_;
	IBusBusGlobalBindingType gtype = 0;
	Panel* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus != NULL);
	_tmp0_ = self->priv->m_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	if (application_m_verbose) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		FILE* _tmp3_;
		FILE* _tmp4_;
		if ((state & IBUS_RELEASE_MASK) != ((guint) 0)) {
			_tmp1_ = "FALSE";
		} else {
			_tmp1_ = "TRUE";
		}
		if (is_backward) {
			_tmp2_ = "TRUE";
		} else {
			_tmp2_ = "FALSE";
		}
		_tmp3_ = application_m_log;
		fprintf (_tmp3_, "Global shortcut key %u keyval %X keycode %u " "state %X pressed %s backward %s\n", type, keyval, keycode, state, _tmp1_, _tmp2_);
		_tmp4_ = application_m_log;
		fflush (_tmp4_);
	}
	gtype = (IBusBusGlobalBindingType) type;
	_tmp5_ = self->priv->m_panel;
	panel_set_global_shortcut_key_state (_tmp5_, gtype, keyval, keycode, state, is_backward);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
application_open_log (void)
{
	gchar* directory = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* path = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	FILE* _tmp9_;
	struct passwd* pw = NULL;
	struct passwd* _tmp10_;
	struct passwd* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp17_;
	GDateTime* now = NULL;
	GDateTime* _tmp19_;
	gint msec = 0;
	GDateTime* _tmp20_;
	FILE* _tmp21_;
	GDateTime* _tmp22_;
	GDateTime* _tmp23_;
	GDateTime* _tmp24_;
	FILE* _tmp25_;
	gboolean result;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "ibus", NULL);
	directory = _tmp1_;
	_tmp2_ = directory;
	g_return_val_if_fail (_tmp2_ != NULL, FALSE);
	errno = 0;
	_tmp3_ = directory;
	if (g_mkdir_with_parents (_tmp3_, 0700) != 0) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = directory;
		_tmp5_ = strerror (errno);
		g_warning ("application.vala:190: mkdir is failed in %s: %s", _tmp4_, _tmp5_);
		result = FALSE;
		_g_free0 (directory);
		return result;
	}
	_tmp6_ = directory;
	_tmp7_ = g_build_filename (_tmp6_, "wayland.log", NULL);
	path = _tmp7_;
	_tmp8_ = path;
	_tmp9_ = g_fopen (_tmp8_, "w");
	_fclose0 (application_m_log);
	application_m_log = _tmp9_;
	_tmp10_ = getpwuid (getuid ());
	pw = _tmp10_;
	_tmp11_ = pw;
	_tmp12_ = _tmp11_->pw_name;
	_tmp13_ = string_substring (_tmp12_, (glong) 0, (glong) 6);
	_g_free0 (application_m_user);
	application_m_user = _tmp13_;
	_tmp14_ = application_m_user;
	if (_tmp14_ == NULL) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = g_getenv ("USER");
		_tmp16_ = string_substring (_tmp15_, (glong) 0, (glong) 6);
		_g_free0 (application_m_user);
		application_m_user = _tmp16_;
	}
	_tmp17_ = application_m_user;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup ("UNKNOW");
		_g_free0 (application_m_user);
		application_m_user = _tmp18_;
	}
	_tmp19_ = g_date_time_new_now_local ();
	now = _tmp19_;
	_tmp20_ = now;
	msec = g_date_time_get_microsecond (_tmp20_) / 1000;
	_tmp21_ = application_m_log;
	_tmp22_ = now;
	_tmp23_ = now;
	_tmp24_ = now;
	fprintf (_tmp21_, "Start %02d:%02d:%02d:%06d\n", g_date_time_get_hour (_tmp22_), g_date_time_get_minute (_tmp23_), g_date_time_get_second (_tmp24_), msec);
	_tmp25_ = application_m_log;
	fflush (_tmp25_);
	result = TRUE;
	_g_date_time_unref0 (now);
	_g_free0 (path);
	_g_free0 (directory);
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
application_check_ps (void)
{
	gchar* standard_output = NULL;
	gchar* standard_error = NULL;
	gint wait_status = 0;
	gchar** lines = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint lines_length1;
	gint _lines_size_;
	FILE* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	FILE* _tmp20_;
	GError* _inner_error0_ = NULL;
	standard_output = NULL;
	standard_error = NULL;
	wait_status = 0;
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		g_spawn_command_line_sync ("ps -ef", &_tmp0_, &_tmp1_, &_tmp2_, &_inner_error0_);
		_g_free0 (standard_output);
		standard_output = _tmp0_;
		_g_free0 (standard_error);
		standard_error = _tmp1_;
		wait_status = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (standard_error);
			_g_free0 (standard_output);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		FILE* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = application_m_log;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = standard_error;
		fprintf (_tmp3_, "Failed ps %s: %s\n", _tmp5_, _tmp6_);
		_tmp7_ = application_m_log;
		fflush (_tmp7_);
		_g_error_free0 (e);
		_g_free0 (standard_error);
		_g_free0 (standard_output);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (standard_error);
		_g_free0 (standard_output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp8_ = standard_output;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "\n", -1);
	lines = _tmp10_;
	lines_length1 = _vala_array_length (_tmp9_);
	_lines_size_ = lines_length1;
	_tmp11_ = application_m_log;
	fprintf (_tmp11_, "ps -ef\n");
	_tmp12_ = lines;
	_tmp12__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp12_;
		line_collection_length1 = _tmp12__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp13_;
			gchar* line = NULL;
			_tmp13_ = g_strdup (line_collection[line_it]);
			line = _tmp13_;
			{
				gboolean _tmp14_ = FALSE;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = line;
				_tmp16_ = application_m_user;
				if (string_index_of (_tmp15_, _tmp16_, 0) >= 0) {
					const gchar* _tmp17_;
					_tmp17_ = line;
					_tmp14_ = string_index_of (_tmp17_, "wayland", 0) >= 0;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					FILE* _tmp18_;
					const gchar* _tmp19_;
					_tmp18_ = application_m_log;
					_tmp19_ = line;
					fprintf (_tmp18_, "  %s\n", _tmp19_);
				}
				_g_free0 (line);
			}
		}
	}
	_tmp20_ = application_m_log;
	fflush (_tmp20_);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (standard_error);
	_g_free0 (standard_output);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
application_run_ibus_daemon (void)
{
	gchar** args = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint args_length1;
	gint _args_size_;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	GPid child_pid = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = g_strdup ("ibus-daemon");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	args = _tmp1_;
	args_length1 = 1;
	_args_size_ = args_length1;
	_tmp2_ = application_m_daemon_args;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _vala_array_length (_tmp3_);
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			gchar* _tmp5_;
			gchar* arg = NULL;
			_tmp5_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp5_;
			{
				const gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp6_ = arg;
				_tmp7_ = g_strdup (_tmp6_);
				_vala_array_add1 (&args, &args_length1, &_args_size_, _tmp7_);
				_g_free0 (arg);
			}
		}
		arg_collection = (_vala_array_free (arg_collection, arg_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	child_pid = (GPid) 0;
	{
		gchar** _tmp8_;
		gint _tmp8__length1;
		GPid _tmp9_ = 0;
		_tmp8_ = args;
		_tmp8__length1 = args_length1;
		g_spawn_async (NULL, _tmp8_, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp9_, &_inner_error0_);
		child_pid = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp10_ = FALSE;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = application_m_log;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		fprintf (_tmp11_, "ibus-daemon error: %s\n", _tmp13_);
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("application.vala:247: %s\n", _tmp15_);
		result = FALSE;
		_g_error_free0 (e);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp16_ = FALSE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp16_;
	}
	result = TRUE;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda118_ (Block1Data* _data1_,
               IBusBus* bus)
{
	GMainLoop* _tmp0_;
	g_return_if_fail (bus != NULL);
	_tmp0_ = _data1_->loop;
	if (_tmp0_ != NULL) {
		GMainLoop* _tmp1_;
		_tmp1_ = _data1_->loop;
		g_main_loop_quit (_tmp1_);
	}
}

static void
____lambda118__ibus_bus_connected (IBusBus* _sender,
                                   gpointer self)
{
	___lambda118_ (self, _sender);
}

static void
application_make_wayland_im (void)
{
	Block1Data* _data1_;
	void* wl_display = NULL;
	gulong i = 0UL;
	gint _errno = 0;
	void* _tmp9_;
	IBusBus* _tmp13_;
	gboolean _tmp14_ = FALSE;
	IBusBus* _tmp15_;
	IBusBus* _tmp22_;
	IBusBus* _tmp25_;
	void* _tmp26_;
	FILE* _tmp27_;
	IBusWaylandIM* _tmp28_;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	if (binding_common_default_is_xdisplay ()) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_vala_assert (application_open_log (), "open_log()");
	wl_display = NULL;
	i = (gulong) 0;
	while (TRUE) {
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp0_;
		GdkDisplay* _tmp1_;
		GdkDisplay* _tmp2_;
		void* _tmp5_;
		gulong _tmp8_;
		_tmp0_ = gdk_display_get_default ();
		_tmp1_ = _g_object_ref0 (_tmp0_);
		display = _tmp1_;
		_tmp2_ = display;
		if (_tmp2_ != NULL) {
			GdkDisplay* _tmp3_;
			void* _tmp4_;
			_tmp3_ = display;
			_tmp4_ = gdk_wayland_display_get_wl_display (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gdk_wayland_display_get_type (), GdkWaylandDisplay));
			wl_display = _tmp4_;
		}
		_tmp5_ = wl_display;
		if (_tmp5_ != NULL) {
			_g_object_unref0 (display);
			break;
		}
		if (i == MAX_DISPLAY_IDLE_TIME) {
			_g_object_unref0 (display);
			break;
		}
		g_usleep (G_USEC_PER_SEC / SLEEP_DIV_PER_SEC);
		if (application_m_verbose) {
			FILE* _tmp6_;
			FILE* _tmp7_;
			_tmp6_ = application_m_log;
			fprintf (_tmp6_, "Spend %lu/%lu secs\n", i, SLEEP_DIV_PER_SEC);
			_tmp7_ = application_m_log;
			fflush (_tmp7_);
		}
		i = i + 1;
		_tmp8_ = i;
		_g_object_unref0 (display);
	}
	_errno = errno;
	if (application_m_verbose) {
		application_check_ps ();
	}
	_tmp9_ = wl_display;
	if (_tmp9_ == NULL) {
		FILE* _tmp10_;
		const gchar* _tmp11_;
		FILE* _tmp12_;
		_tmp10_ = application_m_log;
		_tmp11_ = strerror (_errno);
		fprintf (_tmp10_, "Failed to connect to Wayland server: %s\n", _tmp11_);
		_tmp12_ = application_m_log;
		fflush (_tmp12_);
		g_assert_not_reached ();
	}
	_tmp13_ = ibus_bus_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (bus);
	bus = _tmp13_;
	_data1_->loop = NULL;
	_tmp15_ = bus;
	if (!ibus_bus_is_connected (_tmp15_)) {
		_tmp14_ = application_m_exec_daemon;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gulong handler_id = 0UL;
		IBusBus* _tmp16_;
		gulong _tmp17_;
		IBusBus* _tmp21_;
		_tmp16_ = bus;
		_tmp17_ = g_signal_connect_data (_tmp16_, "connected", (GCallback) ____lambda118__ibus_bus_connected, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		handler_id = _tmp17_;
		if (application_run_ibus_daemon ()) {
			IBusBus* _tmp18_;
			_tmp18_ = bus;
			if (!ibus_bus_is_connected (_tmp18_)) {
				GMainLoop* _tmp19_;
				GMainLoop* _tmp20_;
				_tmp19_ = g_main_loop_new (NULL, FALSE);
				_g_main_loop_unref0 (_data1_->loop);
				_data1_->loop = _tmp19_;
				_tmp20_ = _data1_->loop;
				g_main_loop_run (_tmp20_);
			}
		}
		_tmp21_ = bus;
		g_signal_handler_disconnect ((GObject*) _tmp21_, handler_id);
	}
	_tmp22_ = bus;
	if (!ibus_bus_is_connected (_tmp22_)) {
		FILE* _tmp23_;
		FILE* _tmp24_;
		_tmp23_ = application_m_log;
		fprintf (_tmp23_, "Failed to connect to ibus-daemon\n");
		_tmp24_ = application_m_log;
		fflush (_tmp24_);
		g_assert_not_reached ();
	}
	_tmp25_ = bus;
	_tmp26_ = wl_display;
	_tmp27_ = application_m_log;
	_tmp28_ = ibus_wayland_im_new ("bus", _tmp25_, "wl_display", _tmp26_, "log", _tmp27_, "verbose", application_m_verbose, NULL);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (application_m_wayland_im);
	application_m_wayland_im = _tmp28_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
application_set_wayland_surface (Application* self,
                                 void* surface)
{
	IBusWaylandIM* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = application_m_wayland_im;
	ibus_wayland_im_set_surface (_tmp0_, surface);
}

void
application_show_version (void)
{
	const gchar* _tmp0_;
	_tmp0_ = prgname;
	g_print ("%s %s Wayland %s\n", _tmp0_, PACKAGE_VERSION, IBUS_WAYLAND_VERSION);
}

static void
application_main (gchar** argv,
                  gint argv_length1)
{
	GOptionEntry entries[6] = {0};
	GOptionEntry _tmp0_ = {0};
	GOptionEntry _tmp1_ = {0};
	GOptionEntry _tmp2_ = {0};
	GOptionEntry _tmp3_ = {0};
	GOptionEntry _tmp4_ = {0};
	GOptionEntry _tmp5_ = {0};
	GOptionEntry _tmp6_[6] = {0};
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* parameter_string = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GOptionContext* context = NULL;
	GOptionContext* _tmp11_;
	const gchar* _tmp12_;
	GOptionGroup* _tmp13_;
	const gchar* _tmp16_;
	Application* app = NULL;
	Application* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_unsetenv ("GDK_CORE_DEVICE_EVENTS");
	memset (&_tmp0_, 0, sizeof (GOptionEntry));
	_tmp0_.long_name = "version";
	_tmp0_.short_name = 'V';
	_tmp0_.flags = (gint) G_OPTION_FLAG_NO_ARG;
	_tmp0_.arg = G_OPTION_ARG_CALLBACK;
	_tmp0_.arg_data = (void*) application_show_version;
	_tmp0_.description = N_ ("Show version");
	_tmp0_.arg_description = NULL;
	memset (&_tmp1_, 0, sizeof (GOptionEntry));
	_tmp1_.long_name = "enable-wayland-im";
	_tmp1_.short_name = 'i';
	_tmp1_.flags = (gint) 0;
	_tmp1_.arg = G_OPTION_ARG_NONE;
	_tmp1_.arg_data = &application_m_enable_wayland_im;
	_tmp1_.description = N_ ("Connect Wayland input method protocol");
	_tmp1_.arg_description = NULL;
	memset (&_tmp2_, 0, sizeof (GOptionEntry));
	_tmp2_.long_name = "exec-daemon";
	_tmp2_.short_name = 'd';
	_tmp2_.flags = (gint) 0;
	_tmp2_.arg = G_OPTION_ARG_NONE;
	_tmp2_.arg_data = &application_m_exec_daemon;
	_tmp2_.description = N_ ("Execute ibus-daemon if it's not running");
	_tmp2_.arg_description = NULL;
	memset (&_tmp3_, 0, sizeof (GOptionEntry));
	_tmp3_.long_name = "daemon-args";
	_tmp3_.short_name = 'g';
	_tmp3_.flags = (gint) 0;
	_tmp3_.arg = G_OPTION_ARG_STRING;
	_tmp3_.arg_data = &application_m_daemon_args;
	_tmp3_.description = N_ ("ibus-daemon's arguments");
	_tmp3_.arg_description = NULL;
	memset (&_tmp4_, 0, sizeof (GOptionEntry));
	_tmp4_.long_name = "verbose";
	_tmp4_.short_name = 'v';
	_tmp4_.flags = (gint) 0;
	_tmp4_.arg = G_OPTION_ARG_NONE;
	_tmp4_.arg_data = &application_m_verbose;
	_tmp4_.description = N_ ("Verbose logging");
	_tmp4_.arg_description = NULL;
	memset (&_tmp5_, 0, sizeof (GOptionEntry));
	_tmp5_.long_name = NULL;
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	memcpy (entries, _tmp6_, 6 * sizeof (GOptionEntry));
	_tmp7_ = argv[0];
	_tmp8_ = g_path_get_basename (_tmp7_);
	_g_free0 (prgname);
	prgname = _tmp8_;
	_tmp9_ = prgname;
	_tmp10_ = g_strdup_printf ("- %s", _tmp9_);
	parameter_string = _tmp10_;
	_tmp11_ = g_option_context_new (parameter_string);
	context = _tmp11_;
	_tmp12_ = prgname;
	g_option_context_add_main_entries (context, entries, _tmp12_);
	_tmp13_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (context, _tmp13_);
	{
		g_option_context_parse (context, (gint*) (&argv_length1), &argv, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (context);
			_g_free0 (parameter_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("application.vala:365: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_option_context_free0 (context);
		_g_free0 (parameter_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	ibus_init ();
	_tmp16_ = application_m_daemon_args;
	if (_tmp16_ == NULL) {
		gchar* _tmp17_;
		_tmp17_ = g_strdup ("--xim");
		_g_free0 (application_m_daemon_args);
		application_m_daemon_args = _tmp17_;
	}
	if (application_m_enable_wayland_im) {
		application_make_wayland_im ();
	}
	_tmp18_ = application_new ();
	app = _tmp18_;
	application_run (app);
	_application_unref0 (app);
	_g_option_context_free0 (context);
	_g_free0 (parameter_string);
}

int
main (int argc,
      char ** argv)
{
	application_main (argv, argc);
	return 0;
}

static void
value_application_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_application_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		application_unref (value->data[0].v_pointer);
	}
}

static void
value_application_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = application_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_application_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_application_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Application * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = application_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_application_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	Application ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = application_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_application (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecApplication* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_APPLICATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_application (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_application (GValue* value,
                       gpointer v_object)
{
	Application * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APPLICATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		application_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		application_unref (old);
	}
}

void
value_take_application (GValue* value,
                        gpointer v_object)
{
	Application * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APPLICATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		application_unref (old);
	}
}

static void
application_class_init (ApplicationClass * klass,
                        gpointer klass_data)
{
	application_parent_class = g_type_class_peek_parent (klass);
	((ApplicationClass *) klass)->finalize = application_finalize;
	g_type_class_adjust_private_offset (klass, &Application_private_offset);
}

static void
application_instance_init (Application * self,
                           gpointer klass)
{
	self->priv = application_get_instance_private (self);
	self->ref_count = 1;
}

static void
application_finalize (Application * obj)
{
	Application * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION, Application);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->m_panel);
}

static GType
application_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_application_init, value_application_free_value, value_application_copy_value, value_application_peek_pointer, "p", value_application_collect_value, "p", value_application_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType application_type_id;
	application_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Application", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Application_private_offset = g_type_add_instance_private (application_type_id, sizeof (ApplicationPrivate));
	return application_type_id;
}

GType
application_get_type (void)
{
	static volatile gsize application_type_id__once = 0;
	if (g_once_init_enter (&application_type_id__once)) {
		GType application_type_id;
		application_type_id = application_get_type_once ();
		g_once_init_leave (&application_type_id__once, application_type_id);
	}
	return application_type_id__once;
}

gpointer
application_ref (gpointer instance)
{
	Application * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
application_unref (gpointer instance)
{
	Application * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		APPLICATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

