#!/bin/sh

set -e

DEB_VERSION_UPSTREAM=$(dpkg-parsechangelog -SVersion | sed -e 's/-[^-]*$//' -e 's/^[0-9]*://')
GEM_TEMP=$(mktemp -q -d rubygems.XXXXXX)

cd "$GEM_TEMP"
mkdir info gems

awk '/^default_gems =/{flag=1;next}/^\s*#/{next}/^]/{flag=0}flag' ../lib/pom.rb | sed "s/\s\+\['\(.*\)', '\([0-9a-z\.]\+\)'.*/\1 \2/" \
| while read -r gem ver; do
    echo "downloading ${gem}-${ver}"
    url=""
    if wget -q "https://rubygems.org/info/${gem}" -O "info/${gem}"; then
        # check if we have a java platform version available
        if grep -o "^[^-]\S\+" "info/${gem}" | grep -qF "${ver}-java"; then
            url="https://rubygems.org/gems/${gem}-${ver}-java.gem"
        elif grep -o "^[^-]\S\+" "info/${gem}" | grep -qF "${ver}"; then
            url="https://rubygems.org/gems/${gem}-${ver}.gem"
        fi
    fi
    if [ -z "$url" ]; then
        # not on rubygems.org, so try to get from maven.org
        url="https://repo1.maven.org/maven2/rubygems/${gem}/${ver}/${gem}-${ver}.gem"
    fi
    echo "  from ${url}"
    mkdir -p "gems/${gem}/${ver}"
    wget -q "$url" -O "gems/${gem}/${ver}/${gem}-${ver}.gem"
done

# create the tarballs
cd "gems"
tar caf "../../../jruby_${DEB_VERSION_UPSTREAM}.orig-rubygems.tar.xz" .

cd ../..
rm -rf "$GEM_TEMP"
