/*
 * Copyright (c) 2013, Giulio Paci <giuliopaci@gmail.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *	* Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 *
 *	* Redistributions in binary form must reproduce the above
 *	  copyright notice, this list of conditions and the following
 *	  disclaimer in the documentation and/or other materials provided
 *	  with the distribution.
 *
 *	* Neither the name of the Massachusetts Institute of Technology
 *	  nor the names of its contributors may be used to endorse or
 *	  promote products derived from this software without specific
 *	  prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 **/

#define setulb_f77 F77_FUNC (setulb, SETULB)

void setulb_f77(int *n, int *m, double *x, double *l, double *u, int *nbd,
		double *f, double *g, double *factr, double *pgtol,
		double *wa, int *iwa, char *task, int *iprint,
		char *csave, int *lsave, int *isave, double *dsave);


#define lbfgs_f77 F77_FUNC (lbfgs, LBFGS)

void lbfgs_f77(int *n, int *m, double *x, double *f, double *g,
	       int *diagco, double *diag, int *iprint,
	       double *eps, double *xtol, double *w, int *iflag);


void mitlm_setulb(int *n, int *m, double *x, double *l, double *u, int *nbd,
		  double *f, double *g, double *factr, double *pgtol,
		  double *wa, int *iwa, char *task, int *iprint,
		  char *csave, int *lsave, int *isave, double *dsave)
{
	setulb_f77(n, m, x, l, u, nbd, f, g, factr, pgtol, wa,
			 iwa, task, iprint,csave, lsave, isave, dsave);
}

void mitlm_lbfgs(int *n, int *m, double *x, double *f, double *g,
		 int *diagco, double *diag, int *iprint,
		 double *eps, double *xtol, double *w, int *iflag)
{
	lbfgs_f77(n, m, x, f, g, diagco, diag, iprint, eps,
			xtol, w, iflag);
}

