/*
  Simple DirectMedia Layer
  Copyright (C) 1997-2024 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/

/*
 * This file #includes the proper SDL3 headers, but #defines a whole
 *  bunch of stuff so we don't conflict with symbols we plan to offer with
 *  the SDL2 signatures. Ugly business.
 */

#ifndef INCL_SDL3_INCLUDE_WRAPPER_H
#define INCL_SDL3_INCLUDE_WRAPPER_H

#define SDL_SLOW_MEMCPY
#define SDL_SLOW_MEMMOVE
#define SDL_SLOW_MEMSET

#define SDL_ThreadID SDL3_ThreadID /* avoid clash with SDL_ThreadID() of SDL2 */

#define SDL_AddEventWatch IGNORE_THIS_VERSION_OF_SDL_AddEventWatch
#define SDL_AddGamepadMapping IGNORE_THIS_VERSION_OF_SDL_AddGamepadMapping
#define SDL_AddGamepadMappingsFromRW IGNORE_THIS_VERSION_OF_SDL_AddGamepadMappingsFromRW
#define SDL_AddHintCallback IGNORE_THIS_VERSION_OF_SDL_AddHintCallback
#define SDL_AddTimer IGNORE_THIS_VERSION_OF_SDL_AddTimer
#define SDL_AndroidBackButton IGNORE_THIS_VERSION_OF_SDL_AndroidBackButton
#define SDL_AndroidGetActivity IGNORE_THIS_VERSION_OF_SDL_AndroidGetActivity
#define SDL_AndroidGetExternalStoragePath IGNORE_THIS_VERSION_OF_SDL_AndroidGetExternalStoragePath
#define SDL_AndroidGetExternalStorageState IGNORE_THIS_VERSION_OF_SDL_AndroidGetExternalStorageState
#define SDL_AndroidGetInternalStoragePath IGNORE_THIS_VERSION_OF_SDL_AndroidGetInternalStoragePath
#define SDL_AndroidGetJNIEnv IGNORE_THIS_VERSION_OF_SDL_AndroidGetJNIEnv
#define SDL_AndroidRequestPermission IGNORE_THIS_VERSION_OF_SDL_AndroidRequestPermission
#define SDL_AndroidSendMessage IGNORE_THIS_VERSION_OF_SDL_AndroidSendMessage
#define SDL_AndroidShowToast IGNORE_THIS_VERSION_OF_SDL_AndroidShowToast
#define SDL_AtomicAdd IGNORE_THIS_VERSION_OF_SDL_AtomicAdd
#define SDL_AtomicCompareAndSwap IGNORE_THIS_VERSION_OF_SDL_AtomicCompareAndSwap
#define SDL_AtomicCompareAndSwapPointer IGNORE_THIS_VERSION_OF_SDL_AtomicCompareAndSwapPointer
#define SDL_AtomicGet IGNORE_THIS_VERSION_OF_SDL_AtomicGet
#define SDL_AtomicGetPtr IGNORE_THIS_VERSION_OF_SDL_AtomicGetPtr
#define SDL_LockSpinlock IGNORE_THIS_VERSION_OF_SDL_LockSpinlock
#define SDL_AtomicSet IGNORE_THIS_VERSION_OF_SDL_AtomicSet
#define SDL_AtomicSetPtr IGNORE_THIS_VERSION_OF_SDL_AtomicSetPtr
#define SDL_TryLockSpinlock IGNORE_THIS_VERSION_OF_SDL_TryLockSpinlock
#define SDL_UnlockSpinlock IGNORE_THIS_VERSION_OF_SDL_UnlockSpinlock
#define SDL_AttachVirtualJoystick IGNORE_THIS_VERSION_OF_SDL_AttachVirtualJoystick
#define SDL_AttachVirtualJoystickEx IGNORE_THIS_VERSION_OF_SDL_AttachVirtualJoystickEx
#define SDL_BlitSurface IGNORE_THIS_VERSION_OF_SDL_BlitSurface
#define SDL_BlitSurfaceScaled IGNORE_THIS_VERSION_OF_SDL_BlitSurfaceScaled
#define SDL_BlitSurfaceUnchecked IGNORE_THIS_VERSION_OF_SDL_BlitSurfaceUnchecked
#define SDL_BlitSurfaceUncheckedScaled IGNORE_THIS_VERSION_OF_SDL_BlitSurfaceUncheckedScaled
#define SDL_BroadcastCondition IGNORE_THIS_VERSION_OF_SDL_BroadcastCondition
#define SDL_CaptureMouse IGNORE_THIS_VERSION_OF_SDL_CaptureMouse
#define SDL_CleanupTLS IGNORE_THIS_VERSION_OF_SDL_CleanupTLS
#define SDL_ClearComposition IGNORE_THIS_VERSION_OF_SDL_ClearComposition
#define SDL_ClearError IGNORE_THIS_VERSION_OF_SDL_ClearError
#define SDL_ClearHints IGNORE_THIS_VERSION_OF_SDL_ClearHints
#define SDL_CloseGamepad IGNORE_THIS_VERSION_OF_SDL_CloseGamepad
#define SDL_CloseJoystick IGNORE_THIS_VERSION_OF_SDL_CloseJoystick
#define SDL_CloseSensor IGNORE_THIS_VERSION_OF_SDL_CloseSensor
#define SDL_ComposeCustomBlendMode IGNORE_THIS_VERSION_OF_SDL_ComposeCustomBlendMode
#define SDL_ConvertEventToRenderCoordinates IGNORE_THIS_VERSION_OF_SDL_ConvertEventToRenderCoordinates
#define SDL_ConvertPixels IGNORE_THIS_VERSION_OF_SDL_ConvertPixels
#define SDL_ConvertSurface IGNORE_THIS_VERSION_OF_SDL_ConvertSurface
#define SDL_ConvertSurfaceFormat IGNORE_THIS_VERSION_OF_SDL_ConvertSurfaceFormat
#define SDL_CreateColorCursor IGNORE_THIS_VERSION_OF_SDL_CreateColorCursor
#define SDL_CreateCondition IGNORE_THIS_VERSION_OF_SDL_CreateCondition
#define SDL_CreateCursor IGNORE_THIS_VERSION_OF_SDL_CreateCursor
#define SDL_CreateMutex IGNORE_THIS_VERSION_OF_SDL_CreateMutex
#define SDL_CreatePalette IGNORE_THIS_VERSION_OF_SDL_CreatePalette
#define SDL_CreatePixelFormat IGNORE_THIS_VERSION_OF_SDL_CreatePixelFormat
#define SDL_CreatePopupWindow IGNORE_THIS_VERSION_OF_SDL_CreatePopupWindow
#define SDL_CreateRW IGNORE_THIS_VERSION_OF_SDL_CreateRW
#define SDL_CreateRWLock IGNORE_THIS_VERSION_OF_SDL_CreateRWLock
#define SDL_CreateRenderer IGNORE_THIS_VERSION_OF_SDL_CreateRenderer
#define SDL_CreateSemaphore IGNORE_THIS_VERSION_OF_SDL_CreateSemaphore
#define SDL_CreateSoftwareRenderer IGNORE_THIS_VERSION_OF_SDL_CreateSoftwareRenderer
#define SDL_CreateSurface IGNORE_THIS_VERSION_OF_SDL_CreateSurface
#define SDL_CreateSurfaceFrom IGNORE_THIS_VERSION_OF_SDL_CreateSurfaceFrom
#define SDL_CreateSystemCursor IGNORE_THIS_VERSION_OF_SDL_CreateSystemCursor
#define SDL_CreateTLS IGNORE_THIS_VERSION_OF_SDL_CreateTLS
#define SDL_CreateTexture IGNORE_THIS_VERSION_OF_SDL_CreateTexture
#define SDL_CreateTextureFromSurface IGNORE_THIS_VERSION_OF_SDL_CreateTextureFromSurface
#define SDL_CreateThread IGNORE_THIS_VERSION_OF_SDL_CreateThread
#define SDL_CreateThreadWithStackSize IGNORE_THIS_VERSION_OF_SDL_CreateThreadWithStackSize
#define SDL_CreateWindow IGNORE_THIS_VERSION_OF_SDL_CreateWindow
#define SDL_CreateWindowAndRenderer IGNORE_THIS_VERSION_OF_SDL_CreateWindowAndRenderer
#define SDL_CreateWindowWithProperties IGNORE_THIS_VERSION_OF_SDL_CreateWindowWithProperties
#define SDL_CursorVisible IGNORE_THIS_VERSION_OF_SDL_CursorVisible
#define SDL_DXGIGetOutputInfo IGNORE_THIS_VERSION_OF_SDL_DXGIGetOutputInfo
#define SDL_DelEventWatch IGNORE_THIS_VERSION_OF_SDL_DelEventWatch
#define SDL_DelHintCallback IGNORE_THIS_VERSION_OF_SDL_DelHintCallback
#define SDL_Delay IGNORE_THIS_VERSION_OF_SDL_Delay
#define SDL_DelayNS IGNORE_THIS_VERSION_OF_SDL_DelayNS
#define SDL_DestroyCondition IGNORE_THIS_VERSION_OF_SDL_DestroyCondition
#define SDL_DestroyCursor IGNORE_THIS_VERSION_OF_SDL_DestroyCursor
#define SDL_DestroyMutex IGNORE_THIS_VERSION_OF_SDL_DestroyMutex
#define SDL_DestroyPalette IGNORE_THIS_VERSION_OF_SDL_DestroyPalette
#define SDL_DestroyPixelFormat IGNORE_THIS_VERSION_OF_SDL_DestroyPixelFormat
#define SDL_DestroyRW IGNORE_THIS_VERSION_OF_SDL_DestroyRW
#define SDL_DestroyRWLock IGNORE_THIS_VERSION_OF_SDL_DestroyRWLock
#define SDL_DestroyRenderer IGNORE_THIS_VERSION_OF_SDL_DestroyRenderer
#define SDL_DestroySemaphore IGNORE_THIS_VERSION_OF_SDL_DestroySemaphore
#define SDL_DestroySurface IGNORE_THIS_VERSION_OF_SDL_DestroySurface
#define SDL_DestroyTexture IGNORE_THIS_VERSION_OF_SDL_DestroyTexture
#define SDL_DestroyWindow IGNORE_THIS_VERSION_OF_SDL_DestroyWindow
#define SDL_DestroyWindowSurface IGNORE_THIS_VERSION_OF_SDL_DestroyWindowSurface
#define SDL_DetachThread IGNORE_THIS_VERSION_OF_SDL_DetachThread
#define SDL_DetachVirtualJoystick IGNORE_THIS_VERSION_OF_SDL_DetachVirtualJoystick
#define SDL_Direct3D9GetAdapterIndex IGNORE_THIS_VERSION_OF_SDL_Direct3D9GetAdapterIndex
#define SDL_DisableScreenSaver IGNORE_THIS_VERSION_OF_SDL_DisableScreenSaver
#define SDL_DuplicateSurface IGNORE_THIS_VERSION_OF_SDL_DuplicateSurface
#define SDL_EGL_GetCurrentEGLConfig IGNORE_THIS_VERSION_OF_SDL_EGL_GetCurrentEGLConfig
#define SDL_EGL_GetCurrentEGLDisplay IGNORE_THIS_VERSION_OF_SDL_EGL_GetCurrentEGLDisplay
#define SDL_EGL_GetProcAddress IGNORE_THIS_VERSION_OF_SDL_EGL_GetProcAddress
#define SDL_EGL_GetWindowEGLSurface IGNORE_THIS_VERSION_OF_SDL_EGL_GetWindowEGLSurface
#define SDL_EGL_SetEGLAttributeCallbacks IGNORE_THIS_VERSION_OF_SDL_EGL_SetEGLAttributeCallbacks
#define SDL_EnableScreenSaver IGNORE_THIS_VERSION_OF_SDL_EnableScreenSaver
#define SDL_Error IGNORE_THIS_VERSION_OF_SDL_Error
#define SDL_EventEnabled IGNORE_THIS_VERSION_OF_SDL_EventEnabled
#define SDL_FillSurfaceRect IGNORE_THIS_VERSION_OF_SDL_FillSurfaceRect
#define SDL_FillSurfaceRects IGNORE_THIS_VERSION_OF_SDL_FillSurfaceRects
#define SDL_FilterEvents IGNORE_THIS_VERSION_OF_SDL_FilterEvents
#define SDL_FlashWindow IGNORE_THIS_VERSION_OF_SDL_FlashWindow
#define SDL_FlushEvent IGNORE_THIS_VERSION_OF_SDL_FlushEvent
#define SDL_FlushEvents IGNORE_THIS_VERSION_OF_SDL_FlushEvents
#define SDL_FlushRenderer IGNORE_THIS_VERSION_OF_SDL_FlushRenderer
#define SDL_GDKGetTaskQueue IGNORE_THIS_VERSION_OF_SDL_GDKGetTaskQueue
#define SDL_GDKSuspendComplete IGNORE_THIS_VERSION_OF_SDL_GDKSuspendComplete
#define SDL_GL_CreateContext IGNORE_THIS_VERSION_OF_SDL_GL_CreateContext
#define SDL_GL_DeleteContext IGNORE_THIS_VERSION_OF_SDL_GL_DeleteContext
#define SDL_GL_ExtensionSupported IGNORE_THIS_VERSION_OF_SDL_GL_ExtensionSupported
#define SDL_GL_GetAttribute IGNORE_THIS_VERSION_OF_SDL_GL_GetAttribute
#define SDL_GL_GetCurrentContext IGNORE_THIS_VERSION_OF_SDL_GL_GetCurrentContext
#define SDL_GL_GetCurrentWindow IGNORE_THIS_VERSION_OF_SDL_GL_GetCurrentWindow
#define SDL_GL_GetProcAddress IGNORE_THIS_VERSION_OF_SDL_GL_GetProcAddress
#define SDL_GL_GetSwapInterval IGNORE_THIS_VERSION_OF_SDL_GL_GetSwapInterval
#define SDL_GL_LoadLibrary IGNORE_THIS_VERSION_OF_SDL_GL_LoadLibrary
#define SDL_GL_MakeCurrent IGNORE_THIS_VERSION_OF_SDL_GL_MakeCurrent
#define SDL_GL_ResetAttributes IGNORE_THIS_VERSION_OF_SDL_GL_ResetAttributes
#define SDL_GL_SetAttribute IGNORE_THIS_VERSION_OF_SDL_GL_SetAttribute
#define SDL_GL_SetSwapInterval IGNORE_THIS_VERSION_OF_SDL_GL_SetSwapInterval
#define SDL_GL_SwapWindow IGNORE_THIS_VERSION_OF_SDL_GL_SwapWindow
#define SDL_GL_UnloadLibrary IGNORE_THIS_VERSION_OF_SDL_GL_UnloadLibrary
#define SDL_GUIDFromString IGNORE_THIS_VERSION_OF_SDL_GUIDFromString
#define SDL_GUIDToString IGNORE_THIS_VERSION_OF_SDL_GUIDToString
#define SDL_GamepadConnected IGNORE_THIS_VERSION_OF_SDL_GamepadConnected
#define SDL_GamepadEventsEnabled IGNORE_THIS_VERSION_OF_SDL_GamepadEventsEnabled
#define SDL_GamepadHasAxis IGNORE_THIS_VERSION_OF_SDL_GamepadHasAxis
#define SDL_GamepadHasButton IGNORE_THIS_VERSION_OF_SDL_GamepadHasButton
#define SDL_GamepadHasSensor IGNORE_THIS_VERSION_OF_SDL_GamepadHasSensor
#define SDL_GamepadSensorEnabled IGNORE_THIS_VERSION_OF_SDL_GamepadSensorEnabled
#define SDL_GetAndroidSDKVersion IGNORE_THIS_VERSION_OF_SDL_GetAndroidSDKVersion
#define SDL_GetAssertionHandler IGNORE_THIS_VERSION_OF_SDL_GetAssertionHandler
#define SDL_GetAssertionReport IGNORE_THIS_VERSION_OF_SDL_GetAssertionReport
#define SDL_GetBasePath IGNORE_THIS_VERSION_OF_SDL_GetBasePath
#define SDL_GetCPUCacheLineSize IGNORE_THIS_VERSION_OF_SDL_GetCPUCacheLineSize
#define SDL_GetCPUCount IGNORE_THIS_VERSION_OF_SDL_GetCPUCount
#define SDL_GetClipboardData IGNORE_THIS_VERSION_OF_SDL_GetClipboardData
#define SDL_GetClipboardText IGNORE_THIS_VERSION_OF_SDL_GetClipboardText
#define SDL_GetClosestFullscreenDisplayMode IGNORE_THIS_VERSION_OF_SDL_GetClosestFullscreenDisplayMode
#define SDL_GetCurrentDisplayMode IGNORE_THIS_VERSION_OF_SDL_GetCurrentDisplayMode
#define SDL_GetCurrentDisplayOrientation IGNORE_THIS_VERSION_OF_SDL_GetCurrentDisplayOrientation
#define SDL_GetCurrentRenderOutputSize IGNORE_THIS_VERSION_OF_SDL_GetCurrentRenderOutputSize
#define SDL_GetCurrentVideoDriver IGNORE_THIS_VERSION_OF_SDL_GetCurrentVideoDriver
#define SDL_GetCursor IGNORE_THIS_VERSION_OF_SDL_GetCursor
#define SDL_GetDefaultAssertionHandler IGNORE_THIS_VERSION_OF_SDL_GetDefaultAssertionHandler
#define SDL_GetDefaultCursor IGNORE_THIS_VERSION_OF_SDL_GetDefaultCursor
#define SDL_GetDesktopDisplayMode IGNORE_THIS_VERSION_OF_SDL_GetDesktopDisplayMode
#define SDL_GetDisplayBounds IGNORE_THIS_VERSION_OF_SDL_GetDisplayBounds
#define SDL_GetDisplayContentScale IGNORE_THIS_VERSION_OF_SDL_GetDisplayContentScale
#define SDL_GetDisplayForPoint IGNORE_THIS_VERSION_OF_SDL_GetDisplayForPoint
#define SDL_GetDisplayForRect IGNORE_THIS_VERSION_OF_SDL_GetDisplayForRect
#define SDL_GetDisplayForWindow IGNORE_THIS_VERSION_OF_SDL_GetDisplayForWindow
#define SDL_GetDisplayName IGNORE_THIS_VERSION_OF_SDL_GetDisplayName
#define SDL_GetDisplayUsableBounds IGNORE_THIS_VERSION_OF_SDL_GetDisplayUsableBounds
#define SDL_GetDisplays IGNORE_THIS_VERSION_OF_SDL_GetDisplays
#define SDL_GetError IGNORE_THIS_VERSION_OF_SDL_GetError
#define SDL_GetEventFilter IGNORE_THIS_VERSION_OF_SDL_GetEventFilter
#define SDL_GetFullscreenDisplayModes IGNORE_THIS_VERSION_OF_SDL_GetFullscreenDisplayModes
#define SDL_GetGamepadAppleSFSymbolsNameForAxis IGNORE_THIS_VERSION_OF_SDL_GetGamepadAppleSFSymbolsNameForAxis
#define SDL_GetGamepadAppleSFSymbolsNameForButton IGNORE_THIS_VERSION_OF_SDL_GetGamepadAppleSFSymbolsNameForButton
#define SDL_GetGamepadAxis IGNORE_THIS_VERSION_OF_SDL_GetGamepadAxis
#define SDL_GetGamepadAxisFromString IGNORE_THIS_VERSION_OF_SDL_GetGamepadAxisFromString
#define SDL_GetGamepadBindings IGNORE_THIS_VERSION_OF_SDL_GetGamepadBindings
#define SDL_GetGamepadButton IGNORE_THIS_VERSION_OF_SDL_GetGamepadButton
#define SDL_GetGamepadButtonFromString IGNORE_THIS_VERSION_OF_SDL_GetGamepadButtonFromString
#define SDL_GetGamepadFirmwareVersion IGNORE_THIS_VERSION_OF_SDL_GetGamepadFirmwareVersion
#define SDL_GetGamepadFromInstanceID IGNORE_THIS_VERSION_OF_SDL_GetGamepadFromInstanceID
#define SDL_GetGamepadFromPlayerIndex IGNORE_THIS_VERSION_OF_SDL_GetGamepadFromPlayerIndex
#define SDL_GetGamepadInstanceGUID IGNORE_THIS_VERSION_OF_SDL_GetGamepadInstanceGUID
#define SDL_GetGamepadInstanceMapping IGNORE_THIS_VERSION_OF_SDL_GetGamepadInstanceMapping
#define SDL_GetGamepadInstanceName IGNORE_THIS_VERSION_OF_SDL_GetGamepadInstanceName
#define SDL_GetGamepadInstancePath IGNORE_THIS_VERSION_OF_SDL_GetGamepadInstancePath
#define SDL_GetGamepadInstancePlayerIndex IGNORE_THIS_VERSION_OF_SDL_GetGamepadInstancePlayerIndex
#define SDL_GetGamepadInstanceProduct IGNORE_THIS_VERSION_OF_SDL_GetGamepadInstanceProduct
#define SDL_GetGamepadInstanceProductVersion IGNORE_THIS_VERSION_OF_SDL_GetGamepadInstanceProductVersion
#define SDL_GetGamepadInstanceType IGNORE_THIS_VERSION_OF_SDL_GetGamepadInstanceType
#define SDL_GetGamepadInstanceVendor IGNORE_THIS_VERSION_OF_SDL_GetGamepadInstanceVendor
#define SDL_GetGamepadJoystick IGNORE_THIS_VERSION_OF_SDL_GetGamepadJoystick
#define SDL_GetGamepadMapping IGNORE_THIS_VERSION_OF_SDL_GetGamepadMapping
#define SDL_GetGamepadMappingForGUID IGNORE_THIS_VERSION_OF_SDL_GetGamepadMappingForGUID
#define SDL_GetGamepadName IGNORE_THIS_VERSION_OF_SDL_GetGamepadName
#define SDL_GetGamepadPath IGNORE_THIS_VERSION_OF_SDL_GetGamepadPath
#define SDL_GetGamepadPlayerIndex IGNORE_THIS_VERSION_OF_SDL_GetGamepadPlayerIndex
#define SDL_GetGamepadProduct IGNORE_THIS_VERSION_OF_SDL_GetGamepadProduct
#define SDL_GetGamepadProductVersion IGNORE_THIS_VERSION_OF_SDL_GetGamepadProductVersion
#define SDL_GetGamepadSensorData IGNORE_THIS_VERSION_OF_SDL_GetGamepadSensorData
#define SDL_GetGamepadSensorDataRate IGNORE_THIS_VERSION_OF_SDL_GetGamepadSensorDataRate
#define SDL_GetGamepadSerial IGNORE_THIS_VERSION_OF_SDL_GetGamepadSerial
#define SDL_GetGamepadStringForAxis IGNORE_THIS_VERSION_OF_SDL_GetGamepadStringForAxis
#define SDL_GetGamepadStringForButton IGNORE_THIS_VERSION_OF_SDL_GetGamepadStringForButton
#define SDL_GetGamepadTouchpadFinger IGNORE_THIS_VERSION_OF_SDL_GetGamepadTouchpadFinger
#define SDL_GetGamepadType IGNORE_THIS_VERSION_OF_SDL_GetGamepadType
#define SDL_GetGamepadVendor IGNORE_THIS_VERSION_OF_SDL_GetGamepadVendor
#define SDL_GetGamepads IGNORE_THIS_VERSION_OF_SDL_GetGamepads
#define SDL_GetGlobalMouseState IGNORE_THIS_VERSION_OF_SDL_GetGlobalMouseState
#define SDL_GetGrabbedWindow IGNORE_THIS_VERSION_OF_SDL_GetGrabbedWindow
#define SDL_GetHint IGNORE_THIS_VERSION_OF_SDL_GetHint
#define SDL_GetHintBoolean IGNORE_THIS_VERSION_OF_SDL_GetHintBoolean
#define SDL_GetJoystickAxis IGNORE_THIS_VERSION_OF_SDL_GetJoystickAxis
#define SDL_GetJoystickAxisInitialState IGNORE_THIS_VERSION_OF_SDL_GetJoystickAxisInitialState
#define SDL_GetJoystickButton IGNORE_THIS_VERSION_OF_SDL_GetJoystickButton
#define SDL_GetJoystickFirmwareVersion IGNORE_THIS_VERSION_OF_SDL_GetJoystickFirmwareVersion
#define SDL_GetJoystickFromInstanceID IGNORE_THIS_VERSION_OF_SDL_GetJoystickFromInstanceID
#define SDL_GetJoystickFromPlayerIndex IGNORE_THIS_VERSION_OF_SDL_GetJoystickFromPlayerIndex
#define SDL_GetJoystickGUID IGNORE_THIS_VERSION_OF_SDL_GetJoystickGUID
#define SDL_GetJoystickGUIDFromString IGNORE_THIS_VERSION_OF_SDL_GetJoystickGUIDFromString
#define SDL_GetJoystickGUIDInfo IGNORE_THIS_VERSION_OF_SDL_GetJoystickGUIDInfo
#define SDL_GetJoystickGUIDString IGNORE_THIS_VERSION_OF_SDL_GetJoystickGUIDString
#define SDL_GetJoystickHat IGNORE_THIS_VERSION_OF_SDL_GetJoystickHat
#define SDL_GetJoystickInstanceGUID IGNORE_THIS_VERSION_OF_SDL_GetJoystickInstanceGUID
#define SDL_GetJoystickInstanceID IGNORE_THIS_VERSION_OF_SDL_GetJoystickInstanceID
#define SDL_GetJoystickInstanceName IGNORE_THIS_VERSION_OF_SDL_GetJoystickInstanceName
#define SDL_GetJoystickInstancePath IGNORE_THIS_VERSION_OF_SDL_GetJoystickInstancePath
#define SDL_GetJoystickInstancePlayerIndex IGNORE_THIS_VERSION_OF_SDL_GetJoystickInstancePlayerIndex
#define SDL_GetJoystickInstanceProduct IGNORE_THIS_VERSION_OF_SDL_GetJoystickInstanceProduct
#define SDL_GetJoystickInstanceProductVersion IGNORE_THIS_VERSION_OF_SDL_GetJoystickInstanceProductVersion
#define SDL_GetJoystickInstanceType IGNORE_THIS_VERSION_OF_SDL_GetJoystickInstanceType
#define SDL_GetJoystickInstanceVendor IGNORE_THIS_VERSION_OF_SDL_GetJoystickInstanceVendor
#define SDL_GetJoystickName IGNORE_THIS_VERSION_OF_SDL_GetJoystickName
#define SDL_GetJoystickPath IGNORE_THIS_VERSION_OF_SDL_GetJoystickPath
#define SDL_GetJoystickPlayerIndex IGNORE_THIS_VERSION_OF_SDL_GetJoystickPlayerIndex
#define SDL_GetJoystickPowerLevel IGNORE_THIS_VERSION_OF_SDL_GetJoystickPowerLevel
#define SDL_GetJoystickProduct IGNORE_THIS_VERSION_OF_SDL_GetJoystickProduct
#define SDL_GetJoystickProductVersion IGNORE_THIS_VERSION_OF_SDL_GetJoystickProductVersion
#define SDL_GetJoystickSerial IGNORE_THIS_VERSION_OF_SDL_GetJoystickSerial
#define SDL_GetJoystickType IGNORE_THIS_VERSION_OF_SDL_GetJoystickType
#define SDL_GetJoystickVendor IGNORE_THIS_VERSION_OF_SDL_GetJoystickVendor
#define SDL_GetJoysticks IGNORE_THIS_VERSION_OF_SDL_GetJoysticks
#define SDL_GetKeyFromName IGNORE_THIS_VERSION_OF_SDL_GetKeyFromName
#define SDL_GetKeyFromScancode IGNORE_THIS_VERSION_OF_SDL_GetKeyFromScancode
#define SDL_GetKeyName IGNORE_THIS_VERSION_OF_SDL_GetKeyName
#define SDL_GetKeyboardFocus IGNORE_THIS_VERSION_OF_SDL_GetKeyboardFocus
#define SDL_GetKeyboardState IGNORE_THIS_VERSION_OF_SDL_GetKeyboardState
#define SDL_GetMasksForPixelFormatEnum IGNORE_THIS_VERSION_OF_SDL_GetMasksForPixelFormatEnum
#define SDL_GetMemoryFunctions IGNORE_THIS_VERSION_OF_SDL_GetMemoryFunctions
#define SDL_GetModState IGNORE_THIS_VERSION_OF_SDL_GetModState
#define SDL_GetMouseFocus IGNORE_THIS_VERSION_OF_SDL_GetMouseFocus
#define SDL_GetMouseState IGNORE_THIS_VERSION_OF_SDL_GetMouseState
#define SDL_GetNaturalDisplayOrientation IGNORE_THIS_VERSION_OF_SDL_GetNaturalDisplayOrientation
#define SDL_GetNumAllocations IGNORE_THIS_VERSION_OF_SDL_GetNumAllocations
#define SDL_GetNumGamepadTouchpadFingers IGNORE_THIS_VERSION_OF_SDL_GetNumGamepadTouchpadFingers
#define SDL_GetNumGamepadTouchpads IGNORE_THIS_VERSION_OF_SDL_GetNumGamepadTouchpads
#define SDL_GetNumJoystickAxes IGNORE_THIS_VERSION_OF_SDL_GetNumJoystickAxes
#define SDL_GetNumJoystickButtons IGNORE_THIS_VERSION_OF_SDL_GetNumJoystickButtons
#define SDL_GetNumJoystickHats IGNORE_THIS_VERSION_OF_SDL_GetNumJoystickHats
#define SDL_GetNumRenderDrivers IGNORE_THIS_VERSION_OF_SDL_GetNumRenderDrivers
#define SDL_GetNumTouchFingers IGNORE_THIS_VERSION_OF_SDL_GetNumTouchFingers
#define SDL_GetNumVideoDrivers IGNORE_THIS_VERSION_OF_SDL_GetNumVideoDrivers
#define SDL_GetOriginalMemoryFunctions IGNORE_THIS_VERSION_OF_SDL_GetOriginalMemoryFunctions
#define SDL_GetUserFolder IGNORE_THIS_VERSION_OF_SDL_GetUserFolder
#define SDL_GetPerformanceCounter IGNORE_THIS_VERSION_OF_SDL_GetPerformanceCounter
#define SDL_GetPerformanceFrequency IGNORE_THIS_VERSION_OF_SDL_GetPerformanceFrequency
#define SDL_GetPixelFormatEnumForMasks IGNORE_THIS_VERSION_OF_SDL_GetPixelFormatEnumForMasks
#define SDL_GetPixelFormatName IGNORE_THIS_VERSION_OF_SDL_GetPixelFormatName
#define SDL_GetPlatform IGNORE_THIS_VERSION_OF_SDL_GetPlatform
#define SDL_GetPowerInfo IGNORE_THIS_VERSION_OF_SDL_GetPowerInfo
#define SDL_GetPrefPath IGNORE_THIS_VERSION_OF_SDL_GetPrefPath
#define SDL_GetPreferredLocales IGNORE_THIS_VERSION_OF_SDL_GetPreferredLocales
#define SDL_GetPrimaryDisplay IGNORE_THIS_VERSION_OF_SDL_GetPrimaryDisplay
#define SDL_GetPrimarySelectionText IGNORE_THIS_VERSION_OF_SDL_GetPrimarySelectionText
#define SDL_GetRGB IGNORE_THIS_VERSION_OF_SDL_GetRGB
#define SDL_GetRGBA IGNORE_THIS_VERSION_OF_SDL_GetRGBA
#define SDL_GetRectAndLineIntersection IGNORE_THIS_VERSION_OF_SDL_GetRectAndLineIntersection
#define SDL_GetRectAndLineIntersectionFloat IGNORE_THIS_VERSION_OF_SDL_GetRectAndLineIntersectionFloat
#define SDL_GetRectEnclosingPoints IGNORE_THIS_VERSION_OF_SDL_GetRectEnclosingPoints
#define SDL_GetRectEnclosingPointsFloat IGNORE_THIS_VERSION_OF_SDL_GetRectEnclosingPointsFloat
#define SDL_GetRectIntersection IGNORE_THIS_VERSION_OF_SDL_GetRectIntersection
#define SDL_GetRectIntersectionFloat IGNORE_THIS_VERSION_OF_SDL_GetRectIntersectionFloat
#define SDL_GetRectUnion IGNORE_THIS_VERSION_OF_SDL_GetRectUnion
#define SDL_GetRectUnionFloat IGNORE_THIS_VERSION_OF_SDL_GetRectUnionFloat
#define SDL_GetRelativeMouseMode IGNORE_THIS_VERSION_OF_SDL_GetRelativeMouseMode
#define SDL_GetRelativeMouseState IGNORE_THIS_VERSION_OF_SDL_GetRelativeMouseState
#define SDL_GetRenderClipRect IGNORE_THIS_VERSION_OF_SDL_GetRenderClipRect
#define SDL_GetRenderDrawBlendMode IGNORE_THIS_VERSION_OF_SDL_GetRenderDrawBlendMode
#define SDL_GetRenderDrawColor IGNORE_THIS_VERSION_OF_SDL_GetRenderDrawColor
#define SDL_GetRenderDriver IGNORE_THIS_VERSION_OF_SDL_GetRenderDriver
#define SDL_GetRenderLogicalPresentation IGNORE_THIS_VERSION_OF_SDL_GetRenderLogicalPresentation
#define SDL_GetRenderMetalCommandEncoder IGNORE_THIS_VERSION_OF_SDL_GetRenderMetalCommandEncoder
#define SDL_GetRenderMetalLayer IGNORE_THIS_VERSION_OF_SDL_GetRenderMetalLayer
#define SDL_GetRenderOutputSize IGNORE_THIS_VERSION_OF_SDL_GetRenderOutputSize
#define SDL_GetRenderScale IGNORE_THIS_VERSION_OF_SDL_GetRenderScale
#define SDL_GetRenderTarget IGNORE_THIS_VERSION_OF_SDL_GetRenderTarget
#define SDL_GetRenderVSync IGNORE_THIS_VERSION_OF_SDL_GetRenderVSync
#define SDL_GetRenderViewport IGNORE_THIS_VERSION_OF_SDL_GetRenderViewport
#define SDL_GetRenderWindow IGNORE_THIS_VERSION_OF_SDL_GetRenderWindow
#define SDL_GetRenderer IGNORE_THIS_VERSION_OF_SDL_GetRenderer
#define SDL_GetRendererInfo IGNORE_THIS_VERSION_OF_SDL_GetRendererInfo
#define SDL_GetRevision IGNORE_THIS_VERSION_OF_SDL_GetRevision
#define SDL_GetScancodeFromKey IGNORE_THIS_VERSION_OF_SDL_GetScancodeFromKey
#define SDL_GetScancodeFromName IGNORE_THIS_VERSION_OF_SDL_GetScancodeFromName
#define SDL_GetScancodeName IGNORE_THIS_VERSION_OF_SDL_GetScancodeName
#define SDL_GetSemaphoreValue IGNORE_THIS_VERSION_OF_SDL_GetSemaphoreValue
#define SDL_GetSensorData IGNORE_THIS_VERSION_OF_SDL_GetSensorData
#define SDL_GetSensorFromInstanceID IGNORE_THIS_VERSION_OF_SDL_GetSensorFromInstanceID
#define SDL_GetSensorInstanceID IGNORE_THIS_VERSION_OF_SDL_GetSensorInstanceID
#define SDL_GetSensorInstanceName IGNORE_THIS_VERSION_OF_SDL_GetSensorInstanceName
#define SDL_GetSensorInstanceNonPortableType IGNORE_THIS_VERSION_OF_SDL_GetSensorInstanceNonPortableType
#define SDL_GetSensorInstanceType IGNORE_THIS_VERSION_OF_SDL_GetSensorInstanceType
#define SDL_GetSensorName IGNORE_THIS_VERSION_OF_SDL_GetSensorName
#define SDL_GetSensorNonPortableType IGNORE_THIS_VERSION_OF_SDL_GetSensorNonPortableType
#define SDL_GetSensorType IGNORE_THIS_VERSION_OF_SDL_GetSensorType
#define SDL_GetSensors IGNORE_THIS_VERSION_OF_SDL_GetSensors
#define SDL_GetSurfaceAlphaMod IGNORE_THIS_VERSION_OF_SDL_GetSurfaceAlphaMod
#define SDL_GetSurfaceBlendMode IGNORE_THIS_VERSION_OF_SDL_GetSurfaceBlendMode
#define SDL_GetSurfaceClipRect IGNORE_THIS_VERSION_OF_SDL_GetSurfaceClipRect
#define SDL_GetSurfaceColorKey IGNORE_THIS_VERSION_OF_SDL_GetSurfaceColorKey
#define SDL_GetSurfaceColorMod IGNORE_THIS_VERSION_OF_SDL_GetSurfaceColorMod
#define SDL_GetSystemRAM IGNORE_THIS_VERSION_OF_SDL_GetSystemRAM
#define SDL_GetSystemTheme IGNORE_THIS_VERSION_OF_SDL_GetSystemTheme
#define SDL_GetTLS IGNORE_THIS_VERSION_OF_SDL_GetTLS
#define SDL_GetTextureAlphaMod IGNORE_THIS_VERSION_OF_SDL_GetTextureAlphaMod
#define SDL_GetTextureBlendMode IGNORE_THIS_VERSION_OF_SDL_GetTextureBlendMode
#define SDL_GetTextureColorMod IGNORE_THIS_VERSION_OF_SDL_GetTextureColorMod
#define SDL_GetTextureScaleMode IGNORE_THIS_VERSION_OF_SDL_GetTextureScaleMode
#define SDL_GetThreadID IGNORE_THIS_VERSION_OF_SDL_GetThreadID
#define SDL_GetThreadName IGNORE_THIS_VERSION_OF_SDL_GetThreadName
#define SDL_GetTicks IGNORE_THIS_VERSION_OF_SDL_GetTicks
#define SDL_GetTicksNS IGNORE_THIS_VERSION_OF_SDL_GetTicksNS
#define SDL_GetTouchDeviceType IGNORE_THIS_VERSION_OF_SDL_GetTouchDeviceType
#define SDL_GetTouchFinger IGNORE_THIS_VERSION_OF_SDL_GetTouchFinger
#define SDL_GetVersion IGNORE_THIS_VERSION_OF_SDL_GetVersion
#define SDL_GetVideoDriver IGNORE_THIS_VERSION_OF_SDL_GetVideoDriver
#define SDL_GetWindowBordersSize IGNORE_THIS_VERSION_OF_SDL_GetWindowBordersSize
#define SDL_GetWindowDisplayScale IGNORE_THIS_VERSION_OF_SDL_GetWindowDisplayScale
#define SDL_GetWindowFlags IGNORE_THIS_VERSION_OF_SDL_GetWindowFlags
#define SDL_GetWindowFromID IGNORE_THIS_VERSION_OF_SDL_GetWindowFromID
#define SDL_GetWindowFullscreenMode IGNORE_THIS_VERSION_OF_SDL_GetWindowFullscreenMode
#define SDL_GetWindowGrab IGNORE_THIS_VERSION_OF_SDL_GetWindowGrab
#define SDL_GetWindowICCProfile IGNORE_THIS_VERSION_OF_SDL_GetWindowICCProfile
#define SDL_GetWindowID IGNORE_THIS_VERSION_OF_SDL_GetWindowID
#define SDL_GetWindowKeyboardGrab IGNORE_THIS_VERSION_OF_SDL_GetWindowKeyboardGrab
#define SDL_GetWindowMaximumSize IGNORE_THIS_VERSION_OF_SDL_GetWindowMaximumSize
#define SDL_GetWindowMinimumSize IGNORE_THIS_VERSION_OF_SDL_GetWindowMinimumSize
#define SDL_GetWindowMouseGrab IGNORE_THIS_VERSION_OF_SDL_GetWindowMouseGrab
#define SDL_GetWindowMouseRect IGNORE_THIS_VERSION_OF_SDL_GetWindowMouseRect
#define SDL_GetWindowOpacity IGNORE_THIS_VERSION_OF_SDL_GetWindowOpacity
#define SDL_GetWindowParent IGNORE_THIS_VERSION_OF_SDL_GetWindowParent
#define SDL_GetWindowPixelDensity IGNORE_THIS_VERSION_OF_SDL_GetWindowPixelDensity
#define SDL_GetWindowPixelFormat IGNORE_THIS_VERSION_OF_SDL_GetWindowPixelFormat
#define SDL_GetWindowPosition IGNORE_THIS_VERSION_OF_SDL_GetWindowPosition
#define SDL_GetWindowSize IGNORE_THIS_VERSION_OF_SDL_GetWindowSize
#define SDL_GetWindowSizeInPixels IGNORE_THIS_VERSION_OF_SDL_GetWindowSizeInPixels
#define SDL_GetWindowSurface IGNORE_THIS_VERSION_OF_SDL_GetWindowSurface
#define SDL_GetWindowTitle IGNORE_THIS_VERSION_OF_SDL_GetWindowTitle
#define SDL_GetYUVConversionMode IGNORE_THIS_VERSION_OF_SDL_GetYUVConversionMode
#define SDL_GetYUVConversionModeForResolution IGNORE_THIS_VERSION_OF_SDL_GetYUVConversionModeForResolution
#define SDL_CloseHaptic IGNORE_THIS_VERSION_OF_SDL_CloseHaptic
#define SDL_DestroyHapticEffect IGNORE_THIS_VERSION_OF_SDL_DestroyHapticEffect
#define SDL_HapticEffectSupported IGNORE_THIS_VERSION_OF_SDL_HapticEffectSupported
#define SDL_GetHapticEffectStatus IGNORE_THIS_VERSION_OF_SDL_GetHapticEffectStatus
#define SDL_CreateHapticEffect IGNORE_THIS_VERSION_OF_SDL_CreateHapticEffect
#define SDL_GetNumHapticAxes IGNORE_THIS_VERSION_OF_SDL_GetNumHapticAxes
#define SDL_GetMaxHapticEffects IGNORE_THIS_VERSION_OF_SDL_GetMaxHapticEffects
#define SDL_GetMaxHapticEffectsPlaying IGNORE_THIS_VERSION_OF_SDL_GetMaxHapticEffectsPlaying
#define SDL_OpenHaptic IGNORE_THIS_VERSION_OF_SDL_OpenHaptic
#define SDL_OpenHapticFromJoystick IGNORE_THIS_VERSION_OF_SDL_OpenHapticFromJoystick
#define SDL_OpenHapticFromMouse IGNORE_THIS_VERSION_OF_SDL_OpenHapticFromMouse
#define SDL_PauseHaptic IGNORE_THIS_VERSION_OF_SDL_PauseHaptic
#define SDL_GetHapticFeatures IGNORE_THIS_VERSION_OF_SDL_GetHapticFeatures
#define SDL_InitHapticRumble IGNORE_THIS_VERSION_OF_SDL_InitHapticRumble
#define SDL_PlayHapticRumble IGNORE_THIS_VERSION_OF_SDL_PlayHapticRumble
#define SDL_StopHapticRumble IGNORE_THIS_VERSION_OF_SDL_StopHapticRumble
#define SDL_HapticRumbleSupported IGNORE_THIS_VERSION_OF_SDL_HapticRumbleSupported
#define SDL_RunHapticEffect IGNORE_THIS_VERSION_OF_SDL_RunHapticEffect
#define SDL_SetHapticAutocenter IGNORE_THIS_VERSION_OF_SDL_SetHapticAutocenter
#define SDL_SetHapticGain IGNORE_THIS_VERSION_OF_SDL_SetHapticGain
#define SDL_StopHapticEffects IGNORE_THIS_VERSION_OF_SDL_StopHapticEffects
#define SDL_StopHapticEffect IGNORE_THIS_VERSION_OF_SDL_StopHapticEffect
#define SDL_ResumeHaptic IGNORE_THIS_VERSION_OF_SDL_ResumeHaptic
#define SDL_UpdateHapticEffect IGNORE_THIS_VERSION_OF_SDL_UpdateHapticEffect
#define SDL_HasARMSIMD IGNORE_THIS_VERSION_OF_SDL_HasARMSIMD
#define SDL_HasAVX IGNORE_THIS_VERSION_OF_SDL_HasAVX
#define SDL_HasAVX2 IGNORE_THIS_VERSION_OF_SDL_HasAVX2
#define SDL_HasAVX512F IGNORE_THIS_VERSION_OF_SDL_HasAVX512F
#define SDL_HasAltiVec IGNORE_THIS_VERSION_OF_SDL_HasAltiVec
#define SDL_HasClipboardData IGNORE_THIS_VERSION_OF_SDL_HasClipboardData
#define SDL_HasClipboardText IGNORE_THIS_VERSION_OF_SDL_HasClipboardText
#define SDL_HasEvent IGNORE_THIS_VERSION_OF_SDL_HasEvent
#define SDL_HasEvents IGNORE_THIS_VERSION_OF_SDL_HasEvents
#define SDL_HasLASX IGNORE_THIS_VERSION_OF_SDL_HasLASX
#define SDL_HasLSX IGNORE_THIS_VERSION_OF_SDL_HasLSX
#define SDL_HasMMX IGNORE_THIS_VERSION_OF_SDL_HasMMX
#define SDL_HasNEON IGNORE_THIS_VERSION_OF_SDL_HasNEON
#define SDL_HasPrimarySelectionText IGNORE_THIS_VERSION_OF_SDL_HasPrimarySelectionText
#define SDL_HasRectIntersection IGNORE_THIS_VERSION_OF_SDL_HasRectIntersection
#define SDL_HasRectIntersectionFloat IGNORE_THIS_VERSION_OF_SDL_HasRectIntersectionFloat
#define SDL_HasSSE IGNORE_THIS_VERSION_OF_SDL_HasSSE
#define SDL_HasSSE2 IGNORE_THIS_VERSION_OF_SDL_HasSSE2
#define SDL_HasSSE3 IGNORE_THIS_VERSION_OF_SDL_HasSSE3
#define SDL_HasSSE41 IGNORE_THIS_VERSION_OF_SDL_HasSSE41
#define SDL_HasSSE42 IGNORE_THIS_VERSION_OF_SDL_HasSSE42
#define SDL_HasScreenKeyboardSupport IGNORE_THIS_VERSION_OF_SDL_HasScreenKeyboardSupport
#define SDL_HasWindowSurface IGNORE_THIS_VERSION_OF_SDL_HasWindowSurface
#define SDL_HideCursor IGNORE_THIS_VERSION_OF_SDL_HideCursor
#define SDL_HideWindow IGNORE_THIS_VERSION_OF_SDL_HideWindow
#define SDL_Init IGNORE_THIS_VERSION_OF_SDL_Init
#define SDL_InitSubSystem IGNORE_THIS_VERSION_OF_SDL_InitSubSystem
#define SDL_IsAndroidTV IGNORE_THIS_VERSION_OF_SDL_IsAndroidTV
#define SDL_IsChromebook IGNORE_THIS_VERSION_OF_SDL_IsChromebook
#define SDL_IsDeXMode IGNORE_THIS_VERSION_OF_SDL_IsDeXMode
#define SDL_IsGamepad IGNORE_THIS_VERSION_OF_SDL_IsGamepad
#define SDL_IsJoystickVirtual IGNORE_THIS_VERSION_OF_SDL_IsJoystickVirtual
#define SDL_IsTablet IGNORE_THIS_VERSION_OF_SDL_IsTablet
#define SDL_JoystickConnected IGNORE_THIS_VERSION_OF_SDL_JoystickConnected
#define SDL_JoystickEventsEnabled IGNORE_THIS_VERSION_OF_SDL_JoystickEventsEnabled
#define SDL_JoystickHasLED IGNORE_THIS_VERSION_OF_SDL_JoystickHasLED
#define SDL_JoystickHasRumble IGNORE_THIS_VERSION_OF_SDL_JoystickHasRumble
#define SDL_JoystickHasRumbleTriggers IGNORE_THIS_VERSION_OF_SDL_JoystickHasRumbleTriggers
#define SDL_IsJoystickHaptic IGNORE_THIS_VERSION_OF_SDL_IsJoystickHaptic
#define SDL_LinuxSetThreadPriority IGNORE_THIS_VERSION_OF_SDL_LinuxSetThreadPriority
#define SDL_LinuxSetThreadPriorityAndPolicy IGNORE_THIS_VERSION_OF_SDL_LinuxSetThreadPriorityAndPolicy
#define SDL_LoadBMP IGNORE_THIS_VERSION_OF_SDL_LoadBMP
#define SDL_LoadBMP_RW IGNORE_THIS_VERSION_OF_SDL_LoadBMP_RW
#define SDL_LoadFile IGNORE_THIS_VERSION_OF_SDL_LoadFile
#define SDL_LoadFile_RW IGNORE_THIS_VERSION_OF_SDL_LoadFile_RW
#define SDL_LoadFunction IGNORE_THIS_VERSION_OF_SDL_LoadFunction
#define SDL_LoadObject IGNORE_THIS_VERSION_OF_SDL_LoadObject
#define SDL_LockJoysticks IGNORE_THIS_VERSION_OF_SDL_LockJoysticks
#define SDL_LockMutex IGNORE_THIS_VERSION_OF_SDL_LockMutex
#define SDL_LockRWLockForReading IGNORE_THIS_VERSION_OF_SDL_LockRWLockForReading
#define SDL_LockRWLockForWriting IGNORE_THIS_VERSION_OF_SDL_LockRWLockForWriting
#define SDL_LockSurface IGNORE_THIS_VERSION_OF_SDL_LockSurface
#define SDL_LockTexture IGNORE_THIS_VERSION_OF_SDL_LockTexture
#define SDL_LockTextureToSurface IGNORE_THIS_VERSION_OF_SDL_LockTextureToSurface
#define SDL_Log IGNORE_THIS_VERSION_OF_SDL_Log
#define SDL_LogCritical IGNORE_THIS_VERSION_OF_SDL_LogCritical
#define SDL_LogDebug IGNORE_THIS_VERSION_OF_SDL_LogDebug
#define SDL_LogError IGNORE_THIS_VERSION_OF_SDL_LogError
#define SDL_LogGetOutputFunction IGNORE_THIS_VERSION_OF_SDL_LogGetOutputFunction
#define SDL_LogGetPriority IGNORE_THIS_VERSION_OF_SDL_LogGetPriority
#define SDL_LogInfo IGNORE_THIS_VERSION_OF_SDL_LogInfo
#define SDL_LogMessage IGNORE_THIS_VERSION_OF_SDL_LogMessage
#define SDL_LogMessageV IGNORE_THIS_VERSION_OF_SDL_LogMessageV
#define SDL_LogResetPriorities IGNORE_THIS_VERSION_OF_SDL_LogResetPriorities
#define SDL_LogSetAllPriority IGNORE_THIS_VERSION_OF_SDL_LogSetAllPriority
#define SDL_LogSetOutputFunction IGNORE_THIS_VERSION_OF_SDL_LogSetOutputFunction
#define SDL_LogSetPriority IGNORE_THIS_VERSION_OF_SDL_LogSetPriority
#define SDL_LogVerbose IGNORE_THIS_VERSION_OF_SDL_LogVerbose
#define SDL_LogWarn IGNORE_THIS_VERSION_OF_SDL_LogWarn
#define SDL_MapRGB IGNORE_THIS_VERSION_OF_SDL_MapRGB
#define SDL_MapRGBA IGNORE_THIS_VERSION_OF_SDL_MapRGBA
#define SDL_MaximizeWindow IGNORE_THIS_VERSION_OF_SDL_MaximizeWindow
#define SDL_MemoryBarrierAcquireFunction IGNORE_THIS_VERSION_OF_SDL_MemoryBarrierAcquireFunction
#define SDL_MemoryBarrierReleaseFunction IGNORE_THIS_VERSION_OF_SDL_MemoryBarrierReleaseFunction
#define SDL_Metal_CreateView IGNORE_THIS_VERSION_OF_SDL_Metal_CreateView
#define SDL_Metal_DestroyView IGNORE_THIS_VERSION_OF_SDL_Metal_DestroyView
#define SDL_Metal_GetLayer IGNORE_THIS_VERSION_OF_SDL_Metal_GetLayer
#define SDL_MinimizeWindow IGNORE_THIS_VERSION_OF_SDL_MinimizeWindow
#define SDL_IsMouseHaptic IGNORE_THIS_VERSION_OF_SDL_IsMouseHaptic
#define SDL_OnApplicationDidBecomeActive IGNORE_THIS_VERSION_OF_SDL_OnApplicationDidBecomeActive
#define SDL_OnApplicationDidChangeStatusBarOrientation IGNORE_THIS_VERSION_OF_SDL_OnApplicationDidChangeStatusBarOrientation
#define SDL_OnApplicationDidEnterBackground IGNORE_THIS_VERSION_OF_SDL_OnApplicationDidEnterBackground
#define SDL_OnApplicationDidReceiveMemoryWarning IGNORE_THIS_VERSION_OF_SDL_OnApplicationDidReceiveMemoryWarning
#define SDL_OnApplicationWillEnterForeground IGNORE_THIS_VERSION_OF_SDL_OnApplicationWillEnterForeground
#define SDL_OnApplicationWillResignActive IGNORE_THIS_VERSION_OF_SDL_OnApplicationWillResignActive
#define SDL_OnApplicationWillTerminate IGNORE_THIS_VERSION_OF_SDL_OnApplicationWillTerminate
#define SDL_OpenGamepad IGNORE_THIS_VERSION_OF_SDL_OpenGamepad
#define SDL_OpenJoystick IGNORE_THIS_VERSION_OF_SDL_OpenJoystick
#define SDL_OpenSensor IGNORE_THIS_VERSION_OF_SDL_OpenSensor
#define SDL_OpenURL IGNORE_THIS_VERSION_OF_SDL_OpenURL
#define SDL_PeepEvents IGNORE_THIS_VERSION_OF_SDL_PeepEvents
#define SDL_PollEvent IGNORE_THIS_VERSION_OF_SDL_PollEvent
#define SDL_PostSemaphore IGNORE_THIS_VERSION_OF_SDL_PostSemaphore
#define SDL_PremultiplyAlpha IGNORE_THIS_VERSION_OF_SDL_PremultiplyAlpha
#define SDL_PumpEvents IGNORE_THIS_VERSION_OF_SDL_PumpEvents
#define SDL_PushEvent IGNORE_THIS_VERSION_OF_SDL_PushEvent
#define SDL_QueryTexture IGNORE_THIS_VERSION_OF_SDL_QueryTexture
#define SDL_Quit IGNORE_THIS_VERSION_OF_SDL_Quit
#define SDL_QuitSubSystem IGNORE_THIS_VERSION_OF_SDL_QuitSubSystem
#define SDL_RWFromConstMem IGNORE_THIS_VERSION_OF_SDL_RWFromConstMem
#define SDL_RWFromFile IGNORE_THIS_VERSION_OF_SDL_RWFromFile
#define SDL_RWFromMem IGNORE_THIS_VERSION_OF_SDL_RWFromMem
#define SDL_RWclose IGNORE_THIS_VERSION_OF_SDL_RWclose
#define SDL_RWread IGNORE_THIS_VERSION_OF_SDL_RWread
#define SDL_RWseek IGNORE_THIS_VERSION_OF_SDL_RWseek
#define SDL_RWsize IGNORE_THIS_VERSION_OF_SDL_RWsize
#define SDL_RWtell IGNORE_THIS_VERSION_OF_SDL_RWtell
#define SDL_RWwrite IGNORE_THIS_VERSION_OF_SDL_RWwrite
#define SDL_RaiseWindow IGNORE_THIS_VERSION_OF_SDL_RaiseWindow
#define SDL_ReadU16BE IGNORE_THIS_VERSION_OF_SDL_ReadU16BE
#define SDL_ReadU32BE IGNORE_THIS_VERSION_OF_SDL_ReadU32BE
#define SDL_ReadU64BE IGNORE_THIS_VERSION_OF_SDL_ReadU64BE
#define SDL_ReadU16LE IGNORE_THIS_VERSION_OF_SDL_ReadU16LE
#define SDL_ReadU32LE IGNORE_THIS_VERSION_OF_SDL_ReadU32LE
#define SDL_ReadU64LE IGNORE_THIS_VERSION_OF_SDL_ReadU64LE
#define SDL_ReadU8 IGNORE_THIS_VERSION_OF_SDL_ReadU8
#define SDL_RegisterApp IGNORE_THIS_VERSION_OF_SDL_RegisterApp
#define SDL_RegisterEvents IGNORE_THIS_VERSION_OF_SDL_RegisterEvents
#define SDL_RemoveTimer IGNORE_THIS_VERSION_OF_SDL_RemoveTimer
#define SDL_RenderClear IGNORE_THIS_VERSION_OF_SDL_RenderClear
#define SDL_RenderClipEnabled IGNORE_THIS_VERSION_OF_SDL_RenderClipEnabled
#define SDL_RenderCoordinatesFromWindow IGNORE_THIS_VERSION_OF_SDL_RenderCoordinatesFromWindow
#define SDL_RenderCoordinatesToWindow IGNORE_THIS_VERSION_OF_SDL_RenderCoordinatesToWindow
#define SDL_RenderFillRect IGNORE_THIS_VERSION_OF_SDL_RenderFillRect
#define SDL_RenderFillRects IGNORE_THIS_VERSION_OF_SDL_RenderFillRects
#define SDL_RenderGeometry IGNORE_THIS_VERSION_OF_SDL_RenderGeometry
#define SDL_RenderGeometryRaw IGNORE_THIS_VERSION_OF_SDL_RenderGeometryRaw
#define SDL_RenderLine IGNORE_THIS_VERSION_OF_SDL_RenderLine
#define SDL_RenderLines IGNORE_THIS_VERSION_OF_SDL_RenderLines
#define SDL_RenderPoint IGNORE_THIS_VERSION_OF_SDL_RenderPoint
#define SDL_RenderPoints IGNORE_THIS_VERSION_OF_SDL_RenderPoints
#define SDL_RenderPresent IGNORE_THIS_VERSION_OF_SDL_RenderPresent
#define SDL_RenderReadPixels IGNORE_THIS_VERSION_OF_SDL_RenderReadPixels
#define SDL_RenderRect IGNORE_THIS_VERSION_OF_SDL_RenderRect
#define SDL_RenderRects IGNORE_THIS_VERSION_OF_SDL_RenderRects
#define SDL_RenderTexture IGNORE_THIS_VERSION_OF_SDL_RenderTexture
#define SDL_RenderTextureRotated IGNORE_THIS_VERSION_OF_SDL_RenderTextureRotated
#define SDL_ReportAssertion IGNORE_THIS_VERSION_OF_SDL_ReportAssertion
#define SDL_ResetAssertionReport IGNORE_THIS_VERSION_OF_SDL_ResetAssertionReport
#define SDL_ResetHint IGNORE_THIS_VERSION_OF_SDL_ResetHint
#define SDL_ResetHints IGNORE_THIS_VERSION_OF_SDL_ResetHints
#define SDL_ResetKeyboard IGNORE_THIS_VERSION_OF_SDL_ResetKeyboard
#define SDL_RestoreWindow IGNORE_THIS_VERSION_OF_SDL_RestoreWindow
#define SDL_RumbleGamepad IGNORE_THIS_VERSION_OF_SDL_RumbleGamepad
#define SDL_RumbleGamepadTriggers IGNORE_THIS_VERSION_OF_SDL_RumbleGamepadTriggers
#define SDL_RumbleJoystick IGNORE_THIS_VERSION_OF_SDL_RumbleJoystick
#define SDL_RumbleJoystickTriggers IGNORE_THIS_VERSION_OF_SDL_RumbleJoystickTriggers
#define SDL_RunApp IGNORE_THIS_VERSION_OF_SDL_RunApp
#define SDL_SIMDGetAlignment IGNORE_THIS_VERSION_OF_SDL_SIMDGetAlignment
#define SDL_SaveBMP IGNORE_THIS_VERSION_OF_SDL_SaveBMP
#define SDL_SaveBMP_RW IGNORE_THIS_VERSION_OF_SDL_SaveBMP_RW
#define SDL_ScreenKeyboardShown IGNORE_THIS_VERSION_OF_SDL_ScreenKeyboardShown
#define SDL_ScreenSaverEnabled IGNORE_THIS_VERSION_OF_SDL_ScreenSaverEnabled
#define SDL_SendGamepadEffect IGNORE_THIS_VERSION_OF_SDL_SendGamepadEffect
#define SDL_SendJoystickEffect IGNORE_THIS_VERSION_OF_SDL_SendJoystickEffect
#define SDL_SetAssertionHandler IGNORE_THIS_VERSION_OF_SDL_SetAssertionHandler
#define SDL_SetClipboardData IGNORE_THIS_VERSION_OF_SDL_SetClipboardData
#define SDL_SetClipboardText IGNORE_THIS_VERSION_OF_SDL_SetClipboardText
#define SDL_SetCursor IGNORE_THIS_VERSION_OF_SDL_SetCursor
#define SDL_SetError IGNORE_THIS_VERSION_OF_SDL_SetError
#define SDL_SetEventEnabled IGNORE_THIS_VERSION_OF_SDL_SetEventEnabled
#define SDL_SetEventFilter IGNORE_THIS_VERSION_OF_SDL_SetEventFilter
#define SDL_SetGamepadEventsEnabled IGNORE_THIS_VERSION_OF_SDL_SetGamepadEventsEnabled
#define SDL_SetGamepadLED IGNORE_THIS_VERSION_OF_SDL_SetGamepadLED
#define SDL_SetGamepadPlayerIndex IGNORE_THIS_VERSION_OF_SDL_SetGamepadPlayerIndex
#define SDL_SetGamepadSensorEnabled IGNORE_THIS_VERSION_OF_SDL_SetGamepadSensorEnabled
#define SDL_SetHint IGNORE_THIS_VERSION_OF_SDL_SetHint
#define SDL_SetHintWithPriority IGNORE_THIS_VERSION_OF_SDL_SetHintWithPriority
#define SDL_SetJoystickEventsEnabled IGNORE_THIS_VERSION_OF_SDL_SetJoystickEventsEnabled
#define SDL_SetJoystickLED IGNORE_THIS_VERSION_OF_SDL_SetJoystickLED
#define SDL_SetJoystickPlayerIndex IGNORE_THIS_VERSION_OF_SDL_SetJoystickPlayerIndex
#define SDL_SetJoystickVirtualAxis IGNORE_THIS_VERSION_OF_SDL_SetJoystickVirtualAxis
#define SDL_SetJoystickVirtualButton IGNORE_THIS_VERSION_OF_SDL_SetJoystickVirtualButton
#define SDL_SetJoystickVirtualHat IGNORE_THIS_VERSION_OF_SDL_SetJoystickVirtualHat
#define SDL_SetMainReady IGNORE_THIS_VERSION_OF_SDL_SetMainReady
#define SDL_SetMemoryFunctions IGNORE_THIS_VERSION_OF_SDL_SetMemoryFunctions
#define SDL_SetModState IGNORE_THIS_VERSION_OF_SDL_SetModState
#define SDL_SetPaletteColors IGNORE_THIS_VERSION_OF_SDL_SetPaletteColors
#define SDL_SetPixelFormatPalette IGNORE_THIS_VERSION_OF_SDL_SetPixelFormatPalette
#define SDL_SetPrimarySelectionText IGNORE_THIS_VERSION_OF_SDL_SetPrimarySelectionText
#define SDL_SetRelativeMouseMode IGNORE_THIS_VERSION_OF_SDL_SetRelativeMouseMode
#define SDL_SetRenderClipRect IGNORE_THIS_VERSION_OF_SDL_SetRenderClipRect
#define SDL_SetRenderDrawBlendMode IGNORE_THIS_VERSION_OF_SDL_SetRenderDrawBlendMode
#define SDL_SetRenderDrawColor IGNORE_THIS_VERSION_OF_SDL_SetRenderDrawColor
#define SDL_SetRenderLogicalPresentation IGNORE_THIS_VERSION_OF_SDL_SetRenderLogicalPresentation
#define SDL_SetRenderScale IGNORE_THIS_VERSION_OF_SDL_SetRenderScale
#define SDL_SetRenderTarget IGNORE_THIS_VERSION_OF_SDL_SetRenderTarget
#define SDL_SetRenderVSync IGNORE_THIS_VERSION_OF_SDL_SetRenderVSync
#define SDL_SetRenderViewport IGNORE_THIS_VERSION_OF_SDL_SetRenderViewport
#define SDL_SetSurfaceAlphaMod IGNORE_THIS_VERSION_OF_SDL_SetSurfaceAlphaMod
#define SDL_SetSurfaceBlendMode IGNORE_THIS_VERSION_OF_SDL_SetSurfaceBlendMode
#define SDL_SetSurfaceClipRect IGNORE_THIS_VERSION_OF_SDL_SetSurfaceClipRect
#define SDL_SetSurfaceColorKey IGNORE_THIS_VERSION_OF_SDL_SetSurfaceColorKey
#define SDL_SetSurfaceColorMod IGNORE_THIS_VERSION_OF_SDL_SetSurfaceColorMod
#define SDL_SetSurfacePalette IGNORE_THIS_VERSION_OF_SDL_SetSurfacePalette
#define SDL_SetSurfaceRLE IGNORE_THIS_VERSION_OF_SDL_SetSurfaceRLE
#define SDL_SetTLS IGNORE_THIS_VERSION_OF_SDL_SetTLS
#define SDL_SetTextInputRect IGNORE_THIS_VERSION_OF_SDL_SetTextInputRect
#define SDL_SetTextureAlphaMod IGNORE_THIS_VERSION_OF_SDL_SetTextureAlphaMod
#define SDL_SetTextureBlendMode IGNORE_THIS_VERSION_OF_SDL_SetTextureBlendMode
#define SDL_SetTextureColorMod IGNORE_THIS_VERSION_OF_SDL_SetTextureColorMod
#define SDL_SetTextureScaleMode IGNORE_THIS_VERSION_OF_SDL_SetTextureScaleMode
#define SDL_SetThreadPriority IGNORE_THIS_VERSION_OF_SDL_SetThreadPriority
#define SDL_SetWindowAlwaysOnTop IGNORE_THIS_VERSION_OF_SDL_SetWindowAlwaysOnTop
#define SDL_SetWindowBordered IGNORE_THIS_VERSION_OF_SDL_SetWindowBordered
#define SDL_SetWindowFullscreen IGNORE_THIS_VERSION_OF_SDL_SetWindowFullscreen
#define SDL_SetWindowFullscreenMode IGNORE_THIS_VERSION_OF_SDL_SetWindowFullscreenMode
#define SDL_SetWindowGrab IGNORE_THIS_VERSION_OF_SDL_SetWindowGrab
#define SDL_SetWindowHitTest IGNORE_THIS_VERSION_OF_SDL_SetWindowHitTest
#define SDL_SetWindowIcon IGNORE_THIS_VERSION_OF_SDL_SetWindowIcon
#define SDL_SetWindowInputFocus IGNORE_THIS_VERSION_OF_SDL_SetWindowInputFocus
#define SDL_SetWindowKeyboardGrab IGNORE_THIS_VERSION_OF_SDL_SetWindowKeyboardGrab
#define SDL_SetWindowMaximumSize IGNORE_THIS_VERSION_OF_SDL_SetWindowMaximumSize
#define SDL_SetWindowMinimumSize IGNORE_THIS_VERSION_OF_SDL_SetWindowMinimumSize
#define SDL_SetWindowModalFor IGNORE_THIS_VERSION_OF_SDL_SetWindowModalFor
#define SDL_SetWindowMouseGrab IGNORE_THIS_VERSION_OF_SDL_SetWindowMouseGrab
#define SDL_SetWindowMouseRect IGNORE_THIS_VERSION_OF_SDL_SetWindowMouseRect
#define SDL_SetWindowOpacity IGNORE_THIS_VERSION_OF_SDL_SetWindowOpacity
#define SDL_SetWindowPosition IGNORE_THIS_VERSION_OF_SDL_SetWindowPosition
#define SDL_SetWindowResizable IGNORE_THIS_VERSION_OF_SDL_SetWindowResizable
#define SDL_SetWindowSize IGNORE_THIS_VERSION_OF_SDL_SetWindowSize
#define SDL_SetWindowTitle IGNORE_THIS_VERSION_OF_SDL_SetWindowTitle
#define SDL_SetWindowsMessageHook IGNORE_THIS_VERSION_OF_SDL_SetWindowsMessageHook
#define SDL_SetYUVConversionMode IGNORE_THIS_VERSION_OF_SDL_SetYUVConversionMode
#define SDL_ShowCursor IGNORE_THIS_VERSION_OF_SDL_ShowCursor
#define SDL_ShowMessageBox IGNORE_THIS_VERSION_OF_SDL_ShowMessageBox
#define SDL_ShowSimpleMessageBox IGNORE_THIS_VERSION_OF_SDL_ShowSimpleMessageBox
#define SDL_ShowWindow IGNORE_THIS_VERSION_OF_SDL_ShowWindow
#define SDL_SignalCondition IGNORE_THIS_VERSION_OF_SDL_SignalCondition
#define SDL_SoftStretch IGNORE_THIS_VERSION_OF_SDL_SoftStretch
#define SDL_StartTextInput IGNORE_THIS_VERSION_OF_SDL_StartTextInput
#define SDL_StopTextInput IGNORE_THIS_VERSION_OF_SDL_StopTextInput
#define SDL_SurfaceHasColorKey IGNORE_THIS_VERSION_OF_SDL_SurfaceHasColorKey
#define SDL_SurfaceHasRLE IGNORE_THIS_VERSION_OF_SDL_SurfaceHasRLE
#define SDL_TextInputActive IGNORE_THIS_VERSION_OF_SDL_TextInputActive
#define SDL_TextInputShown IGNORE_THIS_VERSION_OF_SDL_TextInputShown
#define SDL_GetCurrentThreadID IGNORE_THIS_VERSION_OF_SDL_GetCurrentThreadID
#define SDL_TryLockMutex IGNORE_THIS_VERSION_OF_SDL_TryLockMutex
#define SDL_TryLockRWLockForReading IGNORE_THIS_VERSION_OF_SDL_TryLockRWLockForReading
#define SDL_TryLockRWLockForWriting IGNORE_THIS_VERSION_OF_SDL_TryLockRWLockForWriting
#define SDL_TryWaitSemaphore IGNORE_THIS_VERSION_OF_SDL_TryWaitSemaphore
#define SDL_UnloadObject IGNORE_THIS_VERSION_OF_SDL_UnloadObject
#define SDL_UnlockJoysticks IGNORE_THIS_VERSION_OF_SDL_UnlockJoysticks
#define SDL_UnlockMutex IGNORE_THIS_VERSION_OF_SDL_UnlockMutex
#define SDL_UnlockRWLock IGNORE_THIS_VERSION_OF_SDL_UnlockRWLock
#define SDL_UnlockSurface IGNORE_THIS_VERSION_OF_SDL_UnlockSurface
#define SDL_UnlockTexture IGNORE_THIS_VERSION_OF_SDL_UnlockTexture
#define SDL_UnregisterApp IGNORE_THIS_VERSION_OF_SDL_UnregisterApp
#define SDL_UpdateGamepads IGNORE_THIS_VERSION_OF_SDL_UpdateGamepads
#define SDL_UpdateJoysticks IGNORE_THIS_VERSION_OF_SDL_UpdateJoysticks
#define SDL_UpdateNVTexture IGNORE_THIS_VERSION_OF_SDL_UpdateNVTexture
#define SDL_UpdateSensors IGNORE_THIS_VERSION_OF_SDL_UpdateSensors
#define SDL_UpdateTexture IGNORE_THIS_VERSION_OF_SDL_UpdateTexture
#define SDL_UpdateWindowSurface IGNORE_THIS_VERSION_OF_SDL_UpdateWindowSurface
#define SDL_UpdateWindowSurfaceRects IGNORE_THIS_VERSION_OF_SDL_UpdateWindowSurfaceRects
#define SDL_UpdateYUVTexture IGNORE_THIS_VERSION_OF_SDL_UpdateYUVTexture
#define SDL_Vulkan_CreateSurface IGNORE_THIS_VERSION_OF_SDL_Vulkan_CreateSurface
#define SDL_Vulkan_GetInstanceExtensions IGNORE_THIS_VERSION_OF_SDL_Vulkan_GetInstanceExtensions
#define SDL_Vulkan_GetVkGetInstanceProcAddr IGNORE_THIS_VERSION_OF_SDL_Vulkan_GetVkGetInstanceProcAddr
#define SDL_Vulkan_LoadLibrary IGNORE_THIS_VERSION_OF_SDL_Vulkan_LoadLibrary
#define SDL_Vulkan_UnloadLibrary IGNORE_THIS_VERSION_OF_SDL_Vulkan_UnloadLibrary
#define SDL_WaitCondition IGNORE_THIS_VERSION_OF_SDL_WaitCondition
#define SDL_WaitConditionTimeout IGNORE_THIS_VERSION_OF_SDL_WaitConditionTimeout
#define SDL_WaitEvent IGNORE_THIS_VERSION_OF_SDL_WaitEvent
#define SDL_WaitEventTimeout IGNORE_THIS_VERSION_OF_SDL_WaitEventTimeout
#define SDL_WaitSemaphore IGNORE_THIS_VERSION_OF_SDL_WaitSemaphore
#define SDL_WaitSemaphoreTimeout IGNORE_THIS_VERSION_OF_SDL_WaitSemaphoreTimeout
#define SDL_WaitThread IGNORE_THIS_VERSION_OF_SDL_WaitThread
#define SDL_WarpMouseGlobal IGNORE_THIS_VERSION_OF_SDL_WarpMouseGlobal
#define SDL_WarpMouseInWindow IGNORE_THIS_VERSION_OF_SDL_WarpMouseInWindow
#define SDL_WasInit IGNORE_THIS_VERSION_OF_SDL_WasInit
#define SDL_WinRTGetDeviceFamily IGNORE_THIS_VERSION_OF_SDL_WinRTGetDeviceFamily
#define SDL_WinRTGetFSPathUNICODE IGNORE_THIS_VERSION_OF_SDL_WinRTGetFSPathUNICODE
#define SDL_WinRTGetFSPathUTF8 IGNORE_THIS_VERSION_OF_SDL_WinRTGetFSPathUTF8
#define SDL_WriteU16BE IGNORE_THIS_VERSION_OF_SDL_WriteU16BE
#define SDL_WriteU32BE IGNORE_THIS_VERSION_OF_SDL_WriteU32BE
#define SDL_WriteU64BE IGNORE_THIS_VERSION_OF_SDL_WriteU64BE
#define SDL_WriteU16LE IGNORE_THIS_VERSION_OF_SDL_WriteU16LE
#define SDL_WriteU32LE IGNORE_THIS_VERSION_OF_SDL_WriteU32LE
#define SDL_WriteU64LE IGNORE_THIS_VERSION_OF_SDL_WriteU64LE
#define SDL_WriteU8 IGNORE_THIS_VERSION_OF_SDL_WriteU8
#define SDL_abs IGNORE_THIS_VERSION_OF_SDL_abs
#define SDL_acos IGNORE_THIS_VERSION_OF_SDL_acos
#define SDL_acosf IGNORE_THIS_VERSION_OF_SDL_acosf
#define SDL_aligned_alloc IGNORE_THIS_VERSION_OF_SDL_aligned_alloc
#define SDL_aligned_free IGNORE_THIS_VERSION_OF_SDL_aligned_free
#define SDL_asin IGNORE_THIS_VERSION_OF_SDL_asin
#define SDL_asinf IGNORE_THIS_VERSION_OF_SDL_asinf
#define SDL_asprintf IGNORE_THIS_VERSION_OF_SDL_asprintf
#define SDL_atan IGNORE_THIS_VERSION_OF_SDL_atan
#define SDL_atan2 IGNORE_THIS_VERSION_OF_SDL_atan2
#define SDL_atan2f IGNORE_THIS_VERSION_OF_SDL_atan2f
#define SDL_atanf IGNORE_THIS_VERSION_OF_SDL_atanf
#define SDL_atof IGNORE_THIS_VERSION_OF_SDL_atof
#define SDL_atoi IGNORE_THIS_VERSION_OF_SDL_atoi
#define SDL_bsearch IGNORE_THIS_VERSION_OF_SDL_bsearch
#define SDL_calloc IGNORE_THIS_VERSION_OF_SDL_calloc
#define SDL_ceil IGNORE_THIS_VERSION_OF_SDL_ceil
#define SDL_ceilf IGNORE_THIS_VERSION_OF_SDL_ceilf
#define SDL_copysign IGNORE_THIS_VERSION_OF_SDL_copysign
#define SDL_copysignf IGNORE_THIS_VERSION_OF_SDL_copysignf
#define SDL_cos IGNORE_THIS_VERSION_OF_SDL_cos
#define SDL_cosf IGNORE_THIS_VERSION_OF_SDL_cosf
#define SDL_crc16 IGNORE_THIS_VERSION_OF_SDL_crc16
#define SDL_crc32 IGNORE_THIS_VERSION_OF_SDL_crc32
#define SDL_exp IGNORE_THIS_VERSION_OF_SDL_exp
#define SDL_expf IGNORE_THIS_VERSION_OF_SDL_expf
#define SDL_fabs IGNORE_THIS_VERSION_OF_SDL_fabs
#define SDL_fabsf IGNORE_THIS_VERSION_OF_SDL_fabsf
#define SDL_floor IGNORE_THIS_VERSION_OF_SDL_floor
#define SDL_floorf IGNORE_THIS_VERSION_OF_SDL_floorf
#define SDL_fmod IGNORE_THIS_VERSION_OF_SDL_fmod
#define SDL_fmodf IGNORE_THIS_VERSION_OF_SDL_fmodf
#define SDL_free IGNORE_THIS_VERSION_OF_SDL_free
#define SDL_getenv IGNORE_THIS_VERSION_OF_SDL_getenv
#define SDL_hid_ble_scan IGNORE_THIS_VERSION_OF_SDL_hid_ble_scan
#define SDL_hid_close IGNORE_THIS_VERSION_OF_SDL_hid_close
#define SDL_hid_device_change_count IGNORE_THIS_VERSION_OF_SDL_hid_device_change_count
#define SDL_hid_enumerate IGNORE_THIS_VERSION_OF_SDL_hid_enumerate
#define SDL_hid_exit IGNORE_THIS_VERSION_OF_SDL_hid_exit
#define SDL_hid_free_enumeration IGNORE_THIS_VERSION_OF_SDL_hid_free_enumeration
#define SDL_hid_get_device_info IGNORE_THIS_VERSION_OF_SDL_hid_get_device_info
#define SDL_hid_get_feature_report IGNORE_THIS_VERSION_OF_SDL_hid_get_feature_report
#define SDL_hid_get_indexed_string IGNORE_THIS_VERSION_OF_SDL_hid_get_indexed_string
#define SDL_hid_get_input_report IGNORE_THIS_VERSION_OF_SDL_hid_get_input_report
#define SDL_hid_get_manufacturer_string IGNORE_THIS_VERSION_OF_SDL_hid_get_manufacturer_string
#define SDL_hid_get_product_string IGNORE_THIS_VERSION_OF_SDL_hid_get_product_string
#define SDL_hid_get_report_descriptor IGNORE_THIS_VERSION_OF_SDL_hid_get_report_descriptor
#define SDL_hid_get_serial_number_string IGNORE_THIS_VERSION_OF_SDL_hid_get_serial_number_string
#define SDL_hid_init IGNORE_THIS_VERSION_OF_SDL_hid_init
#define SDL_hid_open IGNORE_THIS_VERSION_OF_SDL_hid_open
#define SDL_hid_open_path IGNORE_THIS_VERSION_OF_SDL_hid_open_path
#define SDL_hid_read IGNORE_THIS_VERSION_OF_SDL_hid_read
#define SDL_hid_read_timeout IGNORE_THIS_VERSION_OF_SDL_hid_read_timeout
#define SDL_hid_send_feature_report IGNORE_THIS_VERSION_OF_SDL_hid_send_feature_report
#define SDL_hid_set_nonblocking IGNORE_THIS_VERSION_OF_SDL_hid_set_nonblocking
#define SDL_hid_write IGNORE_THIS_VERSION_OF_SDL_hid_write
#define SDL_iPhoneSetAnimationCallback IGNORE_THIS_VERSION_OF_SDL_iPhoneSetAnimationCallback
#define SDL_iPhoneSetEventPump IGNORE_THIS_VERSION_OF_SDL_iPhoneSetEventPump
#define SDL_iconv IGNORE_THIS_VERSION_OF_SDL_iconv
#define SDL_iconv_close IGNORE_THIS_VERSION_OF_SDL_iconv_close
#define SDL_iconv_open IGNORE_THIS_VERSION_OF_SDL_iconv_open
#define SDL_iconv_string IGNORE_THIS_VERSION_OF_SDL_iconv_string
#define SDL_isalnum IGNORE_THIS_VERSION_OF_SDL_isalnum
#define SDL_isalpha IGNORE_THIS_VERSION_OF_SDL_isalpha
#define SDL_isblank IGNORE_THIS_VERSION_OF_SDL_isblank
#define SDL_iscntrl IGNORE_THIS_VERSION_OF_SDL_iscntrl
#define SDL_isdigit IGNORE_THIS_VERSION_OF_SDL_isdigit
#define SDL_isgraph IGNORE_THIS_VERSION_OF_SDL_isgraph
#define SDL_islower IGNORE_THIS_VERSION_OF_SDL_islower
#define SDL_isprint IGNORE_THIS_VERSION_OF_SDL_isprint
#define SDL_ispunct IGNORE_THIS_VERSION_OF_SDL_ispunct
#define SDL_isspace IGNORE_THIS_VERSION_OF_SDL_isspace
#define SDL_isupper IGNORE_THIS_VERSION_OF_SDL_isupper
#define SDL_isxdigit IGNORE_THIS_VERSION_OF_SDL_isxdigit
#define SDL_itoa IGNORE_THIS_VERSION_OF_SDL_itoa
#define SDL_lltoa IGNORE_THIS_VERSION_OF_SDL_lltoa
#define SDL_log IGNORE_THIS_VERSION_OF_SDL_log
#define SDL_log10 IGNORE_THIS_VERSION_OF_SDL_log10
#define SDL_log10f IGNORE_THIS_VERSION_OF_SDL_log10f
#define SDL_logf IGNORE_THIS_VERSION_OF_SDL_logf
#define SDL_lround IGNORE_THIS_VERSION_OF_SDL_lround
#define SDL_lroundf IGNORE_THIS_VERSION_OF_SDL_lroundf
#define SDL_ltoa IGNORE_THIS_VERSION_OF_SDL_ltoa
#define SDL_malloc IGNORE_THIS_VERSION_OF_SDL_malloc
#define SDL_memcmp IGNORE_THIS_VERSION_OF_SDL_memcmp
#define SDL_memcpy IGNORE_THIS_VERSION_OF_SDL_memcpy
#define SDL_memmove IGNORE_THIS_VERSION_OF_SDL_memmove
#define SDL_memset IGNORE_THIS_VERSION_OF_SDL_memset
#define SDL_memset4 IGNORE_THIS_VERSION_OF_SDL_memset4
#define SDL_modf IGNORE_THIS_VERSION_OF_SDL_modf
#define SDL_modff IGNORE_THIS_VERSION_OF_SDL_modff
#define SDL_pow IGNORE_THIS_VERSION_OF_SDL_pow
#define SDL_powf IGNORE_THIS_VERSION_OF_SDL_powf
#define SDL_qsort IGNORE_THIS_VERSION_OF_SDL_qsort
#define SDL_realloc IGNORE_THIS_VERSION_OF_SDL_realloc
#define SDL_round IGNORE_THIS_VERSION_OF_SDL_round
#define SDL_roundf IGNORE_THIS_VERSION_OF_SDL_roundf
#define SDL_scalbn IGNORE_THIS_VERSION_OF_SDL_scalbn
#define SDL_scalbnf IGNORE_THIS_VERSION_OF_SDL_scalbnf
#define SDL_setenv IGNORE_THIS_VERSION_OF_SDL_setenv
#define SDL_sin IGNORE_THIS_VERSION_OF_SDL_sin
#define SDL_sinf IGNORE_THIS_VERSION_OF_SDL_sinf
#define SDL_snprintf IGNORE_THIS_VERSION_OF_SDL_snprintf
#define SDL_sqrt IGNORE_THIS_VERSION_OF_SDL_sqrt
#define SDL_sqrtf IGNORE_THIS_VERSION_OF_SDL_sqrtf
#define SDL_sscanf IGNORE_THIS_VERSION_OF_SDL_sscanf
#define SDL_strcasecmp IGNORE_THIS_VERSION_OF_SDL_strcasecmp
#define SDL_strcasestr IGNORE_THIS_VERSION_OF_SDL_strcasestr
#define SDL_strchr IGNORE_THIS_VERSION_OF_SDL_strchr
#define SDL_strcmp IGNORE_THIS_VERSION_OF_SDL_strcmp
#define SDL_strdup IGNORE_THIS_VERSION_OF_SDL_strdup
#define SDL_strlcat IGNORE_THIS_VERSION_OF_SDL_strlcat
#define SDL_strlcpy IGNORE_THIS_VERSION_OF_SDL_strlcpy
#define SDL_strlen IGNORE_THIS_VERSION_OF_SDL_strlen
#define SDL_strlwr IGNORE_THIS_VERSION_OF_SDL_strlwr
#define SDL_strncasecmp IGNORE_THIS_VERSION_OF_SDL_strncasecmp
#define SDL_strncmp IGNORE_THIS_VERSION_OF_SDL_strncmp
#define SDL_strrchr IGNORE_THIS_VERSION_OF_SDL_strrchr
#define SDL_strrev IGNORE_THIS_VERSION_OF_SDL_strrev
#define SDL_strstr IGNORE_THIS_VERSION_OF_SDL_strstr
#define SDL_strtod IGNORE_THIS_VERSION_OF_SDL_strtod
#define SDL_strtok_r IGNORE_THIS_VERSION_OF_SDL_strtok_r
#define SDL_strtol IGNORE_THIS_VERSION_OF_SDL_strtol
#define SDL_strtoll IGNORE_THIS_VERSION_OF_SDL_strtoll
#define SDL_strtoul IGNORE_THIS_VERSION_OF_SDL_strtoul
#define SDL_strtoull IGNORE_THIS_VERSION_OF_SDL_strtoull
#define SDL_strupr IGNORE_THIS_VERSION_OF_SDL_strupr
#define SDL_swprintf IGNORE_THIS_VERSION_OF_SDL_swprintf
#define SDL_tan IGNORE_THIS_VERSION_OF_SDL_tan
#define SDL_tanf IGNORE_THIS_VERSION_OF_SDL_tanf
#define SDL_tolower IGNORE_THIS_VERSION_OF_SDL_tolower
#define SDL_toupper IGNORE_THIS_VERSION_OF_SDL_toupper
#define SDL_trunc IGNORE_THIS_VERSION_OF_SDL_trunc
#define SDL_truncf IGNORE_THIS_VERSION_OF_SDL_truncf
#define SDL_uitoa IGNORE_THIS_VERSION_OF_SDL_uitoa
#define SDL_ulltoa IGNORE_THIS_VERSION_OF_SDL_ulltoa
#define SDL_ultoa IGNORE_THIS_VERSION_OF_SDL_ultoa
#define SDL_utf8strlcpy IGNORE_THIS_VERSION_OF_SDL_utf8strlcpy
#define SDL_utf8strlen IGNORE_THIS_VERSION_OF_SDL_utf8strlen
#define SDL_utf8strnlen IGNORE_THIS_VERSION_OF_SDL_utf8strnlen
#define SDL_vasprintf IGNORE_THIS_VERSION_OF_SDL_vasprintf
#define SDL_vsnprintf IGNORE_THIS_VERSION_OF_SDL_vsnprintf
#define SDL_vsscanf IGNORE_THIS_VERSION_OF_SDL_vsscanf
#define SDL_vswprintf IGNORE_THIS_VERSION_OF_SDL_vswprintf
#define SDL_wcscasecmp IGNORE_THIS_VERSION_OF_SDL_wcscasecmp
#define SDL_wcscmp IGNORE_THIS_VERSION_OF_SDL_wcscmp
#define SDL_wcsdup IGNORE_THIS_VERSION_OF_SDL_wcsdup
#define SDL_wcslcat IGNORE_THIS_VERSION_OF_SDL_wcslcat
#define SDL_wcslcpy IGNORE_THIS_VERSION_OF_SDL_wcslcpy
#define SDL_wcslen IGNORE_THIS_VERSION_OF_SDL_wcslen
#define SDL_wcsncasecmp IGNORE_THIS_VERSION_OF_SDL_wcsncasecmp
#define SDL_wcsncmp IGNORE_THIS_VERSION_OF_SDL_wcsncmp
#define SDL_wcsstr IGNORE_THIS_VERSION_OF_SDL_wcsstr
#define SDL_wcstol IGNORE_THIS_VERSION_OF_SDL_wcstol
#define SDL_ClearClipboardData IGNORE_THIS_VERSION_OF_SDL_ClearClipboardData
#define SDL_GetGamepadInstanceID IGNORE_THIS_VERSION_OF_SDL_GetGamepadInstanceID
#define SDL_GetGamepadPowerLevel IGNORE_THIS_VERSION_OF_SDL_GetGamepadPowerLevel
#define SDL_SetGamepadMapping IGNORE_THIS_VERSION_OF_SDL_SetGamepadMapping
#define SDL_strndup IGNORE_THIS_VERSION_OF_SDL_strndup
#define SDL_GetGamepadTypeFromString IGNORE_THIS_VERSION_OF_SDL_GetGamepadTypeFromString
#define SDL_GetGamepadStringForType IGNORE_THIS_VERSION_OF_SDL_GetGamepadStringForType
#define SDL_GetRealGamepadInstanceType IGNORE_THIS_VERSION_OF_SDL_GetRealGamepadInstanceType
#define SDL_GetRealGamepadType IGNORE_THIS_VERSION_OF_SDL_GetRealGamepadType
#define SDL_wcsnlen IGNORE_THIS_VERSION_OF_SDL_wcsnlen
#define SDL_strnlen IGNORE_THIS_VERSION_OF_SDL_strnlen
#define SDL_AddGamepadMappingsFromFile IGNORE_THIS_VERSION_OF_SDL_AddGamepadMappingsFromFile
#define SDL_ReloadGamepadMappings IGNORE_THIS_VERSION_OF_SDL_ReloadGamepadMappings
#define SDL_GetNumAudioDrivers IGNORE_THIS_VERSION_OF_SDL_GetNumAudioDrivers
#define SDL_GetAudioDriver IGNORE_THIS_VERSION_OF_SDL_GetAudioDriver
#define SDL_GetCurrentAudioDriver IGNORE_THIS_VERSION_OF_SDL_GetCurrentAudioDriver
#define SDL_GetAudioOutputDevices IGNORE_THIS_VERSION_OF_SDL_GetAudioOutputDevices
#define SDL_GetAudioCaptureDevices IGNORE_THIS_VERSION_OF_SDL_GetAudioCaptureDevices
#define SDL_GetAudioDeviceName IGNORE_THIS_VERSION_OF_SDL_GetAudioDeviceName
#define SDL_GetAudioDeviceFormat IGNORE_THIS_VERSION_OF_SDL_GetAudioDeviceFormat
#define SDL_OpenAudioDevice IGNORE_THIS_VERSION_OF_SDL_OpenAudioDevice
#define SDL_CloseAudioDevice IGNORE_THIS_VERSION_OF_SDL_CloseAudioDevice
#define SDL_BindAudioStreams IGNORE_THIS_VERSION_OF_SDL_BindAudioStreams
#define SDL_BindAudioStream IGNORE_THIS_VERSION_OF_SDL_BindAudioStream
#define SDL_UnbindAudioStreams IGNORE_THIS_VERSION_OF_SDL_UnbindAudioStreams
#define SDL_UnbindAudioStream IGNORE_THIS_VERSION_OF_SDL_UnbindAudioStream
#define SDL_CreateAudioStream IGNORE_THIS_VERSION_OF_SDL_CreateAudioStream
#define SDL_GetAudioStreamFormat IGNORE_THIS_VERSION_OF_SDL_GetAudioStreamFormat
#define SDL_SetAudioStreamFormat IGNORE_THIS_VERSION_OF_SDL_SetAudioStreamFormat
#define SDL_PutAudioStreamData IGNORE_THIS_VERSION_OF_SDL_PutAudioStreamData
#define SDL_GetAudioStreamData IGNORE_THIS_VERSION_OF_SDL_GetAudioStreamData
#define SDL_GetAudioStreamAvailable IGNORE_THIS_VERSION_OF_SDL_GetAudioStreamAvailable
#define SDL_FlushAudioStream IGNORE_THIS_VERSION_OF_SDL_FlushAudioStream
#define SDL_ClearAudioStream IGNORE_THIS_VERSION_OF_SDL_ClearAudioStream
#define SDL_LockAudioStream IGNORE_THIS_VERSION_OF_SDL_LockAudioStream
#define SDL_UnlockAudioStream IGNORE_THIS_VERSION_OF_SDL_UnlockAudioStream
#define SDL_SetAudioStreamGetCallback IGNORE_THIS_VERSION_OF_SDL_SetAudioStreamGetCallback
#define SDL_SetAudioStreamPutCallback IGNORE_THIS_VERSION_OF_SDL_SetAudioStreamPutCallback
#define SDL_DestroyAudioStream IGNORE_THIS_VERSION_OF_SDL_DestroyAudioStream
#define SDL_OpenAudioDeviceStream IGNORE_THIS_VERSION_OF_SDL_OpenAudioDeviceStream
#define SDL_LoadWAV_RW IGNORE_THIS_VERSION_OF_SDL_LoadWAV_RW
#define SDL_LoadWAV IGNORE_THIS_VERSION_OF_SDL_LoadWAV
#define SDL_MixAudioFormat IGNORE_THIS_VERSION_OF_SDL_MixAudioFormat
#define SDL_ConvertAudioSamples IGNORE_THIS_VERSION_OF_SDL_ConvertAudioSamples
#define SDL_GetSilenceValueForFormat IGNORE_THIS_VERSION_OF_SDL_GetSilenceValueForFormat
#define SDL_PauseAudioDevice IGNORE_THIS_VERSION_OF_SDL_PauseAudioDevice
#define SDL_ResumeAudioDevice IGNORE_THIS_VERSION_OF_SDL_ResumeAudioDevice
#define SDL_AudioDevicePaused IGNORE_THIS_VERSION_OF_SDL_AudioDevicePaused
#define SDL_GetAudioStreamDevice IGNORE_THIS_VERSION_OF_SDL_GetAudioStreamDevice
#define SDL_ShowWindowSystemMenu IGNORE_THIS_VERSION_OF_SDL_ShowWindowSystemMenu
#define SDL_ReadS16LE IGNORE_THIS_VERSION_OF_SDL_ReadS16LE
#define SDL_ReadS16BE IGNORE_THIS_VERSION_OF_SDL_ReadS16BE
#define SDL_ReadS32LE IGNORE_THIS_VERSION_OF_SDL_ReadS32LE
#define SDL_ReadS32BE IGNORE_THIS_VERSION_OF_SDL_ReadS32BE
#define SDL_ReadS64LE IGNORE_THIS_VERSION_OF_SDL_ReadS64LE
#define SDL_ReadS64BE IGNORE_THIS_VERSION_OF_SDL_ReadS64BE
#define SDL_WriteS16LE IGNORE_THIS_VERSION_OF_SDL_WriteS16LE
#define SDL_WriteS16BE IGNORE_THIS_VERSION_OF_SDL_WriteS16BE
#define SDL_WriteS32LE IGNORE_THIS_VERSION_OF_SDL_WriteS32LE
#define SDL_WriteS32BE IGNORE_THIS_VERSION_OF_SDL_WriteS32BE
#define SDL_WriteS64LE IGNORE_THIS_VERSION_OF_SDL_WriteS64LE
#define SDL_WriteS64BE IGNORE_THIS_VERSION_OF_SDL_WriteS64BE
#define SDL_GDKGetDefaultUser IGNORE_THIS_VERSION_OF_SDL_GDKGetDefaultUser
#define SDL_SetWindowFocusable IGNORE_THIS_VERSION_OF_SDL_SetWindowFocusable
#define SDL_GetAudioStreamFrequencyRatio IGNORE_THIS_VERSION_OF_SDL_GetAudioStreamFrequencyRatio
#define SDL_SetAudioStreamFrequencyRatio IGNORE_THIS_VERSION_OF_SDL_SetAudioStreamFrequencyRatio
#define SDL_SetAudioPostmixCallback IGNORE_THIS_VERSION_OF_SDL_SetAudioPostmixCallback
#define SDL_GetAudioStreamQueued IGNORE_THIS_VERSION_OF_SDL_GetAudioStreamQueued
#define SDL_CreateProperties IGNORE_THIS_VERSION_OF_SDL_CreateProperties
#define SDL_LockProperties IGNORE_THIS_VERSION_OF_SDL_LockProperties
#define SDL_UnlockProperties IGNORE_THIS_VERSION_OF_SDL_UnlockProperties
#define SDL_SetProperty IGNORE_THIS_VERSION_OF_SDL_SetProperty
#define SDL_GetProperty IGNORE_THIS_VERSION_OF_SDL_GetProperty
#define SDL_DestroyProperties IGNORE_THIS_VERSION_OF_SDL_DestroyProperties
#define SDL_GetAudioStreamProperties IGNORE_THIS_VERSION_OF_SDL_GetAudioStreamProperties
#define SDL_GetGamepadProperties IGNORE_THIS_VERSION_OF_SDL_GetGamepadProperties
#define SDL_GetJoystickProperties IGNORE_THIS_VERSION_OF_SDL_GetJoystickProperties
#define SDL_GetRendererProperties IGNORE_THIS_VERSION_OF_SDL_GetRendererProperties
#define SDL_GetTextureProperties IGNORE_THIS_VERSION_OF_SDL_GetTextureProperties
#define SDL_GetRWProperties IGNORE_THIS_VERSION_OF_SDL_GetRWProperties
#define SDL_GetSensorProperties IGNORE_THIS_VERSION_OF_SDL_GetSensorProperties
#define SDL_GetSurfaceProperties IGNORE_THIS_VERSION_OF_SDL_GetSurfaceProperties
#define SDL_GetWindowProperties IGNORE_THIS_VERSION_OF_SDL_GetWindowProperties
#define SDL_ClearProperty IGNORE_THIS_VERSION_OF_SDL_ClearProperty
#define SDL_EnterAppMainCallbacks IGNORE_THIS_VERSION_OF_SDL_EnterAppMainCallbacks
#define SDL_RWprintf IGNORE_THIS_VERSION_OF_SDL_RWprintf
#define SDL_RWvprintf IGNORE_THIS_VERSION_OF_SDL_RWvprintf
#define SDL_AllocateEventMemory IGNORE_THIS_VERSION_OF_SDL_AllocateEventMemory
#define SDL_GetDisplayProperties IGNORE_THIS_VERSION_OF_SDL_GetDisplayProperties
#define SDL_SetPropertyWithCleanup IGNORE_THIS_VERSION_OF_SDL_SetPropertyWithCleanup
#define SDL_SetX11EventHook IGNORE_THIS_VERSION_OF_SDL_SetX11EventHook
#define SDL_GetGlobalProperties IGNORE_THIS_VERSION_OF_SDL_GetGlobalProperties
#define SDL_OpenVideoCapture IGNORE_THIS_VERSION_OF_SDL_OpenVideoCapture
#define SDL_SetVideoCaptureSpec IGNORE_THIS_VERSION_OF_SDL_SetVideoCaptureSpec
#define SDL_OpenVideoCaptureWithSpec IGNORE_THIS_VERSION_OF_SDL_OpenVideoCaptureWithSpec
#define SDL_GetVideoCaptureDeviceName IGNORE_THIS_VERSION_OF_SDL_GetVideoCaptureDeviceName
#define SDL_GetVideoCaptureSpec IGNORE_THIS_VERSION_OF_SDL_GetVideoCaptureSpec
#define SDL_GetVideoCaptureFormat IGNORE_THIS_VERSION_OF_SDL_GetVideoCaptureFormat
#define SDL_GetNumVideoCaptureFormats IGNORE_THIS_VERSION_OF_SDL_GetNumVideoCaptureFormats
#define SDL_GetVideoCaptureFrameSize IGNORE_THIS_VERSION_OF_SDL_GetVideoCaptureFrameSize
#define SDL_GetNumVideoCaptureFrameSizes IGNORE_THIS_VERSION_OF_SDL_GetNumVideoCaptureFrameSizes
#define SDL_GetVideoCaptureStatus IGNORE_THIS_VERSION_OF_SDL_GetVideoCaptureStatus
#define SDL_StartVideoCapture IGNORE_THIS_VERSION_OF_SDL_StartVideoCapture
#define SDL_AcquireVideoCaptureFrame IGNORE_THIS_VERSION_OF_SDL_AcquireVideoCaptureFrame
#define SDL_ReleaseVideoCaptureFrame IGNORE_THIS_VERSION_OF_SDL_ReleaseVideoCaptureFrame
#define SDL_StopVideoCapture IGNORE_THIS_VERSION_OF_SDL_StopVideoCapture
#define SDL_CloseVideoCapture IGNORE_THIS_VERSION_OF_SDL_CloseVideoCapture
#define SDL_GetVideoCaptureDevices IGNORE_THIS_VERSION_OF_SDL_GetVideoCaptureDevices
#define SDL_GetGamepadButtonLabelForType IGNORE_THIS_VERSION_OF_SDL_GetGamepadButtonLabelForType
#define SDL_GetGamepadButtonLabel IGNORE_THIS_VERSION_OF_SDL_GetGamepadButtonLabel
#define SDL_GetPens IGNORE_THIS_VERSION_OF_SDL_GetPens
#define SDL_GetPenStatus IGNORE_THIS_VERSION_OF_SDL_GetPenStatus
#define SDL_GetPenFromGUID IGNORE_THIS_VERSION_OF_SDL_GetPenFromGUID
#define SDL_GetPenGUID IGNORE_THIS_VERSION_OF_SDL_GetPenGUID
#define SDL_PenConnected IGNORE_THIS_VERSION_OF_SDL_PenConnected
#define SDL_GetPenName IGNORE_THIS_VERSION_OF_SDL_GetPenName
#define SDL_GetPenCapabilities IGNORE_THIS_VERSION_OF_SDL_GetPenCapabilities
#define SDL_GetPenType IGNORE_THIS_VERSION_OF_SDL_GetPenType
#define SDL_GetPens IGNORE_THIS_VERSION_OF_SDL_GetPens
#define SDL_GetPenStatus IGNORE_THIS_VERSION_OF_SDL_GetPenStatus
#define SDL_GetPenFromGUID IGNORE_THIS_VERSION_OF_SDL_GetPenFromGUID
#define SDL_GetPenGUID IGNORE_THIS_VERSION_OF_SDL_GetPenGUID
#define SDL_PenConnected IGNORE_THIS_VERSION_OF_SDL_PenConnected
#define SDL_GetPenName IGNORE_THIS_VERSION_OF_SDL_GetPenName
#define SDL_GetPenCapabilities IGNORE_THIS_VERSION_OF_SDL_GetPenCapabilities
#define SDL_GetPenType IGNORE_THIS_VERSION_OF_SDL_GetPenType
#define SDL_SetStringProperty IGNORE_THIS_VERSION_OF_SDL_SetStringProperty
#define SDL_SetNumberProperty IGNORE_THIS_VERSION_OF_SDL_SetNumberProperty
#define SDL_SetFloatProperty IGNORE_THIS_VERSION_OF_SDL_SetFloatProperty
#define SDL_GetPropertyType IGNORE_THIS_VERSION_OF_SDL_GetPropertyType
#define SDL_GetStringProperty IGNORE_THIS_VERSION_OF_SDL_GetStringProperty
#define SDL_GetNumberProperty IGNORE_THIS_VERSION_OF_SDL_GetNumberProperty
#define SDL_GetFloatProperty IGNORE_THIS_VERSION_OF_SDL_GetFloatProperty
#define SDL_EnumerateProperties IGNORE_THIS_VERSION_OF_SDL_EnumerateProperties
#define SDL_SetBooleanProperty IGNORE_THIS_VERSION_OF_SDL_SetBooleanProperty
#define SDL_GetBooleanProperty IGNORE_THIS_VERSION_OF_SDL_GetBooleanProperty
#define SDL_CreateTextureWithProperties IGNORE_THIS_VERSION_OF_SDL_CreateTextureWithProperties
#define SDL_CreateRendererWithProperties IGNORE_THIS_VERSION_OF_SDL_CreateRendererWithProperties
#define SDL_GetGamepadMappings IGNORE_THIS_VERSION_OF_SDL_GetGamepadMappings
#define SDL_GetTouchDevices IGNORE_THIS_VERSION_OF_SDL_GetTouchDevices
#define SDL_GetTouchDeviceName IGNORE_THIS_VERSION_OF_SDL_GetTouchDeviceName
#define SDL_strnstr IGNORE_THIS_VERSION_OF_SDL_strnstr
#define SDL_wcsnstr IGNORE_THIS_VERSION_OF_SDL_wcsnstr
#define SDL_SyncWindow IGNORE_THIS_VERSION_OF_SDL_SyncWindow
#define SDL_GetGamepadSteamHandle IGNORE_THIS_VERSION_OF_SDL_GetGamepadSteamHandle
#define SDL_GetRendererFromTexture IGNORE_THIS_VERSION_OF_SDL_GetRendererFromTexture
#define SDL_GetHaptics IGNORE_THIS_VERSION_OF_SDL_GetHaptics
#define SDL_GetHapticInstanceName IGNORE_THIS_VERSION_OF_SDL_GetHapticInstanceName
#define SDL_GetHapticFromInstanceID IGNORE_THIS_VERSION_OF_SDL_GetHapticFromInstanceID
#define SDL_GetHapticInstanceID IGNORE_THIS_VERSION_OF_SDL_GetHapticInstanceID
#define SDL_GetHapticName IGNORE_THIS_VERSION_OF_SDL_GetHapticName
#define SDL_ReadSurfacePixel IGNORE_THIS_VERSION_OF_SDL_ReadSurfacePixel
#define SDL_FlipSurface IGNORE_THIS_VERSION_OF_SDL_FlipSurface
#define SDL_GetJoystickCaps IGNORE_THIS_VERSION_OF_SDL_GetJoystickCaps
#define SDL_GetGamepadCaps IGNORE_THIS_VERSION_OF_SDL_GetGamepadCaps


#define SDL_FUNCTION_POINTER_IS_VOID_POINTER 1
#define SDL_DISABLE_OLD_NAMES 1
#define __BUILDING_SDL2_COMPAT__ 1

#include <SDL3/SDL.h>
#if !SDL_VERSION_ATLEAST(3,0,0)
#error You need to compile against SDL >= 3.0.0 headers.
#endif

#define SDL_MAIN_HANDLED 1
#include <SDL3/SDL_main.h>
#include <SDL3/SDL_vulkan.h>

#ifdef _WIN32
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN 1
#endif
#include <windows.h>
/* the following macros from Win32 SDK headers are harmful here. */
#undef CreateWindow
#undef CreateThread
#undef CreateSemaphore
#undef CreateMutex
#endif  /* _WIN32 */


#ifdef SDL_AddEventWatch
#undef SDL_AddEventWatch
#endif

#ifdef SDL_AddGamepadMapping
#undef SDL_AddGamepadMapping
#endif

#ifdef SDL_AddGamepadMappingsFromRW
#undef SDL_AddGamepadMappingsFromRW
#endif

#ifdef SDL_AddHintCallback
#undef SDL_AddHintCallback
#endif

#ifdef SDL_AddTimer
#undef SDL_AddTimer
#endif

#ifdef SDL_AndroidBackButton
#undef SDL_AndroidBackButton
#endif

#ifdef SDL_AndroidGetActivity
#undef SDL_AndroidGetActivity
#endif

#ifdef SDL_AndroidGetExternalStoragePath
#undef SDL_AndroidGetExternalStoragePath
#endif

#ifdef SDL_AndroidGetExternalStorageState
#undef SDL_AndroidGetExternalStorageState
#endif

#ifdef SDL_AndroidGetInternalStoragePath
#undef SDL_AndroidGetInternalStoragePath
#endif

#ifdef SDL_AndroidGetJNIEnv
#undef SDL_AndroidGetJNIEnv
#endif

#ifdef SDL_AndroidRequestPermission
#undef SDL_AndroidRequestPermission
#endif

#ifdef SDL_AndroidSendMessage
#undef SDL_AndroidSendMessage
#endif

#ifdef SDL_AndroidShowToast
#undef SDL_AndroidShowToast
#endif

#ifdef SDL_AtomicAdd
#undef SDL_AtomicAdd
#endif

#ifdef SDL_AtomicCompareAndSwap
#undef SDL_AtomicCompareAndSwap
#endif

#ifdef SDL_AtomicCompareAndSwapPointer
#undef SDL_AtomicCompareAndSwapPointer
#endif

#ifdef SDL_AtomicGet
#undef SDL_AtomicGet
#endif

#ifdef SDL_AtomicGetPtr
#undef SDL_AtomicGetPtr
#endif

#ifdef SDL_LockSpinlock
#undef SDL_LockSpinlock
#endif

#ifdef SDL_AtomicSet
#undef SDL_AtomicSet
#endif

#ifdef SDL_AtomicSetPtr
#undef SDL_AtomicSetPtr
#endif

#ifdef SDL_TryLockSpinlock
#undef SDL_TryLockSpinlock
#endif

#ifdef SDL_UnlockSpinlock
#undef SDL_UnlockSpinlock
#endif

#ifdef SDL_AttachVirtualJoystick
#undef SDL_AttachVirtualJoystick
#endif

#ifdef SDL_AttachVirtualJoystickEx
#undef SDL_AttachVirtualJoystickEx
#endif

#ifdef SDL_BlitSurface
#undef SDL_BlitSurface
#endif

#ifdef SDL_BlitSurfaceScaled
#undef SDL_BlitSurfaceScaled
#endif

#ifdef SDL_BlitSurfaceUnchecked
#undef SDL_BlitSurfaceUnchecked
#endif

#ifdef SDL_BlitSurfaceUncheckedScaled
#undef SDL_BlitSurfaceUncheckedScaled
#endif

#ifdef SDL_BroadcastCondition
#undef SDL_BroadcastCondition
#endif

#ifdef SDL_CaptureMouse
#undef SDL_CaptureMouse
#endif

#ifdef SDL_CleanupTLS
#undef SDL_CleanupTLS
#endif

#ifdef SDL_ClearComposition
#undef SDL_ClearComposition
#endif

#ifdef SDL_ClearError
#undef SDL_ClearError
#endif

#ifdef SDL_ClearHints
#undef SDL_ClearHints
#endif

#ifdef SDL_CloseGamepad
#undef SDL_CloseGamepad
#endif

#ifdef SDL_CloseJoystick
#undef SDL_CloseJoystick
#endif

#ifdef SDL_CloseSensor
#undef SDL_CloseSensor
#endif

#ifdef SDL_ComposeCustomBlendMode
#undef SDL_ComposeCustomBlendMode
#endif

#ifdef SDL_ConvertEventToRenderCoordinates
#undef SDL_ConvertEventToRenderCoordinates
#endif

#ifdef SDL_ConvertPixels
#undef SDL_ConvertPixels
#endif

#ifdef SDL_ConvertSurface
#undef SDL_ConvertSurface
#endif

#ifdef SDL_ConvertSurfaceFormat
#undef SDL_ConvertSurfaceFormat
#endif

#ifdef SDL_CreateColorCursor
#undef SDL_CreateColorCursor
#endif

#ifdef SDL_CreateCondition
#undef SDL_CreateCondition
#endif

#ifdef SDL_CreateCursor
#undef SDL_CreateCursor
#endif

#ifdef SDL_CreateMutex
#undef SDL_CreateMutex
#endif

#ifdef SDL_CreatePalette
#undef SDL_CreatePalette
#endif

#ifdef SDL_CreatePixelFormat
#undef SDL_CreatePixelFormat
#endif

#ifdef SDL_CreatePopupWindow
#undef SDL_CreatePopupWindow
#endif

#ifdef SDL_CreateRW
#undef SDL_CreateRW
#endif

#ifdef SDL_CreateRWLock
#undef SDL_CreateRWLock
#endif

#ifdef SDL_CreateRenderer
#undef SDL_CreateRenderer
#endif

#ifdef SDL_CreateSemaphore
#undef SDL_CreateSemaphore
#endif

#ifdef SDL_CreateSoftwareRenderer
#undef SDL_CreateSoftwareRenderer
#endif

#ifdef SDL_CreateSurface
#undef SDL_CreateSurface
#endif

#ifdef SDL_CreateSurfaceFrom
#undef SDL_CreateSurfaceFrom
#endif

#ifdef SDL_CreateSystemCursor
#undef SDL_CreateSystemCursor
#endif

#ifdef SDL_CreateTLS
#undef SDL_CreateTLS
#endif

#ifdef SDL_CreateTexture
#undef SDL_CreateTexture
#endif

#ifdef SDL_CreateTextureFromSurface
#undef SDL_CreateTextureFromSurface
#endif

#ifdef SDL_CreateThread
#undef SDL_CreateThread
#endif

#ifdef SDL_CreateThreadWithStackSize
#undef SDL_CreateThreadWithStackSize
#endif

#ifdef SDL_CreateWindow
#undef SDL_CreateWindow
#endif

#ifdef SDL_CreateWindowAndRenderer
#undef SDL_CreateWindowAndRenderer
#endif

#ifdef SDL_CreateWindowWithProperties
#undef SDL_CreateWindowWithProperties
#endif

#ifdef SDL_CursorVisible
#undef SDL_CursorVisible
#endif

#ifdef SDL_DXGIGetOutputInfo
#undef SDL_DXGIGetOutputInfo
#endif

#ifdef SDL_DelEventWatch
#undef SDL_DelEventWatch
#endif

#ifdef SDL_DelHintCallback
#undef SDL_DelHintCallback
#endif

#ifdef SDL_Delay
#undef SDL_Delay
#endif

#ifdef SDL_DelayNS
#undef SDL_DelayNS
#endif

#ifdef SDL_DestroyCondition
#undef SDL_DestroyCondition
#endif

#ifdef SDL_DestroyCursor
#undef SDL_DestroyCursor
#endif

#ifdef SDL_DestroyMutex
#undef SDL_DestroyMutex
#endif

#ifdef SDL_DestroyPalette
#undef SDL_DestroyPalette
#endif

#ifdef SDL_DestroyPixelFormat
#undef SDL_DestroyPixelFormat
#endif

#ifdef SDL_DestroyRW
#undef SDL_DestroyRW
#endif

#ifdef SDL_DestroyRWLock
#undef SDL_DestroyRWLock
#endif

#ifdef SDL_DestroyRenderer
#undef SDL_DestroyRenderer
#endif

#ifdef SDL_DestroySemaphore
#undef SDL_DestroySemaphore
#endif

#ifdef SDL_DestroySurface
#undef SDL_DestroySurface
#endif

#ifdef SDL_DestroyTexture
#undef SDL_DestroyTexture
#endif

#ifdef SDL_DestroyWindow
#undef SDL_DestroyWindow
#endif

#ifdef SDL_DestroyWindowSurface
#undef SDL_DestroyWindowSurface
#endif

#ifdef SDL_DetachThread
#undef SDL_DetachThread
#endif

#ifdef SDL_DetachVirtualJoystick
#undef SDL_DetachVirtualJoystick
#endif

#ifdef SDL_Direct3D9GetAdapterIndex
#undef SDL_Direct3D9GetAdapterIndex
#endif

#ifdef SDL_DisableScreenSaver
#undef SDL_DisableScreenSaver
#endif

#ifdef SDL_DuplicateSurface
#undef SDL_DuplicateSurface
#endif

#ifdef SDL_EGL_GetCurrentEGLConfig
#undef SDL_EGL_GetCurrentEGLConfig
#endif

#ifdef SDL_EGL_GetCurrentEGLDisplay
#undef SDL_EGL_GetCurrentEGLDisplay
#endif

#ifdef SDL_EGL_GetProcAddress
#undef SDL_EGL_GetProcAddress
#endif

#ifdef SDL_EGL_GetWindowEGLSurface
#undef SDL_EGL_GetWindowEGLSurface
#endif

#ifdef SDL_EGL_SetEGLAttributeCallbacks
#undef SDL_EGL_SetEGLAttributeCallbacks
#endif

#ifdef SDL_EnableScreenSaver
#undef SDL_EnableScreenSaver
#endif

#ifdef SDL_Error
#undef SDL_Error
#endif

#ifdef SDL_EventEnabled
#undef SDL_EventEnabled
#endif

#ifdef SDL_FillSurfaceRect
#undef SDL_FillSurfaceRect
#endif

#ifdef SDL_FillSurfaceRects
#undef SDL_FillSurfaceRects
#endif

#ifdef SDL_FilterEvents
#undef SDL_FilterEvents
#endif

#ifdef SDL_FlashWindow
#undef SDL_FlashWindow
#endif

#ifdef SDL_FlushEvent
#undef SDL_FlushEvent
#endif

#ifdef SDL_FlushEvents
#undef SDL_FlushEvents
#endif

#ifdef SDL_FlushRenderer
#undef SDL_FlushRenderer
#endif

#ifdef SDL_GDKGetTaskQueue
#undef SDL_GDKGetTaskQueue
#endif

#ifdef SDL_GDKSuspendComplete
#undef SDL_GDKSuspendComplete
#endif

#ifdef SDL_GL_CreateContext
#undef SDL_GL_CreateContext
#endif

#ifdef SDL_GL_DeleteContext
#undef SDL_GL_DeleteContext
#endif

#ifdef SDL_GL_ExtensionSupported
#undef SDL_GL_ExtensionSupported
#endif

#ifdef SDL_GL_GetAttribute
#undef SDL_GL_GetAttribute
#endif

#ifdef SDL_GL_GetCurrentContext
#undef SDL_GL_GetCurrentContext
#endif

#ifdef SDL_GL_GetCurrentWindow
#undef SDL_GL_GetCurrentWindow
#endif

#ifdef SDL_GL_GetProcAddress
#undef SDL_GL_GetProcAddress
#endif

#ifdef SDL_GL_GetSwapInterval
#undef SDL_GL_GetSwapInterval
#endif

#ifdef SDL_GL_LoadLibrary
#undef SDL_GL_LoadLibrary
#endif

#ifdef SDL_GL_MakeCurrent
#undef SDL_GL_MakeCurrent
#endif

#ifdef SDL_GL_ResetAttributes
#undef SDL_GL_ResetAttributes
#endif

#ifdef SDL_GL_SetAttribute
#undef SDL_GL_SetAttribute
#endif

#ifdef SDL_GL_SetSwapInterval
#undef SDL_GL_SetSwapInterval
#endif

#ifdef SDL_GL_SwapWindow
#undef SDL_GL_SwapWindow
#endif

#ifdef SDL_GL_UnloadLibrary
#undef SDL_GL_UnloadLibrary
#endif

#ifdef SDL_GUIDFromString
#undef SDL_GUIDFromString
#endif

#ifdef SDL_GUIDToString
#undef SDL_GUIDToString
#endif

#ifdef SDL_GamepadConnected
#undef SDL_GamepadConnected
#endif

#ifdef SDL_GamepadEventsEnabled
#undef SDL_GamepadEventsEnabled
#endif

#ifdef SDL_GamepadHasAxis
#undef SDL_GamepadHasAxis
#endif

#ifdef SDL_GamepadHasButton
#undef SDL_GamepadHasButton
#endif

#ifdef SDL_GamepadHasSensor
#undef SDL_GamepadHasSensor
#endif

#ifdef SDL_GamepadSensorEnabled
#undef SDL_GamepadSensorEnabled
#endif

#ifdef SDL_GetAndroidSDKVersion
#undef SDL_GetAndroidSDKVersion
#endif

#ifdef SDL_GetAssertionHandler
#undef SDL_GetAssertionHandler
#endif

#ifdef SDL_GetAssertionReport
#undef SDL_GetAssertionReport
#endif

#ifdef SDL_GetBasePath
#undef SDL_GetBasePath
#endif

#ifdef SDL_GetCPUCacheLineSize
#undef SDL_GetCPUCacheLineSize
#endif

#ifdef SDL_GetCPUCount
#undef SDL_GetCPUCount
#endif

#ifdef SDL_GetClipboardData
#undef SDL_GetClipboardData
#endif

#ifdef SDL_GetClipboardText
#undef SDL_GetClipboardText
#endif

#ifdef SDL_GetClosestFullscreenDisplayMode
#undef SDL_GetClosestFullscreenDisplayMode
#endif

#ifdef SDL_GetCurrentDisplayMode
#undef SDL_GetCurrentDisplayMode
#endif

#ifdef SDL_GetCurrentDisplayOrientation
#undef SDL_GetCurrentDisplayOrientation
#endif

#ifdef SDL_GetCurrentRenderOutputSize
#undef SDL_GetCurrentRenderOutputSize
#endif

#ifdef SDL_GetCurrentVideoDriver
#undef SDL_GetCurrentVideoDriver
#endif

#ifdef SDL_GetCursor
#undef SDL_GetCursor
#endif

#ifdef SDL_GetDefaultAssertionHandler
#undef SDL_GetDefaultAssertionHandler
#endif

#ifdef SDL_GetDefaultCursor
#undef SDL_GetDefaultCursor
#endif

#ifdef SDL_GetDesktopDisplayMode
#undef SDL_GetDesktopDisplayMode
#endif

#ifdef SDL_GetDisplayBounds
#undef SDL_GetDisplayBounds
#endif

#ifdef SDL_GetDisplayContentScale
#undef SDL_GetDisplayContentScale
#endif

#ifdef SDL_GetDisplayForPoint
#undef SDL_GetDisplayForPoint
#endif

#ifdef SDL_GetDisplayForRect
#undef SDL_GetDisplayForRect
#endif

#ifdef SDL_GetDisplayForWindow
#undef SDL_GetDisplayForWindow
#endif

#ifdef SDL_GetDisplayName
#undef SDL_GetDisplayName
#endif

#ifdef SDL_GetDisplayUsableBounds
#undef SDL_GetDisplayUsableBounds
#endif

#ifdef SDL_GetDisplays
#undef SDL_GetDisplays
#endif

#ifdef SDL_GetError
#undef SDL_GetError
#endif

#ifdef SDL_GetEventFilter
#undef SDL_GetEventFilter
#endif

#ifdef SDL_GetFullscreenDisplayModes
#undef SDL_GetFullscreenDisplayModes
#endif

#ifdef SDL_GetGamepadAppleSFSymbolsNameForAxis
#undef SDL_GetGamepadAppleSFSymbolsNameForAxis
#endif

#ifdef SDL_GetGamepadAppleSFSymbolsNameForButton
#undef SDL_GetGamepadAppleSFSymbolsNameForButton
#endif

#ifdef SDL_GetGamepadAxis
#undef SDL_GetGamepadAxis
#endif

#ifdef SDL_GetGamepadAxisFromString
#undef SDL_GetGamepadAxisFromString
#endif

#ifdef SDL_GetGamepadBindings
#undef SDL_GetGamepadBindings
#endif

#ifdef SDL_GetGamepadButton
#undef SDL_GetGamepadButton
#endif

#ifdef SDL_GetGamepadButtonFromString
#undef SDL_GetGamepadButtonFromString
#endif

#ifdef SDL_GetGamepadFirmwareVersion
#undef SDL_GetGamepadFirmwareVersion
#endif

#ifdef SDL_GetGamepadFromInstanceID
#undef SDL_GetGamepadFromInstanceID
#endif

#ifdef SDL_GetGamepadFromPlayerIndex
#undef SDL_GetGamepadFromPlayerIndex
#endif

#ifdef SDL_GetGamepadInstanceGUID
#undef SDL_GetGamepadInstanceGUID
#endif

#ifdef SDL_GetGamepadInstanceMapping
#undef SDL_GetGamepadInstanceMapping
#endif

#ifdef SDL_GetGamepadInstanceName
#undef SDL_GetGamepadInstanceName
#endif

#ifdef SDL_GetGamepadInstancePath
#undef SDL_GetGamepadInstancePath
#endif

#ifdef SDL_GetGamepadInstancePlayerIndex
#undef SDL_GetGamepadInstancePlayerIndex
#endif

#ifdef SDL_GetGamepadInstanceProduct
#undef SDL_GetGamepadInstanceProduct
#endif

#ifdef SDL_GetGamepadInstanceProductVersion
#undef SDL_GetGamepadInstanceProductVersion
#endif

#ifdef SDL_GetGamepadInstanceType
#undef SDL_GetGamepadInstanceType
#endif

#ifdef SDL_GetGamepadInstanceVendor
#undef SDL_GetGamepadInstanceVendor
#endif

#ifdef SDL_GetGamepadJoystick
#undef SDL_GetGamepadJoystick
#endif

#ifdef SDL_GetGamepadMapping
#undef SDL_GetGamepadMapping
#endif

#ifdef SDL_GetGamepadMappingForGUID
#undef SDL_GetGamepadMappingForGUID
#endif

#ifdef SDL_GetGamepadName
#undef SDL_GetGamepadName
#endif

#ifdef SDL_GetGamepadPath
#undef SDL_GetGamepadPath
#endif

#ifdef SDL_GetGamepadPlayerIndex
#undef SDL_GetGamepadPlayerIndex
#endif

#ifdef SDL_GetGamepadProduct
#undef SDL_GetGamepadProduct
#endif

#ifdef SDL_GetGamepadProductVersion
#undef SDL_GetGamepadProductVersion
#endif

#ifdef SDL_GetGamepadSensorData
#undef SDL_GetGamepadSensorData
#endif

#ifdef SDL_GetGamepadSensorDataRate
#undef SDL_GetGamepadSensorDataRate
#endif

#ifdef SDL_GetGamepadSerial
#undef SDL_GetGamepadSerial
#endif

#ifdef SDL_GetGamepadStringForAxis
#undef SDL_GetGamepadStringForAxis
#endif

#ifdef SDL_GetGamepadStringForButton
#undef SDL_GetGamepadStringForButton
#endif

#ifdef SDL_GetGamepadTouchpadFinger
#undef SDL_GetGamepadTouchpadFinger
#endif

#ifdef SDL_GetGamepadType
#undef SDL_GetGamepadType
#endif

#ifdef SDL_GetGamepadVendor
#undef SDL_GetGamepadVendor
#endif

#ifdef SDL_GetGamepads
#undef SDL_GetGamepads
#endif

#ifdef SDL_GetGlobalMouseState
#undef SDL_GetGlobalMouseState
#endif

#ifdef SDL_GetGrabbedWindow
#undef SDL_GetGrabbedWindow
#endif

#ifdef SDL_GetHint
#undef SDL_GetHint
#endif

#ifdef SDL_GetHintBoolean
#undef SDL_GetHintBoolean
#endif

#ifdef SDL_GetJoystickAxis
#undef SDL_GetJoystickAxis
#endif

#ifdef SDL_GetJoystickAxisInitialState
#undef SDL_GetJoystickAxisInitialState
#endif

#ifdef SDL_GetJoystickButton
#undef SDL_GetJoystickButton
#endif

#ifdef SDL_GetJoystickFirmwareVersion
#undef SDL_GetJoystickFirmwareVersion
#endif

#ifdef SDL_GetJoystickFromInstanceID
#undef SDL_GetJoystickFromInstanceID
#endif

#ifdef SDL_GetJoystickFromPlayerIndex
#undef SDL_GetJoystickFromPlayerIndex
#endif

#ifdef SDL_GetJoystickGUID
#undef SDL_GetJoystickGUID
#endif

#ifdef SDL_GetJoystickGUIDFromString
#undef SDL_GetJoystickGUIDFromString
#endif

#ifdef SDL_GetJoystickGUIDInfo
#undef SDL_GetJoystickGUIDInfo
#endif

#ifdef SDL_GetJoystickGUIDString
#undef SDL_GetJoystickGUIDString
#endif

#ifdef SDL_GetJoystickHat
#undef SDL_GetJoystickHat
#endif

#ifdef SDL_GetJoystickInstanceGUID
#undef SDL_GetJoystickInstanceGUID
#endif

#ifdef SDL_GetJoystickInstanceID
#undef SDL_GetJoystickInstanceID
#endif

#ifdef SDL_GetJoystickInstanceName
#undef SDL_GetJoystickInstanceName
#endif

#ifdef SDL_GetJoystickInstancePath
#undef SDL_GetJoystickInstancePath
#endif

#ifdef SDL_GetJoystickInstancePlayerIndex
#undef SDL_GetJoystickInstancePlayerIndex
#endif

#ifdef SDL_GetJoystickInstanceProduct
#undef SDL_GetJoystickInstanceProduct
#endif

#ifdef SDL_GetJoystickInstanceProductVersion
#undef SDL_GetJoystickInstanceProductVersion
#endif

#ifdef SDL_GetJoystickInstanceType
#undef SDL_GetJoystickInstanceType
#endif

#ifdef SDL_GetJoystickInstanceVendor
#undef SDL_GetJoystickInstanceVendor
#endif

#ifdef SDL_GetJoystickName
#undef SDL_GetJoystickName
#endif

#ifdef SDL_GetJoystickPath
#undef SDL_GetJoystickPath
#endif

#ifdef SDL_GetJoystickPlayerIndex
#undef SDL_GetJoystickPlayerIndex
#endif

#ifdef SDL_GetJoystickPowerLevel
#undef SDL_GetJoystickPowerLevel
#endif

#ifdef SDL_GetJoystickProduct
#undef SDL_GetJoystickProduct
#endif

#ifdef SDL_GetJoystickProductVersion
#undef SDL_GetJoystickProductVersion
#endif

#ifdef SDL_GetJoystickSerial
#undef SDL_GetJoystickSerial
#endif

#ifdef SDL_GetJoystickType
#undef SDL_GetJoystickType
#endif

#ifdef SDL_GetJoystickVendor
#undef SDL_GetJoystickVendor
#endif

#ifdef SDL_GetJoysticks
#undef SDL_GetJoysticks
#endif

#ifdef SDL_GetKeyFromName
#undef SDL_GetKeyFromName
#endif

#ifdef SDL_GetKeyFromScancode
#undef SDL_GetKeyFromScancode
#endif

#ifdef SDL_GetKeyName
#undef SDL_GetKeyName
#endif

#ifdef SDL_GetKeyboardFocus
#undef SDL_GetKeyboardFocus
#endif

#ifdef SDL_GetKeyboardState
#undef SDL_GetKeyboardState
#endif

#ifdef SDL_GetMasksForPixelFormatEnum
#undef SDL_GetMasksForPixelFormatEnum
#endif

#ifdef SDL_GetMemoryFunctions
#undef SDL_GetMemoryFunctions
#endif

#ifdef SDL_GetModState
#undef SDL_GetModState
#endif

#ifdef SDL_GetMouseFocus
#undef SDL_GetMouseFocus
#endif

#ifdef SDL_GetMouseState
#undef SDL_GetMouseState
#endif

#ifdef SDL_GetNaturalDisplayOrientation
#undef SDL_GetNaturalDisplayOrientation
#endif

#ifdef SDL_GetNumAllocations
#undef SDL_GetNumAllocations
#endif

#ifdef SDL_GetNumGamepadTouchpadFingers
#undef SDL_GetNumGamepadTouchpadFingers
#endif

#ifdef SDL_GetNumGamepadTouchpads
#undef SDL_GetNumGamepadTouchpads
#endif

#ifdef SDL_GetNumJoystickAxes
#undef SDL_GetNumJoystickAxes
#endif

#ifdef SDL_GetNumJoystickButtons
#undef SDL_GetNumJoystickButtons
#endif

#ifdef SDL_GetNumJoystickHats
#undef SDL_GetNumJoystickHats
#endif

#ifdef SDL_GetNumRenderDrivers
#undef SDL_GetNumRenderDrivers
#endif

#ifdef SDL_GetNumTouchFingers
#undef SDL_GetNumTouchFingers
#endif

#ifdef SDL_GetNumVideoDrivers
#undef SDL_GetNumVideoDrivers
#endif

#ifdef SDL_GetOriginalMemoryFunctions
#undef SDL_GetOriginalMemoryFunctions
#endif

#ifdef SDL_GetUserFolder
#undef SDL_GetUserFolder
#endif

#ifdef SDL_GetPerformanceCounter
#undef SDL_GetPerformanceCounter
#endif

#ifdef SDL_GetPerformanceFrequency
#undef SDL_GetPerformanceFrequency
#endif

#ifdef SDL_GetPixelFormatEnumForMasks
#undef SDL_GetPixelFormatEnumForMasks
#endif

#ifdef SDL_GetPixelFormatName
#undef SDL_GetPixelFormatName
#endif

#ifdef SDL_GetPlatform
#undef SDL_GetPlatform
#endif

#ifdef SDL_GetPowerInfo
#undef SDL_GetPowerInfo
#endif

#ifdef SDL_GetPrefPath
#undef SDL_GetPrefPath
#endif

#ifdef SDL_GetPreferredLocales
#undef SDL_GetPreferredLocales
#endif

#ifdef SDL_GetPrimaryDisplay
#undef SDL_GetPrimaryDisplay
#endif

#ifdef SDL_GetPrimarySelectionText
#undef SDL_GetPrimarySelectionText
#endif

#ifdef SDL_GetRGB
#undef SDL_GetRGB
#endif

#ifdef SDL_GetRGBA
#undef SDL_GetRGBA
#endif

#ifdef SDL_GetRectAndLineIntersection
#undef SDL_GetRectAndLineIntersection
#endif

#ifdef SDL_GetRectAndLineIntersectionFloat
#undef SDL_GetRectAndLineIntersectionFloat
#endif

#ifdef SDL_GetRectEnclosingPoints
#undef SDL_GetRectEnclosingPoints
#endif

#ifdef SDL_GetRectEnclosingPointsFloat
#undef SDL_GetRectEnclosingPointsFloat
#endif

#ifdef SDL_GetRectIntersection
#undef SDL_GetRectIntersection
#endif

#ifdef SDL_GetRectIntersectionFloat
#undef SDL_GetRectIntersectionFloat
#endif

#ifdef SDL_GetRectUnion
#undef SDL_GetRectUnion
#endif

#ifdef SDL_GetRectUnionFloat
#undef SDL_GetRectUnionFloat
#endif

#ifdef SDL_GetRelativeMouseMode
#undef SDL_GetRelativeMouseMode
#endif

#ifdef SDL_GetRelativeMouseState
#undef SDL_GetRelativeMouseState
#endif

#ifdef SDL_GetRenderClipRect
#undef SDL_GetRenderClipRect
#endif

#ifdef SDL_GetRenderDrawBlendMode
#undef SDL_GetRenderDrawBlendMode
#endif

#ifdef SDL_GetRenderDrawColor
#undef SDL_GetRenderDrawColor
#endif

#ifdef SDL_GetRenderDriver
#undef SDL_GetRenderDriver
#endif

#ifdef SDL_GetRenderLogicalPresentation
#undef SDL_GetRenderLogicalPresentation
#endif

#ifdef SDL_GetRenderMetalCommandEncoder
#undef SDL_GetRenderMetalCommandEncoder
#endif

#ifdef SDL_GetRenderMetalLayer
#undef SDL_GetRenderMetalLayer
#endif

#ifdef SDL_GetRenderOutputSize
#undef SDL_GetRenderOutputSize
#endif

#ifdef SDL_GetRenderScale
#undef SDL_GetRenderScale
#endif

#ifdef SDL_GetRenderTarget
#undef SDL_GetRenderTarget
#endif

#ifdef SDL_GetRenderVSync
#undef SDL_GetRenderVSync
#endif

#ifdef SDL_GetRenderViewport
#undef SDL_GetRenderViewport
#endif

#ifdef SDL_GetRenderWindow
#undef SDL_GetRenderWindow
#endif

#ifdef SDL_GetRenderer
#undef SDL_GetRenderer
#endif

#ifdef SDL_GetRendererInfo
#undef SDL_GetRendererInfo
#endif

#ifdef SDL_GetRevision
#undef SDL_GetRevision
#endif

#ifdef SDL_GetScancodeFromKey
#undef SDL_GetScancodeFromKey
#endif

#ifdef SDL_GetScancodeFromName
#undef SDL_GetScancodeFromName
#endif

#ifdef SDL_GetScancodeName
#undef SDL_GetScancodeName
#endif

#ifdef SDL_GetSemaphoreValue
#undef SDL_GetSemaphoreValue
#endif

#ifdef SDL_GetSensorData
#undef SDL_GetSensorData
#endif

#ifdef SDL_GetSensorFromInstanceID
#undef SDL_GetSensorFromInstanceID
#endif

#ifdef SDL_GetSensorInstanceID
#undef SDL_GetSensorInstanceID
#endif

#ifdef SDL_GetSensorInstanceName
#undef SDL_GetSensorInstanceName
#endif

#ifdef SDL_GetSensorInstanceNonPortableType
#undef SDL_GetSensorInstanceNonPortableType
#endif

#ifdef SDL_GetSensorInstanceType
#undef SDL_GetSensorInstanceType
#endif

#ifdef SDL_GetSensorName
#undef SDL_GetSensorName
#endif

#ifdef SDL_GetSensorNonPortableType
#undef SDL_GetSensorNonPortableType
#endif

#ifdef SDL_GetSensorType
#undef SDL_GetSensorType
#endif

#ifdef SDL_GetSensors
#undef SDL_GetSensors
#endif

#ifdef SDL_GetSurfaceAlphaMod
#undef SDL_GetSurfaceAlphaMod
#endif

#ifdef SDL_GetSurfaceBlendMode
#undef SDL_GetSurfaceBlendMode
#endif

#ifdef SDL_GetSurfaceClipRect
#undef SDL_GetSurfaceClipRect
#endif

#ifdef SDL_GetSurfaceColorKey
#undef SDL_GetSurfaceColorKey
#endif

#ifdef SDL_GetSurfaceColorMod
#undef SDL_GetSurfaceColorMod
#endif

#ifdef SDL_GetSystemRAM
#undef SDL_GetSystemRAM
#endif

#ifdef SDL_GetSystemTheme
#undef SDL_GetSystemTheme
#endif

#ifdef SDL_GetTLS
#undef SDL_GetTLS
#endif

#ifdef SDL_GetTextureAlphaMod
#undef SDL_GetTextureAlphaMod
#endif

#ifdef SDL_GetTextureBlendMode
#undef SDL_GetTextureBlendMode
#endif

#ifdef SDL_GetTextureColorMod
#undef SDL_GetTextureColorMod
#endif

#ifdef SDL_GetTextureScaleMode
#undef SDL_GetTextureScaleMode
#endif

#ifdef SDL_GetThreadID
#undef SDL_GetThreadID
#endif

#ifdef SDL_GetThreadName
#undef SDL_GetThreadName
#endif

#ifdef SDL_GetTicks
#undef SDL_GetTicks
#endif

#ifdef SDL_GetTicksNS
#undef SDL_GetTicksNS
#endif

#ifdef SDL_GetTouchDeviceType
#undef SDL_GetTouchDeviceType
#endif

#ifdef SDL_GetTouchFinger
#undef SDL_GetTouchFinger
#endif

#ifdef SDL_GetVersion
#undef SDL_GetVersion
#endif

#ifdef SDL_GetVideoDriver
#undef SDL_GetVideoDriver
#endif

#ifdef SDL_GetWindowBordersSize
#undef SDL_GetWindowBordersSize
#endif

#ifdef SDL_GetWindowDisplayScale
#undef SDL_GetWindowDisplayScale
#endif

#ifdef SDL_GetWindowFlags
#undef SDL_GetWindowFlags
#endif

#ifdef SDL_GetWindowFromID
#undef SDL_GetWindowFromID
#endif

#ifdef SDL_GetWindowFullscreenMode
#undef SDL_GetWindowFullscreenMode
#endif

#ifdef SDL_GetWindowGrab
#undef SDL_GetWindowGrab
#endif

#ifdef SDL_GetWindowICCProfile
#undef SDL_GetWindowICCProfile
#endif

#ifdef SDL_GetWindowID
#undef SDL_GetWindowID
#endif

#ifdef SDL_GetWindowKeyboardGrab
#undef SDL_GetWindowKeyboardGrab
#endif

#ifdef SDL_GetWindowMaximumSize
#undef SDL_GetWindowMaximumSize
#endif

#ifdef SDL_GetWindowMinimumSize
#undef SDL_GetWindowMinimumSize
#endif

#ifdef SDL_GetWindowMouseGrab
#undef SDL_GetWindowMouseGrab
#endif

#ifdef SDL_GetWindowMouseRect
#undef SDL_GetWindowMouseRect
#endif

#ifdef SDL_GetWindowOpacity
#undef SDL_GetWindowOpacity
#endif

#ifdef SDL_GetWindowParent
#undef SDL_GetWindowParent
#endif

#ifdef SDL_GetWindowPixelDensity
#undef SDL_GetWindowPixelDensity
#endif

#ifdef SDL_GetWindowPixelFormat
#undef SDL_GetWindowPixelFormat
#endif

#ifdef SDL_GetWindowPosition
#undef SDL_GetWindowPosition
#endif

#ifdef SDL_GetWindowSize
#undef SDL_GetWindowSize
#endif

#ifdef SDL_GetWindowSizeInPixels
#undef SDL_GetWindowSizeInPixels
#endif

#ifdef SDL_GetWindowSurface
#undef SDL_GetWindowSurface
#endif

#ifdef SDL_GetWindowTitle
#undef SDL_GetWindowTitle
#endif

#ifdef SDL_GetYUVConversionMode
#undef SDL_GetYUVConversionMode
#endif

#ifdef SDL_GetYUVConversionModeForResolution
#undef SDL_GetYUVConversionModeForResolution
#endif

#ifdef SDL_CloseHaptic
#undef SDL_CloseHaptic
#endif

#ifdef SDL_DestroyHapticEffect
#undef SDL_DestroyHapticEffect
#endif

#ifdef SDL_HapticEffectSupported
#undef SDL_HapticEffectSupported
#endif

#ifdef SDL_GetHapticEffectStatus
#undef SDL_GetHapticEffectStatus
#endif

#ifdef SDL_CreateHapticEffect
#undef SDL_CreateHapticEffect
#endif

#ifdef SDL_GetNumHapticAxes
#undef SDL_GetNumHapticAxes
#endif

#ifdef SDL_GetMaxHapticEffects
#undef SDL_GetMaxHapticEffects
#endif

#ifdef SDL_GetMaxHapticEffectsPlaying
#undef SDL_GetMaxHapticEffectsPlaying
#endif

#ifdef SDL_OpenHaptic
#undef SDL_OpenHaptic
#endif

#ifdef SDL_OpenHapticFromJoystick
#undef SDL_OpenHapticFromJoystick
#endif

#ifdef SDL_OpenHapticFromMouse
#undef SDL_OpenHapticFromMouse
#endif

#ifdef SDL_PauseHaptic
#undef SDL_PauseHaptic
#endif

#ifdef SDL_GetHapticFeatures
#undef SDL_GetHapticFeatures
#endif

#ifdef SDL_InitHapticRumble
#undef SDL_InitHapticRumble
#endif

#ifdef SDL_PlayHapticRumble
#undef SDL_PlayHapticRumble
#endif

#ifdef SDL_StopHapticRumble
#undef SDL_StopHapticRumble
#endif

#ifdef SDL_HapticRumbleSupported
#undef SDL_HapticRumbleSupported
#endif

#ifdef SDL_RunHapticEffect
#undef SDL_RunHapticEffect
#endif

#ifdef SDL_SetHapticAutocenter
#undef SDL_SetHapticAutocenter
#endif

#ifdef SDL_SetHapticGain
#undef SDL_SetHapticGain
#endif

#ifdef SDL_StopHapticEffects
#undef SDL_StopHapticEffects
#endif

#ifdef SDL_StopHapticEffect
#undef SDL_StopHapticEffect
#endif

#ifdef SDL_ResumeHaptic
#undef SDL_ResumeHaptic
#endif

#ifdef SDL_UpdateHapticEffect
#undef SDL_UpdateHapticEffect
#endif

#ifdef SDL_HasARMSIMD
#undef SDL_HasARMSIMD
#endif

#ifdef SDL_HasAVX
#undef SDL_HasAVX
#endif

#ifdef SDL_HasAVX2
#undef SDL_HasAVX2
#endif

#ifdef SDL_HasAVX512F
#undef SDL_HasAVX512F
#endif

#ifdef SDL_HasAltiVec
#undef SDL_HasAltiVec
#endif

#ifdef SDL_HasClipboardData
#undef SDL_HasClipboardData
#endif

#ifdef SDL_HasClipboardText
#undef SDL_HasClipboardText
#endif

#ifdef SDL_HasEvent
#undef SDL_HasEvent
#endif

#ifdef SDL_HasEvents
#undef SDL_HasEvents
#endif

#ifdef SDL_HasLASX
#undef SDL_HasLASX
#endif

#ifdef SDL_HasLSX
#undef SDL_HasLSX
#endif

#ifdef SDL_HasMMX
#undef SDL_HasMMX
#endif

#ifdef SDL_HasNEON
#undef SDL_HasNEON
#endif

#ifdef SDL_HasPrimarySelectionText
#undef SDL_HasPrimarySelectionText
#endif

#ifdef SDL_HasRectIntersection
#undef SDL_HasRectIntersection
#endif

#ifdef SDL_HasRectIntersectionFloat
#undef SDL_HasRectIntersectionFloat
#endif

#ifdef SDL_HasSSE
#undef SDL_HasSSE
#endif

#ifdef SDL_HasSSE2
#undef SDL_HasSSE2
#endif

#ifdef SDL_HasSSE3
#undef SDL_HasSSE3
#endif

#ifdef SDL_HasSSE41
#undef SDL_HasSSE41
#endif

#ifdef SDL_HasSSE42
#undef SDL_HasSSE42
#endif

#ifdef SDL_HasScreenKeyboardSupport
#undef SDL_HasScreenKeyboardSupport
#endif

#ifdef SDL_HasWindowSurface
#undef SDL_HasWindowSurface
#endif

#ifdef SDL_HideCursor
#undef SDL_HideCursor
#endif

#ifdef SDL_HideWindow
#undef SDL_HideWindow
#endif

#ifdef SDL_Init
#undef SDL_Init
#endif

#ifdef SDL_InitSubSystem
#undef SDL_InitSubSystem
#endif

#ifdef SDL_IsAndroidTV
#undef SDL_IsAndroidTV
#endif

#ifdef SDL_IsChromebook
#undef SDL_IsChromebook
#endif

#ifdef SDL_IsDeXMode
#undef SDL_IsDeXMode
#endif

#ifdef SDL_IsGamepad
#undef SDL_IsGamepad
#endif

#ifdef SDL_IsJoystickVirtual
#undef SDL_IsJoystickVirtual
#endif

#ifdef SDL_IsTablet
#undef SDL_IsTablet
#endif

#ifdef SDL_JoystickConnected
#undef SDL_JoystickConnected
#endif

#ifdef SDL_JoystickEventsEnabled
#undef SDL_JoystickEventsEnabled
#endif

#ifdef SDL_JoystickHasLED
#undef SDL_JoystickHasLED
#endif

#ifdef SDL_JoystickHasRumble
#undef SDL_JoystickHasRumble
#endif

#ifdef SDL_JoystickHasRumbleTriggers
#undef SDL_JoystickHasRumbleTriggers
#endif

#ifdef SDL_IsJoystickHaptic
#undef SDL_IsJoystickHaptic
#endif

#ifdef SDL_LinuxSetThreadPriority
#undef SDL_LinuxSetThreadPriority
#endif

#ifdef SDL_LinuxSetThreadPriorityAndPolicy
#undef SDL_LinuxSetThreadPriorityAndPolicy
#endif

#ifdef SDL_LoadBMP
#undef SDL_LoadBMP
#endif

#ifdef SDL_LoadBMP_RW
#undef SDL_LoadBMP_RW
#endif

#ifdef SDL_LoadFile
#undef SDL_LoadFile
#endif

#ifdef SDL_LoadFile_RW
#undef SDL_LoadFile_RW
#endif

#ifdef SDL_LoadFunction
#undef SDL_LoadFunction
#endif

#ifdef SDL_LoadObject
#undef SDL_LoadObject
#endif

#ifdef SDL_LockJoysticks
#undef SDL_LockJoysticks
#endif

#ifdef SDL_LockMutex
#undef SDL_LockMutex
#endif

#ifdef SDL_LockRWLockForReading
#undef SDL_LockRWLockForReading
#endif

#ifdef SDL_LockRWLockForWriting
#undef SDL_LockRWLockForWriting
#endif

#ifdef SDL_LockSurface
#undef SDL_LockSurface
#endif

#ifdef SDL_LockTexture
#undef SDL_LockTexture
#endif

#ifdef SDL_LockTextureToSurface
#undef SDL_LockTextureToSurface
#endif

#ifdef SDL_Log
#undef SDL_Log
#endif

#ifdef SDL_LogCritical
#undef SDL_LogCritical
#endif

#ifdef SDL_LogDebug
#undef SDL_LogDebug
#endif

#ifdef SDL_LogError
#undef SDL_LogError
#endif

#ifdef SDL_LogGetOutputFunction
#undef SDL_LogGetOutputFunction
#endif

#ifdef SDL_LogGetPriority
#undef SDL_LogGetPriority
#endif

#ifdef SDL_LogInfo
#undef SDL_LogInfo
#endif

#ifdef SDL_LogMessage
#undef SDL_LogMessage
#endif

#ifdef SDL_LogMessageV
#undef SDL_LogMessageV
#endif

#ifdef SDL_LogResetPriorities
#undef SDL_LogResetPriorities
#endif

#ifdef SDL_LogSetAllPriority
#undef SDL_LogSetAllPriority
#endif

#ifdef SDL_LogSetOutputFunction
#undef SDL_LogSetOutputFunction
#endif

#ifdef SDL_LogSetPriority
#undef SDL_LogSetPriority
#endif

#ifdef SDL_LogVerbose
#undef SDL_LogVerbose
#endif

#ifdef SDL_LogWarn
#undef SDL_LogWarn
#endif

#ifdef SDL_MapRGB
#undef SDL_MapRGB
#endif

#ifdef SDL_MapRGBA
#undef SDL_MapRGBA
#endif

#ifdef SDL_MaximizeWindow
#undef SDL_MaximizeWindow
#endif

#ifdef SDL_MemoryBarrierAcquireFunction
#undef SDL_MemoryBarrierAcquireFunction
#endif

#ifdef SDL_MemoryBarrierReleaseFunction
#undef SDL_MemoryBarrierReleaseFunction
#endif

#ifdef SDL_Metal_CreateView
#undef SDL_Metal_CreateView
#endif

#ifdef SDL_Metal_DestroyView
#undef SDL_Metal_DestroyView
#endif

#ifdef SDL_Metal_GetLayer
#undef SDL_Metal_GetLayer
#endif

#ifdef SDL_MinimizeWindow
#undef SDL_MinimizeWindow
#endif

#ifdef SDL_IsMouseHaptic
#undef SDL_IsMouseHaptic
#endif

#ifdef SDL_OnApplicationDidBecomeActive
#undef SDL_OnApplicationDidBecomeActive
#endif

#ifdef SDL_OnApplicationDidChangeStatusBarOrientation
#undef SDL_OnApplicationDidChangeStatusBarOrientation
#endif

#ifdef SDL_OnApplicationDidEnterBackground
#undef SDL_OnApplicationDidEnterBackground
#endif

#ifdef SDL_OnApplicationDidReceiveMemoryWarning
#undef SDL_OnApplicationDidReceiveMemoryWarning
#endif

#ifdef SDL_OnApplicationWillEnterForeground
#undef SDL_OnApplicationWillEnterForeground
#endif

#ifdef SDL_OnApplicationWillResignActive
#undef SDL_OnApplicationWillResignActive
#endif

#ifdef SDL_OnApplicationWillTerminate
#undef SDL_OnApplicationWillTerminate
#endif

#ifdef SDL_OpenGamepad
#undef SDL_OpenGamepad
#endif

#ifdef SDL_OpenJoystick
#undef SDL_OpenJoystick
#endif

#ifdef SDL_OpenSensor
#undef SDL_OpenSensor
#endif

#ifdef SDL_OpenURL
#undef SDL_OpenURL
#endif

#ifdef SDL_PeepEvents
#undef SDL_PeepEvents
#endif

#ifdef SDL_PollEvent
#undef SDL_PollEvent
#endif

#ifdef SDL_PostSemaphore
#undef SDL_PostSemaphore
#endif

#ifdef SDL_PremultiplyAlpha
#undef SDL_PremultiplyAlpha
#endif

#ifdef SDL_PumpEvents
#undef SDL_PumpEvents
#endif

#ifdef SDL_PushEvent
#undef SDL_PushEvent
#endif

#ifdef SDL_QueryTexture
#undef SDL_QueryTexture
#endif

#ifdef SDL_Quit
#undef SDL_Quit
#endif

#ifdef SDL_QuitSubSystem
#undef SDL_QuitSubSystem
#endif

#ifdef SDL_RWFromConstMem
#undef SDL_RWFromConstMem
#endif

#ifdef SDL_RWFromFile
#undef SDL_RWFromFile
#endif

#ifdef SDL_RWFromMem
#undef SDL_RWFromMem
#endif

#ifdef SDL_RWclose
#undef SDL_RWclose
#endif

#ifdef SDL_RWread
#undef SDL_RWread
#endif

#ifdef SDL_RWseek
#undef SDL_RWseek
#endif

#ifdef SDL_RWsize
#undef SDL_RWsize
#endif

#ifdef SDL_RWtell
#undef SDL_RWtell
#endif

#ifdef SDL_RWwrite
#undef SDL_RWwrite
#endif

#ifdef SDL_RaiseWindow
#undef SDL_RaiseWindow
#endif

#ifdef SDL_ReadU16BE
#undef SDL_ReadU16BE
#endif

#ifdef SDL_ReadU32BE
#undef SDL_ReadU32BE
#endif

#ifdef SDL_ReadU64BE
#undef SDL_ReadU64BE
#endif

#ifdef SDL_ReadU16LE
#undef SDL_ReadU16LE
#endif

#ifdef SDL_ReadU32LE
#undef SDL_ReadU32LE
#endif

#ifdef SDL_ReadU64LE
#undef SDL_ReadU64LE
#endif

#ifdef SDL_ReadU8
#undef SDL_ReadU8
#endif

#ifdef SDL_RegisterApp
#undef SDL_RegisterApp
#endif

#ifdef SDL_RegisterEvents
#undef SDL_RegisterEvents
#endif

#ifdef SDL_RemoveTimer
#undef SDL_RemoveTimer
#endif

#ifdef SDL_RenderClear
#undef SDL_RenderClear
#endif

#ifdef SDL_RenderClipEnabled
#undef SDL_RenderClipEnabled
#endif

#ifdef SDL_RenderCoordinatesFromWindow
#undef SDL_RenderCoordinatesFromWindow
#endif

#ifdef SDL_RenderCoordinatesToWindow
#undef SDL_RenderCoordinatesToWindow
#endif

#ifdef SDL_RenderFillRect
#undef SDL_RenderFillRect
#endif

#ifdef SDL_RenderFillRects
#undef SDL_RenderFillRects
#endif

#ifdef SDL_RenderGeometry
#undef SDL_RenderGeometry
#endif

#ifdef SDL_RenderGeometryRaw
#undef SDL_RenderGeometryRaw
#endif

#ifdef SDL_RenderLine
#undef SDL_RenderLine
#endif

#ifdef SDL_RenderLines
#undef SDL_RenderLines
#endif

#ifdef SDL_RenderPoint
#undef SDL_RenderPoint
#endif

#ifdef SDL_RenderPoints
#undef SDL_RenderPoints
#endif

#ifdef SDL_RenderPresent
#undef SDL_RenderPresent
#endif

#ifdef SDL_RenderReadPixels
#undef SDL_RenderReadPixels
#endif

#ifdef SDL_RenderRect
#undef SDL_RenderRect
#endif

#ifdef SDL_RenderRects
#undef SDL_RenderRects
#endif

#ifdef SDL_RenderTexture
#undef SDL_RenderTexture
#endif

#ifdef SDL_RenderTextureRotated
#undef SDL_RenderTextureRotated
#endif

#ifdef SDL_ReportAssertion
#undef SDL_ReportAssertion
#endif

#ifdef SDL_ResetAssertionReport
#undef SDL_ResetAssertionReport
#endif

#ifdef SDL_ResetHint
#undef SDL_ResetHint
#endif

#ifdef SDL_ResetHints
#undef SDL_ResetHints
#endif

#ifdef SDL_ResetKeyboard
#undef SDL_ResetKeyboard
#endif

#ifdef SDL_RestoreWindow
#undef SDL_RestoreWindow
#endif

#ifdef SDL_RumbleGamepad
#undef SDL_RumbleGamepad
#endif

#ifdef SDL_RumbleGamepadTriggers
#undef SDL_RumbleGamepadTriggers
#endif

#ifdef SDL_RumbleJoystick
#undef SDL_RumbleJoystick
#endif

#ifdef SDL_RumbleJoystickTriggers
#undef SDL_RumbleJoystickTriggers
#endif

#ifdef SDL_RunApp
#undef SDL_RunApp
#endif

#ifdef SDL_SIMDGetAlignment
#undef SDL_SIMDGetAlignment
#endif

#ifdef SDL_SaveBMP
#undef SDL_SaveBMP
#endif

#ifdef SDL_SaveBMP_RW
#undef SDL_SaveBMP_RW
#endif

#ifdef SDL_ScreenKeyboardShown
#undef SDL_ScreenKeyboardShown
#endif

#ifdef SDL_ScreenSaverEnabled
#undef SDL_ScreenSaverEnabled
#endif

#ifdef SDL_SendGamepadEffect
#undef SDL_SendGamepadEffect
#endif

#ifdef SDL_SendJoystickEffect
#undef SDL_SendJoystickEffect
#endif

#ifdef SDL_SetAssertionHandler
#undef SDL_SetAssertionHandler
#endif

#ifdef SDL_SetClipboardData
#undef SDL_SetClipboardData
#endif

#ifdef SDL_SetClipboardText
#undef SDL_SetClipboardText
#endif

#ifdef SDL_SetCursor
#undef SDL_SetCursor
#endif

#ifdef SDL_SetError
#undef SDL_SetError
#endif

#ifdef SDL_SetEventEnabled
#undef SDL_SetEventEnabled
#endif

#ifdef SDL_SetEventFilter
#undef SDL_SetEventFilter
#endif

#ifdef SDL_SetGamepadEventsEnabled
#undef SDL_SetGamepadEventsEnabled
#endif

#ifdef SDL_SetGamepadLED
#undef SDL_SetGamepadLED
#endif

#ifdef SDL_SetGamepadPlayerIndex
#undef SDL_SetGamepadPlayerIndex
#endif

#ifdef SDL_SetGamepadSensorEnabled
#undef SDL_SetGamepadSensorEnabled
#endif

#ifdef SDL_SetHint
#undef SDL_SetHint
#endif

#ifdef SDL_SetHintWithPriority
#undef SDL_SetHintWithPriority
#endif

#ifdef SDL_SetJoystickEventsEnabled
#undef SDL_SetJoystickEventsEnabled
#endif

#ifdef SDL_SetJoystickLED
#undef SDL_SetJoystickLED
#endif

#ifdef SDL_SetJoystickPlayerIndex
#undef SDL_SetJoystickPlayerIndex
#endif

#ifdef SDL_SetJoystickVirtualAxis
#undef SDL_SetJoystickVirtualAxis
#endif

#ifdef SDL_SetJoystickVirtualButton
#undef SDL_SetJoystickVirtualButton
#endif

#ifdef SDL_SetJoystickVirtualHat
#undef SDL_SetJoystickVirtualHat
#endif

#ifdef SDL_SetMainReady
#undef SDL_SetMainReady
#endif

#ifdef SDL_SetMemoryFunctions
#undef SDL_SetMemoryFunctions
#endif

#ifdef SDL_SetModState
#undef SDL_SetModState
#endif

#ifdef SDL_SetPaletteColors
#undef SDL_SetPaletteColors
#endif

#ifdef SDL_SetPixelFormatPalette
#undef SDL_SetPixelFormatPalette
#endif

#ifdef SDL_SetPrimarySelectionText
#undef SDL_SetPrimarySelectionText
#endif

#ifdef SDL_SetRelativeMouseMode
#undef SDL_SetRelativeMouseMode
#endif

#ifdef SDL_SetRenderClipRect
#undef SDL_SetRenderClipRect
#endif

#ifdef SDL_SetRenderDrawBlendMode
#undef SDL_SetRenderDrawBlendMode
#endif

#ifdef SDL_SetRenderDrawColor
#undef SDL_SetRenderDrawColor
#endif

#ifdef SDL_SetRenderLogicalPresentation
#undef SDL_SetRenderLogicalPresentation
#endif

#ifdef SDL_SetRenderScale
#undef SDL_SetRenderScale
#endif

#ifdef SDL_SetRenderTarget
#undef SDL_SetRenderTarget
#endif

#ifdef SDL_SetRenderVSync
#undef SDL_SetRenderVSync
#endif

#ifdef SDL_SetRenderViewport
#undef SDL_SetRenderViewport
#endif

#ifdef SDL_SetSurfaceAlphaMod
#undef SDL_SetSurfaceAlphaMod
#endif

#ifdef SDL_SetSurfaceBlendMode
#undef SDL_SetSurfaceBlendMode
#endif

#ifdef SDL_SetSurfaceClipRect
#undef SDL_SetSurfaceClipRect
#endif

#ifdef SDL_SetSurfaceColorKey
#undef SDL_SetSurfaceColorKey
#endif

#ifdef SDL_SetSurfaceColorMod
#undef SDL_SetSurfaceColorMod
#endif

#ifdef SDL_SetSurfacePalette
#undef SDL_SetSurfacePalette
#endif

#ifdef SDL_SetSurfaceRLE
#undef SDL_SetSurfaceRLE
#endif

#ifdef SDL_SetTLS
#undef SDL_SetTLS
#endif

#ifdef SDL_SetTextInputRect
#undef SDL_SetTextInputRect
#endif

#ifdef SDL_SetTextureAlphaMod
#undef SDL_SetTextureAlphaMod
#endif

#ifdef SDL_SetTextureBlendMode
#undef SDL_SetTextureBlendMode
#endif

#ifdef SDL_SetTextureColorMod
#undef SDL_SetTextureColorMod
#endif

#ifdef SDL_SetTextureScaleMode
#undef SDL_SetTextureScaleMode
#endif

#ifdef SDL_SetThreadPriority
#undef SDL_SetThreadPriority
#endif

#ifdef SDL_SetWindowAlwaysOnTop
#undef SDL_SetWindowAlwaysOnTop
#endif

#ifdef SDL_SetWindowBordered
#undef SDL_SetWindowBordered
#endif

#ifdef SDL_SetWindowFullscreen
#undef SDL_SetWindowFullscreen
#endif

#ifdef SDL_SetWindowFullscreenMode
#undef SDL_SetWindowFullscreenMode
#endif

#ifdef SDL_SetWindowGrab
#undef SDL_SetWindowGrab
#endif

#ifdef SDL_SetWindowHitTest
#undef SDL_SetWindowHitTest
#endif

#ifdef SDL_SetWindowIcon
#undef SDL_SetWindowIcon
#endif

#ifdef SDL_SetWindowInputFocus
#undef SDL_SetWindowInputFocus
#endif

#ifdef SDL_SetWindowKeyboardGrab
#undef SDL_SetWindowKeyboardGrab
#endif

#ifdef SDL_SetWindowMaximumSize
#undef SDL_SetWindowMaximumSize
#endif

#ifdef SDL_SetWindowMinimumSize
#undef SDL_SetWindowMinimumSize
#endif

#ifdef SDL_SetWindowModalFor
#undef SDL_SetWindowModalFor
#endif

#ifdef SDL_SetWindowMouseGrab
#undef SDL_SetWindowMouseGrab
#endif

#ifdef SDL_SetWindowMouseRect
#undef SDL_SetWindowMouseRect
#endif

#ifdef SDL_SetWindowOpacity
#undef SDL_SetWindowOpacity
#endif

#ifdef SDL_SetWindowPosition
#undef SDL_SetWindowPosition
#endif

#ifdef SDL_SetWindowResizable
#undef SDL_SetWindowResizable
#endif

#ifdef SDL_SetWindowSize
#undef SDL_SetWindowSize
#endif

#ifdef SDL_SetWindowTitle
#undef SDL_SetWindowTitle
#endif

#ifdef SDL_SetWindowsMessageHook
#undef SDL_SetWindowsMessageHook
#endif

#ifdef SDL_SetYUVConversionMode
#undef SDL_SetYUVConversionMode
#endif

#ifdef SDL_ShowCursor
#undef SDL_ShowCursor
#endif

#ifdef SDL_ShowMessageBox
#undef SDL_ShowMessageBox
#endif

#ifdef SDL_ShowSimpleMessageBox
#undef SDL_ShowSimpleMessageBox
#endif

#ifdef SDL_ShowWindow
#undef SDL_ShowWindow
#endif

#ifdef SDL_SignalCondition
#undef SDL_SignalCondition
#endif

#ifdef SDL_SoftStretch
#undef SDL_SoftStretch
#endif

#ifdef SDL_StartTextInput
#undef SDL_StartTextInput
#endif

#ifdef SDL_StopTextInput
#undef SDL_StopTextInput
#endif

#ifdef SDL_SurfaceHasColorKey
#undef SDL_SurfaceHasColorKey
#endif

#ifdef SDL_SurfaceHasRLE
#undef SDL_SurfaceHasRLE
#endif

#ifdef SDL_TextInputActive
#undef SDL_TextInputActive
#endif

#ifdef SDL_TextInputShown
#undef SDL_TextInputShown
#endif

#ifdef SDL_GetCurrentThreadID
#undef SDL_GetCurrentThreadID
#endif

#ifdef SDL_TryLockMutex
#undef SDL_TryLockMutex
#endif

#ifdef SDL_TryLockRWLockForReading
#undef SDL_TryLockRWLockForReading
#endif

#ifdef SDL_TryLockRWLockForWriting
#undef SDL_TryLockRWLockForWriting
#endif

#ifdef SDL_TryWaitSemaphore
#undef SDL_TryWaitSemaphore
#endif

#ifdef SDL_UnloadObject
#undef SDL_UnloadObject
#endif

#ifdef SDL_UnlockJoysticks
#undef SDL_UnlockJoysticks
#endif

#ifdef SDL_UnlockMutex
#undef SDL_UnlockMutex
#endif

#ifdef SDL_UnlockRWLock
#undef SDL_UnlockRWLock
#endif

#ifdef SDL_UnlockSurface
#undef SDL_UnlockSurface
#endif

#ifdef SDL_UnlockTexture
#undef SDL_UnlockTexture
#endif

#ifdef SDL_UnregisterApp
#undef SDL_UnregisterApp
#endif

#ifdef SDL_UpdateGamepads
#undef SDL_UpdateGamepads
#endif

#ifdef SDL_UpdateJoysticks
#undef SDL_UpdateJoysticks
#endif

#ifdef SDL_UpdateNVTexture
#undef SDL_UpdateNVTexture
#endif

#ifdef SDL_UpdateSensors
#undef SDL_UpdateSensors
#endif

#ifdef SDL_UpdateTexture
#undef SDL_UpdateTexture
#endif

#ifdef SDL_UpdateWindowSurface
#undef SDL_UpdateWindowSurface
#endif

#ifdef SDL_UpdateWindowSurfaceRects
#undef SDL_UpdateWindowSurfaceRects
#endif

#ifdef SDL_UpdateYUVTexture
#undef SDL_UpdateYUVTexture
#endif

#ifdef SDL_Vulkan_CreateSurface
#undef SDL_Vulkan_CreateSurface
#endif

#ifdef SDL_Vulkan_GetInstanceExtensions
#undef SDL_Vulkan_GetInstanceExtensions
#endif

#ifdef SDL_Vulkan_GetVkGetInstanceProcAddr
#undef SDL_Vulkan_GetVkGetInstanceProcAddr
#endif

#ifdef SDL_Vulkan_LoadLibrary
#undef SDL_Vulkan_LoadLibrary
#endif

#ifdef SDL_Vulkan_UnloadLibrary
#undef SDL_Vulkan_UnloadLibrary
#endif

#ifdef SDL_WaitCondition
#undef SDL_WaitCondition
#endif

#ifdef SDL_WaitConditionTimeout
#undef SDL_WaitConditionTimeout
#endif

#ifdef SDL_WaitEvent
#undef SDL_WaitEvent
#endif

#ifdef SDL_WaitEventTimeout
#undef SDL_WaitEventTimeout
#endif

#ifdef SDL_WaitSemaphore
#undef SDL_WaitSemaphore
#endif

#ifdef SDL_WaitSemaphoreTimeout
#undef SDL_WaitSemaphoreTimeout
#endif

#ifdef SDL_WaitThread
#undef SDL_WaitThread
#endif

#ifdef SDL_WarpMouseGlobal
#undef SDL_WarpMouseGlobal
#endif

#ifdef SDL_WarpMouseInWindow
#undef SDL_WarpMouseInWindow
#endif

#ifdef SDL_WasInit
#undef SDL_WasInit
#endif

#ifdef SDL_WinRTGetDeviceFamily
#undef SDL_WinRTGetDeviceFamily
#endif

#ifdef SDL_WinRTGetFSPathUNICODE
#undef SDL_WinRTGetFSPathUNICODE
#endif

#ifdef SDL_WinRTGetFSPathUTF8
#undef SDL_WinRTGetFSPathUTF8
#endif

#ifdef SDL_WriteU16BE
#undef SDL_WriteU16BE
#endif

#ifdef SDL_WriteU32BE
#undef SDL_WriteU32BE
#endif

#ifdef SDL_WriteU64BE
#undef SDL_WriteU64BE
#endif

#ifdef SDL_WriteU16LE
#undef SDL_WriteU16LE
#endif

#ifdef SDL_WriteU32LE
#undef SDL_WriteU32LE
#endif

#ifdef SDL_WriteU64LE
#undef SDL_WriteU64LE
#endif

#ifdef SDL_WriteU8
#undef SDL_WriteU8
#endif

#ifdef SDL_abs
#undef SDL_abs
#endif

#ifdef SDL_acos
#undef SDL_acos
#endif

#ifdef SDL_acosf
#undef SDL_acosf
#endif

#ifdef SDL_aligned_alloc
#undef SDL_aligned_alloc
#endif

#ifdef SDL_aligned_free
#undef SDL_aligned_free
#endif

#ifdef SDL_asin
#undef SDL_asin
#endif

#ifdef SDL_asinf
#undef SDL_asinf
#endif

#ifdef SDL_asprintf
#undef SDL_asprintf
#endif

#ifdef SDL_atan
#undef SDL_atan
#endif

#ifdef SDL_atan2
#undef SDL_atan2
#endif

#ifdef SDL_atan2f
#undef SDL_atan2f
#endif

#ifdef SDL_atanf
#undef SDL_atanf
#endif

#ifdef SDL_atof
#undef SDL_atof
#endif

#ifdef SDL_atoi
#undef SDL_atoi
#endif

#ifdef SDL_bsearch
#undef SDL_bsearch
#endif

#ifdef SDL_calloc
#undef SDL_calloc
#endif

#ifdef SDL_ceil
#undef SDL_ceil
#endif

#ifdef SDL_ceilf
#undef SDL_ceilf
#endif

#ifdef SDL_copysign
#undef SDL_copysign
#endif

#ifdef SDL_copysignf
#undef SDL_copysignf
#endif

#ifdef SDL_cos
#undef SDL_cos
#endif

#ifdef SDL_cosf
#undef SDL_cosf
#endif

#ifdef SDL_crc16
#undef SDL_crc16
#endif

#ifdef SDL_crc32
#undef SDL_crc32
#endif

#ifdef SDL_exp
#undef SDL_exp
#endif

#ifdef SDL_expf
#undef SDL_expf
#endif

#ifdef SDL_fabs
#undef SDL_fabs
#endif

#ifdef SDL_fabsf
#undef SDL_fabsf
#endif

#ifdef SDL_floor
#undef SDL_floor
#endif

#ifdef SDL_floorf
#undef SDL_floorf
#endif

#ifdef SDL_fmod
#undef SDL_fmod
#endif

#ifdef SDL_fmodf
#undef SDL_fmodf
#endif

#ifdef SDL_free
#undef SDL_free
#endif

#ifdef SDL_getenv
#undef SDL_getenv
#endif

#ifdef SDL_hid_ble_scan
#undef SDL_hid_ble_scan
#endif

#ifdef SDL_hid_close
#undef SDL_hid_close
#endif

#ifdef SDL_hid_device_change_count
#undef SDL_hid_device_change_count
#endif

#ifdef SDL_hid_enumerate
#undef SDL_hid_enumerate
#endif

#ifdef SDL_hid_exit
#undef SDL_hid_exit
#endif

#ifdef SDL_hid_free_enumeration
#undef SDL_hid_free_enumeration
#endif

#ifdef SDL_hid_get_device_info
#undef SDL_hid_get_device_info
#endif

#ifdef SDL_hid_get_feature_report
#undef SDL_hid_get_feature_report
#endif

#ifdef SDL_hid_get_indexed_string
#undef SDL_hid_get_indexed_string
#endif

#ifdef SDL_hid_get_input_report
#undef SDL_hid_get_input_report
#endif

#ifdef SDL_hid_get_manufacturer_string
#undef SDL_hid_get_manufacturer_string
#endif

#ifdef SDL_hid_get_product_string
#undef SDL_hid_get_product_string
#endif

#ifdef SDL_hid_get_report_descriptor
#undef SDL_hid_get_report_descriptor
#endif

#ifdef SDL_hid_get_serial_number_string
#undef SDL_hid_get_serial_number_string
#endif

#ifdef SDL_hid_init
#undef SDL_hid_init
#endif

#ifdef SDL_hid_open
#undef SDL_hid_open
#endif

#ifdef SDL_hid_open_path
#undef SDL_hid_open_path
#endif

#ifdef SDL_hid_read
#undef SDL_hid_read
#endif

#ifdef SDL_hid_read_timeout
#undef SDL_hid_read_timeout
#endif

#ifdef SDL_hid_send_feature_report
#undef SDL_hid_send_feature_report
#endif

#ifdef SDL_hid_set_nonblocking
#undef SDL_hid_set_nonblocking
#endif

#ifdef SDL_hid_write
#undef SDL_hid_write
#endif

#ifdef SDL_iPhoneSetAnimationCallback
#undef SDL_iPhoneSetAnimationCallback
#endif

#ifdef SDL_iPhoneSetEventPump
#undef SDL_iPhoneSetEventPump
#endif

#ifdef SDL_iconv
#undef SDL_iconv
#endif

#ifdef SDL_iconv_close
#undef SDL_iconv_close
#endif

#ifdef SDL_iconv_open
#undef SDL_iconv_open
#endif

#ifdef SDL_iconv_string
#undef SDL_iconv_string
#endif

#ifdef SDL_isalnum
#undef SDL_isalnum
#endif

#ifdef SDL_isalpha
#undef SDL_isalpha
#endif

#ifdef SDL_isblank
#undef SDL_isblank
#endif

#ifdef SDL_iscntrl
#undef SDL_iscntrl
#endif

#ifdef SDL_isdigit
#undef SDL_isdigit
#endif

#ifdef SDL_isgraph
#undef SDL_isgraph
#endif

#ifdef SDL_islower
#undef SDL_islower
#endif

#ifdef SDL_isprint
#undef SDL_isprint
#endif

#ifdef SDL_ispunct
#undef SDL_ispunct
#endif

#ifdef SDL_isspace
#undef SDL_isspace
#endif

#ifdef SDL_isupper
#undef SDL_isupper
#endif

#ifdef SDL_isxdigit
#undef SDL_isxdigit
#endif

#ifdef SDL_itoa
#undef SDL_itoa
#endif

#ifdef SDL_lltoa
#undef SDL_lltoa
#endif

#ifdef SDL_log
#undef SDL_log
#endif

#ifdef SDL_log10
#undef SDL_log10
#endif

#ifdef SDL_log10f
#undef SDL_log10f
#endif

#ifdef SDL_logf
#undef SDL_logf
#endif

#ifdef SDL_lround
#undef SDL_lround
#endif

#ifdef SDL_lroundf
#undef SDL_lroundf
#endif

#ifdef SDL_ltoa
#undef SDL_ltoa
#endif

#ifdef SDL_malloc
#undef SDL_malloc
#endif

#ifdef SDL_memcmp
#undef SDL_memcmp
#endif

#ifdef SDL_memcpy
#undef SDL_memcpy
#endif

#ifdef SDL_memmove
#undef SDL_memmove
#endif

#ifdef SDL_memset
#undef SDL_memset
#endif

#ifdef SDL_memset4
#undef SDL_memset4
#endif

#ifdef SDL_modf
#undef SDL_modf
#endif

#ifdef SDL_modff
#undef SDL_modff
#endif

#ifdef SDL_pow
#undef SDL_pow
#endif

#ifdef SDL_powf
#undef SDL_powf
#endif

#ifdef SDL_qsort
#undef SDL_qsort
#endif

#ifdef SDL_realloc
#undef SDL_realloc
#endif

#ifdef SDL_round
#undef SDL_round
#endif

#ifdef SDL_roundf
#undef SDL_roundf
#endif

#ifdef SDL_scalbn
#undef SDL_scalbn
#endif

#ifdef SDL_scalbnf
#undef SDL_scalbnf
#endif

#ifdef SDL_setenv
#undef SDL_setenv
#endif

#ifdef SDL_sin
#undef SDL_sin
#endif

#ifdef SDL_sinf
#undef SDL_sinf
#endif

#ifdef SDL_snprintf
#undef SDL_snprintf
#endif

#ifdef SDL_sqrt
#undef SDL_sqrt
#endif

#ifdef SDL_sqrtf
#undef SDL_sqrtf
#endif

#ifdef SDL_sscanf
#undef SDL_sscanf
#endif

#ifdef SDL_strcasecmp
#undef SDL_strcasecmp
#endif

#ifdef SDL_strcasestr
#undef SDL_strcasestr
#endif

#ifdef SDL_strchr
#undef SDL_strchr
#endif

#ifdef SDL_strcmp
#undef SDL_strcmp
#endif

#ifdef SDL_strdup
#undef SDL_strdup
#endif

#ifdef SDL_strlcat
#undef SDL_strlcat
#endif

#ifdef SDL_strlcpy
#undef SDL_strlcpy
#endif

#ifdef SDL_strlen
#undef SDL_strlen
#endif

#ifdef SDL_strlwr
#undef SDL_strlwr
#endif

#ifdef SDL_strncasecmp
#undef SDL_strncasecmp
#endif

#ifdef SDL_strncmp
#undef SDL_strncmp
#endif

#ifdef SDL_strrchr
#undef SDL_strrchr
#endif

#ifdef SDL_strrev
#undef SDL_strrev
#endif

#ifdef SDL_strstr
#undef SDL_strstr
#endif

#ifdef SDL_strtod
#undef SDL_strtod
#endif

#ifdef SDL_strtok_r
#undef SDL_strtok_r
#endif

#ifdef SDL_strtol
#undef SDL_strtol
#endif

#ifdef SDL_strtoll
#undef SDL_strtoll
#endif

#ifdef SDL_strtoul
#undef SDL_strtoul
#endif

#ifdef SDL_strtoull
#undef SDL_strtoull
#endif

#ifdef SDL_strupr
#undef SDL_strupr
#endif

#ifdef SDL_swprintf
#undef SDL_swprintf
#endif

#ifdef SDL_tan
#undef SDL_tan
#endif

#ifdef SDL_tanf
#undef SDL_tanf
#endif

#ifdef SDL_tolower
#undef SDL_tolower
#endif

#ifdef SDL_toupper
#undef SDL_toupper
#endif

#ifdef SDL_trunc
#undef SDL_trunc
#endif

#ifdef SDL_truncf
#undef SDL_truncf
#endif

#ifdef SDL_uitoa
#undef SDL_uitoa
#endif

#ifdef SDL_ulltoa
#undef SDL_ulltoa
#endif

#ifdef SDL_ultoa
#undef SDL_ultoa
#endif

#ifdef SDL_utf8strlcpy
#undef SDL_utf8strlcpy
#endif

#ifdef SDL_utf8strlen
#undef SDL_utf8strlen
#endif

#ifdef SDL_utf8strnlen
#undef SDL_utf8strnlen
#endif

#ifdef SDL_vasprintf
#undef SDL_vasprintf
#endif

#ifdef SDL_vsnprintf
#undef SDL_vsnprintf
#endif

#ifdef SDL_vsscanf
#undef SDL_vsscanf
#endif

#ifdef SDL_vswprintf
#undef SDL_vswprintf
#endif

#ifdef SDL_wcscasecmp
#undef SDL_wcscasecmp
#endif

#ifdef SDL_wcscmp
#undef SDL_wcscmp
#endif

#ifdef SDL_wcsdup
#undef SDL_wcsdup
#endif

#ifdef SDL_wcslcat
#undef SDL_wcslcat
#endif

#ifdef SDL_wcslcpy
#undef SDL_wcslcpy
#endif

#ifdef SDL_wcslen
#undef SDL_wcslen
#endif

#ifdef SDL_wcsncasecmp
#undef SDL_wcsncasecmp
#endif

#ifdef SDL_wcsncmp
#undef SDL_wcsncmp
#endif

#ifdef SDL_wcsstr
#undef SDL_wcsstr
#endif

#ifdef SDL_wcstol
#undef SDL_wcstol
#endif

#ifdef SDL_ClearClipboardData
#undef SDL_ClearClipboardData
#endif

#ifdef SDL_GetGamepadInstanceID
#undef SDL_GetGamepadInstanceID
#endif

#ifdef SDL_GetGamepadPowerLevel
#undef SDL_GetGamepadPowerLevel
#endif

#ifdef SDL_SetGamepadMapping
#undef SDL_SetGamepadMapping
#endif

#ifdef SDL_strndup
#undef SDL_strndup
#endif

#ifdef SDL_GetGamepadTypeFromString
#undef SDL_GetGamepadTypeFromString
#endif

#ifdef SDL_GetGamepadStringForType
#undef SDL_GetGamepadStringForType
#endif

#ifdef SDL_GetRealGamepadInstanceType
#undef SDL_GetRealGamepadInstanceType
#endif

#ifdef SDL_GetRealGamepadType
#undef SDL_GetRealGamepadType
#endif

#ifdef SDL_wcsnlen
#undef SDL_wcsnlen
#endif

#ifdef SDL_strnlen
#undef SDL_strnlen
#endif

#ifdef SDL_AddGamepadMappingsFromFile
#undef SDL_AddGamepadMappingsFromFile
#endif

#ifdef SDL_ReloadGamepadMappings
#undef SDL_ReloadGamepadMappings
#endif

#ifdef SDL_GetNumAudioDrivers
#undef SDL_GetNumAudioDrivers
#endif

#ifdef SDL_GetAudioDriver
#undef SDL_GetAudioDriver
#endif

#ifdef SDL_GetCurrentAudioDriver
#undef SDL_GetCurrentAudioDriver
#endif

#ifdef SDL_GetAudioOutputDevices
#undef SDL_GetAudioOutputDevices
#endif

#ifdef SDL_GetAudioCaptureDevices
#undef SDL_GetAudioCaptureDevices
#endif

#ifdef SDL_GetAudioDeviceName
#undef SDL_GetAudioDeviceName
#endif

#ifdef SDL_GetAudioDeviceFormat
#undef SDL_GetAudioDeviceFormat
#endif

#ifdef SDL_OpenAudioDevice
#undef SDL_OpenAudioDevice
#endif

#ifdef SDL_CloseAudioDevice
#undef SDL_CloseAudioDevice
#endif

#ifdef SDL_BindAudioStreams
#undef SDL_BindAudioStreams
#endif

#ifdef SDL_BindAudioStream
#undef SDL_BindAudioStream
#endif

#ifdef SDL_UnbindAudioStreams
#undef SDL_UnbindAudioStreams
#endif

#ifdef SDL_UnbindAudioStream
#undef SDL_UnbindAudioStream
#endif

#ifdef SDL_CreateAudioStream
#undef SDL_CreateAudioStream
#endif

#ifdef SDL_GetAudioStreamFormat
#undef SDL_GetAudioStreamFormat
#endif

#ifdef SDL_SetAudioStreamFormat
#undef SDL_SetAudioStreamFormat
#endif

#ifdef SDL_PutAudioStreamData
#undef SDL_PutAudioStreamData
#endif

#ifdef SDL_GetAudioStreamData
#undef SDL_GetAudioStreamData
#endif

#ifdef SDL_GetAudioStreamAvailable
#undef SDL_GetAudioStreamAvailable
#endif

#ifdef SDL_FlushAudioStream
#undef SDL_FlushAudioStream
#endif

#ifdef SDL_ClearAudioStream
#undef SDL_ClearAudioStream
#endif

#ifdef SDL_LockAudioStream
#undef SDL_LockAudioStream
#endif

#ifdef SDL_UnlockAudioStream
#undef SDL_UnlockAudioStream
#endif

#ifdef SDL_SetAudioStreamGetCallback
#undef SDL_SetAudioStreamGetCallback
#endif

#ifdef SDL_SetAudioStreamPutCallback
#undef SDL_SetAudioStreamPutCallback
#endif

#ifdef SDL_DestroyAudioStream
#undef SDL_DestroyAudioStream
#endif

#ifdef SDL_OpenAudioDeviceStream
#undef SDL_OpenAudioDeviceStream
#endif

#ifdef SDL_LoadWAV_RW
#undef SDL_LoadWAV_RW
#endif

#ifdef SDL_LoadWAV
#undef SDL_LoadWAV
#endif

#ifdef SDL_MixAudioFormat
#undef SDL_MixAudioFormat
#endif

#ifdef SDL_ConvertAudioSamples
#undef SDL_ConvertAudioSamples
#endif

#ifdef SDL_GetSilenceValueForFormat
#undef SDL_GetSilenceValueForFormat
#endif

#ifdef SDL_PauseAudioDevice
#undef SDL_PauseAudioDevice
#endif

#ifdef SDL_ResumeAudioDevice
#undef SDL_ResumeAudioDevice
#endif

#ifdef SDL_AudioDevicePaused
#undef SDL_AudioDevicePaused
#endif

#ifdef SDL_GetAudioStreamDevice
#undef SDL_GetAudioStreamDevice
#endif

#ifdef SDL_ShowWindowSystemMenu
#undef SDL_ShowWindowSystemMenu
#endif

#ifdef SDL_ReadS16LE
#undef SDL_ReadS16LE
#endif

#ifdef SDL_ReadS16BE
#undef SDL_ReadS16BE
#endif

#ifdef SDL_ReadS32LE
#undef SDL_ReadS32LE
#endif

#ifdef SDL_ReadS32BE
#undef SDL_ReadS32BE
#endif

#ifdef SDL_ReadS64LE
#undef SDL_ReadS64LE
#endif

#ifdef SDL_ReadS64BE
#undef SDL_ReadS64BE
#endif

#ifdef SDL_WriteS16LE
#undef SDL_WriteS16LE
#endif

#ifdef SDL_WriteS16BE
#undef SDL_WriteS16BE
#endif

#ifdef SDL_WriteS32LE
#undef SDL_WriteS32LE
#endif

#ifdef SDL_WriteS32BE
#undef SDL_WriteS32BE
#endif

#ifdef SDL_WriteS64LE
#undef SDL_WriteS64LE
#endif

#ifdef SDL_WriteS64BE
#undef SDL_WriteS64BE
#endif

#ifdef SDL_GDKGetDefaultUser
#undef SDL_GDKGetDefaultUser
#endif

#ifdef SDL_SetWindowFocusable
#undef SDL_SetWindowFocusable
#endif

#ifdef SDL_GetAudioStreamFrequencyRatio
#undef SDL_GetAudioStreamFrequencyRatio
#endif

#ifdef SDL_SetAudioStreamFrequencyRatio
#undef SDL_SetAudioStreamFrequencyRatio
#endif

#ifdef SDL_SetAudioPostmixCallback
#undef SDL_SetAudioPostmixCallback
#endif

#ifdef SDL_GetAudioStreamQueued
#undef SDL_GetAudioStreamQueued
#endif

#ifdef SDL_CreateProperties
#undef SDL_CreateProperties
#endif

#ifdef SDL_LockProperties
#undef SDL_LockProperties
#endif

#ifdef SDL_UnlockProperties
#undef SDL_UnlockProperties
#endif

#ifdef SDL_SetProperty
#undef SDL_SetProperty
#endif

#ifdef SDL_GetProperty
#undef SDL_GetProperty
#endif

#ifdef SDL_DestroyProperties
#undef SDL_DestroyProperties
#endif

#ifdef SDL_GetAudioStreamProperties
#undef SDL_GetAudioStreamProperties
#endif

#ifdef SDL_GetGamepadProperties
#undef SDL_GetGamepadProperties
#endif

#ifdef SDL_GetJoystickProperties
#undef SDL_GetJoystickProperties
#endif

#ifdef SDL_GetRendererProperties
#undef SDL_GetRendererProperties
#endif

#ifdef SDL_GetTextureProperties
#undef SDL_GetTextureProperties
#endif

#ifdef SDL_GetRWProperties
#undef SDL_GetRWProperties
#endif

#ifdef SDL_GetSensorProperties
#undef SDL_GetSensorProperties
#endif

#ifdef SDL_GetSurfaceProperties
#undef SDL_GetSurfaceProperties
#endif

#ifdef SDL_GetWindowProperties
#undef SDL_GetWindowProperties
#endif

#ifdef SDL_ClearProperty
#undef SDL_ClearProperty
#endif

#ifdef SDL_EnterAppMainCallbacks
#undef SDL_EnterAppMainCallbacks
#endif

#ifdef SDL_RWprintf
#undef SDL_RWprintf
#endif

#ifdef SDL_RWvprintf
#undef SDL_RWvprintf
#endif

#ifdef SDL_AllocateEventMemory
#undef SDL_AllocateEventMemory
#endif

#ifdef SDL_GetDisplayProperties
#undef SDL_GetDisplayProperties
#endif

#ifdef SDL_SetPropertyWithCleanup
#undef SDL_SetPropertyWithCleanup
#endif

#ifdef SDL_SetX11EventHook
#undef SDL_SetX11EventHook
#endif

#ifdef SDL_GetGlobalProperties
#undef SDL_GetGlobalProperties
#endif

#ifdef SDL_OpenVideoCapture
#undef SDL_OpenVideoCapture
#endif

#ifdef SDL_SetVideoCaptureSpec
#undef SDL_SetVideoCaptureSpec
#endif

#ifdef SDL_OpenVideoCaptureWithSpec
#undef SDL_OpenVideoCaptureWithSpec
#endif

#ifdef SDL_GetVideoCaptureDeviceName
#undef SDL_GetVideoCaptureDeviceName
#endif

#ifdef SDL_GetVideoCaptureSpec
#undef SDL_GetVideoCaptureSpec
#endif

#ifdef SDL_GetVideoCaptureFormat
#undef SDL_GetVideoCaptureFormat
#endif

#ifdef SDL_GetNumVideoCaptureFormats
#undef SDL_GetNumVideoCaptureFormats
#endif

#ifdef SDL_GetVideoCaptureFrameSize
#undef SDL_GetVideoCaptureFrameSize
#endif

#ifdef SDL_GetNumVideoCaptureFrameSizes
#undef SDL_GetNumVideoCaptureFrameSizes
#endif

#ifdef SDL_GetVideoCaptureStatus
#undef SDL_GetVideoCaptureStatus
#endif

#ifdef SDL_StartVideoCapture
#undef SDL_StartVideoCapture
#endif

#ifdef SDL_AcquireVideoCaptureFrame
#undef SDL_AcquireVideoCaptureFrame
#endif

#ifdef SDL_ReleaseVideoCaptureFrame
#undef SDL_ReleaseVideoCaptureFrame
#endif

#ifdef SDL_StopVideoCapture
#undef SDL_StopVideoCapture
#endif

#ifdef SDL_CloseVideoCapture
#undef SDL_CloseVideoCapture
#endif

#ifdef SDL_GetVideoCaptureDevices
#undef SDL_GetVideoCaptureDevices
#endif

#ifdef SDL_GetGamepadButtonLabelForType
#undef SDL_GetGamepadButtonLabelForType
#endif

#ifdef SDL_GetGamepadButtonLabel
#undef SDL_GetGamepadButtonLabel
#endif

#ifdef SDL_GetPens
#undef SDL_GetPens
#endif

#ifdef SDL_GetPenStatus
#undef SDL_GetPenStatus
#endif

#ifdef SDL_GetPenFromGUID
#undef SDL_GetPenFromGUID
#endif

#ifdef SDL_GetPenGUID
#undef SDL_GetPenGUID
#endif

#ifdef SDL_PenConnected
#undef SDL_PenConnected
#endif

#ifdef SDL_GetPenName
#undef SDL_GetPenName
#endif

#ifdef SDL_GetPenCapabilities
#undef SDL_GetPenCapabilities
#endif

#ifdef SDL_GetPenType
#undef SDL_GetPenType
#endif

#ifdef SDL_GetPens
#undef SDL_GetPens
#endif

#ifdef SDL_GetPenStatus
#undef SDL_GetPenStatus
#endif

#ifdef SDL_GetPenFromGUID
#undef SDL_GetPenFromGUID
#endif

#ifdef SDL_GetPenGUID
#undef SDL_GetPenGUID
#endif

#ifdef SDL_PenConnected
#undef SDL_PenConnected
#endif

#ifdef SDL_GetPenName
#undef SDL_GetPenName
#endif

#ifdef SDL_GetPenCapabilities
#undef SDL_GetPenCapabilities
#endif

#ifdef SDL_GetPenType
#undef SDL_GetPenType
#endif

#ifdef SDL_SetStringProperty
#undef SDL_SetStringProperty
#endif

#ifdef SDL_SetNumberProperty
#undef SDL_SetNumberProperty
#endif

#ifdef SDL_SetFloatProperty
#undef SDL_SetFloatProperty
#endif

#ifdef SDL_GetPropertyType
#undef SDL_GetPropertyType
#endif

#ifdef SDL_GetStringProperty
#undef SDL_GetStringProperty
#endif

#ifdef SDL_GetNumberProperty
#undef SDL_GetNumberProperty
#endif

#ifdef SDL_GetFloatProperty
#undef SDL_GetFloatProperty
#endif

#ifdef SDL_EnumerateProperties
#undef SDL_EnumerateProperties
#endif

#ifdef SDL_SetBooleanProperty
#undef SDL_SetBooleanProperty
#endif

#ifdef SDL_GetBooleanProperty
#undef SDL_GetBooleanProperty
#endif

#ifdef SDL_CreateTextureWithProperties
#undef SDL_CreateTextureWithProperties
#endif

#ifdef SDL_CreateRendererWithProperties
#undef SDL_CreateRendererWithProperties
#endif

#ifdef SDL_GetGamepadMappings
#undef SDL_GetGamepadMappings
#endif

#ifdef SDL_GetTouchDevices
#undef SDL_GetTouchDevices
#endif

#ifdef SDL_GetTouchDeviceName
#undef SDL_GetTouchDeviceName
#endif

#ifdef SDL_strnstr
#undef SDL_strnstr
#endif

#ifdef SDL_wcsnstr
#undef SDL_wcsnstr
#endif

#ifdef SDL_SyncWindow
#undef SDL_SyncWindow
#endif

#ifdef SDL_GetGamepadSteamHandle
#undef SDL_GetGamepadSteamHandle
#endif

#ifdef SDL_GetRendererFromTexture
#undef SDL_GetRendererFromTexture
#endif

#ifdef SDL_GetHaptics
#undef SDL_GetHaptics
#endif

#ifdef SDL_GetHapticInstanceName
#undef SDL_GetHapticInstanceName
#endif

#ifdef SDL_GetHapticFromInstanceID
#undef SDL_GetHapticFromInstanceID
#endif

#ifdef SDL_GetHapticInstanceID
#undef SDL_GetHapticInstanceID
#endif

#ifdef SDL_GetHapticName
#undef SDL_GetHapticName
#endif

#ifdef SDL_ReadSurfacePixel
#undef SDL_ReadSurfacePixel
#endif

#ifdef SDL_FlipSurface
#undef SDL_FlipSurface
#endif

#ifdef SDL_GetJoystickCaps
#undef SDL_GetJoystickCaps
#endif

#ifdef SDL_GetGamepadCaps
#undef SDL_GetGamepadCaps
#endif

#undef SDL_ThreadID /* see at top. */

/* undefine these macros, too: redefine as SDL3_xxx, if needed. */

#ifdef SDL_enabled_assert
#undef SDL_enabled_assert
#endif

#ifdef SDL_OutOfMemory
#undef SDL_OutOfMemory
#endif

#ifdef SDL_Unsupported
#undef SDL_Unsupported
#endif

#ifdef SDL_InvalidParamError
#undef SDL_InvalidParamError
#endif

#ifdef SDL_AtomicIncRef
#undef SDL_AtomicIncRef
#endif

#ifdef SDL_AtomicDecRef
#undef SDL_AtomicDecRef
#endif

#ifdef SDL_copyp
#undef SDL_copyp
#endif

#ifdef SDL_zero
#undef SDL_zero
#endif

#ifdef SDL_zeroa
#undef SDL_zeroa
#endif

#ifdef SDL_zerop
#undef SDL_zerop
#endif

#ifdef SDL_stack_alloc
#undef SDL_stack_alloc
#endif

#ifdef SDL_stack_free
#undef SDL_stack_free
#endif

#ifdef SDL_iconv_utf8_locale
#undef SDL_iconv_utf8_locale
#endif

#ifdef SDL_iconv_utf8_ucs2
#undef SDL_iconv_utf8_ucs2
#endif

#ifdef SDL_iconv_utf8_ucs4
#undef SDL_iconv_utf8_ucs4
#endif

#ifdef SDL_iconv_wchar_utf8
#undef SDL_iconv_wchar_utf8
#endif

#ifdef SDL_GDKRunApp
#undef SDL_GDKRunApp
#endif

#ifdef SDL_WinRTRunApp
#undef SDL_WinRTRunApp
#endif

#ifdef SDL_UIKitRunApp
#undef SDL_UIKitRunApp
#endif

#ifdef SDL_iOSSetAnimationCallback
#undef SDL_iOSSetAnimationCallback
#endif

#ifdef SDL_iOSSetEventPump
#undef SDL_iOSSetEventPump
#endif

#endif /* INCL_SDL3_INCLUDE_WRAPPER_H */
