/*
  Simple DirectMedia Layer
  Copyright (C) 1997-2024 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/

/* don't #pragma once this file, it gets #included multiple times! */

#ifndef SDL3_SYM
#define SDL3_SYM(rc,fn,params,args,ret)
#endif

#ifndef SDL3_SYM_PASSTHROUGH
#define SDL3_SYM_PASSTHROUGH(rc,fn,params,args,ret) SDL3_SYM(rc,fn,params,args,ret)
#endif

#ifndef SDL3_SYM_RENAMED
#define SDL3_SYM_RENAMED(rc,oldfn,newfn,params,args,ret) SDL3_SYM(rc,newfn,params,args,ret)
#endif

#ifndef SDL3_SYM_VARARGS
#define SDL3_SYM_VARARGS(rc,fn,params) SDL3_SYM(rc,fn,params,unused,unused)
#endif

SDL3_SYM_VARARGS(int,SetError,(SDL_PRINTF_FORMAT_STRING const char *a, ...))
SDL3_SYM_VARARGS(void,Log,(SDL_PRINTF_FORMAT_STRING const char *a, ...))
SDL3_SYM_VARARGS(void,LogVerbose,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(void,LogDebug,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(void,LogInfo,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(void,LogWarn,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(void,LogError,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(void,LogCritical,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(void,LogMessage,(int a, SDL_LogPriority b, SDL_PRINTF_FORMAT_STRING const char *c, ...))
SDL3_SYM_VARARGS(int,sscanf,(const char *a, SDL_SCANF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(int,snprintf,(SDL_OUT_Z_CAP(b) char *a, size_t b, SDL_PRINTF_FORMAT_STRING const char *c, ...))

#if (defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_GDK)) && !defined(SDL_PLATFORM_WINRT)
SDL3_SYM_PASSTHROUGH(SDL_Thread*,CreateThread,(SDL_ThreadFunction a, const char *b, void *c, pfnSDL_CurrentBeginThread d, pfnSDL_CurrentEndThread e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(SDL_Thread*,CreateThreadWithStackSize,(SDL_ThreadFunction a, const char *b, const size_t c, void *d, pfnSDL_CurrentBeginThread e, pfnSDL_CurrentEndThread f),(a,b,c,d,e,f),return)
#else
SDL3_SYM_PASSTHROUGH(SDL_Thread*,CreateThread,(SDL_ThreadFunction a, const char *b, void *c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(SDL_Thread*,CreateThreadWithStackSize,(SDL_ThreadFunction a, const char *b, const size_t c, void *d),(a,b,c,d),return)
#endif

#if defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_GDK)
SDL3_SYM_PASSTHROUGH(int,RegisterApp,(const char *a, Uint32 b, void *c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void,UnregisterApp,(void),(),)
SDL3_SYM_PASSTHROUGH(void,SetWindowsMessageHook,(SDL_WindowsMessageHook a, void *b),(a,b),)
#endif

#if defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_WINGDK)
SDL3_SYM(int,Direct3D9GetAdapterIndex,(SDL_DisplayID a),(a),return)
SDL3_SYM(SDL_bool,DXGIGetOutputInfo,(SDL_DisplayID a,int *b, int *c),(a,b,c),return)
#endif

#ifdef SDL_PLATFORM_GDK
SDL3_SYM_PASSTHROUGH(int,GDKGetTaskQueue,(XTaskQueueHandle *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,GDKGetDefaultUser,(XUserHandle *a),(a),return)
#endif

#ifdef SDL_PLATFORM_WINRT
SDL3_SYM_PASSTHROUGH(const wchar_t*,WinRTGetFSPathUNICODE,(SDL_WinRT_Path a),(a),return)
SDL3_SYM_PASSTHROUGH(const char*,WinRTGetFSPathUTF8,(SDL_WinRT_Path a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_WinRT_DeviceFamily,WinRTGetDeviceFamily,(void),(),return)
#endif

#ifdef SDL_PLATFORM_IOS
SDL3_SYM_PASSTHROUGH(int,iPhoneSetAnimationCallback,(SDL_Window *a, int b, void (SDLCALL *c)(void *), void *d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(void,iPhoneSetEventPump,(SDL_bool a),(a),)
SDL3_SYM_PASSTHROUGH(void,OnApplicationDidChangeStatusBarOrientation,(void),(),)
#endif

#ifdef SDL_PLATFORM_LINUX
SDL3_SYM_PASSTHROUGH(int,LinuxSetThreadPriority,(Sint64 a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,LinuxSetThreadPriorityAndPolicy,(Sint64 a, int b, int c),(a,b,c),return)
#endif

#ifdef SDL_PLATFORM_ANDROID
SDL3_SYM_PASSTHROUGH(void*,AndroidGetJNIEnv,(void),(),return)
SDL3_SYM_PASSTHROUGH(void*,AndroidGetActivity,(void),(),return)
SDL3_SYM_PASSTHROUGH(const char*,AndroidGetInternalStoragePath,(void),(),return)
SDL3_SYM(int,AndroidGetExternalStorageState,(Uint32 *a),(a),return)
SDL3_SYM_PASSTHROUGH(const char*,AndroidGetExternalStoragePath,(void),(),return)
SDL3_SYM_PASSTHROUGH(int,AndroidSendMessage,(Uint32 a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,IsAndroidTV,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,IsChromebook,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,IsDeXMode,(void),(),return)
SDL3_SYM_PASSTHROUGH(void,AndroidBackButton,(void),(),)
SDL3_SYM_PASSTHROUGH(SDL_bool,AndroidRequestPermission,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,AndroidShowToast,(const char *a, int b, int c, int d, int e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(int,GetAndroidSDKVersion,(void),(),return)
#endif

SDL3_SYM(int,Init,(Uint32 a),(a),return)
SDL3_SYM(int,InitSubSystem,(Uint32 a),(a),return)
SDL3_SYM(void,QuitSubSystem,(Uint32 a),(a),)
SDL3_SYM(void,Quit,(void),(),)
SDL3_SYM_PASSTHROUGH(Uint32,WasInit,(Uint32 a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_AssertState,ReportAssertion,(SDL_AssertData *a, const char *b, const char *c, int d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(void,SetAssertionHandler,(SDL_AssertionHandler a, void *b),(a,b),)
SDL3_SYM_PASSTHROUGH(const SDL_AssertData*,GetAssertionReport,(void),(),return)
SDL3_SYM_PASSTHROUGH(void,ResetAssertionReport,(void),(),)
SDL3_SYM_RENAMED(SDL_bool,AtomicTryLock,TryLockSpinlock,(SDL_SpinLock *a),(a),return)
SDL3_SYM_RENAMED(void,AtomicLock,LockSpinlock,(SDL_SpinLock *a),(a),)
SDL3_SYM_RENAMED(void,AtomicUnlock,UnlockSpinlock,(SDL_SpinLock *a),(a),)
SDL3_SYM_RENAMED(SDL_bool,AtomicCAS,AtomicCompareAndSwap,(SDL_atomic_t *a, int b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,AtomicSet,(SDL_atomic_t *a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,AtomicGet,(SDL_atomic_t *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,AtomicAdd,(SDL_atomic_t *a, int b),(a,b),return)
SDL3_SYM_RENAMED(SDL_bool,AtomicCASPtr,AtomicCompareAndSwapPointer,(void **a, void *b, void *c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void*,AtomicSetPtr,(void **a, void *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void*,AtomicGetPtr,(void **a),(a),return)
SDL3_SYM_PASSTHROUGH(int,SetClipboardText,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(char*,GetClipboardText,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasClipboardText,(void),(),return)
SDL3_SYM_PASSTHROUGH(int,GetCPUCount,(void),(),return)
SDL3_SYM_PASSTHROUGH(int,GetCPUCacheLineSize,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasAltiVec,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasMMX,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasSSE,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasSSE2,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasSSE3,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasSSE41,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasSSE42,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasAVX,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasAVX2,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasAVX512F,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasNEON,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasARMSIMD,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasLSX,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasLASX,(void),(),return)
SDL3_SYM_PASSTHROUGH(int,GetSystemRAM,(void),(),return)
SDL3_SYM_PASSTHROUGH(const char*,GetError,(void),(),return)
SDL3_SYM_PASSTHROUGH(void,ClearError,(void),(),)
SDL3_SYM_PASSTHROUGH(int,Error,(SDL_errorcode a),(a),return)
SDL3_SYM_PASSTHROUGH(void,PumpEvents,(void),(),)
SDL3_SYM(int,PeepEvents,(SDL_Event *a, int b, SDL_eventaction c, Uint32 d, Uint32 e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasEvent,(Uint32 a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasEvents,(Uint32 a, Uint32 b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void,FlushEvent,(Uint32 a),(a),)
SDL3_SYM_PASSTHROUGH(void,FlushEvents,(Uint32 a, Uint32 b),(a,b),)
SDL3_SYM(SDL_bool,WaitEventTimeout,(SDL_Event *a, Sint32 b),(a,b),return)
SDL3_SYM(int,PushEvent,(SDL_Event *a),(a),return)
SDL3_SYM(SDL_bool,GetEventFilter,(SDL_EventFilter *a, void **b),(a,b),)
SDL3_SYM(void,SetEventFilter,(SDL_EventFilter a, void *b),(a,b),)
SDL3_SYM(void,FilterEvents,(SDL_EventFilter a, void *b),(a,b),)
SDL3_SYM(void *,AllocateEventMemory,(size_t a),(a),return)
SDL3_SYM_PASSTHROUGH(Uint32,RegisterEvents,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(char*,GetBasePath,(void),(),return)
SDL3_SYM_PASSTHROUGH(char*,GetPrefPath,(const char *a, const char *b),(a,b),return)
SDL3_SYM_RENAMED(int,GameControllerAddMapping,AddGamepadMapping,(const char *a),(a),return)
SDL3_SYM_RENAMED(char*,GameControllerMappingForGUID,GetGamepadMappingForGUID,(SDL_JoystickGUID a),(a),return)
SDL3_SYM_RENAMED(char*,GameControllerMapping,GetGamepadMapping,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(const char*,GameControllerName,GetGamepadName,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(SDL_bool,GameControllerGetAttached,GamepadConnected,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(SDL_Joystick*,GameControllerGetJoystick,GetGamepadJoystick,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(void,GameControllerUpdate,UpdateGamepads,(void),(),)
SDL3_SYM_RENAMED(SDL_GameControllerAxis,GameControllerGetAxisFromString,GetGamepadAxisFromString,(const char *a),(a),return)
SDL3_SYM_RENAMED(const char*,GameControllerGetStringForAxis,GetGamepadStringForAxis,(SDL_GameControllerAxis a),(a),return)
SDL3_SYM_RENAMED(Sint16,GameControllerGetAxis,GetGamepadAxis,(SDL_GameController *a, SDL_GameControllerAxis b),(a,b),return)
SDL3_SYM_RENAMED(SDL_GameControllerButton,GameControllerGetButtonFromString,GetGamepadButtonFromString,(const char *a),(a),return)
SDL3_SYM_RENAMED(const char*,GameControllerGetStringForButton,GetGamepadStringForButton,(SDL_GameControllerButton a),(a),return)
SDL3_SYM(Uint8,GetGamepadButton,(SDL_Gamepad *a, SDL_GamepadButton b),(a,b),return)
SDL3_SYM_RENAMED(void,GameControllerClose,CloseGamepad,(SDL_GameController *a),(a),)
SDL3_SYM(SDL_Haptic*,OpenHaptic,(SDL_HapticID a),(a),return)
SDL3_SYM_RENAMED(int,MouseIsHaptic,IsMouseHaptic,(void),(),return)
SDL3_SYM_RENAMED(SDL_Haptic*,HapticOpenFromMouse,OpenHapticFromMouse,(void),(),return)
SDL3_SYM_RENAMED(int,JoystickIsHaptic,IsJoystickHaptic,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(SDL_Haptic*,HapticOpenFromJoystick,OpenHapticFromJoystick,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(void,HapticClose,CloseHaptic,(SDL_Haptic *a),(a),)
SDL3_SYM_RENAMED(int,HapticNumEffects,GetMaxHapticEffects,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED(int,HapticNumEffectsPlaying,GetMaxHapticEffectsPlaying,(SDL_Haptic *a),(a),return)
SDL3_SYM(Uint32,GetHapticFeatures,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED(int,HapticNumAxes,GetNumHapticAxes,(SDL_Haptic *a),(a),return)
SDL3_SYM(SDL_bool,HapticEffectSupported,(SDL_Haptic *a, const SDL_HapticEffect *b),(a,b),return)
SDL3_SYM(int,CreateHapticEffect,(SDL_Haptic *a, const SDL_HapticEffect *b),(a,b),return)
SDL3_SYM(int,UpdateHapticEffect,(SDL_Haptic *a, int b, const SDL_HapticEffect *c),(a,b,c),return)
SDL3_SYM_RENAMED(int,HapticRunEffect,RunHapticEffect,(SDL_Haptic *a, int b, Uint32 c),(a,b,c),return)
SDL3_SYM_RENAMED(int,HapticStopEffect,StopHapticEffect,(SDL_Haptic *a, int b),(a,b),return)
SDL3_SYM_RENAMED(void,HapticDestroyEffect,DestroyHapticEffect,(SDL_Haptic *a, int b),(a,b),)
SDL3_SYM_RENAMED(int,HapticGetEffectStatus,GetHapticEffectStatus,(SDL_Haptic *a, int b),(a,b),return)
SDL3_SYM_RENAMED(int,HapticSetGain,SetHapticGain,(SDL_Haptic *a, int b),(a,b),return)
SDL3_SYM_RENAMED(int,HapticSetAutocenter,SetHapticAutocenter,(SDL_Haptic *a, int b),(a,b),return)
SDL3_SYM_RENAMED(int,HapticPause,PauseHaptic,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED(int,HapticUnpause,ResumeHaptic,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED(int,HapticStopAll,StopHapticEffects,(SDL_Haptic *a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HapticRumbleSupported,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED(int,HapticRumbleInit,InitHapticRumble,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED(int,HapticRumblePlay,PlayHapticRumble,(SDL_Haptic *a, float b, Uint32 c),(a,b,c),return)
SDL3_SYM_RENAMED(int,HapticRumbleStop,StopHapticRumble,(SDL_Haptic *a),(a),return)
SDL3_SYM(SDL_bool,SetHintWithPriority,(const char *a, const char *b, SDL_HintPriority c),(a,b,c),return)
SDL3_SYM(SDL_bool,SetHint,(const char *a, const char *b),(a,b),return)
SDL3_SYM(const char*,GetHint,(const char *a),(a),return)
SDL3_SYM(int,AddHintCallback,(const char *a, SDL_HintCallback b, void *c),(a,b,c),)
SDL3_SYM(void,DelHintCallback,(const char *a, SDL_HintCallback b, void *c),(a,b,c),)
SDL3_SYM_PASSTHROUGH(void,ClearHints,(void),(),)
SDL3_SYM_RENAMED(const char*,JoystickName,GetJoystickName,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(SDL_JoystickGUID,JoystickGetGUID,GetJoystickGUID,(SDL_Joystick *a),(a),return)
SDL3_SYM(int,GetJoystickGUIDString,(SDL_JoystickGUID a, char *b, int c),(a,b,c),return)
SDL3_SYM_RENAMED(SDL_JoystickGUID,JoystickGetGUIDFromString,GetJoystickGUIDFromString,(const char *a),(a),return)
SDL3_SYM_RENAMED(SDL_bool,JoystickGetAttached,JoystickConnected,(SDL_Joystick *a),(a),return)
SDL3_SYM(SDL_JoystickID,GetJoystickInstanceID,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(int,JoystickNumAxes,GetNumJoystickAxes,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(int,JoystickNumHats,GetNumJoystickHats,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(int,JoystickNumButtons,GetNumJoystickButtons,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(void,JoystickUpdate,UpdateJoysticks,(void),(),)
SDL3_SYM_RENAMED(Sint16,JoystickGetAxis,GetJoystickAxis,(SDL_Joystick *a, int b),(a,b),return)
SDL3_SYM_RENAMED(Uint8,JoystickGetHat,GetJoystickHat,(SDL_Joystick *a, int b),(a,b),return)
SDL3_SYM_RENAMED(Uint8,JoystickGetButton,GetJoystickButton,(SDL_Joystick *a, int b),(a,b),return)
SDL3_SYM_RENAMED(void,JoystickClose,CloseJoystick,(SDL_Joystick *a),(a),)
SDL3_SYM_PASSTHROUGH(SDL_Window*,GetKeyboardFocus,(void),(),return)
SDL3_SYM_PASSTHROUGH(const Uint8*,GetKeyboardState,(int *a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_Keymod,GetModState,(void),(),return)
SDL3_SYM_PASSTHROUGH(void,SetModState,(SDL_Keymod a),(a),)
SDL3_SYM_PASSTHROUGH(SDL_Keycode,GetKeyFromScancode,(SDL_Scancode a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_Scancode,GetScancodeFromKey,(SDL_Keycode a),(a),return)
SDL3_SYM_PASSTHROUGH(const char*,GetScancodeName,(SDL_Scancode a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_Scancode,GetScancodeFromName,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(const char*,GetKeyName,(SDL_Keycode a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_Keycode,GetKeyFromName,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,StartTextInput,(void),(),)
SDL3_SYM_RENAMED(SDL_bool,IsTextInputActive,TextInputActive,(void),(),return)
SDL3_SYM_PASSTHROUGH(void,StopTextInput,(void),(),)
SDL3_SYM(int,SetTextInputRect,(const SDL_Rect *a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasScreenKeyboardSupport,(void),(),return)
SDL3_SYM_RENAMED(SDL_bool,IsScreenKeyboardShown,ScreenKeyboardShown,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(void*,LoadObject,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(void*,LoadFunction,(void *a, const char *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void,UnloadObject,(void *a),(a),)
SDL3_SYM_PASSTHROUGH(void,LogSetAllPriority,(SDL_LogPriority a),(a),)
SDL3_SYM_PASSTHROUGH(void,LogSetPriority,(int a, SDL_LogPriority b),(a,b),)
SDL3_SYM_PASSTHROUGH(SDL_LogPriority,LogGetPriority,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(void,LogResetPriorities,(void),(),)
SDL3_SYM_PASSTHROUGH(void,LogMessageV,(int a, SDL_LogPriority b, const char *c, va_list d),(a,b,c,d),)
SDL3_SYM_PASSTHROUGH(void,LogGetOutputFunction,(SDL_LogOutputFunction *a, void **b),(a,b),)
SDL3_SYM_PASSTHROUGH(void,LogSetOutputFunction,(SDL_LogOutputFunction a, void *b),(a,b),)
SDL3_SYM_PASSTHROUGH(void,SetMainReady,(void),(),)
SDL3_SYM_PASSTHROUGH(int,ShowMessageBox,(const SDL_MessageBoxData *a, int *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,ShowSimpleMessageBox,(Uint32 a, const char *b, const char *c, SDL_Window *d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(SDL_Window*,GetMouseFocus,(void),(),return)
SDL3_SYM(Uint32,GetMouseState,(float *a, float *b),(a,b),return)
SDL3_SYM(Uint32,GetRelativeMouseState,(float *a, float *b),(a,b),return)
SDL3_SYM(void,WarpMouseInWindow,(SDL_Window *a, float b, float c),(a,b,c),)
SDL3_SYM_PASSTHROUGH(int,SetRelativeMouseMode,(SDL_bool a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,GetRelativeMouseMode,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_Cursor*,CreateCursor,(const Uint8 *a, const Uint8 *b, int c, int d, int e, int f),(a,b,c,d,e,f),return)
SDL3_SYM_PASSTHROUGH(SDL_Cursor*,CreateColorCursor,(SDL_Surface *a, int b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(SDL_Cursor*,CreateSystemCursor,(SDL_SystemCursor a),(a),return)
SDL3_SYM(int,SetCursor,(SDL_Cursor *a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_Cursor*,GetCursor,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_Cursor*,GetDefaultCursor,(void),(),return)
SDL3_SYM_RENAMED(void,FreeCursor,DestroyCursor,(SDL_Cursor *a),(a),)
SDL3_SYM_PASSTHROUGH(SDL_Mutex*,CreateMutex,(void),(),return)
SDL3_SYM(void,LockMutex,(SDL_Mutex *a),(a),)
SDL3_SYM_PASSTHROUGH(int,TryLockMutex,(SDL_Mutex *a),(a),return)
SDL3_SYM(void,UnlockMutex,(SDL_Mutex *a),(a),)
SDL3_SYM_PASSTHROUGH(void,DestroyMutex,(SDL_Mutex *a),(a),)
SDL3_SYM_PASSTHROUGH(SDL_Semaphore*,CreateSemaphore,(Uint32 a),(a),return)
SDL3_SYM_PASSTHROUGH(void,DestroySemaphore,(SDL_Semaphore *a),(a),)
SDL3_SYM_RENAMED(int,SemWait,WaitSemaphore,(SDL_Semaphore *a),(a),return)
SDL3_SYM_RENAMED(int,SemTryWait,TryWaitSemaphore,(SDL_Semaphore *a),(a),return)
SDL3_SYM(int,WaitSemaphoreTimeout,(SDL_Semaphore *a, Sint32 b),(a,b),return)
SDL3_SYM_RENAMED(int,SemPost,PostSemaphore,(SDL_Semaphore *a),(a),return)
SDL3_SYM_RENAMED(Uint32,SemValue,GetSemaphoreValue,(SDL_Semaphore *a),(a),return)
SDL3_SYM_RENAMED(SDL_Condition*,CreateCond,CreateCondition,(void),(),return)
SDL3_SYM_RENAMED(void,DestroyCond,DestroyCondition,(SDL_Condition *a),(a),)
SDL3_SYM_RENAMED(int,CondSignal,SignalCondition,(SDL_Condition *a),(a),return)
SDL3_SYM_RENAMED(int,CondBroadcast,BroadcastCondition,(SDL_Condition *a),(a),return)
SDL3_SYM_RENAMED(int,CondWait,WaitCondition,(SDL_Condition *a, SDL_Mutex *b),(a,b),return)
SDL3_SYM(int,WaitConditionTimeout,(SDL_Condition *a, SDL_Mutex *b, Sint32 c),(a,b,c),return)
SDL3_SYM(const char*,GetPixelFormatName,(Uint32 a),(a),return)
SDL3_SYM_RENAMED(SDL_bool,PixelFormatEnumToMasks,GetMasksForPixelFormatEnum,(Uint32 a, int *b, Uint32 *c, Uint32 *d, Uint32 *e, Uint32 *f),(a,b,c,d,e,f),return)
SDL3_SYM_RENAMED(Uint32,MasksToPixelFormatEnum,GetPixelFormatEnumForMasks,(int a, Uint32 b, Uint32 c, Uint32 d, Uint32 e),(a,b,c,d,e),return)
SDL3_SYM_RENAMED(SDL_PixelFormat*,AllocFormat,CreatePixelFormat,(Uint32 a),(a),return)
SDL3_SYM(void,DestroyPixelFormat,(SDL_PixelFormat *a),(a),)
SDL3_SYM_RENAMED(SDL_Palette*,AllocPalette,CreatePalette,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,SetPixelFormatPalette,(SDL_PixelFormat *a, SDL_Palette *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,SetPaletteColors,(SDL_Palette *a, const SDL_Color *b, int c, int d),(a,b,c,d),return)
SDL3_SYM(void,DestroyPalette,(SDL_Palette *a),(a),)
SDL3_SYM_PASSTHROUGH(Uint32,MapRGB,(const SDL_PixelFormat *a, Uint8 b, Uint8 c, Uint8 d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(Uint32,MapRGBA,(const SDL_PixelFormat *a, Uint8 b, Uint8 c, Uint8 d, Uint8 e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(void,GetRGB,(Uint32 a, const SDL_PixelFormat *b, Uint8 *c, Uint8 *d, Uint8 *e),(a,b,c,d,e),)
SDL3_SYM_PASSTHROUGH(void,GetRGBA,(Uint32 a, const SDL_PixelFormat *b, Uint8 *c, Uint8 *d, Uint8 *e, Uint8 *f),(a,b,c,d,e,f),)
SDL3_SYM_PASSTHROUGH(const char*,GetPlatform,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_PowerState,GetPowerInfo,(int *a, int *b),(a,b),return)
SDL3_SYM_RENAMED(SDL_bool,HasIntersection,HasRectIntersection,(const SDL_Rect *a, const SDL_Rect *b),(a,b),return)
SDL3_SYM_RENAMED(SDL_bool,IntersectRect,GetRectIntersection,(const SDL_Rect *a, const SDL_Rect *b, SDL_Rect *c),(a,b,c),return)
SDL3_SYM(int,GetRectUnion,(const SDL_Rect *a, const SDL_Rect *b, SDL_Rect *c),(a,b,c),return)
SDL3_SYM_RENAMED(SDL_bool,EnclosePoints,GetRectEnclosingPoints,(const SDL_Point *a, int b, const SDL_Rect *c, SDL_Rect *d),(a,b,c,d),return)
SDL3_SYM_RENAMED(SDL_bool,IntersectRectAndLine,GetRectAndLineIntersection,(const SDL_Rect *a, int *b, int *c, int *d, int *e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(int,GetNumRenderDrivers,(void),(),return)
SDL3_SYM(const char *,GetRenderDriver,(int a),(a),return);
SDL3_SYM_PASSTHROUGH(int,CreateWindowAndRenderer,(int a, int b, Uint32 c, SDL_Window **d, SDL_Renderer **e),(a,b,c,d,e),return)
SDL3_SYM(SDL_Renderer*,CreateRenderer,(SDL_Window *a, const char *b, Uint32 c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(SDL_Renderer*,CreateSoftwareRenderer,(SDL_Surface *a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_Renderer*,GetRenderer,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,GetRendererInfo,(SDL_Renderer *a, SDL_RendererInfo *b),(a,b),return)
SDL3_SYM_RENAMED(int,GetRendererOutputSize,GetRenderOutputSize,(SDL_Renderer *a, int *b, int *c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(SDL_Texture*,CreateTexture,(SDL_Renderer *a, Uint32 b, int c, int d, int e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(SDL_Texture*,CreateTextureFromSurface,(SDL_Renderer *a, SDL_Surface *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,QueryTexture,(SDL_Texture *a, Uint32 *b, int *c, int *d, int *e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(int,SetTextureColorMod,(SDL_Texture *a, Uint8 b, Uint8 c, Uint8 d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(int,GetTextureColorMod,(SDL_Texture *a, Uint8 *b, Uint8 *c, Uint8 *d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(int,SetTextureAlphaMod,(SDL_Texture *a, Uint8 b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,GetTextureAlphaMod,(SDL_Texture *a, Uint8 *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,SetTextureBlendMode,(SDL_Texture *a, SDL_BlendMode b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,GetTextureBlendMode,(SDL_Texture *a, SDL_BlendMode *b),(a,b),return)
SDL3_SYM(SDL_Renderer *,GetRendererFromTexture,(SDL_Texture *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,UpdateTexture,(SDL_Texture *a, const SDL_Rect *b, const void *c, int d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(int,UpdateYUVTexture,(SDL_Texture *a, const SDL_Rect *b, const Uint8 *c, int d, const Uint8 *e, int f, const Uint8 *g, int h),(a,b,c,d,e,f,g,h),return)
SDL3_SYM_PASSTHROUGH(int,LockTexture,(SDL_Texture *a, const SDL_Rect *b, void **c, int *d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(void,UnlockTexture,(SDL_Texture *a),(a),)
SDL3_SYM_PASSTHROUGH(int,SetRenderTarget,(SDL_Renderer *a, SDL_Texture *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_Texture*,GetRenderTarget,(SDL_Renderer *a),(a),return)
SDL3_SYM(int,SetRenderViewport,(SDL_Renderer *a, const SDL_Rect *b),(a,b),return)
SDL3_SYM(int,SetRenderClipRect,(SDL_Renderer *a, const SDL_Rect *b),(a,b),return)
SDL3_SYM_RENAMED(int,RenderSetScale,SetRenderScale,(SDL_Renderer *a, float b, float c),(a,b,c),return)
SDL3_SYM(int,GetRenderViewport,(SDL_Renderer *a, SDL_Rect *b),(a,b),return)
SDL3_SYM(int,GetRenderClipRect,(SDL_Renderer *a, SDL_Rect *b),(a,b),return)
SDL3_SYM(int,GetRenderScale,(SDL_Renderer *a, float *b, float *c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,SetRenderDrawColor,(SDL_Renderer *a, Uint8 b, Uint8 c, Uint8 d, Uint8 e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(int,GetRenderDrawColor,(SDL_Renderer *a, Uint8 *b, Uint8 *c, Uint8 *d, Uint8 *e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(int,SetRenderDrawBlendMode,(SDL_Renderer *a, SDL_BlendMode b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,GetRenderDrawBlendMode,(SDL_Renderer *a, SDL_BlendMode *b),(a,b),return)
SDL3_SYM(int,RenderClear,(SDL_Renderer *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,RenderReadPixels,(SDL_Renderer *a, const SDL_Rect *b, Uint32 c, void *d, int e),(a,b,c,d,e),return)
SDL3_SYM(int,RenderPresent,(SDL_Renderer *a),(a),return)
SDL3_SYM(void,DestroyTexture,(SDL_Texture *a),(a),)
SDL3_SYM(void,DestroyRenderer,(SDL_Renderer *a),(a),)
SDL3_SYM(SDL_RWops*,RWFromFile,(const char *a, const char *b),(a,b),return)
SDL3_SYM(SDL_RWops*,RWFromMem,(void *a, size_t b),(a,b),return)
SDL3_SYM(SDL_RWops*,RWFromConstMem,(const void *a, size_t b),(a,b),return)
SDL3_SYM(SDL_RWops*,CreateRW,(void),(),return)
SDL3_SYM(void,DestroyRW,(SDL_RWops *a),(a),)
SDL3_SYM_PASSTHROUGH(void*,malloc,(size_t a),(a),return)
SDL3_SYM_PASSTHROUGH(void*,calloc,(size_t a, size_t b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void*,realloc,(void *a, size_t b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void,free,(void *a),(a),)
SDL3_SYM_PASSTHROUGH(char*,getenv,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,setenv,(const char *a, const char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void,qsort,(void *a, size_t b, size_t c, int (SDLCALL *d)(const void *, const void *)),(a,b,c,d),)
SDL3_SYM_PASSTHROUGH(int,abs,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isdigit,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isspace,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,toupper,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,tolower,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(void*,memset,(SDL_OUT_BYTECAP(c) void *a, int b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void*,memcpy,(SDL_OUT_BYTECAP(c) void *a, SDL_IN_BYTECAP(c) const void *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void*,memmove,(SDL_OUT_BYTECAP(c) void *a, SDL_IN_BYTECAP(c) const void *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,memcmp,(const void *a, const void *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(size_t,wcslen,(const wchar_t *a),(a),return)
SDL3_SYM_PASSTHROUGH(size_t,wcslcpy,(SDL_OUT_Z_CAP(c) wchar_t *a, const wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(size_t,wcslcat,(SDL_INOUT_Z_CAP(c) wchar_t *a, const wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(size_t,strlen,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(size_t,strlcpy,(SDL_OUT_Z_CAP(c) char *a, const char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(size_t,utf8strlcpy,(SDL_OUT_Z_CAP(c) char *a, const char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(size_t,strlcat,(SDL_INOUT_Z_CAP(c) char *a, const char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(char*,strdup,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(char*,strrev,(char *a),(a),return)
SDL3_SYM_PASSTHROUGH(char*,strupr,(char *a),(a),return)
SDL3_SYM_PASSTHROUGH(char*,strlwr,(char *a),(a),return)
SDL3_SYM_PASSTHROUGH(char*,strchr,(const char *a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(char*,strrchr,(const char *a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(char*,strstr,(const char *a, const char *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(char*,itoa,(int a, char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(char*,uitoa,(unsigned int a, char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(char*,ltoa,(long a, char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(char*,ultoa,(unsigned long a, char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(char*,lltoa,(Sint64 a, char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(char*,ulltoa,(Uint64 a, char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,atoi,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(double,atof,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(long,strtol,(const char *a, char **b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(unsigned long,strtoul,(const char *a, char **b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(Sint64,strtoll,(const char *a, char **b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(Uint64,strtoull,(const char *a, char **b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(double,strtod,(const char *a, char **b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,strcmp,(const char *a, const char *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,strncmp,(const char *a, const char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,strcasecmp,(const char *a, const char *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,strncasecmp,(const char *a, const char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,vsnprintf,(SDL_OUT_Z_CAP(b) char *a, size_t b, const char *c, va_list d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(double,acos,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(double,asin,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(double,atan,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(double,atan2,(double a, double b),(a,b),return)
SDL3_SYM_PASSTHROUGH(double,ceil,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(double,copysign,(double a, double b),(a,b),return)
SDL3_SYM_PASSTHROUGH(double,cos,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,cosf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(double,fabs,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(double,floor,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(double,log,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(double,pow,(double a, double b),(a,b),return)
SDL3_SYM_PASSTHROUGH(double,scalbn,(double a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(double,sin,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,sinf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(double,sqrt,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_iconv_t,iconv_open,(const char *a, const char *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,iconv_close,(SDL_iconv_t a),(a),return)
SDL3_SYM_PASSTHROUGH(size_t,iconv,(SDL_iconv_t a, const char **b, size_t *c, char **d, size_t *e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(char*,iconv_string,(const char *a, const char *b, const char *c, size_t d),(a,b,c,d),return)
SDL3_SYM(SDL_Surface*,CreateSurface,(int a, int b, Uint32 c),(a,b,c),return)
SDL3_SYM(SDL_Surface*,CreateSurfaceFrom,(void *a, int b, int c, int d, Uint32 e),(a,b,c,d,e),return)
SDL3_SYM_RENAMED(void,FreeSurface,DestroySurface,(SDL_Surface *a),(a),)
SDL3_SYM_PASSTHROUGH(int,SetSurfacePalette,(SDL_Surface *a, SDL_Palette *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,LockSurface,(SDL_Surface *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,UnlockSurface,(SDL_Surface *a),(a),)
SDL3_SYM(SDL_Surface*,LoadBMP_RW,(SDL_RWops *a, SDL_bool b),(a,b),return)
SDL3_SYM(int,SaveBMP_RW,(SDL_Surface *a, SDL_RWops *b, SDL_bool c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,SetSurfaceRLE,(SDL_Surface *a, int b),(a,b),return)
SDL3_SYM_RENAMED(int,SetColorKey,SetSurfaceColorKey,(SDL_Surface *a, int b, Uint32 c),(a,b,c),return)
SDL3_SYM_RENAMED(int,GetColorKey,GetSurfaceColorKey,(SDL_Surface *a, Uint32 *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,SetSurfaceColorMod,(SDL_Surface *a, Uint8 b, Uint8 c, Uint8 d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(int,GetSurfaceColorMod,(SDL_Surface *a, Uint8 *b, Uint8 *c, Uint8 *d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(int,SetSurfaceAlphaMod,(SDL_Surface *a, Uint8 b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,GetSurfaceAlphaMod,(SDL_Surface *a, Uint8 *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,SetSurfaceBlendMode,(SDL_Surface *a, SDL_BlendMode b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,GetSurfaceBlendMode,(SDL_Surface *a, SDL_BlendMode *b),(a,b),return)
SDL3_SYM_RENAMED(SDL_bool,SetClipRect,SetSurfaceClipRect,(SDL_Surface *a, const SDL_Rect *b),(a,b),return)
SDL3_SYM(int,GetSurfaceClipRect,(SDL_Surface *a, SDL_Rect *b),(a,b),return)
SDL3_SYM(int,ConvertEventToRenderCoordinates,(SDL_Renderer *a, SDL_Event *b),(a,b),return)
SDL3_SYM(SDL_Surface*,ConvertSurface,(SDL_Surface *a, const SDL_PixelFormat *b),(a,b),return)
SDL3_SYM(SDL_Surface*,ConvertSurfaceFormat,(SDL_Surface *a, Uint32 b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,ConvertPixels,(int a, int b, Uint32 c, const void *d, int e, Uint32 f, void *g, int h),(a,b,c,d,e,f,g,h),return)
SDL3_SYM_RENAMED(int,FillRect,FillSurfaceRect,(SDL_Surface *a, const SDL_Rect *b, Uint32 c),(a,b,c),return)
SDL3_SYM_RENAMED(int,FillRects,FillSurfaceRects,(SDL_Surface *a, const SDL_Rect *b, int c, Uint32 d),(a,b,c,d),return)
SDL3_SYM_RENAMED(int,UpperBlit,BlitSurface,(SDL_Surface *a, const SDL_Rect *b, SDL_Surface *c, SDL_Rect *d),(a,b,c,d),return)
SDL3_SYM(int,BlitSurfaceUnchecked,(SDL_Surface *a, const SDL_Rect *b, SDL_Surface *c, const SDL_Rect *d),(a,b,c,d),return)
SDL3_SYM(int,SoftStretch,(SDL_Surface *a, const SDL_Rect *b, SDL_Surface *c, const SDL_Rect *d, SDL_ScaleMode e),(a,b,c,d,e),return)
SDL3_SYM(int,BlitSurfaceScaled,(SDL_Surface *a, const SDL_Rect *b, SDL_Surface *c, SDL_Rect *d, SDL_ScaleMode e),(a,b,c,d,e),return)
SDL3_SYM(int,BlitSurfaceUncheckedScaled,(SDL_Surface *a, const SDL_Rect *b, SDL_Surface *c, const SDL_Rect *d, SDL_ScaleMode e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(const char*,GetThreadName,(SDL_Thread *a),(a),return)
SDL3_SYM(Uint64,GetCurrentThreadID,(void),(),return)
SDL3_SYM(Uint64,GetThreadID,(SDL_Thread *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,SetThreadPriority,(SDL_ThreadPriority a),(a),return)
SDL3_SYM_PASSTHROUGH(void,WaitThread,(SDL_Thread *a, int *b),(a,b),)
SDL3_SYM_PASSTHROUGH(void,DetachThread,(SDL_Thread *a),(a),)
SDL3_SYM_RENAMED(SDL_TLSID,TLSCreate,CreateTLS,(void),(),return)
SDL3_SYM_RENAMED(void*,TLSGet,GetTLS,(SDL_TLSID a),(a),return)
SDL3_SYM_RENAMED(int,TLSSet,SetTLS,(SDL_TLSID a, const void *b, void (SDLCALL *c)(void*)),(a,b,c),return)
SDL3_SYM(Uint64,GetTicks,(void),(),return)
SDL3_SYM_PASSTHROUGH(Uint64,GetPerformanceCounter,(void),(),return)
SDL3_SYM_PASSTHROUGH(Uint64,GetPerformanceFrequency,(void),(),return)
SDL3_SYM_PASSTHROUGH(void,Delay,(Uint32 a),(a),)
SDL3_SYM_PASSTHROUGH(SDL_TimerID,AddTimer,(Uint32 a, SDL_TimerCallback b, void *c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,RemoveTimer,(SDL_TimerID a),(a),return)
SDL3_SYM(SDL_TouchID*,GetTouchDevices,(int *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,GetNumTouchFingers,(SDL_TouchID a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_Finger*,GetTouchFinger,(SDL_TouchID a, int b),(a,b),return)
SDL3_SYM(int,GetVersion,(SDL_version *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,GetNumVideoDrivers,(void),(),return)
SDL3_SYM_PASSTHROUGH(const char*,GetVideoDriver,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(const char*,GetCurrentVideoDriver,(void),(),return)
SDL3_SYM(const char*,GetDisplayName,(SDL_DisplayID a),(a),return)
SDL3_SYM(int,GetDisplayBounds,(SDL_DisplayID a, SDL_Rect *b),(a,b),return)
SDL3_SYM(float,GetDisplayContentScale,(SDL_DisplayID a),(a),return)
SDL3_SYM(const SDL_DisplayMode*,GetDesktopDisplayMode,(SDL_DisplayID a),(a),return)
SDL3_SYM(const SDL_DisplayMode*,GetCurrentDisplayMode,(SDL_DisplayID a),(a),return)
SDL3_SYM(const SDL_DisplayMode*,GetClosestFullscreenDisplayMode,(SDL_DisplayID a, int b, int c, float d, SDL_bool e),(a,b,c,d,e),return)
SDL3_SYM(int,SetWindowFullscreenMode,(SDL_Window *a, const SDL_DisplayMode *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(Uint32,GetWindowPixelFormat,(SDL_Window *a),(a),return)
SDL3_SYM(SDL_Window*,CreateWindow,(const char *a, int b, int c, Uint32 d),(a,b,c,d),return)
SDL3_SYM(SDL_Window*,CreatePopupWindow,(SDL_Window *a, int b, int c, int d, int e, Uint32 f),(a,b,c,d,e,f),return)
SDL3_SYM_PASSTHROUGH(Uint32,GetWindowID,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_Window*,GetWindowFromID,(Uint32 a),(a),return)
SDL3_SYM(Uint32,GetWindowFlags,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(const char*,GetWindowTitle,(SDL_Window *a),(a),return)
SDL3_SYM(int,SetWindowTitle,(SDL_Window *a, const char *b),(a,b),return)
SDL3_SYM(int,SetWindowIcon,(SDL_Window *a, SDL_Surface *b),(a,b),return)
SDL3_SYM(int,SetWindowPosition,(SDL_Window *a, int b, int c),(a,b,c),return)
SDL3_SYM(int,GetWindowPosition,(SDL_Window *a, int *b, int *c),(a,b,c),return)
SDL3_SYM(int,GetWindowSize,(SDL_Window *a, int *b, int *c),(a,b,c),return)
SDL3_SYM(int,GetWindowMinimumSize,(SDL_Window *a, int *b, int *c),(a,b,c),return)
SDL3_SYM(int,SetWindowSize,(SDL_Window *a, int b, int c),(a,b,c),return)
SDL3_SYM(int,SetWindowMinimumSize,(SDL_Window *a, int b, int c),(a,b,c),return)
SDL3_SYM(int,SetWindowMaximumSize,(SDL_Window *a, int b, int c),(a,b,c),return)
SDL3_SYM(int,GetWindowMaximumSize,(SDL_Window *a, int *b, int *c),(a,b,c),return)
SDL3_SYM(int,SetWindowBordered,(SDL_Window *a, SDL_bool b),(a,b),return)
SDL3_SYM(int,ShowWindow,(SDL_Window *a),(a),return)
SDL3_SYM(int,HideWindow,(SDL_Window *a),(a),return)
SDL3_SYM(int,RaiseWindow,(SDL_Window *a),(a),return)
SDL3_SYM(int,MaximizeWindow,(SDL_Window *a),(a),return)
SDL3_SYM(int,MinimizeWindow,(SDL_Window *a),(a),return)
SDL3_SYM(int,RestoreWindow,(SDL_Window *a),(a),return)
SDL3_SYM(int,SetWindowFullscreen,(SDL_Window *a, SDL_bool b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_Surface*,GetWindowSurface,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,UpdateWindowSurface,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,UpdateWindowSurfaceRects,(SDL_Window *a, const SDL_Rect *b, int c),(a,b,c),return)
SDL3_SYM(int,SetWindowGrab,(SDL_Window *a, SDL_bool b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,GetWindowGrab,(SDL_Window *a),(a),return)
SDL3_SYM(void,DestroyWindow,(SDL_Window *a),(a),)
SDL3_SYM_RENAMED(SDL_bool,IsScreenSaverEnabled,ScreenSaverEnabled,(void),(),return)
SDL3_SYM(int,EnableScreenSaver,(void),(),return)
SDL3_SYM(int,DisableScreenSaver,(void),(),return)
SDL3_SYM_PASSTHROUGH(int,GL_LoadLibrary,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(void*,GL_GetProcAddress,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,GL_UnloadLibrary,(void),(),)
SDL3_SYM_PASSTHROUGH(SDL_bool,GL_ExtensionSupported,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,GL_SetAttribute,(SDL_GLattr a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,GL_GetAttribute,(SDL_GLattr a, int *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_GLContext,GL_CreateContext,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,GL_MakeCurrent,(SDL_Window *a, SDL_GLContext b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_Window*,GL_GetCurrentWindow,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_GLContext,GL_GetCurrentContext,(void),(),return)
SDL3_SYM_PASSTHROUGH(int,GL_SetSwapInterval,(int a),(a),return)
SDL3_SYM(int,GL_GetSwapInterval,(int *a),(a),return)
SDL3_SYM(int,GL_SwapWindow,(SDL_Window *a),(a),return)
SDL3_SYM(int,GL_DeleteContext,(SDL_GLContext a),(a),return)
SDL3_SYM_PASSTHROUGH(int,vsscanf,(const char *a, const char *b, va_list c),(a,b,c),return)
SDL3_SYM(int,AddGamepadMappingsFromRW,(SDL_RWops *a, SDL_bool b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void,GL_ResetAttributes,(void),(),)
SDL3_SYM_PASSTHROUGH(SDL_AssertionHandler,GetDefaultAssertionHandler,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_AssertionHandler,GetAssertionHandler,(void **a),(a),return)
SDL3_SYM_RENAMED(SDL_bool,RenderIsClipEnabled,RenderClipEnabled,(SDL_Renderer *a),(a),return)
SDL3_SYM(int,WarpMouseGlobal,(float a, float b),(a,b),return)
SDL3_SYM_PASSTHROUGH(float,sqrtf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(double,tan,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,tanf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(int,CaptureMouse,(SDL_bool a),(a),return)
SDL3_SYM_PASSTHROUGH(int,SetWindowHitTest,(SDL_Window *a, SDL_HitTest b, void *c),(a,b,c),return)
SDL3_SYM(Uint32,GetGlobalMouseState,(float *a, float *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_Window*,GetGrabbedWindow,(void),(),return)
SDL3_SYM_RENAMED(SDL_JoystickPowerLevel,JoystickCurrentPowerLevel,GetJoystickPowerLevel,(SDL_Joystick *a),(a),return)
SDL3_SYM(SDL_GameController*,GetGamepadFromInstanceID,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_Joystick*,GetJoystickFromInstanceID,(SDL_JoystickID a),(a),return)
SDL3_SYM(int,GetDisplayUsableBounds,(SDL_DisplayID a, SDL_Rect *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,GetWindowBordersSize,(SDL_Window *a, int *b, int *c, int *d, int *e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(int,SetWindowOpacity,(SDL_Window *a, float b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,GetWindowOpacity,(SDL_Window *a, float *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,SetWindowInputFocus,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,SetWindowModalFor,(SDL_Window *a, SDL_Window *b),(a,b),return)
SDL3_SYM(int,SetWindowResizable,(SDL_Window *a, SDL_bool b),(a,b),return)
SDL3_SYM(SDL_bool,GetHintBoolean,(const char *a, SDL_bool b),(a,b),return)
SDL3_SYM_RENAMED(Uint16,JoystickGetVendor,GetJoystickVendor,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(Uint16,JoystickGetProduct,GetJoystickProduct,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(Uint16,JoystickGetProductVersion,GetJoystickProductVersion,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(Uint16,GameControllerGetVendor,GetGamepadVendor,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(Uint16,GameControllerGetProduct,GetGamepadProduct,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(Uint16,GameControllerGetProductVersion,GetGamepadProductVersion,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(SDL_bool,JoystickGetAxisInitialState,GetJoystickAxisInitialState,(SDL_Joystick *a, int b, Sint16 *c),(a,b,c),return)
SDL3_SYM_RENAMED(SDL_JoystickType,JoystickGetType,GetJoystickType,(SDL_Joystick *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,MemoryBarrierReleaseFunction,(void),(),)
SDL3_SYM_PASSTHROUGH(void,MemoryBarrierAcquireFunction,(void),(),)
SDL3_SYM_PASSTHROUGH(size_t,utf8strlen,(const char *a),(a),return)
SDL3_SYM(void*,LoadFile_RW,(SDL_RWops *a, size_t *b, SDL_bool c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,wcscmp,(const wchar_t *a, const wchar_t *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_BlendMode,ComposeCustomBlendMode,(SDL_BlendFactor a, SDL_BlendFactor b, SDL_BlendOperation c, SDL_BlendFactor d, SDL_BlendFactor e, SDL_BlendOperation f),(a,b,c,d,e,f),return)
SDL3_SYM_PASSTHROUGH(SDL_Surface*,DuplicateSurface,(SDL_Surface *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,Vulkan_LoadLibrary,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(void*,Vulkan_GetVkGetInstanceProcAddr,(void),(),return)
SDL3_SYM_PASSTHROUGH(void,Vulkan_UnloadLibrary,(void),(),)
SDL3_SYM(char const* const* ,Vulkan_GetInstanceExtensions,(Uint32 *a),(a),return)
SDL3_SYM(SDL_bool,Vulkan_CreateSurface,(SDL_Window *a, VkInstance b, const struct VkAllocationCallbacks *c, VkSurfaceKHR *d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(void,GetMemoryFunctions,(SDL_malloc_func *a, SDL_calloc_func *b, SDL_realloc_func *c, SDL_free_func *d),(a,b,c,d),)
SDL3_SYM_PASSTHROUGH(int,SetMemoryFunctions,(SDL_malloc_func a, SDL_calloc_func b, SDL_realloc_func c, SDL_free_func d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(void,GetOriginalMemoryFunctions,(SDL_malloc_func *a, SDL_calloc_func *b, SDL_realloc_func *c, SDL_free_func *d),(a,b,c,d),)
SDL3_SYM_PASSTHROUGH(int,GetNumAllocations,(void),(),return)
SDL3_SYM_PASSTHROUGH(float,acosf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(float,asinf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(float,atanf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(float,atan2f,(float a, float b),(a,b),return)
SDL3_SYM_PASSTHROUGH(float,ceilf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(float,copysignf,(float a, float b),(a,b),return)
SDL3_SYM_PASSTHROUGH(float,fabsf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(float,floorf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(float,logf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(float,powf,(float a, float b),(a,b),return)
SDL3_SYM_PASSTHROUGH(float,scalbnf,(float a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(double,fmod,(double a, double b),(a,b),return)
SDL3_SYM_PASSTHROUGH(float,fmodf,(float a, float b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void,SetYUVConversionMode,(SDL_YUV_CONVERSION_MODE a),(a),)
SDL3_SYM_PASSTHROUGH(SDL_YUV_CONVERSION_MODE,GetYUVConversionMode,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_YUV_CONVERSION_MODE,GetYUVConversionModeForResolution,(int a, int b),(a,b),return)
SDL3_SYM_RENAMED(void*,RenderGetMetalLayer,GetRenderMetalLayer,(SDL_Renderer *a),(a),return)
SDL3_SYM_RENAMED(void*,RenderGetMetalCommandEncoder,GetRenderMetalCommandEncoder,(SDL_Renderer *a),(a),return)
SDL3_SYM_PASSTHROUGH(double,log10,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,log10f,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(double,exp,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,expf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(wchar_t*,wcsdup,(const wchar_t *a),(a),return)
SDL3_SYM_RENAMED(int,GameControllerRumble,RumbleGamepad,(SDL_GameController *a, Uint16 b, Uint16 c, Uint32 d),(a,b,c,d),return)
SDL3_SYM_RENAMED(int,JoystickRumble,RumbleJoystick,(SDL_Joystick *a, Uint16 b, Uint16 c, Uint32 d),(a,b,c,d),return)
SDL3_SYM(SDL_Sensor*,GetSensorFromInstanceID,(SDL_SensorID a),(a),return)
SDL3_SYM_RENAMED(const char*,SensorGetName,GetSensorName,(SDL_Sensor *a),(a),return)
SDL3_SYM_RENAMED(SDL_SensorType,SensorGetType,GetSensorType,(SDL_Sensor *a),(a),return)
SDL3_SYM_RENAMED(int,SensorGetNonPortableType,GetSensorNonPortableType,(SDL_Sensor *a),(a),return)
SDL3_SYM(SDL_SensorID,GetSensorInstanceID,(SDL_Sensor *a),(a),return)
SDL3_SYM_RENAMED(int,SensorGetData,GetSensorData,(SDL_Sensor *a, float *b, int c),(a,b,c),return)
SDL3_SYM_RENAMED(void,SensorClose,CloseSensor,(SDL_Sensor *a),(a),)
SDL3_SYM_RENAMED(void,SensorUpdate,UpdateSensors,(void),(),)
SDL3_SYM_PASSTHROUGH(SDL_bool,IsTablet,(void),(),return)
SDL3_SYM(SDL_DisplayOrientation,GetCurrentDisplayOrientation,(SDL_DisplayID a),(a),return)
SDL3_SYM_RENAMED(SDL_bool,HasColorKey,SurfaceHasColorKey,(SDL_Surface *a),(a),return)
SDL3_SYM_RENAMED(int,RenderFlush,FlushRenderer,(SDL_Renderer *a),(a),return)
SDL3_SYM(int,RenderPoint,(SDL_Renderer *a, float b, float c),(a,b,c),return)
SDL3_SYM(int,RenderPoints,(SDL_Renderer *a, const SDL_FPoint *b, int c),(a,b,c),return)
SDL3_SYM(int,RenderLine,(SDL_Renderer *a, float b, float c, float d, float e),(a,b,c,d,e),return)
SDL3_SYM(int,RenderLines,(SDL_Renderer *a, const SDL_FPoint *b, int c),(a,b,c),return)
SDL3_SYM(int,RenderRect,(SDL_Renderer *a, const SDL_FRect *b),(a,b),return)
SDL3_SYM(int,RenderRects,(SDL_Renderer *a, const SDL_FRect *b, int c),(a,b,c),return)
SDL3_SYM(int,RenderFillRect,(SDL_Renderer *a, const SDL_FRect *b),(a,b),return)
SDL3_SYM(int,RenderFillRects,(SDL_Renderer *a, const SDL_FRect *b, int c),(a,b,c),return)
SDL3_SYM(int,RenderTexture,(SDL_Renderer *a, SDL_Texture *b, const SDL_FRect *c, const SDL_FRect *d),(a,b,c,d),return)
SDL3_SYM(int,RenderTextureRotated,(SDL_Renderer *a, SDL_Texture *b, const SDL_FRect *c, const SDL_FRect *d, const double e, const SDL_FPoint *f, const SDL_FlipMode g),(a,b,c,d,e,f,g),return)
SDL3_SYM_PASSTHROUGH(SDL_TouchDeviceType,GetTouchDeviceType,(SDL_TouchID a),(a),return)
SDL3_SYM_PASSTHROUGH(size_t,SIMDGetAlignment,(void),(),return)
SDL3_SYM(void*,aligned_alloc,(size_t a, size_t b),(a,b),return)
SDL3_SYM(void,aligned_free,(void *a),(a),)
SDL3_SYM(Sint64,RWsize,(SDL_RWops *a),(a),return)
SDL3_SYM(Sint64,RWseek,(SDL_RWops *a, Sint64 b, int c),(a,b,c),return)
SDL3_SYM(Sint64,RWtell,(SDL_RWops *a),(a),return)
SDL3_SYM(size_t,RWread,(SDL_RWops *a, void *b, size_t c),(a,b,c),return)
SDL3_SYM(size_t,RWwrite,(SDL_RWops *a, const void *b, size_t c),(a,b,c),return)
SDL3_SYM(int,RWclose,(SDL_RWops *a),(a),return)
SDL3_SYM_PASSTHROUGH(void*,LoadFile,(const char *a, size_t *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_MetalView,Metal_CreateView,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,Metal_DestroyView,(SDL_MetalView a),(a),)
SDL3_SYM_PASSTHROUGH(int,LockTextureToSurface,(SDL_Texture *a, const SDL_Rect *b, SDL_Surface **c),(a,b,c),return)
SDL3_SYM_RENAMED(char*,strtokr,strtok_r,(char *a, const char *b, char **c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(wchar_t*,wcsstr,(const wchar_t *a, const wchar_t *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,wcsncmp,(const wchar_t *a, const wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM(SDL_GamepadType,GetGamepadType,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(SDL_GameController*,GameControllerFromPlayerIndex,GetGamepadFromPlayerIndex,(int a),(a),return)
SDL3_SYM(int,SetGamepadPlayerIndex,(SDL_GameController *a, int b),(a,b),return)
SDL3_SYM_RENAMED(SDL_Joystick*,JoystickFromPlayerIndex,GetJoystickFromPlayerIndex,(int a),(a),return)
SDL3_SYM(int,SetJoystickPlayerIndex,(SDL_Joystick *a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,SetTextureScaleMode,(SDL_Texture *a, SDL_ScaleMode b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,GetTextureScaleMode,(SDL_Texture *a, SDL_ScaleMode *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void,OnApplicationWillTerminate,(void),(),)
SDL3_SYM_PASSTHROUGH(void,OnApplicationDidReceiveMemoryWarning,(void),(),)
SDL3_SYM_PASSTHROUGH(void,OnApplicationWillResignActive,(void),(),)
SDL3_SYM_PASSTHROUGH(void,OnApplicationDidEnterBackground,(void),(),)
SDL3_SYM_PASSTHROUGH(void,OnApplicationWillEnterForeground,(void),(),)
SDL3_SYM_PASSTHROUGH(void,OnApplicationDidBecomeActive,(void),(),)
SDL3_SYM_PASSTHROUGH(int,isupper,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,islower,(int a),(a),return)
SDL3_SYM_RENAMED(int,JoystickGetPlayerIndex,GetJoystickPlayerIndex,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(int,GameControllerGetPlayerIndex,GetGamepadPlayerIndex,(SDL_GameController *a),(a),return)
SDL3_SYM(SDL_JoystickID,AttachVirtualJoystick,(SDL_JoystickType a, int b, int c, int d),(a,b,c,d),return)
SDL3_SYM(int,DetachVirtualJoystick,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_JoystickID,AttachVirtualJoystickEx,(const SDL_VirtualJoystickDesc *a),(a),return)
SDL3_SYM_RENAMED(int,JoystickSetVirtualAxis,SetJoystickVirtualAxis,(SDL_Joystick *a, int b, Sint16 c),(a,b,c),return)
SDL3_SYM_RENAMED(int,JoystickSetVirtualButton,SetJoystickVirtualButton,(SDL_Joystick *a, int b, Uint8 c),(a,b,c),return)
SDL3_SYM_RENAMED(int,JoystickSetVirtualHat,SetJoystickVirtualHat,(SDL_Joystick *a, int b, Uint8 c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void*,Metal_GetLayer,(SDL_MetalView a),(a),return)
SDL3_SYM_PASSTHROUGH(double,trunc,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,truncf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_Locale *,GetPreferredLocales,(void),(),return)
SDL3_SYM_PASSTHROUGH(int,OpenURL,(const char *a),(a),return)
SDL3_SYM_RENAMED(SDL_bool,HasSurfaceRLE,SurfaceHasRLE,(SDL_Surface *a),(a),return)
SDL3_SYM_RENAMED(int,GameControllerSetLED,SetGamepadLED,(SDL_GameController *a, Uint8 b, Uint8 c, Uint8 d),(a,b,c,d),return)
SDL3_SYM_RENAMED(int,JoystickSetLED,SetJoystickLED,(SDL_Joystick *a, Uint8 b, Uint8 c, Uint8 d),(a,b,c,d),return)
SDL3_SYM_RENAMED(int,GameControllerRumbleTriggers,RumbleGamepadTriggers,(SDL_GameController *a, Uint16 b, Uint16 c, Uint32 d),(a,b,c,d),return)
SDL3_SYM_RENAMED(int,JoystickRumbleTriggers,RumbleJoystickTriggers,(SDL_Joystick *a, Uint16 b, Uint16 c, Uint32 d),(a,b,c,d),return)
SDL3_SYM_RENAMED(SDL_bool,GameControllerHasAxis,GamepadHasAxis,(SDL_GameController *a, SDL_GameControllerAxis b),(a,b),return)
SDL3_SYM_RENAMED(SDL_bool,GameControllerHasButton,GamepadHasButton,(SDL_GameController *a, SDL_GameControllerButton b),(a,b),return)
SDL3_SYM_RENAMED(int,GameControllerGetNumTouchpads,GetNumGamepadTouchpads,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(int,GameControllerGetNumTouchpadFingers,GetNumGamepadTouchpadFingers,(SDL_GameController *a, int b),(a,b),return)
SDL3_SYM_RENAMED(int,GameControllerGetTouchpadFinger,GetGamepadTouchpadFinger,(SDL_GameController *a, int b, int c, Uint8 *d, float *e, float *f, float *g),(a,b,c,d,e,f,g),return)
SDL3_SYM_PASSTHROUGH(Uint32,crc32,(Uint32 a, const void *b, size_t c),(a,b,c),return)
SDL3_SYM_RENAMED(const char*,GameControllerGetSerial,GetGamepadSerial,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(const char*,JoystickGetSerial,GetJoystickSerial,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(SDL_bool,GameControllerHasSensor,GamepadHasSensor,(SDL_GameController *a, SDL_SensorType b),(a,b),return)
SDL3_SYM_RENAMED(int,GameControllerSetSensorEnabled,SetGamepadSensorEnabled,(SDL_GameController *a, SDL_SensorType b, SDL_bool c),(a,b,c),return)
SDL3_SYM_RENAMED(SDL_bool,GameControllerIsSensorEnabled,GamepadSensorEnabled,(SDL_GameController *a, SDL_SensorType b),(a,b),return)
SDL3_SYM_RENAMED(int,GameControllerGetSensorData,GetGamepadSensorData,(SDL_GameController *a, SDL_SensorType b, float *c, int d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(int,wcscasecmp,(const wchar_t *a, const wchar_t *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,wcsncasecmp,(const wchar_t *a, const wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(double,round,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,roundf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(long,lround,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(long,lroundf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(int,UpdateNVTexture,(SDL_Texture *a, const SDL_Rect *b, const Uint8 *c, int d, const Uint8 *e, int f),(a,b,c,d,e,f),return)
SDL3_SYM(int,SetWindowKeyboardGrab,(SDL_Window *a, SDL_bool b),(a,b),return)
SDL3_SYM(int,SetWindowMouseGrab,(SDL_Window *a, SDL_bool b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,GetWindowKeyboardGrab,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,GetWindowMouseGrab,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isalpha,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isalnum,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isblank,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,iscntrl,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isxdigit,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,ispunct,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isprint,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isgraph,(int a),(a),return)
SDL3_SYM_RENAMED(void,TLSCleanup,CleanupTLS,(void),(),)
SDL3_SYM(int,SetWindowAlwaysOnTop,(SDL_Window *a, SDL_bool b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,FlashWindow,(SDL_Window *a, SDL_FlashOperation b),(a,b),return)
SDL3_SYM_RENAMED(int,GameControllerSendEffect,SendGamepadEffect,(SDL_GameController *a, const void *b, int c),(a,b,c),return)
SDL3_SYM_RENAMED(int,JoystickSendEffect,SendJoystickEffect,(SDL_Joystick *a, const void *b, int c),(a,b,c),return)
SDL3_SYM_RENAMED(float,GameControllerGetSensorDataRate,GetGamepadSensorDataRate,(SDL_GameController *a, SDL_SensorType b),(a,b),return)
SDL3_SYM(int,RenderGeometry,(SDL_Renderer *a, SDL_Texture *b, const SDL_Vertex *c, int d, const int *e, int f),(a,b,c,d,e,f),return)
SDL3_SYM(int,RenderGeometryRaw,(SDL_Renderer *a, SDL_Texture *b, const float *c, int d, const SDL_Color *e, int f, const float *g, int h, int i, const void *j, int k, int l),(a,b,c,d,e,f,g,h,i,j,k,l),return)
SDL3_SYM_RENAMED(int,RenderSetVSync,SetRenderVSync,(SDL_Renderer *a, int b),(a,b),return)
SDL3_SYM_VARARGS(int,asprintf,(char **a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_PASSTHROUGH(int,vasprintf,(char **a, const char *b, va_list c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void*,GetWindowICCProfile,(SDL_Window *a, size_t *b),(a,b),return)
SDL3_SYM_RENAMED(const char*,GameControllerGetAppleSFSymbolsNameForButton,GetGamepadAppleSFSymbolsNameForButton,(SDL_GameController *a, SDL_GameControllerButton b),(a,b),return)
SDL3_SYM_RENAMED(const char*,GameControllerGetAppleSFSymbolsNameForAxis,GetGamepadAppleSFSymbolsNameForAxis,(SDL_GameController *a, SDL_GameControllerAxis b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,hid_init,(void),(),return)
SDL3_SYM_PASSTHROUGH(int,hid_exit,(void),(),return)
SDL3_SYM_PASSTHROUGH(Uint32,hid_device_change_count,(void),(),return)
SDL3_SYM(SDL_hid_device_info*,hid_enumerate,(unsigned short a, unsigned short b),(a,b),return)
SDL3_SYM(void,hid_free_enumeration,(SDL_hid_device_info *a),(a),)
SDL3_SYM_PASSTHROUGH(SDL_hid_device*,hid_open,(unsigned short a, unsigned short b, const wchar_t *c),(a,b,c),return)
SDL3_SYM(SDL_hid_device*,hid_open_path,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,hid_write,(SDL_hid_device *a, const unsigned char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,hid_read_timeout,(SDL_hid_device *a, unsigned char *b, size_t c, int d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(int,hid_read,(SDL_hid_device *a, unsigned char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,hid_set_nonblocking,(SDL_hid_device *a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,hid_send_feature_report,(SDL_hid_device *a, const unsigned char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,hid_get_feature_report,(SDL_hid_device *a, unsigned char *b, size_t c),(a,b,c),return)
SDL3_SYM(int,hid_close,(SDL_hid_device *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,hid_get_manufacturer_string,(SDL_hid_device *a, wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,hid_get_product_string,(SDL_hid_device *a, wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,hid_get_serial_number_string,(SDL_hid_device *a, wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,hid_get_indexed_string,(SDL_hid_device *a, int b, wchar_t *c, size_t d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(int,SetWindowMouseRect,(SDL_Window *a, const SDL_Rect *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(const SDL_Rect*,GetWindowMouseRect,(SDL_Window *a),(a),return)
SDL3_SYM(int,RenderCoordinatesFromWindow,(SDL_Renderer *a, float b, float c, float *d, float *e),(a,b,c,d,e),return)
SDL3_SYM(int,RenderCoordinatesToWindow,(SDL_Renderer *a, float b, float c, float *d, float *e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(void,hid_ble_scan,(SDL_bool a),(a),)
SDL3_SYM_PASSTHROUGH(int,PremultiplyAlpha,(int a, int b, Uint32 c, const void *d, int e, Uint32 f, void *g, int h),(a,b,c,d,e,f,g,h),return)
SDL3_SYM(const char*,GetTouchDeviceName,(SDL_TouchID a),(a),return)
SDL3_SYM_PASSTHROUGH(void,ClearComposition,(void),(),)
SDL3_SYM_RENAMED(SDL_bool,IsTextInputShown,TextInputShown,(void),(),return)
SDL3_SYM_RENAMED(SDL_bool,HasIntersectionF,HasRectIntersectionFloat,(const SDL_FRect *a, const SDL_FRect *b),(a,b),return)
SDL3_SYM_RENAMED(SDL_bool,IntersectFRect,GetRectIntersectionFloat,(const SDL_FRect *a, const SDL_FRect *b, SDL_FRect *c),(a,b,c),return)
SDL3_SYM(int,GetRectUnionFloat,(const SDL_FRect *a, const SDL_FRect *b, SDL_FRect *c),(a,b,c),return)
SDL3_SYM_RENAMED(SDL_bool,EncloseFPoints,GetRectEnclosingPointsFloat,(const SDL_FPoint *a, int b, const SDL_FRect *c, SDL_FRect *d),(a,b,c,d),return)
SDL3_SYM_RENAMED(SDL_bool,IntersectFRectAndLine,GetRectAndLineIntersectionFloat,(const SDL_FRect *a, float *b, float *c, float *d, float *e),(a,b,c,d,e),return)
SDL3_SYM_RENAMED(SDL_Window*,RenderGetWindow,GetRenderWindow,(SDL_Renderer *a),(a),return)
SDL3_SYM_PASSTHROUGH(void*,bsearch,(const void *a, const void *b, size_t c, size_t d, int (SDLCALL *e)(const void *, const void *)),(a,b,c,d,e),return)
SDL3_SYM_RENAMED(const char*,GameControllerPath,GetGamepadPath,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(const char*,JoystickPath,GetJoystickPath,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(Uint16,GameControllerGetFirmwareVersion,GetGamepadFirmwareVersion,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(Uint16,JoystickGetFirmwareVersion,GetJoystickFirmwareVersion,(SDL_Joystick *a),(a),return)
SDL3_SYM(int,GUIDToString,(SDL_GUID a, char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(SDL_GUID,GUIDFromString,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(size_t,utf8strnlen,(const char *a, size_t b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void,ResetKeyboard,(void),(),)
SDL3_SYM(SDL_bool,ResetHint,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(Uint16,crc16,(Uint16 a, const void *b, size_t c),(a,b,c),return)
SDL3_SYM(int,GetWindowSizeInPixels,(SDL_Window *a, int *b, int *c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void,GetJoystickGUIDInfo,(SDL_JoystickGUID a, Uint16 *b, Uint16 *c, Uint16 *d, Uint16 *e),(a,b,c,d,e),)
SDL3_SYM_PASSTHROUGH(int,SetPrimarySelectionText,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(char*,GetPrimarySelectionText,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasPrimarySelectionText,(void),(),return)
SDL3_SYM_PASSTHROUGH(void,ResetHints,(void),(),)
SDL3_SYM_PASSTHROUGH(char*,strcasestr,(const char *a, const char *b),(a,b),return)
SDL3_SYM(void,SetEventEnabled,(Uint32 a, SDL_bool b),(a,b),)
SDL3_SYM(SDL_bool,EventEnabled,(Uint32 a),(a),return)
SDL3_SYM(void,SetGamepadEventsEnabled,(SDL_bool a),(a),)
SDL3_SYM(SDL_bool,GamepadEventsEnabled,(void),(),return)
SDL3_SYM(void,SetJoystickEventsEnabled,(SDL_bool a),(a),)
SDL3_SYM(SDL_bool,JoystickEventsEnabled,(void),(),return)
SDL3_SYM(int,ShowCursor,(void),(),return)
SDL3_SYM(int,HideCursor,(void),(),return)
SDL3_SYM(SDL_bool,CursorVisible,(void),(),return)
SDL3_SYM(SDL_JoystickID*,GetJoysticks,(int *a),(a),return)
SDL3_SYM(SDL_JoystickGUID,GetJoystickInstanceGUID,(SDL_JoystickID a),(a),return)
SDL3_SYM(const char *,GetJoystickInstanceName,(SDL_JoystickID a),(a),return)
SDL3_SYM(const char *,GetJoystickInstancePath,(SDL_JoystickID a),(a),return)
SDL3_SYM(Uint16,GetJoystickInstanceVendor,(SDL_JoystickID a),(a),return)
SDL3_SYM(Uint16,GetJoystickInstanceProduct,(SDL_JoystickID a),(a),return)
SDL3_SYM(Uint16,GetJoystickInstanceProductVersion,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_JoystickType,GetJoystickInstanceType,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_bool,IsJoystickVirtual,(SDL_JoystickID a),(a),return)
SDL3_SYM(int,GetJoystickInstancePlayerIndex,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_JoystickID*,GetGamepads,(int *a),(a),return)
SDL3_SYM(SDL_Gamepad *,OpenGamepad,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_Joystick *,OpenJoystick,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_JoystickID,GetGamepadInstanceID,(SDL_GameController *a),(a),return)
SDL3_SYM(char *,GetGamepadInstanceMapping,(SDL_JoystickID a),(a),return)
SDL3_SYM(const char *,GetGamepadInstanceName,(SDL_JoystickID a),(a),return)
SDL3_SYM(const char *,GetGamepadInstancePath,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_bool,IsGamepad,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_GamepadType,GetGamepadInstanceType,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_SensorID *,GetSensors,(int *a),(a),return)
SDL3_SYM(const char *,GetSensorInstanceName,(SDL_SensorID a),(a),return)
SDL3_SYM(SDL_SensorType,GetSensorInstanceType,(SDL_SensorID a),(a),return)
SDL3_SYM(int,GetSensorInstanceNonPortableType,(SDL_SensorID a),(a),return)
SDL3_SYM(SDL_Sensor *,OpenSensor,(SDL_SensorID a),(a),return)
SDL3_SYM(double,modf,(double a, double *b),(a,b),return)
SDL3_SYM(float,modff,(float a, float *b),(a,b),return)
SDL3_SYM(SDL_DisplayID*,GetDisplays,(int *a),(a),return)
SDL3_SYM(SDL_DisplayID,GetDisplayForWindow,(SDL_Window *a),(a),return)
SDL3_SYM(SDL_DisplayID,GetDisplayForPoint,(const SDL_Point *a),(a),return)
SDL3_SYM(SDL_DisplayID,GetDisplayForRect,(const SDL_Rect *a),(a),return)
SDL3_SYM(SDL_DisplayID,GetPrimaryDisplay,(void),(),return)
SDL3_SYM(int,RunApp,(int a, char **b, SDL_main_func c, void *d),(a,b,c,d),return)
SDL3_SYM(const SDL_DisplayMode *,GetWindowFullscreenMode,(SDL_Window *a),(a),return)
SDL3_SYM(const SDL_DisplayMode **,GetFullscreenDisplayModes,(SDL_DisplayID a, int *b),(a,b),return)
SDL3_SYM(int,GetRenderLogicalPresentation,(SDL_Renderer *a, int *b, int *c, SDL_RendererLogicalPresentation *d, SDL_ScaleMode *e),(a,b,c,d,e),return)
SDL3_SYM(int,SetRenderLogicalPresentation,(SDL_Renderer *a, int b, int c, SDL_RendererLogicalPresentation d, SDL_ScaleMode e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(SDL_bool,HasWindowSurface,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,DestroyWindowSurface,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,GetNumAudioDrivers,(void),(),return)
SDL3_SYM_PASSTHROUGH(const char*,GetAudioDriver,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(const char*,GetCurrentAudioDriver,(void),(),return)
SDL3_SYM(SDL_AudioDeviceID*,GetAudioOutputDevices,(int *a),(a),return)
SDL3_SYM(SDL_AudioDeviceID*,GetAudioCaptureDevices,(int *a),(a),return)
SDL3_SYM(char*,GetAudioDeviceName,(SDL_AudioDeviceID a),(a),return)
SDL3_SYM(int,GetAudioDeviceFormat,(SDL_AudioDeviceID a, SDL_AudioSpec *b, int *c),(a,b,c),return)
SDL3_SYM(SDL_AudioDeviceID,OpenAudioDevice,(SDL_AudioDeviceID a, const SDL_AudioSpec *b),(a,b),return)
SDL3_SYM(void,CloseAudioDevice,(SDL_AudioDeviceID a),(a),)
SDL3_SYM(int,BindAudioStream,(SDL_AudioDeviceID a, SDL_AudioStream *b),(a,b),return)
SDL3_SYM(SDL_AudioStream*,CreateAudioStream,(const SDL_AudioSpec *a, const SDL_AudioSpec *b),(a,b),return)
SDL3_SYM(int,PutAudioStreamData,(SDL_AudioStream *a, const void *b, int c),(a,b,c),return)
SDL3_SYM(int,GetAudioStreamData,(SDL_AudioStream *a, void *b, int c),(a,b,c),return)
SDL3_SYM(int,GetAudioStreamAvailable,(SDL_AudioStream *a),(a),return)
SDL3_SYM(int,FlushAudioStream,(SDL_AudioStream *a),(a),return)
SDL3_SYM(int,ClearAudioStream,(SDL_AudioStream *a),(a),return)
SDL3_SYM(int,LockAudioStream,(SDL_AudioStream *a),(a),return)
SDL3_SYM(int,UnlockAudioStream,(SDL_AudioStream *a),(a),return)
SDL3_SYM(int,SetAudioStreamGetCallback,(SDL_AudioStream *a, SDL_AudioStreamCallback b, void *c),(a,b,c),return)
SDL3_SYM(int,SetAudioStreamPutCallback,(SDL_AudioStream *a, SDL_AudioStreamCallback b, void *c),(a,b,c),return)
SDL3_SYM(void,DestroyAudioStream,(SDL_AudioStream *a),(a),)
SDL3_SYM(int,LoadWAV_RW,(SDL_RWops *a, SDL_bool b, SDL_AudioSpec *c, Uint8 **d, Uint32 *e),(a,b,c,d,e),return)
SDL3_SYM(int,MixAudioFormat,(Uint8 *a, const Uint8 *b, SDL_AudioFormat c, Uint32 d, int e),(a,b,c,d,e),return)
SDL3_SYM(int,GetSilenceValueForFormat,(SDL_AudioFormat a),(a),return)
SDL3_SYM(int,PauseAudioDevice,(SDL_AudioDeviceID a),(a),return)
SDL3_SYM(int,ResumeAudioDevice,(SDL_AudioDeviceID a),(a),return)
SDL3_SYM(SDL_bool,AudioDevicePaused,(SDL_AudioDeviceID a),(a),return)
SDL3_SYM(SDL_AudioDeviceID,GetAudioStreamDevice,(SDL_AudioStream *a),(a),return)
SDL3_SYM(SDL_GamepadBinding **,GetGamepadBindings,(SDL_Gamepad *a, int *b),(a,b),return)
SDL3_SYM(int,SetProperty,(SDL_PropertiesID a, const char *b, void *c),(a,b,c),return)
SDL3_SYM(void*,GetProperty,(SDL_PropertiesID a, const char *b, void *c),(a,b,c),return)
SDL3_SYM(SDL_PropertiesID,GetWindowProperties,(SDL_Window *a),(a),return)
SDL3_SYM(SDL_PropertiesID,GetTextureProperties,(SDL_Texture *a),(a),return)
SDL3_SYM(SDL_PropertiesID,GetRendererProperties,(SDL_Renderer *a),(a),return)
SDL3_SYM(SDL_GamepadButtonLabel,GetGamepadButtonLabel,(SDL_Gamepad *a, SDL_GamepadButton b),(a,b),return)
SDL3_SYM(Sint64,GetNumberProperty,(SDL_PropertiesID a, const char *b, Sint64 c),(a,b,c),return)
SDL3_SYM(SDL_bool,GetBooleanProperty,(SDL_PropertiesID a, const char *b, SDL_bool c),(a,b,c),return)
SDL3_SYM(float,GetFloatProperty,(SDL_PropertiesID a, const char *b, float c),(a,b,c),return)
SDL3_SYM(SDL_PropertiesID,CreateProperties,(void),(),return)
SDL3_SYM(int,SetBooleanProperty,(SDL_PropertiesID a, const char *b, SDL_bool c),(a,b,c),return)
SDL3_SYM(int,SetNumberProperty,(SDL_PropertiesID a, const char *b, Sint64 c),(a,b,c),return)
SDL3_SYM(int,SetStringProperty,(SDL_PropertiesID a, const char *b, const char *c),(a,b,c),return)
SDL3_SYM(void,DestroyProperties,(SDL_PropertiesID a),(a),)
SDL3_SYM(SDL_Window*,CreateWindowWithProperties,(SDL_PropertiesID a),(a),return)
SDL3_SYM(char **,GetGamepadMappings,(int *a),(a),return)
SDL3_SYM_RENAMED(Uint64,GameControllerGetSteamHandle,GetGamepadSteamHandle,(SDL_GameController *a),(a),return)
SDL3_SYM(SDL_HapticID *,GetHaptics,(int *a),(a),return)
SDL3_SYM(const char *,GetHapticInstanceName,(SDL_HapticID a),(a),return)
SDL3_SYM(SDL_Haptic *,GetHapticFromInstanceID,(SDL_HapticID a),(a),return)
SDL3_SYM(SDL_HapticID,GetHapticInstanceID,(SDL_Haptic *a),(a),return)
SDL3_SYM(Uint32,GetJoystickCaps,(SDL_Joystick *a),(a),return)
SDL3_SYM(Uint32,GetGamepadCaps,(SDL_GameController *a),(a),return)

#undef SDL3_SYM
#undef SDL3_SYM_PASSTHROUGH
#undef SDL3_SYM_RENAMED
#undef SDL3_SYM_VARARGS
