use core:debug;
use lang:bs:macro;

void intMapAdd(Int->Int to, Int[] keys, Int[] values) {
	if (keys.count == values.count) {
		for (Nat i = 0; i < keys.count; i++) {
			to.put(keys[i], values[i]);
		}
	}
}

Int->Int intMapTest(Int[] keys, Int[] values) {
	Int->Int result;
	intMapAdd(result, keys, values);
	result;
}

void strMapAdd(Str->Str to, Str[] keys, Str[] values) {
	if (keys.count == values.count) {
		for (Nat i = 0; i < keys.count; i++) {
			to.put(keys[i], values[i]);
		}
	}
}

Str->Str strMapTest(Str[] keys, Str[] values) {
	Str->Str result;
	strMapAdd(result, keys, values);
	result;
}

Int readIntMap(Int->Int src, Int k) {
	if (src.has(k)) {
		src.get(k);
	} else {
		0;
	}
}

Str readStrMap(Str->Str src, Str k) {
	if (src.has(k)) {
		src.get(k);
	} else {
		"";
	}
}

Str readStrLiteral(Str->Str src) {
	if (src.has("A")) {
		src.get("A");
	} else {
		"";
	}
}

Str strA() {
	"A";
}

Str readStrFn(Str->Str src) {
	if (src.has(strA())) {
		src.get(strA());
	} else {
		"";
	}
}

Int addMap() {
	Int->Int m;
	m[10] = 20;

	m[10];
}

Int addMapStr() {
	Int->Str m;

	m[10] = "25";

	m[10].toInt;
}

Int iterateMap(Int->Int data) {
	Int r = 0;
	for (k, v in data) {
		r += k*v;
	}
	r;
}

Int defaultMapInt() {
	Int->Int m;
	m[1];
}

Str defaultMapStr() {
	Int->Str m;
	m[1];
}

Str[] defaultMapArray() {
	Map<Int, Str[]> m;
	m[1];
}

Str mapAtStr(Str->Str map) {
	if (v = map.at("a")) {
		v;
	} else {
		"nothing";
	}
}

Int mapAtInt(Int->Int map) {
	if (v = map.at(1)) {
		v;
	} else {
		-1;
	}
}
