# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


## Window controls

messenger-window-minimize-button =
    .tooltiptext = Minimise
messenger-window-maximize-button =
    .tooltiptext = Maximise
messenger-window-restore-down-button =
    .tooltiptext = Restore Down
messenger-window-close-button =
    .tooltiptext = Close
# Variables:
# $count (Number) - Number of unread messages.
unread-messages-os-tooltip =
    { $count ->
        [one] 1 unread message
       *[other] { $count } unread messages
    }
about-rights-notification-text = { -brand-short-name } is free and open source software, built by a community of thousands from all over the world.

## Content tabs

content-tab-page-loading-icon =
    .alt = The page is loading
content-tab-security-high-icon =
    .alt = The connection is secure
content-tab-security-broken-icon =
    .alt = The connection is not secure

## Toolbar

addons-and-themes-toolbarbutton =
    .label = Add-ons and Themes
    .tooltiptext = Manage your add-ons
quick-filter-toolbarbutton =
    .label = Quick Filter
    .tooltiptext = Filter messages
redirect-msg-button =
    .label = Redirect
    .tooltiptext = Redirect selected message

## Folder Pane

folder-pane-toolbar =
    .toolbarname = Folder Pane Toolbar
    .accesskey = F
folder-pane-toolbar-options-button =
    .tooltiptext = Folder Pane Options
folder-pane-header-label = Folders

## Folder Toolbar Header Popup

folder-toolbar-hide-toolbar-toolbarbutton =
    .label = Hide Toolbar
    .accesskey = H
show-all-folders-label =
    .label = All Folders
    .accesskey = A
show-unread-folders-label =
    .label = Unread Folders
    .accesskey = n
show-favorite-folders-label =
    .label = Favourite Folders
    .accesskey = F
show-smart-folders-label =
    .label = Unified Folders
    .accesskey = U
show-recent-folders-label =
    .label = Recent Folders
    .accesskey = R
folder-toolbar-toggle-folder-compact-view =
    .label = Compact View
    .accesskey = C

## Menu

redirect-msg-menuitem =
    .label = Redirect
    .accesskey = d
menu-file-save-as-file =
    .label = File…
    .accesskey = F

## AppMenu

# Since v89 we dropped the platforms distinction between Options or Preferences
# and consolidated everything with Preferences.
appmenu-preferences =
    .label = Preferences
appmenu-save-as-file =
    .label = File…
appmenu-settings =
    .label = Settings
appmenu-addons-and-themes =
    .label = Add-ons and Themes
appmenu-help-enter-troubleshoot-mode =
    .label = Troubleshoot Mode…
appmenu-help-exit-troubleshoot-mode =
    .label = Turn Troubleshoot Mode Off
appmenu-help-more-troubleshooting-info =
    .label = More Troubleshooting Information
appmenu-redirect-msg =
    .label = Redirect

## Context menu

context-menu-redirect-msg =
    .label = Redirect
mail-context-delete-messages =
    .label =
        { $count ->
            [one] Delete message
           *[other] Delete selected messages
        }
context-menu-decrypt-to-folder =
    .label = Copy As Decrypted To
    .accesskey = y

## Message header pane

other-action-redirect-msg =
    .label = Redirect
message-header-msg-flagged =
    .title = Starred
    .aria-label = Starred
message-header-msg-not-flagged =
    .title = Not star marked message

## Action Button Context Menu

toolbar-context-menu-manage-extension =
    .label = Manage Extension
    .accesskey = E
toolbar-context-menu-remove-extension =
    .label = Remove Extension
    .accesskey = v

## Message headers

message-header-address-in-address-book-icon =
    .alt = Address is in the Address Book
message-header-address-not-in-address-book-icon =
    .alt = Address is not in the Address Book

## Add-on removal warning

# Variables:
#  $name (String): The name of the addon that will be removed.
addon-removal-title = Remove { $name }?
addon-removal-confirmation-button = Remove
addon-removal-confirmation-message = Remove { $name } as well as its configuration and data from { -brand-short-name }?
caret-browsing-prompt-title = Caret Browsing
caret-browsing-prompt-text = Pressing F7 turns Caret Browsing on or off. This feature places a moveable cursor within some content, allowing you to select text with the keyboard. Do you want to turn Caret Browsing on?
caret-browsing-prompt-check-text = Do not ask again.
repair-text-encoding-button =
    .label = Repair Text Encoding
    .tooltiptext = Guess correct text encoding from message content

## no-reply handling

no-reply-title = Reply Not Supported
no-reply-message = The reply address ({ $email }) does not appear to be a monitored address. Messages to this address will likely not be read by anyone.
no-reply-reply-anyway-button = Reply Anyway

## error messages

decrypt-and-copy-failures = { $failures } of { $total } messages could not be decrypted and were not copied.

## Spaces toolbar

spaces-toolbar =
    .toolbarname = Spaces Toolbar
spaces-toolbar-button-mail =
    .title = Switch to the mail tab
spaces-toolbar-button-address-book =
    .title = Switch to the address book tab
spaces-toolbar-button-calendar =
    .title = Switch to the calendar tab
spaces-toolbar-button-tasks =
    .title = Switch to the tasks tab
spaces-toolbar-button-chat =
    .title = Switch to the chat tab
spaces-toolbar-button-settings =
    .title = Switch to the settings tab
spaces-toolbar-button-collapse =
    .title = Collapse spaces toolbar
spaces-toolbar-button-reveal =
    .title = Show the spaces toolbar
spaces-context-new-tab-item =
    .label = Open in new tab
spaces-context-new-window-item =
    .label = Open in new window
# Variables:
# $tabName (String) - The name of the tab this item will switch to.
spaces-context-switch-tab-item =
    .label = Switch to { $tabName }
settings-context-open-settings-item =
    .label = Open Settings
settings-context-open-account-settings-item =
    .label = Open Account Settings
settings-context-open-addons-item =
    .label = Open Add-ons and Themes

## Spaces toolbar pinned tab menupopup

spaces-toolbar-pinned-tab-button =
    .tooltiptext = Open spaces menu
spaces-pinned-button-menuitem-mail =
    .label = { spaces-toolbar-button-mail.title }
spaces-pinned-button-menuitem-address-book =
    .label = { spaces-toolbar-button-address-book.title }
spaces-pinned-button-menuitem-calendar =
    .label = { spaces-toolbar-button-calendar.title }
spaces-pinned-button-menuitem-tasks =
    .label = { spaces-toolbar-button-tasks.title }
spaces-pinned-button-menuitem-chat =
    .label = { spaces-toolbar-button-chat.title }
spaces-pinned-button-menuitem-reveal =
    .label = { spaces-toolbar-button-reveal.title }
# Variables:
# $count (Number) - Number of unread messages.
chat-button-unread-messages = { $count }
    .title =
        { $count ->
            [one] One unread message
           *[other] { $count } unread messages
        }

## Spaces toolbar customize panel

spaces-context-customize =
    .label = Customise…
spaces-customize-panel-title = Spaces Toolbar Settings
spaces-customize-background-color = Background colour
spaces-customize-icon-color = Button colour
# The background color used on the buttons of the spaces toolbar when they are
# `current`, meaning the related space/tab is active and visible.
spaces-customize-accent-background-color = Selected button background colour
# The icon color used on the buttons of the spaces toolbar when they are
# `current`, meaning the related space/tab is active and visible.
spaces-customize-accent-text-color = Selected button colour
spaces-customize-button-restore = Restore Defaults
    .accesskey = R
spaces-customize-button-save = Done
    .accesskey = D
