
SET(ORDINALS
  ORDINAL_INT
  ORDINAL_INT64_T
)
SET(ORDINAL_INT_CPP_TYPE int)
SET(ORDINAL_INT64_T_CPP_TYPE int64_t)

SET(KOKKOSKERNELS_INST_ORDINAL_INT_DEFAULT ${KOKKOSKERNELS_ADD_DEFAULT_ETI})
SET(KOKKOSKERNELS_INST_ORDINAL_INT64_T_DEFAULT  OFF)


KOKKOSKERNELS_ADD_OPTION(
  INST_ORDINAL_INT
  ${KOKKOSKERNELS_INST_ORDINAL_INT_DEFAULT}
  BOOL
  "Whether to pre instantiate kernels for the ordinal type int.  This option is KokkosKernels_INST_ORDINAL_INT=ON by default. Default: ON"
  )

KOKKOSKERNELS_ADD_OPTION(
  INST_ORDINAL_INT64_T
  ${KOKKOSKERNELS_INST_ORDINAL_INT64_T_DEFAULT}
  BOOL
  "Whether to pre instantiate kernels for the ordinal type int64_t.  This option is KokkosKernels_INST_ORDINAL_INT64_T=OFF by default. Default: OFF"
  )

IF (KOKKOSKERNELS_INST_ORDINAL_INT)
  LIST(APPEND ORDINAL_LIST "int")
ENDIF()

IF (KOKKOSKERNELS_INST_ORDINAL_INT64_T)
  LIST(APPEND ORDINAL_LIST "int64_t")
ENDIF()
