/*
 * Decompiled with CFR 0.152.
 */
package rene.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.PrintWriter;
import rene.gui.Global;
import rene.gui.Panel3D;
import rene.viewer.TextDisplay;
import rene.viewer.TextPosition;
import rene.viewer.Wheel;
import rene.viewer.WheelListener;

public class Viewer
extends Panel
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
ActionListener,
KeyListener,
WheelListener {
    TextDisplay TD;
    Scrollbar Vertical;
    Scrollbar Horizontal;
    TextPosition Start;
    TextPosition End;
    PopupMenu PM;
    int X;
    int Y;
    Panel P3D;
    boolean Dragging = false;

    public Viewer(boolean bl, boolean bl2) {
        this.TD = new TextDisplay(this);
        this.setLayout(new BorderLayout());
        this.P3D = new Panel3D(this.TD);
        this.add("Center", this.P3D);
        if (bl) {
            this.Vertical = new Scrollbar(1, 0, 100, 0, 1100);
            this.add("East", this.Vertical);
            this.Vertical.addAdjustmentListener(this);
        }
        if (bl2) {
            this.Horizontal = new Scrollbar(0, 0, 100, 0, 1100);
            this.add("South", this.Horizontal);
            this.Horizontal.addAdjustmentListener(this);
        }
        this.TD.addMouseListener(this);
        this.TD.addMouseMotionListener(this);
        this.End = null;
        this.Start = null;
        this.PM = new PopupMenu();
        MenuItem menuItem = new MenuItem(Global.name("block.copy", "Copy"));
        menuItem.addActionListener(this);
        this.PM.add(menuItem);
        this.PM.addSeparator();
        menuItem = new MenuItem(Global.name("block.begin", "Begin Block"));
        menuItem.addActionListener(this);
        this.PM.add(menuItem);
        menuItem = new MenuItem(Global.name("block.end", "End Block"));
        menuItem.addActionListener(this);
        this.PM.add(menuItem);
        this.add(this.PM);
        Wheel wheel = new Wheel(this);
        this.addMouseWheelListener(wheel);
    }

    public Viewer() {
        this(true, true);
    }

    public Viewer(String string) {
    }

    public void setFont(Font font) {
        this.TD.init(font);
    }

    public void appendLine(String string) {
        this.TD.appendLine0(string);
    }

    public void appendLine(String string, Color color) {
        this.TD.appendLine0(string, color);
    }

    public void append(String string) {
        this.append(string, Color.black);
    }

    public void append(String string, Color color) {
        this.TD.append(string, color);
    }

    public void doUpdate(boolean bl) {
        this.TD.doUpdate(bl);
        this.setVerticalScrollbar();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.Vertical) {
            switch (adjustmentEvent.getAdjustmentType()) {
                case 1: {
                    this.TD.verticalUp();
                    break;
                }
                case 2: {
                    this.TD.verticalDown();
                    break;
                }
                case 4: {
                    this.TD.verticalPageUp();
                    break;
                }
                case 3: {
                    this.TD.verticalPageDown();
                    break;
                }
                default: {
                    int n = this.Vertical.getValue();
                    this.Vertical.setValue(n);
                    this.TD.setVertical(n);
                    return;
                }
            }
            this.setVerticalScrollbar();
        } else if (adjustmentEvent.getSource() == this.Horizontal) {
            this.Horizontal.setValue(this.TD.setHorizontal(this.Horizontal.getValue()));
        }
    }

    public void setVerticalScrollbar() {
        if (this.Vertical == null) {
            return;
        }
        int n = this.TD.computeVerticalSize();
        this.Vertical.setValues(this.TD.computeVertical(), n, 0, 1000 + n);
    }

    public void setText(String string) {
        this.TD.unmark();
        this.End = null;
        this.Start = null;
        this.TD.setText(string);
        this.setVerticalScrollbar();
    }

    public void save(PrintWriter printWriter) {
        this.TD.save(printWriter);
    }

    public void appendLine0(String string) {
        this.TD.appendLine0(string);
    }

    public void appendLine0(String string, Color color) {
        this.TD.appendLine0(string, color);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            this.PM.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            this.X = mouseEvent.getX();
            this.Y = mouseEvent.getY();
        } else {
            this.TD.unmark(this.Start, this.End);
            this.Start = this.TD.getposition(mouseEvent.getX(), mouseEvent.getY());
            this.Start.oneleft();
            this.End = null;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 200);
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 200);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.Dragging = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.TD.unmark(this.Start, this.End);
        TextPosition textPosition = this.TD.getposition(mouseEvent.getX(), mouseEvent.getY());
        if (textPosition != null) {
            this.End = textPosition;
        }
        this.TD.mark(this.Start, this.End);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(Global.name("block.copy", "Copy"))) {
            this.TD.copy(this.Start, this.End);
        } else if (string.equals(Global.name("block.begin", "Begin Block"))) {
            this.TD.unmark(this.Start, this.End);
            this.Start = this.TD.getposition(this.X, this.Y);
            this.Start.oneleft();
            if (this.End == null && this.TD.L.last() != null) {
                this.End = this.TD.lastpos();
            }
            this.TD.mark(this.Start, this.End);
        } else if (string.equals(Global.name("block.end", "End Block"))) {
            this.TD.unmark(this.Start, this.End);
            this.End = this.TD.getposition(this.X, this.Y);
            if (this.Start == null && this.TD.L.first() != null) {
                this.Start = new TextPosition(this.TD.L.first(), 0, 0);
            }
            this.TD.mark(this.Start, this.End);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 67 && this.Start != null && this.End != null) {
            this.TD.copy(this.Start, this.End);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setTabWidth(int n) {
        this.TD.setTabWidth(n);
    }

    public void showFirst() {
        this.TD.showFirst();
        this.setVerticalScrollbar();
        this.TD.repaint();
    }

    public void showLast() {
        this.TD.showlast();
        this.setVerticalScrollbar();
        this.TD.repaint();
    }

    public boolean hasFocus() {
        return false;
    }

    public void setBackground(Color color) {
        this.TD.setBackground(color);
        this.P3D.setBackground(color);
        super.setBackground(color);
    }

    public void up(int n) {
        for (int i = 0; i < n; ++i) {
            this.TD.verticalUp();
        }
        this.setVerticalScrollbar();
    }

    public void down(int n) {
        for (int i = 0; i < n; ++i) {
            this.TD.verticalDown();
        }
        this.setVerticalScrollbar();
    }

    public void pageUp() {
        this.TD.verticalPageUp();
        this.setVerticalScrollbar();
    }

    public void pageDown() {
        this.TD.verticalPageDown();
        this.setVerticalScrollbar();
    }

    public void resized() {
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.setLayout(new BorderLayout());
        Viewer viewer = new Viewer(true, false);
        frame.add("Center", viewer);
        frame.setSize(300, 300);
        frame.setVisible(true);
        viewer.append("test test test test test test test");
        viewer.appendLine("test test test test test test test");
        viewer.appendLine("test test test test test test test");
        viewer.appendLine("test test test test test test test");
    }
}

