/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.utils;

import fr.ove.utils.ConnectionConfigurable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class Connection
implements ConnectionConfigurable {
    private Socket socket;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private String hostName;
    private int portNumber;

    public Connection() {
        this("localhost", 6666);
    }

    public Connection(String string, int n) {
        this.hostName = string;
        this.portNumber = n;
    }

    @Override
    public void setHostName(String string) {
        this.hostName = string;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setPortNumber(int n) {
        this.portNumber = n;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    public void open() throws IOException {
        this.socket = new Socket(InetAddress.getByName(this.hostName), this.portNumber);
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
    }

    public void open(Socket socket) throws IOException {
        this.socket = socket;
        this.hostName = socket.getInetAddress().getHostName();
        this.portNumber = socket.getPort();
        this.inputStream = socket.getInputStream();
        this.outputStream = socket.getOutputStream();
    }

    public boolean isOpened() {
        return this.outputStream != null && this.inputStream != null;
    }

    public void close() throws IOException {
        this.outputStream.close();
        this.inputStream.close();
        this.outputStream = null;
        this.inputStream = null;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }
}

