# Cucumber-ruby 4.0.0 release notes

This is the first stable Cucumber release of the 4.x series. It's the first stable release for 2 years.
Upgrading from 3.x should not require any changes, but there are some deprecations (see below). We also have some exciting new features!

## Added

### new Gherkin syntax: Rules and Examples

One of the most visible change in the new release is the support of the Gherkin 6+ syntax. This is still backward compatible with your existing features of course, but here are the changes introduced:
 - the `Rule` keyword acts as a grouping of scenarios inside a feature
 - the `Scenario Outline` keyword is not needed anymore when using `Examples` with a `Scenario``
 - the `Scenario` keyword now has synonym: `Example`

If you are familiar with [example mapping](https://cucumber.io/docs/bdd/example-mapping/), you will see how easy it is to translate your cards from an example mapping session into a `feature` file.

### support of the cucumber-messages protocol

[`cucumber-messages`](https://github.com/cucumber/cucumber/tree/master/messages#cucumber-messages) is the new format that is used by Cucumber to represent the various information emitted during an execution.

This library satisfies multiple interests:
 - same output for all `cucumber` and related implementation (cucumber-ruby, cucumber-jvm, cucumber-jss, SpecFlow ...)
 - it relies on [`protobuf`](https://developers.google.com/protocol-buffers/), so it is fairly easy to generate a consumer in any language supported by `protobuf`.
  - we have published libraries to consume this format for [ruby](https://rubygems.org/gems/cucumber-messages), [Java](https://mvnrepository.com/artifact/io.cucumber/messages), [JavaScript](https://www.npmjs.com/package/@cucumber/messages) and [C#](https://www.nuget.org/packages/Cucumber.Messages/)
 - it is easier to generate tools consuming this output

To generate the new messages, you can use the `message` reporter.

Example: `bundle exec cucumber --format message`

### sending results to a server

You now have the option to send the results of the execution directly to a web server. You can achieve this by specifying an `http` or `http` URL to the `--out` parameter.

Example: `bundle exec cucumber --format messages --out "http://example.com/report-service"`

### HTML reporter

We've added a brand new HTML reporter in this release. Everything is embedded in a single file (no CSS or JS file), so you can easily share the generated page.

Example: `bundle exec cucumber --format html --out report.html`

## Deprecated

### JSON formatter

With the introduction of the `message` formatter, we have decided to deprecate the JSON formatter. It will be removed in the 6.0.0 release.
After the removal, you will still have the possibility to export to JSON using the [`json-formatter`](https://github.com/cucumber/cucumber/tree/master/json-formatter#cucumber-json-formatter) which takes cucumber-messages as input.


### `puts`

When using `puts` in your step definitions, the data you output is caught by `cucumber` and then processed by the formatter (for example, when using the `json` formatter, the data provided to `puts` will appear in the `output` field of the step).
This solution is now deprecated in favor of the `log` method. In `cucumber-ruby 5`, calls to `puts` will not be caught by the formatter and the default Ruby behavior will be triggered.

### `embed`
The `embed` method to add attachments is also deprecated in favor of the `attach` method. This is part of task to make the different implementations of cucumber [more uniform](https://github.com/cucumber/cucumber/issues/897).
