//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilityelementprotocol?language=objc)
    #[doc(alias = "NSAccessibilityElement")]
    #[name = "NSAccessibilityElement"]
    pub unsafe trait NSAccessibilityElementProtocol: NSObjectProtocol {
        #[unsafe(method(accessibilityFrame))]
        #[unsafe(method_family = none)]
        fn accessibilityFrame(&self) -> NSRect;

        #[unsafe(method(accessibilityParent))]
        #[unsafe(method_family = none)]
        fn accessibilityParent(&self) -> Option<Retained<AnyObject>>;

        #[optional]
        #[unsafe(method(isAccessibilityFocused))]
        #[unsafe(method_family = none)]
        fn isAccessibilityFocused(&self) -> bool;

        #[optional]
        #[unsafe(method(accessibilityIdentifier))]
        #[unsafe(method_family = none)]
        fn accessibilityIdentifier(&self) -> Retained<NSString>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitygroup?language=objc)
    pub unsafe trait NSAccessibilityGroup: NSAccessibilityElementProtocol {}
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitybutton?language=objc)
    pub unsafe trait NSAccessibilityButton: NSAccessibilityElementProtocol {
        #[unsafe(method(accessibilityLabel))]
        #[unsafe(method_family = none)]
        fn accessibilityLabel(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(accessibilityPerformPress))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformPress(&self) -> bool;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilityswitch?language=objc)
    pub unsafe trait NSAccessibilitySwitch: NSAccessibilityButton {
        #[unsafe(method(accessibilityValue))]
        #[unsafe(method_family = none)]
        fn accessibilityValue(&self) -> Option<Retained<NSString>>;

        #[optional]
        #[unsafe(method(accessibilityPerformIncrement))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformIncrement(&self) -> bool;

        #[optional]
        #[unsafe(method(accessibilityPerformDecrement))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformDecrement(&self) -> bool;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilityradiobutton?language=objc)
    pub unsafe trait NSAccessibilityRadioButton: NSAccessibilityButton {
        #[unsafe(method(accessibilityValue))]
        #[unsafe(method_family = none)]
        fn accessibilityValue(&self) -> Option<Retained<NSNumber>>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitycheckbox?language=objc)
    pub unsafe trait NSAccessibilityCheckBox: NSAccessibilityButton {
        #[unsafe(method(accessibilityValue))]
        #[unsafe(method_family = none)]
        fn accessibilityValue(&self) -> Option<Retained<NSNumber>>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitystatictext?language=objc)
    pub unsafe trait NSAccessibilityStaticText: NSAccessibilityElementProtocol {
        #[unsafe(method(accessibilityValue))]
        #[unsafe(method_family = none)]
        fn accessibilityValue(&self) -> Option<Retained<NSString>>;

        #[optional]
        #[unsafe(method(accessibilityAttributedStringForRange:))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedStringForRange(
            &self,
            range: NSRange,
        ) -> Option<Retained<NSAttributedString>>;

        #[optional]
        #[unsafe(method(accessibilityVisibleCharacterRange))]
        #[unsafe(method_family = none)]
        fn accessibilityVisibleCharacterRange(&self) -> NSRange;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitynavigablestatictext?language=objc)
    pub unsafe trait NSAccessibilityNavigableStaticText: NSAccessibilityStaticText {
        #[unsafe(method(accessibilityStringForRange:))]
        #[unsafe(method_family = none)]
        fn accessibilityStringForRange(&self, range: NSRange) -> Option<Retained<NSString>>;

        #[unsafe(method(accessibilityLineForIndex:))]
        #[unsafe(method_family = none)]
        fn accessibilityLineForIndex(&self, index: NSInteger) -> NSInteger;

        #[unsafe(method(accessibilityRangeForLine:))]
        #[unsafe(method_family = none)]
        fn accessibilityRangeForLine(&self, line_number: NSInteger) -> NSRange;

        #[unsafe(method(accessibilityFrameForRange:))]
        #[unsafe(method_family = none)]
        fn accessibilityFrameForRange(&self, range: NSRange) -> NSRect;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilityprogressindicator?language=objc)
    pub unsafe trait NSAccessibilityProgressIndicator: NSAccessibilityGroup {
        #[unsafe(method(accessibilityValue))]
        #[unsafe(method_family = none)]
        fn accessibilityValue(&self) -> Option<Retained<NSNumber>>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitystepper?language=objc)
    pub unsafe trait NSAccessibilityStepper: NSAccessibilityElementProtocol {
        #[unsafe(method(accessibilityLabel))]
        #[unsafe(method_family = none)]
        fn accessibilityLabel(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(accessibilityPerformIncrement))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformIncrement(&self) -> bool;

        #[unsafe(method(accessibilityPerformDecrement))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformDecrement(&self) -> bool;

        #[optional]
        #[unsafe(method(accessibilityValue))]
        #[unsafe(method_family = none)]
        fn accessibilityValue(&self) -> Option<Retained<AnyObject>>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilityslider?language=objc)
    pub unsafe trait NSAccessibilitySlider: NSAccessibilityElementProtocol {
        #[unsafe(method(accessibilityLabel))]
        #[unsafe(method_family = none)]
        fn accessibilityLabel(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(accessibilityValue))]
        #[unsafe(method_family = none)]
        fn accessibilityValue(&self) -> Option<Retained<AnyObject>>;

        #[unsafe(method(accessibilityPerformIncrement))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformIncrement(&self) -> bool;

        #[unsafe(method(accessibilityPerformDecrement))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformDecrement(&self) -> bool;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilityimage?language=objc)
    pub unsafe trait NSAccessibilityImage: NSAccessibilityElementProtocol {
        #[unsafe(method(accessibilityLabel))]
        #[unsafe(method_family = none)]
        fn accessibilityLabel(&self) -> Option<Retained<NSString>>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitycontainstransientui?language=objc)
    pub unsafe trait NSAccessibilityContainsTransientUI:
        NSAccessibilityElementProtocol
    {
        #[unsafe(method(accessibilityPerformShowAlternateUI))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformShowAlternateUI(&self) -> bool;

        #[unsafe(method(accessibilityPerformShowDefaultUI))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformShowDefaultUI(&self) -> bool;

        #[unsafe(method(isAccessibilityAlternateUIVisible))]
        #[unsafe(method_family = none)]
        fn isAccessibilityAlternateUIVisible(&self) -> bool;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitytable?language=objc)
    pub unsafe trait NSAccessibilityTable: NSAccessibilityGroup {
        #[unsafe(method(accessibilityLabel))]
        #[unsafe(method_family = none)]
        fn accessibilityLabel(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(accessibilityRows))]
        #[unsafe(method_family = none)]
        fn accessibilityRows(
            &self,
        ) -> Option<Retained<NSArray<ProtocolObject<dyn NSAccessibilityRow>>>>;

        #[optional]
        #[unsafe(method(accessibilitySelectedRows))]
        #[unsafe(method_family = none)]
        fn accessibilitySelectedRows(
            &self,
        ) -> Option<Retained<NSArray<ProtocolObject<dyn NSAccessibilityRow>>>>;

        #[optional]
        #[unsafe(method(setAccessibilitySelectedRows:))]
        #[unsafe(method_family = none)]
        fn setAccessibilitySelectedRows(
            &self,
            selected_rows: &NSArray<ProtocolObject<dyn NSAccessibilityRow>>,
        );

        #[optional]
        #[unsafe(method(accessibilityVisibleRows))]
        #[unsafe(method_family = none)]
        fn accessibilityVisibleRows(
            &self,
        ) -> Option<Retained<NSArray<ProtocolObject<dyn NSAccessibilityRow>>>>;

        #[optional]
        #[unsafe(method(accessibilityColumns))]
        #[unsafe(method_family = none)]
        fn accessibilityColumns(&self) -> Option<Retained<NSArray>>;

        #[optional]
        #[unsafe(method(accessibilityVisibleColumns))]
        #[unsafe(method_family = none)]
        fn accessibilityVisibleColumns(&self) -> Option<Retained<NSArray>>;

        #[optional]
        #[unsafe(method(accessibilitySelectedColumns))]
        #[unsafe(method_family = none)]
        fn accessibilitySelectedColumns(&self) -> Option<Retained<NSArray>>;

        #[deprecated]
        #[optional]
        #[unsafe(method(accessibilityHeaderGroup))]
        #[unsafe(method_family = none)]
        fn accessibilityHeaderGroup(&self) -> Option<Retained<NSString>>;

        #[optional]
        #[unsafe(method(accessibilitySelectedCells))]
        #[unsafe(method_family = none)]
        fn accessibilitySelectedCells(&self) -> Option<Retained<NSArray>>;

        #[optional]
        #[unsafe(method(accessibilityVisibleCells))]
        #[unsafe(method_family = none)]
        fn accessibilityVisibleCells(&self) -> Option<Retained<NSArray>>;

        #[optional]
        #[unsafe(method(accessibilityRowHeaderUIElements))]
        #[unsafe(method_family = none)]
        fn accessibilityRowHeaderUIElements(&self) -> Option<Retained<NSArray>>;

        #[optional]
        #[unsafe(method(accessibilityColumnHeaderUIElements))]
        #[unsafe(method_family = none)]
        fn accessibilityColumnHeaderUIElements(&self) -> Option<Retained<NSArray>>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilityoutline?language=objc)
    pub unsafe trait NSAccessibilityOutline: NSAccessibilityTable {}
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitylist?language=objc)
    pub unsafe trait NSAccessibilityList: NSAccessibilityTable {}
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilityrow?language=objc)
    pub unsafe trait NSAccessibilityRow: NSAccessibilityGroup {
        #[unsafe(method(accessibilityIndex))]
        #[unsafe(method_family = none)]
        fn accessibilityIndex(&self) -> NSInteger;

        #[optional]
        #[unsafe(method(accessibilityDisclosureLevel))]
        #[unsafe(method_family = none)]
        fn accessibilityDisclosureLevel(&self) -> NSInteger;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitylayoutarea?language=objc)
    pub unsafe trait NSAccessibilityLayoutArea: NSAccessibilityGroup {
        #[unsafe(method(accessibilityLabel))]
        #[unsafe(method_family = none)]
        fn accessibilityLabel(&self) -> Retained<NSString>;

        #[unsafe(method(accessibilityChildren))]
        #[unsafe(method_family = none)]
        fn accessibilityChildren(&self) -> Option<Retained<NSArray>>;

        #[unsafe(method(accessibilitySelectedChildren))]
        #[unsafe(method_family = none)]
        fn accessibilitySelectedChildren(&self) -> Option<Retained<NSArray>>;

        #[unsafe(method(accessibilityFocusedUIElement))]
        #[unsafe(method_family = none)]
        fn accessibilityFocusedUIElement(&self) -> Retained<AnyObject>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilitylayoutitem?language=objc)
    pub unsafe trait NSAccessibilityLayoutItem: NSAccessibilityGroup {
        #[optional]
        #[unsafe(method(setAccessibilityFrame:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityFrame(&self, frame: NSRect);
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibilityelementloading?language=objc)
    pub unsafe trait NSAccessibilityElementLoading: NSObjectProtocol {
        #[cfg(feature = "NSAccessibilityConstants")]
        /// Loads the target element with the given load token.
        ///
        /// Returns: An element that will be messaged for other accessibility
        /// properties. Assistive technologies may try to set accessibility
        /// focus on the returned element.
        ///
        /// # Safety
        ///
        /// `token` should be of the correct type.
        #[unsafe(method(accessibilityElementWithToken:))]
        #[unsafe(method_family = none)]
        unsafe fn accessibilityElementWithToken(
            &self,
            token: &NSAccessibilityLoadingToken,
        ) -> Option<Retained<ProtocolObject<dyn NSAccessibilityElementProtocol>>>;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// For text-based elements returned from accessibilityElementWithToken,
        /// such as an NSTextView, the range specifies an area of interest. Assistive
        /// technologies will try to bring focus to the specified text range.
        ///
        /// Either do not implement this method or return NSNotFound for the
        /// location if there is no range of interest for a given load token.
        ///
        /// # Safety
        ///
        /// `token` should be of the correct type.
        #[optional]
        #[unsafe(method(accessibilityRangeInTargetElementWithToken:))]
        #[unsafe(method_family = none)]
        unsafe fn accessibilityRangeInTargetElementWithToken(
            &self,
            token: &NSAccessibilityLoadingToken,
        ) -> NSRange;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsaccessibility?language=objc)
    pub unsafe trait NSAccessibility: NSObjectProtocol {
        #[unsafe(method(isAccessibilityElement))]
        #[unsafe(method_family = none)]
        fn isAccessibilityElement(&self) -> bool;

        /// Setter for [`isAccessibilityElement`][Self::isAccessibilityElement].
        #[unsafe(method(setAccessibilityElement:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityElement(&self, accessibility_element: bool);

        #[unsafe(method(accessibilityFrame))]
        #[unsafe(method_family = none)]
        fn accessibilityFrame(&self) -> NSRect;

        /// Setter for [`accessibilityFrame`][Self::accessibilityFrame].
        #[unsafe(method(setAccessibilityFrame:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityFrame(&self, accessibility_frame: NSRect);

        #[unsafe(method(isAccessibilityFocused))]
        #[unsafe(method_family = none)]
        fn isAccessibilityFocused(&self) -> bool;

        /// Setter for [`isAccessibilityFocused`][Self::isAccessibilityFocused].
        #[unsafe(method(setAccessibilityFocused:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityFocused(&self, accessibility_focused: bool);

        #[unsafe(method(accessibilityActivationPoint))]
        #[unsafe(method_family = none)]
        fn accessibilityActivationPoint(&self) -> NSPoint;

        /// Setter for [`accessibilityActivationPoint`][Self::accessibilityActivationPoint].
        #[unsafe(method(setAccessibilityActivationPoint:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityActivationPoint(&self, accessibility_activation_point: NSPoint);

        #[unsafe(method(accessibilityTopLevelUIElement))]
        #[unsafe(method_family = none)]
        fn accessibilityTopLevelUIElement(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityTopLevelUIElement`][Self::accessibilityTopLevelUIElement].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// `accessibility_top_level_ui_element` should be of the correct type.
        #[unsafe(method(setAccessibilityTopLevelUIElement:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityTopLevelUIElement(
            &self,
            accessibility_top_level_ui_element: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityURL))]
        #[unsafe(method_family = none)]
        fn accessibilityURL(&self) -> Option<Retained<NSURL>>;

        /// Setter for [`accessibilityURL`][Self::accessibilityURL].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityURL:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityURL(&self, accessibility_url: Option<&NSURL>);

        #[unsafe(method(accessibilityValue))]
        #[unsafe(method_family = none)]
        fn accessibilityValue(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityValue`][Self::accessibilityValue].
        ///
        /// # Safety
        ///
        /// `accessibility_value` should be of the correct type.
        #[unsafe(method(setAccessibilityValue:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityValue(&self, accessibility_value: Option<&AnyObject>);

        #[unsafe(method(accessibilityValueDescription))]
        #[unsafe(method_family = none)]
        fn accessibilityValueDescription(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityValueDescription`][Self::accessibilityValueDescription].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityValueDescription:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityValueDescription(
            &self,
            accessibility_value_description: Option<&NSString>,
        );

        #[unsafe(method(accessibilityVisibleChildren))]
        #[unsafe(method_family = none)]
        fn accessibilityVisibleChildren(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityVisibleChildren`][Self::accessibilityVisibleChildren].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_visible_children` generic should be of the correct type.
        #[unsafe(method(setAccessibilityVisibleChildren:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityVisibleChildren(
            &self,
            accessibility_visible_children: Option<&NSArray>,
        );

        #[cfg(feature = "NSAccessibilityConstants")]
        #[unsafe(method(accessibilitySubrole))]
        #[unsafe(method_family = none)]
        fn accessibilitySubrole(&self) -> Option<Retained<NSAccessibilitySubrole>>;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// Setter for [`accessibilitySubrole`][Self::accessibilitySubrole].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilitySubrole:))]
        #[unsafe(method_family = none)]
        fn setAccessibilitySubrole(&self, accessibility_subrole: Option<&NSAccessibilitySubrole>);

        #[unsafe(method(accessibilityTitle))]
        #[unsafe(method_family = none)]
        fn accessibilityTitle(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityTitle`][Self::accessibilityTitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityTitle:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityTitle(&self, accessibility_title: Option<&NSString>);

        #[unsafe(method(accessibilityTitleUIElement))]
        #[unsafe(method_family = none)]
        fn accessibilityTitleUIElement(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityTitleUIElement`][Self::accessibilityTitleUIElement].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// `accessibility_title_ui_element` should be of the correct type.
        #[unsafe(method(setAccessibilityTitleUIElement:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityTitleUIElement(
            &self,
            accessibility_title_ui_element: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityNextContents))]
        #[unsafe(method_family = none)]
        fn accessibilityNextContents(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityNextContents`][Self::accessibilityNextContents].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_next_contents` generic should be of the correct type.
        #[unsafe(method(setAccessibilityNextContents:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityNextContents(
            &self,
            accessibility_next_contents: Option<&NSArray>,
        );

        #[cfg(feature = "NSAccessibilityConstants")]
        #[unsafe(method(accessibilityOrientation))]
        #[unsafe(method_family = none)]
        fn accessibilityOrientation(&self) -> NSAccessibilityOrientation;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// Setter for [`accessibilityOrientation`][Self::accessibilityOrientation].
        #[unsafe(method(setAccessibilityOrientation:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityOrientation(
            &self,
            accessibility_orientation: NSAccessibilityOrientation,
        );

        #[unsafe(method(accessibilityOverflowButton))]
        #[unsafe(method_family = none)]
        fn accessibilityOverflowButton(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityOverflowButton`][Self::accessibilityOverflowButton].
        ///
        /// # Safety
        ///
        /// `accessibility_overflow_button` should be of the correct type.
        #[unsafe(method(setAccessibilityOverflowButton:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityOverflowButton(
            &self,
            accessibility_overflow_button: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityParent))]
        #[unsafe(method_family = none)]
        fn accessibilityParent(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityParent`][Self::accessibilityParent].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// `accessibility_parent` should be of the correct type.
        #[unsafe(method(setAccessibilityParent:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityParent(&self, accessibility_parent: Option<&AnyObject>);

        #[unsafe(method(accessibilityPlaceholderValue))]
        #[unsafe(method_family = none)]
        fn accessibilityPlaceholderValue(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityPlaceholderValue`][Self::accessibilityPlaceholderValue].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityPlaceholderValue:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityPlaceholderValue(
            &self,
            accessibility_placeholder_value: Option<&NSString>,
        );

        #[unsafe(method(accessibilityPreviousContents))]
        #[unsafe(method_family = none)]
        fn accessibilityPreviousContents(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityPreviousContents`][Self::accessibilityPreviousContents].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_previous_contents` generic should be of the correct type.
        #[unsafe(method(setAccessibilityPreviousContents:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityPreviousContents(
            &self,
            accessibility_previous_contents: Option<&NSArray>,
        );

        #[cfg(feature = "NSAccessibilityConstants")]
        #[unsafe(method(accessibilityRole))]
        #[unsafe(method_family = none)]
        fn accessibilityRole(&self) -> Option<Retained<NSAccessibilityRole>>;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// Setter for [`accessibilityRole`][Self::accessibilityRole].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityRole:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityRole(&self, accessibility_role: Option<&NSAccessibilityRole>);

        #[unsafe(method(accessibilityRoleDescription))]
        #[unsafe(method_family = none)]
        fn accessibilityRoleDescription(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityRoleDescription`][Self::accessibilityRoleDescription].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityRoleDescription:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityRoleDescription(
            &self,
            accessibility_role_description: Option<&NSString>,
        );

        #[unsafe(method(accessibilitySearchButton))]
        #[unsafe(method_family = none)]
        fn accessibilitySearchButton(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilitySearchButton`][Self::accessibilitySearchButton].
        ///
        /// # Safety
        ///
        /// `accessibility_search_button` should be of the correct type.
        #[unsafe(method(setAccessibilitySearchButton:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilitySearchButton(
            &self,
            accessibility_search_button: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilitySearchMenu))]
        #[unsafe(method_family = none)]
        fn accessibilitySearchMenu(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilitySearchMenu`][Self::accessibilitySearchMenu].
        ///
        /// # Safety
        ///
        /// `accessibility_search_menu` should be of the correct type.
        #[unsafe(method(setAccessibilitySearchMenu:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilitySearchMenu(&self, accessibility_search_menu: Option<&AnyObject>);

        #[unsafe(method(isAccessibilitySelected))]
        #[unsafe(method_family = none)]
        fn isAccessibilitySelected(&self) -> bool;

        /// Setter for [`isAccessibilitySelected`][Self::isAccessibilitySelected].
        #[unsafe(method(setAccessibilitySelected:))]
        #[unsafe(method_family = none)]
        fn setAccessibilitySelected(&self, accessibility_selected: bool);

        #[unsafe(method(accessibilitySelectedChildren))]
        #[unsafe(method_family = none)]
        fn accessibilitySelectedChildren(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilitySelectedChildren`][Self::accessibilitySelectedChildren].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_selected_children` generic should be of the correct type.
        #[unsafe(method(setAccessibilitySelectedChildren:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilitySelectedChildren(
            &self,
            accessibility_selected_children: Option<&NSArray>,
        );

        #[unsafe(method(accessibilityServesAsTitleForUIElements))]
        #[unsafe(method_family = none)]
        fn accessibilityServesAsTitleForUIElements(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityServesAsTitleForUIElements`][Self::accessibilityServesAsTitleForUIElements].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_serves_as_title_for_ui_elements` generic should be of the correct type.
        #[unsafe(method(setAccessibilityServesAsTitleForUIElements:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityServesAsTitleForUIElements(
            &self,
            accessibility_serves_as_title_for_ui_elements: Option<&NSArray>,
        );

        #[unsafe(method(accessibilityShownMenu))]
        #[unsafe(method_family = none)]
        fn accessibilityShownMenu(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityShownMenu`][Self::accessibilityShownMenu].
        ///
        /// # Safety
        ///
        /// `accessibility_shown_menu` should be of the correct type.
        #[unsafe(method(setAccessibilityShownMenu:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityShownMenu(&self, accessibility_shown_menu: Option<&AnyObject>);

        #[unsafe(method(accessibilityMinValue))]
        #[unsafe(method_family = none)]
        fn accessibilityMinValue(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityMinValue`][Self::accessibilityMinValue].
        ///
        /// # Safety
        ///
        /// `accessibility_min_value` should be of the correct type.
        #[unsafe(method(setAccessibilityMinValue:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityMinValue(&self, accessibility_min_value: Option<&AnyObject>);

        #[unsafe(method(accessibilityMaxValue))]
        #[unsafe(method_family = none)]
        fn accessibilityMaxValue(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityMaxValue`][Self::accessibilityMaxValue].
        ///
        /// # Safety
        ///
        /// `accessibility_max_value` should be of the correct type.
        #[unsafe(method(setAccessibilityMaxValue:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityMaxValue(&self, accessibility_max_value: Option<&AnyObject>);

        #[unsafe(method(accessibilityLinkedUIElements))]
        #[unsafe(method_family = none)]
        fn accessibilityLinkedUIElements(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityLinkedUIElements`][Self::accessibilityLinkedUIElements].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_linked_ui_elements` generic should be of the correct type.
        #[unsafe(method(setAccessibilityLinkedUIElements:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityLinkedUIElements(
            &self,
            accessibility_linked_ui_elements: Option<&NSArray>,
        );

        #[unsafe(method(accessibilityWindow))]
        #[unsafe(method_family = none)]
        fn accessibilityWindow(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityWindow`][Self::accessibilityWindow].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// `accessibility_window` should be of the correct type.
        #[unsafe(method(setAccessibilityWindow:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityWindow(&self, accessibility_window: Option<&AnyObject>);

        #[unsafe(method(accessibilityIdentifier))]
        #[unsafe(method_family = none)]
        fn accessibilityIdentifier(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityIdentifier`][Self::accessibilityIdentifier].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityIdentifier:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityIdentifier(&self, accessibility_identifier: Option<&NSString>);

        #[unsafe(method(accessibilityHelp))]
        #[unsafe(method_family = none)]
        fn accessibilityHelp(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityHelp`][Self::accessibilityHelp].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityHelp:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityHelp(&self, accessibility_help: Option<&NSString>);

        #[unsafe(method(accessibilityFilename))]
        #[unsafe(method_family = none)]
        fn accessibilityFilename(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityFilename`][Self::accessibilityFilename].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityFilename:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityFilename(&self, accessibility_filename: Option<&NSString>);

        #[unsafe(method(isAccessibilityExpanded))]
        #[unsafe(method_family = none)]
        fn isAccessibilityExpanded(&self) -> bool;

        /// Setter for [`isAccessibilityExpanded`][Self::isAccessibilityExpanded].
        #[unsafe(method(setAccessibilityExpanded:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityExpanded(&self, accessibility_expanded: bool);

        #[unsafe(method(isAccessibilityEdited))]
        #[unsafe(method_family = none)]
        fn isAccessibilityEdited(&self) -> bool;

        /// Setter for [`isAccessibilityEdited`][Self::isAccessibilityEdited].
        #[unsafe(method(setAccessibilityEdited:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityEdited(&self, accessibility_edited: bool);

        #[unsafe(method(isAccessibilityEnabled))]
        #[unsafe(method_family = none)]
        fn isAccessibilityEnabled(&self) -> bool;

        /// Setter for [`isAccessibilityEnabled`][Self::isAccessibilityEnabled].
        #[unsafe(method(setAccessibilityEnabled:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityEnabled(&self, accessibility_enabled: bool);

        #[unsafe(method(accessibilityChildren))]
        #[unsafe(method_family = none)]
        fn accessibilityChildren(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityChildren`][Self::accessibilityChildren].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_children` generic should be of the correct type.
        #[unsafe(method(setAccessibilityChildren:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityChildren(&self, accessibility_children: Option<&NSArray>);

        #[unsafe(method(accessibilityChildrenInNavigationOrder))]
        #[unsafe(method_family = none)]
        fn accessibilityChildrenInNavigationOrder(
            &self,
        ) -> Option<Retained<NSArray<ProtocolObject<dyn NSAccessibilityElementProtocol>>>>;

        /// Setter for [`accessibilityChildrenInNavigationOrder`][Self::accessibilityChildrenInNavigationOrder].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityChildrenInNavigationOrder:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityChildrenInNavigationOrder(
            &self,
            accessibility_children_in_navigation_order: Option<
                &NSArray<ProtocolObject<dyn NSAccessibilityElementProtocol>>,
            >,
        );

        #[unsafe(method(accessibilityClearButton))]
        #[unsafe(method_family = none)]
        fn accessibilityClearButton(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityClearButton`][Self::accessibilityClearButton].
        ///
        /// # Safety
        ///
        /// `accessibility_clear_button` should be of the correct type.
        #[unsafe(method(setAccessibilityClearButton:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityClearButton(
            &self,
            accessibility_clear_button: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityCancelButton))]
        #[unsafe(method_family = none)]
        fn accessibilityCancelButton(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityCancelButton`][Self::accessibilityCancelButton].
        ///
        /// # Safety
        ///
        /// `accessibility_cancel_button` should be of the correct type.
        #[unsafe(method(setAccessibilityCancelButton:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityCancelButton(
            &self,
            accessibility_cancel_button: Option<&AnyObject>,
        );

        #[unsafe(method(isAccessibilityProtectedContent))]
        #[unsafe(method_family = none)]
        fn isAccessibilityProtectedContent(&self) -> bool;

        /// Setter for [`isAccessibilityProtectedContent`][Self::isAccessibilityProtectedContent].
        #[unsafe(method(setAccessibilityProtectedContent:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityProtectedContent(&self, accessibility_protected_content: bool);

        #[unsafe(method(accessibilityContents))]
        #[unsafe(method_family = none)]
        fn accessibilityContents(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityContents`][Self::accessibilityContents].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_contents` generic should be of the correct type.
        #[unsafe(method(setAccessibilityContents:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityContents(&self, accessibility_contents: Option<&NSArray>);

        #[unsafe(method(accessibilityLabel))]
        #[unsafe(method_family = none)]
        fn accessibilityLabel(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityLabel`][Self::accessibilityLabel].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityLabel:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityLabel(&self, accessibility_label: Option<&NSString>);

        #[unsafe(method(isAccessibilityAlternateUIVisible))]
        #[unsafe(method_family = none)]
        fn isAccessibilityAlternateUIVisible(&self) -> bool;

        /// Setter for [`isAccessibilityAlternateUIVisible`][Self::isAccessibilityAlternateUIVisible].
        #[unsafe(method(setAccessibilityAlternateUIVisible:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityAlternateUIVisible(&self, accessibility_alternate_ui_visible: bool);

        #[unsafe(method(accessibilitySharedFocusElements))]
        #[unsafe(method_family = none)]
        fn accessibilitySharedFocusElements(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilitySharedFocusElements`][Self::accessibilitySharedFocusElements].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_shared_focus_elements` generic should be of the correct type.
        #[unsafe(method(setAccessibilitySharedFocusElements:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilitySharedFocusElements(
            &self,
            accessibility_shared_focus_elements: Option<&NSArray>,
        );

        #[unsafe(method(isAccessibilityRequired))]
        #[unsafe(method_family = none)]
        fn isAccessibilityRequired(&self) -> bool;

        /// Setter for [`isAccessibilityRequired`][Self::isAccessibilityRequired].
        #[unsafe(method(setAccessibilityRequired:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityRequired(&self, accessibility_required: bool);

        #[cfg(feature = "NSAccessibilityCustomRotor")]
        #[unsafe(method(accessibilityCustomRotors))]
        #[unsafe(method_family = none)]
        fn accessibilityCustomRotors(&self) -> Retained<NSArray<NSAccessibilityCustomRotor>>;

        #[cfg(feature = "NSAccessibilityCustomRotor")]
        /// Setter for [`accessibilityCustomRotors`][Self::accessibilityCustomRotors].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityCustomRotors:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityCustomRotors(
            &self,
            accessibility_custom_rotors: &NSArray<NSAccessibilityCustomRotor>,
        );

        #[unsafe(method(accessibilityUserInputLabels))]
        #[unsafe(method_family = none)]
        fn accessibilityUserInputLabels(&self) -> Option<Retained<NSArray<NSString>>>;

        /// Setter for [`accessibilityUserInputLabels`][Self::accessibilityUserInputLabels].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityUserInputLabels:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityUserInputLabels(
            &self,
            accessibility_user_input_labels: Option<&NSArray<NSString>>,
        );

        #[unsafe(method(accessibilityAttributedUserInputLabels))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedUserInputLabels(
            &self,
        ) -> Option<Retained<NSArray<NSAttributedString>>>;

        /// Setter for [`accessibilityAttributedUserInputLabels`][Self::accessibilityAttributedUserInputLabels].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityAttributedUserInputLabels:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityAttributedUserInputLabels(
            &self,
            accessibility_attributed_user_input_labels: Option<&NSArray<NSAttributedString>>,
        );

        #[unsafe(method(accessibilityApplicationFocusedUIElement))]
        #[unsafe(method_family = none)]
        fn accessibilityApplicationFocusedUIElement(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityApplicationFocusedUIElement`][Self::accessibilityApplicationFocusedUIElement].
        ///
        /// # Safety
        ///
        /// `accessibility_application_focused_ui_element` should be of the correct type.
        #[unsafe(method(setAccessibilityApplicationFocusedUIElement:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityApplicationFocusedUIElement(
            &self,
            accessibility_application_focused_ui_element: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityMainWindow))]
        #[unsafe(method_family = none)]
        fn accessibilityMainWindow(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityMainWindow`][Self::accessibilityMainWindow].
        ///
        /// # Safety
        ///
        /// `accessibility_main_window` should be of the correct type.
        #[unsafe(method(setAccessibilityMainWindow:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityMainWindow(&self, accessibility_main_window: Option<&AnyObject>);

        #[unsafe(method(isAccessibilityHidden))]
        #[unsafe(method_family = none)]
        fn isAccessibilityHidden(&self) -> bool;

        /// Setter for [`isAccessibilityHidden`][Self::isAccessibilityHidden].
        #[unsafe(method(setAccessibilityHidden:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityHidden(&self, accessibility_hidden: bool);

        #[unsafe(method(isAccessibilityFrontmost))]
        #[unsafe(method_family = none)]
        fn isAccessibilityFrontmost(&self) -> bool;

        /// Setter for [`isAccessibilityFrontmost`][Self::isAccessibilityFrontmost].
        #[unsafe(method(setAccessibilityFrontmost:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityFrontmost(&self, accessibility_frontmost: bool);

        #[unsafe(method(accessibilityFocusedWindow))]
        #[unsafe(method_family = none)]
        fn accessibilityFocusedWindow(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityFocusedWindow`][Self::accessibilityFocusedWindow].
        ///
        /// # Safety
        ///
        /// `accessibility_focused_window` should be of the correct type.
        #[unsafe(method(setAccessibilityFocusedWindow:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityFocusedWindow(
            &self,
            accessibility_focused_window: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityWindows))]
        #[unsafe(method_family = none)]
        fn accessibilityWindows(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityWindows`][Self::accessibilityWindows].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_windows` generic should be of the correct type.
        #[unsafe(method(setAccessibilityWindows:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityWindows(&self, accessibility_windows: Option<&NSArray>);

        #[unsafe(method(accessibilityExtrasMenuBar))]
        #[unsafe(method_family = none)]
        fn accessibilityExtrasMenuBar(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityExtrasMenuBar`][Self::accessibilityExtrasMenuBar].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// `accessibility_extras_menu_bar` should be of the correct type.
        #[unsafe(method(setAccessibilityExtrasMenuBar:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityExtrasMenuBar(
            &self,
            accessibility_extras_menu_bar: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityMenuBar))]
        #[unsafe(method_family = none)]
        fn accessibilityMenuBar(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityMenuBar`][Self::accessibilityMenuBar].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// `accessibility_menu_bar` should be of the correct type.
        #[unsafe(method(setAccessibilityMenuBar:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityMenuBar(&self, accessibility_menu_bar: Option<&AnyObject>);

        #[unsafe(method(accessibilityColumnTitles))]
        #[unsafe(method_family = none)]
        fn accessibilityColumnTitles(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityColumnTitles`][Self::accessibilityColumnTitles].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_column_titles` generic should be of the correct type.
        #[unsafe(method(setAccessibilityColumnTitles:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityColumnTitles(
            &self,
            accessibility_column_titles: Option<&NSArray>,
        );

        #[unsafe(method(isAccessibilityOrderedByRow))]
        #[unsafe(method_family = none)]
        fn isAccessibilityOrderedByRow(&self) -> bool;

        /// Setter for [`isAccessibilityOrderedByRow`][Self::isAccessibilityOrderedByRow].
        #[unsafe(method(setAccessibilityOrderedByRow:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityOrderedByRow(&self, accessibility_ordered_by_row: bool);

        #[cfg(feature = "NSAccessibilityConstants")]
        #[unsafe(method(accessibilityHorizontalUnits))]
        #[unsafe(method_family = none)]
        fn accessibilityHorizontalUnits(&self) -> NSAccessibilityUnits;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// Setter for [`accessibilityHorizontalUnits`][Self::accessibilityHorizontalUnits].
        #[unsafe(method(setAccessibilityHorizontalUnits:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityHorizontalUnits(
            &self,
            accessibility_horizontal_units: NSAccessibilityUnits,
        );

        #[cfg(feature = "NSAccessibilityConstants")]
        #[unsafe(method(accessibilityVerticalUnits))]
        #[unsafe(method_family = none)]
        fn accessibilityVerticalUnits(&self) -> NSAccessibilityUnits;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// Setter for [`accessibilityVerticalUnits`][Self::accessibilityVerticalUnits].
        #[unsafe(method(setAccessibilityVerticalUnits:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityVerticalUnits(&self, accessibility_vertical_units: NSAccessibilityUnits);

        #[unsafe(method(accessibilityHorizontalUnitDescription))]
        #[unsafe(method_family = none)]
        fn accessibilityHorizontalUnitDescription(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityHorizontalUnitDescription`][Self::accessibilityHorizontalUnitDescription].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityHorizontalUnitDescription:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityHorizontalUnitDescription(
            &self,
            accessibility_horizontal_unit_description: Option<&NSString>,
        );

        #[unsafe(method(accessibilityVerticalUnitDescription))]
        #[unsafe(method_family = none)]
        fn accessibilityVerticalUnitDescription(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityVerticalUnitDescription`][Self::accessibilityVerticalUnitDescription].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityVerticalUnitDescription:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityVerticalUnitDescription(
            &self,
            accessibility_vertical_unit_description: Option<&NSString>,
        );

        #[unsafe(method(accessibilityLayoutPointForScreenPoint:))]
        #[unsafe(method_family = none)]
        fn accessibilityLayoutPointForScreenPoint(&self, point: NSPoint) -> NSPoint;

        #[unsafe(method(accessibilityLayoutSizeForScreenSize:))]
        #[unsafe(method_family = none)]
        fn accessibilityLayoutSizeForScreenSize(&self, size: NSSize) -> NSSize;

        #[unsafe(method(accessibilityScreenPointForLayoutPoint:))]
        #[unsafe(method_family = none)]
        fn accessibilityScreenPointForLayoutPoint(&self, point: NSPoint) -> NSPoint;

        #[unsafe(method(accessibilityScreenSizeForLayoutSize:))]
        #[unsafe(method_family = none)]
        fn accessibilityScreenSizeForLayoutSize(&self, size: NSSize) -> NSSize;

        #[unsafe(method(accessibilityHandles))]
        #[unsafe(method_family = none)]
        fn accessibilityHandles(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityHandles`][Self::accessibilityHandles].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_handles` generic should be of the correct type.
        #[unsafe(method(setAccessibilityHandles:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityHandles(&self, accessibility_handles: Option<&NSArray>);

        #[unsafe(method(accessibilityWarningValue))]
        #[unsafe(method_family = none)]
        fn accessibilityWarningValue(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityWarningValue`][Self::accessibilityWarningValue].
        ///
        /// # Safety
        ///
        /// `accessibility_warning_value` should be of the correct type.
        #[unsafe(method(setAccessibilityWarningValue:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityWarningValue(
            &self,
            accessibility_warning_value: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityCriticalValue))]
        #[unsafe(method_family = none)]
        fn accessibilityCriticalValue(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityCriticalValue`][Self::accessibilityCriticalValue].
        ///
        /// # Safety
        ///
        /// `accessibility_critical_value` should be of the correct type.
        #[unsafe(method(setAccessibilityCriticalValue:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityCriticalValue(
            &self,
            accessibility_critical_value: Option<&AnyObject>,
        );

        #[unsafe(method(isAccessibilityDisclosed))]
        #[unsafe(method_family = none)]
        fn isAccessibilityDisclosed(&self) -> bool;

        /// Setter for [`isAccessibilityDisclosed`][Self::isAccessibilityDisclosed].
        #[unsafe(method(setAccessibilityDisclosed:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityDisclosed(&self, accessibility_disclosed: bool);

        #[unsafe(method(accessibilityDisclosedByRow))]
        #[unsafe(method_family = none)]
        fn accessibilityDisclosedByRow(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityDisclosedByRow`][Self::accessibilityDisclosedByRow].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// `accessibility_disclosed_by_row` should be of the correct type.
        #[unsafe(method(setAccessibilityDisclosedByRow:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityDisclosedByRow(
            &self,
            accessibility_disclosed_by_row: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityDisclosedRows))]
        #[unsafe(method_family = none)]
        fn accessibilityDisclosedRows(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityDisclosedRows`][Self::accessibilityDisclosedRows].
        ///
        /// # Safety
        ///
        /// `accessibility_disclosed_rows` should be of the correct type.
        #[unsafe(method(setAccessibilityDisclosedRows:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityDisclosedRows(
            &self,
            accessibility_disclosed_rows: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityDisclosureLevel))]
        #[unsafe(method_family = none)]
        fn accessibilityDisclosureLevel(&self) -> NSInteger;

        /// Setter for [`accessibilityDisclosureLevel`][Self::accessibilityDisclosureLevel].
        #[unsafe(method(setAccessibilityDisclosureLevel:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityDisclosureLevel(&self, accessibility_disclosure_level: NSInteger);

        #[unsafe(method(accessibilityMarkerUIElements))]
        #[unsafe(method_family = none)]
        fn accessibilityMarkerUIElements(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityMarkerUIElements`][Self::accessibilityMarkerUIElements].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_marker_ui_elements` generic should be of the correct type.
        #[unsafe(method(setAccessibilityMarkerUIElements:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityMarkerUIElements(
            &self,
            accessibility_marker_ui_elements: Option<&NSArray>,
        );

        #[unsafe(method(accessibilityMarkerValues))]
        #[unsafe(method_family = none)]
        fn accessibilityMarkerValues(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityMarkerValues`][Self::accessibilityMarkerValues].
        ///
        /// # Safety
        ///
        /// `accessibility_marker_values` should be of the correct type.
        #[unsafe(method(setAccessibilityMarkerValues:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityMarkerValues(
            &self,
            accessibility_marker_values: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityMarkerGroupUIElement))]
        #[unsafe(method_family = none)]
        fn accessibilityMarkerGroupUIElement(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityMarkerGroupUIElement`][Self::accessibilityMarkerGroupUIElement].
        ///
        /// # Safety
        ///
        /// `accessibility_marker_group_ui_element` should be of the correct type.
        #[unsafe(method(setAccessibilityMarkerGroupUIElement:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityMarkerGroupUIElement(
            &self,
            accessibility_marker_group_ui_element: Option<&AnyObject>,
        );

        #[cfg(feature = "NSAccessibilityConstants")]
        #[unsafe(method(accessibilityUnits))]
        #[unsafe(method_family = none)]
        fn accessibilityUnits(&self) -> NSAccessibilityUnits;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// Setter for [`accessibilityUnits`][Self::accessibilityUnits].
        #[unsafe(method(setAccessibilityUnits:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityUnits(&self, accessibility_units: NSAccessibilityUnits);

        #[unsafe(method(accessibilityUnitDescription))]
        #[unsafe(method_family = none)]
        fn accessibilityUnitDescription(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityUnitDescription`][Self::accessibilityUnitDescription].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityUnitDescription:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityUnitDescription(
            &self,
            accessibility_unit_description: Option<&NSString>,
        );

        #[cfg(feature = "NSAccessibilityConstants")]
        #[unsafe(method(accessibilityRulerMarkerType))]
        #[unsafe(method_family = none)]
        fn accessibilityRulerMarkerType(&self) -> NSAccessibilityRulerMarkerType;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// Setter for [`accessibilityRulerMarkerType`][Self::accessibilityRulerMarkerType].
        #[unsafe(method(setAccessibilityRulerMarkerType:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityRulerMarkerType(
            &self,
            accessibility_ruler_marker_type: NSAccessibilityRulerMarkerType,
        );

        #[unsafe(method(accessibilityMarkerTypeDescription))]
        #[unsafe(method_family = none)]
        fn accessibilityMarkerTypeDescription(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityMarkerTypeDescription`][Self::accessibilityMarkerTypeDescription].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityMarkerTypeDescription:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityMarkerTypeDescription(
            &self,
            accessibility_marker_type_description: Option<&NSString>,
        );

        #[unsafe(method(accessibilityHorizontalScrollBar))]
        #[unsafe(method_family = none)]
        fn accessibilityHorizontalScrollBar(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityHorizontalScrollBar`][Self::accessibilityHorizontalScrollBar].
        ///
        /// # Safety
        ///
        /// `accessibility_horizontal_scroll_bar` should be of the correct type.
        #[unsafe(method(setAccessibilityHorizontalScrollBar:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityHorizontalScrollBar(
            &self,
            accessibility_horizontal_scroll_bar: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityVerticalScrollBar))]
        #[unsafe(method_family = none)]
        fn accessibilityVerticalScrollBar(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityVerticalScrollBar`][Self::accessibilityVerticalScrollBar].
        ///
        /// # Safety
        ///
        /// `accessibility_vertical_scroll_bar` should be of the correct type.
        #[unsafe(method(setAccessibilityVerticalScrollBar:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityVerticalScrollBar(
            &self,
            accessibility_vertical_scroll_bar: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityAllowedValues))]
        #[unsafe(method_family = none)]
        fn accessibilityAllowedValues(&self) -> Option<Retained<NSArray<NSNumber>>>;

        /// Setter for [`accessibilityAllowedValues`][Self::accessibilityAllowedValues].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityAllowedValues:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityAllowedValues(
            &self,
            accessibility_allowed_values: Option<&NSArray<NSNumber>>,
        );

        #[unsafe(method(accessibilityLabelUIElements))]
        #[unsafe(method_family = none)]
        fn accessibilityLabelUIElements(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityLabelUIElements`][Self::accessibilityLabelUIElements].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_label_ui_elements` generic should be of the correct type.
        #[unsafe(method(setAccessibilityLabelUIElements:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityLabelUIElements(
            &self,
            accessibility_label_ui_elements: Option<&NSArray>,
        );

        #[unsafe(method(accessibilityLabelValue))]
        #[unsafe(method_family = none)]
        fn accessibilityLabelValue(&self) -> c_float;

        /// Setter for [`accessibilityLabelValue`][Self::accessibilityLabelValue].
        #[unsafe(method(setAccessibilityLabelValue:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityLabelValue(&self, accessibility_label_value: c_float);

        #[unsafe(method(accessibilitySplitters))]
        #[unsafe(method_family = none)]
        fn accessibilitySplitters(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilitySplitters`][Self::accessibilitySplitters].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_splitters` generic should be of the correct type.
        #[unsafe(method(setAccessibilitySplitters:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilitySplitters(&self, accessibility_splitters: Option<&NSArray>);

        #[unsafe(method(accessibilityDecrementButton))]
        #[unsafe(method_family = none)]
        fn accessibilityDecrementButton(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityDecrementButton`][Self::accessibilityDecrementButton].
        ///
        /// # Safety
        ///
        /// `accessibility_decrement_button` should be of the correct type.
        #[unsafe(method(setAccessibilityDecrementButton:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityDecrementButton(
            &self,
            accessibility_decrement_button: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityIncrementButton))]
        #[unsafe(method_family = none)]
        fn accessibilityIncrementButton(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityIncrementButton`][Self::accessibilityIncrementButton].
        ///
        /// # Safety
        ///
        /// `accessibility_increment_button` should be of the correct type.
        #[unsafe(method(setAccessibilityIncrementButton:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityIncrementButton(
            &self,
            accessibility_increment_button: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityTabs))]
        #[unsafe(method_family = none)]
        fn accessibilityTabs(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityTabs`][Self::accessibilityTabs].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_tabs` generic should be of the correct type.
        #[unsafe(method(setAccessibilityTabs:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityTabs(&self, accessibility_tabs: Option<&NSArray>);

        #[unsafe(method(accessibilityHeader))]
        #[unsafe(method_family = none)]
        fn accessibilityHeader(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityHeader`][Self::accessibilityHeader].
        ///
        /// # Safety
        ///
        /// `accessibility_header` should be of the correct type.
        #[unsafe(method(setAccessibilityHeader:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityHeader(&self, accessibility_header: Option<&AnyObject>);

        #[unsafe(method(accessibilityColumnCount))]
        #[unsafe(method_family = none)]
        fn accessibilityColumnCount(&self) -> NSInteger;

        /// Setter for [`accessibilityColumnCount`][Self::accessibilityColumnCount].
        #[unsafe(method(setAccessibilityColumnCount:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityColumnCount(&self, accessibility_column_count: NSInteger);

        #[unsafe(method(accessibilityRowCount))]
        #[unsafe(method_family = none)]
        fn accessibilityRowCount(&self) -> NSInteger;

        /// Setter for [`accessibilityRowCount`][Self::accessibilityRowCount].
        #[unsafe(method(setAccessibilityRowCount:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityRowCount(&self, accessibility_row_count: NSInteger);

        #[unsafe(method(accessibilityIndex))]
        #[unsafe(method_family = none)]
        fn accessibilityIndex(&self) -> NSInteger;

        /// Setter for [`accessibilityIndex`][Self::accessibilityIndex].
        #[unsafe(method(setAccessibilityIndex:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityIndex(&self, accessibility_index: NSInteger);

        #[unsafe(method(accessibilityColumns))]
        #[unsafe(method_family = none)]
        fn accessibilityColumns(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityColumns`][Self::accessibilityColumns].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_columns` generic should be of the correct type.
        #[unsafe(method(setAccessibilityColumns:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityColumns(&self, accessibility_columns: Option<&NSArray>);

        #[unsafe(method(accessibilityRows))]
        #[unsafe(method_family = none)]
        fn accessibilityRows(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityRows`][Self::accessibilityRows].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_rows` generic should be of the correct type.
        #[unsafe(method(setAccessibilityRows:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityRows(&self, accessibility_rows: Option<&NSArray>);

        #[unsafe(method(accessibilityVisibleRows))]
        #[unsafe(method_family = none)]
        fn accessibilityVisibleRows(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityVisibleRows`][Self::accessibilityVisibleRows].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_visible_rows` generic should be of the correct type.
        #[unsafe(method(setAccessibilityVisibleRows:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityVisibleRows(&self, accessibility_visible_rows: Option<&NSArray>);

        #[unsafe(method(accessibilitySelectedRows))]
        #[unsafe(method_family = none)]
        fn accessibilitySelectedRows(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilitySelectedRows`][Self::accessibilitySelectedRows].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_selected_rows` generic should be of the correct type.
        #[unsafe(method(setAccessibilitySelectedRows:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilitySelectedRows(
            &self,
            accessibility_selected_rows: Option<&NSArray>,
        );

        #[unsafe(method(accessibilityVisibleColumns))]
        #[unsafe(method_family = none)]
        fn accessibilityVisibleColumns(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityVisibleColumns`][Self::accessibilityVisibleColumns].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_visible_columns` generic should be of the correct type.
        #[unsafe(method(setAccessibilityVisibleColumns:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityVisibleColumns(
            &self,
            accessibility_visible_columns: Option<&NSArray>,
        );

        #[unsafe(method(accessibilitySelectedColumns))]
        #[unsafe(method_family = none)]
        fn accessibilitySelectedColumns(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilitySelectedColumns`][Self::accessibilitySelectedColumns].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_selected_columns` generic should be of the correct type.
        #[unsafe(method(setAccessibilitySelectedColumns:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilitySelectedColumns(
            &self,
            accessibility_selected_columns: Option<&NSArray>,
        );

        #[cfg(feature = "NSAccessibilityConstants")]
        #[unsafe(method(accessibilitySortDirection))]
        #[unsafe(method_family = none)]
        fn accessibilitySortDirection(&self) -> NSAccessibilitySortDirection;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// Setter for [`accessibilitySortDirection`][Self::accessibilitySortDirection].
        #[unsafe(method(setAccessibilitySortDirection:))]
        #[unsafe(method_family = none)]
        fn setAccessibilitySortDirection(
            &self,
            accessibility_sort_direction: NSAccessibilitySortDirection,
        );

        #[unsafe(method(accessibilityRowHeaderUIElements))]
        #[unsafe(method_family = none)]
        fn accessibilityRowHeaderUIElements(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityRowHeaderUIElements`][Self::accessibilityRowHeaderUIElements].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_row_header_ui_elements` generic should be of the correct type.
        #[unsafe(method(setAccessibilityRowHeaderUIElements:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityRowHeaderUIElements(
            &self,
            accessibility_row_header_ui_elements: Option<&NSArray>,
        );

        #[unsafe(method(accessibilitySelectedCells))]
        #[unsafe(method_family = none)]
        fn accessibilitySelectedCells(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilitySelectedCells`][Self::accessibilitySelectedCells].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_selected_cells` generic should be of the correct type.
        #[unsafe(method(setAccessibilitySelectedCells:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilitySelectedCells(
            &self,
            accessibility_selected_cells: Option<&NSArray>,
        );

        #[unsafe(method(accessibilityVisibleCells))]
        #[unsafe(method_family = none)]
        fn accessibilityVisibleCells(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityVisibleCells`][Self::accessibilityVisibleCells].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_visible_cells` generic should be of the correct type.
        #[unsafe(method(setAccessibilityVisibleCells:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityVisibleCells(
            &self,
            accessibility_visible_cells: Option<&NSArray>,
        );

        #[unsafe(method(accessibilityColumnHeaderUIElements))]
        #[unsafe(method_family = none)]
        fn accessibilityColumnHeaderUIElements(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityColumnHeaderUIElements`][Self::accessibilityColumnHeaderUIElements].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_column_header_ui_elements` generic should be of the correct type.
        #[unsafe(method(setAccessibilityColumnHeaderUIElements:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityColumnHeaderUIElements(
            &self,
            accessibility_column_header_ui_elements: Option<&NSArray>,
        );

        #[unsafe(method(accessibilityCellForColumn:row:))]
        #[unsafe(method_family = none)]
        fn accessibilityCellForColumn_row(
            &self,
            column: NSInteger,
            row: NSInteger,
        ) -> Option<Retained<AnyObject>>;

        #[unsafe(method(accessibilityRowIndexRange))]
        #[unsafe(method_family = none)]
        fn accessibilityRowIndexRange(&self) -> NSRange;

        /// Setter for [`accessibilityRowIndexRange`][Self::accessibilityRowIndexRange].
        #[unsafe(method(setAccessibilityRowIndexRange:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityRowIndexRange(&self, accessibility_row_index_range: NSRange);

        #[unsafe(method(accessibilityColumnIndexRange))]
        #[unsafe(method_family = none)]
        fn accessibilityColumnIndexRange(&self) -> NSRange;

        /// Setter for [`accessibilityColumnIndexRange`][Self::accessibilityColumnIndexRange].
        #[unsafe(method(setAccessibilityColumnIndexRange:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityColumnIndexRange(&self, accessibility_column_index_range: NSRange);

        #[unsafe(method(accessibilityInsertionPointLineNumber))]
        #[unsafe(method_family = none)]
        fn accessibilityInsertionPointLineNumber(&self) -> NSInteger;

        /// Setter for [`accessibilityInsertionPointLineNumber`][Self::accessibilityInsertionPointLineNumber].
        #[unsafe(method(setAccessibilityInsertionPointLineNumber:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityInsertionPointLineNumber(
            &self,
            accessibility_insertion_point_line_number: NSInteger,
        );

        #[unsafe(method(accessibilitySharedCharacterRange))]
        #[unsafe(method_family = none)]
        fn accessibilitySharedCharacterRange(&self) -> NSRange;

        /// Setter for [`accessibilitySharedCharacterRange`][Self::accessibilitySharedCharacterRange].
        #[unsafe(method(setAccessibilitySharedCharacterRange:))]
        #[unsafe(method_family = none)]
        fn setAccessibilitySharedCharacterRange(
            &self,
            accessibility_shared_character_range: NSRange,
        );

        #[unsafe(method(accessibilitySharedTextUIElements))]
        #[unsafe(method_family = none)]
        fn accessibilitySharedTextUIElements(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilitySharedTextUIElements`][Self::accessibilitySharedTextUIElements].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_shared_text_ui_elements` generic should be of the correct type.
        #[unsafe(method(setAccessibilitySharedTextUIElements:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilitySharedTextUIElements(
            &self,
            accessibility_shared_text_ui_elements: Option<&NSArray>,
        );

        #[unsafe(method(accessibilityVisibleCharacterRange))]
        #[unsafe(method_family = none)]
        fn accessibilityVisibleCharacterRange(&self) -> NSRange;

        /// Setter for [`accessibilityVisibleCharacterRange`][Self::accessibilityVisibleCharacterRange].
        #[unsafe(method(setAccessibilityVisibleCharacterRange:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityVisibleCharacterRange(
            &self,
            accessibility_visible_character_range: NSRange,
        );

        #[unsafe(method(accessibilityNumberOfCharacters))]
        #[unsafe(method_family = none)]
        fn accessibilityNumberOfCharacters(&self) -> NSInteger;

        /// Setter for [`accessibilityNumberOfCharacters`][Self::accessibilityNumberOfCharacters].
        #[unsafe(method(setAccessibilityNumberOfCharacters:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityNumberOfCharacters(&self, accessibility_number_of_characters: NSInteger);

        #[unsafe(method(accessibilitySelectedText))]
        #[unsafe(method_family = none)]
        fn accessibilitySelectedText(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilitySelectedText`][Self::accessibilitySelectedText].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilitySelectedText:))]
        #[unsafe(method_family = none)]
        fn setAccessibilitySelectedText(&self, accessibility_selected_text: Option<&NSString>);

        #[unsafe(method(accessibilitySelectedTextRange))]
        #[unsafe(method_family = none)]
        fn accessibilitySelectedTextRange(&self) -> NSRange;

        /// Setter for [`accessibilitySelectedTextRange`][Self::accessibilitySelectedTextRange].
        #[unsafe(method(setAccessibilitySelectedTextRange:))]
        #[unsafe(method_family = none)]
        fn setAccessibilitySelectedTextRange(&self, accessibility_selected_text_range: NSRange);

        #[unsafe(method(accessibilitySelectedTextRanges))]
        #[unsafe(method_family = none)]
        fn accessibilitySelectedTextRanges(&self) -> Option<Retained<NSArray<NSValue>>>;

        /// Setter for [`accessibilitySelectedTextRanges`][Self::accessibilitySelectedTextRanges].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilitySelectedTextRanges:))]
        #[unsafe(method_family = none)]
        fn setAccessibilitySelectedTextRanges(
            &self,
            accessibility_selected_text_ranges: Option<&NSArray<NSValue>>,
        );

        #[unsafe(method(accessibilityAttributedStringForRange:))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedStringForRange(
            &self,
            range: NSRange,
        ) -> Option<Retained<NSAttributedString>>;

        #[unsafe(method(accessibilityRangeForLine:))]
        #[unsafe(method_family = none)]
        fn accessibilityRangeForLine(&self, line: NSInteger) -> NSRange;

        #[unsafe(method(accessibilityStringForRange:))]
        #[unsafe(method_family = none)]
        fn accessibilityStringForRange(&self, range: NSRange) -> Option<Retained<NSString>>;

        #[unsafe(method(accessibilityRangeForPosition:))]
        #[unsafe(method_family = none)]
        fn accessibilityRangeForPosition(&self, point: NSPoint) -> NSRange;

        #[unsafe(method(accessibilityRangeForIndex:))]
        #[unsafe(method_family = none)]
        fn accessibilityRangeForIndex(&self, index: NSInteger) -> NSRange;

        #[unsafe(method(accessibilityFrameForRange:))]
        #[unsafe(method_family = none)]
        fn accessibilityFrameForRange(&self, range: NSRange) -> NSRect;

        #[unsafe(method(accessibilityRTFForRange:))]
        #[unsafe(method_family = none)]
        fn accessibilityRTFForRange(&self, range: NSRange) -> Option<Retained<NSData>>;

        #[unsafe(method(accessibilityStyleRangeForIndex:))]
        #[unsafe(method_family = none)]
        fn accessibilityStyleRangeForIndex(&self, index: NSInteger) -> NSRange;

        #[unsafe(method(accessibilityLineForIndex:))]
        #[unsafe(method_family = none)]
        fn accessibilityLineForIndex(&self, index: NSInteger) -> NSInteger;

        #[unsafe(method(accessibilityToolbarButton))]
        #[unsafe(method_family = none)]
        fn accessibilityToolbarButton(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityToolbarButton`][Self::accessibilityToolbarButton].
        ///
        /// # Safety
        ///
        /// `accessibility_toolbar_button` should be of the correct type.
        #[unsafe(method(setAccessibilityToolbarButton:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityToolbarButton(
            &self,
            accessibility_toolbar_button: Option<&AnyObject>,
        );

        #[unsafe(method(isAccessibilityModal))]
        #[unsafe(method_family = none)]
        fn isAccessibilityModal(&self) -> bool;

        /// Setter for [`isAccessibilityModal`][Self::isAccessibilityModal].
        #[unsafe(method(setAccessibilityModal:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityModal(&self, accessibility_modal: bool);

        #[unsafe(method(accessibilityProxy))]
        #[unsafe(method_family = none)]
        fn accessibilityProxy(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityProxy`][Self::accessibilityProxy].
        ///
        /// # Safety
        ///
        /// `accessibility_proxy` should be of the correct type.
        #[unsafe(method(setAccessibilityProxy:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityProxy(&self, accessibility_proxy: Option<&AnyObject>);

        #[unsafe(method(isAccessibilityMain))]
        #[unsafe(method_family = none)]
        fn isAccessibilityMain(&self) -> bool;

        /// Setter for [`isAccessibilityMain`][Self::isAccessibilityMain].
        #[unsafe(method(setAccessibilityMain:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityMain(&self, accessibility_main: bool);

        #[unsafe(method(accessibilityFullScreenButton))]
        #[unsafe(method_family = none)]
        fn accessibilityFullScreenButton(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityFullScreenButton`][Self::accessibilityFullScreenButton].
        ///
        /// # Safety
        ///
        /// `accessibility_full_screen_button` should be of the correct type.
        #[unsafe(method(setAccessibilityFullScreenButton:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityFullScreenButton(
            &self,
            accessibility_full_screen_button: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityGrowArea))]
        #[unsafe(method_family = none)]
        fn accessibilityGrowArea(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityGrowArea`][Self::accessibilityGrowArea].
        ///
        /// # Safety
        ///
        /// `accessibility_grow_area` should be of the correct type.
        #[unsafe(method(setAccessibilityGrowArea:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityGrowArea(&self, accessibility_grow_area: Option<&AnyObject>);

        #[unsafe(method(accessibilityDocument))]
        #[unsafe(method_family = none)]
        fn accessibilityDocument(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityDocument`][Self::accessibilityDocument].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityDocument:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityDocument(&self, accessibility_document: Option<&NSString>);

        #[unsafe(method(accessibilityDefaultButton))]
        #[unsafe(method_family = none)]
        fn accessibilityDefaultButton(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityDefaultButton`][Self::accessibilityDefaultButton].
        ///
        /// # Safety
        ///
        /// `accessibility_default_button` should be of the correct type.
        #[unsafe(method(setAccessibilityDefaultButton:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityDefaultButton(
            &self,
            accessibility_default_button: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityCloseButton))]
        #[unsafe(method_family = none)]
        fn accessibilityCloseButton(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityCloseButton`][Self::accessibilityCloseButton].
        ///
        /// # Safety
        ///
        /// `accessibility_close_button` should be of the correct type.
        #[unsafe(method(setAccessibilityCloseButton:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityCloseButton(
            &self,
            accessibility_close_button: Option<&AnyObject>,
        );

        #[unsafe(method(accessibilityZoomButton))]
        #[unsafe(method_family = none)]
        fn accessibilityZoomButton(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityZoomButton`][Self::accessibilityZoomButton].
        ///
        /// # Safety
        ///
        /// `accessibility_zoom_button` should be of the correct type.
        #[unsafe(method(setAccessibilityZoomButton:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityZoomButton(&self, accessibility_zoom_button: Option<&AnyObject>);

        #[unsafe(method(accessibilityMinimizeButton))]
        #[unsafe(method_family = none)]
        fn accessibilityMinimizeButton(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityMinimizeButton`][Self::accessibilityMinimizeButton].
        ///
        /// # Safety
        ///
        /// `accessibility_minimize_button` should be of the correct type.
        #[unsafe(method(setAccessibilityMinimizeButton:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityMinimizeButton(
            &self,
            accessibility_minimize_button: Option<&AnyObject>,
        );

        #[unsafe(method(isAccessibilityMinimized))]
        #[unsafe(method_family = none)]
        fn isAccessibilityMinimized(&self) -> bool;

        /// Setter for [`isAccessibilityMinimized`][Self::isAccessibilityMinimized].
        #[unsafe(method(setAccessibilityMinimized:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityMinimized(&self, accessibility_minimized: bool);

        #[cfg(feature = "NSAccessibilityCustomAction")]
        #[unsafe(method(accessibilityCustomActions))]
        #[unsafe(method_family = none)]
        fn accessibilityCustomActions(
            &self,
        ) -> Option<Retained<NSArray<NSAccessibilityCustomAction>>>;

        #[cfg(feature = "NSAccessibilityCustomAction")]
        /// Setter for [`accessibilityCustomActions`][Self::accessibilityCustomActions].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityCustomActions:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityCustomActions(
            &self,
            accessibility_custom_actions: Option<&NSArray<NSAccessibilityCustomAction>>,
        );

        #[unsafe(method(accessibilityPerformCancel))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformCancel(&self) -> bool;

        #[unsafe(method(accessibilityPerformConfirm))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformConfirm(&self) -> bool;

        #[unsafe(method(accessibilityPerformDecrement))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformDecrement(&self) -> bool;

        #[unsafe(method(accessibilityPerformDelete))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformDelete(&self) -> bool;

        #[unsafe(method(accessibilityPerformIncrement))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformIncrement(&self) -> bool;

        #[unsafe(method(accessibilityPerformPick))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformPick(&self) -> bool;

        #[unsafe(method(accessibilityPerformPress))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformPress(&self) -> bool;

        #[unsafe(method(accessibilityPerformRaise))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformRaise(&self) -> bool;

        #[unsafe(method(accessibilityPerformShowAlternateUI))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformShowAlternateUI(&self) -> bool;

        #[unsafe(method(accessibilityPerformShowDefaultUI))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformShowDefaultUI(&self) -> bool;

        #[unsafe(method(accessibilityPerformShowMenu))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformShowMenu(&self) -> bool;

        /// # Safety
        ///
        /// `selector` must be a valid selector.
        #[unsafe(method(isAccessibilitySelectorAllowed:))]
        #[unsafe(method_family = none)]
        unsafe fn isAccessibilitySelectorAllowed(&self, selector: Sel) -> bool;
    }
);
