/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.commands;

import org.hampelratte.svdrp.Command;

public class PLAY
extends Command {
    private static final long serialVersionUID = 2L;
    public static final String BEGIN = "begin";
    int startFrame = -1;
    String startTime = null;
    int recordingNumber;

    public PLAY(int recordingNumber) {
        this(recordingNumber, -1);
    }

    public PLAY(int recordingNumber, int startFrame) {
        this.recordingNumber = recordingNumber;
        this.startFrame = startFrame;
    }

    public PLAY(int recordingNumber, String startTime) {
        this.recordingNumber = recordingNumber;
        this.startTime = startTime;
    }

    public int getRecordingNumber() {
        return this.recordingNumber;
    }

    public void setRecordingNumber(int recordingNumber) {
        this.recordingNumber = recordingNumber;
    }

    public int getStartFrame() {
        return this.startFrame;
    }

    public void setStartFrame(int startFrame) {
        this.startFrame = startFrame;
        this.startTime = null;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        if (startTime != null && !BEGIN.equals(startTime) && !startTime.matches("\\d\\d:\\d\\d:\\d\\d(?:\\.\\d\\d)?")) {
            throw new IllegalArgumentException("Start time has to be in the format hh:mm:ss[.ff]");
        }
        this.startTime = startTime;
        this.startFrame = -1;
    }

    @Override
    public String getCommand() {
        String command = "PLAY " + this.recordingNumber;
        if (this.startFrame > -1) {
            command = command + " " + this.startFrame;
        } else if (this.startTime != null) {
            command = command + " " + this.startTime;
        }
        return command;
    }

    @Override
    public String toString() {
        return "PLAY";
    }
}

