/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.parsers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hampelratte.svdrp.responses.highlevel.Timer;

public class TimerParser {
    public static List<Timer> parse(String timerData) {
        ArrayList<Timer> list = new ArrayList<Timer>();
        StringTokenizer st1 = new StringTokenizer(timerData, "\n");
        while (st1.hasMoreTokens()) {
            Timer timer = new Timer();
            String line = st1.nextToken();
            int pos = line.indexOf(" ");
            String id = line.substring(0, pos);
            String restOfLine = line.substring(pos + 1);
            StringTokenizer st = new StringTokenizer(restOfLine, ":");
            String active = st.nextToken();
            String channel = st.nextToken();
            String day = st.nextToken();
            String starttime = st.nextToken();
            String endtime = st.nextToken();
            TimerParser.parseDay(timer, day, starttime, endtime);
            String priority = st.nextToken();
            String lifetime = st.nextToken();
            String file = st.nextToken();
            String desc = "";
            while (st.hasMoreTokens()) {
                desc = desc + st.nextToken();
                if (!st.hasMoreTokens()) continue;
                desc = desc + ":";
            }
            desc = desc.replaceAll("\\|", "\n");
            timer.setID(Integer.parseInt(id));
            timer.setState(Integer.parseInt(active));
            timer.setChannelNumber(Integer.parseInt(channel));
            timer.setPriority(Integer.parseInt(priority));
            timer.setLifetime(Integer.parseInt(lifetime));
            timer.setFile(file);
            timer.setDescription(desc);
            list.add(timer);
        }
        return list;
    }

    private static void parseTime(Calendar time, String timeString) {
        int hours = Integer.parseInt(timeString.substring(0, 2));
        int minutes = Integer.parseInt(timeString.substring(2));
        time.set(11, hours);
        time.set(12, minutes);
    }

    private static void parseDay(Timer timer, String day, String startString, String endString) {
        Calendar startTime = timer.getStartTime();
        Calendar endTime = timer.getEndTime();
        Calendar firstTime = timer.getFirstTime();
        Pattern dayPattern = Pattern.compile("([1-9]|[12][0-9]|3[01])");
        Pattern datePattern = Pattern.compile("((?:19|20)\\d\\d)-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])");
        Pattern simpleRepeating = Pattern.compile("(\\p{Upper}|-){7}");
        Pattern repeatingAtShort = Pattern.compile("((?:\\p{Upper}|-){7})@(0?[1-9]|[12][0-9]|3[01])");
        Pattern repeatingAt = Pattern.compile("((?:\\p{Upper}|-){7})@((?:19|20)\\d\\d)-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])");
        Matcher matcher = dayPattern.matcher(day);
        if (matcher.matches()) {
            int day_of_month = Integer.parseInt(day);
            int today = startTime.get(5);
            startTime.set(5, day_of_month);
            endTime.set(5, day_of_month);
            if (day_of_month < today) {
                startTime.add(2, 1);
                endTime.add(2, 1);
            }
            TimerParser.parseTime(startTime, startString);
            TimerParser.parseTime(endTime, endString);
            if (endTime.get(11) < startTime.get(11)) {
                endTime.add(5, 1);
            }
        } else {
            matcher = datePattern.matcher(day);
            if (matcher.matches()) {
                int day_of_month = Integer.parseInt(matcher.group(3));
                int month = Integer.parseInt(matcher.group(2)) - 1;
                int year = Integer.parseInt(matcher.group(1));
                TimerParser.parseTime(startTime, startString);
                TimerParser.parseTime(endTime, endString);
                startTime.set(5, day_of_month);
                startTime.set(2, month);
                startTime.set(1, year);
                endTime.set(5, day_of_month);
                endTime.set(2, month);
                endTime.set(1, year);
                if (endTime.get(11) < startTime.get(11)) {
                    endTime.add(5, 1);
                }
            } else {
                matcher = simpleRepeating.matcher(day);
                if (matcher.matches()) {
                    timer.setRepeatingDays(TimerParser.determineDays(day));
                    int day_of_month = -1;
                    TimerParser.parseTime(startTime, startString);
                    TimerParser.parseTime(endTime, endString);
                    if (endTime.get(11) < startTime.get(11)) {
                        endTime.add(5, 1);
                    }
                } else {
                    matcher = repeatingAtShort.matcher(day);
                    if (matcher.matches()) {
                        timer.setHasFirstTime(true);
                        String days = matcher.group(1);
                        timer.setRepeatingDays(TimerParser.determineDays(days));
                        int day_of_month = Integer.parseInt(matcher.group(2));
                        firstTime.set(5, day_of_month);
                        startTime.set(5, day_of_month);
                        endTime.set(5, day_of_month);
                        TimerParser.parseTime(startTime, startString);
                        TimerParser.parseTime(endTime, endString);
                        if (endTime.get(11) < startTime.get(11)) {
                            endTime.add(5, 1);
                        }
                    } else {
                        matcher = repeatingAt.matcher(day);
                        if (matcher.matches()) {
                            timer.setHasFirstTime(true);
                            String days = matcher.group(1);
                            timer.setRepeatingDays(TimerParser.determineDays(days));
                            int day_of_month = Integer.parseInt(matcher.group(4));
                            int month = Integer.parseInt(matcher.group(3)) - 1;
                            int year = Integer.parseInt(matcher.group(2));
                            TimerParser.parseTime(startTime, startString);
                            TimerParser.parseTime(endTime, endString);
                            firstTime.set(5, day_of_month);
                            firstTime.set(2, month);
                            firstTime.set(1, year);
                            startTime.set(5, day_of_month);
                            startTime.set(2, month);
                            startTime.set(1, year);
                            endTime.set(5, day_of_month);
                            endTime.set(2, month);
                            endTime.set(1, year);
                            if (endTime.get(11) < startTime.get(11)) {
                                endTime.add(5, 1);
                            }
                        }
                    }
                }
            }
        }
    }

    private static boolean[] determineDays(String days) {
        boolean[] d = new boolean[days.length()];
        char[] chars = days.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            d[i] = chars[i] != '-';
        }
        return d;
    }
}

