/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.responses.highlevel;

import java.util.ArrayList;
import java.util.List;
import org.hampelratte.svdrp.responses.highlevel.TreeNode;

public class Folder
implements TreeNode {
    private String title;
    private List<TreeNode> children = new ArrayList<TreeNode>();

    public Folder(String title) {
        if (!title.isEmpty()) {
            while (title.charAt(0) == '%') {
                title = title.substring(1);
            }
        }
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDisplayTitle() {
        return this.title;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode> children) {
        this.children = children;
    }

    public void merge(TreeNode subtree) {
        if (subtree instanceof Folder) {
            ArrayList<Object[]> treesToMerge = new ArrayList<Object[]>();
            boolean matched = false;
            for (TreeNode child : this.getChildren()) {
                if (!(child instanceof Folder) || !child.getDisplayTitle().equals(subtree.getDisplayTitle())) continue;
                treesToMerge.add(new Object[]{child, subtree});
                matched = true;
            }
            if (!matched) {
                this.getChildren().add(subtree);
            }
            for (Object[] trees : treesToMerge) {
                Folder childFolder = (Folder)trees[0];
                Folder subtreeFolder = (Folder)trees[1];
                for (TreeNode newChild : subtreeFolder.getChildren()) {
                    childFolder.merge(newChild);
                }
            }
        } else {
            this.getChildren().add(subtree);
        }
    }

    public String toString() {
        return this.getDisplayTitle();
    }
}

