/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.commons.nullanalysis.Nullable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SwingLookAndFeelTask
extends Task {
    @Nullable
    private String lookAndFeelNameProperty;
    @Nullable
    private String lookAndFeelIdProperty;
    @Nullable
    private String lookAndFeelClassNameProperty;
    @Nullable
    private String auxiliaryLookAndFeelNamesProperty;
    @Nullable
    private String auxiliaryLookAndFeelIdsProperty;
    @Nullable
    private String installedLookAndFeelNamesProperty;
    @Nullable
    private String installedLookAndFeelClassNamesProperty;
    @Nullable
    private String className;
    private String separator = ",";

    public void setGetLookAndFeelName(String propertyName) {
        this.lookAndFeelNameProperty = propertyName;
    }

    public void setGetLookAndFeelId(String propertyName) {
        this.lookAndFeelIdProperty = propertyName;
    }

    public void setGetLookAndFeelClassName(String propertyName) {
        this.lookAndFeelClassNameProperty = propertyName;
    }

    public void setGetAuxiliaryLookAndFeelNames(String propertyName) {
        this.auxiliaryLookAndFeelNamesProperty = propertyName;
    }

    public void setGetAuxiliaryLookAndFeelIds(String propertyName) {
        this.auxiliaryLookAndFeelIdsProperty = propertyName;
    }

    public void setGetInstalledLookAndFeelNames(String propertyName) {
        this.installedLookAndFeelNamesProperty = propertyName;
    }

    public void setGetInstalledLookAndFeelClassNames(String propertyName) {
        this.installedLookAndFeelClassNamesProperty = propertyName;
    }

    public void setName(String name) {
        for (UIManager.LookAndFeelInfo lafi : UIManager.getInstalledLookAndFeels()) {
            if (!lafi.getName().equals(name)) continue;
            this.setClassName(lafi.getClassName());
            return;
        }
        throw new BuildException("Unknown look-and-feel name \"" + name + "\"");
    }

    public void setClassName(String className) {
        if (this.className != null) {
            throw new BuildException("At most one look-and-feel can be set");
        }
        this.className = className;
    }

    public void setCrossPlatform(boolean value) {
        if (value) {
            this.setClassName(UIManager.getCrossPlatformLookAndFeelClassName());
        }
    }

    public void setSystem(boolean value) {
        if (value) {
            this.setClassName(UIManager.getSystemLookAndFeelClassName());
        }
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void execute() throws BuildException {
        UIManager.LookAndFeelInfo[] installedLookAndFeelInfos;
        int i;
        LookAndFeel[] auxiliaryLookAndFeels;
        StringBuilder result;
        if (this.lookAndFeelNameProperty != null) {
            this.getProject().setProperty(this.lookAndFeelNameProperty, UIManager.getLookAndFeel().getName());
        }
        if (this.lookAndFeelIdProperty != null) {
            this.getProject().setProperty(this.lookAndFeelIdProperty, UIManager.getLookAndFeel().getID());
        }
        if (this.lookAndFeelClassNameProperty != null) {
            this.getProject().setProperty(this.lookAndFeelClassNameProperty, UIManager.getLookAndFeel().getClass().getName());
        }
        if (this.auxiliaryLookAndFeelNamesProperty != null) {
            result = new StringBuilder();
            auxiliaryLookAndFeels = UIManager.getAuxiliaryLookAndFeels();
            if (auxiliaryLookAndFeels != null) {
                for (i = 0; i < auxiliaryLookAndFeels.length; ++i) {
                    if (i > 0) {
                        result.append(this.separator);
                    }
                    result.append(auxiliaryLookAndFeels[i].getName());
                }
            }
            this.getProject().setProperty(this.auxiliaryLookAndFeelNamesProperty, result.toString());
        }
        if (this.auxiliaryLookAndFeelIdsProperty != null) {
            result = new StringBuilder();
            auxiliaryLookAndFeels = UIManager.getAuxiliaryLookAndFeels();
            if (auxiliaryLookAndFeels != null) {
                for (i = 0; i < auxiliaryLookAndFeels.length; ++i) {
                    if (i > 0) {
                        result.append(this.separator);
                    }
                    result.append(auxiliaryLookAndFeels[i].getID());
                }
            }
            this.getProject().setProperty(this.auxiliaryLookAndFeelIdsProperty, result.toString());
        }
        if (this.installedLookAndFeelNamesProperty != null) {
            result = new StringBuilder();
            installedLookAndFeelInfos = UIManager.getInstalledLookAndFeels();
            for (i = 0; i < installedLookAndFeelInfos.length; ++i) {
                if (i > 0) {
                    result.append(this.separator);
                }
                result.append(installedLookAndFeelInfos[i].getName());
            }
            this.getProject().setProperty(this.installedLookAndFeelNamesProperty, result.toString());
        }
        if (this.installedLookAndFeelClassNamesProperty != null) {
            result = new StringBuilder();
            installedLookAndFeelInfos = UIManager.getInstalledLookAndFeels();
            for (i = 0; i < installedLookAndFeelInfos.length; ++i) {
                if (i > 0) {
                    result.append(this.separator);
                }
                result.append(installedLookAndFeelInfos[i].getClassName());
            }
            this.getProject().setProperty(this.installedLookAndFeelClassNamesProperty, result.toString());
        }
        if (this.className != null) {
            try {
                UIManager.setLookAndFeel(this.className);
            }
            catch (Exception e) {
                throw new BuildException("Setting look-and-feel \"" + this.className + "\"", (Throwable)e, this.getLocation());
            }
        }
    }
}

