/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.type;

import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.StringResource;

public class ResourceNames
extends ProjectComponent
implements ResourceCollection,
Iterable<Resource> {
    @Nullable
    private ResourceCollection delegate;

    public void addConfigured(ResourceCollection value) {
        if (this.delegate != null) {
            throw new BuildException("No more than one resource collection subelement allowed");
        }
        this.delegate = value;
    }

    public boolean isFilesystemOnly() {
        return false;
    }

    @Override
    public Iterator<Resource> iterator() {
        final ResourceCollection delegate = this.delegate;
        if (delegate == null) {
            throw new BuildException("Resource collection subelement missing");
        }
        return new Iterator<Resource>(){
            final Iterator<Resource> iter;
            {
                this.iter = delegate.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Resource next() {
                Resource resource = this.iter.next();
                String name = resource.getName();
                return new StringResource(ResourceNames.this.getProject(), name);
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    public int size() {
        ResourceCollection delegate = this.delegate;
        if (delegate == null) {
            throw new BuildException("Resource collection subelement missing");
        }
        return delegate.size();
    }
}

