/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.protocol;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateWhichThrows;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.nullanalysis.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

public final class Mappings {
    private static final Mapping NONE;

    private Mappings() {
    }

    public static <K, V> Mapping<K, V> fromMap(final Map<K, V> map) {
        return new Mapping<K, V>(){

            @Override
            public boolean containsKey(@Nullable Object key) {
                return map.containsKey(key);
            }

            @Override
            public V get(@Nullable Object key) {
                return map.get(key);
            }

            public String toString() {
                return map.toString();
            }
        };
    }

    public static <K, V> Mapping<K, V> mapping(final Object ... keysAndValues) {
        return new Mapping<K, V>(){

            @Override
            public boolean containsKey(@Nullable Object key) {
                for (int i = 0; i < keysAndValues.length; i += 2) {
                    if (!ObjectUtil.equals(keysAndValues[i], key)) continue;
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            public V get(@Nullable Object key) {
                for (int i = 0; i < keysAndValues.length; i += 2) {
                    if (!ObjectUtil.equals(keysAndValues[i], key)) continue;
                    Object value = keysAndValues[i + 1];
                    if (value instanceof Producer) {
                        Producer producer = (Producer)value;
                        return producer.produce();
                    }
                    Object value2 = value;
                    return value2;
                }
                return null;
            }

            public String toString() {
                return Arrays.toString(keysAndValues);
            }
        };
    }

    public static <K, V> Mapping<K, V> none() {
        return NONE;
    }

    public static Mapping<String, Object> propertiesOf(final Object subject) {
        final Class<?> clasS = subject.getClass();
        if (clasS.isArray()) {
            return Mappings.mapping("length", ((Object[])subject).length);
        }
        return new Mapping<String, Object>(){

            @Override
            @Nullable
            public Object get(@Nullable Object key) {
                assert (key instanceof String);
                Object result = this.get((String)key);
                return result == this ? null : result;
            }

            @Override
            public boolean containsKey(@Nullable Object key) {
                assert (key instanceof String);
                return this.get((String)key) != this;
            }

            @Nullable
            private Object get(String propertyName) {
                for (String getterMethodPrefix : new String[]{"get", "is", "has"}) {
                    try {
                        String getterMethodName = getterMethodPrefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                        Method m = clasS.getMethod(getterMethodName, new Class[0]);
                        m.setAccessible(true);
                        return m.invoke(subject, new Object[0]);
                    }
                    catch (InvocationTargetException ite) {
                        throw new RuntimeException(ite.getTargetException());
                    }
                    catch (Exception exception) {
                    }
                }
                try {
                    Method m = clasS.getMethod(propertyName, new Class[0]);
                    m.setAccessible(true);
                    return m.invoke(subject, new Object[0]);
                }
                catch (InvocationTargetException ite) {
                    throw new RuntimeException(ite.getTargetException());
                }
                catch (Exception exception) {
                    try {
                        return clasS.getField(propertyName).get(subject);
                    }
                    catch (Exception exception2) {
                        return this;
                    }
                }
            }

            public String toString() {
                return "Properties of \"" + subject.toString() + "\" (" + subject.getClass() + ")";
            }
        };
    }

    @Nullable
    public static <K, T> T get(Mapping<? extends K, ?> mapping, Object key, Class<T> targetType) {
        Object value = mapping.get(key);
        if (value == null) {
            return null;
        }
        Class<?> actualType = value.getClass();
        try {
            if (targetType.isAssignableFrom(actualType) || targetType.isPrimitive() && actualType.getDeclaredField("TYPE").get(null) == targetType) {
                Object tmp = value;
                return (T)tmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("Value '" + value + "' of key '" + key + "' of mapping '" + mapping + "' has unexpected type '" + actualType + "' - expected '" + targetType + "'");
    }

    public static <K> Object getNonNull(Mapping<K, ?> mapping, String key) {
        Object value = mapping.get(key);
        if (value == null) {
            if (!mapping.containsKey(key)) {
                throw new IllegalArgumentException("Mapping '" + mapping + "' does not contain the key '" + key + "'");
            }
            throw new IllegalArgumentException("Value of key '" + key + "' of mapping '" + mapping + "' is <null>");
        }
        return value;
    }

    public static <K, T> T getNonNull(Mapping<K, ?> mapping, String key, Class<T> targetType) {
        T value = Mappings.get(mapping, key, targetType);
        if (value == null) {
            if (!mapping.containsKey(key)) {
                throw new IllegalArgumentException("Mapping '" + mapping + "' does not contain the key '" + key + "'");
            }
            throw new IllegalArgumentException("Value of key '" + key + "' of mapping '" + mapping + "' is <null>");
        }
        return value;
    }

    public static <K, V> Mapping<K, V> union(final Mapping<K, V> op1, final Mapping<K, V> op2) {
        if (op1 == NONE) {
            return op2;
        }
        if (op2 == NONE) {
            return op1;
        }
        return new Mapping<K, V>(){

            @Override
            public boolean containsKey(@Nullable Object key) {
                return op1.containsKey(key) || op2.containsKey(key);
            }

            @Override
            @Nullable
            public V get(@Nullable Object key) {
                Object value = op1.get(key);
                return value != null || op1.containsKey(key) ? value : op2.get(key);
            }

            public String toString() {
                return "(union of " + op1 + " and " + op2 + ")";
            }
        };
    }

    public static <K, V> Mapping<K, V> augment(Mapping<K, V> in, Object ... keysAndValues) {
        return Mappings.union(in, Mappings.mapping(keysAndValues));
    }

    public static <K, V> Mapping<K, V> override(Mapping<K, V> in, Object ... keysAndValues) {
        return Mappings.union(Mappings.mapping(keysAndValues), in);
    }

    public static <K, V> Mapping<K, V> constant(final V constantValue) {
        return new Mapping<K, V>(){

            @Override
            public boolean containsKey(@Nullable Object key) {
                return true;
            }

            @Override
            @Nullable
            public V get(@Nullable Object key) {
                return constantValue;
            }
        };
    }

    public static <K, V> Predicate<K> containsKeyPredicate(final Mapping<K, V> delegate) {
        return new Predicate<K>(){

            @Override
            public boolean evaluate(K key) {
                return delegate.containsKey(key);
            }
        };
    }

    public static <K, V, EX extends Throwable> PredicateWhichThrows<K, EX> containsKeyPredicateWhichThrows(final Mapping<K, V> delegate) {
        return new PredicateWhichThrows<K, EX>(){

            @Override
            public boolean evaluate(K key) {
                return delegate.containsKey(key);
            }
        };
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        NONE = new Mapping(){

            @Override
            public boolean containsKey(@Nullable Object key) {
                return false;
            }

            @Nullable
            public Object get(@Nullable Object key) {
                return null;
            }

            public String toString() {
                return "(none)";
            }
        };
    }
}

