/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.protocol;

import de.unkrig.commons.lang.protocol.FunctionWhichThrows;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateWhichThrows;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.lang.protocol.TransformerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class ProducerUtil {
    private ProducerUtil() {
    }

    @Deprecated
    public static <T, ST> Producer<T> sparingProducer(final Producer<? extends T> delegate, final Predicate<? super ST> condition, final ST subject) {
        return new Producer<T>(){
            @Nullable
            private T product;

            @Override
            @Nullable
            public T produce() {
                if (condition.evaluate(subject)) {
                    this.product = delegate.produce();
                }
                return this.product;
            }
        };
    }

    public static Producer<Boolean> every(final long interval) {
        return new Producer<Boolean>(){
            private long expirationTime;

            @Override
            @Nullable
            public synchronized Boolean produce() {
                long now = System.currentTimeMillis();
                if (now >= this.expirationTime) {
                    this.expirationTime = now + interval;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> asProducerWhichThrows(Producer<? extends T> source) {
        Producer<? extends T> result = source;
        return result;
    }

    public static <T> Producer<T> asProducer(ProducerWhichThrows<? extends T, ? extends RuntimeException> source) {
        Producer result = (Producer)source;
        return result;
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> one(final T singleProduct) {
        return new ProducerWhichThrows<T, EX>(){
            boolean first = true;

            @Override
            @Nullable
            public T produce() {
                if (this.first) {
                    this.first = false;
                    return singleProduct;
                }
                return null;
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> fromElements(final T ... elements) {
        return new ProducerWhichThrows<T, EX>(){
            int idx;

            @Override
            @Nullable
            public T produce() {
                return this.idx == elements.length ? null : elements[this.idx++];
            }
        };
    }

    @Deprecated
    public static <T> Producer<T> fromCollection(Collection<T> delegate) {
        return ProducerUtil.fromIterator(delegate.iterator(), true);
    }

    @Deprecated
    public static <T> Producer<T> fromIterable(Iterable<T> delegate, boolean remove) {
        return ProducerUtil.fromIterator(delegate.iterator(), remove);
    }

    public static <T> FromArrayProducer<T> fromArray(T[] delegate) {
        return ProducerUtil.fromArray(delegate, 0, delegate.length);
    }

    public static <T> FromArrayProducer<T> fromArray(final T[] delegate, final int from, final int to) {
        if (from < 0 || to < from || to > delegate.length) {
            throw new IllegalArgumentException();
        }
        return new FromArrayProducer<T>(){
            int idx;
            {
                this.idx = from;
            }

            @Override
            @Nullable
            public T produce() {
                return this.idx < to ? delegate[this.idx++] : null;
            }

            @Override
            public int index() {
                return this.idx;
            }
        };
    }

    public static <T> Producer<T> fromIterator(Iterator<T> delegate) {
        return ProducerUtil.fromIterator(delegate, false);
    }

    public static <T> Producer<T> fromIterator(final Iterator<T> delegate, final boolean remove) {
        return new Producer<T>(){

            @Override
            @Nullable
            public T produce() {
                if (!delegate.hasNext()) {
                    return null;
                }
                Object product = delegate.next();
                if (remove) {
                    delegate.remove();
                }
                return product;
            }
        };
    }

    public static <T> Producer<T> fromIndexTransformer(final Transformer<? super Integer, T> indexTransformer) {
        return new Producer<T>(){
            private int index;

            @Override
            @Nullable
            public T produce() {
                return indexTransformer.transform(this.index++);
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> fromIndexTransformer(final TransformerWhichThrows<? super Integer, T, EX> indexTransformer) {
        return new ProducerWhichThrows<T, EX>(){
            private int index;

            @Override
            @Nullable
            public T produce() throws Throwable {
                return indexTransformer.transform(this.index++);
            }
        };
    }

    public static <T1, T2, EX extends Throwable> ProducerWhichThrows<T2, EX> transform(final ProducerWhichThrows<? extends T1, ? extends EX> delegate, final TransformerWhichThrows<? super T1, ? extends T2, EX> transformer) {
        return new ProducerWhichThrows<T2, EX>(){

            @Override
            @Nullable
            public T2 produce() throws Throwable {
                Object product = delegate.produce();
                return product == null ? null : (Object)transformer.transform(product);
            }
        };
    }

    public static <T1, T2, EX extends Throwable> ProducerWhichThrows<T2, EX> transform(final ProducerWhichThrows<? extends T1, ? extends EX> delegate, final FunctionWhichThrows<? super T1, ? extends T2, EX> function) {
        return new ProducerWhichThrows<T2, EX>(){

            @Override
            @Nullable
            public T2 produce() throws Throwable {
                return function.call(delegate.produce());
            }
        };
    }

    public static Producer<Byte> randomByteProducer(final long seed) {
        return new Producer<Byte>(){
            final Random r;
            {
                this.r = new Random(seed);
            }

            @Override
            public Byte produce() {
                return (byte)this.r.nextInt(256);
            }
        };
    }

    public static <T> Producer<T> constantProducer(final T constant) {
        return new Producer<T>(){

            @Override
            public T produce() {
                return constant;
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> filter(final ProducerWhichThrows<? extends T, ? extends EX> delegate, final PredicateWhichThrows<? super T, ? extends EX> predicate) {
        return new ProducerWhichThrows<T, EX>(){

            @Override
            @Nullable
            public T produce() throws Throwable {
                Object product;
                do {
                    if ((product = delegate.produce()) != null) continue;
                    return null;
                } while (!predicate.evaluate(product));
                return product;
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> filter(final ProducerWhichThrows<? extends T, ? extends EX> delegate, final Predicate<? super T> predicate) {
        return new ProducerWhichThrows<T, EX>(){

            @Override
            @Nullable
            public T produce() throws Throwable {
                Object product;
                do {
                    if ((product = delegate.produce()) != null) continue;
                    return null;
                } while (!predicate.evaluate(product));
                return product;
            }
        };
    }

    public static <T> Producer<T> compress(final Producer<? extends T> delegate, final Predicate<? super T> compressable, final T compressed) {
        return new Producer<T>(){
            boolean initial = true;
            @Nullable
            T lookahead;

            @Override
            @Nullable
            public T produce() {
                if (this.initial) {
                    Object product;
                    do {
                        if ((product = delegate.produce()) != null) continue;
                        return null;
                    } while (compressable.evaluate(product));
                    this.initial = false;
                    return product;
                }
                Object tmp = this.lookahead;
                if (tmp != null) {
                    this.lookahead = null;
                    return tmp;
                }
                Object product = delegate.produce();
                if (product == null) {
                    return null;
                }
                if (!compressable.evaluate(product)) {
                    return product;
                }
                do {
                    if ((product = delegate.produce()) != null) continue;
                    return null;
                } while (compressable.evaluate(product));
                this.lookahead = product;
                return compressed;
            }
        };
    }

    public static <T> Producer<T> alternate(final T first, final T second) {
        return new Producer<T>(){
            boolean toggle;

            @Override
            @Nullable
            public T produce() {
                this.toggle = !this.toggle;
                return this.toggle ? first : second;
            }
        };
    }

    public static Producer<Integer> increasing() {
        return ProducerUtil.increasing(0);
    }

    public static Producer<Integer> increasing(final int initialValue) {
        return new Producer<Integer>(){
            int value;
            {
                this.value = initialValue;
            }

            @Override
            @Nullable
            public Integer produce() {
                return this.value++;
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> concat(final ProducerWhichThrows<? extends T, EX> delegate1, final ProducerWhichThrows<? extends T, EX> delegate2) {
        return new ProducerWhichThrows<T, EX>(){
            boolean second;

            @Override
            @Nullable
            public T produce() throws Throwable {
                if (this.second) {
                    return delegate2.produce();
                }
                Object product = delegate1.produce();
                if (product != null) {
                    return product;
                }
                this.second = true;
                return delegate2.produce();
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> concat(T additionalElement, ProducerWhichThrows<? extends T, EX> delegate) {
        return ProducerUtil.concat(ProducerUtil.one(additionalElement), delegate);
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> concat(ProducerWhichThrows<? extends T, EX> delegate, T additionalElement) {
        return ProducerUtil.concat(delegate, ProducerUtil.one(additionalElement));
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> cache(final ProducerWhichThrows<T, ? extends EX> delegate) {
        return new ProducerWhichThrows<T, EX>(){
            @Nullable
            T cache;
            boolean isCached;

            @Override
            @Nullable
            public T produce() throws Throwable {
                if (this.isCached) {
                    return this.cache;
                }
                Object result = delegate.produce();
                this.isCached = true;
                this.cache = result;
                return result;
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> cache(final ProducerWhichThrows<T, ? extends EX> delegate, final ProducerWhichThrows<Boolean, ? extends EX> invalidationCondition) {
        return new ProducerWhichThrows<T, EX>(){
            @Nullable
            T cache;
            boolean isCached;

            @Override
            @Nullable
            public T produce() throws Throwable {
                if (this.isCached && !Boolean.TRUE.equals(invalidationCondition.produce())) {
                    return this.cache;
                }
                Object tmp = delegate.produce();
                this.isCached = true;
                this.cache = tmp;
                return tmp;
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> cache(final @Nullable T firstProduct, final ProducerWhichThrows<T, ? extends EX> delegate, final ProducerWhichThrows<Boolean, ? extends EX> invalidationCondition) {
        return new ProducerWhichThrows<T, EX>(){
            @Nullable
            T cache;
            {
                this.cache = firstProduct;
            }

            @Override
            @Nullable
            public T produce() throws Throwable {
                Boolean b = (Boolean)invalidationCondition.produce();
                if (b != null && b.booleanValue()) {
                    return this.cache;
                }
                this.cache = delegate.produce();
                return this.cache;
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> cacheAsynchronously(final ProducerWhichThrows<Future<T>, ? extends EX> delegate, final ProducerWhichThrows<Boolean, ? extends EX> invalidationCondition, final boolean prefetch) throws EX {
        return new ProducerWhichThrows<T, EX>(){
            @Nullable
            Future<T> previous;
            @Nullable
            Future<T> next;
            {
                this.next = prefetch ? (Future)delegate.produce() : null;
            }

            @Override
            @Nullable
            public synchronized T produce() throws Throwable {
                try {
                    Future p = this.previous;
                    Future n = this.next;
                    if (p == null) {
                        if (n == null) {
                            this.previous = (Future)delegate.produce();
                            return this.previous.get();
                        }
                        this.previous = n;
                        this.next = null;
                        return n.get();
                    }
                    if (n == null) {
                        if (Boolean.TRUE.equals(invalidationCondition.produce())) {
                            n = (Future)delegate.produce();
                            assert (n != null);
                            if (n.isDone()) {
                                this.previous = n;
                                return n.get();
                            }
                            this.next = n;
                        }
                    } else if (n.isDone()) {
                        this.previous = n;
                        this.next = null;
                        return n.get();
                    }
                    return p.get();
                }
                catch (ExecutionException ee) {
                    Throwable cause = ee.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    Throwable ex = cause;
                    throw ex;
                }
                catch (CancellationException ce) {
                    throw new AssertionError((Object)ce);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
        };
    }

    public static Producer<Boolean> atMostEvery(long milliseconds) {
        return ProducerUtil.atMostEvery(milliseconds, true, true);
    }

    public static Producer<Boolean> atMostEvery(final long milliseconds, final boolean firstProduct, final boolean startAtTrueProduct) {
        return new Producer<Boolean>(){
            long next = Long.MIN_VALUE;

            @Override
            @Nullable
            public Boolean produce() {
                long now = System.currentTimeMillis();
                if (now < this.next) {
                    if (this.next == Long.MAX_VALUE) {
                        this.next = now + milliseconds;
                    }
                    return false;
                }
                if (this.next == Long.MIN_VALUE && !firstProduct) {
                    this.next = now + milliseconds;
                    return false;
                }
                this.next = startAtTrueProduct ? now + milliseconds : Long.MAX_VALUE;
                return true;
            }

            @Override
            public String toString() {
                return "At most every " + milliseconds + " ms; next expiration at " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US);
            }
        };
    }

    public static Producer<Boolean> after(final long expirationTime) {
        return new Producer<Boolean>(){

            @Override
            @Nullable
            public Boolean produce() {
                return System.currentTimeMillis() > expirationTime;
            }

            @Override
            public String toString() {
                return "After " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US);
            }
        };
    }

    public static <T, EX extends Throwable> Producer<T> ignoreExceptions(final Class<EX> exceptionClass, final ProducerWhichThrows<T, EX> delegate, final T defaultValue) {
        return new Producer<T>(){

            @Override
            @Nullable
            public T produce() {
                block6: {
                    try {
                        return delegate.produce();
                    }
                    catch (RuntimeException re) {
                        if (!exceptionClass.isAssignableFrom(re.getClass())) {
                            throw re;
                        }
                    }
                    catch (Error e) {
                        if (!exceptionClass.isAssignableFrom(e.getClass())) {
                            throw e;
                        }
                    }
                    catch (Throwable t) {
                        if ($assertionsDisabled || exceptionClass.isAssignableFrom(t.getClass())) break block6;
                        throw new AssertionError();
                    }
                }
                return defaultValue;
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> synchronizedProducer(final ProducerWhichThrows<? extends T, EX> delegate) {
        return new ProducerWhichThrows<T, EX>(){

            @Override
            @Nullable
            public synchronized T produce() throws Throwable {
                return delegate.produce();
            }
        };
    }

    public static Producer<Boolean> oneOutOf(final int n, final int initialFalses) {
        return new Producer<Boolean>(){
            final AtomicInteger counter;
            {
                this.counter = new AtomicInteger(-initialFalses);
            }

            @Override
            @Nullable
            public Boolean produce() {
                return this.getAndIncrement(this.counter, n) == 0;
            }

            private int getAndIncrement(AtomicInteger atomicInteger, int modulo) {
                int next;
                int current;
                do {
                    if ((next = (current = atomicInteger.get()) + 1) < modulo) continue;
                    next %= modulo;
                } while (!atomicInteger.compareAndSet(current, next));
                return current;
            }
        };
    }

    public static <T, EX extends Exception> ProducerWhichThrows<T, EX> roundRobin(final ProducerWhichThrows<? extends T, ? extends EX> ... delegates) {
        return new ProducerWhichThrows<T, EX>(){
            int nextIndex;

            @Override
            @Nullable
            public T produce() throws Exception {
                ProducerWhichThrows p = delegates[this.nextIndex];
                this.nextIndex = (this.nextIndex + 1) % delegates.length;
                return p.produce();
            }
        };
    }

    public static BooleanProducer once() {
        return new BooleanProducer(){
            final AtomicBoolean b = new AtomicBoolean(true);

            @Override
            public boolean produce() {
                return this.b.getAndSet(false);
            }
        };
    }

    public static interface BooleanProducer {
        public boolean produce();
    }

    public static interface FromArrayProducer<T>
    extends Producer<T> {
        public int index();
    }
}

