/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.fs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.fs.DBFFileSystemDescriptor;
import org.jkiss.dbeaver.model.fs.DBFRegistry;
import org.jkiss.dbeaver.registry.fs.FileSystemProviderDescriptor;
import org.jkiss.utils.CommonUtils;

public class FileSystemProviderRegistry
implements DBFRegistry {
    private static FileSystemProviderRegistry instance = null;
    private final List<FileSystemProviderDescriptor> descriptors = new ArrayList<FileSystemProviderDescriptor>();

    public static synchronized FileSystemProviderRegistry getInstance() {
        if (instance == null) {
            instance = new FileSystemProviderRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private FileSystemProviderRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.fileSystem");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            this.descriptors.add(new FileSystemProviderDescriptor(ext));
            ++n2;
        }
    }

    public List<FileSystemProviderDescriptor> getProviders() {
        return this.descriptors;
    }

    public FileSystemProviderDescriptor getProvider(String id) {
        for (FileSystemProviderDescriptor descriptor : this.descriptors) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    public DBFFileSystemDescriptor[] getFileSystemProviders() {
        return this.descriptors.toArray(new DBFFileSystemDescriptor[0]);
    }

    public DBFFileSystemDescriptor getFileSystemProvider(@NotNull String id) {
        return this.descriptors.stream().filter(d -> d.getId().equals(id)).findFirst().orElse(null);
    }

    public DBFFileSystemDescriptor getFileSystemProviderBySchema(@NotNull String schema) {
        return this.descriptors.stream().filter(d -> CommonUtils.equalObjects((Object)d.getSchema(), (Object)schema)).findFirst().orElse(null);
    }
}

