//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// The corner curve to apply to a view.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicornercurve?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UICornerCurve(pub NSInteger);
impl UICornerCurve {
    /// Select the corner style automatically.
    #[doc(alias = "UICornerCurveAutomatic")]
    pub const Automatic: Self = Self(0);
    /// Always use a circular corner style.
    #[doc(alias = "UICornerCurveCircular")]
    pub const Circular: Self = Self(1);
    /// Always use a continuous corner style.
    #[doc(alias = "UICornerCurveContinuous")]
    pub const Continuous: Self = Self(2);
}

unsafe impl Encode for UICornerCurve {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UICornerCurve {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// A type that can provide a custom `UIShape`, resolved dynamically based on
    /// context.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uishapeprovider?language=objc)
    pub unsafe trait UIShapeProvider: NSObjectProtocol {
        /// Resolves this shape in the provided `context`.
        #[unsafe(method(resolvedShapeInContext:))]
        #[unsafe(method_family = none)]
        fn resolvedShapeInContext(
            &self,
            context: &UIShapeResolutionContext,
        ) -> Retained<UIResolvedShape>;
    }
);

extern_class!(
    /// An abstract representation of a shape.
    ///
    /// A `UIShape` can represent a simple shape such as a rectangle or circle that
    /// are later "resolved" into a concrete shape based on context like a size and
    /// position for the shape. A `UIShape` can also represent more complex shapes
    /// like paths and even "dynamic" shapes that are resolved using a custom
    /// closure.
    ///
    /// You typically use a `UIShape` with APIs like `UIHoverStyle` to represent the
    /// shape of an effect.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uishape?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIShape;
);

extern_conformance!(
    unsafe impl NSCopying for UIShape {}
);

unsafe impl CopyingHelper for UIShape {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIShape {}
);

extern_conformance!(
    unsafe impl UIShapeProvider for UIShape {}
);

impl UIShape {
    extern_methods!(
        /// A rectangular shape.
        #[unsafe(method(rectShape))]
        #[unsafe(method_family = none)]
        pub fn rectShape() -> Retained<UIShape>;

        /// A capsule shape, equivalent to a rounded rectangle where the corner
        /// radius is chosen as half the length of the rectangle’s smallest edge.
        #[unsafe(method(capsuleShape))]
        #[unsafe(method_family = none)]
        pub fn capsuleShape() -> Retained<UIShape>;

        /// A circular shape, with a radius equals half the length of the frame
        /// rectangle’s smallest edge.
        #[unsafe(method(circleShape))]
        #[unsafe(method_family = none)]
        pub fn circleShape() -> Retained<UIShape>;

        #[cfg(feature = "objc2-core-foundation")]
        /// A rectangular shape with rounded corners, aligned inside the frame of
        /// in which it is contained.
        #[unsafe(method(rectShapeWithCornerRadius:))]
        #[unsafe(method_family = none)]
        pub fn rectShapeWithCornerRadius(corner_radius: CGFloat) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// A rectangular shape with rounded corners, aligned inside the frame of
        /// in which it is contained.
        #[unsafe(method(rectShapeWithCornerRadius:cornerCurve:))]
        #[unsafe(method_family = none)]
        pub fn rectShapeWithCornerRadius_cornerCurve(
            corner_radius: CGFloat,
            corner_curve: UICornerCurve,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// A rectangular shape with rounded corners, aligned inside the frame of
        /// in which it is contained.
        #[unsafe(method(rectShapeWithCornerRadius:cornerCurve:maskedCorners:))]
        #[unsafe(method_family = none)]
        pub fn rectShapeWithCornerRadius_cornerCurve_maskedCorners(
            corner_radius: CGFloat,
            corner_curve: UICornerCurve,
            masked_corners: UIRectCorner,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// A fixed rectangle shape using `rect` as its shape, regardless of the
        /// frame in which it is contained.
        #[unsafe(method(fixedRectShapeWithRect:))]
        #[unsafe(method_family = none)]
        pub fn fixedRectShapeWithRect(rect: CGRect) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// A fixed rectangle shape using `rect` as its shape, regardless of the
        /// frame in which it is contained, with rounded corners using `cornerRadius`.
        #[unsafe(method(fixedRectShapeWithRect:cornerRadius:))]
        #[unsafe(method_family = none)]
        pub fn fixedRectShapeWithRect_cornerRadius(
            rect: CGRect,
            corner_radius: CGFloat,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// A fixed rectangle shape using `rect` as its shape, regardless of the
        /// frame in which it is contained, with rounded corners using `cornerRadius`.
        #[unsafe(method(fixedRectShapeWithRect:cornerRadius:cornerCurve:maskedCorners:))]
        #[unsafe(method_family = none)]
        pub fn fixedRectShapeWithRect_cornerRadius_cornerCurve_maskedCorners(
            rect: CGRect,
            corner_radius: CGFloat,
            corner_curve: UICornerCurve,
            masked_corners: UIRectCorner,
        ) -> Retained<Self>;

        #[cfg(feature = "UIBezierPath")]
        /// A shape with a custom bezier path.
        #[unsafe(method(shapeWithBezierPath:))]
        #[unsafe(method_family = none)]
        pub fn shapeWithBezierPath(path: &UIBezierPath) -> Retained<Self>;

        /// Creates a dynamic shape that can be resolved using the provided
        /// `UIShapeProvider` based on context like its containing rect.
        #[unsafe(method(shapeWithProvider:))]
        #[unsafe(method_family = none)]
        pub fn shapeWithProvider(provider: &ProtocolObject<dyn UIShapeProvider>) -> Retained<Self>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Insets this shape by the provided `insets`, returning a new modified
        /// shape.
        ///
        /// Negative values can be used to add inner padding to a shape. If this
        /// shape is not insettable (e.g., if it is a custom path), this has no
        /// effect. For some shapes like rounded rectangles, this can also modify
        /// the corner radii of the shape to ensure the resulting corners are
        /// concentric.
        #[unsafe(method(shapeByApplyingInsets:))]
        #[unsafe(method_family = none)]
        pub fn shapeByApplyingInsets(&self, insets: UIEdgeInsets) -> Retained<UIShape>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Insets this shape by the provided `inset`, returning a new modified
        /// shape.
        ///
        /// Negative values can be used to add inner padding to a shape. If this
        /// shape is not insettable (e.g., if it is a custom path), this has no
        /// effect. For some shapes like rounded rectangles, this can also modify
        /// the corner radii of the shape to ensure the resulting corners are
        /// concentric.
        #[unsafe(method(shapeByApplyingInset:))]
        #[unsafe(method_family = none)]
        pub fn shapeByApplyingInset(&self, inset: CGFloat) -> Retained<UIShape>;

        /// Resolves this shape in the provided `context`.
        #[unsafe(method(resolvedShapeInContext:))]
        #[unsafe(method_family = none)]
        pub fn resolvedShapeInContext(
            &self,
            context: &UIShapeResolutionContext,
        ) -> Retained<UIResolvedShape>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// A shape that has been resolved based on a `ResolutionContext`.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiresolvedshape?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIResolvedShape;
);

extern_conformance!(
    unsafe impl NSCopying for UIResolvedShape {}
);

unsafe impl CopyingHelper for UIResolvedShape {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIResolvedShape {}
);

impl UIResolvedShape {
    extern_methods!(
        /// The abstract shape that produced this resolved shape.
        #[unsafe(method(shape))]
        #[unsafe(method_family = none)]
        pub fn shape(&self) -> Retained<UIShape>;

        #[cfg(feature = "objc2-core-foundation")]
        /// The bounding rect in which the shape is framed.
        #[unsafe(method(boundingRect))]
        #[unsafe(method_family = none)]
        pub fn boundingRect(&self) -> CGRect;

        #[cfg(feature = "UIBezierPath")]
        /// The bezier path representing this shape.
        #[unsafe(method(path))]
        #[unsafe(method_family = none)]
        pub fn path(&self) -> Retained<UIBezierPath>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Insets this shape by the provided `insets`, returning a new modified
        /// shape.
        ///
        /// Negative values can be used to add inner padding to a shape. If this
        /// shape is not insettable (e.g., if it is a custom path), this has no
        /// effect. For some shapes like rounded rectangles, this can also modify
        /// the corner radii of the shape to ensure the resulting corners are
        /// concentric.
        #[unsafe(method(shapeByApplyingInsets:))]
        #[unsafe(method_family = none)]
        pub fn shapeByApplyingInsets(&self, insets: UIEdgeInsets) -> Retained<UIResolvedShape>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Insets this shape by the provided `inset`, returning a new modified
        /// shape.
        ///
        /// Negative values can be used to add inner padding to a shape. If this
        /// shape is not insettable (e.g., if it is a custom path), this has no
        /// effect. For some shapes like rounded rectangles, this can also modify
        /// the corner radii of the shape to ensure the resulting corners are
        /// concentric.
        #[unsafe(method(shapeByApplyingInset:))]
        #[unsafe(method_family = none)]
        pub fn shapeByApplyingInset(&self, inset: CGFloat) -> Retained<UIResolvedShape>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// The context used for resolving a `dynamic` `UIShape`.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uishaperesolutioncontext?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIShapeResolutionContext;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIShapeResolutionContext {}
);

impl UIShapeResolutionContext {
    extern_methods!(
        /// The resolved shape of the content to which this shape may be
        /// applied. For example, if this shape will be used to apply an effect
        /// to a button, the `contentShape` could represent the bounding shape
        /// of that button's background. You should typically size a dynamic
        /// shape relative to the bounding `rect` of the `contentShape`.
        #[unsafe(method(contentShape))]
        #[unsafe(method_family = none)]
        pub fn contentShape(&self) -> Retained<UIResolvedShape>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
