// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// Error thrown for access denied scenarios with flexible HTTP status mapping Runtime HTTP Status Code Mapping: - HTTP 401 (Unauthorized): TOKEN_EXPIRED, AUTHCODE_EXPIRED - HTTP 403 (Forbidden): USER_CREDENTIALS_CHANGED, INSUFFICIENT_PERMISSIONS The specific HTTP status code is determined at runtime based on the error enum value. Consumers should use the error field to determine the specific access denial reason.
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct AccessDeniedException {
    /// OAuth 2.0 error code indicating the specific type of access denial Can be TOKEN_EXPIRED, AUTHCODE_EXPIRED, USER_CREDENTIALS_CHANGED, or INSUFFICIENT_PERMISSIONS
    pub error: crate::types::OAuth2ErrorCode,
    /// Detailed message explaining the access denial Provides specific information about why access was denied
    pub message: ::std::string::String,
    pub(crate) meta: ::aws_smithy_types::error::ErrorMetadata,
}
impl AccessDeniedException {
    /// OAuth 2.0 error code indicating the specific type of access denial Can be TOKEN_EXPIRED, AUTHCODE_EXPIRED, USER_CREDENTIALS_CHANGED, or INSUFFICIENT_PERMISSIONS
    pub fn error(&self) -> &crate::types::OAuth2ErrorCode {
        &self.error
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> &str {
        &self.message
    }
}
impl ::std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        ::std::write!(f, "AccessDeniedException")?;
        {
            ::std::write!(f, ": {}", &self.message)?;
        }
        Ok(())
    }
}
impl ::std::error::Error for AccessDeniedException {}
impl ::aws_types::request_id::RequestId for crate::types::error::AccessDeniedException {
    fn request_id(&self) -> Option<&str> {
        use ::aws_smithy_types::error::metadata::ProvideErrorMetadata;
        self.meta().request_id()
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for AccessDeniedException {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        &self.meta
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::types::error::AccessDeniedException).
    pub fn builder() -> crate::types::error::builders::AccessDeniedExceptionBuilder {
        crate::types::error::builders::AccessDeniedExceptionBuilder::default()
    }
}

/// A builder for [`AccessDeniedException`](crate::types::error::AccessDeniedException).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct AccessDeniedExceptionBuilder {
    pub(crate) error: ::std::option::Option<crate::types::OAuth2ErrorCode>,
    pub(crate) message: ::std::option::Option<::std::string::String>,
    meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
}
impl AccessDeniedExceptionBuilder {
    /// OAuth 2.0 error code indicating the specific type of access denial Can be TOKEN_EXPIRED, AUTHCODE_EXPIRED, USER_CREDENTIALS_CHANGED, or INSUFFICIENT_PERMISSIONS
    /// This field is required.
    pub fn error(mut self, input: crate::types::OAuth2ErrorCode) -> Self {
        self.error = ::std::option::Option::Some(input);
        self
    }
    /// OAuth 2.0 error code indicating the specific type of access denial Can be TOKEN_EXPIRED, AUTHCODE_EXPIRED, USER_CREDENTIALS_CHANGED, or INSUFFICIENT_PERMISSIONS
    pub fn set_error(mut self, input: ::std::option::Option<crate::types::OAuth2ErrorCode>) -> Self {
        self.error = input;
        self
    }
    /// OAuth 2.0 error code indicating the specific type of access denial Can be TOKEN_EXPIRED, AUTHCODE_EXPIRED, USER_CREDENTIALS_CHANGED, or INSUFFICIENT_PERMISSIONS
    pub fn get_error(&self) -> &::std::option::Option<crate::types::OAuth2ErrorCode> {
        &self.error
    }
    /// Detailed message explaining the access denial Provides specific information about why access was denied
    /// This field is required.
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.message = ::std::option::Option::Some(input.into());
        self
    }
    /// Detailed message explaining the access denial Provides specific information about why access was denied
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.message = input;
        self
    }
    /// Detailed message explaining the access denial Provides specific information about why access was denied
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.message
    }
    /// Sets error metadata
    pub fn meta(mut self, meta: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        self.meta = Some(meta);
        self
    }

    /// Sets error metadata
    pub fn set_meta(&mut self, meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>) -> &mut Self {
        self.meta = meta;
        self
    }
    /// Consumes the builder and constructs a [`AccessDeniedException`](crate::types::error::AccessDeniedException).
    /// This method will fail if any of the following fields are not set:
    /// - [`error`](crate::types::error::builders::AccessDeniedExceptionBuilder::error)
    /// - [`message`](crate::types::error::builders::AccessDeniedExceptionBuilder::message)
    pub fn build(self) -> ::std::result::Result<crate::types::error::AccessDeniedException, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::error::AccessDeniedException {
            error: self.error.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "error",
                    "error was not specified but it is required when building AccessDeniedException",
                )
            })?,
            message: self.message.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "message",
                    "message was not specified but it is required when building AccessDeniedException",
                )
            })?,
            meta: self.meta.unwrap_or_default(),
        })
    }
}
