// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct MajorMinorVersionMarker {
    if_11_byte_start: Option<usize>,
    if_20_byte_start: Option<usize>,
}

impl MajorMinorVersionMarker {
    pub fn version_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + MajorMinor::RAW_BYTE_LEN
    }

    pub fn always_present_byte_range(&self) -> Range<usize> {
        let start = self.version_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn if_11_byte_range(&self) -> Option<Range<usize>> {
        let start = self.if_11_byte_start?;
        Some(start..start + u16::RAW_BYTE_LEN)
    }

    pub fn if_20_byte_range(&self) -> Option<Range<usize>> {
        let start = self.if_20_byte_start?;
        Some(start..start + u32::RAW_BYTE_LEN)
    }
}

impl<'a> FontRead<'a> for MajorMinorVersion<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        let version: MajorMinor = cursor.read()?;
        cursor.advance::<u16>();
        let if_11_byte_start = version
            .compatible((1u16, 1u16))
            .then(|| cursor.position())
            .transpose()?;
        version
            .compatible((1u16, 1u16))
            .then(|| cursor.advance::<u16>());
        let if_20_byte_start = version
            .compatible((2u16, 0u16))
            .then(|| cursor.position())
            .transpose()?;
        version
            .compatible((2u16, 0u16))
            .then(|| cursor.advance::<u32>());
        cursor.finish(MajorMinorVersionMarker {
            if_11_byte_start,
            if_20_byte_start,
        })
    }
}

pub type MajorMinorVersion<'a> = TableRef<'a, MajorMinorVersionMarker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> MajorMinorVersion<'a> {
    pub fn version(&self) -> MajorMinor {
        let range = self.shape.version_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn always_present(&self) -> u16 {
        let range = self.shape.always_present_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn if_11(&self) -> Option<u16> {
        let range = self.shape.if_11_byte_range()?;
        Some(self.data.read_at(range.start).unwrap())
    }

    pub fn if_20(&self) -> Option<u32> {
        let range = self.shape.if_20_byte_range()?;
        Some(self.data.read_at(range.start).unwrap())
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for MajorMinorVersion<'a> {
    fn type_name(&self) -> &str {
        "MajorMinorVersion"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        let version = self.version();
        match idx {
            0usize => Some(Field::new("version", self.version())),
            1usize => Some(Field::new("always_present", self.always_present())),
            2usize if version.compatible((1u16, 1u16)) => {
                Some(Field::new("if_11", self.if_11().unwrap()))
            }
            3usize if version.compatible((2u16, 0u16)) => {
                Some(Field::new("if_20", self.if_20().unwrap()))
            }
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for MajorMinorVersion<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}

#[derive(Clone, Copy, Default, PartialEq, Eq, PartialOrd, Ord, Hash, bytemuck :: AnyBitPattern)]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
#[repr(transparent)]
pub struct GotFlags {
    bits: u16,
}

impl GotFlags {
    pub const FOO: Self = Self { bits: 0x0001 };

    pub const BAR: Self = Self { bits: 0x0002 };

    pub const BAZ: Self = Self { bits: 0x0004 };
}

impl GotFlags {
    ///  Returns an empty set of flags.
    #[inline]
    pub const fn empty() -> Self {
        Self { bits: 0 }
    }

    /// Returns the set containing all flags.
    #[inline]
    pub const fn all() -> Self {
        Self {
            bits: Self::FOO.bits | Self::BAR.bits | Self::BAZ.bits,
        }
    }

    /// Returns the raw value of the flags currently stored.
    #[inline]
    pub const fn bits(&self) -> u16 {
        self.bits
    }

    /// Convert from underlying bit representation, unless that
    /// representation contains bits that do not correspond to a flag.
    #[inline]
    pub const fn from_bits(bits: u16) -> Option<Self> {
        if (bits & !Self::all().bits()) == 0 {
            Some(Self { bits })
        } else {
            None
        }
    }

    /// Convert from underlying bit representation, dropping any bits
    /// that do not correspond to flags.
    #[inline]
    pub const fn from_bits_truncate(bits: u16) -> Self {
        Self {
            bits: bits & Self::all().bits,
        }
    }

    /// Returns `true` if no flags are currently stored.
    #[inline]
    pub const fn is_empty(&self) -> bool {
        self.bits() == Self::empty().bits()
    }

    /// Returns `true` if there are flags common to both `self` and `other`.
    #[inline]
    pub const fn intersects(&self, other: Self) -> bool {
        !(Self {
            bits: self.bits & other.bits,
        })
        .is_empty()
    }

    /// Returns `true` if all of the flags in `other` are contained within `self`.
    #[inline]
    pub const fn contains(&self, other: Self) -> bool {
        (self.bits & other.bits) == other.bits
    }

    /// Inserts the specified flags in-place.
    #[inline]
    pub fn insert(&mut self, other: Self) {
        self.bits |= other.bits;
    }

    /// Removes the specified flags in-place.
    #[inline]
    pub fn remove(&mut self, other: Self) {
        self.bits &= !other.bits;
    }

    /// Toggles the specified flags in-place.
    #[inline]
    pub fn toggle(&mut self, other: Self) {
        self.bits ^= other.bits;
    }

    /// Returns the intersection between the flags in `self` and
    /// `other`.
    ///
    /// Specifically, the returned set contains only the flags which are
    /// present in *both* `self` *and* `other`.
    ///
    /// This is equivalent to using the `&` operator (e.g.
    /// [`ops::BitAnd`]), as in `flags & other`.
    ///
    /// [`ops::BitAnd`]: https://doc.rust-lang.org/std/ops/trait.BitAnd.html
    #[inline]
    #[must_use]
    pub const fn intersection(self, other: Self) -> Self {
        Self {
            bits: self.bits & other.bits,
        }
    }

    /// Returns the union of between the flags in `self` and `other`.
    ///
    /// Specifically, the returned set contains all flags which are
    /// present in *either* `self` *or* `other`, including any which are
    /// present in both.
    ///
    /// This is equivalent to using the `|` operator (e.g.
    /// [`ops::BitOr`]), as in `flags | other`.
    ///
    /// [`ops::BitOr`]: https://doc.rust-lang.org/std/ops/trait.BitOr.html
    #[inline]
    #[must_use]
    pub const fn union(self, other: Self) -> Self {
        Self {
            bits: self.bits | other.bits,
        }
    }

    /// Returns the difference between the flags in `self` and `other`.
    ///
    /// Specifically, the returned set contains all flags present in
    /// `self`, except for the ones present in `other`.
    ///
    /// It is also conceptually equivalent to the "bit-clear" operation:
    /// `flags & !other` (and this syntax is also supported).
    ///
    /// This is equivalent to using the `-` operator (e.g.
    /// [`ops::Sub`]), as in `flags - other`.
    ///
    /// [`ops::Sub`]: https://doc.rust-lang.org/std/ops/trait.Sub.html
    #[inline]
    #[must_use]
    pub const fn difference(self, other: Self) -> Self {
        Self {
            bits: self.bits & !other.bits,
        }
    }
}

impl std::ops::BitOr for GotFlags {
    type Output = Self;

    /// Returns the union of the two sets of flags.
    #[inline]
    fn bitor(self, other: GotFlags) -> Self {
        Self {
            bits: self.bits | other.bits,
        }
    }
}

impl std::ops::BitOrAssign for GotFlags {
    /// Adds the set of flags.
    #[inline]
    fn bitor_assign(&mut self, other: Self) {
        self.bits |= other.bits;
    }
}

impl std::ops::BitXor for GotFlags {
    type Output = Self;

    /// Returns the left flags, but with all the right flags toggled.
    #[inline]
    fn bitxor(self, other: Self) -> Self {
        Self {
            bits: self.bits ^ other.bits,
        }
    }
}

impl std::ops::BitXorAssign for GotFlags {
    /// Toggles the set of flags.
    #[inline]
    fn bitxor_assign(&mut self, other: Self) {
        self.bits ^= other.bits;
    }
}

impl std::ops::BitAnd for GotFlags {
    type Output = Self;

    /// Returns the intersection between the two sets of flags.
    #[inline]
    fn bitand(self, other: Self) -> Self {
        Self {
            bits: self.bits & other.bits,
        }
    }
}

impl std::ops::BitAndAssign for GotFlags {
    /// Disables all flags disabled in the set.
    #[inline]
    fn bitand_assign(&mut self, other: Self) {
        self.bits &= other.bits;
    }
}

impl std::ops::Sub for GotFlags {
    type Output = Self;

    /// Returns the set difference of the two sets of flags.
    #[inline]
    fn sub(self, other: Self) -> Self {
        Self {
            bits: self.bits & !other.bits,
        }
    }
}

impl std::ops::SubAssign for GotFlags {
    /// Disables all flags enabled in the set.
    #[inline]
    fn sub_assign(&mut self, other: Self) {
        self.bits &= !other.bits;
    }
}

impl std::ops::Not for GotFlags {
    type Output = Self;

    /// Returns the complement of this set of flags.
    #[inline]
    fn not(self) -> Self {
        Self { bits: !self.bits } & Self::all()
    }
}

impl std::fmt::Debug for GotFlags {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        let members: &[(&str, Self)] =
            &[("FOO", Self::FOO), ("BAR", Self::BAR), ("BAZ", Self::BAZ)];
        let mut first = true;
        for (name, value) in members {
            if self.contains(*value) {
                if !first {
                    f.write_str(" | ")?;
                }
                first = false;
                f.write_str(name)?;
            }
        }
        if first {
            f.write_str("(empty)")?;
        }
        Ok(())
    }
}

impl std::fmt::Binary for GotFlags {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        std::fmt::Binary::fmt(&self.bits, f)
    }
}

impl std::fmt::Octal for GotFlags {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        std::fmt::Octal::fmt(&self.bits, f)
    }
}

impl std::fmt::LowerHex for GotFlags {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        std::fmt::LowerHex::fmt(&self.bits, f)
    }
}

impl std::fmt::UpperHex for GotFlags {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        std::fmt::UpperHex::fmt(&self.bits, f)
    }
}

impl font_types::Scalar for GotFlags {
    type Raw = <u16 as font_types::Scalar>::Raw;
    fn to_raw(self) -> Self::Raw {
        self.bits().to_raw()
    }
    fn from_raw(raw: Self::Raw) -> Self {
        let t = <u16>::from_raw(raw);
        Self::from_bits_truncate(t)
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> From<GotFlags> for FieldType<'a> {
    fn from(src: GotFlags) -> FieldType<'a> {
        src.bits().into()
    }
}

#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct FlagDayMarker {
    foo_byte_start: Option<usize>,
    bar_byte_start: Option<usize>,
    baz_byte_start: Option<usize>,
}

impl FlagDayMarker {
    pub fn volume_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn flags_byte_range(&self) -> Range<usize> {
        let start = self.volume_byte_range().end;
        start..start + GotFlags::RAW_BYTE_LEN
    }

    pub fn foo_byte_range(&self) -> Option<Range<usize>> {
        let start = self.foo_byte_start?;
        Some(start..start + u16::RAW_BYTE_LEN)
    }

    pub fn bar_byte_range(&self) -> Option<Range<usize>> {
        let start = self.bar_byte_start?;
        Some(start..start + u16::RAW_BYTE_LEN)
    }

    pub fn baz_byte_range(&self) -> Option<Range<usize>> {
        let start = self.baz_byte_start?;
        Some(start..start + u16::RAW_BYTE_LEN)
    }
}

impl<'a> FontRead<'a> for FlagDay<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<u16>();
        let flags: GotFlags = cursor.read()?;
        let foo_byte_start = flags
            .contains(GotFlags::FOO)
            .then(|| cursor.position())
            .transpose()?;
        flags
            .contains(GotFlags::FOO)
            .then(|| cursor.advance::<u16>());
        let bar_byte_start = flags
            .contains(GotFlags::BAR)
            .then(|| cursor.position())
            .transpose()?;
        flags
            .contains(GotFlags::BAR)
            .then(|| cursor.advance::<u16>());
        let baz_byte_start = flags
            .intersects(GotFlags::BAZ | GotFlags::FOO)
            .then(|| cursor.position())
            .transpose()?;
        flags
            .intersects(GotFlags::BAZ | GotFlags::FOO)
            .then(|| cursor.advance::<u16>());
        cursor.finish(FlagDayMarker {
            foo_byte_start,
            bar_byte_start,
            baz_byte_start,
        })
    }
}

pub type FlagDay<'a> = TableRef<'a, FlagDayMarker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> FlagDay<'a> {
    pub fn volume(&self) -> u16 {
        let range = self.shape.volume_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn flags(&self) -> GotFlags {
        let range = self.shape.flags_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn foo(&self) -> Option<u16> {
        let range = self.shape.foo_byte_range()?;
        Some(self.data.read_at(range.start).unwrap())
    }

    pub fn bar(&self) -> Option<u16> {
        let range = self.shape.bar_byte_range()?;
        Some(self.data.read_at(range.start).unwrap())
    }

    pub fn baz(&self) -> Option<u16> {
        let range = self.shape.baz_byte_range()?;
        Some(self.data.read_at(range.start).unwrap())
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for FlagDay<'a> {
    fn type_name(&self) -> &str {
        "FlagDay"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        let flags = self.flags();
        match idx {
            0usize => Some(Field::new("volume", self.volume())),
            1usize => Some(Field::new("flags", self.flags())),
            2usize if flags.contains(GotFlags::FOO) => Some(Field::new("foo", self.foo().unwrap())),
            3usize if flags.contains(GotFlags::BAR) => Some(Field::new("bar", self.bar().unwrap())),
            4usize if flags.intersects(GotFlags::BAZ | GotFlags::FOO) => {
                Some(Field::new("baz", self.baz().unwrap()))
            }
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for FlagDay<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}

#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct FieldsAfterConditionalsMarker {
    foo_byte_start: Option<usize>,
    bar_byte_start: Option<usize>,
    baz_byte_start: Option<usize>,
}

impl FieldsAfterConditionalsMarker {
    pub fn flags_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + GotFlags::RAW_BYTE_LEN
    }

    pub fn foo_byte_range(&self) -> Option<Range<usize>> {
        let start = self.foo_byte_start?;
        Some(start..start + u16::RAW_BYTE_LEN)
    }

    pub fn always_here_byte_range(&self) -> Range<usize> {
        let start = self
            .foo_byte_range()
            .map(|range| range.end)
            .unwrap_or_else(|| self.flags_byte_range().end);
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn bar_byte_range(&self) -> Option<Range<usize>> {
        let start = self.bar_byte_start?;
        Some(start..start + u16::RAW_BYTE_LEN)
    }

    pub fn baz_byte_range(&self) -> Option<Range<usize>> {
        let start = self.baz_byte_start?;
        Some(start..start + u16::RAW_BYTE_LEN)
    }

    pub fn also_always_here_byte_range(&self) -> Range<usize> {
        let start = self
            .baz_byte_range()
            .map(|range| range.end)
            .unwrap_or_else(|| {
                self.bar_byte_range()
                    .map(|range| range.end)
                    .unwrap_or_else(|| self.always_here_byte_range().end)
            });
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn and_me_too_byte_range(&self) -> Range<usize> {
        let start = self.also_always_here_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }
}

impl<'a> FontRead<'a> for FieldsAfterConditionals<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        let flags: GotFlags = cursor.read()?;
        let foo_byte_start = flags
            .contains(GotFlags::FOO)
            .then(|| cursor.position())
            .transpose()?;
        flags
            .contains(GotFlags::FOO)
            .then(|| cursor.advance::<u16>());
        cursor.advance::<u16>();
        let bar_byte_start = flags
            .contains(GotFlags::BAR)
            .then(|| cursor.position())
            .transpose()?;
        flags
            .contains(GotFlags::BAR)
            .then(|| cursor.advance::<u16>());
        let baz_byte_start = flags
            .contains(GotFlags::BAZ)
            .then(|| cursor.position())
            .transpose()?;
        flags
            .contains(GotFlags::BAZ)
            .then(|| cursor.advance::<u16>());
        cursor.advance::<u16>();
        cursor.advance::<u16>();
        cursor.finish(FieldsAfterConditionalsMarker {
            foo_byte_start,
            bar_byte_start,
            baz_byte_start,
        })
    }
}

pub type FieldsAfterConditionals<'a> = TableRef<'a, FieldsAfterConditionalsMarker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> FieldsAfterConditionals<'a> {
    pub fn flags(&self) -> GotFlags {
        let range = self.shape.flags_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn foo(&self) -> Option<u16> {
        let range = self.shape.foo_byte_range()?;
        Some(self.data.read_at(range.start).unwrap())
    }

    pub fn always_here(&self) -> u16 {
        let range = self.shape.always_here_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn bar(&self) -> Option<u16> {
        let range = self.shape.bar_byte_range()?;
        Some(self.data.read_at(range.start).unwrap())
    }

    pub fn baz(&self) -> Option<u16> {
        let range = self.shape.baz_byte_range()?;
        Some(self.data.read_at(range.start).unwrap())
    }

    pub fn also_always_here(&self) -> u16 {
        let range = self.shape.also_always_here_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn and_me_too(&self) -> u16 {
        let range = self.shape.and_me_too_byte_range();
        self.data.read_at(range.start).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for FieldsAfterConditionals<'a> {
    fn type_name(&self) -> &str {
        "FieldsAfterConditionals"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        let flags = self.flags();
        match idx {
            0usize => Some(Field::new("flags", self.flags())),
            1usize if flags.contains(GotFlags::FOO) => Some(Field::new("foo", self.foo().unwrap())),
            2usize => Some(Field::new("always_here", self.always_here())),
            3usize if flags.contains(GotFlags::BAR) => Some(Field::new("bar", self.bar().unwrap())),
            4usize if flags.contains(GotFlags::BAZ) => Some(Field::new("baz", self.baz().unwrap())),
            5usize => Some(Field::new("also_always_here", self.also_always_here())),
            6usize => Some(Field::new("and_me_too", self.and_me_too())),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for FieldsAfterConditionals<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}
