
# Reference

This pages provide detailed reference documentation for Cantera.

## Programming Reference

These sections document the classes and functions that define the Cantera interface for
each available programming language, as well as the structure of Cantera's YAML
mechanism files.

````{grid} 2
:gutter: 3

```{grid-item-card} Python API Reference
:link: /python/index
:link-type: doc
:text-align: center
```

```{grid-item-card} C++ API Reference
:link: ../cxx/index.html
:text-align: center
```

```{grid-item-card} C API Reference
:link: /clib/index
:link-type: doc
:text-align: center
```

```{grid-item-card} MATLAB Toolbox Reference
:link: /matlab/index
:link-type: doc
:text-align: center
```

```{grid-item-card} .NET API Reference
:link: /dotnet/index
:link-type: doc
:text-align: center
```

```{grid-item-card} YAML Format Reference
:link: /yaml/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Release Notes
:link: releasenotes/index
:link-type: doc
:text-align: center
```

````

```{toctree}
:hidden:
:maxdepth: 1
:caption: API Reference

/python/index
/matlab/index
/clib/index
/dotnet/index
/yaml/index
releasenotes/index
```

## Science Reference

These sections document the scientific theories, mathematical models, and numerical
methods implemented by Cantera. This starts with some of the fundamental scientific
theory underpinning the ways that Cantera models phases of matter, which involves
calculations for thermodynamic and transport properties and chemical reaction rates.
Cantera then builds on top of these models to provide means of representing and solving
a number of zero- and one-dimensional systems.

````{grid} 2
:gutter: 3

```{grid-item-card} Thermodynamics
:link: thermo/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Chemical Reactions
:link: kinetics/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Transport Properties
:link: transport/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Reactors
:link: reactors/index
:link-type: doc
:text-align: center
```

```{grid-item-card} 1D Flames
:link: onedim/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Bibliography
:link: bibliography
:link-type: doc
:text-align: center
```

```{grid-item-card} Glossary
:link: glossary
:link-type: doc
:text-align: center
```

````

```{toctree}
:hidden:
:maxdepth: 1
:caption: Science Reference

thermo/index
kinetics/index
transport/index
reactors/index
onedim/index
bibliography
glossary
```
