# This file is part of Cantera. See License.txt in the top-level directory or
# at https://cantera.org/license.txt for license and copyright information.

from pathlib import Path
from typing import Any, Literal

from .solutionbase import _SolutionBase

class ReactionPathDiagram:
    def __init__(
        self, contents: _SolutionBase, element: str, *args: Any, **kwargs: Any
    ) -> None: ...
    @property
    def show_details(self) -> bool: ...
    @show_details.setter
    def show_details(self, value: bool) -> None: ...
    @property
    def threshold(self) -> float: ...
    @threshold.setter
    def threshold(self, value: float) -> None: ...
    @property
    def bold_threshold(self) -> float: ...
    @bold_threshold.setter
    def bold_threshold(self, value: float) -> None: ...
    @property
    def normal_threshold(self) -> float: ...
    @normal_threshold.setter
    def normal_threshold(self, value: float) -> None: ...
    @property
    def label_threshold(self) -> float: ...
    @label_threshold.setter
    def label_threshold(self, value: float) -> None: ...
    @property
    def bold_color(self) -> str: ...
    @bold_color.setter
    def bold_color(self, value: str) -> None: ...
    @property
    def normal_color(self) -> str: ...
    @normal_color.setter
    def normal_color(self, value: str) -> None: ...
    @property
    def dashed_color(self) -> str: ...
    @dashed_color.setter
    def dashed_color(self, value: str) -> None: ...
    @property
    def dot_options(self) -> str: ...
    @dot_options.setter
    def dot_options(self, value: str) -> None: ...
    @property
    def font(self) -> str: ...
    @font.setter
    def font(self, value: str) -> None: ...
    @property
    def scale(self) -> float: ...
    @scale.setter
    def scale(self, value: float) -> None: ...
    @property
    def flow_type(self) -> Literal["NetFlow", "OneWayFlow"]: ...
    @flow_type.setter
    def flow_type(self, value: Literal["NetFlow", "OneWayFlow"]) -> None: ...
    @property
    def arrow_width(self) -> float: ...
    @arrow_width.setter
    def arrow_width(self, value: float) -> None: ...
    @property
    def title(self) -> str: ...
    @title.setter
    def title(self, value: str) -> None: ...
    def add(self, other: ReactionPathDiagram) -> None: ...
    def display_only(self, k: int) -> None: ...
    def get_dot(self) -> str: ...
    def write_dot(self, filename: Path | str) -> None: ...
    def get_data(self) -> str: ...
    def build(self, verbose: bool = False) -> None: ...
    @property
    def log(self) -> str: ...
