/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.colors;

import org.hsluv.HUSLColorConverter;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.SHA1;

public class ConsistentColor {
    private static final ConsistentColorSettings DEFAULT_SETTINGS = new ConsistentColorSettings();

    private static double createAngle(CharSequence input) {
        byte[] h = SHA1.bytes(input.toString());
        double v = ConsistentColor.u(h[0]) + 256 * ConsistentColor.u(h[1]);
        double d = v / 65536.0;
        return d * 360.0;
    }

    private static double applyColorDeficiencyCorrection(double angle, Deficiency deficiency) {
        switch (deficiency) {
            case none: {
                break;
            }
            case redGreenBlindness: {
                angle += 90.0;
                angle %= 180.0;
                angle += 270.0;
                angle %= 360.0;
                break;
            }
            case blueBlindness: {
                angle %= 180.0;
            }
        }
        return angle;
    }

    private static double[] hsluvToRgb(double hue) {
        return ConsistentColor.hsluvToRgb(hue, 100.0, 50.0);
    }

    private static double[] hsluvToRgb(double hue, double saturation, double lightness) {
        return HUSLColorConverter.hsluvToRgb(new double[]{hue, saturation, lightness});
    }

    private static double[] mixWithBackground(double[] rgbi, float[] rgbb) {
        return new double[]{0.2 * (double)(1.0f - rgbb[0]) + 0.8 * rgbi[0], 0.2 * (double)(1.0f - rgbb[1]) + 0.8 * rgbi[1], 0.2 * (double)(1.0f - rgbb[2]) + 0.8 * rgbi[2]};
    }

    private static int u(byte b) {
        return b & 0xFF;
    }

    public static float[] RGBFrom(CharSequence input) {
        return ConsistentColor.RGBFrom(input, DEFAULT_SETTINGS);
    }

    public static float[] RGBFrom(CharSequence input, ConsistentColorSettings settings) {
        double angle = ConsistentColor.createAngle(input);
        double correctedAngle = ConsistentColor.applyColorDeficiencyCorrection(angle, settings.getDeficiency());
        double[] rgb = ConsistentColor.hsluvToRgb(correctedAngle);
        if (settings.backgroundRGB != null) {
            rgb = ConsistentColor.mixWithBackground(rgb, settings.backgroundRGB);
        }
        return new float[]{(float)rgb[0], (float)rgb[1], (float)rgb[2]};
    }

    public static int[] floatRgbToInts(float[] floats) {
        return new int[]{(int)(floats[0] * 255.0f), (int)(floats[1] * 255.0f), (int)(floats[2] * 255.0f)};
    }

    public static enum Deficiency {
        none,
        redGreenBlindness,
        blueBlindness;

    }

    public static class ConsistentColorSettings {
        private final Deficiency deficiency;
        private final float[] backgroundRGB;

        public ConsistentColorSettings() {
            this.deficiency = Deficiency.none;
            this.backgroundRGB = null;
        }

        public ConsistentColorSettings(Deficiency deficiency) {
            this.deficiency = Objects.requireNonNull(deficiency, "Deficiency must be given");
            this.backgroundRGB = null;
        }

        public ConsistentColorSettings(Deficiency deficiency, float[] backgroundRGB) {
            this.deficiency = Objects.requireNonNull(deficiency, "Deficiency must be given");
            if (backgroundRGB.length != 3) {
                throw new IllegalArgumentException("Background RGB value array must have length 3.");
            }
            for (float f : backgroundRGB) {
                ConsistentColorSettings.checkRange(f, 0.0f, 1.0f);
            }
            this.backgroundRGB = backgroundRGB;
        }

        private static void checkRange(float value, float lower, float upper) {
            if (lower > value || upper < value) {
                throw new IllegalArgumentException("Value out of range.");
            }
        }

        public Deficiency getDeficiency() {
            return this.deficiency;
        }
    }
}

