/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.dox.element;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jxmpp.jid.Jid;
import org.minidns.dnsmessage.DnsMessage;

public class DnsIq
extends IQ {
    public static final String ELEMENT = "dns";
    public static final String NAMESPACE = "urn:xmpp:dox:0";
    private final DnsMessage dnsMessage;
    private String base64DnsMessage;

    public DnsIq(String base64DnsMessage) throws IOException {
        this(Base64.decode(base64DnsMessage));
        this.base64DnsMessage = base64DnsMessage;
    }

    public DnsIq(byte[] dnsMessage) throws IOException {
        this(new DnsMessage(dnsMessage));
    }

    public DnsIq(DnsMessage dnsQuery, Jid to) {
        this(dnsQuery);
        this.setTo(to);
        this.setType(IQ.Type.get);
    }

    public DnsIq(DnsMessage dnsMessage) {
        super(ELEMENT, NAMESPACE);
        this.dnsMessage = dnsMessage;
    }

    public DnsMessage getDnsMessage() {
        return this.dnsMessage;
    }

    public String getDnsMessageBase64Encoded() {
        if (this.base64DnsMessage == null) {
            ByteBuffer byteBuffer = this.dnsMessage.getInByteBuffer();
            byte[] bytes = byteBuffer.array();
            this.base64DnsMessage = Base64.encodeToStringWithoutPadding(bytes);
        }
        return this.base64DnsMessage;
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.rightAngleBracket();
        xml.escape(this.getDnsMessageBase64Encoded());
        return xml;
    }
}

