/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.karaf.bundle.command.BundlesCommand;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.ShellUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

@Command(scope="bundle", name="requirements", description="Displays OSGi requirements of a given bundles.")
@Service
public class Requirements
extends BundlesCommand {
    public static final String NONSTANDARD_SERVICE_NAMESPACE = "service";
    private static final String EMPTY_MESSAGE = "[EMPTY]";
    private static final String UNRESOLVED_MESSAGE = "[UNRESOLVED]";
    @Option(name="--namespace")
    String namespace = "*";

    @Override
    protected void executeOnBundle(Bundle bundle) throws Exception {
    }

    @Override
    protected Object doExecute(List<Bundle> bundles) throws Exception {
        boolean separatorNeeded = false;
        Pattern ns = Pattern.compile(this.namespace.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"));
        for (Bundle b : bundles) {
            BundleWiring wiring;
            if (separatorNeeded) {
                System.out.println();
            }
            if ((wiring = (BundleWiring)b.adapt(BundleWiring.class)) != null) {
                String title = b + " requires:";
                System.out.println(title);
                System.out.println(ShellUtil.getUnderlineString((String)title));
                boolean matches = Requirements.printMatchingRequirements(wiring, ns);
                if (Requirements.matchNamespace(ns, NONSTANDARD_SERVICE_NAMESPACE)) {
                    matches |= Requirements.printServiceRequirements(b);
                }
                if (!matches) {
                    System.out.println(this.namespace + " [EMPTY]");
                }
            } else {
                System.out.println("Bundle " + b.getBundleId() + " is not resolved.");
            }
            separatorNeeded = true;
        }
        return null;
    }

    private static boolean printMatchingRequirements(BundleWiring wiring, Pattern namespace) {
        List wires = wiring.getRequiredWires(null);
        Map<BundleRequirement, List<BundleWire>> aggregateReqs = Requirements.aggregateRequirements(namespace, wires);
        List allReqs = wiring.getRequirements(null);
        boolean matches = false;
        for (BundleRequirement req : allReqs) {
            if (!Requirements.matchNamespace(namespace, req.getNamespace())) continue;
            matches = true;
            List<BundleWire> providers = aggregateReqs.get(req);
            if (providers != null) {
                System.out.println(req.getNamespace() + "; " + (String)req.getDirectives().get("filter") + " resolved by:");
                for (BundleWire wire : providers) {
                    Object keyAttr = wire.getCapability().getAttributes().get(wire.getCapability().getNamespace());
                    Object msg = keyAttr != null ? wire.getCapability().getNamespace() + "; " + keyAttr + " " + Requirements.getVersionFromCapability(wire.getCapability()) : wire.getCapability().toString();
                    msg = "   " + (String)msg + " from " + wire.getProviderWiring().getBundle();
                    System.out.println((String)msg);
                }
                continue;
            }
            System.out.println(req.getNamespace() + "; " + (String)req.getDirectives().get("filter") + " [UNRESOLVED]");
        }
        return matches;
    }

    private static Map<BundleRequirement, List<BundleWire>> aggregateRequirements(Pattern namespace, List<BundleWire> wires) {
        HashMap<BundleRequirement, List<BundleWire>> map = new HashMap<BundleRequirement, List<BundleWire>>();
        for (BundleWire wire : wires) {
            if (!Requirements.matchNamespace(namespace, wire.getRequirement().getNamespace())) continue;
            map.computeIfAbsent(wire.getRequirement(), k -> new ArrayList()).add(wire);
        }
        return map;
    }

    static boolean printServiceRequirements(Bundle b) {
        boolean matches = false;
        try {
            ServiceReference[] refs = b.getServicesInUse();
            if (refs != null && refs.length > 0) {
                matches = true;
                for (ServiceReference ref : refs) {
                    System.out.println("service; " + ShellUtil.getValueString((Object)ref.getProperty("objectClass")) + " provided by:");
                    System.out.println("   " + ref.getBundle());
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
        return matches;
    }

    private static String getVersionFromCapability(BundleCapability c) {
        Object o = c.getAttributes().get("version");
        if (o == null) {
            o = c.getAttributes().get("bundle-version");
        }
        return o == null ? "" : o.toString();
    }

    private static boolean matchNamespace(Pattern namespace, String actual) {
        return namespace.matcher(actual).matches();
    }
}

