/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IMemberProvider;

public class ArtifactKey
implements IArtifactKey,
IMemberProvider {
    private static final String SEPARATOR = ",";
    public static final String MEMBER_ID = "id";
    public static final String MEMBER_CLASSIFIER = "classifier";
    public static final String MEMBER_VERSION = "version";
    private final String id;
    private final String classifier;
    private final Version version;

    public static IArtifactKey parse(String specification) {
        String[] parts = specification.split(SEPARATOR, -1);
        if (parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("Unexpected number of parts in artifact key: " + specification);
        }
        Version version = Version.emptyVersion;
        if (parts.length == 3 && !parts[2].isBlank()) {
            version = Version.parseVersion(parts[2]);
        }
        try {
            return new ArtifactKey(parts[0], parts[1], version);
        }
        catch (IllegalArgumentException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Wrong version syntax in artifact key: " + specification).initCause(e);
        }
    }

    public ArtifactKey(String classifier, String id, Version version) {
        Assert.isNotNull((Object)classifier);
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)version);
        if (classifier.contains(SEPARATOR)) {
            throw new IllegalArgumentException("comma not allowed in classifier");
        }
        if (id.contains(SEPARATOR)) {
            throw new IllegalArgumentException("comma not allowed in id");
        }
        this.classifier = classifier;
        this.id = id;
        this.version = version;
    }

    public ArtifactKey(IArtifactKey artifactKey) {
        this.classifier = artifactKey.getClassifier();
        this.id = artifactKey.getId();
        this.version = artifactKey.getVersion();
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.getVersion(), this.classifier);
    }

    public String toString() {
        return this.classifier + SEPARATOR + this.id + SEPARATOR + String.valueOf(this.getVersion());
    }

    public boolean equals(Object obj) {
        IArtifactKey ak;
        if (this == obj) {
            return true;
        }
        return obj instanceof IArtifactKey && (ak = (IArtifactKey)obj).getId().equals(this.id) && ak.getVersion().equals(this.getVersion()) && ak.getClassifier().equals(this.classifier);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String toExternalForm() {
        return String.join((CharSequence)SEPARATOR, this.classifier, this.id, this.version.toString());
    }

    @Override
    public Object getMember(String memberName) {
        return switch (memberName) {
            case MEMBER_ID -> this.id;
            case MEMBER_VERSION -> this.version;
            case MEMBER_CLASSIFIER -> this.classifier;
            default -> throw new IllegalArgumentException("No such member: " + memberName);
        };
    }
}

