// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::put_bucket_acl::_put_bucket_acl_output::PutBucketAclOutputBuilder;

pub use crate::operation::put_bucket_acl::_put_bucket_acl_input::PutBucketAclInputBuilder;

impl crate::operation::put_bucket_acl::builders::PutBucketAclInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::put_bucket_acl::PutBucketAclOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_acl::PutBucketAclError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.put_bucket_acl();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `PutBucketAcl`.
///
/// <important>
/// <p>End of support notice: Beginning October 1, 2025, Amazon S3 will discontinue support for creating new Email Grantee Access Control Lists (ACL). Email Grantee ACLs created prior to this date will continue to work and remain accessible through the Amazon Web Services Management Console, Command Line Interface (CLI), SDKs, and REST API. However, you will no longer be able to create new Email Grantee ACLs.</p>
/// <p>This change affects the following Amazon Web Services Regions: US East (N. Virginia) Region, US West (N. California) Region, US West (Oregon) Region, Asia Pacific (Singapore) Region, Asia Pacific (Sydney) Region, Asia Pacific (Tokyo) Region, Europe (Ireland) Region, and South America (São Paulo) Region.</p>
/// </important> <note>
/// <p>This operation is not supported for directory buckets.</p>
/// </note>
/// <p>Sets the permissions on an existing bucket using access control lists (ACL). For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. To set the ACL of a bucket, you must have the <code>WRITE_ACP</code> permission.</p>
/// <p>You can use one of the following two ways to set a bucket's permissions:</p>
/// <ul>
/// <li>
/// <p>Specify the ACL in the request body</p></li>
/// <li>
/// <p>Specify permissions using request headers</p></li>
/// </ul><note>
/// <p>You cannot specify access permission using both the body and the request headers.</p>
/// </note>
/// <p>Depending on your application needs, you may choose to set the ACL on a bucket using either the request body or the headers. For example, if you have an existing application that updates a bucket ACL using the request body, then you can continue to use that approach.</p><important>
/// <p>If your bucket uses the bucket owner enforced setting for S3 Object Ownership, ACLs are disabled and no longer affect permissions. You must use policies to grant access to your bucket and the objects in it. Requests to set ACLs or update ACLs fail and return the <code>AccessControlListNotSupported</code> error code. Requests to read ACLs are still supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling object ownership</a> in the <i>Amazon S3 User Guide</i>.</p>
/// </important>
/// <dl>
/// <dt>
/// Permissions
/// </dt>
/// <dd>
/// <p>You can set access permissions by using one of the following methods:</p>
/// <ul>
/// <li>
/// <p>Specify a canned ACL with the <code>x-amz-acl</code> request header. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. Specify the canned ACL name as the value of <code>x-amz-acl</code>. If you use this header, you cannot use other access control-specific headers in your request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p></li>
/// <li>
/// <p>Specify access permissions explicitly with the <code>x-amz-grant-read</code>, <code>x-amz-grant-read-acp</code>, <code>x-amz-grant-write-acp</code>, and <code>x-amz-grant-full-control</code> headers. When using these headers, you specify explicit access permissions and grantees (Amazon Web Services accounts or Amazon S3 groups) who will receive the permission. If you use these ACL-specific headers, you cannot use the <code>x-amz-acl</code> header to set a canned ACL. These parameters map to the set of permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a>.</p>
/// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
/// <ul>
/// <li>
/// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
/// <li>
/// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
/// <li>
/// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
/// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
/// <ul>
/// <li>
/// <p>US East (N. Virginia)</p></li>
/// <li>
/// <p>US West (N. California)</p></li>
/// <li>
/// <p>US West (Oregon)</p></li>
/// <li>
/// <p>Asia Pacific (Singapore)</p></li>
/// <li>
/// <p>Asia Pacific (Sydney)</p></li>
/// <li>
/// <p>Asia Pacific (Tokyo)</p></li>
/// <li>
/// <p>Europe (Ireland)</p></li>
/// <li>
/// <p>South America (São Paulo)</p></li>
/// </ul>
/// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
/// </note></li>
/// </ul>
/// <p>For example, the following <code>x-amz-grant-write</code> header grants create, overwrite, and delete objects permission to LogDelivery group predefined by Amazon S3 and two Amazon Web Services accounts identified by their email addresses.</p>
/// <p><code>x-amz-grant-write: uri="http://acs.amazonaws.com/groups/s3/LogDelivery", id="111122223333", id="555566667777" </code></p></li>
/// </ul>
/// <p>You can use either a canned ACL or specify access permissions explicitly. You cannot do both.</p>
/// </dd>
/// <dt>
/// Grantee Values
/// </dt>
/// <dd>
/// <p>You can specify the person (grantee) to whom you're assigning access rights (using request elements) in the following ways. For examples of how to specify these grantee values in JSON format, see the Amazon Web Services CLI example in <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html"> Enabling Amazon S3 server access logging</a> in the <i>Amazon S3 User Guide</i>.</p>
/// <ul>
/// <li>
/// <p>By the person's ID:</p>
/// <p><code><grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="CanonicalUser">
/// <id>
/// &lt;&gt;ID&lt;&gt;
/// </id>
/// <displayname>
/// &lt;&gt;GranteesEmail&lt;&gt;
/// </displayname>
/// </grantee></code></p>
/// <p>DisplayName is optional and ignored in the request</p></li>
/// <li>
/// <p>By URI:</p>
/// <p><code><grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="Group">
/// <uri>
/// &lt;&gt;http://acs.amazonaws.com/groups/global/AuthenticatedUsers&lt;&gt;
/// </uri>
/// </grantee></code></p></li>
/// <li>
/// <p>By Email address:</p>
/// <p><code><grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="AmazonCustomerByEmail">
/// <emailaddress>
/// &lt;&gt;Grantees@email.com&lt;&gt;
/// </emailaddress>&amp;
/// </grantee></code></p>
/// <p>The grantee is resolved to the CanonicalUser and, in a response to a GET Object acl request, appears as the CanonicalUser.</p><note>
/// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
/// <ul>
/// <li>
/// <p>US East (N. Virginia)</p></li>
/// <li>
/// <p>US West (N. California)</p></li>
/// <li>
/// <p>US West (Oregon)</p></li>
/// <li>
/// <p>Asia Pacific (Singapore)</p></li>
/// <li>
/// <p>Asia Pacific (Sydney)</p></li>
/// <li>
/// <p>Asia Pacific (Tokyo)</p></li>
/// <li>
/// <p>Europe (Ireland)</p></li>
/// <li>
/// <p>South America (São Paulo)</p></li>
/// </ul>
/// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
/// </note></li>
/// </ul>
/// </dd>
/// </dl>
/// <p>The following operations are related to <code>PutBucketAcl</code>:</p>
/// <ul>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a></p></li>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a></p></li>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a></p></li>
/// </ul>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct PutBucketAclFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::put_bucket_acl::builders::PutBucketAclInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::put_bucket_acl::PutBucketAclOutput,
        crate::operation::put_bucket_acl::PutBucketAclError,
    > for PutBucketAclFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::put_bucket_acl::PutBucketAclOutput,
            crate::operation::put_bucket_acl::PutBucketAclError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl PutBucketAclFluentBuilder {
    /// Creates a new `PutBucketAclFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the PutBucketAcl as a reference.
    pub fn as_input(&self) -> &crate::operation::put_bucket_acl::builders::PutBucketAclInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::put_bucket_acl::PutBucketAclOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_acl::PutBucketAclError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::put_bucket_acl::PutBucketAcl::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::put_bucket_acl::PutBucketAcl::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::put_bucket_acl::PutBucketAclOutput,
        crate::operation::put_bucket_acl::PutBucketAclError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The canned ACL to apply to the bucket.</p>
    pub fn acl(mut self, input: crate::types::BucketCannedAcl) -> Self {
        self.inner = self.inner.acl(input);
        self
    }
    /// <p>The canned ACL to apply to the bucket.</p>
    pub fn set_acl(mut self, input: ::std::option::Option<crate::types::BucketCannedAcl>) -> Self {
        self.inner = self.inner.set_acl(input);
        self
    }
    /// <p>The canned ACL to apply to the bucket.</p>
    pub fn get_acl(&self) -> &::std::option::Option<crate::types::BucketCannedAcl> {
        self.inner.get_acl()
    }
    /// <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
    pub fn access_control_policy(mut self, input: crate::types::AccessControlPolicy) -> Self {
        self.inner = self.inner.access_control_policy(input);
        self
    }
    /// <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
    pub fn set_access_control_policy(mut self, input: ::std::option::Option<crate::types::AccessControlPolicy>) -> Self {
        self.inner = self.inner.set_access_control_policy(input);
        self
    }
    /// <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
    pub fn get_access_control_policy(&self) -> &::std::option::Option<crate::types::AccessControlPolicy> {
        self.inner.get_access_control_policy()
    }
    /// <p>The bucket to which to apply the ACL.</p>
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.bucket(input.into());
        self
    }
    /// <p>The bucket to which to apply the ACL.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_bucket(input);
        self
    }
    /// <p>The bucket to which to apply the ACL.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_bucket()
    }
    /// <p>The Base64 encoded 128-bit <code>MD5</code> digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a></p>
    /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    pub fn content_md5(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content_md5(input.into());
        self
    }
    /// <p>The Base64 encoded 128-bit <code>MD5</code> digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a></p>
    /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    pub fn set_content_md5(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content_md5(input);
        self
    }
    /// <p>The Base64 encoded 128-bit <code>MD5</code> digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a></p>
    /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    pub fn get_content_md5(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content_md5()
    }
    /// <p>Indicates the algorithm used to create the checksum for the request when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding <code>x-amz-checksum</code> or <code>x-amz-trailer</code> header sent. Otherwise, Amazon S3 fails the request with the HTTP status code <code>400 Bad Request</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>If you provide an individual checksum, Amazon S3 ignores any provided <code>ChecksumAlgorithm</code> parameter.</p>
    pub fn checksum_algorithm(mut self, input: crate::types::ChecksumAlgorithm) -> Self {
        self.inner = self.inner.checksum_algorithm(input);
        self
    }
    /// <p>Indicates the algorithm used to create the checksum for the request when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding <code>x-amz-checksum</code> or <code>x-amz-trailer</code> header sent. Otherwise, Amazon S3 fails the request with the HTTP status code <code>400 Bad Request</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>If you provide an individual checksum, Amazon S3 ignores any provided <code>ChecksumAlgorithm</code> parameter.</p>
    pub fn set_checksum_algorithm(mut self, input: ::std::option::Option<crate::types::ChecksumAlgorithm>) -> Self {
        self.inner = self.inner.set_checksum_algorithm(input);
        self
    }
    /// <p>Indicates the algorithm used to create the checksum for the request when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding <code>x-amz-checksum</code> or <code>x-amz-trailer</code> header sent. Otherwise, Amazon S3 fails the request with the HTTP status code <code>400 Bad Request</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>If you provide an individual checksum, Amazon S3 ignores any provided <code>ChecksumAlgorithm</code> parameter.</p>
    pub fn get_checksum_algorithm(&self) -> &::std::option::Option<crate::types::ChecksumAlgorithm> {
        self.inner.get_checksum_algorithm()
    }
    /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
    pub fn grant_full_control(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.grant_full_control(input.into());
        self
    }
    /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
    pub fn set_grant_full_control(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_grant_full_control(input);
        self
    }
    /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
    pub fn get_grant_full_control(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_grant_full_control()
    }
    /// <p>Allows grantee to list the objects in the bucket.</p>
    pub fn grant_read(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.grant_read(input.into());
        self
    }
    /// <p>Allows grantee to list the objects in the bucket.</p>
    pub fn set_grant_read(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_grant_read(input);
        self
    }
    /// <p>Allows grantee to list the objects in the bucket.</p>
    pub fn get_grant_read(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_grant_read()
    }
    /// <p>Allows grantee to read the bucket ACL.</p>
    pub fn grant_read_acp(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.grant_read_acp(input.into());
        self
    }
    /// <p>Allows grantee to read the bucket ACL.</p>
    pub fn set_grant_read_acp(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_grant_read_acp(input);
        self
    }
    /// <p>Allows grantee to read the bucket ACL.</p>
    pub fn get_grant_read_acp(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_grant_read_acp()
    }
    /// <p>Allows grantee to create new objects in the bucket.</p>
    /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
    pub fn grant_write(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.grant_write(input.into());
        self
    }
    /// <p>Allows grantee to create new objects in the bucket.</p>
    /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
    pub fn set_grant_write(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_grant_write(input);
        self
    }
    /// <p>Allows grantee to create new objects in the bucket.</p>
    /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
    pub fn get_grant_write(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_grant_write()
    }
    /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
    pub fn grant_write_acp(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.grant_write_acp(input.into());
        self
    }
    /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
    pub fn set_grant_write_acp(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_grant_write_acp(input);
        self
    }
    /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
    pub fn get_grant_write_acp(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_grant_write_acp()
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn expected_bucket_owner(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.expected_bucket_owner(input.into());
        self
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn set_expected_bucket_owner(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_expected_bucket_owner(input);
        self
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn get_expected_bucket_owner(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_expected_bucket_owner()
    }
}
