package azurestackhci

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeInternal ...
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeInternal}
}

// ArcSettingAggregateState enumerates the values for arc setting aggregate state.
type ArcSettingAggregateState string

const (
	// ArcSettingAggregateStateCanceled ...
	ArcSettingAggregateStateCanceled ArcSettingAggregateState = "Canceled"
	// ArcSettingAggregateStateConnected ...
	ArcSettingAggregateStateConnected ArcSettingAggregateState = "Connected"
	// ArcSettingAggregateStateCreating ...
	ArcSettingAggregateStateCreating ArcSettingAggregateState = "Creating"
	// ArcSettingAggregateStateDeleted ...
	ArcSettingAggregateStateDeleted ArcSettingAggregateState = "Deleted"
	// ArcSettingAggregateStateDeleting ...
	ArcSettingAggregateStateDeleting ArcSettingAggregateState = "Deleting"
	// ArcSettingAggregateStateDisconnected ...
	ArcSettingAggregateStateDisconnected ArcSettingAggregateState = "Disconnected"
	// ArcSettingAggregateStateError ...
	ArcSettingAggregateStateError ArcSettingAggregateState = "Error"
	// ArcSettingAggregateStateFailed ...
	ArcSettingAggregateStateFailed ArcSettingAggregateState = "Failed"
	// ArcSettingAggregateStateInProgress ...
	ArcSettingAggregateStateInProgress ArcSettingAggregateState = "InProgress"
	// ArcSettingAggregateStateMoving ...
	ArcSettingAggregateStateMoving ArcSettingAggregateState = "Moving"
	// ArcSettingAggregateStateNotSpecified ...
	ArcSettingAggregateStateNotSpecified ArcSettingAggregateState = "NotSpecified"
	// ArcSettingAggregateStatePartiallyConnected ...
	ArcSettingAggregateStatePartiallyConnected ArcSettingAggregateState = "PartiallyConnected"
	// ArcSettingAggregateStatePartiallySucceeded ...
	ArcSettingAggregateStatePartiallySucceeded ArcSettingAggregateState = "PartiallySucceeded"
	// ArcSettingAggregateStateSucceeded ...
	ArcSettingAggregateStateSucceeded ArcSettingAggregateState = "Succeeded"
	// ArcSettingAggregateStateUpdating ...
	ArcSettingAggregateStateUpdating ArcSettingAggregateState = "Updating"
)

// PossibleArcSettingAggregateStateValues returns an array of possible values for the ArcSettingAggregateState const type.
func PossibleArcSettingAggregateStateValues() []ArcSettingAggregateState {
	return []ArcSettingAggregateState{ArcSettingAggregateStateCanceled, ArcSettingAggregateStateConnected, ArcSettingAggregateStateCreating, ArcSettingAggregateStateDeleted, ArcSettingAggregateStateDeleting, ArcSettingAggregateStateDisconnected, ArcSettingAggregateStateError, ArcSettingAggregateStateFailed, ArcSettingAggregateStateInProgress, ArcSettingAggregateStateMoving, ArcSettingAggregateStateNotSpecified, ArcSettingAggregateStatePartiallyConnected, ArcSettingAggregateStatePartiallySucceeded, ArcSettingAggregateStateSucceeded, ArcSettingAggregateStateUpdating}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// ExtensionAggregateState enumerates the values for extension aggregate state.
type ExtensionAggregateState string

const (
	// ExtensionAggregateStateCanceled ...
	ExtensionAggregateStateCanceled ExtensionAggregateState = "Canceled"
	// ExtensionAggregateStateConnected ...
	ExtensionAggregateStateConnected ExtensionAggregateState = "Connected"
	// ExtensionAggregateStateCreating ...
	ExtensionAggregateStateCreating ExtensionAggregateState = "Creating"
	// ExtensionAggregateStateDeleted ...
	ExtensionAggregateStateDeleted ExtensionAggregateState = "Deleted"
	// ExtensionAggregateStateDeleting ...
	ExtensionAggregateStateDeleting ExtensionAggregateState = "Deleting"
	// ExtensionAggregateStateDisconnected ...
	ExtensionAggregateStateDisconnected ExtensionAggregateState = "Disconnected"
	// ExtensionAggregateStateError ...
	ExtensionAggregateStateError ExtensionAggregateState = "Error"
	// ExtensionAggregateStateFailed ...
	ExtensionAggregateStateFailed ExtensionAggregateState = "Failed"
	// ExtensionAggregateStateInProgress ...
	ExtensionAggregateStateInProgress ExtensionAggregateState = "InProgress"
	// ExtensionAggregateStateMoving ...
	ExtensionAggregateStateMoving ExtensionAggregateState = "Moving"
	// ExtensionAggregateStateNotSpecified ...
	ExtensionAggregateStateNotSpecified ExtensionAggregateState = "NotSpecified"
	// ExtensionAggregateStatePartiallyConnected ...
	ExtensionAggregateStatePartiallyConnected ExtensionAggregateState = "PartiallyConnected"
	// ExtensionAggregateStatePartiallySucceeded ...
	ExtensionAggregateStatePartiallySucceeded ExtensionAggregateState = "PartiallySucceeded"
	// ExtensionAggregateStateSucceeded ...
	ExtensionAggregateStateSucceeded ExtensionAggregateState = "Succeeded"
	// ExtensionAggregateStateUpdating ...
	ExtensionAggregateStateUpdating ExtensionAggregateState = "Updating"
)

// PossibleExtensionAggregateStateValues returns an array of possible values for the ExtensionAggregateState const type.
func PossibleExtensionAggregateStateValues() []ExtensionAggregateState {
	return []ExtensionAggregateState{ExtensionAggregateStateCanceled, ExtensionAggregateStateConnected, ExtensionAggregateStateCreating, ExtensionAggregateStateDeleted, ExtensionAggregateStateDeleting, ExtensionAggregateStateDisconnected, ExtensionAggregateStateError, ExtensionAggregateStateFailed, ExtensionAggregateStateInProgress, ExtensionAggregateStateMoving, ExtensionAggregateStateNotSpecified, ExtensionAggregateStatePartiallyConnected, ExtensionAggregateStatePartiallySucceeded, ExtensionAggregateStateSucceeded, ExtensionAggregateStateUpdating}
}

// NodeArcState enumerates the values for node arc state.
type NodeArcState string

const (
	// NodeArcStateCanceled ...
	NodeArcStateCanceled NodeArcState = "Canceled"
	// NodeArcStateConnected ...
	NodeArcStateConnected NodeArcState = "Connected"
	// NodeArcStateCreating ...
	NodeArcStateCreating NodeArcState = "Creating"
	// NodeArcStateDeleted ...
	NodeArcStateDeleted NodeArcState = "Deleted"
	// NodeArcStateDeleting ...
	NodeArcStateDeleting NodeArcState = "Deleting"
	// NodeArcStateDisconnected ...
	NodeArcStateDisconnected NodeArcState = "Disconnected"
	// NodeArcStateError ...
	NodeArcStateError NodeArcState = "Error"
	// NodeArcStateFailed ...
	NodeArcStateFailed NodeArcState = "Failed"
	// NodeArcStateMoving ...
	NodeArcStateMoving NodeArcState = "Moving"
	// NodeArcStateNotSpecified ...
	NodeArcStateNotSpecified NodeArcState = "NotSpecified"
	// NodeArcStateSucceeded ...
	NodeArcStateSucceeded NodeArcState = "Succeeded"
	// NodeArcStateUpdating ...
	NodeArcStateUpdating NodeArcState = "Updating"
)

// PossibleNodeArcStateValues returns an array of possible values for the NodeArcState const type.
func PossibleNodeArcStateValues() []NodeArcState {
	return []NodeArcState{NodeArcStateCanceled, NodeArcStateConnected, NodeArcStateCreating, NodeArcStateDeleted, NodeArcStateDeleting, NodeArcStateDisconnected, NodeArcStateError, NodeArcStateFailed, NodeArcStateMoving, NodeArcStateNotSpecified, NodeArcStateSucceeded, NodeArcStateUpdating}
}

// NodeExtensionState enumerates the values for node extension state.
type NodeExtensionState string

const (
	// NodeExtensionStateCanceled ...
	NodeExtensionStateCanceled NodeExtensionState = "Canceled"
	// NodeExtensionStateConnected ...
	NodeExtensionStateConnected NodeExtensionState = "Connected"
	// NodeExtensionStateCreating ...
	NodeExtensionStateCreating NodeExtensionState = "Creating"
	// NodeExtensionStateDeleted ...
	NodeExtensionStateDeleted NodeExtensionState = "Deleted"
	// NodeExtensionStateDeleting ...
	NodeExtensionStateDeleting NodeExtensionState = "Deleting"
	// NodeExtensionStateDisconnected ...
	NodeExtensionStateDisconnected NodeExtensionState = "Disconnected"
	// NodeExtensionStateError ...
	NodeExtensionStateError NodeExtensionState = "Error"
	// NodeExtensionStateFailed ...
	NodeExtensionStateFailed NodeExtensionState = "Failed"
	// NodeExtensionStateMoving ...
	NodeExtensionStateMoving NodeExtensionState = "Moving"
	// NodeExtensionStateNotSpecified ...
	NodeExtensionStateNotSpecified NodeExtensionState = "NotSpecified"
	// NodeExtensionStateSucceeded ...
	NodeExtensionStateSucceeded NodeExtensionState = "Succeeded"
	// NodeExtensionStateUpdating ...
	NodeExtensionStateUpdating NodeExtensionState = "Updating"
)

// PossibleNodeExtensionStateValues returns an array of possible values for the NodeExtensionState const type.
func PossibleNodeExtensionStateValues() []NodeExtensionState {
	return []NodeExtensionState{NodeExtensionStateCanceled, NodeExtensionStateConnected, NodeExtensionStateCreating, NodeExtensionStateDeleted, NodeExtensionStateDeleting, NodeExtensionStateDisconnected, NodeExtensionStateError, NodeExtensionStateFailed, NodeExtensionStateMoving, NodeExtensionStateNotSpecified, NodeExtensionStateSucceeded, NodeExtensionStateUpdating}
}

// Origin enumerates the values for origin.
type Origin string

const (
	// OriginSystem ...
	OriginSystem Origin = "system"
	// OriginUser ...
	OriginUser Origin = "user"
	// OriginUsersystem ...
	OriginUsersystem Origin = "user,system"
)

// PossibleOriginValues returns an array of possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{OriginSystem, OriginUser, OriginUsersystem}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateAccepted ...
	ProvisioningStateAccepted ProvisioningState = "Accepted"
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateProvisioning ...
	ProvisioningStateProvisioning ProvisioningState = "Provisioning"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateAccepted, ProvisioningStateCanceled, ProvisioningStateFailed, ProvisioningStateProvisioning, ProvisioningStateSucceeded}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusConnectedRecently ...
	StatusConnectedRecently Status = "ConnectedRecently"
	// StatusDisconnected ...
	StatusDisconnected Status = "Disconnected"
	// StatusError ...
	StatusError Status = "Error"
	// StatusNotConnectedRecently ...
	StatusNotConnectedRecently Status = "NotConnectedRecently"
	// StatusNotYetRegistered ...
	StatusNotYetRegistered Status = "NotYetRegistered"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusConnectedRecently, StatusDisconnected, StatusError, StatusNotConnectedRecently, StatusNotYetRegistered}
}
