package ccs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryHotlineRecord invokes the ccs.QueryHotlineRecord API synchronously
// api document: https://help.aliyun.com/api/ccs/queryhotlinerecord.html
func (client *Client) QueryHotlineRecord(request *QueryHotlineRecordRequest) (response *QueryHotlineRecordResponse, err error) {
	response = CreateQueryHotlineRecordResponse()
	err = client.DoAction(request, response)
	return
}

// QueryHotlineRecordWithChan invokes the ccs.QueryHotlineRecord API asynchronously
// api document: https://help.aliyun.com/api/ccs/queryhotlinerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryHotlineRecordWithChan(request *QueryHotlineRecordRequest) (<-chan *QueryHotlineRecordResponse, <-chan error) {
	responseChan := make(chan *QueryHotlineRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryHotlineRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryHotlineRecordWithCallback invokes the ccs.QueryHotlineRecord API asynchronously
// api document: https://help.aliyun.com/api/ccs/queryhotlinerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryHotlineRecordWithCallback(request *QueryHotlineRecordRequest, callback func(response *QueryHotlineRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryHotlineRecordResponse
		var err error
		defer close(result)
		response, err = client.QueryHotlineRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryHotlineRecordRequest is the request struct for api QueryHotlineRecord
type QueryHotlineRecordRequest struct {
	*requests.RpcRequest
	AgentId         string           `position:"Query" name:"AgentId"`
	MaxTalkDuration requests.Integer `position:"Query" name:"MaxTalkDuration"`
	GroupId         string           `position:"Query" name:"GroupId"`
	EndTime         string           `position:"Query" name:"EndTime"`
	StartTime       string           `position:"Query" name:"StartTime"`
	PageNum         requests.Integer `position:"Query" name:"PageNum"`
	Satisfaction    string           `position:"Query" name:"Satisfaction"`
	MinTalkDuratoin requests.Integer `position:"Query" name:"MinTalkDuratoin"`
	CategoryIds     string           `position:"Query" name:"CategoryIds"`
	VisitorProvince string           `position:"Query" name:"VisitorProvince"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	CallType        string           `position:"Query" name:"CallType"`
	CcsInstanceId   string           `position:"Query" name:"CcsInstanceId"`
	VisitorPhone    string           `position:"Query" name:"VisitorPhone"`
	VisitorId       string           `position:"Query" name:"VisitorId"`
	Status          string           `position:"Query" name:"Status"`
}

// QueryHotlineRecordResponse is the response struct for api QueryHotlineRecord
type QueryHotlineRecordResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	TotalCount int     `json:"TotalCount" xml:"TotalCount"`
	PageNum    int     `json:"PageNum" xml:"PageNum"`
	PageSize   int     `json:"PageSize" xml:"PageSize"`
	Records    Records `json:"Records" xml:"Records"`
}

// CreateQueryHotlineRecordRequest creates a request to invoke QueryHotlineRecord API
func CreateQueryHotlineRecordRequest() (request *QueryHotlineRecordRequest) {
	request = &QueryHotlineRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ccs", "2017-10-01", "QueryHotlineRecord", "ccs", "openAPI")
	return
}

// CreateQueryHotlineRecordResponse creates a response to parse from QueryHotlineRecord response
func CreateQueryHotlineRecordResponse() (response *QueryHotlineRecordResponse) {
	response = &QueryHotlineRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
