package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAggregateDiscoveredResource invokes the config.GetAggregateDiscoveredResource API synchronously
func (client *Client) GetAggregateDiscoveredResource(request *GetAggregateDiscoveredResourceRequest) (response *GetAggregateDiscoveredResourceResponse, err error) {
	response = CreateGetAggregateDiscoveredResourceResponse()
	err = client.DoAction(request, response)
	return
}

// GetAggregateDiscoveredResourceWithChan invokes the config.GetAggregateDiscoveredResource API asynchronously
func (client *Client) GetAggregateDiscoveredResourceWithChan(request *GetAggregateDiscoveredResourceRequest) (<-chan *GetAggregateDiscoveredResourceResponse, <-chan error) {
	responseChan := make(chan *GetAggregateDiscoveredResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAggregateDiscoveredResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAggregateDiscoveredResourceWithCallback invokes the config.GetAggregateDiscoveredResource API asynchronously
func (client *Client) GetAggregateDiscoveredResourceWithCallback(request *GetAggregateDiscoveredResourceRequest, callback func(response *GetAggregateDiscoveredResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAggregateDiscoveredResourceResponse
		var err error
		defer close(result)
		response, err = client.GetAggregateDiscoveredResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAggregateDiscoveredResourceRequest is the request struct for api GetAggregateDiscoveredResource
type GetAggregateDiscoveredResourceRequest struct {
	*requests.RpcRequest
	ResourceId      string           `position:"Query" name:"ResourceId"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AggregatorId    string           `position:"Query" name:"AggregatorId"`
	ResourceType    string           `position:"Query" name:"ResourceType"`
	Region          string           `position:"Query" name:"Region"`
}

// GetAggregateDiscoveredResourceResponse is the response struct for api GetAggregateDiscoveredResource
type GetAggregateDiscoveredResourceResponse struct {
	*responses.BaseResponse
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	DiscoveredResourceDetail DiscoveredResourceDetail `json:"DiscoveredResourceDetail" xml:"DiscoveredResourceDetail"`
}

// CreateGetAggregateDiscoveredResourceRequest creates a request to invoke GetAggregateDiscoveredResource API
func CreateGetAggregateDiscoveredResourceRequest() (request *GetAggregateDiscoveredResourceRequest) {
	request = &GetAggregateDiscoveredResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetAggregateDiscoveredResource", "", "")
	request.Method = requests.GET
	return
}

// CreateGetAggregateDiscoveredResourceResponse creates a response to parse from GetAggregateDiscoveredResource response
func CreateGetAggregateDiscoveredResourceResponse() (response *GetAggregateDiscoveredResourceResponse) {
	response = &GetAggregateDiscoveredResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
