package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RescaleDeviceService invokes the ens.RescaleDeviceService API synchronously
func (client *Client) RescaleDeviceService(request *RescaleDeviceServiceRequest) (response *RescaleDeviceServiceResponse, err error) {
	response = CreateRescaleDeviceServiceResponse()
	err = client.DoAction(request, response)
	return
}

// RescaleDeviceServiceWithChan invokes the ens.RescaleDeviceService API asynchronously
func (client *Client) RescaleDeviceServiceWithChan(request *RescaleDeviceServiceRequest) (<-chan *RescaleDeviceServiceResponse, <-chan error) {
	responseChan := make(chan *RescaleDeviceServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RescaleDeviceService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RescaleDeviceServiceWithCallback invokes the ens.RescaleDeviceService API asynchronously
func (client *Client) RescaleDeviceServiceWithCallback(request *RescaleDeviceServiceRequest, callback func(response *RescaleDeviceServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RescaleDeviceServiceResponse
		var err error
		defer close(result)
		response, err = client.RescaleDeviceService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RescaleDeviceServiceRequest is the request struct for api RescaleDeviceService
type RescaleDeviceServiceRequest struct {
	*requests.RpcRequest
	ResourceSelector string           `position:"Body" name:"ResourceSelector"`
	ResourceInfo     string           `position:"Body" name:"ResourceInfo"`
	RescaleType      string           `position:"Query" name:"RescaleType"`
	ImageId          string           `position:"Query" name:"ImageId"`
	Timeout          requests.Integer `position:"Query" name:"Timeout"`
	RescaleLevel     string           `position:"Query" name:"RescaleLevel"`
	ResourceSpec     string           `position:"Query" name:"ResourceSpec"`
	IpType           requests.Integer `position:"Query" name:"IpType"`
	AppId            string           `position:"Query" name:"AppId"`
	ServiceId        string           `position:"Query" name:"ServiceId"`
}

// RescaleDeviceServiceResponse is the response struct for api RescaleDeviceService
type RescaleDeviceServiceResponse struct {
	*responses.BaseResponse
	RequestId           string               `json:"RequestId" xml:"RequestId"`
	OrderId             string               `json:"OrderId" xml:"OrderId"`
	DeviceIds           []string             `json:"DeviceIds" xml:"DeviceIds"`
	ResourceDetailInfos []ResourceDetailInfo `json:"ResourceDetailInfos" xml:"ResourceDetailInfos"`
}

// CreateRescaleDeviceServiceRequest creates a request to invoke RescaleDeviceService API
func CreateRescaleDeviceServiceRequest() (request *RescaleDeviceServiceRequest) {
	request = &RescaleDeviceServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "RescaleDeviceService", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRescaleDeviceServiceResponse creates a response to parse from RescaleDeviceService response
func CreateRescaleDeviceServiceResponse() (response *RescaleDeviceServiceResponse) {
	response = &RescaleDeviceServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
