/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.lang.reflect.Field;
import javax.swing.JDialog;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JListOperator;

public class WizardOperator
extends NbDialogOperator {
    private JButtonOperator _btNext;
    private JButtonOperator _btBack;
    private JButtonOperator _btFinish;
    private JListOperator _lstSteps;
    private static int WAIT_TIME = 60000;

    public WizardOperator(JDialog jDialog) {
        super(jDialog);
    }

    public WizardOperator(String string) {
        super(string);
    }

    public JButtonOperator btNext() {
        if (this._btNext == null) {
            String string = Bundle.getStringTrimmed("org.openide.Bundle", "CTL_NEXT");
            this._btNext = new JButtonOperator((ContainerOperator)this, string);
        }
        return this._btNext;
    }

    public JButtonOperator btBack() {
        if (this._btBack == null) {
            String string = Bundle.getStringTrimmed("org.openide.Bundle", "CTL_PREVIOUS");
            this._btBack = new JButtonOperator((ContainerOperator)this, string);
        }
        return this._btBack;
    }

    public JButtonOperator btFinish() {
        if (this._btFinish == null) {
            String string = Bundle.getStringTrimmed("org.openide.Bundle", "CTL_FINISH");
            this._btFinish = new JButtonOperator((ContainerOperator)this, string);
        }
        return this._btFinish;
    }

    public JListOperator lstSteps() {
        if (this._lstSteps == null) {
            this._lstSteps = new JListOperator((ContainerOperator)this);
        }
        return this._lstSteps;
    }

    public void next() {
        this.btNext().push();
    }

    public void back() {
        this.btBack().push();
    }

    public void finish() {
        this.btFinish().push();
    }

    public int stepsGetSelectedIndex() {
        int n = -1;
        try {
            Field field = this.lstSteps().getCellRenderer().getClass().getDeclaredField("selected");
            field.setAccessible(true);
            n = field.getInt(this.lstSteps().getCellRenderer());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new JemmyException("Field selected not found in CellRenderer.", (Throwable)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JemmyException("Illegal access to field selected.", (Throwable)illegalAccessException);
        }
        return n;
    }

    public void stepsWaitSelectedIndex(final int n) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return n == WizardOperator.this.stepsGetSelectedIndex() ? new Object() : null;
                }

                public String getDescription() {
                    return "Wait WizardOperator step";
                }
            });
            Timeouts timeouts = this.getTimeouts().cloneThis();
            timeouts.setTimeout("Waiter.WaitingTime", timeouts.getTimeout("WizardOperator.WaitWizardStepTimeout"));
            waiter.setTimeouts(timeouts);
            waiter.setOutput(this.getOutput());
            waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String stepsGetSelectedValue() {
        return this.lstSteps().getModel().getElementAt(this.stepsGetSelectedIndex()).toString();
    }

    public void stepsWaitSelectedValue(String string) {
        int n = this.lstSteps().findItemIndex(string);
        if (n < 0) {
            throw new JemmyException("Panel with name \"" + string + "\" not found.");
        }
        this.stepsWaitSelectedIndex(n);
    }

    protected void checkPanel(String string) {
        if (!this.stepsGetSelectedValue().equals(string)) {
            throw new JemmyException("Wrong panel! Found \"" + this.stepsGetSelectedValue() + "\" instead of \"" + string + "\".");
        }
    }

    public void verify() {
        this.btBack();
        this.btNext();
        this.btFinish();
        this.btCancel();
        this.btHelp();
        this.lstSteps();
    }

    static {
        Timeouts.initDefault((String)"WizardOperator.WaitWizardStepTimeout", (long)WAIT_TIME);
    }
}

