/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Utils;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlDefine;
import org.testng.xml.XmlGroups;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestNGContentHandler
extends DefaultHandler {
    private XmlSuite m_currentSuite = null;
    private XmlTest m_currentTest = null;
    private List<String> m_currentDefines = null;
    private List<String> m_currentRuns = null;
    private List<XmlClass> m_currentClasses = null;
    private int m_currentTestIndex = 0;
    private int m_currentClassIndex = 0;
    private int m_currentIncludeIndex = 0;
    private List<XmlPackage> m_currentPackages = null;
    private XmlPackage m_currentPackage = null;
    private List<XmlSuite> m_suites = Lists.newArrayList();
    private XmlGroups m_currentGroups = null;
    private List<String> m_currentIncludedGroups = null;
    private List<String> m_currentExcludedGroups = null;
    private Map<String, String> m_currentTestParameters = null;
    private Map<String, String> m_currentSuiteParameters = null;
    private Map<String, String> m_currentClassParameters = null;
    private Include m_currentInclude;
    private List<String> m_currentMetaGroup = null;
    private String m_currentMetaGroupName;
    private Stack<Location> m_locations = new Stack();
    private XmlClass m_currentClass = null;
    private ArrayList<XmlInclude> m_currentIncludedMethods = null;
    private List<String> m_currentExcludedMethods = null;
    private ArrayList<XmlMethodSelector> m_currentSelectors = null;
    private XmlMethodSelector m_currentSelector = null;
    private String m_currentLanguage = null;
    private String m_currentExpression = null;
    private List<String> m_suiteFiles = Lists.newArrayList();
    private boolean m_enabledTest;
    private List<String> m_listeners;
    private String m_fileName;
    private boolean m_loadClasses;
    private boolean m_validate = false;
    private boolean m_hasWarn = false;

    public TestNGContentHandler(String string, boolean bl) {
        this.m_fileName = string;
        this.m_loadClasses = bl;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        InputSource inputSource;
        if ("http://beust.com/testng/testng-1.0.dtd".equals(string2) || "http://testng.org/testng-1.0.dtd".equals(string2)) {
            this.m_validate = true;
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("testng-1.0.dtd");
            if (null == inputStream) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("testng-1.0.dtd");
                if (null == inputStream) {
                    System.out.println("WARNING: couldn't find in classpath " + string2 + "\nFetching it from the Web site.");
                    inputSource = super.resolveEntity(string, string2);
                } else {
                    inputSource = new InputSource(inputStream);
                }
            } else {
                inputSource = new InputSource(inputStream);
            }
        } else {
            inputSource = super.resolveEntity(string, string2);
        }
        return inputSource;
    }

    private void xmlSuiteFile(boolean bl, Attributes attributes) {
        if (bl) {
            String string = attributes.getValue("path");
            this.pushLocation(Location.SUITE);
            this.m_suiteFiles.add(string);
        } else {
            this.m_currentSuite.setSuiteFiles(this.m_suiteFiles);
            this.popLocation();
        }
    }

    private void xmlSuite(boolean bl, Attributes attributes) {
        if (bl) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            XmlSuite.FailurePolicy failurePolicy;
            String string9;
            Object object;
            String string10;
            String string11;
            this.pushLocation(Location.SUITE);
            String string12 = attributes.getValue("name");
            if (Utils.isStringBlank(string12)) {
                throw new TestNGException("The <suite> tag must define the name attribute");
            }
            this.m_currentSuite = new XmlSuite();
            this.m_currentSuite.setFileName(this.m_fileName);
            this.m_currentSuite.setName(string12);
            this.m_currentSuiteParameters = Maps.newHashMap();
            String string13 = attributes.getValue("verbose");
            if (null != string13) {
                this.m_currentSuite.setVerbose(Integer.parseInt(string13));
            }
            if (null != (string11 = attributes.getValue("junit"))) {
                this.m_currentSuite.setJUnit(Boolean.valueOf(string11));
            }
            if ((string10 = attributes.getValue("parallel")) != null) {
                object = XmlSuite.ParallelMode.getValidParallel(string10);
                if (object != null) {
                    this.m_currentSuite.setParallel((XmlSuite.ParallelMode)((Object)object));
                } else {
                    Utils.log("Parser", 1, "[WARN] Unknown value of attribute 'parallel' at suite level: '" + string10 + "'.");
                }
            }
            if ((object = attributes.getValue("parent-module")) != null) {
                this.m_currentSuite.setParentModule((String)object);
            }
            if ((string9 = attributes.getValue("guice-stage")) != null) {
                this.m_currentSuite.setGuiceStage(string9);
            }
            if (null != (failurePolicy = XmlSuite.FailurePolicy.getValidPolicy(attributes.getValue("configfailurepolicy")))) {
                this.m_currentSuite.setConfigFailurePolicy(failurePolicy);
            }
            if ((string8 = attributes.getValue("group-by-instances")) != null) {
                this.m_currentSuite.setGroupByInstances(Boolean.valueOf(string8));
            }
            if ((string7 = attributes.getValue("skipfailedinvocationcounts")) != null) {
                this.m_currentSuite.setSkipFailedInvocationCounts(Boolean.valueOf(string7));
            }
            if (null != (string6 = attributes.getValue("thread-count"))) {
                this.m_currentSuite.setThreadCount(Integer.parseInt(string6));
            }
            if (null != (string5 = attributes.getValue("data-provider-thread-count"))) {
                this.m_currentSuite.setDataProviderThreadCount(Integer.parseInt(string5));
            }
            if (null != (string4 = attributes.getValue("time-out"))) {
                this.m_currentSuite.setTimeOut(string4);
            }
            if (null != (string3 = attributes.getValue("object-factory")) && this.m_loadClasses) {
                try {
                    this.m_currentSuite.setObjectFactory((ITestObjectFactory)Class.forName(string3).newInstance());
                }
                catch (Exception exception) {
                    Utils.log("Parser", 1, "[ERROR] Unable to create custom object factory '" + string3 + "' :" + exception);
                }
            }
            if ((string2 = attributes.getValue("preserve-order")) != null) {
                this.m_currentSuite.setPreserveOrder(Boolean.valueOf(string2));
            }
            if ((string = attributes.getValue("allow-return-values")) != null) {
                this.m_currentSuite.setAllowReturnValues(Boolean.valueOf(string));
            }
        } else {
            this.m_currentSuite.setParameters(this.m_currentSuiteParameters);
            this.m_suites.add(this.m_currentSuite);
            this.m_currentSuiteParameters = null;
            this.popLocation();
        }
    }

    private void xmlDefine(boolean bl, Attributes attributes) {
        if (bl) {
            String string = attributes.getValue("name");
            this.m_currentDefines = Lists.newArrayList();
            this.m_currentMetaGroup = Lists.newArrayList();
            this.m_currentMetaGroupName = string;
        } else {
            if (this.m_currentTest != null) {
                this.m_currentTest.addMetaGroup(this.m_currentMetaGroupName, this.m_currentMetaGroup);
            } else {
                XmlDefine xmlDefine = new XmlDefine();
                xmlDefine.setName(this.m_currentMetaGroupName);
                xmlDefine.getIncludes().addAll(this.m_currentMetaGroup);
                this.m_currentGroups.addDefine(xmlDefine);
            }
            this.m_currentDefines = null;
        }
    }

    private void xmlScript(boolean bl, Attributes attributes) {
        if (bl) {
            this.m_currentLanguage = attributes.getValue("language");
            this.m_currentExpression = "";
        } else {
            this.m_currentSelector.setExpression(this.m_currentExpression);
            this.m_currentSelector.setLanguage(this.m_currentLanguage);
            if (this.m_locations.peek() == Location.TEST) {
                this.m_currentTest.setBeanShellExpression(this.m_currentExpression);
            }
            this.m_currentLanguage = null;
            this.m_currentExpression = null;
        }
    }

    private void xmlTest(boolean bl, Attributes attributes) {
        if (bl) {
            String string;
            Object object;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            this.m_currentTest = new XmlTest(this.m_currentSuite, this.m_currentTestIndex++);
            this.pushLocation(Location.TEST);
            this.m_currentTestParameters = Maps.newHashMap();
            String string7 = attributes.getValue("name");
            if (Utils.isStringBlank(string7)) {
                throw new TestNGException("The <test> tag must define the name attribute");
            }
            this.m_currentTest.setName(attributes.getValue("name"));
            String string8 = attributes.getValue("verbose");
            if (null != string8) {
                this.m_currentTest.setVerbose(Integer.parseInt(string8));
            }
            if (null != (string6 = attributes.getValue("junit"))) {
                this.m_currentTest.setJUnit(Boolean.valueOf(string6));
            }
            if ((string5 = attributes.getValue("skipfailedinvocationcounts")) != null) {
                this.m_currentTest.setSkipFailedInvocationCounts(Boolean.valueOf(string5));
            }
            if ((string4 = attributes.getValue("group-by-instances")) != null) {
                this.m_currentTest.setGroupByInstances(Boolean.valueOf(string4));
            }
            if ((string3 = attributes.getValue("preserve-order")) != null) {
                this.m_currentTest.setPreserveOrder(Boolean.valueOf(string3));
            }
            if ((string2 = attributes.getValue("parallel")) != null) {
                object = XmlSuite.ParallelMode.getValidParallel(string2);
                if (object != null) {
                    this.m_currentTest.setParallel((XmlSuite.ParallelMode)((Object)object));
                } else {
                    Utils.log("Parser", 1, "[WARN] Unknown value of attribute 'parallel' for test '" + this.m_currentTest.getName() + "': '" + string2 + "'");
                }
            }
            if (null != (object = attributes.getValue("thread-count"))) {
                this.m_currentTest.setThreadCount(Integer.parseInt((String)object));
            }
            if (null != (string = attributes.getValue("time-out"))) {
                this.m_currentTest.setTimeOut(Long.parseLong(string));
            }
            this.m_enabledTest = true;
            String string9 = attributes.getValue("enabled");
            if (null != string9) {
                this.m_enabledTest = Boolean.valueOf(string9);
            }
        } else {
            if (null != this.m_currentTestParameters && this.m_currentTestParameters.size() > 0) {
                this.m_currentTest.setParameters(this.m_currentTestParameters);
            }
            if (null != this.m_currentClasses) {
                this.m_currentTest.setXmlClasses(this.m_currentClasses);
            }
            this.m_currentClasses = null;
            this.m_currentTest = null;
            this.m_currentTestParameters = null;
            this.popLocation();
            if (!this.m_enabledTest) {
                List<XmlTest> list = this.m_currentSuite.getTests();
                list.remove(list.size() - 1);
            }
        }
    }

    public void xmlClasses(boolean bl, Attributes attributes) {
        if (bl) {
            this.m_currentClasses = Lists.newArrayList();
            this.m_currentClassIndex = 0;
        } else {
            this.m_currentTest.setXmlClasses(this.m_currentClasses);
            this.m_currentClasses = null;
        }
    }

    public void xmlListeners(boolean bl, Attributes attributes) {
        if (bl) {
            this.m_listeners = Lists.newArrayList();
        } else if (null != this.m_listeners) {
            this.m_currentSuite.setListeners(this.m_listeners);
            this.m_listeners = null;
        }
    }

    public void xmlListener(boolean bl, Attributes attributes) {
        if (bl) {
            String string = attributes.getValue("class-name");
            this.m_listeners.add(string);
        }
    }

    public void xmlPackages(boolean bl, Attributes attributes) {
        if (bl) {
            this.m_currentPackages = Lists.newArrayList();
        } else {
            if (null != this.m_currentPackages) {
                Location location = this.m_locations.peek();
                switch (location) {
                    case TEST: {
                        this.m_currentTest.setXmlPackages(this.m_currentPackages);
                        break;
                    }
                    case SUITE: {
                        this.m_currentSuite.setXmlPackages(this.m_currentPackages);
                        break;
                    }
                    case CLASS: {
                        throw new UnsupportedOperationException("CLASS");
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected value: " + (Object)((Object)location)));
                    }
                }
            }
            this.m_currentPackages = null;
            this.m_currentPackage = null;
        }
    }

    public void xmlMethodSelectors(boolean bl, Attributes attributes) {
        if (bl) {
            this.m_currentSelectors = new ArrayList();
        } else {
            switch (this.m_locations.peek()) {
                case TEST: {
                    this.m_currentTest.setMethodSelectors(this.m_currentSelectors);
                    break;
                }
                default: {
                    this.m_currentSuite.setMethodSelectors(this.m_currentSelectors);
                }
            }
            this.m_currentSelectors = null;
        }
    }

    public void xmlSelectorClass(boolean bl, Attributes attributes) {
        if (bl) {
            this.m_currentSelector.setName(attributes.getValue("name"));
            String string = attributes.getValue("priority");
            if (string == null) {
                string = "0";
            }
            this.m_currentSelector.setPriority(Integer.parseInt(string));
        }
    }

    public void xmlMethodSelector(boolean bl, Attributes attributes) {
        if (bl) {
            this.m_currentSelector = new XmlMethodSelector();
        } else {
            this.m_currentSelectors.add(this.m_currentSelector);
            this.m_currentSelector = null;
        }
    }

    private void xmlMethod(boolean bl) {
        if (bl) {
            this.m_currentIncludedMethods = new ArrayList();
            this.m_currentExcludedMethods = Lists.newArrayList();
            this.m_currentIncludeIndex = 0;
        } else {
            this.m_currentClass.setIncludedMethods(this.m_currentIncludedMethods);
            this.m_currentClass.setExcludedMethods(this.m_currentExcludedMethods);
            this.m_currentIncludedMethods = null;
            this.m_currentExcludedMethods = null;
        }
    }

    public void xmlRun(boolean bl, Attributes attributes) throws SAXException {
        if (bl) {
            this.m_currentRuns = Lists.newArrayList();
        } else {
            if (this.m_currentTest != null) {
                this.m_currentTest.setIncludedGroups(this.m_currentIncludedGroups);
                this.m_currentTest.setExcludedGroups(this.m_currentExcludedGroups);
            } else {
                this.m_currentSuite.setIncludedGroups(this.m_currentIncludedGroups);
                this.m_currentSuite.setExcludedGroups(this.m_currentExcludedGroups);
            }
            this.m_currentRuns = null;
        }
    }

    public void xmlGroup(boolean bl, Attributes attributes) throws SAXException {
        if (bl) {
            this.m_currentTest.addXmlDependencyGroup(attributes.getValue("name"), attributes.getValue("depends-on"));
        }
    }

    public void xmlGroups(boolean bl, Attributes attributes) throws SAXException {
        if (bl) {
            this.m_currentGroups = new XmlGroups();
            this.m_currentIncludedGroups = Lists.newArrayList();
            this.m_currentExcludedGroups = Lists.newArrayList();
        } else {
            if (this.m_currentTest == null) {
                this.m_currentSuite.setGroups(this.m_currentGroups);
            }
            this.m_currentGroups = null;
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!this.m_validate && !this.m_hasWarn) {
            Logger.getLogger(TestNGContentHandler.class).warn("It is strongly recommended to add \"<!DOCTYPE suite SYSTEM \"http://testng.org/testng-1.0.dtd\" >\" at the top of your file, otherwise TestNG may fail or not work as expected.");
            this.m_hasWarn = true;
        }
        String string4 = attributes.getValue("name");
        if ("suite".equals(string3)) {
            this.xmlSuite(true, attributes);
        } else if ("suite-file".equals(string3)) {
            this.xmlSuiteFile(true, attributes);
        } else if ("test".equals(string3)) {
            this.xmlTest(true, attributes);
        } else if ("script".equals(string3)) {
            this.xmlScript(true, attributes);
        } else if ("method-selector".equals(string3)) {
            this.xmlMethodSelector(true, attributes);
        } else if ("method-selectors".equals(string3)) {
            this.xmlMethodSelectors(true, attributes);
        } else if ("selector-class".equals(string3)) {
            this.xmlSelectorClass(true, attributes);
        } else if ("classes".equals(string3)) {
            this.xmlClasses(true, attributes);
        } else if ("packages".equals(string3)) {
            this.xmlPackages(true, attributes);
        } else if ("listeners".equals(string3)) {
            this.xmlListeners(true, attributes);
        } else if ("listener".equals(string3)) {
            this.xmlListener(true, attributes);
        } else if ("class".equals(string3)) {
            if (null != this.m_currentClasses) {
                this.m_currentClass = new XmlClass(string4, this.m_currentClassIndex++, this.m_loadClasses);
                this.m_currentClass.setXmlTest(this.m_currentTest);
                this.m_currentClassParameters = Maps.newHashMap();
                this.m_currentClasses.add(this.m_currentClass);
                this.pushLocation(Location.CLASS);
            }
        } else if ("package".equals(string3)) {
            if (null != this.m_currentPackages) {
                this.m_currentPackage = new XmlPackage();
                this.m_currentPackage.setName(string4);
                this.m_currentPackages.add(this.m_currentPackage);
            }
        } else if ("define".equals(string3)) {
            this.xmlDefine(true, attributes);
        } else if ("run".equals(string3)) {
            this.xmlRun(true, attributes);
        } else if ("group".equals(string3)) {
            this.xmlGroup(true, attributes);
        } else if ("groups".equals(string3)) {
            this.xmlGroups(true, attributes);
        } else if ("methods".equals(string3)) {
            this.xmlMethod(true);
        } else if ("include".equals(string3)) {
            this.xmlInclude(true, attributes);
        } else if ("exclude".equals(string3)) {
            this.xmlExclude(true, attributes);
        } else if ("parameter".equals(string3)) {
            String string5 = TestNGContentHandler.expandValue(attributes.getValue("value"));
            Location location = this.m_locations.peek();
            switch (location) {
                case TEST: {
                    this.m_currentTestParameters.put(string4, string5);
                    break;
                }
                case SUITE: {
                    this.m_currentSuiteParameters.put(string4, string5);
                    break;
                }
                case CLASS: {
                    this.m_currentClassParameters.put(string4, string5);
                    break;
                }
                case INCLUDE: {
                    this.m_currentInclude.parameters.put(string4, string5);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected value: " + (Object)((Object)location)));
                }
            }
        }
    }

    private void xmlInclude(boolean bl, Attributes attributes) {
        if (bl) {
            this.m_locations.push(Location.INCLUDE);
            this.m_currentInclude = new Include(attributes.getValue("name"), attributes.getValue("invocation-numbers"));
            this.m_currentInclude.description = attributes.getValue("description");
        } else {
            String string = this.m_currentInclude.name;
            if (null != this.m_currentIncludedMethods) {
                String string2 = this.m_currentInclude.invocationNumbers;
                XmlInclude xmlInclude = !Utils.isStringEmpty(string2) ? new XmlInclude(string, this.stringToList(string2), this.m_currentIncludeIndex++) : new XmlInclude(string, this.m_currentIncludeIndex++);
                for (Map.Entry<String, String> entry : this.m_currentInclude.parameters.entrySet()) {
                    xmlInclude.addParameter(entry.getKey(), entry.getValue());
                }
                xmlInclude.setDescription(this.m_currentInclude.description);
                this.m_currentIncludedMethods.add(xmlInclude);
            } else if (null != this.m_currentDefines) {
                this.m_currentMetaGroup.add(string);
            } else if (null != this.m_currentRuns) {
                this.m_currentIncludedGroups.add(string);
            } else if (null != this.m_currentPackage) {
                this.m_currentPackage.getInclude().add(string);
            }
            this.popLocation();
            this.m_currentInclude = null;
        }
    }

    private void xmlExclude(boolean bl, Attributes attributes) {
        if (bl) {
            this.m_locations.push(Location.EXCLUDE);
            String string = attributes.getValue("name");
            if (null != this.m_currentExcludedMethods) {
                this.m_currentExcludedMethods.add(string);
            } else if (null != this.m_currentRuns) {
                this.m_currentExcludedGroups.add(string);
            } else if (null != this.m_currentPackage) {
                this.m_currentPackage.getExclude().add(string);
            }
        } else {
            this.popLocation();
        }
    }

    private void pushLocation(Location location) {
        this.m_locations.push(location);
    }

    private Location popLocation() {
        return this.m_locations.pop();
    }

    private List<Integer> stringToList(String string) {
        String[] stringArray = string.split(" ");
        List<Integer> list = Lists.newArrayList();
        for (String string2 : stringArray) {
            list.add(Integer.parseInt(string2));
        }
        return list;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("suite".equals(string3)) {
            this.xmlSuite(false, null);
        } else if ("suite-file".equals(string3)) {
            this.xmlSuiteFile(false, null);
        } else if ("test".equals(string3)) {
            this.xmlTest(false, null);
        } else if ("define".equals(string3)) {
            this.xmlDefine(false, null);
        } else if ("run".equals(string3)) {
            this.xmlRun(false, null);
        } else if ("groups".equals(string3)) {
            this.xmlGroups(false, null);
        } else if ("methods".equals(string3)) {
            this.xmlMethod(false);
        } else if ("classes".equals(string3)) {
            this.xmlClasses(false, null);
        } else if ("packages".equals(string3)) {
            this.xmlPackages(false, null);
        } else if ("class".equals(string3)) {
            this.m_currentClass.setParameters(this.m_currentClassParameters);
            this.m_currentClassParameters = null;
            this.popLocation();
        } else if ("listeners".equals(string3)) {
            this.xmlListeners(false, null);
        } else if ("method-selector".equals(string3)) {
            this.xmlMethodSelector(false, null);
        } else if ("method-selectors".equals(string3)) {
            this.xmlMethodSelectors(false, null);
        } else if ("selector-class".equals(string3)) {
            this.xmlSelectorClass(false, null);
        } else if ("script".equals(string3)) {
            this.xmlScript(false, null);
        } else if ("include".equals(string3)) {
            this.xmlInclude(false, null);
        } else if ("exclude".equals(string3)) {
            this.xmlExclude(false, null);
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.m_validate) {
            throw sAXParseException;
        }
    }

    private boolean areWhiteSpaces(char[] cArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            char c = cArray[i];
            if (c == '\n' || c == '\t' || c == ' ') continue;
            return false;
        }
        return true;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (null != this.m_currentLanguage && !this.areWhiteSpaces(cArray, n, n2)) {
            this.m_currentExpression = this.m_currentExpression + new String(cArray, n, n2);
        }
    }

    public XmlSuite getSuite() {
        return this.m_currentSuite;
    }

    private static String expandValue(String string) {
        int n;
        int n2;
        StringBuilder stringBuilder = null;
        int n3 = 0;
        while ((n2 = string.indexOf("${", n3)) > -1 && (n = string.indexOf("}", n2 + 3)) > -1) {
            String string2 = string.substring(n2 + 2, n);
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string.substring(n3, n2));
            } else {
                stringBuilder.append(string.substring(n3, n2));
            }
            String string3 = System.getProperty(string2);
            if (string3 == null) {
                string3 = System.getenv(string2);
            }
            if (string3 != null) {
                stringBuilder.append(string3);
            } else {
                stringBuilder.append("${");
                stringBuilder.append(string2);
                stringBuilder.append("}");
            }
            n3 = n2 + 3 + string2.length();
        }
        if (stringBuilder != null) {
            stringBuilder.append(string.substring(n3));
            return stringBuilder.toString();
        }
        return string;
    }

    private static class Include {
        String name;
        String invocationNumbers;
        String description;
        Map<String, String> parameters = Maps.newHashMap();

        Include(String string, String string2) {
            this.name = string;
            this.invocationNumbers = string2;
        }
    }

    static enum Location {
        SUITE,
        TEST,
        CLASS,
        INCLUDE,
        EXCLUDE;

    }
}

