
using namespace System.Management.Automation
using namespace System.Management.Automation.Language

Register-ArgumentCompleter -Native -CommandName 'pkgcruft' -ScriptBlock {
    param($wordToComplete, $commandAst, $cursorPosition)

    $commandElements = $commandAst.CommandElements
    $command = @(
        'pkgcruft'
        for ($i = 1; $i -lt $commandElements.Count; $i++) {
            $element = $commandElements[$i]
            if ($element -isnot [StringConstantExpressionAst] -or
                $element.StringConstantType -ne [StringConstantType]::BareWord -or
                $element.Value.StartsWith('-') -or
                $element.Value -eq $wordToComplete) {
                break
        }
        $element.Value
    }) -join ';'

    $completions = @(switch ($command) {
        'pkgcruft' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Controls when to use color')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('-V', '-V ', [CompletionResultType]::ParameterName, 'Print version')
            [CompletionResult]::new('--version', '--version', [CompletionResultType]::ParameterName, 'Print version')
            [CompletionResult]::new('completion', 'completion', [CompletionResultType]::ParameterValue, 'Generate shell completion')
            [CompletionResult]::new('diff', 'diff', [CompletionResultType]::ParameterValue, 'Compare reports')
            [CompletionResult]::new('ignore', 'ignore', [CompletionResultType]::ParameterValue, 'Show ignore information')
            [CompletionResult]::new('replay', 'replay', [CompletionResultType]::ParameterValue, 'Replay reports')
            [CompletionResult]::new('scan', 'scan', [CompletionResultType]::ParameterValue, 'Scan for QA issues')
            [CompletionResult]::new('show', 'show', [CompletionResultType]::ParameterValue, 'Show various information')
            break
        }
        'pkgcruft;completion' {
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'Target directory for completion files')
            [CompletionResult]::new('--dir', '--dir', [CompletionResultType]::ParameterName, 'Target directory for completion files')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Controls when to use color')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pkgcruft;diff' {
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'Restrict by report target')
            [CompletionResult]::new('--reports', '--reports', [CompletionResultType]::ParameterName, 'Restrict by report target')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'Package restrictions')
            [CompletionResult]::new('--pkgs', '--pkgs', [CompletionResultType]::ParameterName, 'Package restrictions')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Controls when to use color')
            [CompletionResult]::new('-s', '-s', [CompletionResultType]::ParameterName, 'Sort reports')
            [CompletionResult]::new('--sort', '--sort', [CompletionResultType]::ParameterName, 'Sort reports')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pkgcruft;ignore' {
            [CompletionResult]::new('--repo', '--repo', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Controls when to use color')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pkgcruft;replay' {
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'Restrict by report target')
            [CompletionResult]::new('--reports', '--reports', [CompletionResultType]::ParameterName, 'Restrict by report target')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'Package restrictions')
            [CompletionResult]::new('--pkgs', '--pkgs', [CompletionResultType]::ParameterName, 'Package restrictions')
            [CompletionResult]::new('-S', '-S ', [CompletionResultType]::ParameterName, 'Restrict by scope')
            [CompletionResult]::new('--scopes', '--scopes', [CompletionResultType]::ParameterName, 'Restrict by scope')
            [CompletionResult]::new('-R', '-R ', [CompletionResultType]::ParameterName, 'Reporter to use')
            [CompletionResult]::new('--reporter', '--reporter', [CompletionResultType]::ParameterName, 'Reporter to use')
            [CompletionResult]::new('--format', '--format', [CompletionResultType]::ParameterName, 'Format string for the format reporter')
            [CompletionResult]::new('--stats', '--stats', [CompletionResultType]::ParameterName, 'Sorting variant for the stats reporter')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Controls when to use color')
            [CompletionResult]::new('-s', '-s', [CompletionResultType]::ParameterName, 'Sort reports')
            [CompletionResult]::new('--sort', '--sort', [CompletionResultType]::ParameterName, 'Sort reports')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pkgcruft;scan' {
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'Enable package filtering')
            [CompletionResult]::new('--filters', '--filters', [CompletionResultType]::ParameterName, 'Enable package filtering')
            [CompletionResult]::new('-j', '-j', [CompletionResultType]::ParameterName, 'Parallel jobs to run')
            [CompletionResult]::new('--jobs', '--jobs', [CompletionResultType]::ParameterName, 'Parallel jobs to run')
            [CompletionResult]::new('--exit', '--exit', [CompletionResultType]::ParameterName, 'Exit status triggers')
            [CompletionResult]::new('--repo', '--repo', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('-R', '-R ', [CompletionResultType]::ParameterName, 'Reporter to use')
            [CompletionResult]::new('--reporter', '--reporter', [CompletionResultType]::ParameterName, 'Reporter to use')
            [CompletionResult]::new('--format', '--format', [CompletionResultType]::ParameterName, 'Format string for the format reporter')
            [CompletionResult]::new('--stats', '--stats', [CompletionResultType]::ParameterName, 'Sorting variant for the stats reporter')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'Restrict by report target')
            [CompletionResult]::new('--reports', '--reports', [CompletionResultType]::ParameterName, 'Restrict by report target')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Controls when to use color')
            [CompletionResult]::new('-F', '-F ', [CompletionResultType]::ParameterName, 'Disregard ignore settings')
            [CompletionResult]::new('--force', '--force', [CompletionResultType]::ParameterName, 'Disregard ignore settings')
            [CompletionResult]::new('-s', '-s', [CompletionResultType]::ParameterName, 'Output reports in sorted order')
            [CompletionResult]::new('--sort', '--sort', [CompletionResultType]::ParameterName, 'Output reports in sorted order')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pkgcruft;show' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Controls when to use color')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('checks', 'checks', [CompletionResultType]::ParameterValue, 'Show checks')
            [CompletionResult]::new('reports', 'reports', [CompletionResultType]::ParameterValue, 'Show reports')
            break
        }
        'pkgcruft;show;checks' {
            [CompletionResult]::new('--repo', '--repo', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Controls when to use color')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Output extended information')
            [CompletionResult]::new('--info', '--info', [CompletionResultType]::ParameterName, 'Output extended information')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pkgcruft;show;reports' {
            [CompletionResult]::new('--repo', '--repo', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'Restrict by report target')
            [CompletionResult]::new('--reports', '--reports', [CompletionResultType]::ParameterName, 'Restrict by report target')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Controls when to use color')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
    })

    $completions.Where{ $_.CompletionText -like "$wordToComplete*" } |
        Sort-Object -Property ListItemText
}
