use crate::vk::aliases::*;
use crate::vk::bitflags::*;
use crate::vk::constants::*;
use crate::vk::enums::*;
use crate::vk::native::*;
use crate::vk::platform_types::*;
use crate::vk::prelude::*;
use crate::vk::{ptr_chain_iter, Handle};
use core::ffi::*;
use core::fmt;
use core::marker::PhantomData;
#[deprecated = "This define is deprecated. VK_MAKE_API_VERSION should be used instead."]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_MAKE_VERSION.html>"]
pub const fn make_version(major: u32, minor: u32, patch: u32) -> u32 {
    ((major) << 22) | ((minor) << 12) | (patch)
}
#[deprecated = "This define is deprecated. VK_API_VERSION_MAJOR should be used instead."]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_VERSION_MAJOR.html>"]
pub const fn version_major(version: u32) -> u32 {
    (version) >> 22
}
#[deprecated = "This define is deprecated. VK_API_VERSION_MINOR should be used instead."]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_VERSION_MINOR.html>"]
pub const fn version_minor(version: u32) -> u32 {
    ((version) >> 12) & 0x3ffu32
}
#[deprecated = "This define is deprecated. VK_API_VERSION_PATCH should be used instead."]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_VERSION_PATCH.html>"]
pub const fn version_patch(version: u32) -> u32 {
    (version) & 0xfffu32
}
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_MAKE_API_VERSION.html>"]
pub const fn make_api_version(variant: u32, major: u32, minor: u32, patch: u32) -> u32 {
    ((variant) << 29) | ((major) << 22) | ((minor) << 12) | (patch)
}
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_VARIANT.html>"]
pub const fn api_version_variant(version: u32) -> u32 {
    (version) >> 29
}
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_MAJOR.html>"]
pub const fn api_version_major(version: u32) -> u32 {
    ((version) >> 22) & 0x7fu32
}
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_MINOR.html>"]
pub const fn api_version_minor(version: u32) -> u32 {
    ((version) >> 12) & 0x3ffu32
}
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_PATCH.html>"]
pub const fn api_version_patch(version: u32) -> u32 {
    (version) & 0xfffu32
}
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_1_0.html>"]
pub const API_VERSION_1_0: u32 = make_api_version(0, 1, 0, 0);
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_1_1.html>"]
pub const API_VERSION_1_1: u32 = make_api_version(0, 1, 1, 0);
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_1_2.html>"]
pub const API_VERSION_1_2: u32 = make_api_version(0, 1, 2, 0);
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_1_3.html>"]
pub const API_VERSION_1_3: u32 = make_api_version(0, 1, 3, 0);
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_HEADER_VERSION.html>"]
pub const HEADER_VERSION: u32 = 281;
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VK_HEADER_VERSION_COMPLETE.html>"]
pub const HEADER_VERSION_COMPLETE: u32 = make_api_version(0, 1, 3, HEADER_VERSION);
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSampleMask.html>"]
pub type SampleMask = u32;
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBool32.html>"]
pub type Bool32 = u32;
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkFlags.html>"]
pub type Flags = u32;
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkFlags64.html>"]
pub type Flags64 = u64;
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceSize.html>"]
pub type DeviceSize = u64;
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceAddress.html>"]
pub type DeviceAddress = u64;
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkQueryPoolCreateFlags.html>"]
pub struct QueryPoolCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(QueryPoolCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineDynamicStateCreateFlags.html>"]
pub struct PipelineDynamicStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineDynamicStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineMultisampleStateCreateFlags.html>"]
pub struct PipelineMultisampleStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineMultisampleStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationStateCreateFlags.html>"]
pub struct PipelineRasterizationStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineRasterizationStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportStateCreateFlags.html>"]
pub struct PipelineViewportStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineViewportStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineTessellationStateCreateFlags.html>"]
pub struct PipelineTessellationStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineTessellationStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineInputAssemblyStateCreateFlags.html>"]
pub struct PipelineInputAssemblyStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineInputAssemblyStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineVertexInputStateCreateFlags.html>"]
pub struct PipelineVertexInputStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineVertexInputStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBufferViewCreateFlags.html>"]
pub struct BufferViewCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(BufferViewCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceCreateFlags.html>"]
pub struct DeviceCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(DeviceCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorPoolResetFlags.html>"]
pub struct DescriptorPoolResetFlags(pub(crate) Flags);
vk_bitflags_wrapped!(DescriptorPoolResetFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorUpdateTemplateCreateFlags.html>"]
pub struct DescriptorUpdateTemplateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(DescriptorUpdateTemplateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAccelerationStructureMotionInfoFlagsNV.html>"]
pub struct AccelerationStructureMotionInfoFlagsNV(pub(crate) Flags);
vk_bitflags_wrapped!(AccelerationStructureMotionInfoFlagsNV, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAccelerationStructureMotionInstanceFlagsNV.html>"]
pub struct AccelerationStructureMotionInstanceFlagsNV(pub(crate) Flags);
vk_bitflags_wrapped!(AccelerationStructureMotionInstanceFlagsNV, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDirectDriverLoadingFlagsLUNARG.html>"]
pub struct DirectDriverLoadingFlagsLUNARG(pub(crate) Flags);
vk_bitflags_wrapped!(DirectDriverLoadingFlagsLUNARG, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayModeCreateFlagsKHR.html>"]
pub struct DisplayModeCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(DisplayModeCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplaySurfaceCreateFlagsKHR.html>"]
pub struct DisplaySurfaceCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(DisplaySurfaceCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAndroidSurfaceCreateFlagsKHR.html>"]
pub struct AndroidSurfaceCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(AndroidSurfaceCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkViSurfaceCreateFlagsNN.html>"]
pub struct ViSurfaceCreateFlagsNN(pub(crate) Flags);
vk_bitflags_wrapped!(ViSurfaceCreateFlagsNN, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkWaylandSurfaceCreateFlagsKHR.html>"]
pub struct WaylandSurfaceCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(WaylandSurfaceCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkWin32SurfaceCreateFlagsKHR.html>"]
pub struct Win32SurfaceCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(Win32SurfaceCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkXlibSurfaceCreateFlagsKHR.html>"]
pub struct XlibSurfaceCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(XlibSurfaceCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkXcbSurfaceCreateFlagsKHR.html>"]
pub struct XcbSurfaceCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(XcbSurfaceCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDirectFBSurfaceCreateFlagsEXT.html>"]
pub struct DirectFBSurfaceCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(DirectFBSurfaceCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkIOSSurfaceCreateFlagsMVK.html>"]
pub struct IOSSurfaceCreateFlagsMVK(pub(crate) Flags);
vk_bitflags_wrapped!(IOSSurfaceCreateFlagsMVK, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMacOSSurfaceCreateFlagsMVK.html>"]
pub struct MacOSSurfaceCreateFlagsMVK(pub(crate) Flags);
vk_bitflags_wrapped!(MacOSSurfaceCreateFlagsMVK, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMetalSurfaceCreateFlagsEXT.html>"]
pub struct MetalSurfaceCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(MetalSurfaceCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImagePipeSurfaceCreateFlagsFUCHSIA.html>"]
pub struct ImagePipeSurfaceCreateFlagsFUCHSIA(pub(crate) Flags);
vk_bitflags_wrapped!(ImagePipeSurfaceCreateFlagsFUCHSIA, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkStreamDescriptorSurfaceCreateFlagsGGP.html>"]
pub struct StreamDescriptorSurfaceCreateFlagsGGP(pub(crate) Flags);
vk_bitflags_wrapped!(StreamDescriptorSurfaceCreateFlagsGGP, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkHeadlessSurfaceCreateFlagsEXT.html>"]
pub struct HeadlessSurfaceCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(HeadlessSurfaceCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkScreenSurfaceCreateFlagsQNX.html>"]
pub struct ScreenSurfaceCreateFlagsQNX(pub(crate) Flags);
vk_bitflags_wrapped!(ScreenSurfaceCreateFlagsQNX, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCommandPoolTrimFlags.html>"]
pub struct CommandPoolTrimFlags(pub(crate) Flags);
vk_bitflags_wrapped!(CommandPoolTrimFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportSwizzleStateCreateFlagsNV.html>"]
pub struct PipelineViewportSwizzleStateCreateFlagsNV(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineViewportSwizzleStateCreateFlagsNV, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineDiscardRectangleStateCreateFlagsEXT.html>"]
pub struct PipelineDiscardRectangleStateCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineDiscardRectangleStateCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineCoverageToColorStateCreateFlagsNV.html>"]
pub struct PipelineCoverageToColorStateCreateFlagsNV(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineCoverageToColorStateCreateFlagsNV, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineCoverageModulationStateCreateFlagsNV.html>"]
pub struct PipelineCoverageModulationStateCreateFlagsNV(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineCoverageModulationStateCreateFlagsNV, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineCoverageReductionStateCreateFlagsNV.html>"]
pub struct PipelineCoverageReductionStateCreateFlagsNV(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineCoverageReductionStateCreateFlagsNV, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkValidationCacheCreateFlagsEXT.html>"]
pub struct ValidationCacheCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(ValidationCacheCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugUtilsMessengerCreateFlagsEXT.html>"]
pub struct DebugUtilsMessengerCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(DebugUtilsMessengerCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugUtilsMessengerCallbackDataFlagsEXT.html>"]
pub struct DebugUtilsMessengerCallbackDataFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(DebugUtilsMessengerCallbackDataFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceMemoryReportFlagsEXT.html>"]
pub struct DeviceMemoryReportFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(DeviceMemoryReportFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationConservativeStateCreateFlagsEXT.html>"]
pub struct PipelineRasterizationConservativeStateCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineRasterizationConservativeStateCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationStateStreamCreateFlagsEXT.html>"]
pub struct PipelineRasterizationStateStreamCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineRasterizationStateStreamCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationDepthClipStateCreateFlagsEXT.html>"]
pub struct PipelineRasterizationDepthClipStateCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineRasterizationDepthClipStateCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkVideoSessionParametersCreateFlagsKHR.html>"]
pub struct VideoSessionParametersCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(VideoSessionParametersCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkVideoBeginCodingFlagsKHR.html>"]
pub struct VideoBeginCodingFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(VideoBeginCodingFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkVideoEndCodingFlagsKHR.html>"]
pub struct VideoEndCodingFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(VideoEndCodingFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkVideoDecodeFlagsKHR.html>"]
pub struct VideoDecodeFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(VideoDecodeFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkVideoEncodeRateControlFlagsKHR.html>"]
pub struct VideoEncodeRateControlFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(VideoEncodeRateControlFlagsKHR, Flags);
define_handle!(
    Instance,
    INSTANCE,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkInstance.html>"
);
define_handle!(
    PhysicalDevice,
    PHYSICAL_DEVICE,
    doc =
        "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevice.html>"
);
define_handle!(
    Device,
    DEVICE,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDevice.html>"
);
define_handle!(
    Queue,
    QUEUE,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkQueue.html>"
);
define_handle!(
    CommandBuffer,
    COMMAND_BUFFER,
    doc =
        "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCommandBuffer.html>"
);
handle_nondispatchable!(
    DeviceMemory,
    DEVICE_MEMORY,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceMemory.html>"
);
handle_nondispatchable!(
    CommandPool,
    COMMAND_POOL,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCommandPool.html>"
);
handle_nondispatchable!(
    Buffer,
    BUFFER,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBuffer.html>"
);
handle_nondispatchable!(
    BufferView,
    BUFFER_VIEW,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBufferView.html>"
);
handle_nondispatchable!(
    Image,
    IMAGE,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImage.html>"
);
handle_nondispatchable!(
    ImageView,
    IMAGE_VIEW,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageView.html>"
);
handle_nondispatchable!(
    ShaderModule,
    SHADER_MODULE,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkShaderModule.html>"
);
handle_nondispatchable!(
    Pipeline,
    PIPELINE,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipeline.html>"
);
handle_nondispatchable!(
    PipelineLayout,
    PIPELINE_LAYOUT,
    doc =
        "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineLayout.html>"
);
handle_nondispatchable!(
    Sampler,
    SAMPLER,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSampler.html>"
);
handle_nondispatchable!(
    DescriptorSet,
    DESCRIPTOR_SET,
    doc =
        "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorSet.html>"
);
handle_nondispatchable ! (DescriptorSetLayout , DESCRIPTOR_SET_LAYOUT , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetLayout.html>") ;
handle_nondispatchable!(
    DescriptorPool,
    DESCRIPTOR_POOL,
    doc =
        "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorPool.html>"
);
handle_nondispatchable!(
    Fence,
    FENCE,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkFence.html>"
);
handle_nondispatchable!(
    Semaphore,
    SEMAPHORE,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSemaphore.html>"
);
handle_nondispatchable!(
    Event,
    EVENT,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkEvent.html>"
);
handle_nondispatchable!(
    QueryPool,
    QUERY_POOL,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkQueryPool.html>"
);
handle_nondispatchable!(
    Framebuffer,
    FRAMEBUFFER,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkFramebuffer.html>"
);
handle_nondispatchable!(
    RenderPass,
    RENDER_PASS,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRenderPass.html>"
);
handle_nondispatchable!(
    PipelineCache,
    PIPELINE_CACHE,
    doc =
        "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineCache.html>"
);
handle_nondispatchable ! (IndirectCommandsLayoutNV , INDIRECT_COMMANDS_LAYOUT_NV , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkIndirectCommandsLayoutNV.html>") ;
handle_nondispatchable ! (DescriptorUpdateTemplate , DESCRIPTOR_UPDATE_TEMPLATE , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorUpdateTemplate.html>") ;
handle_nondispatchable ! (SamplerYcbcrConversion , SAMPLER_YCBCR_CONVERSION , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSamplerYcbcrConversion.html>") ;
handle_nondispatchable ! (ValidationCacheEXT , VALIDATION_CACHE_EXT , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkValidationCacheEXT.html>") ;
handle_nondispatchable ! (AccelerationStructureKHR , ACCELERATION_STRUCTURE_KHR , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAccelerationStructureKHR.html>") ;
handle_nondispatchable ! (AccelerationStructureNV , ACCELERATION_STRUCTURE_NV , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAccelerationStructureNV.html>") ;
handle_nondispatchable ! (PerformanceConfigurationINTEL , PERFORMANCE_CONFIGURATION_INTEL , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPerformanceConfigurationINTEL.html>") ;
handle_nondispatchable ! (BufferCollectionFUCHSIA , BUFFER_COLLECTION_FUCHSIA , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBufferCollectionFUCHSIA.html>") ;
handle_nondispatchable ! (DeferredOperationKHR , DEFERRED_OPERATION_KHR , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeferredOperationKHR.html>") ;
handle_nondispatchable ! (PrivateDataSlot , PRIVATE_DATA_SLOT , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPrivateDataSlot.html>") ;
handle_nondispatchable!(
    CuModuleNVX,
    CU_MODULE_NVX,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCuModuleNVX.html>"
);
handle_nondispatchable!(
    CuFunctionNVX,
    CU_FUNCTION_NVX,
    doc =
        "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCuFunctionNVX.html>"
);
handle_nondispatchable ! (OpticalFlowSessionNV , OPTICAL_FLOW_SESSION_NV , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkOpticalFlowSessionNV.html>") ;
handle_nondispatchable!(
    MicromapEXT,
    MICROMAP_EXT,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMicromapEXT.html>"
);
handle_nondispatchable!(
    ShaderEXT,
    SHADER_EXT,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkShaderEXT.html>"
);
handle_nondispatchable!(
    DisplayKHR,
    DISPLAY_KHR,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayKHR.html>"
);
handle_nondispatchable!(
    DisplayModeKHR,
    DISPLAY_MODE_KHR,
    doc =
        "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayModeKHR.html>"
);
handle_nondispatchable!(
    SurfaceKHR,
    SURFACE_KHR,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSurfaceKHR.html>"
);
handle_nondispatchable!(
    SwapchainKHR,
    SWAPCHAIN_KHR,
    doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSwapchainKHR.html>"
);
handle_nondispatchable ! (DebugReportCallbackEXT , DEBUG_REPORT_CALLBACK_EXT , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugReportCallbackEXT.html>") ;
handle_nondispatchable ! (DebugUtilsMessengerEXT , DEBUG_UTILS_MESSENGER_EXT , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugUtilsMessengerEXT.html>") ;
handle_nondispatchable ! (VideoSessionKHR , VIDEO_SESSION_KHR , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkVideoSessionKHR.html>") ;
handle_nondispatchable ! (VideoSessionParametersKHR , VIDEO_SESSION_PARAMETERS_KHR , doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkVideoSessionParametersKHR.html>") ;
#[allow(non_camel_case_types)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/PFN_vkInternalAllocationNotification.html>"]
pub type PFN_vkInternalAllocationNotification = Option<
    unsafe extern "system" fn(
        p_user_data: *mut c_void,
        size: usize,
        allocation_type: InternalAllocationType,
        allocation_scope: SystemAllocationScope,
    ),
>;
#[allow(non_camel_case_types)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/PFN_vkInternalFreeNotification.html>"]
pub type PFN_vkInternalFreeNotification = Option<
    unsafe extern "system" fn(
        p_user_data: *mut c_void,
        size: usize,
        allocation_type: InternalAllocationType,
        allocation_scope: SystemAllocationScope,
    ),
>;
#[allow(non_camel_case_types)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/PFN_vkReallocationFunction.html>"]
pub type PFN_vkReallocationFunction = Option<
    unsafe extern "system" fn(
        p_user_data: *mut c_void,
        p_original: *mut c_void,
        size: usize,
        alignment: usize,
        allocation_scope: SystemAllocationScope,
    ) -> *mut c_void,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/PFN_vkAllocationFunction.html>"]
pub type PFN_vkAllocationFunction = Option<
    unsafe extern "system" fn(
        p_user_data: *mut c_void,
        size: usize,
        alignment: usize,
        allocation_scope: SystemAllocationScope,
    ) -> *mut c_void,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/PFN_vkFreeFunction.html>"]
pub type PFN_vkFreeFunction =
    Option<unsafe extern "system" fn(p_user_data: *mut c_void, p_memory: *mut c_void)>;
#[allow(non_camel_case_types)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/PFN_vkVoidFunction.html>"]
pub type PFN_vkVoidFunction = Option<unsafe extern "system" fn()>;
#[allow(non_camel_case_types)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/PFN_vkDebugReportCallbackEXT.html>"]
pub type PFN_vkDebugReportCallbackEXT = Option<
    unsafe extern "system" fn(
        flags: DebugReportFlagsEXT,
        object_type: DebugReportObjectTypeEXT,
        object: u64,
        location: usize,
        message_code: i32,
        p_layer_prefix: *const c_char,
        p_message: *const c_char,
        p_user_data: *mut c_void,
    ) -> Bool32,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/PFN_vkDebugUtilsMessengerCallbackEXT.html>"]
pub type PFN_vkDebugUtilsMessengerCallbackEXT = Option<
    unsafe extern "system" fn(
        message_severity: DebugUtilsMessageSeverityFlagsEXT,
        message_types: DebugUtilsMessageTypeFlagsEXT,
        p_callback_data: *const DebugUtilsMessengerCallbackDataEXT<'_>,
        p_user_data: *mut c_void,
    ) -> Bool32,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/PFN_vkDeviceMemoryReportCallbackEXT.html>"]
pub type PFN_vkDeviceMemoryReportCallbackEXT = Option<
    unsafe extern "system" fn(
        p_callback_data: *const DeviceMemoryReportCallbackDataEXT<'_>,
        p_user_data: *mut c_void,
    ),
>;
#[allow(non_camel_case_types)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/PFN_vkGetInstanceProcAddrLUNARG.html>"]
pub type PFN_vkGetInstanceProcAddrLUNARG = Option<
    unsafe extern "system" fn(instance: Instance, p_name: *const c_char) -> PFN_vkVoidFunction,
>;
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBaseOutStructure.html>"]
#[must_use]
pub struct BaseOutStructure<'a> {
    pub s_type: StructureType,
    pub p_next: *mut Self,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BaseOutStructure<'_> {}
unsafe impl Sync for BaseOutStructure<'_> {}
impl ::core::default::Default for BaseOutStructure<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: unsafe { ::core::mem::zeroed() },
            p_next: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBaseInStructure.html>"]
#[must_use]
pub struct BaseInStructure<'a> {
    pub s_type: StructureType,
    pub p_next: *const Self,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BaseInStructure<'_> {}
unsafe impl Sync for BaseInStructure<'_> {}
impl ::core::default::Default for BaseInStructure<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: unsafe { ::core::mem::zeroed() },
            p_next: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkOffset2D.html>"]
#[must_use]
pub struct Offset2D {
    pub x: i32,
    pub y: i32,
}
impl Offset2D {
    #[inline]
    pub fn x(mut self, x: i32) -> Self {
        self.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: i32) -> Self {
        self.y = y;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkOffset3D.html>"]
#[must_use]
pub struct Offset3D {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}
impl Offset3D {
    #[inline]
    pub fn x(mut self, x: i32) -> Self {
        self.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: i32) -> Self {
        self.y = y;
        self
    }
    #[inline]
    pub fn z(mut self, z: i32) -> Self {
        self.z = z;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExtent2D.html>"]
#[must_use]
pub struct Extent2D {
    pub width: u32,
    pub height: u32,
}
impl Extent2D {
    #[inline]
    pub fn width(mut self, width: u32) -> Self {
        self.width = width;
        self
    }
    #[inline]
    pub fn height(mut self, height: u32) -> Self {
        self.height = height;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExtent3D.html>"]
#[must_use]
pub struct Extent3D {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}
impl Extent3D {
    #[inline]
    pub fn width(mut self, width: u32) -> Self {
        self.width = width;
        self
    }
    #[inline]
    pub fn height(mut self, height: u32) -> Self {
        self.height = height;
        self
    }
    #[inline]
    pub fn depth(mut self, depth: u32) -> Self {
        self.depth = depth;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkViewport.html>"]
#[must_use]
pub struct Viewport {
    pub x: f32,
    pub y: f32,
    pub width: f32,
    pub height: f32,
    pub min_depth: f32,
    pub max_depth: f32,
}
impl Viewport {
    #[inline]
    pub fn x(mut self, x: f32) -> Self {
        self.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: f32) -> Self {
        self.y = y;
        self
    }
    #[inline]
    pub fn width(mut self, width: f32) -> Self {
        self.width = width;
        self
    }
    #[inline]
    pub fn height(mut self, height: f32) -> Self {
        self.height = height;
        self
    }
    #[inline]
    pub fn min_depth(mut self, min_depth: f32) -> Self {
        self.min_depth = min_depth;
        self
    }
    #[inline]
    pub fn max_depth(mut self, max_depth: f32) -> Self {
        self.max_depth = max_depth;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRect2D.html>"]
#[must_use]
pub struct Rect2D {
    pub offset: Offset2D,
    pub extent: Extent2D,
}
impl Rect2D {
    #[inline]
    pub fn offset(mut self, offset: Offset2D) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn extent(mut self, extent: Extent2D) -> Self {
        self.extent = extent;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkClearRect.html>"]
#[must_use]
pub struct ClearRect {
    pub rect: Rect2D,
    pub base_array_layer: u32,
    pub layer_count: u32,
}
impl ClearRect {
    #[inline]
    pub fn rect(mut self, rect: Rect2D) -> Self {
        self.rect = rect;
        self
    }
    #[inline]
    pub fn base_array_layer(mut self, base_array_layer: u32) -> Self {
        self.base_array_layer = base_array_layer;
        self
    }
    #[inline]
    pub fn layer_count(mut self, layer_count: u32) -> Self {
        self.layer_count = layer_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkComponentMapping.html>"]
#[must_use]
pub struct ComponentMapping {
    pub r: ComponentSwizzle,
    pub g: ComponentSwizzle,
    pub b: ComponentSwizzle,
    pub a: ComponentSwizzle,
}
impl ComponentMapping {
    #[inline]
    pub fn r(mut self, r: ComponentSwizzle) -> Self {
        self.r = r;
        self
    }
    #[inline]
    pub fn g(mut self, g: ComponentSwizzle) -> Self {
        self.g = g;
        self
    }
    #[inline]
    pub fn b(mut self, b: ComponentSwizzle) -> Self {
        self.b = b;
        self
    }
    #[inline]
    pub fn a(mut self, a: ComponentSwizzle) -> Self {
        self.a = a;
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceProperties.html>"]
#[must_use]
pub struct PhysicalDeviceProperties {
    pub api_version: u32,
    pub driver_version: u32,
    pub vendor_id: u32,
    pub device_id: u32,
    pub device_type: PhysicalDeviceType,
    pub device_name: [c_char; MAX_PHYSICAL_DEVICE_NAME_SIZE],
    pub pipeline_cache_uuid: [u8; UUID_SIZE],
    pub limits: PhysicalDeviceLimits,
    pub sparse_properties: PhysicalDeviceSparseProperties,
}
#[cfg(feature = "debug")]
impl fmt::Debug for PhysicalDeviceProperties {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("PhysicalDeviceProperties")
            .field("api_version", &self.api_version)
            .field("driver_version", &self.driver_version)
            .field("vendor_id", &self.vendor_id)
            .field("device_id", &self.device_id)
            .field("device_type", &self.device_type)
            .field("device_name", &self.device_name_as_c_str())
            .field("pipeline_cache_uuid", &self.pipeline_cache_uuid)
            .field("limits", &self.limits)
            .field("sparse_properties", &self.sparse_properties)
            .finish()
    }
}
impl ::core::default::Default for PhysicalDeviceProperties {
    #[inline]
    fn default() -> Self {
        Self {
            api_version: u32::default(),
            driver_version: u32::default(),
            vendor_id: u32::default(),
            device_id: u32::default(),
            device_type: PhysicalDeviceType::default(),
            device_name: unsafe { ::core::mem::zeroed() },
            pipeline_cache_uuid: unsafe { ::core::mem::zeroed() },
            limits: PhysicalDeviceLimits::default(),
            sparse_properties: PhysicalDeviceSparseProperties::default(),
        }
    }
}
impl PhysicalDeviceProperties {
    #[inline]
    pub fn api_version(mut self, api_version: u32) -> Self {
        self.api_version = api_version;
        self
    }
    #[inline]
    pub fn driver_version(mut self, driver_version: u32) -> Self {
        self.driver_version = driver_version;
        self
    }
    #[inline]
    pub fn vendor_id(mut self, vendor_id: u32) -> Self {
        self.vendor_id = vendor_id;
        self
    }
    #[inline]
    pub fn device_id(mut self, device_id: u32) -> Self {
        self.device_id = device_id;
        self
    }
    #[inline]
    pub fn device_type(mut self, device_type: PhysicalDeviceType) -> Self {
        self.device_type = device_type;
        self
    }
    #[inline]
    pub fn device_name(
        mut self,
        device_name: &CStr,
    ) -> core::result::Result<Self, CStrTooLargeForStaticArray> {
        write_c_str_slice_with_nul(&mut self.device_name, device_name).map(|()| self)
    }
    #[inline]
    pub fn device_name_as_c_str(&self) -> core::result::Result<&CStr, FromBytesUntilNulError> {
        wrap_c_str_slice_until_nul(&self.device_name)
    }
    #[inline]
    pub fn pipeline_cache_uuid(mut self, pipeline_cache_uuid: [u8; UUID_SIZE]) -> Self {
        self.pipeline_cache_uuid = pipeline_cache_uuid;
        self
    }
    #[inline]
    pub fn limits(mut self, limits: PhysicalDeviceLimits) -> Self {
        self.limits = limits;
        self
    }
    #[inline]
    pub fn sparse_properties(mut self, sparse_properties: PhysicalDeviceSparseProperties) -> Self {
        self.sparse_properties = sparse_properties;
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExtensionProperties.html>"]
#[must_use]
pub struct ExtensionProperties {
    pub extension_name: [c_char; MAX_EXTENSION_NAME_SIZE],
    pub spec_version: u32,
}
#[cfg(feature = "debug")]
impl fmt::Debug for ExtensionProperties {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("ExtensionProperties")
            .field("extension_name", &self.extension_name_as_c_str())
            .field("spec_version", &self.spec_version)
            .finish()
    }
}
impl ::core::default::Default for ExtensionProperties {
    #[inline]
    fn default() -> Self {
        Self {
            extension_name: unsafe { ::core::mem::zeroed() },
            spec_version: u32::default(),
        }
    }
}
impl ExtensionProperties {
    #[inline]
    pub fn extension_name(
        mut self,
        extension_name: &CStr,
    ) -> core::result::Result<Self, CStrTooLargeForStaticArray> {
        write_c_str_slice_with_nul(&mut self.extension_name, extension_name).map(|()| self)
    }
    #[inline]
    pub fn extension_name_as_c_str(&self) -> core::result::Result<&CStr, FromBytesUntilNulError> {
        wrap_c_str_slice_until_nul(&self.extension_name)
    }
    #[inline]
    pub fn spec_version(mut self, spec_version: u32) -> Self {
        self.spec_version = spec_version;
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkLayerProperties.html>"]
#[must_use]
pub struct LayerProperties {
    pub layer_name: [c_char; MAX_EXTENSION_NAME_SIZE],
    pub spec_version: u32,
    pub implementation_version: u32,
    pub description: [c_char; MAX_DESCRIPTION_SIZE],
}
#[cfg(feature = "debug")]
impl fmt::Debug for LayerProperties {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("LayerProperties")
            .field("layer_name", &self.layer_name_as_c_str())
            .field("spec_version", &self.spec_version)
            .field("implementation_version", &self.implementation_version)
            .field("description", &self.description_as_c_str())
            .finish()
    }
}
impl ::core::default::Default for LayerProperties {
    #[inline]
    fn default() -> Self {
        Self {
            layer_name: unsafe { ::core::mem::zeroed() },
            spec_version: u32::default(),
            implementation_version: u32::default(),
            description: unsafe { ::core::mem::zeroed() },
        }
    }
}
impl LayerProperties {
    #[inline]
    pub fn layer_name(
        mut self,
        layer_name: &CStr,
    ) -> core::result::Result<Self, CStrTooLargeForStaticArray> {
        write_c_str_slice_with_nul(&mut self.layer_name, layer_name).map(|()| self)
    }
    #[inline]
    pub fn layer_name_as_c_str(&self) -> core::result::Result<&CStr, FromBytesUntilNulError> {
        wrap_c_str_slice_until_nul(&self.layer_name)
    }
    #[inline]
    pub fn spec_version(mut self, spec_version: u32) -> Self {
        self.spec_version = spec_version;
        self
    }
    #[inline]
    pub fn implementation_version(mut self, implementation_version: u32) -> Self {
        self.implementation_version = implementation_version;
        self
    }
    #[inline]
    pub fn description(
        mut self,
        description: &CStr,
    ) -> core::result::Result<Self, CStrTooLargeForStaticArray> {
        write_c_str_slice_with_nul(&mut self.description, description).map(|()| self)
    }
    #[inline]
    pub fn description_as_c_str(&self) -> core::result::Result<&CStr, FromBytesUntilNulError> {
        wrap_c_str_slice_until_nul(&self.description)
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkApplicationInfo.html>"]
#[must_use]
pub struct ApplicationInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_application_name: *const c_char,
    pub application_version: u32,
    pub p_engine_name: *const c_char,
    pub engine_version: u32,
    pub api_version: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ApplicationInfo<'_> {}
unsafe impl Sync for ApplicationInfo<'_> {}
impl ::core::default::Default for ApplicationInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            p_application_name: ::core::ptr::null(),
            application_version: u32::default(),
            p_engine_name: ::core::ptr::null(),
            engine_version: u32::default(),
            api_version: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ApplicationInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::APPLICATION_INFO;
}
impl<'a> ApplicationInfo<'a> {
    #[inline]
    pub fn application_name(mut self, application_name: &'a CStr) -> Self {
        self.p_application_name = application_name.as_ptr();
        self
    }
    #[inline]
    pub unsafe fn application_name_as_c_str(&self) -> Option<&CStr> {
        if self.p_application_name.is_null() {
            None
        } else {
            Some(CStr::from_ptr(self.p_application_name))
        }
    }
    #[inline]
    pub fn application_version(mut self, application_version: u32) -> Self {
        self.application_version = application_version;
        self
    }
    #[inline]
    pub fn engine_name(mut self, engine_name: &'a CStr) -> Self {
        self.p_engine_name = engine_name.as_ptr();
        self
    }
    #[inline]
    pub unsafe fn engine_name_as_c_str(&self) -> Option<&CStr> {
        if self.p_engine_name.is_null() {
            None
        } else {
            Some(CStr::from_ptr(self.p_engine_name))
        }
    }
    #[inline]
    pub fn engine_version(mut self, engine_version: u32) -> Self {
        self.engine_version = engine_version;
        self
    }
    #[inline]
    pub fn api_version(mut self, api_version: u32) -> Self {
        self.api_version = api_version;
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAllocationCallbacks.html>"]
#[must_use]
pub struct AllocationCallbacks<'a> {
    pub p_user_data: *mut c_void,
    pub pfn_allocation: PFN_vkAllocationFunction,
    pub pfn_reallocation: PFN_vkReallocationFunction,
    pub pfn_free: PFN_vkFreeFunction,
    pub pfn_internal_allocation: PFN_vkInternalAllocationNotification,
    pub pfn_internal_free: PFN_vkInternalFreeNotification,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for AllocationCallbacks<'_> {}
unsafe impl Sync for AllocationCallbacks<'_> {}
#[cfg(feature = "debug")]
impl fmt::Debug for AllocationCallbacks<'_> {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("AllocationCallbacks")
            .field("p_user_data", &self.p_user_data)
            .field(
                "pfn_allocation",
                &(self.pfn_allocation.map(|x| x as *const ())),
            )
            .field(
                "pfn_reallocation",
                &(self.pfn_reallocation.map(|x| x as *const ())),
            )
            .field("pfn_free", &(self.pfn_free.map(|x| x as *const ())))
            .field(
                "pfn_internal_allocation",
                &(self.pfn_internal_allocation.map(|x| x as *const ())),
            )
            .field(
                "pfn_internal_free",
                &(self.pfn_internal_free.map(|x| x as *const ())),
            )
            .finish()
    }
}
impl ::core::default::Default for AllocationCallbacks<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            p_user_data: ::core::ptr::null_mut(),
            pfn_allocation: PFN_vkAllocationFunction::default(),
            pfn_reallocation: PFN_vkReallocationFunction::default(),
            pfn_free: PFN_vkFreeFunction::default(),
            pfn_internal_allocation: PFN_vkInternalAllocationNotification::default(),
            pfn_internal_free: PFN_vkInternalFreeNotification::default(),
            _marker: PhantomData,
        }
    }
}
impl<'a> AllocationCallbacks<'a> {
    #[inline]
    pub fn user_data(mut self, user_data: *mut c_void) -> Self {
        self.p_user_data = user_data;
        self
    }
    #[inline]
    pub fn pfn_allocation(mut self, pfn_allocation: PFN_vkAllocationFunction) -> Self {
        self.pfn_allocation = pfn_allocation;
        self
    }
    #[inline]
    pub fn pfn_reallocation(mut self, pfn_reallocation: PFN_vkReallocationFunction) -> Self {
        self.pfn_reallocation = pfn_reallocation;
        self
    }
    #[inline]
    pub fn pfn_free(mut self, pfn_free: PFN_vkFreeFunction) -> Self {
        self.pfn_free = pfn_free;
        self
    }
    #[inline]
    pub fn pfn_internal_allocation(
        mut self,
        pfn_internal_allocation: PFN_vkInternalAllocationNotification,
    ) -> Self {
        self.pfn_internal_allocation = pfn_internal_allocation;
        self
    }
    #[inline]
    pub fn pfn_internal_free(mut self, pfn_internal_free: PFN_vkInternalFreeNotification) -> Self {
        self.pfn_internal_free = pfn_internal_free;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceQueueCreateInfo.html>"]
#[must_use]
pub struct DeviceQueueCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DeviceQueueCreateFlags,
    pub queue_family_index: u32,
    pub queue_count: u32,
    pub p_queue_priorities: *const f32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceQueueCreateInfo<'_> {}
unsafe impl Sync for DeviceQueueCreateInfo<'_> {}
impl ::core::default::Default for DeviceQueueCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DeviceQueueCreateFlags::default(),
            queue_family_index: u32::default(),
            queue_count: u32::default(),
            p_queue_priorities: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceQueueCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_QUEUE_CREATE_INFO;
}
pub unsafe trait ExtendsDeviceQueueCreateInfo {}
impl<'a> DeviceQueueCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: DeviceQueueCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn queue_family_index(mut self, queue_family_index: u32) -> Self {
        self.queue_family_index = queue_family_index;
        self
    }
    #[inline]
    pub fn queue_priorities(mut self, queue_priorities: &'a [f32]) -> Self {
        self.queue_count = queue_priorities.len() as _;
        self.p_queue_priorities = queue_priorities.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDeviceQueueCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceCreateInfo.html>"]
#[must_use]
pub struct DeviceCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DeviceCreateFlags,
    pub queue_create_info_count: u32,
    pub p_queue_create_infos: *const DeviceQueueCreateInfo<'a>,
    #[deprecated = "functionality described by this member no longer operates"]
    pub enabled_layer_count: u32,
    #[deprecated = "functionality described by this member no longer operates"]
    pub pp_enabled_layer_names: *const *const c_char,
    pub enabled_extension_count: u32,
    pub pp_enabled_extension_names: *const *const c_char,
    pub p_enabled_features: *const PhysicalDeviceFeatures,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceCreateInfo<'_> {}
unsafe impl Sync for DeviceCreateInfo<'_> {}
impl ::core::default::Default for DeviceCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        #[allow(deprecated)]
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DeviceCreateFlags::default(),
            queue_create_info_count: u32::default(),
            p_queue_create_infos: ::core::ptr::null(),
            enabled_layer_count: u32::default(),
            pp_enabled_layer_names: ::core::ptr::null(),
            enabled_extension_count: u32::default(),
            pp_enabled_extension_names: ::core::ptr::null(),
            p_enabled_features: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_CREATE_INFO;
}
pub unsafe trait ExtendsDeviceCreateInfo {}
impl<'a> DeviceCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: DeviceCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn queue_create_infos(
        mut self,
        queue_create_infos: &'a [DeviceQueueCreateInfo<'a>],
    ) -> Self {
        self.queue_create_info_count = queue_create_infos.len() as _;
        self.p_queue_create_infos = queue_create_infos.as_ptr();
        self
    }
    #[deprecated = "functionality described by this member no longer operates"]
    #[allow(deprecated)]
    #[inline]
    pub fn enabled_layer_names(mut self, enabled_layer_names: &'a [*const c_char]) -> Self {
        self.enabled_layer_count = enabled_layer_names.len() as _;
        self.pp_enabled_layer_names = enabled_layer_names.as_ptr();
        self
    }
    #[inline]
    pub fn enabled_extension_names(mut self, enabled_extension_names: &'a [*const c_char]) -> Self {
        self.enabled_extension_count = enabled_extension_names.len() as _;
        self.pp_enabled_extension_names = enabled_extension_names.as_ptr();
        self
    }
    #[inline]
    pub fn enabled_features(mut self, enabled_features: &'a PhysicalDeviceFeatures) -> Self {
        self.p_enabled_features = enabled_features;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDeviceCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkInstanceCreateInfo.html>"]
#[must_use]
pub struct InstanceCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: InstanceCreateFlags,
    pub p_application_info: *const ApplicationInfo<'a>,
    pub enabled_layer_count: u32,
    pub pp_enabled_layer_names: *const *const c_char,
    pub enabled_extension_count: u32,
    pub pp_enabled_extension_names: *const *const c_char,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for InstanceCreateInfo<'_> {}
unsafe impl Sync for InstanceCreateInfo<'_> {}
impl ::core::default::Default for InstanceCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: InstanceCreateFlags::default(),
            p_application_info: ::core::ptr::null(),
            enabled_layer_count: u32::default(),
            pp_enabled_layer_names: ::core::ptr::null(),
            enabled_extension_count: u32::default(),
            pp_enabled_extension_names: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for InstanceCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::INSTANCE_CREATE_INFO;
}
pub unsafe trait ExtendsInstanceCreateInfo {}
impl<'a> InstanceCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: InstanceCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn application_info(mut self, application_info: &'a ApplicationInfo<'a>) -> Self {
        self.p_application_info = application_info;
        self
    }
    #[inline]
    pub fn enabled_layer_names(mut self, enabled_layer_names: &'a [*const c_char]) -> Self {
        self.enabled_layer_count = enabled_layer_names.len() as _;
        self.pp_enabled_layer_names = enabled_layer_names.as_ptr();
        self
    }
    #[inline]
    pub fn enabled_extension_names(mut self, enabled_extension_names: &'a [*const c_char]) -> Self {
        self.enabled_extension_count = enabled_extension_names.len() as _;
        self.pp_enabled_extension_names = enabled_extension_names.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsInstanceCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkQueueFamilyProperties.html>"]
#[must_use]
pub struct QueueFamilyProperties {
    pub queue_flags: QueueFlags,
    pub queue_count: u32,
    pub timestamp_valid_bits: u32,
    pub min_image_transfer_granularity: Extent3D,
}
impl QueueFamilyProperties {
    #[inline]
    pub fn queue_flags(mut self, queue_flags: QueueFlags) -> Self {
        self.queue_flags = queue_flags;
        self
    }
    #[inline]
    pub fn queue_count(mut self, queue_count: u32) -> Self {
        self.queue_count = queue_count;
        self
    }
    #[inline]
    pub fn timestamp_valid_bits(mut self, timestamp_valid_bits: u32) -> Self {
        self.timestamp_valid_bits = timestamp_valid_bits;
        self
    }
    #[inline]
    pub fn min_image_transfer_granularity(
        mut self,
        min_image_transfer_granularity: Extent3D,
    ) -> Self {
        self.min_image_transfer_granularity = min_image_transfer_granularity;
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMemoryProperties.html>"]
#[must_use]
pub struct PhysicalDeviceMemoryProperties {
    pub memory_type_count: u32,
    pub memory_types: [MemoryType; MAX_MEMORY_TYPES],
    pub memory_heap_count: u32,
    pub memory_heaps: [MemoryHeap; MAX_MEMORY_HEAPS],
}
#[cfg(feature = "debug")]
impl fmt::Debug for PhysicalDeviceMemoryProperties {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("PhysicalDeviceMemoryProperties")
            .field("memory_type_count", &self.memory_type_count)
            .field("memory_types", &self.memory_types_as_slice())
            .field("memory_heap_count", &self.memory_heap_count)
            .field("memory_heaps", &self.memory_heaps_as_slice())
            .finish()
    }
}
impl ::core::default::Default for PhysicalDeviceMemoryProperties {
    #[inline]
    fn default() -> Self {
        Self {
            memory_type_count: u32::default(),
            memory_types: unsafe { ::core::mem::zeroed() },
            memory_heap_count: u32::default(),
            memory_heaps: unsafe { ::core::mem::zeroed() },
        }
    }
}
impl PhysicalDeviceMemoryProperties {
    #[inline]
    pub fn memory_types(mut self, memory_types: &'_ [MemoryType]) -> Self {
        self.memory_type_count = memory_types.len() as _;
        self.memory_types[..memory_types.len()].copy_from_slice(memory_types);
        self
    }
    #[inline]
    pub fn memory_types_as_slice(&self) -> &[MemoryType] {
        &self.memory_types[..self.memory_type_count as _]
    }
    #[inline]
    pub fn memory_heaps(mut self, memory_heaps: &'_ [MemoryHeap]) -> Self {
        self.memory_heap_count = memory_heaps.len() as _;
        self.memory_heaps[..memory_heaps.len()].copy_from_slice(memory_heaps);
        self
    }
    #[inline]
    pub fn memory_heaps_as_slice(&self) -> &[MemoryHeap] {
        &self.memory_heaps[..self.memory_heap_count as _]
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryAllocateInfo.html>"]
#[must_use]
pub struct MemoryAllocateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub allocation_size: DeviceSize,
    pub memory_type_index: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryAllocateInfo<'_> {}
unsafe impl Sync for MemoryAllocateInfo<'_> {}
impl ::core::default::Default for MemoryAllocateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            allocation_size: DeviceSize::default(),
            memory_type_index: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryAllocateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_ALLOCATE_INFO;
}
pub unsafe trait ExtendsMemoryAllocateInfo {}
impl<'a> MemoryAllocateInfo<'a> {
    #[inline]
    pub fn allocation_size(mut self, allocation_size: DeviceSize) -> Self {
        self.allocation_size = allocation_size;
        self
    }
    #[inline]
    pub fn memory_type_index(mut self, memory_type_index: u32) -> Self {
        self.memory_type_index = memory_type_index;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsMemoryAllocateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryRequirements.html>"]
#[must_use]
pub struct MemoryRequirements {
    pub size: DeviceSize,
    pub alignment: DeviceSize,
    pub memory_type_bits: u32,
}
impl MemoryRequirements {
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.size = size;
        self
    }
    #[inline]
    pub fn alignment(mut self, alignment: DeviceSize) -> Self {
        self.alignment = alignment;
        self
    }
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.memory_type_bits = memory_type_bits;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSparseImageFormatProperties.html>"]
#[must_use]
pub struct SparseImageFormatProperties {
    pub aspect_mask: ImageAspectFlags,
    pub image_granularity: Extent3D,
    pub flags: SparseImageFormatFlags,
}
impl SparseImageFormatProperties {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.aspect_mask = aspect_mask;
        self
    }
    #[inline]
    pub fn image_granularity(mut self, image_granularity: Extent3D) -> Self {
        self.image_granularity = image_granularity;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: SparseImageFormatFlags) -> Self {
        self.flags = flags;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSparseImageMemoryRequirements.html>"]
#[must_use]
pub struct SparseImageMemoryRequirements {
    pub format_properties: SparseImageFormatProperties,
    pub image_mip_tail_first_lod: u32,
    pub image_mip_tail_size: DeviceSize,
    pub image_mip_tail_offset: DeviceSize,
    pub image_mip_tail_stride: DeviceSize,
}
impl SparseImageMemoryRequirements {
    #[inline]
    pub fn format_properties(mut self, format_properties: SparseImageFormatProperties) -> Self {
        self.format_properties = format_properties;
        self
    }
    #[inline]
    pub fn image_mip_tail_first_lod(mut self, image_mip_tail_first_lod: u32) -> Self {
        self.image_mip_tail_first_lod = image_mip_tail_first_lod;
        self
    }
    #[inline]
    pub fn image_mip_tail_size(mut self, image_mip_tail_size: DeviceSize) -> Self {
        self.image_mip_tail_size = image_mip_tail_size;
        self
    }
    #[inline]
    pub fn image_mip_tail_offset(mut self, image_mip_tail_offset: DeviceSize) -> Self {
        self.image_mip_tail_offset = image_mip_tail_offset;
        self
    }
    #[inline]
    pub fn image_mip_tail_stride(mut self, image_mip_tail_stride: DeviceSize) -> Self {
        self.image_mip_tail_stride = image_mip_tail_stride;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryType.html>"]
#[must_use]
pub struct MemoryType {
    pub property_flags: MemoryPropertyFlags,
    pub heap_index: u32,
}
impl MemoryType {
    #[inline]
    pub fn property_flags(mut self, property_flags: MemoryPropertyFlags) -> Self {
        self.property_flags = property_flags;
        self
    }
    #[inline]
    pub fn heap_index(mut self, heap_index: u32) -> Self {
        self.heap_index = heap_index;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryHeap.html>"]
#[must_use]
pub struct MemoryHeap {
    pub size: DeviceSize,
    pub flags: MemoryHeapFlags,
}
impl MemoryHeap {
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.size = size;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: MemoryHeapFlags) -> Self {
        self.flags = flags;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMappedMemoryRange.html>"]
#[must_use]
pub struct MappedMemoryRange<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub memory: DeviceMemory,
    pub offset: DeviceSize,
    pub size: DeviceSize,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MappedMemoryRange<'_> {}
unsafe impl Sync for MappedMemoryRange<'_> {}
impl ::core::default::Default for MappedMemoryRange<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            memory: DeviceMemory::default(),
            offset: DeviceSize::default(),
            size: DeviceSize::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MappedMemoryRange<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MAPPED_MEMORY_RANGE;
}
impl<'a> MappedMemoryRange<'a> {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.memory = memory;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.size = size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkFormatProperties.html>"]
#[must_use]
pub struct FormatProperties {
    pub linear_tiling_features: FormatFeatureFlags,
    pub optimal_tiling_features: FormatFeatureFlags,
    pub buffer_features: FormatFeatureFlags,
}
impl FormatProperties {
    #[inline]
    pub fn linear_tiling_features(mut self, linear_tiling_features: FormatFeatureFlags) -> Self {
        self.linear_tiling_features = linear_tiling_features;
        self
    }
    #[inline]
    pub fn optimal_tiling_features(mut self, optimal_tiling_features: FormatFeatureFlags) -> Self {
        self.optimal_tiling_features = optimal_tiling_features;
        self
    }
    #[inline]
    pub fn buffer_features(mut self, buffer_features: FormatFeatureFlags) -> Self {
        self.buffer_features = buffer_features;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageFormatProperties.html>"]
#[must_use]
pub struct ImageFormatProperties {
    pub max_extent: Extent3D,
    pub max_mip_levels: u32,
    pub max_array_layers: u32,
    pub sample_counts: SampleCountFlags,
    pub max_resource_size: DeviceSize,
}
impl ImageFormatProperties {
    #[inline]
    pub fn max_extent(mut self, max_extent: Extent3D) -> Self {
        self.max_extent = max_extent;
        self
    }
    #[inline]
    pub fn max_mip_levels(mut self, max_mip_levels: u32) -> Self {
        self.max_mip_levels = max_mip_levels;
        self
    }
    #[inline]
    pub fn max_array_layers(mut self, max_array_layers: u32) -> Self {
        self.max_array_layers = max_array_layers;
        self
    }
    #[inline]
    pub fn sample_counts(mut self, sample_counts: SampleCountFlags) -> Self {
        self.sample_counts = sample_counts;
        self
    }
    #[inline]
    pub fn max_resource_size(mut self, max_resource_size: DeviceSize) -> Self {
        self.max_resource_size = max_resource_size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorBufferInfo.html>"]
#[must_use]
pub struct DescriptorBufferInfo {
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub range: DeviceSize,
}
impl DescriptorBufferInfo {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.buffer = buffer;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn range(mut self, range: DeviceSize) -> Self {
        self.range = range;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorImageInfo.html>"]
#[must_use]
pub struct DescriptorImageInfo {
    pub sampler: Sampler,
    pub image_view: ImageView,
    pub image_layout: ImageLayout,
}
impl DescriptorImageInfo {
    #[inline]
    pub fn sampler(mut self, sampler: Sampler) -> Self {
        self.sampler = sampler;
        self
    }
    #[inline]
    pub fn image_view(mut self, image_view: ImageView) -> Self {
        self.image_view = image_view;
        self
    }
    #[inline]
    pub fn image_layout(mut self, image_layout: ImageLayout) -> Self {
        self.image_layout = image_layout;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkWriteDescriptorSet.html>"]
#[must_use]
pub struct WriteDescriptorSet<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub dst_set: DescriptorSet,
    pub dst_binding: u32,
    pub dst_array_element: u32,
    pub descriptor_count: u32,
    pub descriptor_type: DescriptorType,
    pub p_image_info: *const DescriptorImageInfo,
    pub p_buffer_info: *const DescriptorBufferInfo,
    pub p_texel_buffer_view: *const BufferView,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for WriteDescriptorSet<'_> {}
unsafe impl Sync for WriteDescriptorSet<'_> {}
impl ::core::default::Default for WriteDescriptorSet<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            dst_set: DescriptorSet::default(),
            dst_binding: u32::default(),
            dst_array_element: u32::default(),
            descriptor_count: u32::default(),
            descriptor_type: DescriptorType::default(),
            p_image_info: ::core::ptr::null(),
            p_buffer_info: ::core::ptr::null(),
            p_texel_buffer_view: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for WriteDescriptorSet<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::WRITE_DESCRIPTOR_SET;
}
pub unsafe trait ExtendsWriteDescriptorSet {}
impl<'a> WriteDescriptorSet<'a> {
    #[inline]
    pub fn dst_set(mut self, dst_set: DescriptorSet) -> Self {
        self.dst_set = dst_set;
        self
    }
    #[inline]
    pub fn dst_binding(mut self, dst_binding: u32) -> Self {
        self.dst_binding = dst_binding;
        self
    }
    #[inline]
    pub fn dst_array_element(mut self, dst_array_element: u32) -> Self {
        self.dst_array_element = dst_array_element;
        self
    }
    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.descriptor_count = descriptor_count;
        self
    }
    #[inline]
    pub fn descriptor_type(mut self, descriptor_type: DescriptorType) -> Self {
        self.descriptor_type = descriptor_type;
        self
    }
    #[inline]
    pub fn image_info(mut self, image_info: &'a [DescriptorImageInfo]) -> Self {
        self.descriptor_count = image_info.len() as _;
        self.p_image_info = image_info.as_ptr();
        self
    }
    #[inline]
    pub fn buffer_info(mut self, buffer_info: &'a [DescriptorBufferInfo]) -> Self {
        self.descriptor_count = buffer_info.len() as _;
        self.p_buffer_info = buffer_info.as_ptr();
        self
    }
    #[inline]
    pub fn texel_buffer_view(mut self, texel_buffer_view: &'a [BufferView]) -> Self {
        self.descriptor_count = texel_buffer_view.len() as _;
        self.p_texel_buffer_view = texel_buffer_view.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsWriteDescriptorSet + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCopyDescriptorSet.html>"]
#[must_use]
pub struct CopyDescriptorSet<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_set: DescriptorSet,
    pub src_binding: u32,
    pub src_array_element: u32,
    pub dst_set: DescriptorSet,
    pub dst_binding: u32,
    pub dst_array_element: u32,
    pub descriptor_count: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for CopyDescriptorSet<'_> {}
unsafe impl Sync for CopyDescriptorSet<'_> {}
impl ::core::default::Default for CopyDescriptorSet<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            src_set: DescriptorSet::default(),
            src_binding: u32::default(),
            src_array_element: u32::default(),
            dst_set: DescriptorSet::default(),
            dst_binding: u32::default(),
            dst_array_element: u32::default(),
            descriptor_count: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for CopyDescriptorSet<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::COPY_DESCRIPTOR_SET;
}
impl<'a> CopyDescriptorSet<'a> {
    #[inline]
    pub fn src_set(mut self, src_set: DescriptorSet) -> Self {
        self.src_set = src_set;
        self
    }
    #[inline]
    pub fn src_binding(mut self, src_binding: u32) -> Self {
        self.src_binding = src_binding;
        self
    }
    #[inline]
    pub fn src_array_element(mut self, src_array_element: u32) -> Self {
        self.src_array_element = src_array_element;
        self
    }
    #[inline]
    pub fn dst_set(mut self, dst_set: DescriptorSet) -> Self {
        self.dst_set = dst_set;
        self
    }
    #[inline]
    pub fn dst_binding(mut self, dst_binding: u32) -> Self {
        self.dst_binding = dst_binding;
        self
    }
    #[inline]
    pub fn dst_array_element(mut self, dst_array_element: u32) -> Self {
        self.dst_array_element = dst_array_element;
        self
    }
    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.descriptor_count = descriptor_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBufferUsageFlags2CreateInfoKHR.html>"]
#[must_use]
pub struct BufferUsageFlags2CreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub usage: BufferUsageFlags2KHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BufferUsageFlags2CreateInfoKHR<'_> {}
unsafe impl Sync for BufferUsageFlags2CreateInfoKHR<'_> {}
impl ::core::default::Default for BufferUsageFlags2CreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            usage: BufferUsageFlags2KHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BufferUsageFlags2CreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BUFFER_USAGE_FLAGS_2_CREATE_INFO_KHR;
}
unsafe impl ExtendsBufferViewCreateInfo for BufferUsageFlags2CreateInfoKHR<'_> {}
unsafe impl ExtendsBufferCreateInfo for BufferUsageFlags2CreateInfoKHR<'_> {}
unsafe impl ExtendsPhysicalDeviceExternalBufferInfo for BufferUsageFlags2CreateInfoKHR<'_> {}
unsafe impl ExtendsDescriptorBufferBindingInfoEXT for BufferUsageFlags2CreateInfoKHR<'_> {}
impl<'a> BufferUsageFlags2CreateInfoKHR<'a> {
    #[inline]
    pub fn usage(mut self, usage: BufferUsageFlags2KHR) -> Self {
        self.usage = usage;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBufferCreateInfo.html>"]
#[must_use]
pub struct BufferCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: BufferCreateFlags,
    pub size: DeviceSize,
    pub usage: BufferUsageFlags,
    pub sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub p_queue_family_indices: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BufferCreateInfo<'_> {}
unsafe impl Sync for BufferCreateInfo<'_> {}
impl ::core::default::Default for BufferCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: BufferCreateFlags::default(),
            size: DeviceSize::default(),
            usage: BufferUsageFlags::default(),
            sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            p_queue_family_indices: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BufferCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BUFFER_CREATE_INFO;
}
pub unsafe trait ExtendsBufferCreateInfo {}
impl<'a> BufferCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: BufferCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.size = size;
        self
    }
    #[inline]
    pub fn usage(mut self, usage: BufferUsageFlags) -> Self {
        self.usage = usage;
        self
    }
    #[inline]
    pub fn sharing_mode(mut self, sharing_mode: SharingMode) -> Self {
        self.sharing_mode = sharing_mode;
        self
    }
    #[inline]
    pub fn queue_family_indices(mut self, queue_family_indices: &'a [u32]) -> Self {
        self.queue_family_index_count = queue_family_indices.len() as _;
        self.p_queue_family_indices = queue_family_indices.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBufferCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBufferViewCreateInfo.html>"]
#[must_use]
pub struct BufferViewCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: BufferViewCreateFlags,
    pub buffer: Buffer,
    pub format: Format,
    pub offset: DeviceSize,
    pub range: DeviceSize,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BufferViewCreateInfo<'_> {}
unsafe impl Sync for BufferViewCreateInfo<'_> {}
impl ::core::default::Default for BufferViewCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: BufferViewCreateFlags::default(),
            buffer: Buffer::default(),
            format: Format::default(),
            offset: DeviceSize::default(),
            range: DeviceSize::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BufferViewCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BUFFER_VIEW_CREATE_INFO;
}
pub unsafe trait ExtendsBufferViewCreateInfo {}
impl<'a> BufferViewCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: BufferViewCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.buffer = buffer;
        self
    }
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.format = format;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn range(mut self, range: DeviceSize) -> Self {
        self.range = range;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBufferViewCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageSubresource.html>"]
#[must_use]
pub struct ImageSubresource {
    pub aspect_mask: ImageAspectFlags,
    pub mip_level: u32,
    pub array_layer: u32,
}
impl ImageSubresource {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.aspect_mask = aspect_mask;
        self
    }
    #[inline]
    pub fn mip_level(mut self, mip_level: u32) -> Self {
        self.mip_level = mip_level;
        self
    }
    #[inline]
    pub fn array_layer(mut self, array_layer: u32) -> Self {
        self.array_layer = array_layer;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageSubresourceLayers.html>"]
#[must_use]
pub struct ImageSubresourceLayers {
    pub aspect_mask: ImageAspectFlags,
    pub mip_level: u32,
    pub base_array_layer: u32,
    pub layer_count: u32,
}
impl ImageSubresourceLayers {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.aspect_mask = aspect_mask;
        self
    }
    #[inline]
    pub fn mip_level(mut self, mip_level: u32) -> Self {
        self.mip_level = mip_level;
        self
    }
    #[inline]
    pub fn base_array_layer(mut self, base_array_layer: u32) -> Self {
        self.base_array_layer = base_array_layer;
        self
    }
    #[inline]
    pub fn layer_count(mut self, layer_count: u32) -> Self {
        self.layer_count = layer_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageSubresourceRange.html>"]
#[must_use]
pub struct ImageSubresourceRange {
    pub aspect_mask: ImageAspectFlags,
    pub base_mip_level: u32,
    pub level_count: u32,
    pub base_array_layer: u32,
    pub layer_count: u32,
}
impl ImageSubresourceRange {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.aspect_mask = aspect_mask;
        self
    }
    #[inline]
    pub fn base_mip_level(mut self, base_mip_level: u32) -> Self {
        self.base_mip_level = base_mip_level;
        self
    }
    #[inline]
    pub fn level_count(mut self, level_count: u32) -> Self {
        self.level_count = level_count;
        self
    }
    #[inline]
    pub fn base_array_layer(mut self, base_array_layer: u32) -> Self {
        self.base_array_layer = base_array_layer;
        self
    }
    #[inline]
    pub fn layer_count(mut self, layer_count: u32) -> Self {
        self.layer_count = layer_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryBarrier.html>"]
#[must_use]
pub struct MemoryBarrier<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryBarrier<'_> {}
unsafe impl Sync for MemoryBarrier<'_> {}
impl ::core::default::Default for MemoryBarrier<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryBarrier<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_BARRIER;
}
impl<'a> MemoryBarrier<'a> {
    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> Self {
        self.src_access_mask = src_access_mask;
        self
    }
    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> Self {
        self.dst_access_mask = dst_access_mask;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBufferMemoryBarrier.html>"]
#[must_use]
pub struct BufferMemoryBarrier<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub src_queue_family_index: u32,
    pub dst_queue_family_index: u32,
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub size: DeviceSize,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BufferMemoryBarrier<'_> {}
unsafe impl Sync for BufferMemoryBarrier<'_> {}
impl ::core::default::Default for BufferMemoryBarrier<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
            src_queue_family_index: u32::default(),
            dst_queue_family_index: u32::default(),
            buffer: Buffer::default(),
            offset: DeviceSize::default(),
            size: DeviceSize::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BufferMemoryBarrier<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BUFFER_MEMORY_BARRIER;
}
pub unsafe trait ExtendsBufferMemoryBarrier {}
impl<'a> BufferMemoryBarrier<'a> {
    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> Self {
        self.src_access_mask = src_access_mask;
        self
    }
    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> Self {
        self.dst_access_mask = dst_access_mask;
        self
    }
    #[inline]
    pub fn src_queue_family_index(mut self, src_queue_family_index: u32) -> Self {
        self.src_queue_family_index = src_queue_family_index;
        self
    }
    #[inline]
    pub fn dst_queue_family_index(mut self, dst_queue_family_index: u32) -> Self {
        self.dst_queue_family_index = dst_queue_family_index;
        self
    }
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.buffer = buffer;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.size = size;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBufferMemoryBarrier + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageMemoryBarrier.html>"]
#[must_use]
pub struct ImageMemoryBarrier<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub old_layout: ImageLayout,
    pub new_layout: ImageLayout,
    pub src_queue_family_index: u32,
    pub dst_queue_family_index: u32,
    pub image: Image,
    pub subresource_range: ImageSubresourceRange,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageMemoryBarrier<'_> {}
unsafe impl Sync for ImageMemoryBarrier<'_> {}
impl ::core::default::Default for ImageMemoryBarrier<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
            old_layout: ImageLayout::default(),
            new_layout: ImageLayout::default(),
            src_queue_family_index: u32::default(),
            dst_queue_family_index: u32::default(),
            image: Image::default(),
            subresource_range: ImageSubresourceRange::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageMemoryBarrier<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_MEMORY_BARRIER;
}
pub unsafe trait ExtendsImageMemoryBarrier {}
impl<'a> ImageMemoryBarrier<'a> {
    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> Self {
        self.src_access_mask = src_access_mask;
        self
    }
    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> Self {
        self.dst_access_mask = dst_access_mask;
        self
    }
    #[inline]
    pub fn old_layout(mut self, old_layout: ImageLayout) -> Self {
        self.old_layout = old_layout;
        self
    }
    #[inline]
    pub fn new_layout(mut self, new_layout: ImageLayout) -> Self {
        self.new_layout = new_layout;
        self
    }
    #[inline]
    pub fn src_queue_family_index(mut self, src_queue_family_index: u32) -> Self {
        self.src_queue_family_index = src_queue_family_index;
        self
    }
    #[inline]
    pub fn dst_queue_family_index(mut self, dst_queue_family_index: u32) -> Self {
        self.dst_queue_family_index = dst_queue_family_index;
        self
    }
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.image = image;
        self
    }
    #[inline]
    pub fn subresource_range(mut self, subresource_range: ImageSubresourceRange) -> Self {
        self.subresource_range = subresource_range;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageMemoryBarrier + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageCreateInfo.html>"]
#[must_use]
pub struct ImageCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ImageCreateFlags,
    pub image_type: ImageType,
    pub format: Format,
    pub extent: Extent3D,
    pub mip_levels: u32,
    pub array_layers: u32,
    pub samples: SampleCountFlags,
    pub tiling: ImageTiling,
    pub usage: ImageUsageFlags,
    pub sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub p_queue_family_indices: *const u32,
    pub initial_layout: ImageLayout,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageCreateInfo<'_> {}
unsafe impl Sync for ImageCreateInfo<'_> {}
impl ::core::default::Default for ImageCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: ImageCreateFlags::default(),
            image_type: ImageType::default(),
            format: Format::default(),
            extent: Extent3D::default(),
            mip_levels: u32::default(),
            array_layers: u32::default(),
            samples: SampleCountFlags::default(),
            tiling: ImageTiling::default(),
            usage: ImageUsageFlags::default(),
            sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            p_queue_family_indices: ::core::ptr::null(),
            initial_layout: ImageLayout::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_CREATE_INFO;
}
pub unsafe trait ExtendsImageCreateInfo {}
impl<'a> ImageCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: ImageCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn image_type(mut self, image_type: ImageType) -> Self {
        self.image_type = image_type;
        self
    }
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.format = format;
        self
    }
    #[inline]
    pub fn extent(mut self, extent: Extent3D) -> Self {
        self.extent = extent;
        self
    }
    #[inline]
    pub fn mip_levels(mut self, mip_levels: u32) -> Self {
        self.mip_levels = mip_levels;
        self
    }
    #[inline]
    pub fn array_layers(mut self, array_layers: u32) -> Self {
        self.array_layers = array_layers;
        self
    }
    #[inline]
    pub fn samples(mut self, samples: SampleCountFlags) -> Self {
        self.samples = samples;
        self
    }
    #[inline]
    pub fn tiling(mut self, tiling: ImageTiling) -> Self {
        self.tiling = tiling;
        self
    }
    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.usage = usage;
        self
    }
    #[inline]
    pub fn sharing_mode(mut self, sharing_mode: SharingMode) -> Self {
        self.sharing_mode = sharing_mode;
        self
    }
    #[inline]
    pub fn queue_family_indices(mut self, queue_family_indices: &'a [u32]) -> Self {
        self.queue_family_index_count = queue_family_indices.len() as _;
        self.p_queue_family_indices = queue_family_indices.as_ptr();
        self
    }
    #[inline]
    pub fn initial_layout(mut self, initial_layout: ImageLayout) -> Self {
        self.initial_layout = initial_layout;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSubresourceLayout.html>"]
#[must_use]
pub struct SubresourceLayout {
    pub offset: DeviceSize,
    pub size: DeviceSize,
    pub row_pitch: DeviceSize,
    pub array_pitch: DeviceSize,
    pub depth_pitch: DeviceSize,
}
impl SubresourceLayout {
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.size = size;
        self
    }
    #[inline]
    pub fn row_pitch(mut self, row_pitch: DeviceSize) -> Self {
        self.row_pitch = row_pitch;
        self
    }
    #[inline]
    pub fn array_pitch(mut self, array_pitch: DeviceSize) -> Self {
        self.array_pitch = array_pitch;
        self
    }
    #[inline]
    pub fn depth_pitch(mut self, depth_pitch: DeviceSize) -> Self {
        self.depth_pitch = depth_pitch;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageViewCreateInfo.html>"]
#[must_use]
pub struct ImageViewCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ImageViewCreateFlags,
    pub image: Image,
    pub view_type: ImageViewType,
    pub format: Format,
    pub components: ComponentMapping,
    pub subresource_range: ImageSubresourceRange,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageViewCreateInfo<'_> {}
unsafe impl Sync for ImageViewCreateInfo<'_> {}
impl ::core::default::Default for ImageViewCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: ImageViewCreateFlags::default(),
            image: Image::default(),
            view_type: ImageViewType::default(),
            format: Format::default(),
            components: ComponentMapping::default(),
            subresource_range: ImageSubresourceRange::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageViewCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_VIEW_CREATE_INFO;
}
pub unsafe trait ExtendsImageViewCreateInfo {}
impl<'a> ImageViewCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: ImageViewCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.image = image;
        self
    }
    #[inline]
    pub fn view_type(mut self, view_type: ImageViewType) -> Self {
        self.view_type = view_type;
        self
    }
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.format = format;
        self
    }
    #[inline]
    pub fn components(mut self, components: ComponentMapping) -> Self {
        self.components = components;
        self
    }
    #[inline]
    pub fn subresource_range(mut self, subresource_range: ImageSubresourceRange) -> Self {
        self.subresource_range = subresource_range;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageViewCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBufferCopy.html>"]
#[must_use]
pub struct BufferCopy {
    pub src_offset: DeviceSize,
    pub dst_offset: DeviceSize,
    pub size: DeviceSize,
}
impl BufferCopy {
    #[inline]
    pub fn src_offset(mut self, src_offset: DeviceSize) -> Self {
        self.src_offset = src_offset;
        self
    }
    #[inline]
    pub fn dst_offset(mut self, dst_offset: DeviceSize) -> Self {
        self.dst_offset = dst_offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.size = size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSparseMemoryBind.html>"]
#[must_use]
pub struct SparseMemoryBind {
    pub resource_offset: DeviceSize,
    pub size: DeviceSize,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
    pub flags: SparseMemoryBindFlags,
}
impl SparseMemoryBind {
    #[inline]
    pub fn resource_offset(mut self, resource_offset: DeviceSize) -> Self {
        self.resource_offset = resource_offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.size = size;
        self
    }
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.memory = memory;
        self
    }
    #[inline]
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> Self {
        self.memory_offset = memory_offset;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: SparseMemoryBindFlags) -> Self {
        self.flags = flags;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSparseImageMemoryBind.html>"]
#[must_use]
pub struct SparseImageMemoryBind {
    pub subresource: ImageSubresource,
    pub offset: Offset3D,
    pub extent: Extent3D,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
    pub flags: SparseMemoryBindFlags,
}
impl SparseImageMemoryBind {
    #[inline]
    pub fn subresource(mut self, subresource: ImageSubresource) -> Self {
        self.subresource = subresource;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: Offset3D) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn extent(mut self, extent: Extent3D) -> Self {
        self.extent = extent;
        self
    }
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.memory = memory;
        self
    }
    #[inline]
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> Self {
        self.memory_offset = memory_offset;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: SparseMemoryBindFlags) -> Self {
        self.flags = flags;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSparseBufferMemoryBindInfo.html>"]
#[must_use]
pub struct SparseBufferMemoryBindInfo<'a> {
    pub buffer: Buffer,
    pub bind_count: u32,
    pub p_binds: *const SparseMemoryBind,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SparseBufferMemoryBindInfo<'_> {}
unsafe impl Sync for SparseBufferMemoryBindInfo<'_> {}
impl ::core::default::Default for SparseBufferMemoryBindInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            buffer: Buffer::default(),
            bind_count: u32::default(),
            p_binds: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
impl<'a> SparseBufferMemoryBindInfo<'a> {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.buffer = buffer;
        self
    }
    #[inline]
    pub fn binds(mut self, binds: &'a [SparseMemoryBind]) -> Self {
        self.bind_count = binds.len() as _;
        self.p_binds = binds.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSparseImageOpaqueMemoryBindInfo.html>"]
#[must_use]
pub struct SparseImageOpaqueMemoryBindInfo<'a> {
    pub image: Image,
    pub bind_count: u32,
    pub p_binds: *const SparseMemoryBind,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SparseImageOpaqueMemoryBindInfo<'_> {}
unsafe impl Sync for SparseImageOpaqueMemoryBindInfo<'_> {}
impl ::core::default::Default for SparseImageOpaqueMemoryBindInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            image: Image::default(),
            bind_count: u32::default(),
            p_binds: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
impl<'a> SparseImageOpaqueMemoryBindInfo<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.image = image;
        self
    }
    #[inline]
    pub fn binds(mut self, binds: &'a [SparseMemoryBind]) -> Self {
        self.bind_count = binds.len() as _;
        self.p_binds = binds.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSparseImageMemoryBindInfo.html>"]
#[must_use]
pub struct SparseImageMemoryBindInfo<'a> {
    pub image: Image,
    pub bind_count: u32,
    pub p_binds: *const SparseImageMemoryBind,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SparseImageMemoryBindInfo<'_> {}
unsafe impl Sync for SparseImageMemoryBindInfo<'_> {}
impl ::core::default::Default for SparseImageMemoryBindInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            image: Image::default(),
            bind_count: u32::default(),
            p_binds: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
impl<'a> SparseImageMemoryBindInfo<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.image = image;
        self
    }
    #[inline]
    pub fn binds(mut self, binds: &'a [SparseImageMemoryBind]) -> Self {
        self.bind_count = binds.len() as _;
        self.p_binds = binds.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBindSparseInfo.html>"]
#[must_use]
pub struct BindSparseInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_count: u32,
    pub p_wait_semaphores: *const Semaphore,
    pub buffer_bind_count: u32,
    pub p_buffer_binds: *const SparseBufferMemoryBindInfo<'a>,
    pub image_opaque_bind_count: u32,
    pub p_image_opaque_binds: *const SparseImageOpaqueMemoryBindInfo<'a>,
    pub image_bind_count: u32,
    pub p_image_binds: *const SparseImageMemoryBindInfo<'a>,
    pub signal_semaphore_count: u32,
    pub p_signal_semaphores: *const Semaphore,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BindSparseInfo<'_> {}
unsafe impl Sync for BindSparseInfo<'_> {}
impl ::core::default::Default for BindSparseInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            wait_semaphore_count: u32::default(),
            p_wait_semaphores: ::core::ptr::null(),
            buffer_bind_count: u32::default(),
            p_buffer_binds: ::core::ptr::null(),
            image_opaque_bind_count: u32::default(),
            p_image_opaque_binds: ::core::ptr::null(),
            image_bind_count: u32::default(),
            p_image_binds: ::core::ptr::null(),
            signal_semaphore_count: u32::default(),
            p_signal_semaphores: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BindSparseInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_SPARSE_INFO;
}
pub unsafe trait ExtendsBindSparseInfo {}
impl<'a> BindSparseInfo<'a> {
    #[inline]
    pub fn wait_semaphores(mut self, wait_semaphores: &'a [Semaphore]) -> Self {
        self.wait_semaphore_count = wait_semaphores.len() as _;
        self.p_wait_semaphores = wait_semaphores.as_ptr();
        self
    }
    #[inline]
    pub fn buffer_binds(mut self, buffer_binds: &'a [SparseBufferMemoryBindInfo<'a>]) -> Self {
        self.buffer_bind_count = buffer_binds.len() as _;
        self.p_buffer_binds = buffer_binds.as_ptr();
        self
    }
    #[inline]
    pub fn image_opaque_binds(
        mut self,
        image_opaque_binds: &'a [SparseImageOpaqueMemoryBindInfo<'a>],
    ) -> Self {
        self.image_opaque_bind_count = image_opaque_binds.len() as _;
        self.p_image_opaque_binds = image_opaque_binds.as_ptr();
        self
    }
    #[inline]
    pub fn image_binds(mut self, image_binds: &'a [SparseImageMemoryBindInfo<'a>]) -> Self {
        self.image_bind_count = image_binds.len() as _;
        self.p_image_binds = image_binds.as_ptr();
        self
    }
    #[inline]
    pub fn signal_semaphores(mut self, signal_semaphores: &'a [Semaphore]) -> Self {
        self.signal_semaphore_count = signal_semaphores.len() as _;
        self.p_signal_semaphores = signal_semaphores.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBindSparseInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageCopy.html>"]
#[must_use]
pub struct ImageCopy {
    pub src_subresource: ImageSubresourceLayers,
    pub src_offset: Offset3D,
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offset: Offset3D,
    pub extent: Extent3D,
}
impl ImageCopy {
    #[inline]
    pub fn src_subresource(mut self, src_subresource: ImageSubresourceLayers) -> Self {
        self.src_subresource = src_subresource;
        self
    }
    #[inline]
    pub fn src_offset(mut self, src_offset: Offset3D) -> Self {
        self.src_offset = src_offset;
        self
    }
    #[inline]
    pub fn dst_subresource(mut self, dst_subresource: ImageSubresourceLayers) -> Self {
        self.dst_subresource = dst_subresource;
        self
    }
    #[inline]
    pub fn dst_offset(mut self, dst_offset: Offset3D) -> Self {
        self.dst_offset = dst_offset;
        self
    }
    #[inline]
    pub fn extent(mut self, extent: Extent3D) -> Self {
        self.extent = extent;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageBlit.html>"]
#[must_use]
pub struct ImageBlit {
    pub src_subresource: ImageSubresourceLayers,
    pub src_offsets: [Offset3D; 2],
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offsets: [Offset3D; 2],
}
impl ::core::default::Default for ImageBlit {
    #[inline]
    fn default() -> Self {
        Self {
            src_subresource: ImageSubresourceLayers::default(),
            src_offsets: unsafe { ::core::mem::zeroed() },
            dst_subresource: ImageSubresourceLayers::default(),
            dst_offsets: unsafe { ::core::mem::zeroed() },
        }
    }
}
impl ImageBlit {
    #[inline]
    pub fn src_subresource(mut self, src_subresource: ImageSubresourceLayers) -> Self {
        self.src_subresource = src_subresource;
        self
    }
    #[inline]
    pub fn src_offsets(mut self, src_offsets: [Offset3D; 2]) -> Self {
        self.src_offsets = src_offsets;
        self
    }
    #[inline]
    pub fn dst_subresource(mut self, dst_subresource: ImageSubresourceLayers) -> Self {
        self.dst_subresource = dst_subresource;
        self
    }
    #[inline]
    pub fn dst_offsets(mut self, dst_offsets: [Offset3D; 2]) -> Self {
        self.dst_offsets = dst_offsets;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBufferImageCopy.html>"]
#[must_use]
pub struct BufferImageCopy {
    pub buffer_offset: DeviceSize,
    pub buffer_row_length: u32,
    pub buffer_image_height: u32,
    pub image_subresource: ImageSubresourceLayers,
    pub image_offset: Offset3D,
    pub image_extent: Extent3D,
}
impl BufferImageCopy {
    #[inline]
    pub fn buffer_offset(mut self, buffer_offset: DeviceSize) -> Self {
        self.buffer_offset = buffer_offset;
        self
    }
    #[inline]
    pub fn buffer_row_length(mut self, buffer_row_length: u32) -> Self {
        self.buffer_row_length = buffer_row_length;
        self
    }
    #[inline]
    pub fn buffer_image_height(mut self, buffer_image_height: u32) -> Self {
        self.buffer_image_height = buffer_image_height;
        self
    }
    #[inline]
    pub fn image_subresource(mut self, image_subresource: ImageSubresourceLayers) -> Self {
        self.image_subresource = image_subresource;
        self
    }
    #[inline]
    pub fn image_offset(mut self, image_offset: Offset3D) -> Self {
        self.image_offset = image_offset;
        self
    }
    #[inline]
    pub fn image_extent(mut self, image_extent: Extent3D) -> Self {
        self.image_extent = image_extent;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCopyMemoryIndirectCommandNV.html>"]
#[must_use]
pub struct CopyMemoryIndirectCommandNV {
    pub src_address: DeviceAddress,
    pub dst_address: DeviceAddress,
    pub size: DeviceSize,
}
impl CopyMemoryIndirectCommandNV {
    #[inline]
    pub fn src_address(mut self, src_address: DeviceAddress) -> Self {
        self.src_address = src_address;
        self
    }
    #[inline]
    pub fn dst_address(mut self, dst_address: DeviceAddress) -> Self {
        self.dst_address = dst_address;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.size = size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCopyMemoryToImageIndirectCommandNV.html>"]
#[must_use]
pub struct CopyMemoryToImageIndirectCommandNV {
    pub src_address: DeviceAddress,
    pub buffer_row_length: u32,
    pub buffer_image_height: u32,
    pub image_subresource: ImageSubresourceLayers,
    pub image_offset: Offset3D,
    pub image_extent: Extent3D,
}
impl CopyMemoryToImageIndirectCommandNV {
    #[inline]
    pub fn src_address(mut self, src_address: DeviceAddress) -> Self {
        self.src_address = src_address;
        self
    }
    #[inline]
    pub fn buffer_row_length(mut self, buffer_row_length: u32) -> Self {
        self.buffer_row_length = buffer_row_length;
        self
    }
    #[inline]
    pub fn buffer_image_height(mut self, buffer_image_height: u32) -> Self {
        self.buffer_image_height = buffer_image_height;
        self
    }
    #[inline]
    pub fn image_subresource(mut self, image_subresource: ImageSubresourceLayers) -> Self {
        self.image_subresource = image_subresource;
        self
    }
    #[inline]
    pub fn image_offset(mut self, image_offset: Offset3D) -> Self {
        self.image_offset = image_offset;
        self
    }
    #[inline]
    pub fn image_extent(mut self, image_extent: Extent3D) -> Self {
        self.image_extent = image_extent;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageResolve.html>"]
#[must_use]
pub struct ImageResolve {
    pub src_subresource: ImageSubresourceLayers,
    pub src_offset: Offset3D,
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offset: Offset3D,
    pub extent: Extent3D,
}
impl ImageResolve {
    #[inline]
    pub fn src_subresource(mut self, src_subresource: ImageSubresourceLayers) -> Self {
        self.src_subresource = src_subresource;
        self
    }
    #[inline]
    pub fn src_offset(mut self, src_offset: Offset3D) -> Self {
        self.src_offset = src_offset;
        self
    }
    #[inline]
    pub fn dst_subresource(mut self, dst_subresource: ImageSubresourceLayers) -> Self {
        self.dst_subresource = dst_subresource;
        self
    }
    #[inline]
    pub fn dst_offset(mut self, dst_offset: Offset3D) -> Self {
        self.dst_offset = dst_offset;
        self
    }
    #[inline]
    pub fn extent(mut self, extent: Extent3D) -> Self {
        self.extent = extent;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkShaderModuleCreateInfo.html>"]
#[must_use]
pub struct ShaderModuleCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ShaderModuleCreateFlags,
    pub code_size: usize,
    pub p_code: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ShaderModuleCreateInfo<'_> {}
unsafe impl Sync for ShaderModuleCreateInfo<'_> {}
impl ::core::default::Default for ShaderModuleCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: ShaderModuleCreateFlags::default(),
            code_size: usize::default(),
            p_code: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ShaderModuleCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SHADER_MODULE_CREATE_INFO;
}
unsafe impl ExtendsPipelineShaderStageCreateInfo for ShaderModuleCreateInfo<'_> {}
pub unsafe trait ExtendsShaderModuleCreateInfo {}
impl<'a> ShaderModuleCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: ShaderModuleCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn code(mut self, code: &'a [u32]) -> Self {
        self.code_size = code.len() * 4;
        self.p_code = code.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsShaderModuleCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetLayoutBinding.html>"]
#[must_use]
pub struct DescriptorSetLayoutBinding<'a> {
    pub binding: u32,
    pub descriptor_type: DescriptorType,
    pub descriptor_count: u32,
    pub stage_flags: ShaderStageFlags,
    pub p_immutable_samplers: *const Sampler,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DescriptorSetLayoutBinding<'_> {}
unsafe impl Sync for DescriptorSetLayoutBinding<'_> {}
impl ::core::default::Default for DescriptorSetLayoutBinding<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            binding: u32::default(),
            descriptor_type: DescriptorType::default(),
            descriptor_count: u32::default(),
            stage_flags: ShaderStageFlags::default(),
            p_immutable_samplers: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
impl<'a> DescriptorSetLayoutBinding<'a> {
    #[inline]
    pub fn binding(mut self, binding: u32) -> Self {
        self.binding = binding;
        self
    }
    #[inline]
    pub fn descriptor_type(mut self, descriptor_type: DescriptorType) -> Self {
        self.descriptor_type = descriptor_type;
        self
    }
    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.descriptor_count = descriptor_count;
        self
    }
    #[inline]
    pub fn stage_flags(mut self, stage_flags: ShaderStageFlags) -> Self {
        self.stage_flags = stage_flags;
        self
    }
    #[inline]
    pub fn immutable_samplers(mut self, immutable_samplers: &'a [Sampler]) -> Self {
        self.descriptor_count = immutable_samplers.len() as _;
        self.p_immutable_samplers = immutable_samplers.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetLayoutCreateInfo.html>"]
#[must_use]
pub struct DescriptorSetLayoutCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DescriptorSetLayoutCreateFlags,
    pub binding_count: u32,
    pub p_bindings: *const DescriptorSetLayoutBinding<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DescriptorSetLayoutCreateInfo<'_> {}
unsafe impl Sync for DescriptorSetLayoutCreateInfo<'_> {}
impl ::core::default::Default for DescriptorSetLayoutCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DescriptorSetLayoutCreateFlags::default(),
            binding_count: u32::default(),
            p_bindings: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DescriptorSetLayoutCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DESCRIPTOR_SET_LAYOUT_CREATE_INFO;
}
pub unsafe trait ExtendsDescriptorSetLayoutCreateInfo {}
impl<'a> DescriptorSetLayoutCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: DescriptorSetLayoutCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn bindings(mut self, bindings: &'a [DescriptorSetLayoutBinding<'a>]) -> Self {
        self.binding_count = bindings.len() as _;
        self.p_bindings = bindings.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDescriptorSetLayoutCreateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorPoolSize.html>"]
#[must_use]
pub struct DescriptorPoolSize {
    pub ty: DescriptorType,
    pub descriptor_count: u32,
}
impl DescriptorPoolSize {
    #[inline]
    pub fn ty(mut self, ty: DescriptorType) -> Self {
        self.ty = ty;
        self
    }
    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.descriptor_count = descriptor_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorPoolCreateInfo.html>"]
#[must_use]
pub struct DescriptorPoolCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DescriptorPoolCreateFlags,
    pub max_sets: u32,
    pub pool_size_count: u32,
    pub p_pool_sizes: *const DescriptorPoolSize,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DescriptorPoolCreateInfo<'_> {}
unsafe impl Sync for DescriptorPoolCreateInfo<'_> {}
impl ::core::default::Default for DescriptorPoolCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DescriptorPoolCreateFlags::default(),
            max_sets: u32::default(),
            pool_size_count: u32::default(),
            p_pool_sizes: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DescriptorPoolCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DESCRIPTOR_POOL_CREATE_INFO;
}
pub unsafe trait ExtendsDescriptorPoolCreateInfo {}
impl<'a> DescriptorPoolCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: DescriptorPoolCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn max_sets(mut self, max_sets: u32) -> Self {
        self.max_sets = max_sets;
        self
    }
    #[inline]
    pub fn pool_sizes(mut self, pool_sizes: &'a [DescriptorPoolSize]) -> Self {
        self.pool_size_count = pool_sizes.len() as _;
        self.p_pool_sizes = pool_sizes.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDescriptorPoolCreateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetAllocateInfo.html>"]
#[must_use]
pub struct DescriptorSetAllocateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub descriptor_pool: DescriptorPool,
    pub descriptor_set_count: u32,
    pub p_set_layouts: *const DescriptorSetLayout,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DescriptorSetAllocateInfo<'_> {}
unsafe impl Sync for DescriptorSetAllocateInfo<'_> {}
impl ::core::default::Default for DescriptorSetAllocateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            descriptor_pool: DescriptorPool::default(),
            descriptor_set_count: u32::default(),
            p_set_layouts: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DescriptorSetAllocateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DESCRIPTOR_SET_ALLOCATE_INFO;
}
pub unsafe trait ExtendsDescriptorSetAllocateInfo {}
impl<'a> DescriptorSetAllocateInfo<'a> {
    #[inline]
    pub fn descriptor_pool(mut self, descriptor_pool: DescriptorPool) -> Self {
        self.descriptor_pool = descriptor_pool;
        self
    }
    #[inline]
    pub fn set_layouts(mut self, set_layouts: &'a [DescriptorSetLayout]) -> Self {
        self.descriptor_set_count = set_layouts.len() as _;
        self.p_set_layouts = set_layouts.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDescriptorSetAllocateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSpecializationMapEntry.html>"]
#[must_use]
pub struct SpecializationMapEntry {
    pub constant_id: u32,
    pub offset: u32,
    pub size: usize,
}
impl SpecializationMapEntry {
    #[inline]
    pub fn constant_id(mut self, constant_id: u32) -> Self {
        self.constant_id = constant_id;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: u32) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: usize) -> Self {
        self.size = size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSpecializationInfo.html>"]
#[must_use]
pub struct SpecializationInfo<'a> {
    pub map_entry_count: u32,
    pub p_map_entries: *const SpecializationMapEntry,
    pub data_size: usize,
    pub p_data: *const c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SpecializationInfo<'_> {}
unsafe impl Sync for SpecializationInfo<'_> {}
impl ::core::default::Default for SpecializationInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            map_entry_count: u32::default(),
            p_map_entries: ::core::ptr::null(),
            data_size: usize::default(),
            p_data: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
impl<'a> SpecializationInfo<'a> {
    #[inline]
    pub fn map_entries(mut self, map_entries: &'a [SpecializationMapEntry]) -> Self {
        self.map_entry_count = map_entries.len() as _;
        self.p_map_entries = map_entries.as_ptr();
        self
    }
    #[inline]
    pub fn data(mut self, data: &'a [u8]) -> Self {
        self.data_size = data.len();
        self.p_data = data.as_ptr().cast();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineShaderStageCreateInfo.html>"]
#[must_use]
pub struct PipelineShaderStageCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineShaderStageCreateFlags,
    pub stage: ShaderStageFlags,
    pub module: ShaderModule,
    pub p_name: *const c_char,
    pub p_specialization_info: *const SpecializationInfo<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineShaderStageCreateInfo<'_> {}
unsafe impl Sync for PipelineShaderStageCreateInfo<'_> {}
impl ::core::default::Default for PipelineShaderStageCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineShaderStageCreateFlags::default(),
            stage: ShaderStageFlags::default(),
            module: ShaderModule::default(),
            p_name: ::core::ptr::null(),
            p_specialization_info: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineShaderStageCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_SHADER_STAGE_CREATE_INFO;
}
pub unsafe trait ExtendsPipelineShaderStageCreateInfo {}
impl<'a> PipelineShaderStageCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineShaderStageCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn stage(mut self, stage: ShaderStageFlags) -> Self {
        self.stage = stage;
        self
    }
    #[inline]
    pub fn module(mut self, module: ShaderModule) -> Self {
        self.module = module;
        self
    }
    #[inline]
    pub fn name(mut self, name: &'a CStr) -> Self {
        self.p_name = name.as_ptr();
        self
    }
    #[inline]
    pub unsafe fn name_as_c_str(&self) -> Option<&CStr> {
        if self.p_name.is_null() {
            None
        } else {
            Some(CStr::from_ptr(self.p_name))
        }
    }
    #[inline]
    pub fn specialization_info(mut self, specialization_info: &'a SpecializationInfo<'a>) -> Self {
        self.p_specialization_info = specialization_info;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineShaderStageCreateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkComputePipelineCreateInfo.html>"]
#[must_use]
pub struct ComputePipelineCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage: PipelineShaderStageCreateInfo<'a>,
    pub layout: PipelineLayout,
    pub base_pipeline_handle: Pipeline,
    pub base_pipeline_index: i32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ComputePipelineCreateInfo<'_> {}
unsafe impl Sync for ComputePipelineCreateInfo<'_> {}
impl ::core::default::Default for ComputePipelineCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineCreateFlags::default(),
            stage: PipelineShaderStageCreateInfo::default(),
            layout: PipelineLayout::default(),
            base_pipeline_handle: Pipeline::default(),
            base_pipeline_index: i32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ComputePipelineCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::COMPUTE_PIPELINE_CREATE_INFO;
}
pub unsafe trait ExtendsComputePipelineCreateInfo {}
impl<'a> ComputePipelineCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn stage(mut self, stage: PipelineShaderStageCreateInfo<'a>) -> Self {
        self.stage = stage;
        self
    }
    #[inline]
    pub fn layout(mut self, layout: PipelineLayout) -> Self {
        self.layout = layout;
        self
    }
    #[inline]
    pub fn base_pipeline_handle(mut self, base_pipeline_handle: Pipeline) -> Self {
        self.base_pipeline_handle = base_pipeline_handle;
        self
    }
    #[inline]
    pub fn base_pipeline_index(mut self, base_pipeline_index: i32) -> Self {
        self.base_pipeline_index = base_pipeline_index;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsComputePipelineCreateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkComputePipelineIndirectBufferInfoNV.html>"]
#[must_use]
pub struct ComputePipelineIndirectBufferInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub device_address: DeviceAddress,
    pub size: DeviceSize,
    pub pipeline_device_address_capture_replay: DeviceAddress,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ComputePipelineIndirectBufferInfoNV<'_> {}
unsafe impl Sync for ComputePipelineIndirectBufferInfoNV<'_> {}
impl ::core::default::Default for ComputePipelineIndirectBufferInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            device_address: DeviceAddress::default(),
            size: DeviceSize::default(),
            pipeline_device_address_capture_replay: DeviceAddress::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ComputePipelineIndirectBufferInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::COMPUTE_PIPELINE_INDIRECT_BUFFER_INFO_NV;
}
unsafe impl ExtendsComputePipelineCreateInfo for ComputePipelineIndirectBufferInfoNV<'_> {}
impl<'a> ComputePipelineIndirectBufferInfoNV<'a> {
    #[inline]
    pub fn device_address(mut self, device_address: DeviceAddress) -> Self {
        self.device_address = device_address;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.size = size;
        self
    }
    #[inline]
    pub fn pipeline_device_address_capture_replay(
        mut self,
        pipeline_device_address_capture_replay: DeviceAddress,
    ) -> Self {
        self.pipeline_device_address_capture_replay = pipeline_device_address_capture_replay;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineCreateFlags2CreateInfoKHR.html>"]
#[must_use]
pub struct PipelineCreateFlags2CreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCreateFlags2KHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineCreateFlags2CreateInfoKHR<'_> {}
unsafe impl Sync for PipelineCreateFlags2CreateInfoKHR<'_> {}
impl ::core::default::Default for PipelineCreateFlags2CreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineCreateFlags2KHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineCreateFlags2CreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_CREATE_FLAGS_2_CREATE_INFO_KHR;
}
unsafe impl ExtendsComputePipelineCreateInfo for PipelineCreateFlags2CreateInfoKHR<'_> {}
unsafe impl ExtendsGraphicsPipelineCreateInfo for PipelineCreateFlags2CreateInfoKHR<'_> {}
unsafe impl ExtendsRayTracingPipelineCreateInfoNV for PipelineCreateFlags2CreateInfoKHR<'_> {}
unsafe impl ExtendsRayTracingPipelineCreateInfoKHR for PipelineCreateFlags2CreateInfoKHR<'_> {}
impl<'a> PipelineCreateFlags2CreateInfoKHR<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCreateFlags2KHR) -> Self {
        self.flags = flags;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkVertexInputBindingDescription.html>"]
#[must_use]
pub struct VertexInputBindingDescription {
    pub binding: u32,
    pub stride: u32,
    pub input_rate: VertexInputRate,
}
impl VertexInputBindingDescription {
    #[inline]
    pub fn binding(mut self, binding: u32) -> Self {
        self.binding = binding;
        self
    }
    #[inline]
    pub fn stride(mut self, stride: u32) -> Self {
        self.stride = stride;
        self
    }
    #[inline]
    pub fn input_rate(mut self, input_rate: VertexInputRate) -> Self {
        self.input_rate = input_rate;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkVertexInputAttributeDescription.html>"]
#[must_use]
pub struct VertexInputAttributeDescription {
    pub location: u32,
    pub binding: u32,
    pub format: Format,
    pub offset: u32,
}
impl VertexInputAttributeDescription {
    #[inline]
    pub fn location(mut self, location: u32) -> Self {
        self.location = location;
        self
    }
    #[inline]
    pub fn binding(mut self, binding: u32) -> Self {
        self.binding = binding;
        self
    }
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.format = format;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: u32) -> Self {
        self.offset = offset;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineVertexInputStateCreateInfo.html>"]
#[must_use]
pub struct PipelineVertexInputStateCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineVertexInputStateCreateFlags,
    pub vertex_binding_description_count: u32,
    pub p_vertex_binding_descriptions: *const VertexInputBindingDescription,
    pub vertex_attribute_description_count: u32,
    pub p_vertex_attribute_descriptions: *const VertexInputAttributeDescription,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineVertexInputStateCreateInfo<'_> {}
unsafe impl Sync for PipelineVertexInputStateCreateInfo<'_> {}
impl ::core::default::Default for PipelineVertexInputStateCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineVertexInputStateCreateFlags::default(),
            vertex_binding_description_count: u32::default(),
            p_vertex_binding_descriptions: ::core::ptr::null(),
            vertex_attribute_description_count: u32::default(),
            p_vertex_attribute_descriptions: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineVertexInputStateCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO;
}
pub unsafe trait ExtendsPipelineVertexInputStateCreateInfo {}
impl<'a> PipelineVertexInputStateCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineVertexInputStateCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn vertex_binding_descriptions(
        mut self,
        vertex_binding_descriptions: &'a [VertexInputBindingDescription],
    ) -> Self {
        self.vertex_binding_description_count = vertex_binding_descriptions.len() as _;
        self.p_vertex_binding_descriptions = vertex_binding_descriptions.as_ptr();
        self
    }
    #[inline]
    pub fn vertex_attribute_descriptions(
        mut self,
        vertex_attribute_descriptions: &'a [VertexInputAttributeDescription],
    ) -> Self {
        self.vertex_attribute_description_count = vertex_attribute_descriptions.len() as _;
        self.p_vertex_attribute_descriptions = vertex_attribute_descriptions.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineVertexInputStateCreateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineInputAssemblyStateCreateInfo.html>"]
#[must_use]
pub struct PipelineInputAssemblyStateCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineInputAssemblyStateCreateFlags,
    pub topology: PrimitiveTopology,
    pub primitive_restart_enable: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineInputAssemblyStateCreateInfo<'_> {}
unsafe impl Sync for PipelineInputAssemblyStateCreateInfo<'_> {}
impl ::core::default::Default for PipelineInputAssemblyStateCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineInputAssemblyStateCreateFlags::default(),
            topology: PrimitiveTopology::default(),
            primitive_restart_enable: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineInputAssemblyStateCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO;
}
impl<'a> PipelineInputAssemblyStateCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineInputAssemblyStateCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn topology(mut self, topology: PrimitiveTopology) -> Self {
        self.topology = topology;
        self
    }
    #[inline]
    pub fn primitive_restart_enable(mut self, primitive_restart_enable: bool) -> Self {
        self.primitive_restart_enable = primitive_restart_enable.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineTessellationStateCreateInfo.html>"]
#[must_use]
pub struct PipelineTessellationStateCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineTessellationStateCreateFlags,
    pub patch_control_points: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineTessellationStateCreateInfo<'_> {}
unsafe impl Sync for PipelineTessellationStateCreateInfo<'_> {}
impl ::core::default::Default for PipelineTessellationStateCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineTessellationStateCreateFlags::default(),
            patch_control_points: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineTessellationStateCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_TESSELLATION_STATE_CREATE_INFO;
}
pub unsafe trait ExtendsPipelineTessellationStateCreateInfo {}
impl<'a> PipelineTessellationStateCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineTessellationStateCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn patch_control_points(mut self, patch_control_points: u32) -> Self {
        self.patch_control_points = patch_control_points;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineTessellationStateCreateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportStateCreateInfo.html>"]
#[must_use]
pub struct PipelineViewportStateCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineViewportStateCreateFlags,
    pub viewport_count: u32,
    pub p_viewports: *const Viewport,
    pub scissor_count: u32,
    pub p_scissors: *const Rect2D,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineViewportStateCreateInfo<'_> {}
unsafe impl Sync for PipelineViewportStateCreateInfo<'_> {}
impl ::core::default::Default for PipelineViewportStateCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineViewportStateCreateFlags::default(),
            viewport_count: u32::default(),
            p_viewports: ::core::ptr::null(),
            scissor_count: u32::default(),
            p_scissors: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineViewportStateCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_VIEWPORT_STATE_CREATE_INFO;
}
pub unsafe trait ExtendsPipelineViewportStateCreateInfo {}
impl<'a> PipelineViewportStateCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineViewportStateCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn viewport_count(mut self, viewport_count: u32) -> Self {
        self.viewport_count = viewport_count;
        self
    }
    #[inline]
    pub fn viewports(mut self, viewports: &'a [Viewport]) -> Self {
        self.viewport_count = viewports.len() as _;
        self.p_viewports = viewports.as_ptr();
        self
    }
    #[inline]
    pub fn scissor_count(mut self, scissor_count: u32) -> Self {
        self.scissor_count = scissor_count;
        self
    }
    #[inline]
    pub fn scissors(mut self, scissors: &'a [Rect2D]) -> Self {
        self.scissor_count = scissors.len() as _;
        self.p_scissors = scissors.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineViewportStateCreateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationStateCreateInfo.html>"]
#[must_use]
pub struct PipelineRasterizationStateCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineRasterizationStateCreateFlags,
    pub depth_clamp_enable: Bool32,
    pub rasterizer_discard_enable: Bool32,
    pub polygon_mode: PolygonMode,
    pub cull_mode: CullModeFlags,
    pub front_face: FrontFace,
    pub depth_bias_enable: Bool32,
    pub depth_bias_constant_factor: f32,
    pub depth_bias_clamp: f32,
    pub depth_bias_slope_factor: f32,
    pub line_width: f32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineRasterizationStateCreateInfo<'_> {}
unsafe impl Sync for PipelineRasterizationStateCreateInfo<'_> {}
impl ::core::default::Default for PipelineRasterizationStateCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineRasterizationStateCreateFlags::default(),
            depth_clamp_enable: Bool32::default(),
            rasterizer_discard_enable: Bool32::default(),
            polygon_mode: PolygonMode::default(),
            cull_mode: CullModeFlags::default(),
            front_face: FrontFace::default(),
            depth_bias_enable: Bool32::default(),
            depth_bias_constant_factor: f32::default(),
            depth_bias_clamp: f32::default(),
            depth_bias_slope_factor: f32::default(),
            line_width: f32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineRasterizationStateCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_RASTERIZATION_STATE_CREATE_INFO;
}
pub unsafe trait ExtendsPipelineRasterizationStateCreateInfo {}
impl<'a> PipelineRasterizationStateCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineRasterizationStateCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn depth_clamp_enable(mut self, depth_clamp_enable: bool) -> Self {
        self.depth_clamp_enable = depth_clamp_enable.into();
        self
    }
    #[inline]
    pub fn rasterizer_discard_enable(mut self, rasterizer_discard_enable: bool) -> Self {
        self.rasterizer_discard_enable = rasterizer_discard_enable.into();
        self
    }
    #[inline]
    pub fn polygon_mode(mut self, polygon_mode: PolygonMode) -> Self {
        self.polygon_mode = polygon_mode;
        self
    }
    #[inline]
    pub fn cull_mode(mut self, cull_mode: CullModeFlags) -> Self {
        self.cull_mode = cull_mode;
        self
    }
    #[inline]
    pub fn front_face(mut self, front_face: FrontFace) -> Self {
        self.front_face = front_face;
        self
    }
    #[inline]
    pub fn depth_bias_enable(mut self, depth_bias_enable: bool) -> Self {
        self.depth_bias_enable = depth_bias_enable.into();
        self
    }
    #[inline]
    pub fn depth_bias_constant_factor(mut self, depth_bias_constant_factor: f32) -> Self {
        self.depth_bias_constant_factor = depth_bias_constant_factor;
        self
    }
    #[inline]
    pub fn depth_bias_clamp(mut self, depth_bias_clamp: f32) -> Self {
        self.depth_bias_clamp = depth_bias_clamp;
        self
    }
    #[inline]
    pub fn depth_bias_slope_factor(mut self, depth_bias_slope_factor: f32) -> Self {
        self.depth_bias_slope_factor = depth_bias_slope_factor;
        self
    }
    #[inline]
    pub fn line_width(mut self, line_width: f32) -> Self {
        self.line_width = line_width;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineRasterizationStateCreateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineMultisampleStateCreateInfo.html>"]
#[must_use]
pub struct PipelineMultisampleStateCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineMultisampleStateCreateFlags,
    pub rasterization_samples: SampleCountFlags,
    pub sample_shading_enable: Bool32,
    pub min_sample_shading: f32,
    pub p_sample_mask: *const SampleMask,
    pub alpha_to_coverage_enable: Bool32,
    pub alpha_to_one_enable: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineMultisampleStateCreateInfo<'_> {}
unsafe impl Sync for PipelineMultisampleStateCreateInfo<'_> {}
impl ::core::default::Default for PipelineMultisampleStateCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineMultisampleStateCreateFlags::default(),
            rasterization_samples: SampleCountFlags::default(),
            sample_shading_enable: Bool32::default(),
            min_sample_shading: f32::default(),
            p_sample_mask: ::core::ptr::null(),
            alpha_to_coverage_enable: Bool32::default(),
            alpha_to_one_enable: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineMultisampleStateCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_MULTISAMPLE_STATE_CREATE_INFO;
}
pub unsafe trait ExtendsPipelineMultisampleStateCreateInfo {}
impl<'a> PipelineMultisampleStateCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineMultisampleStateCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn rasterization_samples(mut self, rasterization_samples: SampleCountFlags) -> Self {
        self.rasterization_samples = rasterization_samples;
        self
    }
    #[inline]
    pub fn sample_shading_enable(mut self, sample_shading_enable: bool) -> Self {
        self.sample_shading_enable = sample_shading_enable.into();
        self
    }
    #[inline]
    pub fn min_sample_shading(mut self, min_sample_shading: f32) -> Self {
        self.min_sample_shading = min_sample_shading;
        self
    }
    #[doc = r" Sets `p_sample_mask` to `null` if the slice is empty. The mask will"]
    #[doc = r" be treated as if it has all bits set to `1`."]
    #[doc = r""]
    #[doc = r" See <https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineMultisampleStateCreateInfo.html#_description>"]
    #[doc = r" for more details."]
    #[inline]
    pub fn sample_mask(mut self, sample_mask: &'a [SampleMask]) -> Self {
        self.p_sample_mask = if sample_mask.is_empty() {
            core::ptr::null()
        } else {
            sample_mask.as_ptr()
        };
        self
    }
    #[inline]
    pub fn alpha_to_coverage_enable(mut self, alpha_to_coverage_enable: bool) -> Self {
        self.alpha_to_coverage_enable = alpha_to_coverage_enable.into();
        self
    }
    #[inline]
    pub fn alpha_to_one_enable(mut self, alpha_to_one_enable: bool) -> Self {
        self.alpha_to_one_enable = alpha_to_one_enable.into();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineMultisampleStateCreateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineColorBlendAttachmentState.html>"]
#[must_use]
pub struct PipelineColorBlendAttachmentState {
    pub blend_enable: Bool32,
    pub src_color_blend_factor: BlendFactor,
    pub dst_color_blend_factor: BlendFactor,
    pub color_blend_op: BlendOp,
    pub src_alpha_blend_factor: BlendFactor,
    pub dst_alpha_blend_factor: BlendFactor,
    pub alpha_blend_op: BlendOp,
    pub color_write_mask: ColorComponentFlags,
}
impl PipelineColorBlendAttachmentState {
    #[inline]
    pub fn blend_enable(mut self, blend_enable: bool) -> Self {
        self.blend_enable = blend_enable.into();
        self
    }
    #[inline]
    pub fn src_color_blend_factor(mut self, src_color_blend_factor: BlendFactor) -> Self {
        self.src_color_blend_factor = src_color_blend_factor;
        self
    }
    #[inline]
    pub fn dst_color_blend_factor(mut self, dst_color_blend_factor: BlendFactor) -> Self {
        self.dst_color_blend_factor = dst_color_blend_factor;
        self
    }
    #[inline]
    pub fn color_blend_op(mut self, color_blend_op: BlendOp) -> Self {
        self.color_blend_op = color_blend_op;
        self
    }
    #[inline]
    pub fn src_alpha_blend_factor(mut self, src_alpha_blend_factor: BlendFactor) -> Self {
        self.src_alpha_blend_factor = src_alpha_blend_factor;
        self
    }
    #[inline]
    pub fn dst_alpha_blend_factor(mut self, dst_alpha_blend_factor: BlendFactor) -> Self {
        self.dst_alpha_blend_factor = dst_alpha_blend_factor;
        self
    }
    #[inline]
    pub fn alpha_blend_op(mut self, alpha_blend_op: BlendOp) -> Self {
        self.alpha_blend_op = alpha_blend_op;
        self
    }
    #[inline]
    pub fn color_write_mask(mut self, color_write_mask: ColorComponentFlags) -> Self {
        self.color_write_mask = color_write_mask;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineColorBlendStateCreateInfo.html>"]
#[must_use]
pub struct PipelineColorBlendStateCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineColorBlendStateCreateFlags,
    pub logic_op_enable: Bool32,
    pub logic_op: LogicOp,
    pub attachment_count: u32,
    pub p_attachments: *const PipelineColorBlendAttachmentState,
    pub blend_constants: [f32; 4],
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineColorBlendStateCreateInfo<'_> {}
unsafe impl Sync for PipelineColorBlendStateCreateInfo<'_> {}
impl ::core::default::Default for PipelineColorBlendStateCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineColorBlendStateCreateFlags::default(),
            logic_op_enable: Bool32::default(),
            logic_op: LogicOp::default(),
            attachment_count: u32::default(),
            p_attachments: ::core::ptr::null(),
            blend_constants: unsafe { ::core::mem::zeroed() },
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineColorBlendStateCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_COLOR_BLEND_STATE_CREATE_INFO;
}
pub unsafe trait ExtendsPipelineColorBlendStateCreateInfo {}
impl<'a> PipelineColorBlendStateCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineColorBlendStateCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn logic_op_enable(mut self, logic_op_enable: bool) -> Self {
        self.logic_op_enable = logic_op_enable.into();
        self
    }
    #[inline]
    pub fn logic_op(mut self, logic_op: LogicOp) -> Self {
        self.logic_op = logic_op;
        self
    }
    #[inline]
    pub fn attachments(mut self, attachments: &'a [PipelineColorBlendAttachmentState]) -> Self {
        self.attachment_count = attachments.len() as _;
        self.p_attachments = attachments.as_ptr();
        self
    }
    #[inline]
    pub fn blend_constants(mut self, blend_constants: [f32; 4]) -> Self {
        self.blend_constants = blend_constants;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineColorBlendStateCreateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineDynamicStateCreateInfo.html>"]
#[must_use]
pub struct PipelineDynamicStateCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineDynamicStateCreateFlags,
    pub dynamic_state_count: u32,
    pub p_dynamic_states: *const DynamicState,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineDynamicStateCreateInfo<'_> {}
unsafe impl Sync for PipelineDynamicStateCreateInfo<'_> {}
impl ::core::default::Default for PipelineDynamicStateCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineDynamicStateCreateFlags::default(),
            dynamic_state_count: u32::default(),
            p_dynamic_states: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineDynamicStateCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_DYNAMIC_STATE_CREATE_INFO;
}
impl<'a> PipelineDynamicStateCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineDynamicStateCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn dynamic_states(mut self, dynamic_states: &'a [DynamicState]) -> Self {
        self.dynamic_state_count = dynamic_states.len() as _;
        self.p_dynamic_states = dynamic_states.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkStencilOpState.html>"]
#[must_use]
pub struct StencilOpState {
    pub fail_op: StencilOp,
    pub pass_op: StencilOp,
    pub depth_fail_op: StencilOp,
    pub compare_op: CompareOp,
    pub compare_mask: u32,
    pub write_mask: u32,
    pub reference: u32,
}
impl StencilOpState {
    #[inline]
    pub fn fail_op(mut self, fail_op: StencilOp) -> Self {
        self.fail_op = fail_op;
        self
    }
    #[inline]
    pub fn pass_op(mut self, pass_op: StencilOp) -> Self {
        self.pass_op = pass_op;
        self
    }
    #[inline]
    pub fn depth_fail_op(mut self, depth_fail_op: StencilOp) -> Self {
        self.depth_fail_op = depth_fail_op;
        self
    }
    #[inline]
    pub fn compare_op(mut self, compare_op: CompareOp) -> Self {
        self.compare_op = compare_op;
        self
    }
    #[inline]
    pub fn compare_mask(mut self, compare_mask: u32) -> Self {
        self.compare_mask = compare_mask;
        self
    }
    #[inline]
    pub fn write_mask(mut self, write_mask: u32) -> Self {
        self.write_mask = write_mask;
        self
    }
    #[inline]
    pub fn reference(mut self, reference: u32) -> Self {
        self.reference = reference;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineDepthStencilStateCreateInfo.html>"]
#[must_use]
pub struct PipelineDepthStencilStateCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineDepthStencilStateCreateFlags,
    pub depth_test_enable: Bool32,
    pub depth_write_enable: Bool32,
    pub depth_compare_op: CompareOp,
    pub depth_bounds_test_enable: Bool32,
    pub stencil_test_enable: Bool32,
    pub front: StencilOpState,
    pub back: StencilOpState,
    pub min_depth_bounds: f32,
    pub max_depth_bounds: f32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineDepthStencilStateCreateInfo<'_> {}
unsafe impl Sync for PipelineDepthStencilStateCreateInfo<'_> {}
impl ::core::default::Default for PipelineDepthStencilStateCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineDepthStencilStateCreateFlags::default(),
            depth_test_enable: Bool32::default(),
            depth_write_enable: Bool32::default(),
            depth_compare_op: CompareOp::default(),
            depth_bounds_test_enable: Bool32::default(),
            stencil_test_enable: Bool32::default(),
            front: StencilOpState::default(),
            back: StencilOpState::default(),
            min_depth_bounds: f32::default(),
            max_depth_bounds: f32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineDepthStencilStateCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO;
}
impl<'a> PipelineDepthStencilStateCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineDepthStencilStateCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn depth_test_enable(mut self, depth_test_enable: bool) -> Self {
        self.depth_test_enable = depth_test_enable.into();
        self
    }
    #[inline]
    pub fn depth_write_enable(mut self, depth_write_enable: bool) -> Self {
        self.depth_write_enable = depth_write_enable.into();
        self
    }
    #[inline]
    pub fn depth_compare_op(mut self, depth_compare_op: CompareOp) -> Self {
        self.depth_compare_op = depth_compare_op;
        self
    }
    #[inline]
    pub fn depth_bounds_test_enable(mut self, depth_bounds_test_enable: bool) -> Self {
        self.depth_bounds_test_enable = depth_bounds_test_enable.into();
        self
    }
    #[inline]
    pub fn stencil_test_enable(mut self, stencil_test_enable: bool) -> Self {
        self.stencil_test_enable = stencil_test_enable.into();
        self
    }
    #[inline]
    pub fn front(mut self, front: StencilOpState) -> Self {
        self.front = front;
        self
    }
    #[inline]
    pub fn back(mut self, back: StencilOpState) -> Self {
        self.back = back;
        self
    }
    #[inline]
    pub fn min_depth_bounds(mut self, min_depth_bounds: f32) -> Self {
        self.min_depth_bounds = min_depth_bounds;
        self
    }
    #[inline]
    pub fn max_depth_bounds(mut self, max_depth_bounds: f32) -> Self {
        self.max_depth_bounds = max_depth_bounds;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkGraphicsPipelineCreateInfo.html>"]
#[must_use]
pub struct GraphicsPipelineCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage_count: u32,
    pub p_stages: *const PipelineShaderStageCreateInfo<'a>,
    pub p_vertex_input_state: *const PipelineVertexInputStateCreateInfo<'a>,
    pub p_input_assembly_state: *const PipelineInputAssemblyStateCreateInfo<'a>,
    pub p_tessellation_state: *const PipelineTessellationStateCreateInfo<'a>,
    pub p_viewport_state: *const PipelineViewportStateCreateInfo<'a>,
    pub p_rasterization_state: *const PipelineRasterizationStateCreateInfo<'a>,
    pub p_multisample_state: *const PipelineMultisampleStateCreateInfo<'a>,
    pub p_depth_stencil_state: *const PipelineDepthStencilStateCreateInfo<'a>,
    pub p_color_blend_state: *const PipelineColorBlendStateCreateInfo<'a>,
    pub p_dynamic_state: *const PipelineDynamicStateCreateInfo<'a>,
    pub layout: PipelineLayout,
    pub render_pass: RenderPass,
    pub subpass: u32,
    pub base_pipeline_handle: Pipeline,
    pub base_pipeline_index: i32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for GraphicsPipelineCreateInfo<'_> {}
unsafe impl Sync for GraphicsPipelineCreateInfo<'_> {}
impl ::core::default::Default for GraphicsPipelineCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineCreateFlags::default(),
            stage_count: u32::default(),
            p_stages: ::core::ptr::null(),
            p_vertex_input_state: ::core::ptr::null(),
            p_input_assembly_state: ::core::ptr::null(),
            p_tessellation_state: ::core::ptr::null(),
            p_viewport_state: ::core::ptr::null(),
            p_rasterization_state: ::core::ptr::null(),
            p_multisample_state: ::core::ptr::null(),
            p_depth_stencil_state: ::core::ptr::null(),
            p_color_blend_state: ::core::ptr::null(),
            p_dynamic_state: ::core::ptr::null(),
            layout: PipelineLayout::default(),
            render_pass: RenderPass::default(),
            subpass: u32::default(),
            base_pipeline_handle: Pipeline::default(),
            base_pipeline_index: i32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for GraphicsPipelineCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::GRAPHICS_PIPELINE_CREATE_INFO;
}
pub unsafe trait ExtendsGraphicsPipelineCreateInfo {}
impl<'a> GraphicsPipelineCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn stages(mut self, stages: &'a [PipelineShaderStageCreateInfo<'a>]) -> Self {
        self.stage_count = stages.len() as _;
        self.p_stages = stages.as_ptr();
        self
    }
    #[inline]
    pub fn vertex_input_state(
        mut self,
        vertex_input_state: &'a PipelineVertexInputStateCreateInfo<'a>,
    ) -> Self {
        self.p_vertex_input_state = vertex_input_state;
        self
    }
    #[inline]
    pub fn input_assembly_state(
        mut self,
        input_assembly_state: &'a PipelineInputAssemblyStateCreateInfo<'a>,
    ) -> Self {
        self.p_input_assembly_state = input_assembly_state;
        self
    }
    #[inline]
    pub fn tessellation_state(
        mut self,
        tessellation_state: &'a PipelineTessellationStateCreateInfo<'a>,
    ) -> Self {
        self.p_tessellation_state = tessellation_state;
        self
    }
    #[inline]
    pub fn viewport_state(
        mut self,
        viewport_state: &'a PipelineViewportStateCreateInfo<'a>,
    ) -> Self {
        self.p_viewport_state = viewport_state;
        self
    }
    #[inline]
    pub fn rasterization_state(
        mut self,
        rasterization_state: &'a PipelineRasterizationStateCreateInfo<'a>,
    ) -> Self {
        self.p_rasterization_state = rasterization_state;
        self
    }
    #[inline]
    pub fn multisample_state(
        mut self,
        multisample_state: &'a PipelineMultisampleStateCreateInfo<'a>,
    ) -> Self {
        self.p_multisample_state = multisample_state;
        self
    }
    #[inline]
    pub fn depth_stencil_state(
        mut self,
        depth_stencil_state: &'a PipelineDepthStencilStateCreateInfo<'a>,
    ) -> Self {
        self.p_depth_stencil_state = depth_stencil_state;
        self
    }
    #[inline]
    pub fn color_blend_state(
        mut self,
        color_blend_state: &'a PipelineColorBlendStateCreateInfo<'a>,
    ) -> Self {
        self.p_color_blend_state = color_blend_state;
        self
    }
    #[inline]
    pub fn dynamic_state(mut self, dynamic_state: &'a PipelineDynamicStateCreateInfo<'a>) -> Self {
        self.p_dynamic_state = dynamic_state;
        self
    }
    #[inline]
    pub fn layout(mut self, layout: PipelineLayout) -> Self {
        self.layout = layout;
        self
    }
    #[inline]
    pub fn render_pass(mut self, render_pass: RenderPass) -> Self {
        self.render_pass = render_pass;
        self
    }
    #[inline]
    pub fn subpass(mut self, subpass: u32) -> Self {
        self.subpass = subpass;
        self
    }
    #[inline]
    pub fn base_pipeline_handle(mut self, base_pipeline_handle: Pipeline) -> Self {
        self.base_pipeline_handle = base_pipeline_handle;
        self
    }
    #[inline]
    pub fn base_pipeline_index(mut self, base_pipeline_index: i32) -> Self {
        self.base_pipeline_index = base_pipeline_index;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsGraphicsPipelineCreateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineCacheCreateInfo.html>"]
#[must_use]
pub struct PipelineCacheCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCacheCreateFlags,
    pub initial_data_size: usize,
    pub p_initial_data: *const c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineCacheCreateInfo<'_> {}
unsafe impl Sync for PipelineCacheCreateInfo<'_> {}
impl ::core::default::Default for PipelineCacheCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineCacheCreateFlags::default(),
            initial_data_size: usize::default(),
            p_initial_data: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineCacheCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_CACHE_CREATE_INFO;
}
impl<'a> PipelineCacheCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCacheCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn initial_data(mut self, initial_data: &'a [u8]) -> Self {
        self.initial_data_size = initial_data.len();
        self.p_initial_data = initial_data.as_ptr().cast();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineCacheHeaderVersionOne.html>"]
#[must_use]
pub struct PipelineCacheHeaderVersionOne {
    pub header_size: u32,
    pub header_version: PipelineCacheHeaderVersion,
    pub vendor_id: u32,
    pub device_id: u32,
    pub pipeline_cache_uuid: [u8; UUID_SIZE],
}
impl ::core::default::Default for PipelineCacheHeaderVersionOne {
    #[inline]
    fn default() -> Self {
        Self {
            header_size: u32::default(),
            header_version: PipelineCacheHeaderVersion::default(),
            vendor_id: u32::default(),
            device_id: u32::default(),
            pipeline_cache_uuid: unsafe { ::core::mem::zeroed() },
        }
    }
}
impl PipelineCacheHeaderVersionOne {
    #[inline]
    pub fn header_size(mut self, header_size: u32) -> Self {
        self.header_size = header_size;
        self
    }
    #[inline]
    pub fn header_version(mut self, header_version: PipelineCacheHeaderVersion) -> Self {
        self.header_version = header_version;
        self
    }
    #[inline]
    pub fn vendor_id(mut self, vendor_id: u32) -> Self {
        self.vendor_id = vendor_id;
        self
    }
    #[inline]
    pub fn device_id(mut self, device_id: u32) -> Self {
        self.device_id = device_id;
        self
    }
    #[inline]
    pub fn pipeline_cache_uuid(mut self, pipeline_cache_uuid: [u8; UUID_SIZE]) -> Self {
        self.pipeline_cache_uuid = pipeline_cache_uuid;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPushConstantRange.html>"]
#[must_use]
pub struct PushConstantRange {
    pub stage_flags: ShaderStageFlags,
    pub offset: u32,
    pub size: u32,
}
impl PushConstantRange {
    #[inline]
    pub fn stage_flags(mut self, stage_flags: ShaderStageFlags) -> Self {
        self.stage_flags = stage_flags;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: u32) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: u32) -> Self {
        self.size = size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineLayoutCreateInfo.html>"]
#[must_use]
pub struct PipelineLayoutCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineLayoutCreateFlags,
    pub set_layout_count: u32,
    pub p_set_layouts: *const DescriptorSetLayout,
    pub push_constant_range_count: u32,
    pub p_push_constant_ranges: *const PushConstantRange,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineLayoutCreateInfo<'_> {}
unsafe impl Sync for PipelineLayoutCreateInfo<'_> {}
impl ::core::default::Default for PipelineLayoutCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineLayoutCreateFlags::default(),
            set_layout_count: u32::default(),
            p_set_layouts: ::core::ptr::null(),
            push_constant_range_count: u32::default(),
            p_push_constant_ranges: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineLayoutCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_LAYOUT_CREATE_INFO;
}
unsafe impl ExtendsBindDescriptorSetsInfoKHR for PipelineLayoutCreateInfo<'_> {}
unsafe impl ExtendsPushConstantsInfoKHR for PipelineLayoutCreateInfo<'_> {}
unsafe impl ExtendsPushDescriptorSetInfoKHR for PipelineLayoutCreateInfo<'_> {}
unsafe impl ExtendsPushDescriptorSetWithTemplateInfoKHR for PipelineLayoutCreateInfo<'_> {}
unsafe impl ExtendsSetDescriptorBufferOffsetsInfoEXT for PipelineLayoutCreateInfo<'_> {}
unsafe impl ExtendsBindDescriptorBufferEmbeddedSamplersInfoEXT for PipelineLayoutCreateInfo<'_> {}
impl<'a> PipelineLayoutCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineLayoutCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn set_layouts(mut self, set_layouts: &'a [DescriptorSetLayout]) -> Self {
        self.set_layout_count = set_layouts.len() as _;
        self.p_set_layouts = set_layouts.as_ptr();
        self
    }
    #[inline]
    pub fn push_constant_ranges(mut self, push_constant_ranges: &'a [PushConstantRange]) -> Self {
        self.push_constant_range_count = push_constant_ranges.len() as _;
        self.p_push_constant_ranges = push_constant_ranges.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSamplerCreateInfo.html>"]
#[must_use]
pub struct SamplerCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: SamplerCreateFlags,
    pub mag_filter: Filter,
    pub min_filter: Filter,
    pub mipmap_mode: SamplerMipmapMode,
    pub address_mode_u: SamplerAddressMode,
    pub address_mode_v: SamplerAddressMode,
    pub address_mode_w: SamplerAddressMode,
    pub mip_lod_bias: f32,
    pub anisotropy_enable: Bool32,
    pub max_anisotropy: f32,
    pub compare_enable: Bool32,
    pub compare_op: CompareOp,
    pub min_lod: f32,
    pub max_lod: f32,
    pub border_color: BorderColor,
    pub unnormalized_coordinates: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SamplerCreateInfo<'_> {}
unsafe impl Sync for SamplerCreateInfo<'_> {}
impl ::core::default::Default for SamplerCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: SamplerCreateFlags::default(),
            mag_filter: Filter::default(),
            min_filter: Filter::default(),
            mipmap_mode: SamplerMipmapMode::default(),
            address_mode_u: SamplerAddressMode::default(),
            address_mode_v: SamplerAddressMode::default(),
            address_mode_w: SamplerAddressMode::default(),
            mip_lod_bias: f32::default(),
            anisotropy_enable: Bool32::default(),
            max_anisotropy: f32::default(),
            compare_enable: Bool32::default(),
            compare_op: CompareOp::default(),
            min_lod: f32::default(),
            max_lod: f32::default(),
            border_color: BorderColor::default(),
            unnormalized_coordinates: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SamplerCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SAMPLER_CREATE_INFO;
}
pub unsafe trait ExtendsSamplerCreateInfo {}
impl<'a> SamplerCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: SamplerCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn mag_filter(mut self, mag_filter: Filter) -> Self {
        self.mag_filter = mag_filter;
        self
    }
    #[inline]
    pub fn min_filter(mut self, min_filter: Filter) -> Self {
        self.min_filter = min_filter;
        self
    }
    #[inline]
    pub fn mipmap_mode(mut self, mipmap_mode: SamplerMipmapMode) -> Self {
        self.mipmap_mode = mipmap_mode;
        self
    }
    #[inline]
    pub fn address_mode_u(mut self, address_mode_u: SamplerAddressMode) -> Self {
        self.address_mode_u = address_mode_u;
        self
    }
    #[inline]
    pub fn address_mode_v(mut self, address_mode_v: SamplerAddressMode) -> Self {
        self.address_mode_v = address_mode_v;
        self
    }
    #[inline]
    pub fn address_mode_w(mut self, address_mode_w: SamplerAddressMode) -> Self {
        self.address_mode_w = address_mode_w;
        self
    }
    #[inline]
    pub fn mip_lod_bias(mut self, mip_lod_bias: f32) -> Self {
        self.mip_lod_bias = mip_lod_bias;
        self
    }
    #[inline]
    pub fn anisotropy_enable(mut self, anisotropy_enable: bool) -> Self {
        self.anisotropy_enable = anisotropy_enable.into();
        self
    }
    #[inline]
    pub fn max_anisotropy(mut self, max_anisotropy: f32) -> Self {
        self.max_anisotropy = max_anisotropy;
        self
    }
    #[inline]
    pub fn compare_enable(mut self, compare_enable: bool) -> Self {
        self.compare_enable = compare_enable.into();
        self
    }
    #[inline]
    pub fn compare_op(mut self, compare_op: CompareOp) -> Self {
        self.compare_op = compare_op;
        self
    }
    #[inline]
    pub fn min_lod(mut self, min_lod: f32) -> Self {
        self.min_lod = min_lod;
        self
    }
    #[inline]
    pub fn max_lod(mut self, max_lod: f32) -> Self {
        self.max_lod = max_lod;
        self
    }
    #[inline]
    pub fn border_color(mut self, border_color: BorderColor) -> Self {
        self.border_color = border_color;
        self
    }
    #[inline]
    pub fn unnormalized_coordinates(mut self, unnormalized_coordinates: bool) -> Self {
        self.unnormalized_coordinates = unnormalized_coordinates.into();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSamplerCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCommandPoolCreateInfo.html>"]
#[must_use]
pub struct CommandPoolCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: CommandPoolCreateFlags,
    pub queue_family_index: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for CommandPoolCreateInfo<'_> {}
unsafe impl Sync for CommandPoolCreateInfo<'_> {}
impl ::core::default::Default for CommandPoolCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: CommandPoolCreateFlags::default(),
            queue_family_index: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for CommandPoolCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::COMMAND_POOL_CREATE_INFO;
}
impl<'a> CommandPoolCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: CommandPoolCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn queue_family_index(mut self, queue_family_index: u32) -> Self {
        self.queue_family_index = queue_family_index;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCommandBufferAllocateInfo.html>"]
#[must_use]
pub struct CommandBufferAllocateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub command_pool: CommandPool,
    pub level: CommandBufferLevel,
    pub command_buffer_count: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for CommandBufferAllocateInfo<'_> {}
unsafe impl Sync for CommandBufferAllocateInfo<'_> {}
impl ::core::default::Default for CommandBufferAllocateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            command_pool: CommandPool::default(),
            level: CommandBufferLevel::default(),
            command_buffer_count: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for CommandBufferAllocateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::COMMAND_BUFFER_ALLOCATE_INFO;
}
impl<'a> CommandBufferAllocateInfo<'a> {
    #[inline]
    pub fn command_pool(mut self, command_pool: CommandPool) -> Self {
        self.command_pool = command_pool;
        self
    }
    #[inline]
    pub fn level(mut self, level: CommandBufferLevel) -> Self {
        self.level = level;
        self
    }
    #[inline]
    pub fn command_buffer_count(mut self, command_buffer_count: u32) -> Self {
        self.command_buffer_count = command_buffer_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCommandBufferInheritanceInfo.html>"]
#[must_use]
pub struct CommandBufferInheritanceInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub render_pass: RenderPass,
    pub subpass: u32,
    pub framebuffer: Framebuffer,
    pub occlusion_query_enable: Bool32,
    pub query_flags: QueryControlFlags,
    pub pipeline_statistics: QueryPipelineStatisticFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for CommandBufferInheritanceInfo<'_> {}
unsafe impl Sync for CommandBufferInheritanceInfo<'_> {}
impl ::core::default::Default for CommandBufferInheritanceInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            render_pass: RenderPass::default(),
            subpass: u32::default(),
            framebuffer: Framebuffer::default(),
            occlusion_query_enable: Bool32::default(),
            query_flags: QueryControlFlags::default(),
            pipeline_statistics: QueryPipelineStatisticFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for CommandBufferInheritanceInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::COMMAND_BUFFER_INHERITANCE_INFO;
}
pub unsafe trait ExtendsCommandBufferInheritanceInfo {}
impl<'a> CommandBufferInheritanceInfo<'a> {
    #[inline]
    pub fn render_pass(mut self, render_pass: RenderPass) -> Self {
        self.render_pass = render_pass;
        self
    }
    #[inline]
    pub fn subpass(mut self, subpass: u32) -> Self {
        self.subpass = subpass;
        self
    }
    #[inline]
    pub fn framebuffer(mut self, framebuffer: Framebuffer) -> Self {
        self.framebuffer = framebuffer;
        self
    }
    #[inline]
    pub fn occlusion_query_enable(mut self, occlusion_query_enable: bool) -> Self {
        self.occlusion_query_enable = occlusion_query_enable.into();
        self
    }
    #[inline]
    pub fn query_flags(mut self, query_flags: QueryControlFlags) -> Self {
        self.query_flags = query_flags;
        self
    }
    #[inline]
    pub fn pipeline_statistics(mut self, pipeline_statistics: QueryPipelineStatisticFlags) -> Self {
        self.pipeline_statistics = pipeline_statistics;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsCommandBufferInheritanceInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCommandBufferBeginInfo.html>"]
#[must_use]
pub struct CommandBufferBeginInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: CommandBufferUsageFlags,
    pub p_inheritance_info: *const CommandBufferInheritanceInfo<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for CommandBufferBeginInfo<'_> {}
unsafe impl Sync for CommandBufferBeginInfo<'_> {}
impl ::core::default::Default for CommandBufferBeginInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: CommandBufferUsageFlags::default(),
            p_inheritance_info: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for CommandBufferBeginInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::COMMAND_BUFFER_BEGIN_INFO;
}
pub unsafe trait ExtendsCommandBufferBeginInfo {}
impl<'a> CommandBufferBeginInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: CommandBufferUsageFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn inheritance_info(
        mut self,
        inheritance_info: &'a CommandBufferInheritanceInfo<'a>,
    ) -> Self {
        self.p_inheritance_info = inheritance_info;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsCommandBufferBeginInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRenderPassBeginInfo.html>"]
#[must_use]
pub struct RenderPassBeginInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub render_pass: RenderPass,
    pub framebuffer: Framebuffer,
    pub render_area: Rect2D,
    pub clear_value_count: u32,
    pub p_clear_values: *const ClearValue,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for RenderPassBeginInfo<'_> {}
unsafe impl Sync for RenderPassBeginInfo<'_> {}
#[cfg(feature = "debug")]
impl fmt::Debug for RenderPassBeginInfo<'_> {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("RenderPassBeginInfo")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("render_pass", &self.render_pass)
            .field("framebuffer", &self.framebuffer)
            .field("render_area", &self.render_area)
            .field("clear_value_count", &self.clear_value_count)
            .field("p_clear_values", &"union")
            .finish()
    }
}
impl ::core::default::Default for RenderPassBeginInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            render_pass: RenderPass::default(),
            framebuffer: Framebuffer::default(),
            render_area: Rect2D::default(),
            clear_value_count: u32::default(),
            p_clear_values: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for RenderPassBeginInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::RENDER_PASS_BEGIN_INFO;
}
pub unsafe trait ExtendsRenderPassBeginInfo {}
impl<'a> RenderPassBeginInfo<'a> {
    #[inline]
    pub fn render_pass(mut self, render_pass: RenderPass) -> Self {
        self.render_pass = render_pass;
        self
    }
    #[inline]
    pub fn framebuffer(mut self, framebuffer: Framebuffer) -> Self {
        self.framebuffer = framebuffer;
        self
    }
    #[inline]
    pub fn render_area(mut self, render_area: Rect2D) -> Self {
        self.render_area = render_area;
        self
    }
    #[inline]
    pub fn clear_values(mut self, clear_values: &'a [ClearValue]) -> Self {
        self.clear_value_count = clear_values.len() as _;
        self.p_clear_values = clear_values.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsRenderPassBeginInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkClearColorValue.html>"]
pub union ClearColorValue {
    pub float32: [f32; 4],
    pub int32: [i32; 4],
    pub uint32: [u32; 4],
}
impl ::core::default::Default for ClearColorValue {
    #[inline]
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkClearDepthStencilValue.html>"]
#[must_use]
pub struct ClearDepthStencilValue {
    pub depth: f32,
    pub stencil: u32,
}
impl ClearDepthStencilValue {
    #[inline]
    pub fn depth(mut self, depth: f32) -> Self {
        self.depth = depth;
        self
    }
    #[inline]
    pub fn stencil(mut self, stencil: u32) -> Self {
        self.stencil = stencil;
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkClearValue.html>"]
pub union ClearValue {
    pub color: ClearColorValue,
    pub depth_stencil: ClearDepthStencilValue,
}
impl ::core::default::Default for ClearValue {
    #[inline]
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkClearAttachment.html>"]
#[must_use]
pub struct ClearAttachment {
    pub aspect_mask: ImageAspectFlags,
    pub color_attachment: u32,
    pub clear_value: ClearValue,
}
#[cfg(feature = "debug")]
impl fmt::Debug for ClearAttachment {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("ClearAttachment")
            .field("aspect_mask", &self.aspect_mask)
            .field("color_attachment", &self.color_attachment)
            .field("clear_value", &"union")
            .finish()
    }
}
impl ClearAttachment {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.aspect_mask = aspect_mask;
        self
    }
    #[inline]
    pub fn color_attachment(mut self, color_attachment: u32) -> Self {
        self.color_attachment = color_attachment;
        self
    }
    #[inline]
    pub fn clear_value(mut self, clear_value: ClearValue) -> Self {
        self.clear_value = clear_value;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAttachmentDescription.html>"]
#[must_use]
pub struct AttachmentDescription {
    pub flags: AttachmentDescriptionFlags,
    pub format: Format,
    pub samples: SampleCountFlags,
    pub load_op: AttachmentLoadOp,
    pub store_op: AttachmentStoreOp,
    pub stencil_load_op: AttachmentLoadOp,
    pub stencil_store_op: AttachmentStoreOp,
    pub initial_layout: ImageLayout,
    pub final_layout: ImageLayout,
}
impl AttachmentDescription {
    #[inline]
    pub fn flags(mut self, flags: AttachmentDescriptionFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.format = format;
        self
    }
    #[inline]
    pub fn samples(mut self, samples: SampleCountFlags) -> Self {
        self.samples = samples;
        self
    }
    #[inline]
    pub fn load_op(mut self, load_op: AttachmentLoadOp) -> Self {
        self.load_op = load_op;
        self
    }
    #[inline]
    pub fn store_op(mut self, store_op: AttachmentStoreOp) -> Self {
        self.store_op = store_op;
        self
    }
    #[inline]
    pub fn stencil_load_op(mut self, stencil_load_op: AttachmentLoadOp) -> Self {
        self.stencil_load_op = stencil_load_op;
        self
    }
    #[inline]
    pub fn stencil_store_op(mut self, stencil_store_op: AttachmentStoreOp) -> Self {
        self.stencil_store_op = stencil_store_op;
        self
    }
    #[inline]
    pub fn initial_layout(mut self, initial_layout: ImageLayout) -> Self {
        self.initial_layout = initial_layout;
        self
    }
    #[inline]
    pub fn final_layout(mut self, final_layout: ImageLayout) -> Self {
        self.final_layout = final_layout;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAttachmentReference.html>"]
#[must_use]
pub struct AttachmentReference {
    pub attachment: u32,
    pub layout: ImageLayout,
}
impl AttachmentReference {
    #[inline]
    pub fn attachment(mut self, attachment: u32) -> Self {
        self.attachment = attachment;
        self
    }
    #[inline]
    pub fn layout(mut self, layout: ImageLayout) -> Self {
        self.layout = layout;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSubpassDescription.html>"]
#[must_use]
pub struct SubpassDescription<'a> {
    pub flags: SubpassDescriptionFlags,
    pub pipeline_bind_point: PipelineBindPoint,
    pub input_attachment_count: u32,
    pub p_input_attachments: *const AttachmentReference,
    pub color_attachment_count: u32,
    pub p_color_attachments: *const AttachmentReference,
    pub p_resolve_attachments: *const AttachmentReference,
    pub p_depth_stencil_attachment: *const AttachmentReference,
    pub preserve_attachment_count: u32,
    pub p_preserve_attachments: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SubpassDescription<'_> {}
unsafe impl Sync for SubpassDescription<'_> {}
impl ::core::default::Default for SubpassDescription<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            flags: SubpassDescriptionFlags::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            input_attachment_count: u32::default(),
            p_input_attachments: ::core::ptr::null(),
            color_attachment_count: u32::default(),
            p_color_attachments: ::core::ptr::null(),
            p_resolve_attachments: ::core::ptr::null(),
            p_depth_stencil_attachment: ::core::ptr::null(),
            preserve_attachment_count: u32::default(),
            p_preserve_attachments: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
impl<'a> SubpassDescription<'a> {
    #[inline]
    pub fn flags(mut self, flags: SubpassDescriptionFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.pipeline_bind_point = pipeline_bind_point;
        self
    }
    #[inline]
    pub fn input_attachments(mut self, input_attachments: &'a [AttachmentReference]) -> Self {
        self.input_attachment_count = input_attachments.len() as _;
        self.p_input_attachments = input_attachments.as_ptr();
        self
    }
    #[inline]
    pub fn color_attachments(mut self, color_attachments: &'a [AttachmentReference]) -> Self {
        self.color_attachment_count = color_attachments.len() as _;
        self.p_color_attachments = color_attachments.as_ptr();
        self
    }
    #[inline]
    pub fn resolve_attachments(mut self, resolve_attachments: &'a [AttachmentReference]) -> Self {
        self.color_attachment_count = resolve_attachments.len() as _;
        self.p_resolve_attachments = resolve_attachments.as_ptr();
        self
    }
    #[inline]
    pub fn depth_stencil_attachment(
        mut self,
        depth_stencil_attachment: &'a AttachmentReference,
    ) -> Self {
        self.p_depth_stencil_attachment = depth_stencil_attachment;
        self
    }
    #[inline]
    pub fn preserve_attachments(mut self, preserve_attachments: &'a [u32]) -> Self {
        self.preserve_attachment_count = preserve_attachments.len() as _;
        self.p_preserve_attachments = preserve_attachments.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSubpassDependency.html>"]
#[must_use]
pub struct SubpassDependency {
    pub src_subpass: u32,
    pub dst_subpass: u32,
    pub src_stage_mask: PipelineStageFlags,
    pub dst_stage_mask: PipelineStageFlags,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub dependency_flags: DependencyFlags,
}
impl SubpassDependency {
    #[inline]
    pub fn src_subpass(mut self, src_subpass: u32) -> Self {
        self.src_subpass = src_subpass;
        self
    }
    #[inline]
    pub fn dst_subpass(mut self, dst_subpass: u32) -> Self {
        self.dst_subpass = dst_subpass;
        self
    }
    #[inline]
    pub fn src_stage_mask(mut self, src_stage_mask: PipelineStageFlags) -> Self {
        self.src_stage_mask = src_stage_mask;
        self
    }
    #[inline]
    pub fn dst_stage_mask(mut self, dst_stage_mask: PipelineStageFlags) -> Self {
        self.dst_stage_mask = dst_stage_mask;
        self
    }
    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> Self {
        self.src_access_mask = src_access_mask;
        self
    }
    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> Self {
        self.dst_access_mask = dst_access_mask;
        self
    }
    #[inline]
    pub fn dependency_flags(mut self, dependency_flags: DependencyFlags) -> Self {
        self.dependency_flags = dependency_flags;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRenderPassCreateInfo.html>"]
#[must_use]
pub struct RenderPassCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: RenderPassCreateFlags,
    pub attachment_count: u32,
    pub p_attachments: *const AttachmentDescription,
    pub subpass_count: u32,
    pub p_subpasses: *const SubpassDescription<'a>,
    pub dependency_count: u32,
    pub p_dependencies: *const SubpassDependency,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for RenderPassCreateInfo<'_> {}
unsafe impl Sync for RenderPassCreateInfo<'_> {}
impl ::core::default::Default for RenderPassCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: RenderPassCreateFlags::default(),
            attachment_count: u32::default(),
            p_attachments: ::core::ptr::null(),
            subpass_count: u32::default(),
            p_subpasses: ::core::ptr::null(),
            dependency_count: u32::default(),
            p_dependencies: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for RenderPassCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::RENDER_PASS_CREATE_INFO;
}
pub unsafe trait ExtendsRenderPassCreateInfo {}
impl<'a> RenderPassCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: RenderPassCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn attachments(mut self, attachments: &'a [AttachmentDescription]) -> Self {
        self.attachment_count = attachments.len() as _;
        self.p_attachments = attachments.as_ptr();
        self
    }
    #[inline]
    pub fn subpasses(mut self, subpasses: &'a [SubpassDescription<'a>]) -> Self {
        self.subpass_count = subpasses.len() as _;
        self.p_subpasses = subpasses.as_ptr();
        self
    }
    #[inline]
    pub fn dependencies(mut self, dependencies: &'a [SubpassDependency]) -> Self {
        self.dependency_count = dependencies.len() as _;
        self.p_dependencies = dependencies.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsRenderPassCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkEventCreateInfo.html>"]
#[must_use]
pub struct EventCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: EventCreateFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for EventCreateInfo<'_> {}
unsafe impl Sync for EventCreateInfo<'_> {}
impl ::core::default::Default for EventCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: EventCreateFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for EventCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EVENT_CREATE_INFO;
}
pub unsafe trait ExtendsEventCreateInfo {}
impl<'a> EventCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: EventCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsEventCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkFenceCreateInfo.html>"]
#[must_use]
pub struct FenceCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: FenceCreateFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for FenceCreateInfo<'_> {}
unsafe impl Sync for FenceCreateInfo<'_> {}
impl ::core::default::Default for FenceCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: FenceCreateFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for FenceCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::FENCE_CREATE_INFO;
}
pub unsafe trait ExtendsFenceCreateInfo {}
impl<'a> FenceCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: FenceCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsFenceCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceFeatures.html>"]
#[must_use]
pub struct PhysicalDeviceFeatures {
    pub robust_buffer_access: Bool32,
    pub full_draw_index_uint32: Bool32,
    pub image_cube_array: Bool32,
    pub independent_blend: Bool32,
    pub geometry_shader: Bool32,
    pub tessellation_shader: Bool32,
    pub sample_rate_shading: Bool32,
    pub dual_src_blend: Bool32,
    pub logic_op: Bool32,
    pub multi_draw_indirect: Bool32,
    pub draw_indirect_first_instance: Bool32,
    pub depth_clamp: Bool32,
    pub depth_bias_clamp: Bool32,
    pub fill_mode_non_solid: Bool32,
    pub depth_bounds: Bool32,
    pub wide_lines: Bool32,
    pub large_points: Bool32,
    pub alpha_to_one: Bool32,
    pub multi_viewport: Bool32,
    pub sampler_anisotropy: Bool32,
    pub texture_compression_etc2: Bool32,
    pub texture_compression_astc_ldr: Bool32,
    pub texture_compression_bc: Bool32,
    pub occlusion_query_precise: Bool32,
    pub pipeline_statistics_query: Bool32,
    pub vertex_pipeline_stores_and_atomics: Bool32,
    pub fragment_stores_and_atomics: Bool32,
    pub shader_tessellation_and_geometry_point_size: Bool32,
    pub shader_image_gather_extended: Bool32,
    pub shader_storage_image_extended_formats: Bool32,
    pub shader_storage_image_multisample: Bool32,
    pub shader_storage_image_read_without_format: Bool32,
    pub shader_storage_image_write_without_format: Bool32,
    pub shader_uniform_buffer_array_dynamic_indexing: Bool32,
    pub shader_sampled_image_array_dynamic_indexing: Bool32,
    pub shader_storage_buffer_array_dynamic_indexing: Bool32,
    pub shader_storage_image_array_dynamic_indexing: Bool32,
    pub shader_clip_distance: Bool32,
    pub shader_cull_distance: Bool32,
    pub shader_float64: Bool32,
    pub shader_int64: Bool32,
    pub shader_int16: Bool32,
    pub shader_resource_residency: Bool32,
    pub shader_resource_min_lod: Bool32,
    pub sparse_binding: Bool32,
    pub sparse_residency_buffer: Bool32,
    pub sparse_residency_image2_d: Bool32,
    pub sparse_residency_image3_d: Bool32,
    pub sparse_residency2_samples: Bool32,
    pub sparse_residency4_samples: Bool32,
    pub sparse_residency8_samples: Bool32,
    pub sparse_residency16_samples: Bool32,
    pub sparse_residency_aliased: Bool32,
    pub variable_multisample_rate: Bool32,
    pub inherited_queries: Bool32,
}
impl PhysicalDeviceFeatures {
    #[inline]
    pub fn robust_buffer_access(mut self, robust_buffer_access: bool) -> Self {
        self.robust_buffer_access = robust_buffer_access.into();
        self
    }
    #[inline]
    pub fn full_draw_index_uint32(mut self, full_draw_index_uint32: bool) -> Self {
        self.full_draw_index_uint32 = full_draw_index_uint32.into();
        self
    }
    #[inline]
    pub fn image_cube_array(mut self, image_cube_array: bool) -> Self {
        self.image_cube_array = image_cube_array.into();
        self
    }
    #[inline]
    pub fn independent_blend(mut self, independent_blend: bool) -> Self {
        self.independent_blend = independent_blend.into();
        self
    }
    #[inline]
    pub fn geometry_shader(mut self, geometry_shader: bool) -> Self {
        self.geometry_shader = geometry_shader.into();
        self
    }
    #[inline]
    pub fn tessellation_shader(mut self, tessellation_shader: bool) -> Self {
        self.tessellation_shader = tessellation_shader.into();
        self
    }
    #[inline]
    pub fn sample_rate_shading(mut self, sample_rate_shading: bool) -> Self {
        self.sample_rate_shading = sample_rate_shading.into();
        self
    }
    #[inline]
    pub fn dual_src_blend(mut self, dual_src_blend: bool) -> Self {
        self.dual_src_blend = dual_src_blend.into();
        self
    }
    #[inline]
    pub fn logic_op(mut self, logic_op: bool) -> Self {
        self.logic_op = logic_op.into();
        self
    }
    #[inline]
    pub fn multi_draw_indirect(mut self, multi_draw_indirect: bool) -> Self {
        self.multi_draw_indirect = multi_draw_indirect.into();
        self
    }
    #[inline]
    pub fn draw_indirect_first_instance(mut self, draw_indirect_first_instance: bool) -> Self {
        self.draw_indirect_first_instance = draw_indirect_first_instance.into();
        self
    }
    #[inline]
    pub fn depth_clamp(mut self, depth_clamp: bool) -> Self {
        self.depth_clamp = depth_clamp.into();
        self
    }
    #[inline]
    pub fn depth_bias_clamp(mut self, depth_bias_clamp: bool) -> Self {
        self.depth_bias_clamp = depth_bias_clamp.into();
        self
    }
    #[inline]
    pub fn fill_mode_non_solid(mut self, fill_mode_non_solid: bool) -> Self {
        self.fill_mode_non_solid = fill_mode_non_solid.into();
        self
    }
    #[inline]
    pub fn depth_bounds(mut self, depth_bounds: bool) -> Self {
        self.depth_bounds = depth_bounds.into();
        self
    }
    #[inline]
    pub fn wide_lines(mut self, wide_lines: bool) -> Self {
        self.wide_lines = wide_lines.into();
        self
    }
    #[inline]
    pub fn large_points(mut self, large_points: bool) -> Self {
        self.large_points = large_points.into();
        self
    }
    #[inline]
    pub fn alpha_to_one(mut self, alpha_to_one: bool) -> Self {
        self.alpha_to_one = alpha_to_one.into();
        self
    }
    #[inline]
    pub fn multi_viewport(mut self, multi_viewport: bool) -> Self {
        self.multi_viewport = multi_viewport.into();
        self
    }
    #[inline]
    pub fn sampler_anisotropy(mut self, sampler_anisotropy: bool) -> Self {
        self.sampler_anisotropy = sampler_anisotropy.into();
        self
    }
    #[inline]
    pub fn texture_compression_etc2(mut self, texture_compression_etc2: bool) -> Self {
        self.texture_compression_etc2 = texture_compression_etc2.into();
        self
    }
    #[inline]
    pub fn texture_compression_astc_ldr(mut self, texture_compression_astc_ldr: bool) -> Self {
        self.texture_compression_astc_ldr = texture_compression_astc_ldr.into();
        self
    }
    #[inline]
    pub fn texture_compression_bc(mut self, texture_compression_bc: bool) -> Self {
        self.texture_compression_bc = texture_compression_bc.into();
        self
    }
    #[inline]
    pub fn occlusion_query_precise(mut self, occlusion_query_precise: bool) -> Self {
        self.occlusion_query_precise = occlusion_query_precise.into();
        self
    }
    #[inline]
    pub fn pipeline_statistics_query(mut self, pipeline_statistics_query: bool) -> Self {
        self.pipeline_statistics_query = pipeline_statistics_query.into();
        self
    }
    #[inline]
    pub fn vertex_pipeline_stores_and_atomics(
        mut self,
        vertex_pipeline_stores_and_atomics: bool,
    ) -> Self {
        self.vertex_pipeline_stores_and_atomics = vertex_pipeline_stores_and_atomics.into();
        self
    }
    #[inline]
    pub fn fragment_stores_and_atomics(mut self, fragment_stores_and_atomics: bool) -> Self {
        self.fragment_stores_and_atomics = fragment_stores_and_atomics.into();
        self
    }
    #[inline]
    pub fn shader_tessellation_and_geometry_point_size(
        mut self,
        shader_tessellation_and_geometry_point_size: bool,
    ) -> Self {
        self.shader_tessellation_and_geometry_point_size =
            shader_tessellation_and_geometry_point_size.into();
        self
    }
    #[inline]
    pub fn shader_image_gather_extended(mut self, shader_image_gather_extended: bool) -> Self {
        self.shader_image_gather_extended = shader_image_gather_extended.into();
        self
    }
    #[inline]
    pub fn shader_storage_image_extended_formats(
        mut self,
        shader_storage_image_extended_formats: bool,
    ) -> Self {
        self.shader_storage_image_extended_formats = shader_storage_image_extended_formats.into();
        self
    }
    #[inline]
    pub fn shader_storage_image_multisample(
        mut self,
        shader_storage_image_multisample: bool,
    ) -> Self {
        self.shader_storage_image_multisample = shader_storage_image_multisample.into();
        self
    }
    #[inline]
    pub fn shader_storage_image_read_without_format(
        mut self,
        shader_storage_image_read_without_format: bool,
    ) -> Self {
        self.shader_storage_image_read_without_format =
            shader_storage_image_read_without_format.into();
        self
    }
    #[inline]
    pub fn shader_storage_image_write_without_format(
        mut self,
        shader_storage_image_write_without_format: bool,
    ) -> Self {
        self.shader_storage_image_write_without_format =
            shader_storage_image_write_without_format.into();
        self
    }
    #[inline]
    pub fn shader_uniform_buffer_array_dynamic_indexing(
        mut self,
        shader_uniform_buffer_array_dynamic_indexing: bool,
    ) -> Self {
        self.shader_uniform_buffer_array_dynamic_indexing =
            shader_uniform_buffer_array_dynamic_indexing.into();
        self
    }
    #[inline]
    pub fn shader_sampled_image_array_dynamic_indexing(
        mut self,
        shader_sampled_image_array_dynamic_indexing: bool,
    ) -> Self {
        self.shader_sampled_image_array_dynamic_indexing =
            shader_sampled_image_array_dynamic_indexing.into();
        self
    }
    #[inline]
    pub fn shader_storage_buffer_array_dynamic_indexing(
        mut self,
        shader_storage_buffer_array_dynamic_indexing: bool,
    ) -> Self {
        self.shader_storage_buffer_array_dynamic_indexing =
            shader_storage_buffer_array_dynamic_indexing.into();
        self
    }
    #[inline]
    pub fn shader_storage_image_array_dynamic_indexing(
        mut self,
        shader_storage_image_array_dynamic_indexing: bool,
    ) -> Self {
        self.shader_storage_image_array_dynamic_indexing =
            shader_storage_image_array_dynamic_indexing.into();
        self
    }
    #[inline]
    pub fn shader_clip_distance(mut self, shader_clip_distance: bool) -> Self {
        self.shader_clip_distance = shader_clip_distance.into();
        self
    }
    #[inline]
    pub fn shader_cull_distance(mut self, shader_cull_distance: bool) -> Self {
        self.shader_cull_distance = shader_cull_distance.into();
        self
    }
    #[inline]
    pub fn shader_float64(mut self, shader_float64: bool) -> Self {
        self.shader_float64 = shader_float64.into();
        self
    }
    #[inline]
    pub fn shader_int64(mut self, shader_int64: bool) -> Self {
        self.shader_int64 = shader_int64.into();
        self
    }
    #[inline]
    pub fn shader_int16(mut self, shader_int16: bool) -> Self {
        self.shader_int16 = shader_int16.into();
        self
    }
    #[inline]
    pub fn shader_resource_residency(mut self, shader_resource_residency: bool) -> Self {
        self.shader_resource_residency = shader_resource_residency.into();
        self
    }
    #[inline]
    pub fn shader_resource_min_lod(mut self, shader_resource_min_lod: bool) -> Self {
        self.shader_resource_min_lod = shader_resource_min_lod.into();
        self
    }
    #[inline]
    pub fn sparse_binding(mut self, sparse_binding: bool) -> Self {
        self.sparse_binding = sparse_binding.into();
        self
    }
    #[inline]
    pub fn sparse_residency_buffer(mut self, sparse_residency_buffer: bool) -> Self {
        self.sparse_residency_buffer = sparse_residency_buffer.into();
        self
    }
    #[inline]
    pub fn sparse_residency_image2_d(mut self, sparse_residency_image2_d: bool) -> Self {
        self.sparse_residency_image2_d = sparse_residency_image2_d.into();
        self
    }
    #[inline]
    pub fn sparse_residency_image3_d(mut self, sparse_residency_image3_d: bool) -> Self {
        self.sparse_residency_image3_d = sparse_residency_image3_d.into();
        self
    }
    #[inline]
    pub fn sparse_residency2_samples(mut self, sparse_residency2_samples: bool) -> Self {
        self.sparse_residency2_samples = sparse_residency2_samples.into();
        self
    }
    #[inline]
    pub fn sparse_residency4_samples(mut self, sparse_residency4_samples: bool) -> Self {
        self.sparse_residency4_samples = sparse_residency4_samples.into();
        self
    }
    #[inline]
    pub fn sparse_residency8_samples(mut self, sparse_residency8_samples: bool) -> Self {
        self.sparse_residency8_samples = sparse_residency8_samples.into();
        self
    }
    #[inline]
    pub fn sparse_residency16_samples(mut self, sparse_residency16_samples: bool) -> Self {
        self.sparse_residency16_samples = sparse_residency16_samples.into();
        self
    }
    #[inline]
    pub fn sparse_residency_aliased(mut self, sparse_residency_aliased: bool) -> Self {
        self.sparse_residency_aliased = sparse_residency_aliased.into();
        self
    }
    #[inline]
    pub fn variable_multisample_rate(mut self, variable_multisample_rate: bool) -> Self {
        self.variable_multisample_rate = variable_multisample_rate.into();
        self
    }
    #[inline]
    pub fn inherited_queries(mut self, inherited_queries: bool) -> Self {
        self.inherited_queries = inherited_queries.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSparseProperties.html>"]
#[must_use]
pub struct PhysicalDeviceSparseProperties {
    pub residency_standard2_d_block_shape: Bool32,
    pub residency_standard2_d_multisample_block_shape: Bool32,
    pub residency_standard3_d_block_shape: Bool32,
    pub residency_aligned_mip_size: Bool32,
    pub residency_non_resident_strict: Bool32,
}
impl PhysicalDeviceSparseProperties {
    #[inline]
    pub fn residency_standard2_d_block_shape(
        mut self,
        residency_standard2_d_block_shape: bool,
    ) -> Self {
        self.residency_standard2_d_block_shape = residency_standard2_d_block_shape.into();
        self
    }
    #[inline]
    pub fn residency_standard2_d_multisample_block_shape(
        mut self,
        residency_standard2_d_multisample_block_shape: bool,
    ) -> Self {
        self.residency_standard2_d_multisample_block_shape =
            residency_standard2_d_multisample_block_shape.into();
        self
    }
    #[inline]
    pub fn residency_standard3_d_block_shape(
        mut self,
        residency_standard3_d_block_shape: bool,
    ) -> Self {
        self.residency_standard3_d_block_shape = residency_standard3_d_block_shape.into();
        self
    }
    #[inline]
    pub fn residency_aligned_mip_size(mut self, residency_aligned_mip_size: bool) -> Self {
        self.residency_aligned_mip_size = residency_aligned_mip_size.into();
        self
    }
    #[inline]
    pub fn residency_non_resident_strict(mut self, residency_non_resident_strict: bool) -> Self {
        self.residency_non_resident_strict = residency_non_resident_strict.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceLimits.html>"]
#[must_use]
pub struct PhysicalDeviceLimits {
    pub max_image_dimension1_d: u32,
    pub max_image_dimension2_d: u32,
    pub max_image_dimension3_d: u32,
    pub max_image_dimension_cube: u32,
    pub max_image_array_layers: u32,
    pub max_texel_buffer_elements: u32,
    pub max_uniform_buffer_range: u32,
    pub max_storage_buffer_range: u32,
    pub max_push_constants_size: u32,
    pub max_memory_allocation_count: u32,
    pub max_sampler_allocation_count: u32,
    pub buffer_image_granularity: DeviceSize,
    pub sparse_address_space_size: DeviceSize,
    pub max_bound_descriptor_sets: u32,
    pub max_per_stage_descriptor_samplers: u32,
    pub max_per_stage_descriptor_uniform_buffers: u32,
    pub max_per_stage_descriptor_storage_buffers: u32,
    pub max_per_stage_descriptor_sampled_images: u32,
    pub max_per_stage_descriptor_storage_images: u32,
    pub max_per_stage_descriptor_input_attachments: u32,
    pub max_per_stage_resources: u32,
    pub max_descriptor_set_samplers: u32,
    pub max_descriptor_set_uniform_buffers: u32,
    pub max_descriptor_set_uniform_buffers_dynamic: u32,
    pub max_descriptor_set_storage_buffers: u32,
    pub max_descriptor_set_storage_buffers_dynamic: u32,
    pub max_descriptor_set_sampled_images: u32,
    pub max_descriptor_set_storage_images: u32,
    pub max_descriptor_set_input_attachments: u32,
    pub max_vertex_input_attributes: u32,
    pub max_vertex_input_bindings: u32,
    pub max_vertex_input_attribute_offset: u32,
    pub max_vertex_input_binding_stride: u32,
    pub max_vertex_output_components: u32,
    pub max_tessellation_generation_level: u32,
    pub max_tessellation_patch_size: u32,
    pub max_tessellation_control_per_vertex_input_components: u32,
    pub max_tessellation_control_per_vertex_output_components: u32,
    pub max_tessellation_control_per_patch_output_components: u32,
    pub max_tessellation_control_total_output_components: u32,
    pub max_tessellation_evaluation_input_components: u32,
    pub max_tessellation_evaluation_output_components: u32,
    pub max_geometry_shader_invocations: u32,
    pub max_geometry_input_components: u32,
    pub max_geometry_output_components: u32,
    pub max_geometry_output_vertices: u32,
    pub max_geometry_total_output_components: u32,
    pub max_fragment_input_components: u32,
    pub max_fragment_output_attachments: u32,
    pub max_fragment_dual_src_attachments: u32,
    pub max_fragment_combined_output_resources: u32,
    pub max_compute_shared_memory_size: u32,
    pub max_compute_work_group_count: [u32; 3],
    pub max_compute_work_group_invocations: u32,
    pub max_compute_work_group_size: [u32; 3],
    pub sub_pixel_precision_bits: u32,
    pub sub_texel_precision_bits: u32,
    pub mipmap_precision_bits: u32,
    pub max_draw_indexed_index_value: u32,
    pub max_draw_indirect_count: u32,
    pub max_sampler_lod_bias: f32,
    pub max_sampler_anisotropy: f32,
    pub max_viewports: u32,
    pub max_viewport_dimensions: [u32; 2],
    pub viewport_bounds_range: [f32; 2],
    pub viewport_sub_pixel_bits: u32,
    pub min_memory_map_alignment: usize,
    pub min_texel_buffer_offset_alignment: DeviceSize,
    pub min_uniform_buffer_offset_alignment: DeviceSize,
    pub min_storage_buffer_offset_alignment: DeviceSize,
    pub min_texel_offset: i32,
    pub max_texel_offset: u32,
    pub min_texel_gather_offset: i32,
    pub max_texel_gather_offset: u32,
    pub min_interpolation_offset: f32,
    pub max_interpolation_offset: f32,
    pub sub_pixel_interpolation_offset_bits: u32,
    pub max_framebuffer_width: u32,
    pub max_framebuffer_height: u32,
    pub max_framebuffer_layers: u32,
    pub framebuffer_color_sample_counts: SampleCountFlags,
    pub framebuffer_depth_sample_counts: SampleCountFlags,
    pub framebuffer_stencil_sample_counts: SampleCountFlags,
    pub framebuffer_no_attachments_sample_counts: SampleCountFlags,
    pub max_color_attachments: u32,
    pub sampled_image_color_sample_counts: SampleCountFlags,
    pub sampled_image_integer_sample_counts: SampleCountFlags,
    pub sampled_image_depth_sample_counts: SampleCountFlags,
    pub sampled_image_stencil_sample_counts: SampleCountFlags,
    pub storage_image_sample_counts: SampleCountFlags,
    pub max_sample_mask_words: u32,
    pub timestamp_compute_and_graphics: Bool32,
    pub timestamp_period: f32,
    pub max_clip_distances: u32,
    pub max_cull_distances: u32,
    pub max_combined_clip_and_cull_distances: u32,
    pub discrete_queue_priorities: u32,
    pub point_size_range: [f32; 2],
    pub line_width_range: [f32; 2],
    pub point_size_granularity: f32,
    pub line_width_granularity: f32,
    pub strict_lines: Bool32,
    pub standard_sample_locations: Bool32,
    pub optimal_buffer_copy_offset_alignment: DeviceSize,
    pub optimal_buffer_copy_row_pitch_alignment: DeviceSize,
    pub non_coherent_atom_size: DeviceSize,
}
impl ::core::default::Default for PhysicalDeviceLimits {
    #[inline]
    fn default() -> Self {
        Self {
            max_image_dimension1_d: u32::default(),
            max_image_dimension2_d: u32::default(),
            max_image_dimension3_d: u32::default(),
            max_image_dimension_cube: u32::default(),
            max_image_array_layers: u32::default(),
            max_texel_buffer_elements: u32::default(),
            max_uniform_buffer_range: u32::default(),
            max_storage_buffer_range: u32::default(),
            max_push_constants_size: u32::default(),
            max_memory_allocation_count: u32::default(),
            max_sampler_allocation_count: u32::default(),
            buffer_image_granularity: DeviceSize::default(),
            sparse_address_space_size: DeviceSize::default(),
            max_bound_descriptor_sets: u32::default(),
            max_per_stage_descriptor_samplers: u32::default(),
            max_per_stage_descriptor_uniform_buffers: u32::default(),
            max_per_stage_descriptor_storage_buffers: u32::default(),
            max_per_stage_descriptor_sampled_images: u32::default(),
            max_per_stage_descriptor_storage_images: u32::default(),
            max_per_stage_descriptor_input_attachments: u32::default(),
            max_per_stage_resources: u32::default(),
            max_descriptor_set_samplers: u32::default(),
            max_descriptor_set_uniform_buffers: u32::default(),
            max_descriptor_set_uniform_buffers_dynamic: u32::default(),
            max_descriptor_set_storage_buffers: u32::default(),
            max_descriptor_set_storage_buffers_dynamic: u32::default(),
            max_descriptor_set_sampled_images: u32::default(),
            max_descriptor_set_storage_images: u32::default(),
            max_descriptor_set_input_attachments: u32::default(),
            max_vertex_input_attributes: u32::default(),
            max_vertex_input_bindings: u32::default(),
            max_vertex_input_attribute_offset: u32::default(),
            max_vertex_input_binding_stride: u32::default(),
            max_vertex_output_components: u32::default(),
            max_tessellation_generation_level: u32::default(),
            max_tessellation_patch_size: u32::default(),
            max_tessellation_control_per_vertex_input_components: u32::default(),
            max_tessellation_control_per_vertex_output_components: u32::default(),
            max_tessellation_control_per_patch_output_components: u32::default(),
            max_tessellation_control_total_output_components: u32::default(),
            max_tessellation_evaluation_input_components: u32::default(),
            max_tessellation_evaluation_output_components: u32::default(),
            max_geometry_shader_invocations: u32::default(),
            max_geometry_input_components: u32::default(),
            max_geometry_output_components: u32::default(),
            max_geometry_output_vertices: u32::default(),
            max_geometry_total_output_components: u32::default(),
            max_fragment_input_components: u32::default(),
            max_fragment_output_attachments: u32::default(),
            max_fragment_dual_src_attachments: u32::default(),
            max_fragment_combined_output_resources: u32::default(),
            max_compute_shared_memory_size: u32::default(),
            max_compute_work_group_count: unsafe { ::core::mem::zeroed() },
            max_compute_work_group_invocations: u32::default(),
            max_compute_work_group_size: unsafe { ::core::mem::zeroed() },
            sub_pixel_precision_bits: u32::default(),
            sub_texel_precision_bits: u32::default(),
            mipmap_precision_bits: u32::default(),
            max_draw_indexed_index_value: u32::default(),
            max_draw_indirect_count: u32::default(),
            max_sampler_lod_bias: f32::default(),
            max_sampler_anisotropy: f32::default(),
            max_viewports: u32::default(),
            max_viewport_dimensions: unsafe { ::core::mem::zeroed() },
            viewport_bounds_range: unsafe { ::core::mem::zeroed() },
            viewport_sub_pixel_bits: u32::default(),
            min_memory_map_alignment: usize::default(),
            min_texel_buffer_offset_alignment: DeviceSize::default(),
            min_uniform_buffer_offset_alignment: DeviceSize::default(),
            min_storage_buffer_offset_alignment: DeviceSize::default(),
            min_texel_offset: i32::default(),
            max_texel_offset: u32::default(),
            min_texel_gather_offset: i32::default(),
            max_texel_gather_offset: u32::default(),
            min_interpolation_offset: f32::default(),
            max_interpolation_offset: f32::default(),
            sub_pixel_interpolation_offset_bits: u32::default(),
            max_framebuffer_width: u32::default(),
            max_framebuffer_height: u32::default(),
            max_framebuffer_layers: u32::default(),
            framebuffer_color_sample_counts: SampleCountFlags::default(),
            framebuffer_depth_sample_counts: SampleCountFlags::default(),
            framebuffer_stencil_sample_counts: SampleCountFlags::default(),
            framebuffer_no_attachments_sample_counts: SampleCountFlags::default(),
            max_color_attachments: u32::default(),
            sampled_image_color_sample_counts: SampleCountFlags::default(),
            sampled_image_integer_sample_counts: SampleCountFlags::default(),
            sampled_image_depth_sample_counts: SampleCountFlags::default(),
            sampled_image_stencil_sample_counts: SampleCountFlags::default(),
            storage_image_sample_counts: SampleCountFlags::default(),
            max_sample_mask_words: u32::default(),
            timestamp_compute_and_graphics: Bool32::default(),
            timestamp_period: f32::default(),
            max_clip_distances: u32::default(),
            max_cull_distances: u32::default(),
            max_combined_clip_and_cull_distances: u32::default(),
            discrete_queue_priorities: u32::default(),
            point_size_range: unsafe { ::core::mem::zeroed() },
            line_width_range: unsafe { ::core::mem::zeroed() },
            point_size_granularity: f32::default(),
            line_width_granularity: f32::default(),
            strict_lines: Bool32::default(),
            standard_sample_locations: Bool32::default(),
            optimal_buffer_copy_offset_alignment: DeviceSize::default(),
            optimal_buffer_copy_row_pitch_alignment: DeviceSize::default(),
            non_coherent_atom_size: DeviceSize::default(),
        }
    }
}
impl PhysicalDeviceLimits {
    #[inline]
    pub fn max_image_dimension1_d(mut self, max_image_dimension1_d: u32) -> Self {
        self.max_image_dimension1_d = max_image_dimension1_d;
        self
    }
    #[inline]
    pub fn max_image_dimension2_d(mut self, max_image_dimension2_d: u32) -> Self {
        self.max_image_dimension2_d = max_image_dimension2_d;
        self
    }
    #[inline]
    pub fn max_image_dimension3_d(mut self, max_image_dimension3_d: u32) -> Self {
        self.max_image_dimension3_d = max_image_dimension3_d;
        self
    }
    #[inline]
    pub fn max_image_dimension_cube(mut self, max_image_dimension_cube: u32) -> Self {
        self.max_image_dimension_cube = max_image_dimension_cube;
        self
    }
    #[inline]
    pub fn max_image_array_layers(mut self, max_image_array_layers: u32) -> Self {
        self.max_image_array_layers = max_image_array_layers;
        self
    }
    #[inline]
    pub fn max_texel_buffer_elements(mut self, max_texel_buffer_elements: u32) -> Self {
        self.max_texel_buffer_elements = max_texel_buffer_elements;
        self
    }
    #[inline]
    pub fn max_uniform_buffer_range(mut self, max_uniform_buffer_range: u32) -> Self {
        self.max_uniform_buffer_range = max_uniform_buffer_range;
        self
    }
    #[inline]
    pub fn max_storage_buffer_range(mut self, max_storage_buffer_range: u32) -> Self {
        self.max_storage_buffer_range = max_storage_buffer_range;
        self
    }
    #[inline]
    pub fn max_push_constants_size(mut self, max_push_constants_size: u32) -> Self {
        self.max_push_constants_size = max_push_constants_size;
        self
    }
    #[inline]
    pub fn max_memory_allocation_count(mut self, max_memory_allocation_count: u32) -> Self {
        self.max_memory_allocation_count = max_memory_allocation_count;
        self
    }
    #[inline]
    pub fn max_sampler_allocation_count(mut self, max_sampler_allocation_count: u32) -> Self {
        self.max_sampler_allocation_count = max_sampler_allocation_count;
        self
    }
    #[inline]
    pub fn buffer_image_granularity(mut self, buffer_image_granularity: DeviceSize) -> Self {
        self.buffer_image_granularity = buffer_image_granularity;
        self
    }
    #[inline]
    pub fn sparse_address_space_size(mut self, sparse_address_space_size: DeviceSize) -> Self {
        self.sparse_address_space_size = sparse_address_space_size;
        self
    }
    #[inline]
    pub fn max_bound_descriptor_sets(mut self, max_bound_descriptor_sets: u32) -> Self {
        self.max_bound_descriptor_sets = max_bound_descriptor_sets;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_samplers(
        mut self,
        max_per_stage_descriptor_samplers: u32,
    ) -> Self {
        self.max_per_stage_descriptor_samplers = max_per_stage_descriptor_samplers;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_uniform_buffers(
        mut self,
        max_per_stage_descriptor_uniform_buffers: u32,
    ) -> Self {
        self.max_per_stage_descriptor_uniform_buffers = max_per_stage_descriptor_uniform_buffers;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_storage_buffers(
        mut self,
        max_per_stage_descriptor_storage_buffers: u32,
    ) -> Self {
        self.max_per_stage_descriptor_storage_buffers = max_per_stage_descriptor_storage_buffers;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_sampled_images(
        mut self,
        max_per_stage_descriptor_sampled_images: u32,
    ) -> Self {
        self.max_per_stage_descriptor_sampled_images = max_per_stage_descriptor_sampled_images;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_storage_images(
        mut self,
        max_per_stage_descriptor_storage_images: u32,
    ) -> Self {
        self.max_per_stage_descriptor_storage_images = max_per_stage_descriptor_storage_images;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_input_attachments(
        mut self,
        max_per_stage_descriptor_input_attachments: u32,
    ) -> Self {
        self.max_per_stage_descriptor_input_attachments =
            max_per_stage_descriptor_input_attachments;
        self
    }
    #[inline]
    pub fn max_per_stage_resources(mut self, max_per_stage_resources: u32) -> Self {
        self.max_per_stage_resources = max_per_stage_resources;
        self
    }
    #[inline]
    pub fn max_descriptor_set_samplers(mut self, max_descriptor_set_samplers: u32) -> Self {
        self.max_descriptor_set_samplers = max_descriptor_set_samplers;
        self
    }
    #[inline]
    pub fn max_descriptor_set_uniform_buffers(
        mut self,
        max_descriptor_set_uniform_buffers: u32,
    ) -> Self {
        self.max_descriptor_set_uniform_buffers = max_descriptor_set_uniform_buffers;
        self
    }
    #[inline]
    pub fn max_descriptor_set_uniform_buffers_dynamic(
        mut self,
        max_descriptor_set_uniform_buffers_dynamic: u32,
    ) -> Self {
        self.max_descriptor_set_uniform_buffers_dynamic =
            max_descriptor_set_uniform_buffers_dynamic;
        self
    }
    #[inline]
    pub fn max_descriptor_set_storage_buffers(
        mut self,
        max_descriptor_set_storage_buffers: u32,
    ) -> Self {
        self.max_descriptor_set_storage_buffers = max_descriptor_set_storage_buffers;
        self
    }
    #[inline]
    pub fn max_descriptor_set_storage_buffers_dynamic(
        mut self,
        max_descriptor_set_storage_buffers_dynamic: u32,
    ) -> Self {
        self.max_descriptor_set_storage_buffers_dynamic =
            max_descriptor_set_storage_buffers_dynamic;
        self
    }
    #[inline]
    pub fn max_descriptor_set_sampled_images(
        mut self,
        max_descriptor_set_sampled_images: u32,
    ) -> Self {
        self.max_descriptor_set_sampled_images = max_descriptor_set_sampled_images;
        self
    }
    #[inline]
    pub fn max_descriptor_set_storage_images(
        mut self,
        max_descriptor_set_storage_images: u32,
    ) -> Self {
        self.max_descriptor_set_storage_images = max_descriptor_set_storage_images;
        self
    }
    #[inline]
    pub fn max_descriptor_set_input_attachments(
        mut self,
        max_descriptor_set_input_attachments: u32,
    ) -> Self {
        self.max_descriptor_set_input_attachments = max_descriptor_set_input_attachments;
        self
    }
    #[inline]
    pub fn max_vertex_input_attributes(mut self, max_vertex_input_attributes: u32) -> Self {
        self.max_vertex_input_attributes = max_vertex_input_attributes;
        self
    }
    #[inline]
    pub fn max_vertex_input_bindings(mut self, max_vertex_input_bindings: u32) -> Self {
        self.max_vertex_input_bindings = max_vertex_input_bindings;
        self
    }
    #[inline]
    pub fn max_vertex_input_attribute_offset(
        mut self,
        max_vertex_input_attribute_offset: u32,
    ) -> Self {
        self.max_vertex_input_attribute_offset = max_vertex_input_attribute_offset;
        self
    }
    #[inline]
    pub fn max_vertex_input_binding_stride(mut self, max_vertex_input_binding_stride: u32) -> Self {
        self.max_vertex_input_binding_stride = max_vertex_input_binding_stride;
        self
    }
    #[inline]
    pub fn max_vertex_output_components(mut self, max_vertex_output_components: u32) -> Self {
        self.max_vertex_output_components = max_vertex_output_components;
        self
    }
    #[inline]
    pub fn max_tessellation_generation_level(
        mut self,
        max_tessellation_generation_level: u32,
    ) -> Self {
        self.max_tessellation_generation_level = max_tessellation_generation_level;
        self
    }
    #[inline]
    pub fn max_tessellation_patch_size(mut self, max_tessellation_patch_size: u32) -> Self {
        self.max_tessellation_patch_size = max_tessellation_patch_size;
        self
    }
    #[inline]
    pub fn max_tessellation_control_per_vertex_input_components(
        mut self,
        max_tessellation_control_per_vertex_input_components: u32,
    ) -> Self {
        self.max_tessellation_control_per_vertex_input_components =
            max_tessellation_control_per_vertex_input_components;
        self
    }
    #[inline]
    pub fn max_tessellation_control_per_vertex_output_components(
        mut self,
        max_tessellation_control_per_vertex_output_components: u32,
    ) -> Self {
        self.max_tessellation_control_per_vertex_output_components =
            max_tessellation_control_per_vertex_output_components;
        self
    }
    #[inline]
    pub fn max_tessellation_control_per_patch_output_components(
        mut self,
        max_tessellation_control_per_patch_output_components: u32,
    ) -> Self {
        self.max_tessellation_control_per_patch_output_components =
            max_tessellation_control_per_patch_output_components;
        self
    }
    #[inline]
    pub fn max_tessellation_control_total_output_components(
        mut self,
        max_tessellation_control_total_output_components: u32,
    ) -> Self {
        self.max_tessellation_control_total_output_components =
            max_tessellation_control_total_output_components;
        self
    }
    #[inline]
    pub fn max_tessellation_evaluation_input_components(
        mut self,
        max_tessellation_evaluation_input_components: u32,
    ) -> Self {
        self.max_tessellation_evaluation_input_components =
            max_tessellation_evaluation_input_components;
        self
    }
    #[inline]
    pub fn max_tessellation_evaluation_output_components(
        mut self,
        max_tessellation_evaluation_output_components: u32,
    ) -> Self {
        self.max_tessellation_evaluation_output_components =
            max_tessellation_evaluation_output_components;
        self
    }
    #[inline]
    pub fn max_geometry_shader_invocations(mut self, max_geometry_shader_invocations: u32) -> Self {
        self.max_geometry_shader_invocations = max_geometry_shader_invocations;
        self
    }
    #[inline]
    pub fn max_geometry_input_components(mut self, max_geometry_input_components: u32) -> Self {
        self.max_geometry_input_components = max_geometry_input_components;
        self
    }
    #[inline]
    pub fn max_geometry_output_components(mut self, max_geometry_output_components: u32) -> Self {
        self.max_geometry_output_components = max_geometry_output_components;
        self
    }
    #[inline]
    pub fn max_geometry_output_vertices(mut self, max_geometry_output_vertices: u32) -> Self {
        self.max_geometry_output_vertices = max_geometry_output_vertices;
        self
    }
    #[inline]
    pub fn max_geometry_total_output_components(
        mut self,
        max_geometry_total_output_components: u32,
    ) -> Self {
        self.max_geometry_total_output_components = max_geometry_total_output_components;
        self
    }
    #[inline]
    pub fn max_fragment_input_components(mut self, max_fragment_input_components: u32) -> Self {
        self.max_fragment_input_components = max_fragment_input_components;
        self
    }
    #[inline]
    pub fn max_fragment_output_attachments(mut self, max_fragment_output_attachments: u32) -> Self {
        self.max_fragment_output_attachments = max_fragment_output_attachments;
        self
    }
    #[inline]
    pub fn max_fragment_dual_src_attachments(
        mut self,
        max_fragment_dual_src_attachments: u32,
    ) -> Self {
        self.max_fragment_dual_src_attachments = max_fragment_dual_src_attachments;
        self
    }
    #[inline]
    pub fn max_fragment_combined_output_resources(
        mut self,
        max_fragment_combined_output_resources: u32,
    ) -> Self {
        self.max_fragment_combined_output_resources = max_fragment_combined_output_resources;
        self
    }
    #[inline]
    pub fn max_compute_shared_memory_size(mut self, max_compute_shared_memory_size: u32) -> Self {
        self.max_compute_shared_memory_size = max_compute_shared_memory_size;
        self
    }
    #[inline]
    pub fn max_compute_work_group_count(mut self, max_compute_work_group_count: [u32; 3]) -> Self {
        self.max_compute_work_group_count = max_compute_work_group_count;
        self
    }
    #[inline]
    pub fn max_compute_work_group_invocations(
        mut self,
        max_compute_work_group_invocations: u32,
    ) -> Self {
        self.max_compute_work_group_invocations = max_compute_work_group_invocations;
        self
    }
    #[inline]
    pub fn max_compute_work_group_size(mut self, max_compute_work_group_size: [u32; 3]) -> Self {
        self.max_compute_work_group_size = max_compute_work_group_size;
        self
    }
    #[inline]
    pub fn sub_pixel_precision_bits(mut self, sub_pixel_precision_bits: u32) -> Self {
        self.sub_pixel_precision_bits = sub_pixel_precision_bits;
        self
    }
    #[inline]
    pub fn sub_texel_precision_bits(mut self, sub_texel_precision_bits: u32) -> Self {
        self.sub_texel_precision_bits = sub_texel_precision_bits;
        self
    }
    #[inline]
    pub fn mipmap_precision_bits(mut self, mipmap_precision_bits: u32) -> Self {
        self.mipmap_precision_bits = mipmap_precision_bits;
        self
    }
    #[inline]
    pub fn max_draw_indexed_index_value(mut self, max_draw_indexed_index_value: u32) -> Self {
        self.max_draw_indexed_index_value = max_draw_indexed_index_value;
        self
    }
    #[inline]
    pub fn max_draw_indirect_count(mut self, max_draw_indirect_count: u32) -> Self {
        self.max_draw_indirect_count = max_draw_indirect_count;
        self
    }
    #[inline]
    pub fn max_sampler_lod_bias(mut self, max_sampler_lod_bias: f32) -> Self {
        self.max_sampler_lod_bias = max_sampler_lod_bias;
        self
    }
    #[inline]
    pub fn max_sampler_anisotropy(mut self, max_sampler_anisotropy: f32) -> Self {
        self.max_sampler_anisotropy = max_sampler_anisotropy;
        self
    }
    #[inline]
    pub fn max_viewports(mut self, max_viewports: u32) -> Self {
        self.max_viewports = max_viewports;
        self
    }
    #[inline]
    pub fn max_viewport_dimensions(mut self, max_viewport_dimensions: [u32; 2]) -> Self {
        self.max_viewport_dimensions = max_viewport_dimensions;
        self
    }
    #[inline]
    pub fn viewport_bounds_range(mut self, viewport_bounds_range: [f32; 2]) -> Self {
        self.viewport_bounds_range = viewport_bounds_range;
        self
    }
    #[inline]
    pub fn viewport_sub_pixel_bits(mut self, viewport_sub_pixel_bits: u32) -> Self {
        self.viewport_sub_pixel_bits = viewport_sub_pixel_bits;
        self
    }
    #[inline]
    pub fn min_memory_map_alignment(mut self, min_memory_map_alignment: usize) -> Self {
        self.min_memory_map_alignment = min_memory_map_alignment;
        self
    }
    #[inline]
    pub fn min_texel_buffer_offset_alignment(
        mut self,
        min_texel_buffer_offset_alignment: DeviceSize,
    ) -> Self {
        self.min_texel_buffer_offset_alignment = min_texel_buffer_offset_alignment;
        self
    }
    #[inline]
    pub fn min_uniform_buffer_offset_alignment(
        mut self,
        min_uniform_buffer_offset_alignment: DeviceSize,
    ) -> Self {
        self.min_uniform_buffer_offset_alignment = min_uniform_buffer_offset_alignment;
        self
    }
    #[inline]
    pub fn min_storage_buffer_offset_alignment(
        mut self,
        min_storage_buffer_offset_alignment: DeviceSize,
    ) -> Self {
        self.min_storage_buffer_offset_alignment = min_storage_buffer_offset_alignment;
        self
    }
    #[inline]
    pub fn min_texel_offset(mut self, min_texel_offset: i32) -> Self {
        self.min_texel_offset = min_texel_offset;
        self
    }
    #[inline]
    pub fn max_texel_offset(mut self, max_texel_offset: u32) -> Self {
        self.max_texel_offset = max_texel_offset;
        self
    }
    #[inline]
    pub fn min_texel_gather_offset(mut self, min_texel_gather_offset: i32) -> Self {
        self.min_texel_gather_offset = min_texel_gather_offset;
        self
    }
    #[inline]
    pub fn max_texel_gather_offset(mut self, max_texel_gather_offset: u32) -> Self {
        self.max_texel_gather_offset = max_texel_gather_offset;
        self
    }
    #[inline]
    pub fn min_interpolation_offset(mut self, min_interpolation_offset: f32) -> Self {
        self.min_interpolation_offset = min_interpolation_offset;
        self
    }
    #[inline]
    pub fn max_interpolation_offset(mut self, max_interpolation_offset: f32) -> Self {
        self.max_interpolation_offset = max_interpolation_offset;
        self
    }
    #[inline]
    pub fn sub_pixel_interpolation_offset_bits(
        mut self,
        sub_pixel_interpolation_offset_bits: u32,
    ) -> Self {
        self.sub_pixel_interpolation_offset_bits = sub_pixel_interpolation_offset_bits;
        self
    }
    #[inline]
    pub fn max_framebuffer_width(mut self, max_framebuffer_width: u32) -> Self {
        self.max_framebuffer_width = max_framebuffer_width;
        self
    }
    #[inline]
    pub fn max_framebuffer_height(mut self, max_framebuffer_height: u32) -> Self {
        self.max_framebuffer_height = max_framebuffer_height;
        self
    }
    #[inline]
    pub fn max_framebuffer_layers(mut self, max_framebuffer_layers: u32) -> Self {
        self.max_framebuffer_layers = max_framebuffer_layers;
        self
    }
    #[inline]
    pub fn framebuffer_color_sample_counts(
        mut self,
        framebuffer_color_sample_counts: SampleCountFlags,
    ) -> Self {
        self.framebuffer_color_sample_counts = framebuffer_color_sample_counts;
        self
    }
    #[inline]
    pub fn framebuffer_depth_sample_counts(
        mut self,
        framebuffer_depth_sample_counts: SampleCountFlags,
    ) -> Self {
        self.framebuffer_depth_sample_counts = framebuffer_depth_sample_counts;
        self
    }
    #[inline]
    pub fn framebuffer_stencil_sample_counts(
        mut self,
        framebuffer_stencil_sample_counts: SampleCountFlags,
    ) -> Self {
        self.framebuffer_stencil_sample_counts = framebuffer_stencil_sample_counts;
        self
    }
    #[inline]
    pub fn framebuffer_no_attachments_sample_counts(
        mut self,
        framebuffer_no_attachments_sample_counts: SampleCountFlags,
    ) -> Self {
        self.framebuffer_no_attachments_sample_counts = framebuffer_no_attachments_sample_counts;
        self
    }
    #[inline]
    pub fn max_color_attachments(mut self, max_color_attachments: u32) -> Self {
        self.max_color_attachments = max_color_attachments;
        self
    }
    #[inline]
    pub fn sampled_image_color_sample_counts(
        mut self,
        sampled_image_color_sample_counts: SampleCountFlags,
    ) -> Self {
        self.sampled_image_color_sample_counts = sampled_image_color_sample_counts;
        self
    }
    #[inline]
    pub fn sampled_image_integer_sample_counts(
        mut self,
        sampled_image_integer_sample_counts: SampleCountFlags,
    ) -> Self {
        self.sampled_image_integer_sample_counts = sampled_image_integer_sample_counts;
        self
    }
    #[inline]
    pub fn sampled_image_depth_sample_counts(
        mut self,
        sampled_image_depth_sample_counts: SampleCountFlags,
    ) -> Self {
        self.sampled_image_depth_sample_counts = sampled_image_depth_sample_counts;
        self
    }
    #[inline]
    pub fn sampled_image_stencil_sample_counts(
        mut self,
        sampled_image_stencil_sample_counts: SampleCountFlags,
    ) -> Self {
        self.sampled_image_stencil_sample_counts = sampled_image_stencil_sample_counts;
        self
    }
    #[inline]
    pub fn storage_image_sample_counts(
        mut self,
        storage_image_sample_counts: SampleCountFlags,
    ) -> Self {
        self.storage_image_sample_counts = storage_image_sample_counts;
        self
    }
    #[inline]
    pub fn max_sample_mask_words(mut self, max_sample_mask_words: u32) -> Self {
        self.max_sample_mask_words = max_sample_mask_words;
        self
    }
    #[inline]
    pub fn timestamp_compute_and_graphics(mut self, timestamp_compute_and_graphics: bool) -> Self {
        self.timestamp_compute_and_graphics = timestamp_compute_and_graphics.into();
        self
    }
    #[inline]
    pub fn timestamp_period(mut self, timestamp_period: f32) -> Self {
        self.timestamp_period = timestamp_period;
        self
    }
    #[inline]
    pub fn max_clip_distances(mut self, max_clip_distances: u32) -> Self {
        self.max_clip_distances = max_clip_distances;
        self
    }
    #[inline]
    pub fn max_cull_distances(mut self, max_cull_distances: u32) -> Self {
        self.max_cull_distances = max_cull_distances;
        self
    }
    #[inline]
    pub fn max_combined_clip_and_cull_distances(
        mut self,
        max_combined_clip_and_cull_distances: u32,
    ) -> Self {
        self.max_combined_clip_and_cull_distances = max_combined_clip_and_cull_distances;
        self
    }
    #[inline]
    pub fn discrete_queue_priorities(mut self, discrete_queue_priorities: u32) -> Self {
        self.discrete_queue_priorities = discrete_queue_priorities;
        self
    }
    #[inline]
    pub fn point_size_range(mut self, point_size_range: [f32; 2]) -> Self {
        self.point_size_range = point_size_range;
        self
    }
    #[inline]
    pub fn line_width_range(mut self, line_width_range: [f32; 2]) -> Self {
        self.line_width_range = line_width_range;
        self
    }
    #[inline]
    pub fn point_size_granularity(mut self, point_size_granularity: f32) -> Self {
        self.point_size_granularity = point_size_granularity;
        self
    }
    #[inline]
    pub fn line_width_granularity(mut self, line_width_granularity: f32) -> Self {
        self.line_width_granularity = line_width_granularity;
        self
    }
    #[inline]
    pub fn strict_lines(mut self, strict_lines: bool) -> Self {
        self.strict_lines = strict_lines.into();
        self
    }
    #[inline]
    pub fn standard_sample_locations(mut self, standard_sample_locations: bool) -> Self {
        self.standard_sample_locations = standard_sample_locations.into();
        self
    }
    #[inline]
    pub fn optimal_buffer_copy_offset_alignment(
        mut self,
        optimal_buffer_copy_offset_alignment: DeviceSize,
    ) -> Self {
        self.optimal_buffer_copy_offset_alignment = optimal_buffer_copy_offset_alignment;
        self
    }
    #[inline]
    pub fn optimal_buffer_copy_row_pitch_alignment(
        mut self,
        optimal_buffer_copy_row_pitch_alignment: DeviceSize,
    ) -> Self {
        self.optimal_buffer_copy_row_pitch_alignment = optimal_buffer_copy_row_pitch_alignment;
        self
    }
    #[inline]
    pub fn non_coherent_atom_size(mut self, non_coherent_atom_size: DeviceSize) -> Self {
        self.non_coherent_atom_size = non_coherent_atom_size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSemaphoreCreateInfo.html>"]
#[must_use]
pub struct SemaphoreCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: SemaphoreCreateFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SemaphoreCreateInfo<'_> {}
unsafe impl Sync for SemaphoreCreateInfo<'_> {}
impl ::core::default::Default for SemaphoreCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: SemaphoreCreateFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SemaphoreCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SEMAPHORE_CREATE_INFO;
}
pub unsafe trait ExtendsSemaphoreCreateInfo {}
impl<'a> SemaphoreCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: SemaphoreCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSemaphoreCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkQueryPoolCreateInfo.html>"]
#[must_use]
pub struct QueryPoolCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: QueryPoolCreateFlags,
    pub query_type: QueryType,
    pub query_count: u32,
    pub pipeline_statistics: QueryPipelineStatisticFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for QueryPoolCreateInfo<'_> {}
unsafe impl Sync for QueryPoolCreateInfo<'_> {}
impl ::core::default::Default for QueryPoolCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: QueryPoolCreateFlags::default(),
            query_type: QueryType::default(),
            query_count: u32::default(),
            pipeline_statistics: QueryPipelineStatisticFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for QueryPoolCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::QUERY_POOL_CREATE_INFO;
}
pub unsafe trait ExtendsQueryPoolCreateInfo {}
impl<'a> QueryPoolCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: QueryPoolCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn query_type(mut self, query_type: QueryType) -> Self {
        self.query_type = query_type;
        self
    }
    #[inline]
    pub fn query_count(mut self, query_count: u32) -> Self {
        self.query_count = query_count;
        self
    }
    #[inline]
    pub fn pipeline_statistics(mut self, pipeline_statistics: QueryPipelineStatisticFlags) -> Self {
        self.pipeline_statistics = pipeline_statistics;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsQueryPoolCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkFramebufferCreateInfo.html>"]
#[must_use]
pub struct FramebufferCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: FramebufferCreateFlags,
    pub render_pass: RenderPass,
    pub attachment_count: u32,
    pub p_attachments: *const ImageView,
    pub width: u32,
    pub height: u32,
    pub layers: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for FramebufferCreateInfo<'_> {}
unsafe impl Sync for FramebufferCreateInfo<'_> {}
impl ::core::default::Default for FramebufferCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: FramebufferCreateFlags::default(),
            render_pass: RenderPass::default(),
            attachment_count: u32::default(),
            p_attachments: ::core::ptr::null(),
            width: u32::default(),
            height: u32::default(),
            layers: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for FramebufferCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::FRAMEBUFFER_CREATE_INFO;
}
pub unsafe trait ExtendsFramebufferCreateInfo {}
impl<'a> FramebufferCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: FramebufferCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn render_pass(mut self, render_pass: RenderPass) -> Self {
        self.render_pass = render_pass;
        self
    }
    #[inline]
    pub fn attachment_count(mut self, attachment_count: u32) -> Self {
        self.attachment_count = attachment_count;
        self
    }
    #[inline]
    pub fn attachments(mut self, attachments: &'a [ImageView]) -> Self {
        self.attachment_count = attachments.len() as _;
        self.p_attachments = attachments.as_ptr();
        self
    }
    #[inline]
    pub fn width(mut self, width: u32) -> Self {
        self.width = width;
        self
    }
    #[inline]
    pub fn height(mut self, height: u32) -> Self {
        self.height = height;
        self
    }
    #[inline]
    pub fn layers(mut self, layers: u32) -> Self {
        self.layers = layers;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsFramebufferCreateInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDrawIndirectCommand.html>"]
#[must_use]
pub struct DrawIndirectCommand {
    pub vertex_count: u32,
    pub instance_count: u32,
    pub first_vertex: u32,
    pub first_instance: u32,
}
impl DrawIndirectCommand {
    #[inline]
    pub fn vertex_count(mut self, vertex_count: u32) -> Self {
        self.vertex_count = vertex_count;
        self
    }
    #[inline]
    pub fn instance_count(mut self, instance_count: u32) -> Self {
        self.instance_count = instance_count;
        self
    }
    #[inline]
    pub fn first_vertex(mut self, first_vertex: u32) -> Self {
        self.first_vertex = first_vertex;
        self
    }
    #[inline]
    pub fn first_instance(mut self, first_instance: u32) -> Self {
        self.first_instance = first_instance;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDrawIndexedIndirectCommand.html>"]
#[must_use]
pub struct DrawIndexedIndirectCommand {
    pub index_count: u32,
    pub instance_count: u32,
    pub first_index: u32,
    pub vertex_offset: i32,
    pub first_instance: u32,
}
impl DrawIndexedIndirectCommand {
    #[inline]
    pub fn index_count(mut self, index_count: u32) -> Self {
        self.index_count = index_count;
        self
    }
    #[inline]
    pub fn instance_count(mut self, instance_count: u32) -> Self {
        self.instance_count = instance_count;
        self
    }
    #[inline]
    pub fn first_index(mut self, first_index: u32) -> Self {
        self.first_index = first_index;
        self
    }
    #[inline]
    pub fn vertex_offset(mut self, vertex_offset: i32) -> Self {
        self.vertex_offset = vertex_offset;
        self
    }
    #[inline]
    pub fn first_instance(mut self, first_instance: u32) -> Self {
        self.first_instance = first_instance;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDispatchIndirectCommand.html>"]
#[must_use]
pub struct DispatchIndirectCommand {
    pub x: u32,
    pub y: u32,
    pub z: u32,
}
impl DispatchIndirectCommand {
    #[inline]
    pub fn x(mut self, x: u32) -> Self {
        self.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: u32) -> Self {
        self.y = y;
        self
    }
    #[inline]
    pub fn z(mut self, z: u32) -> Self {
        self.z = z;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMultiDrawInfoEXT.html>"]
#[must_use]
pub struct MultiDrawInfoEXT {
    pub first_vertex: u32,
    pub vertex_count: u32,
}
impl MultiDrawInfoEXT {
    #[inline]
    pub fn first_vertex(mut self, first_vertex: u32) -> Self {
        self.first_vertex = first_vertex;
        self
    }
    #[inline]
    pub fn vertex_count(mut self, vertex_count: u32) -> Self {
        self.vertex_count = vertex_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMultiDrawIndexedInfoEXT.html>"]
#[must_use]
pub struct MultiDrawIndexedInfoEXT {
    pub first_index: u32,
    pub index_count: u32,
    pub vertex_offset: i32,
}
impl MultiDrawIndexedInfoEXT {
    #[inline]
    pub fn first_index(mut self, first_index: u32) -> Self {
        self.first_index = first_index;
        self
    }
    #[inline]
    pub fn index_count(mut self, index_count: u32) -> Self {
        self.index_count = index_count;
        self
    }
    #[inline]
    pub fn vertex_offset(mut self, vertex_offset: i32) -> Self {
        self.vertex_offset = vertex_offset;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSubmitInfo.html>"]
#[must_use]
pub struct SubmitInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_count: u32,
    pub p_wait_semaphores: *const Semaphore,
    pub p_wait_dst_stage_mask: *const PipelineStageFlags,
    pub command_buffer_count: u32,
    pub p_command_buffers: *const CommandBuffer,
    pub signal_semaphore_count: u32,
    pub p_signal_semaphores: *const Semaphore,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SubmitInfo<'_> {}
unsafe impl Sync for SubmitInfo<'_> {}
impl ::core::default::Default for SubmitInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            wait_semaphore_count: u32::default(),
            p_wait_semaphores: ::core::ptr::null(),
            p_wait_dst_stage_mask: ::core::ptr::null(),
            command_buffer_count: u32::default(),
            p_command_buffers: ::core::ptr::null(),
            signal_semaphore_count: u32::default(),
            p_signal_semaphores: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SubmitInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SUBMIT_INFO;
}
pub unsafe trait ExtendsSubmitInfo {}
impl<'a> SubmitInfo<'a> {
    #[inline]
    pub fn wait_semaphores(mut self, wait_semaphores: &'a [Semaphore]) -> Self {
        self.wait_semaphore_count = wait_semaphores.len() as _;
        self.p_wait_semaphores = wait_semaphores.as_ptr();
        self
    }
    #[inline]
    pub fn wait_dst_stage_mask(mut self, wait_dst_stage_mask: &'a [PipelineStageFlags]) -> Self {
        self.wait_semaphore_count = wait_dst_stage_mask.len() as _;
        self.p_wait_dst_stage_mask = wait_dst_stage_mask.as_ptr();
        self
    }
    #[inline]
    pub fn command_buffers(mut self, command_buffers: &'a [CommandBuffer]) -> Self {
        self.command_buffer_count = command_buffers.len() as _;
        self.p_command_buffers = command_buffers.as_ptr();
        self
    }
    #[inline]
    pub fn signal_semaphores(mut self, signal_semaphores: &'a [Semaphore]) -> Self {
        self.signal_semaphore_count = signal_semaphores.len() as _;
        self.p_signal_semaphores = signal_semaphores.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSubmitInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayPropertiesKHR.html>"]
#[must_use]
pub struct DisplayPropertiesKHR<'a> {
    pub display: DisplayKHR,
    pub display_name: *const c_char,
    pub physical_dimensions: Extent2D,
    pub physical_resolution: Extent2D,
    pub supported_transforms: SurfaceTransformFlagsKHR,
    pub plane_reorder_possible: Bool32,
    pub persistent_content: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DisplayPropertiesKHR<'_> {}
unsafe impl Sync for DisplayPropertiesKHR<'_> {}
impl ::core::default::Default for DisplayPropertiesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            display: DisplayKHR::default(),
            display_name: ::core::ptr::null(),
            physical_dimensions: Extent2D::default(),
            physical_resolution: Extent2D::default(),
            supported_transforms: SurfaceTransformFlagsKHR::default(),
            plane_reorder_possible: Bool32::default(),
            persistent_content: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
impl<'a> DisplayPropertiesKHR<'a> {
    #[inline]
    pub fn display(mut self, display: DisplayKHR) -> Self {
        self.display = display;
        self
    }
    #[inline]
    pub fn display_name(mut self, display_name: &'a CStr) -> Self {
        self.display_name = display_name.as_ptr();
        self
    }
    #[inline]
    pub unsafe fn display_name_as_c_str(&self) -> Option<&CStr> {
        if self.display_name.is_null() {
            None
        } else {
            Some(CStr::from_ptr(self.display_name))
        }
    }
    #[inline]
    pub fn physical_dimensions(mut self, physical_dimensions: Extent2D) -> Self {
        self.physical_dimensions = physical_dimensions;
        self
    }
    #[inline]
    pub fn physical_resolution(mut self, physical_resolution: Extent2D) -> Self {
        self.physical_resolution = physical_resolution;
        self
    }
    #[inline]
    pub fn supported_transforms(mut self, supported_transforms: SurfaceTransformFlagsKHR) -> Self {
        self.supported_transforms = supported_transforms;
        self
    }
    #[inline]
    pub fn plane_reorder_possible(mut self, plane_reorder_possible: bool) -> Self {
        self.plane_reorder_possible = plane_reorder_possible.into();
        self
    }
    #[inline]
    pub fn persistent_content(mut self, persistent_content: bool) -> Self {
        self.persistent_content = persistent_content.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayPlanePropertiesKHR.html>"]
#[must_use]
pub struct DisplayPlanePropertiesKHR {
    pub current_display: DisplayKHR,
    pub current_stack_index: u32,
}
impl DisplayPlanePropertiesKHR {
    #[inline]
    pub fn current_display(mut self, current_display: DisplayKHR) -> Self {
        self.current_display = current_display;
        self
    }
    #[inline]
    pub fn current_stack_index(mut self, current_stack_index: u32) -> Self {
        self.current_stack_index = current_stack_index;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayModeParametersKHR.html>"]
#[must_use]
pub struct DisplayModeParametersKHR {
    pub visible_region: Extent2D,
    pub refresh_rate: u32,
}
impl DisplayModeParametersKHR {
    #[inline]
    pub fn visible_region(mut self, visible_region: Extent2D) -> Self {
        self.visible_region = visible_region;
        self
    }
    #[inline]
    pub fn refresh_rate(mut self, refresh_rate: u32) -> Self {
        self.refresh_rate = refresh_rate;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayModePropertiesKHR.html>"]
#[must_use]
pub struct DisplayModePropertiesKHR {
    pub display_mode: DisplayModeKHR,
    pub parameters: DisplayModeParametersKHR,
}
impl DisplayModePropertiesKHR {
    #[inline]
    pub fn display_mode(mut self, display_mode: DisplayModeKHR) -> Self {
        self.display_mode = display_mode;
        self
    }
    #[inline]
    pub fn parameters(mut self, parameters: DisplayModeParametersKHR) -> Self {
        self.parameters = parameters;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayModeCreateInfoKHR.html>"]
#[must_use]
pub struct DisplayModeCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DisplayModeCreateFlagsKHR,
    pub parameters: DisplayModeParametersKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DisplayModeCreateInfoKHR<'_> {}
unsafe impl Sync for DisplayModeCreateInfoKHR<'_> {}
impl ::core::default::Default for DisplayModeCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DisplayModeCreateFlagsKHR::default(),
            parameters: DisplayModeParametersKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DisplayModeCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_MODE_CREATE_INFO_KHR;
}
impl<'a> DisplayModeCreateInfoKHR<'a> {
    #[inline]
    pub fn flags(mut self, flags: DisplayModeCreateFlagsKHR) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn parameters(mut self, parameters: DisplayModeParametersKHR) -> Self {
        self.parameters = parameters;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayPlaneCapabilitiesKHR.html>"]
#[must_use]
pub struct DisplayPlaneCapabilitiesKHR {
    pub supported_alpha: DisplayPlaneAlphaFlagsKHR,
    pub min_src_position: Offset2D,
    pub max_src_position: Offset2D,
    pub min_src_extent: Extent2D,
    pub max_src_extent: Extent2D,
    pub min_dst_position: Offset2D,
    pub max_dst_position: Offset2D,
    pub min_dst_extent: Extent2D,
    pub max_dst_extent: Extent2D,
}
impl DisplayPlaneCapabilitiesKHR {
    #[inline]
    pub fn supported_alpha(mut self, supported_alpha: DisplayPlaneAlphaFlagsKHR) -> Self {
        self.supported_alpha = supported_alpha;
        self
    }
    #[inline]
    pub fn min_src_position(mut self, min_src_position: Offset2D) -> Self {
        self.min_src_position = min_src_position;
        self
    }
    #[inline]
    pub fn max_src_position(mut self, max_src_position: Offset2D) -> Self {
        self.max_src_position = max_src_position;
        self
    }
    #[inline]
    pub fn min_src_extent(mut self, min_src_extent: Extent2D) -> Self {
        self.min_src_extent = min_src_extent;
        self
    }
    #[inline]
    pub fn max_src_extent(mut self, max_src_extent: Extent2D) -> Self {
        self.max_src_extent = max_src_extent;
        self
    }
    #[inline]
    pub fn min_dst_position(mut self, min_dst_position: Offset2D) -> Self {
        self.min_dst_position = min_dst_position;
        self
    }
    #[inline]
    pub fn max_dst_position(mut self, max_dst_position: Offset2D) -> Self {
        self.max_dst_position = max_dst_position;
        self
    }
    #[inline]
    pub fn min_dst_extent(mut self, min_dst_extent: Extent2D) -> Self {
        self.min_dst_extent = min_dst_extent;
        self
    }
    #[inline]
    pub fn max_dst_extent(mut self, max_dst_extent: Extent2D) -> Self {
        self.max_dst_extent = max_dst_extent;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplaySurfaceCreateInfoKHR.html>"]
#[must_use]
pub struct DisplaySurfaceCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DisplaySurfaceCreateFlagsKHR,
    pub display_mode: DisplayModeKHR,
    pub plane_index: u32,
    pub plane_stack_index: u32,
    pub transform: SurfaceTransformFlagsKHR,
    pub global_alpha: f32,
    pub alpha_mode: DisplayPlaneAlphaFlagsKHR,
    pub image_extent: Extent2D,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DisplaySurfaceCreateInfoKHR<'_> {}
unsafe impl Sync for DisplaySurfaceCreateInfoKHR<'_> {}
impl ::core::default::Default for DisplaySurfaceCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DisplaySurfaceCreateFlagsKHR::default(),
            display_mode: DisplayModeKHR::default(),
            plane_index: u32::default(),
            plane_stack_index: u32::default(),
            transform: SurfaceTransformFlagsKHR::default(),
            global_alpha: f32::default(),
            alpha_mode: DisplayPlaneAlphaFlagsKHR::default(),
            image_extent: Extent2D::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DisplaySurfaceCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_SURFACE_CREATE_INFO_KHR;
}
impl<'a> DisplaySurfaceCreateInfoKHR<'a> {
    #[inline]
    pub fn flags(mut self, flags: DisplaySurfaceCreateFlagsKHR) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn display_mode(mut self, display_mode: DisplayModeKHR) -> Self {
        self.display_mode = display_mode;
        self
    }
    #[inline]
    pub fn plane_index(mut self, plane_index: u32) -> Self {
        self.plane_index = plane_index;
        self
    }
    #[inline]
    pub fn plane_stack_index(mut self, plane_stack_index: u32) -> Self {
        self.plane_stack_index = plane_stack_index;
        self
    }
    #[inline]
    pub fn transform(mut self, transform: SurfaceTransformFlagsKHR) -> Self {
        self.transform = transform;
        self
    }
    #[inline]
    pub fn global_alpha(mut self, global_alpha: f32) -> Self {
        self.global_alpha = global_alpha;
        self
    }
    #[inline]
    pub fn alpha_mode(mut self, alpha_mode: DisplayPlaneAlphaFlagsKHR) -> Self {
        self.alpha_mode = alpha_mode;
        self
    }
    #[inline]
    pub fn image_extent(mut self, image_extent: Extent2D) -> Self {
        self.image_extent = image_extent;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayPresentInfoKHR.html>"]
#[must_use]
pub struct DisplayPresentInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_rect: Rect2D,
    pub dst_rect: Rect2D,
    pub persistent: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DisplayPresentInfoKHR<'_> {}
unsafe impl Sync for DisplayPresentInfoKHR<'_> {}
impl ::core::default::Default for DisplayPresentInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            src_rect: Rect2D::default(),
            dst_rect: Rect2D::default(),
            persistent: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DisplayPresentInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_PRESENT_INFO_KHR;
}
unsafe impl ExtendsPresentInfoKHR for DisplayPresentInfoKHR<'_> {}
impl<'a> DisplayPresentInfoKHR<'a> {
    #[inline]
    pub fn src_rect(mut self, src_rect: Rect2D) -> Self {
        self.src_rect = src_rect;
        self
    }
    #[inline]
    pub fn dst_rect(mut self, dst_rect: Rect2D) -> Self {
        self.dst_rect = dst_rect;
        self
    }
    #[inline]
    pub fn persistent(mut self, persistent: bool) -> Self {
        self.persistent = persistent.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSurfaceCapabilitiesKHR.html>"]
#[must_use]
pub struct SurfaceCapabilitiesKHR {
    pub min_image_count: u32,
    pub max_image_count: u32,
    pub current_extent: Extent2D,
    pub min_image_extent: Extent2D,
    pub max_image_extent: Extent2D,
    pub max_image_array_layers: u32,
    pub supported_transforms: SurfaceTransformFlagsKHR,
    pub current_transform: SurfaceTransformFlagsKHR,
    pub supported_composite_alpha: CompositeAlphaFlagsKHR,
    pub supported_usage_flags: ImageUsageFlags,
}
impl SurfaceCapabilitiesKHR {
    #[inline]
    pub fn min_image_count(mut self, min_image_count: u32) -> Self {
        self.min_image_count = min_image_count;
        self
    }
    #[inline]
    pub fn max_image_count(mut self, max_image_count: u32) -> Self {
        self.max_image_count = max_image_count;
        self
    }
    #[inline]
    pub fn current_extent(mut self, current_extent: Extent2D) -> Self {
        self.current_extent = current_extent;
        self
    }
    #[inline]
    pub fn min_image_extent(mut self, min_image_extent: Extent2D) -> Self {
        self.min_image_extent = min_image_extent;
        self
    }
    #[inline]
    pub fn max_image_extent(mut self, max_image_extent: Extent2D) -> Self {
        self.max_image_extent = max_image_extent;
        self
    }
    #[inline]
    pub fn max_image_array_layers(mut self, max_image_array_layers: u32) -> Self {
        self.max_image_array_layers = max_image_array_layers;
        self
    }
    #[inline]
    pub fn supported_transforms(mut self, supported_transforms: SurfaceTransformFlagsKHR) -> Self {
        self.supported_transforms = supported_transforms;
        self
    }
    #[inline]
    pub fn current_transform(mut self, current_transform: SurfaceTransformFlagsKHR) -> Self {
        self.current_transform = current_transform;
        self
    }
    #[inline]
    pub fn supported_composite_alpha(
        mut self,
        supported_composite_alpha: CompositeAlphaFlagsKHR,
    ) -> Self {
        self.supported_composite_alpha = supported_composite_alpha;
        self
    }
    #[inline]
    pub fn supported_usage_flags(mut self, supported_usage_flags: ImageUsageFlags) -> Self {
        self.supported_usage_flags = supported_usage_flags;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAndroidSurfaceCreateInfoKHR.html>"]
#[must_use]
pub struct AndroidSurfaceCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: AndroidSurfaceCreateFlagsKHR,
    pub window: *mut ANativeWindow,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for AndroidSurfaceCreateInfoKHR<'_> {}
unsafe impl Sync for AndroidSurfaceCreateInfoKHR<'_> {}
impl ::core::default::Default for AndroidSurfaceCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: AndroidSurfaceCreateFlagsKHR::default(),
            window: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for AndroidSurfaceCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::ANDROID_SURFACE_CREATE_INFO_KHR;
}
impl<'a> AndroidSurfaceCreateInfoKHR<'a> {
    #[inline]
    pub fn flags(mut self, flags: AndroidSurfaceCreateFlagsKHR) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn window(mut self, window: *mut ANativeWindow) -> Self {
        self.window = window;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkViSurfaceCreateInfoNN.html>"]
#[must_use]
pub struct ViSurfaceCreateInfoNN<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ViSurfaceCreateFlagsNN,
    pub window: *mut c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ViSurfaceCreateInfoNN<'_> {}
unsafe impl Sync for ViSurfaceCreateInfoNN<'_> {}
impl ::core::default::Default for ViSurfaceCreateInfoNN<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: ViSurfaceCreateFlagsNN::default(),
            window: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ViSurfaceCreateInfoNN<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::VI_SURFACE_CREATE_INFO_NN;
}
impl<'a> ViSurfaceCreateInfoNN<'a> {
    #[inline]
    pub fn flags(mut self, flags: ViSurfaceCreateFlagsNN) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn window(mut self, window: *mut c_void) -> Self {
        self.window = window;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkWaylandSurfaceCreateInfoKHR.html>"]
#[must_use]
pub struct WaylandSurfaceCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: WaylandSurfaceCreateFlagsKHR,
    pub display: *mut wl_display,
    pub surface: *mut wl_surface,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for WaylandSurfaceCreateInfoKHR<'_> {}
unsafe impl Sync for WaylandSurfaceCreateInfoKHR<'_> {}
impl ::core::default::Default for WaylandSurfaceCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: WaylandSurfaceCreateFlagsKHR::default(),
            display: ::core::ptr::null_mut(),
            surface: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for WaylandSurfaceCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::WAYLAND_SURFACE_CREATE_INFO_KHR;
}
impl<'a> WaylandSurfaceCreateInfoKHR<'a> {
    #[inline]
    pub fn flags(mut self, flags: WaylandSurfaceCreateFlagsKHR) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn display(mut self, display: *mut wl_display) -> Self {
        self.display = display;
        self
    }
    #[inline]
    pub fn surface(mut self, surface: *mut wl_surface) -> Self {
        self.surface = surface;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkWin32SurfaceCreateInfoKHR.html>"]
#[must_use]
pub struct Win32SurfaceCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: Win32SurfaceCreateFlagsKHR,
    pub hinstance: HINSTANCE,
    pub hwnd: HWND,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for Win32SurfaceCreateInfoKHR<'_> {}
unsafe impl Sync for Win32SurfaceCreateInfoKHR<'_> {}
impl ::core::default::Default for Win32SurfaceCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: Win32SurfaceCreateFlagsKHR::default(),
            hinstance: unsafe { ::core::mem::zeroed() },
            hwnd: unsafe { ::core::mem::zeroed() },
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for Win32SurfaceCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::WIN32_SURFACE_CREATE_INFO_KHR;
}
impl<'a> Win32SurfaceCreateInfoKHR<'a> {
    #[inline]
    pub fn flags(mut self, flags: Win32SurfaceCreateFlagsKHR) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn hinstance(mut self, hinstance: HINSTANCE) -> Self {
        self.hinstance = hinstance;
        self
    }
    #[inline]
    pub fn hwnd(mut self, hwnd: HWND) -> Self {
        self.hwnd = hwnd;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkXlibSurfaceCreateInfoKHR.html>"]
#[must_use]
pub struct XlibSurfaceCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: XlibSurfaceCreateFlagsKHR,
    pub dpy: *mut Display,
    pub window: Window,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for XlibSurfaceCreateInfoKHR<'_> {}
unsafe impl Sync for XlibSurfaceCreateInfoKHR<'_> {}
impl ::core::default::Default for XlibSurfaceCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: XlibSurfaceCreateFlagsKHR::default(),
            dpy: ::core::ptr::null_mut(),
            window: Window::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for XlibSurfaceCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::XLIB_SURFACE_CREATE_INFO_KHR;
}
impl<'a> XlibSurfaceCreateInfoKHR<'a> {
    #[inline]
    pub fn flags(mut self, flags: XlibSurfaceCreateFlagsKHR) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn dpy(mut self, dpy: *mut Display) -> Self {
        self.dpy = dpy;
        self
    }
    #[inline]
    pub fn window(mut self, window: Window) -> Self {
        self.window = window;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkXcbSurfaceCreateInfoKHR.html>"]
#[must_use]
pub struct XcbSurfaceCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: XcbSurfaceCreateFlagsKHR,
    pub connection: *mut xcb_connection_t,
    pub window: xcb_window_t,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for XcbSurfaceCreateInfoKHR<'_> {}
unsafe impl Sync for XcbSurfaceCreateInfoKHR<'_> {}
impl ::core::default::Default for XcbSurfaceCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: XcbSurfaceCreateFlagsKHR::default(),
            connection: ::core::ptr::null_mut(),
            window: xcb_window_t::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for XcbSurfaceCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::XCB_SURFACE_CREATE_INFO_KHR;
}
impl<'a> XcbSurfaceCreateInfoKHR<'a> {
    #[inline]
    pub fn flags(mut self, flags: XcbSurfaceCreateFlagsKHR) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn connection(mut self, connection: *mut xcb_connection_t) -> Self {
        self.connection = connection;
        self
    }
    #[inline]
    pub fn window(mut self, window: xcb_window_t) -> Self {
        self.window = window;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDirectFBSurfaceCreateInfoEXT.html>"]
#[must_use]
pub struct DirectFBSurfaceCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DirectFBSurfaceCreateFlagsEXT,
    pub dfb: *mut IDirectFB,
    pub surface: *mut IDirectFBSurface,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DirectFBSurfaceCreateInfoEXT<'_> {}
unsafe impl Sync for DirectFBSurfaceCreateInfoEXT<'_> {}
impl ::core::default::Default for DirectFBSurfaceCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DirectFBSurfaceCreateFlagsEXT::default(),
            dfb: ::core::ptr::null_mut(),
            surface: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DirectFBSurfaceCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DIRECTFB_SURFACE_CREATE_INFO_EXT;
}
impl<'a> DirectFBSurfaceCreateInfoEXT<'a> {
    #[inline]
    pub fn flags(mut self, flags: DirectFBSurfaceCreateFlagsEXT) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn dfb(mut self, dfb: *mut IDirectFB) -> Self {
        self.dfb = dfb;
        self
    }
    #[inline]
    pub fn surface(mut self, surface: *mut IDirectFBSurface) -> Self {
        self.surface = surface;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImagePipeSurfaceCreateInfoFUCHSIA.html>"]
#[must_use]
pub struct ImagePipeSurfaceCreateInfoFUCHSIA<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ImagePipeSurfaceCreateFlagsFUCHSIA,
    pub image_pipe_handle: zx_handle_t,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImagePipeSurfaceCreateInfoFUCHSIA<'_> {}
unsafe impl Sync for ImagePipeSurfaceCreateInfoFUCHSIA<'_> {}
impl ::core::default::Default for ImagePipeSurfaceCreateInfoFUCHSIA<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: ImagePipeSurfaceCreateFlagsFUCHSIA::default(),
            image_pipe_handle: zx_handle_t::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImagePipeSurfaceCreateInfoFUCHSIA<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA;
}
impl<'a> ImagePipeSurfaceCreateInfoFUCHSIA<'a> {
    #[inline]
    pub fn flags(mut self, flags: ImagePipeSurfaceCreateFlagsFUCHSIA) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn image_pipe_handle(mut self, image_pipe_handle: zx_handle_t) -> Self {
        self.image_pipe_handle = image_pipe_handle;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkStreamDescriptorSurfaceCreateInfoGGP.html>"]
#[must_use]
pub struct StreamDescriptorSurfaceCreateInfoGGP<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: StreamDescriptorSurfaceCreateFlagsGGP,
    pub stream_descriptor: GgpStreamDescriptor,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for StreamDescriptorSurfaceCreateInfoGGP<'_> {}
unsafe impl Sync for StreamDescriptorSurfaceCreateInfoGGP<'_> {}
impl ::core::default::Default for StreamDescriptorSurfaceCreateInfoGGP<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: StreamDescriptorSurfaceCreateFlagsGGP::default(),
            stream_descriptor: GgpStreamDescriptor::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for StreamDescriptorSurfaceCreateInfoGGP<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP;
}
impl<'a> StreamDescriptorSurfaceCreateInfoGGP<'a> {
    #[inline]
    pub fn flags(mut self, flags: StreamDescriptorSurfaceCreateFlagsGGP) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn stream_descriptor(mut self, stream_descriptor: GgpStreamDescriptor) -> Self {
        self.stream_descriptor = stream_descriptor;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkScreenSurfaceCreateInfoQNX.html>"]
#[must_use]
pub struct ScreenSurfaceCreateInfoQNX<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ScreenSurfaceCreateFlagsQNX,
    pub context: *mut _screen_context,
    pub window: *mut _screen_window,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ScreenSurfaceCreateInfoQNX<'_> {}
unsafe impl Sync for ScreenSurfaceCreateInfoQNX<'_> {}
impl ::core::default::Default for ScreenSurfaceCreateInfoQNX<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: ScreenSurfaceCreateFlagsQNX::default(),
            context: ::core::ptr::null_mut(),
            window: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ScreenSurfaceCreateInfoQNX<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SCREEN_SURFACE_CREATE_INFO_QNX;
}
impl<'a> ScreenSurfaceCreateInfoQNX<'a> {
    #[inline]
    pub fn flags(mut self, flags: ScreenSurfaceCreateFlagsQNX) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn context(mut self, context: &'a mut _screen_context) -> Self {
        self.context = context;
        self
    }
    #[inline]
    pub fn window(mut self, window: &'a mut _screen_window) -> Self {
        self.window = window;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSurfaceFormatKHR.html>"]
#[must_use]
pub struct SurfaceFormatKHR {
    pub format: Format,
    pub color_space: ColorSpaceKHR,
}
impl SurfaceFormatKHR {
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.format = format;
        self
    }
    #[inline]
    pub fn color_space(mut self, color_space: ColorSpaceKHR) -> Self {
        self.color_space = color_space;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSwapchainCreateInfoKHR.html>"]
#[must_use]
pub struct SwapchainCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: SwapchainCreateFlagsKHR,
    pub surface: SurfaceKHR,
    pub min_image_count: u32,
    pub image_format: Format,
    pub image_color_space: ColorSpaceKHR,
    pub image_extent: Extent2D,
    pub image_array_layers: u32,
    pub image_usage: ImageUsageFlags,
    pub image_sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub p_queue_family_indices: *const u32,
    pub pre_transform: SurfaceTransformFlagsKHR,
    pub composite_alpha: CompositeAlphaFlagsKHR,
    pub present_mode: PresentModeKHR,
    pub clipped: Bool32,
    pub old_swapchain: SwapchainKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SwapchainCreateInfoKHR<'_> {}
unsafe impl Sync for SwapchainCreateInfoKHR<'_> {}
impl ::core::default::Default for SwapchainCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: SwapchainCreateFlagsKHR::default(),
            surface: SurfaceKHR::default(),
            min_image_count: u32::default(),
            image_format: Format::default(),
            image_color_space: ColorSpaceKHR::default(),
            image_extent: Extent2D::default(),
            image_array_layers: u32::default(),
            image_usage: ImageUsageFlags::default(),
            image_sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            p_queue_family_indices: ::core::ptr::null(),
            pre_transform: SurfaceTransformFlagsKHR::default(),
            composite_alpha: CompositeAlphaFlagsKHR::default(),
            present_mode: PresentModeKHR::default(),
            clipped: Bool32::default(),
            old_swapchain: SwapchainKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SwapchainCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SWAPCHAIN_CREATE_INFO_KHR;
}
pub unsafe trait ExtendsSwapchainCreateInfoKHR {}
impl<'a> SwapchainCreateInfoKHR<'a> {
    #[inline]
    pub fn flags(mut self, flags: SwapchainCreateFlagsKHR) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn surface(mut self, surface: SurfaceKHR) -> Self {
        self.surface = surface;
        self
    }
    #[inline]
    pub fn min_image_count(mut self, min_image_count: u32) -> Self {
        self.min_image_count = min_image_count;
        self
    }
    #[inline]
    pub fn image_format(mut self, image_format: Format) -> Self {
        self.image_format = image_format;
        self
    }
    #[inline]
    pub fn image_color_space(mut self, image_color_space: ColorSpaceKHR) -> Self {
        self.image_color_space = image_color_space;
        self
    }
    #[inline]
    pub fn image_extent(mut self, image_extent: Extent2D) -> Self {
        self.image_extent = image_extent;
        self
    }
    #[inline]
    pub fn image_array_layers(mut self, image_array_layers: u32) -> Self {
        self.image_array_layers = image_array_layers;
        self
    }
    #[inline]
    pub fn image_usage(mut self, image_usage: ImageUsageFlags) -> Self {
        self.image_usage = image_usage;
        self
    }
    #[inline]
    pub fn image_sharing_mode(mut self, image_sharing_mode: SharingMode) -> Self {
        self.image_sharing_mode = image_sharing_mode;
        self
    }
    #[inline]
    pub fn queue_family_indices(mut self, queue_family_indices: &'a [u32]) -> Self {
        self.queue_family_index_count = queue_family_indices.len() as _;
        self.p_queue_family_indices = queue_family_indices.as_ptr();
        self
    }
    #[inline]
    pub fn pre_transform(mut self, pre_transform: SurfaceTransformFlagsKHR) -> Self {
        self.pre_transform = pre_transform;
        self
    }
    #[inline]
    pub fn composite_alpha(mut self, composite_alpha: CompositeAlphaFlagsKHR) -> Self {
        self.composite_alpha = composite_alpha;
        self
    }
    #[inline]
    pub fn present_mode(mut self, present_mode: PresentModeKHR) -> Self {
        self.present_mode = present_mode;
        self
    }
    #[inline]
    pub fn clipped(mut self, clipped: bool) -> Self {
        self.clipped = clipped.into();
        self
    }
    #[inline]
    pub fn old_swapchain(mut self, old_swapchain: SwapchainKHR) -> Self {
        self.old_swapchain = old_swapchain;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSwapchainCreateInfoKHR + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPresentInfoKHR.html>"]
#[must_use]
pub struct PresentInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_count: u32,
    pub p_wait_semaphores: *const Semaphore,
    pub swapchain_count: u32,
    pub p_swapchains: *const SwapchainKHR,
    pub p_image_indices: *const u32,
    pub p_results: *mut Result,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PresentInfoKHR<'_> {}
unsafe impl Sync for PresentInfoKHR<'_> {}
impl ::core::default::Default for PresentInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            wait_semaphore_count: u32::default(),
            p_wait_semaphores: ::core::ptr::null(),
            swapchain_count: u32::default(),
            p_swapchains: ::core::ptr::null(),
            p_image_indices: ::core::ptr::null(),
            p_results: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PresentInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PRESENT_INFO_KHR;
}
pub unsafe trait ExtendsPresentInfoKHR {}
impl<'a> PresentInfoKHR<'a> {
    #[inline]
    pub fn wait_semaphores(mut self, wait_semaphores: &'a [Semaphore]) -> Self {
        self.wait_semaphore_count = wait_semaphores.len() as _;
        self.p_wait_semaphores = wait_semaphores.as_ptr();
        self
    }
    #[inline]
    pub fn swapchains(mut self, swapchains: &'a [SwapchainKHR]) -> Self {
        self.swapchain_count = swapchains.len() as _;
        self.p_swapchains = swapchains.as_ptr();
        self
    }
    #[inline]
    pub fn image_indices(mut self, image_indices: &'a [u32]) -> Self {
        self.swapchain_count = image_indices.len() as _;
        self.p_image_indices = image_indices.as_ptr();
        self
    }
    #[inline]
    pub fn results(mut self, results: &'a mut [Result]) -> Self {
        self.swapchain_count = results.len() as _;
        self.p_results = results.as_mut_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPresentInfoKHR + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugReportCallbackCreateInfoEXT.html>"]
#[must_use]
pub struct DebugReportCallbackCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DebugReportFlagsEXT,
    pub pfn_callback: PFN_vkDebugReportCallbackEXT,
    pub p_user_data: *mut c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DebugReportCallbackCreateInfoEXT<'_> {}
unsafe impl Sync for DebugReportCallbackCreateInfoEXT<'_> {}
#[cfg(feature = "debug")]
impl fmt::Debug for DebugReportCallbackCreateInfoEXT<'_> {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("DebugReportCallbackCreateInfoEXT")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("flags", &self.flags)
            .field("pfn_callback", &(self.pfn_callback.map(|x| x as *const ())))
            .field("p_user_data", &self.p_user_data)
            .finish()
    }
}
impl ::core::default::Default for DebugReportCallbackCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DebugReportFlagsEXT::default(),
            pfn_callback: PFN_vkDebugReportCallbackEXT::default(),
            p_user_data: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DebugReportCallbackCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT;
}
unsafe impl ExtendsInstanceCreateInfo for DebugReportCallbackCreateInfoEXT<'_> {}
impl<'a> DebugReportCallbackCreateInfoEXT<'a> {
    #[inline]
    pub fn flags(mut self, flags: DebugReportFlagsEXT) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn pfn_callback(mut self, pfn_callback: PFN_vkDebugReportCallbackEXT) -> Self {
        self.pfn_callback = pfn_callback;
        self
    }
    #[inline]
    pub fn user_data(mut self, user_data: *mut c_void) -> Self {
        self.p_user_data = user_data;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkValidationFlagsEXT.html>"]
#[must_use]
pub struct ValidationFlagsEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub disabled_validation_check_count: u32,
    pub p_disabled_validation_checks: *const ValidationCheckEXT,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ValidationFlagsEXT<'_> {}
unsafe impl Sync for ValidationFlagsEXT<'_> {}
impl ::core::default::Default for ValidationFlagsEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            disabled_validation_check_count: u32::default(),
            p_disabled_validation_checks: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ValidationFlagsEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::VALIDATION_FLAGS_EXT;
}
unsafe impl ExtendsInstanceCreateInfo for ValidationFlagsEXT<'_> {}
impl<'a> ValidationFlagsEXT<'a> {
    #[inline]
    pub fn disabled_validation_checks(
        mut self,
        disabled_validation_checks: &'a [ValidationCheckEXT],
    ) -> Self {
        self.disabled_validation_check_count = disabled_validation_checks.len() as _;
        self.p_disabled_validation_checks = disabled_validation_checks.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkValidationFeaturesEXT.html>"]
#[must_use]
pub struct ValidationFeaturesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub enabled_validation_feature_count: u32,
    pub p_enabled_validation_features: *const ValidationFeatureEnableEXT,
    pub disabled_validation_feature_count: u32,
    pub p_disabled_validation_features: *const ValidationFeatureDisableEXT,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ValidationFeaturesEXT<'_> {}
unsafe impl Sync for ValidationFeaturesEXT<'_> {}
impl ::core::default::Default for ValidationFeaturesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            enabled_validation_feature_count: u32::default(),
            p_enabled_validation_features: ::core::ptr::null(),
            disabled_validation_feature_count: u32::default(),
            p_disabled_validation_features: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ValidationFeaturesEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::VALIDATION_FEATURES_EXT;
}
unsafe impl ExtendsInstanceCreateInfo for ValidationFeaturesEXT<'_> {}
impl<'a> ValidationFeaturesEXT<'a> {
    #[inline]
    pub fn enabled_validation_features(
        mut self,
        enabled_validation_features: &'a [ValidationFeatureEnableEXT],
    ) -> Self {
        self.enabled_validation_feature_count = enabled_validation_features.len() as _;
        self.p_enabled_validation_features = enabled_validation_features.as_ptr();
        self
    }
    #[inline]
    pub fn disabled_validation_features(
        mut self,
        disabled_validation_features: &'a [ValidationFeatureDisableEXT],
    ) -> Self {
        self.disabled_validation_feature_count = disabled_validation_features.len() as _;
        self.p_disabled_validation_features = disabled_validation_features.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkLayerSettingsCreateInfoEXT.html>"]
#[must_use]
pub struct LayerSettingsCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub setting_count: u32,
    pub p_settings: *const LayerSettingEXT<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for LayerSettingsCreateInfoEXT<'_> {}
unsafe impl Sync for LayerSettingsCreateInfoEXT<'_> {}
impl ::core::default::Default for LayerSettingsCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            setting_count: u32::default(),
            p_settings: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for LayerSettingsCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::LAYER_SETTINGS_CREATE_INFO_EXT;
}
unsafe impl ExtendsInstanceCreateInfo for LayerSettingsCreateInfoEXT<'_> {}
impl<'a> LayerSettingsCreateInfoEXT<'a> {
    #[inline]
    pub fn settings(mut self, settings: &'a [LayerSettingEXT<'a>]) -> Self {
        self.setting_count = settings.len() as _;
        self.p_settings = settings.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkLayerSettingEXT.html>"]
#[must_use]
pub struct LayerSettingEXT<'a> {
    pub p_layer_name: *const c_char,
    pub p_setting_name: *const c_char,
    pub ty: LayerSettingTypeEXT,
    pub value_count: u32,
    pub p_values: *const c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for LayerSettingEXT<'_> {}
unsafe impl Sync for LayerSettingEXT<'_> {}
impl ::core::default::Default for LayerSettingEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            p_layer_name: ::core::ptr::null(),
            p_setting_name: ::core::ptr::null(),
            ty: LayerSettingTypeEXT::default(),
            value_count: u32::default(),
            p_values: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
impl<'a> LayerSettingEXT<'a> {
    #[inline]
    pub fn layer_name(mut self, layer_name: &'a CStr) -> Self {
        self.p_layer_name = layer_name.as_ptr();
        self
    }
    #[inline]
    pub unsafe fn layer_name_as_c_str(&self) -> Option<&CStr> {
        if self.p_layer_name.is_null() {
            None
        } else {
            Some(CStr::from_ptr(self.p_layer_name))
        }
    }
    #[inline]
    pub fn setting_name(mut self, setting_name: &'a CStr) -> Self {
        self.p_setting_name = setting_name.as_ptr();
        self
    }
    #[inline]
    pub unsafe fn setting_name_as_c_str(&self) -> Option<&CStr> {
        if self.p_setting_name.is_null() {
            None
        } else {
            Some(CStr::from_ptr(self.p_setting_name))
        }
    }
    #[inline]
    pub fn ty(mut self, ty: LayerSettingTypeEXT) -> Self {
        self.ty = ty;
        self
    }
    #[inline]
    pub fn values(mut self, values: &'a [u8]) -> Self {
        self.value_count = values.len() as _;
        self.p_values = values.as_ptr().cast();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationStateRasterizationOrderAMD.html>"]
#[must_use]
pub struct PipelineRasterizationStateRasterizationOrderAMD<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub rasterization_order: RasterizationOrderAMD,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineRasterizationStateRasterizationOrderAMD<'_> {}
unsafe impl Sync for PipelineRasterizationStateRasterizationOrderAMD<'_> {}
impl ::core::default::Default for PipelineRasterizationStateRasterizationOrderAMD<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            rasterization_order: RasterizationOrderAMD::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineRasterizationStateRasterizationOrderAMD<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD;
}
unsafe impl ExtendsPipelineRasterizationStateCreateInfo
    for PipelineRasterizationStateRasterizationOrderAMD<'_>
{
}
impl<'a> PipelineRasterizationStateRasterizationOrderAMD<'a> {
    #[inline]
    pub fn rasterization_order(mut self, rasterization_order: RasterizationOrderAMD) -> Self {
        self.rasterization_order = rasterization_order;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugMarkerObjectNameInfoEXT.html>"]
#[must_use]
pub struct DebugMarkerObjectNameInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub object_type: DebugReportObjectTypeEXT,
    pub object: u64,
    pub p_object_name: *const c_char,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DebugMarkerObjectNameInfoEXT<'_> {}
unsafe impl Sync for DebugMarkerObjectNameInfoEXT<'_> {}
impl ::core::default::Default for DebugMarkerObjectNameInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            object_type: DebugReportObjectTypeEXT::default(),
            object: u64::default(),
            p_object_name: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DebugMarkerObjectNameInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_MARKER_OBJECT_NAME_INFO_EXT;
}
impl<'a> DebugMarkerObjectNameInfoEXT<'a> {
    #[inline]
    pub fn object_type(mut self, object_type: DebugReportObjectTypeEXT) -> Self {
        self.object_type = object_type;
        self
    }
    #[inline]
    pub fn object(mut self, object: u64) -> Self {
        self.object = object;
        self
    }
    #[inline]
    pub fn object_name(mut self, object_name: &'a CStr) -> Self {
        self.p_object_name = object_name.as_ptr();
        self
    }
    #[inline]
    pub unsafe fn object_name_as_c_str(&self) -> Option<&CStr> {
        if self.p_object_name.is_null() {
            None
        } else {
            Some(CStr::from_ptr(self.p_object_name))
        }
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugMarkerObjectTagInfoEXT.html>"]
#[must_use]
pub struct DebugMarkerObjectTagInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub object_type: DebugReportObjectTypeEXT,
    pub object: u64,
    pub tag_name: u64,
    pub tag_size: usize,
    pub p_tag: *const c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DebugMarkerObjectTagInfoEXT<'_> {}
unsafe impl Sync for DebugMarkerObjectTagInfoEXT<'_> {}
impl ::core::default::Default for DebugMarkerObjectTagInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            object_type: DebugReportObjectTypeEXT::default(),
            object: u64::default(),
            tag_name: u64::default(),
            tag_size: usize::default(),
            p_tag: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DebugMarkerObjectTagInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_MARKER_OBJECT_TAG_INFO_EXT;
}
impl<'a> DebugMarkerObjectTagInfoEXT<'a> {
    #[inline]
    pub fn object_type(mut self, object_type: DebugReportObjectTypeEXT) -> Self {
        self.object_type = object_type;
        self
    }
    #[inline]
    pub fn object(mut self, object: u64) -> Self {
        self.object = object;
        self
    }
    #[inline]
    pub fn tag_name(mut self, tag_name: u64) -> Self {
        self.tag_name = tag_name;
        self
    }
    #[inline]
    pub fn tag(mut self, tag: &'a [u8]) -> Self {
        self.tag_size = tag.len();
        self.p_tag = tag.as_ptr().cast();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugMarkerMarkerInfoEXT.html>"]
#[must_use]
pub struct DebugMarkerMarkerInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_marker_name: *const c_char,
    pub color: [f32; 4],
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DebugMarkerMarkerInfoEXT<'_> {}
unsafe impl Sync for DebugMarkerMarkerInfoEXT<'_> {}
impl ::core::default::Default for DebugMarkerMarkerInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            p_marker_name: ::core::ptr::null(),
            color: unsafe { ::core::mem::zeroed() },
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DebugMarkerMarkerInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_MARKER_MARKER_INFO_EXT;
}
impl<'a> DebugMarkerMarkerInfoEXT<'a> {
    #[inline]
    pub fn marker_name(mut self, marker_name: &'a CStr) -> Self {
        self.p_marker_name = marker_name.as_ptr();
        self
    }
    #[inline]
    pub unsafe fn marker_name_as_c_str(&self) -> Option<&CStr> {
        if self.p_marker_name.is_null() {
            None
        } else {
            Some(CStr::from_ptr(self.p_marker_name))
        }
    }
    #[inline]
    pub fn color(mut self, color: [f32; 4]) -> Self {
        self.color = color;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDedicatedAllocationImageCreateInfoNV.html>"]
#[must_use]
pub struct DedicatedAllocationImageCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub dedicated_allocation: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DedicatedAllocationImageCreateInfoNV<'_> {}
unsafe impl Sync for DedicatedAllocationImageCreateInfoNV<'_> {}
impl ::core::default::Default for DedicatedAllocationImageCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            dedicated_allocation: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DedicatedAllocationImageCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV;
}
unsafe impl ExtendsImageCreateInfo for DedicatedAllocationImageCreateInfoNV<'_> {}
impl<'a> DedicatedAllocationImageCreateInfoNV<'a> {
    #[inline]
    pub fn dedicated_allocation(mut self, dedicated_allocation: bool) -> Self {
        self.dedicated_allocation = dedicated_allocation.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDedicatedAllocationBufferCreateInfoNV.html>"]
#[must_use]
pub struct DedicatedAllocationBufferCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub dedicated_allocation: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DedicatedAllocationBufferCreateInfoNV<'_> {}
unsafe impl Sync for DedicatedAllocationBufferCreateInfoNV<'_> {}
impl ::core::default::Default for DedicatedAllocationBufferCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            dedicated_allocation: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DedicatedAllocationBufferCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV;
}
unsafe impl ExtendsBufferCreateInfo for DedicatedAllocationBufferCreateInfoNV<'_> {}
impl<'a> DedicatedAllocationBufferCreateInfoNV<'a> {
    #[inline]
    pub fn dedicated_allocation(mut self, dedicated_allocation: bool) -> Self {
        self.dedicated_allocation = dedicated_allocation.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDedicatedAllocationMemoryAllocateInfoNV.html>"]
#[must_use]
pub struct DedicatedAllocationMemoryAllocateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub image: Image,
    pub buffer: Buffer,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DedicatedAllocationMemoryAllocateInfoNV<'_> {}
unsafe impl Sync for DedicatedAllocationMemoryAllocateInfoNV<'_> {}
impl ::core::default::Default for DedicatedAllocationMemoryAllocateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            image: Image::default(),
            buffer: Buffer::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DedicatedAllocationMemoryAllocateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV;
}
unsafe impl ExtendsMemoryAllocateInfo for DedicatedAllocationMemoryAllocateInfoNV<'_> {}
impl<'a> DedicatedAllocationMemoryAllocateInfoNV<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.image = image;
        self
    }
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.buffer = buffer;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExternalImageFormatPropertiesNV.html>"]
#[must_use]
pub struct ExternalImageFormatPropertiesNV {
    pub image_format_properties: ImageFormatProperties,
    pub external_memory_features: ExternalMemoryFeatureFlagsNV,
    pub export_from_imported_handle_types: ExternalMemoryHandleTypeFlagsNV,
    pub compatible_handle_types: ExternalMemoryHandleTypeFlagsNV,
}
impl ExternalImageFormatPropertiesNV {
    #[inline]
    pub fn image_format_properties(
        mut self,
        image_format_properties: ImageFormatProperties,
    ) -> Self {
        self.image_format_properties = image_format_properties;
        self
    }
    #[inline]
    pub fn external_memory_features(
        mut self,
        external_memory_features: ExternalMemoryFeatureFlagsNV,
    ) -> Self {
        self.external_memory_features = external_memory_features;
        self
    }
    #[inline]
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalMemoryHandleTypeFlagsNV,
    ) -> Self {
        self.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }
    #[inline]
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalMemoryHandleTypeFlagsNV,
    ) -> Self {
        self.compatible_handle_types = compatible_handle_types;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExternalMemoryImageCreateInfoNV.html>"]
#[must_use]
pub struct ExternalMemoryImageCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlagsNV,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExternalMemoryImageCreateInfoNV<'_> {}
unsafe impl Sync for ExternalMemoryImageCreateInfoNV<'_> {}
impl ::core::default::Default for ExternalMemoryImageCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlagsNV::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExternalMemoryImageCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV;
}
unsafe impl ExtendsImageCreateInfo for ExternalMemoryImageCreateInfoNV<'_> {}
impl<'a> ExternalMemoryImageCreateInfoNV<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlagsNV) -> Self {
        self.handle_types = handle_types;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExportMemoryAllocateInfoNV.html>"]
#[must_use]
pub struct ExportMemoryAllocateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlagsNV,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExportMemoryAllocateInfoNV<'_> {}
unsafe impl Sync for ExportMemoryAllocateInfoNV<'_> {}
impl ::core::default::Default for ExportMemoryAllocateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlagsNV::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExportMemoryAllocateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_MEMORY_ALLOCATE_INFO_NV;
}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryAllocateInfoNV<'_> {}
impl<'a> ExportMemoryAllocateInfoNV<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlagsNV) -> Self {
        self.handle_types = handle_types;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImportMemoryWin32HandleInfoNV.html>"]
#[must_use]
pub struct ImportMemoryWin32HandleInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlagsNV,
    pub handle: HANDLE,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImportMemoryWin32HandleInfoNV<'_> {}
unsafe impl Sync for ImportMemoryWin32HandleInfoNV<'_> {}
impl ::core::default::Default for ImportMemoryWin32HandleInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlagsNV::default(),
            handle: unsafe { ::core::mem::zeroed() },
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImportMemoryWin32HandleInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_MEMORY_WIN32_HANDLE_INFO_NV;
}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryWin32HandleInfoNV<'_> {}
impl<'a> ImportMemoryWin32HandleInfoNV<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlagsNV) -> Self {
        self.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn handle(mut self, handle: HANDLE) -> Self {
        self.handle = handle;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExportMemoryWin32HandleInfoNV.html>"]
#[must_use]
pub struct ExportMemoryWin32HandleInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExportMemoryWin32HandleInfoNV<'_> {}
unsafe impl Sync for ExportMemoryWin32HandleInfoNV<'_> {}
impl ::core::default::Default for ExportMemoryWin32HandleInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            p_attributes: ::core::ptr::null(),
            dw_access: DWORD::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExportMemoryWin32HandleInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_MEMORY_WIN32_HANDLE_INFO_NV;
}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryWin32HandleInfoNV<'_> {}
impl<'a> ExportMemoryWin32HandleInfoNV<'a> {
    #[inline]
    pub fn attributes(mut self, attributes: &'a SECURITY_ATTRIBUTES) -> Self {
        self.p_attributes = attributes;
        self
    }
    #[inline]
    pub fn dw_access(mut self, dw_access: DWORD) -> Self {
        self.dw_access = dw_access;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkWin32KeyedMutexAcquireReleaseInfoNV.html>"]
#[must_use]
pub struct Win32KeyedMutexAcquireReleaseInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub acquire_count: u32,
    pub p_acquire_syncs: *const DeviceMemory,
    pub p_acquire_keys: *const u64,
    pub p_acquire_timeout_milliseconds: *const u32,
    pub release_count: u32,
    pub p_release_syncs: *const DeviceMemory,
    pub p_release_keys: *const u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for Win32KeyedMutexAcquireReleaseInfoNV<'_> {}
unsafe impl Sync for Win32KeyedMutexAcquireReleaseInfoNV<'_> {}
impl ::core::default::Default for Win32KeyedMutexAcquireReleaseInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            acquire_count: u32::default(),
            p_acquire_syncs: ::core::ptr::null(),
            p_acquire_keys: ::core::ptr::null(),
            p_acquire_timeout_milliseconds: ::core::ptr::null(),
            release_count: u32::default(),
            p_release_syncs: ::core::ptr::null(),
            p_release_keys: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for Win32KeyedMutexAcquireReleaseInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV;
}
unsafe impl ExtendsSubmitInfo for Win32KeyedMutexAcquireReleaseInfoNV<'_> {}
unsafe impl ExtendsSubmitInfo2 for Win32KeyedMutexAcquireReleaseInfoNV<'_> {}
impl<'a> Win32KeyedMutexAcquireReleaseInfoNV<'a> {
    #[inline]
    pub fn acquire_syncs(mut self, acquire_syncs: &'a [DeviceMemory]) -> Self {
        self.acquire_count = acquire_syncs.len() as _;
        self.p_acquire_syncs = acquire_syncs.as_ptr();
        self
    }
    #[inline]
    pub fn acquire_keys(mut self, acquire_keys: &'a [u64]) -> Self {
        self.acquire_count = acquire_keys.len() as _;
        self.p_acquire_keys = acquire_keys.as_ptr();
        self
    }
    #[inline]
    pub fn acquire_timeout_milliseconds(mut self, acquire_timeout_milliseconds: &'a [u32]) -> Self {
        self.acquire_count = acquire_timeout_milliseconds.len() as _;
        self.p_acquire_timeout_milliseconds = acquire_timeout_milliseconds.as_ptr();
        self
    }
    #[inline]
    pub fn release_syncs(mut self, release_syncs: &'a [DeviceMemory]) -> Self {
        self.release_count = release_syncs.len() as _;
        self.p_release_syncs = release_syncs.as_ptr();
        self
    }
    #[inline]
    pub fn release_keys(mut self, release_keys: &'a [u64]) -> Self {
        self.release_count = release_keys.len() as _;
        self.p_release_keys = release_keys.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV.html>"]
#[must_use]
pub struct PhysicalDeviceDeviceGeneratedCommandsFeaturesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub device_generated_commands: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV<'_> {}
unsafe impl Sync for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            device_generated_commands: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV<'_> {}
impl<'a> PhysicalDeviceDeviceGeneratedCommandsFeaturesNV<'a> {
    #[inline]
    pub fn device_generated_commands(mut self, device_generated_commands: bool) -> Self {
        self.device_generated_commands = device_generated_commands.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV.html>"]
#[must_use]
pub struct PhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub device_generated_compute: Bool32,
    pub device_generated_compute_pipelines: Bool32,
    pub device_generated_compute_capture_replay: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV<'_> {}
unsafe impl Sync for PhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            device_generated_compute: Bool32::default(),
            device_generated_compute_pipelines: Bool32::default(),
            device_generated_compute_capture_replay: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV;
}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV<'_>
{
}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV<'_> {}
impl<'a> PhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV<'a> {
    #[inline]
    pub fn device_generated_compute(mut self, device_generated_compute: bool) -> Self {
        self.device_generated_compute = device_generated_compute.into();
        self
    }
    #[inline]
    pub fn device_generated_compute_pipelines(
        mut self,
        device_generated_compute_pipelines: bool,
    ) -> Self {
        self.device_generated_compute_pipelines = device_generated_compute_pipelines.into();
        self
    }
    #[inline]
    pub fn device_generated_compute_capture_replay(
        mut self,
        device_generated_compute_capture_replay: bool,
    ) -> Self {
        self.device_generated_compute_capture_replay =
            device_generated_compute_capture_replay.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDevicePrivateDataCreateInfo.html>"]
#[must_use]
pub struct DevicePrivateDataCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub private_data_slot_request_count: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DevicePrivateDataCreateInfo<'_> {}
unsafe impl Sync for DevicePrivateDataCreateInfo<'_> {}
impl ::core::default::Default for DevicePrivateDataCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            private_data_slot_request_count: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DevicePrivateDataCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_PRIVATE_DATA_CREATE_INFO;
}
unsafe impl ExtendsDeviceCreateInfo for DevicePrivateDataCreateInfo<'_> {}
impl<'a> DevicePrivateDataCreateInfo<'a> {
    #[inline]
    pub fn private_data_slot_request_count(mut self, private_data_slot_request_count: u32) -> Self {
        self.private_data_slot_request_count = private_data_slot_request_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPrivateDataSlotCreateInfo.html>"]
#[must_use]
pub struct PrivateDataSlotCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PrivateDataSlotCreateFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PrivateDataSlotCreateInfo<'_> {}
unsafe impl Sync for PrivateDataSlotCreateInfo<'_> {}
impl ::core::default::Default for PrivateDataSlotCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PrivateDataSlotCreateFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PrivateDataSlotCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PRIVATE_DATA_SLOT_CREATE_INFO;
}
impl<'a> PrivateDataSlotCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: PrivateDataSlotCreateFlags) -> Self {
        self.flags = flags;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevicePrivateDataFeatures.html>"]
#[must_use]
pub struct PhysicalDevicePrivateDataFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub private_data: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDevicePrivateDataFeatures<'_> {}
unsafe impl Sync for PhysicalDevicePrivateDataFeatures<'_> {}
impl ::core::default::Default for PhysicalDevicePrivateDataFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            private_data: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDevicePrivateDataFeatures<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePrivateDataFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePrivateDataFeatures<'_> {}
impl<'a> PhysicalDevicePrivateDataFeatures<'a> {
    #[inline]
    pub fn private_data(mut self, private_data: bool) -> Self {
        self.private_data = private_data.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV.html>"]
#[must_use]
pub struct PhysicalDeviceDeviceGeneratedCommandsPropertiesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_graphics_shader_group_count: u32,
    pub max_indirect_sequence_count: u32,
    pub max_indirect_commands_token_count: u32,
    pub max_indirect_commands_stream_count: u32,
    pub max_indirect_commands_token_offset: u32,
    pub max_indirect_commands_stream_stride: u32,
    pub min_sequences_count_buffer_offset_alignment: u32,
    pub min_sequences_index_buffer_offset_alignment: u32,
    pub min_indirect_commands_buffer_offset_alignment: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV<'_> {}
unsafe impl Sync for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_graphics_shader_group_count: u32::default(),
            max_indirect_sequence_count: u32::default(),
            max_indirect_commands_token_count: u32::default(),
            max_indirect_commands_stream_count: u32::default(),
            max_indirect_commands_token_offset: u32::default(),
            max_indirect_commands_stream_stride: u32::default(),
            min_sequences_count_buffer_offset_alignment: u32::default(),
            min_sequences_index_buffer_offset_alignment: u32::default(),
            min_indirect_commands_buffer_offset_alignment: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV;
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV<'_>
{
}
impl<'a> PhysicalDeviceDeviceGeneratedCommandsPropertiesNV<'a> {
    #[inline]
    pub fn max_graphics_shader_group_count(mut self, max_graphics_shader_group_count: u32) -> Self {
        self.max_graphics_shader_group_count = max_graphics_shader_group_count;
        self
    }
    #[inline]
    pub fn max_indirect_sequence_count(mut self, max_indirect_sequence_count: u32) -> Self {
        self.max_indirect_sequence_count = max_indirect_sequence_count;
        self
    }
    #[inline]
    pub fn max_indirect_commands_token_count(
        mut self,
        max_indirect_commands_token_count: u32,
    ) -> Self {
        self.max_indirect_commands_token_count = max_indirect_commands_token_count;
        self
    }
    #[inline]
    pub fn max_indirect_commands_stream_count(
        mut self,
        max_indirect_commands_stream_count: u32,
    ) -> Self {
        self.max_indirect_commands_stream_count = max_indirect_commands_stream_count;
        self
    }
    #[inline]
    pub fn max_indirect_commands_token_offset(
        mut self,
        max_indirect_commands_token_offset: u32,
    ) -> Self {
        self.max_indirect_commands_token_offset = max_indirect_commands_token_offset;
        self
    }
    #[inline]
    pub fn max_indirect_commands_stream_stride(
        mut self,
        max_indirect_commands_stream_stride: u32,
    ) -> Self {
        self.max_indirect_commands_stream_stride = max_indirect_commands_stream_stride;
        self
    }
    #[inline]
    pub fn min_sequences_count_buffer_offset_alignment(
        mut self,
        min_sequences_count_buffer_offset_alignment: u32,
    ) -> Self {
        self.min_sequences_count_buffer_offset_alignment =
            min_sequences_count_buffer_offset_alignment;
        self
    }
    #[inline]
    pub fn min_sequences_index_buffer_offset_alignment(
        mut self,
        min_sequences_index_buffer_offset_alignment: u32,
    ) -> Self {
        self.min_sequences_index_buffer_offset_alignment =
            min_sequences_index_buffer_offset_alignment;
        self
    }
    #[inline]
    pub fn min_indirect_commands_buffer_offset_alignment(
        mut self,
        min_indirect_commands_buffer_offset_alignment: u32,
    ) -> Self {
        self.min_indirect_commands_buffer_offset_alignment =
            min_indirect_commands_buffer_offset_alignment;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMultiDrawPropertiesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceMultiDrawPropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_multi_draw_count: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMultiDrawPropertiesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceMultiDrawPropertiesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceMultiDrawPropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_multi_draw_count: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMultiDrawPropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMultiDrawPropertiesEXT<'_> {}
impl<'a> PhysicalDeviceMultiDrawPropertiesEXT<'a> {
    #[inline]
    pub fn max_multi_draw_count(mut self, max_multi_draw_count: u32) -> Self {
        self.max_multi_draw_count = max_multi_draw_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkGraphicsShaderGroupCreateInfoNV.html>"]
#[must_use]
pub struct GraphicsShaderGroupCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub stage_count: u32,
    pub p_stages: *const PipelineShaderStageCreateInfo<'a>,
    pub p_vertex_input_state: *const PipelineVertexInputStateCreateInfo<'a>,
    pub p_tessellation_state: *const PipelineTessellationStateCreateInfo<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for GraphicsShaderGroupCreateInfoNV<'_> {}
unsafe impl Sync for GraphicsShaderGroupCreateInfoNV<'_> {}
impl ::core::default::Default for GraphicsShaderGroupCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            stage_count: u32::default(),
            p_stages: ::core::ptr::null(),
            p_vertex_input_state: ::core::ptr::null(),
            p_tessellation_state: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for GraphicsShaderGroupCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::GRAPHICS_SHADER_GROUP_CREATE_INFO_NV;
}
impl<'a> GraphicsShaderGroupCreateInfoNV<'a> {
    #[inline]
    pub fn stages(mut self, stages: &'a [PipelineShaderStageCreateInfo<'a>]) -> Self {
        self.stage_count = stages.len() as _;
        self.p_stages = stages.as_ptr();
        self
    }
    #[inline]
    pub fn vertex_input_state(
        mut self,
        vertex_input_state: &'a PipelineVertexInputStateCreateInfo<'a>,
    ) -> Self {
        self.p_vertex_input_state = vertex_input_state;
        self
    }
    #[inline]
    pub fn tessellation_state(
        mut self,
        tessellation_state: &'a PipelineTessellationStateCreateInfo<'a>,
    ) -> Self {
        self.p_tessellation_state = tessellation_state;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkGraphicsPipelineShaderGroupsCreateInfoNV.html>"]
#[must_use]
pub struct GraphicsPipelineShaderGroupsCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub group_count: u32,
    pub p_groups: *const GraphicsShaderGroupCreateInfoNV<'a>,
    pub pipeline_count: u32,
    pub p_pipelines: *const Pipeline,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for GraphicsPipelineShaderGroupsCreateInfoNV<'_> {}
unsafe impl Sync for GraphicsPipelineShaderGroupsCreateInfoNV<'_> {}
impl ::core::default::Default for GraphicsPipelineShaderGroupsCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            group_count: u32::default(),
            p_groups: ::core::ptr::null(),
            pipeline_count: u32::default(),
            p_pipelines: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for GraphicsPipelineShaderGroupsCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV;
}
unsafe impl ExtendsGraphicsPipelineCreateInfo for GraphicsPipelineShaderGroupsCreateInfoNV<'_> {}
impl<'a> GraphicsPipelineShaderGroupsCreateInfoNV<'a> {
    #[inline]
    pub fn groups(mut self, groups: &'a [GraphicsShaderGroupCreateInfoNV<'a>]) -> Self {
        self.group_count = groups.len() as _;
        self.p_groups = groups.as_ptr();
        self
    }
    #[inline]
    pub fn pipelines(mut self, pipelines: &'a [Pipeline]) -> Self {
        self.pipeline_count = pipelines.len() as _;
        self.p_pipelines = pipelines.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBindShaderGroupIndirectCommandNV.html>"]
#[must_use]
pub struct BindShaderGroupIndirectCommandNV {
    pub group_index: u32,
}
impl BindShaderGroupIndirectCommandNV {
    #[inline]
    pub fn group_index(mut self, group_index: u32) -> Self {
        self.group_index = group_index;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBindIndexBufferIndirectCommandNV.html>"]
#[must_use]
pub struct BindIndexBufferIndirectCommandNV {
    pub buffer_address: DeviceAddress,
    pub size: u32,
    pub index_type: IndexType,
}
impl BindIndexBufferIndirectCommandNV {
    #[inline]
    pub fn buffer_address(mut self, buffer_address: DeviceAddress) -> Self {
        self.buffer_address = buffer_address;
        self
    }
    #[inline]
    pub fn size(mut self, size: u32) -> Self {
        self.size = size;
        self
    }
    #[inline]
    pub fn index_type(mut self, index_type: IndexType) -> Self {
        self.index_type = index_type;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBindVertexBufferIndirectCommandNV.html>"]
#[must_use]
pub struct BindVertexBufferIndirectCommandNV {
    pub buffer_address: DeviceAddress,
    pub size: u32,
    pub stride: u32,
}
impl BindVertexBufferIndirectCommandNV {
    #[inline]
    pub fn buffer_address(mut self, buffer_address: DeviceAddress) -> Self {
        self.buffer_address = buffer_address;
        self
    }
    #[inline]
    pub fn size(mut self, size: u32) -> Self {
        self.size = size;
        self
    }
    #[inline]
    pub fn stride(mut self, stride: u32) -> Self {
        self.stride = stride;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSetStateFlagsIndirectCommandNV.html>"]
#[must_use]
pub struct SetStateFlagsIndirectCommandNV {
    pub data: u32,
}
impl SetStateFlagsIndirectCommandNV {
    #[inline]
    pub fn data(mut self, data: u32) -> Self {
        self.data = data;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkIndirectCommandsStreamNV.html>"]
#[must_use]
pub struct IndirectCommandsStreamNV {
    pub buffer: Buffer,
    pub offset: DeviceSize,
}
impl IndirectCommandsStreamNV {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.buffer = buffer;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.offset = offset;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkIndirectCommandsLayoutTokenNV.html>"]
#[must_use]
pub struct IndirectCommandsLayoutTokenNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub token_type: IndirectCommandsTokenTypeNV,
    pub stream: u32,
    pub offset: u32,
    pub vertex_binding_unit: u32,
    pub vertex_dynamic_stride: Bool32,
    pub pushconstant_pipeline_layout: PipelineLayout,
    pub pushconstant_shader_stage_flags: ShaderStageFlags,
    pub pushconstant_offset: u32,
    pub pushconstant_size: u32,
    pub indirect_state_flags: IndirectStateFlagsNV,
    pub index_type_count: u32,
    pub p_index_types: *const IndexType,
    pub p_index_type_values: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for IndirectCommandsLayoutTokenNV<'_> {}
unsafe impl Sync for IndirectCommandsLayoutTokenNV<'_> {}
impl ::core::default::Default for IndirectCommandsLayoutTokenNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            token_type: IndirectCommandsTokenTypeNV::default(),
            stream: u32::default(),
            offset: u32::default(),
            vertex_binding_unit: u32::default(),
            vertex_dynamic_stride: Bool32::default(),
            pushconstant_pipeline_layout: PipelineLayout::default(),
            pushconstant_shader_stage_flags: ShaderStageFlags::default(),
            pushconstant_offset: u32::default(),
            pushconstant_size: u32::default(),
            indirect_state_flags: IndirectStateFlagsNV::default(),
            index_type_count: u32::default(),
            p_index_types: ::core::ptr::null(),
            p_index_type_values: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for IndirectCommandsLayoutTokenNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::INDIRECT_COMMANDS_LAYOUT_TOKEN_NV;
}
impl<'a> IndirectCommandsLayoutTokenNV<'a> {
    #[inline]
    pub fn token_type(mut self, token_type: IndirectCommandsTokenTypeNV) -> Self {
        self.token_type = token_type;
        self
    }
    #[inline]
    pub fn stream(mut self, stream: u32) -> Self {
        self.stream = stream;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: u32) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn vertex_binding_unit(mut self, vertex_binding_unit: u32) -> Self {
        self.vertex_binding_unit = vertex_binding_unit;
        self
    }
    #[inline]
    pub fn vertex_dynamic_stride(mut self, vertex_dynamic_stride: bool) -> Self {
        self.vertex_dynamic_stride = vertex_dynamic_stride.into();
        self
    }
    #[inline]
    pub fn pushconstant_pipeline_layout(
        mut self,
        pushconstant_pipeline_layout: PipelineLayout,
    ) -> Self {
        self.pushconstant_pipeline_layout = pushconstant_pipeline_layout;
        self
    }
    #[inline]
    pub fn pushconstant_shader_stage_flags(
        mut self,
        pushconstant_shader_stage_flags: ShaderStageFlags,
    ) -> Self {
        self.pushconstant_shader_stage_flags = pushconstant_shader_stage_flags;
        self
    }
    #[inline]
    pub fn pushconstant_offset(mut self, pushconstant_offset: u32) -> Self {
        self.pushconstant_offset = pushconstant_offset;
        self
    }
    #[inline]
    pub fn pushconstant_size(mut self, pushconstant_size: u32) -> Self {
        self.pushconstant_size = pushconstant_size;
        self
    }
    #[inline]
    pub fn indirect_state_flags(mut self, indirect_state_flags: IndirectStateFlagsNV) -> Self {
        self.indirect_state_flags = indirect_state_flags;
        self
    }
    #[inline]
    pub fn index_types(mut self, index_types: &'a [IndexType]) -> Self {
        self.index_type_count = index_types.len() as _;
        self.p_index_types = index_types.as_ptr();
        self
    }
    #[inline]
    pub fn index_type_values(mut self, index_type_values: &'a [u32]) -> Self {
        self.index_type_count = index_type_values.len() as _;
        self.p_index_type_values = index_type_values.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkIndirectCommandsLayoutCreateInfoNV.html>"]
#[must_use]
pub struct IndirectCommandsLayoutCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: IndirectCommandsLayoutUsageFlagsNV,
    pub pipeline_bind_point: PipelineBindPoint,
    pub token_count: u32,
    pub p_tokens: *const IndirectCommandsLayoutTokenNV<'a>,
    pub stream_count: u32,
    pub p_stream_strides: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for IndirectCommandsLayoutCreateInfoNV<'_> {}
unsafe impl Sync for IndirectCommandsLayoutCreateInfoNV<'_> {}
impl ::core::default::Default for IndirectCommandsLayoutCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: IndirectCommandsLayoutUsageFlagsNV::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            token_count: u32::default(),
            p_tokens: ::core::ptr::null(),
            stream_count: u32::default(),
            p_stream_strides: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for IndirectCommandsLayoutCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV;
}
impl<'a> IndirectCommandsLayoutCreateInfoNV<'a> {
    #[inline]
    pub fn flags(mut self, flags: IndirectCommandsLayoutUsageFlagsNV) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.pipeline_bind_point = pipeline_bind_point;
        self
    }
    #[inline]
    pub fn tokens(mut self, tokens: &'a [IndirectCommandsLayoutTokenNV<'a>]) -> Self {
        self.token_count = tokens.len() as _;
        self.p_tokens = tokens.as_ptr();
        self
    }
    #[inline]
    pub fn stream_strides(mut self, stream_strides: &'a [u32]) -> Self {
        self.stream_count = stream_strides.len() as _;
        self.p_stream_strides = stream_strides.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkGeneratedCommandsInfoNV.html>"]
#[must_use]
pub struct GeneratedCommandsInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub pipeline_bind_point: PipelineBindPoint,
    pub pipeline: Pipeline,
    pub indirect_commands_layout: IndirectCommandsLayoutNV,
    pub stream_count: u32,
    pub p_streams: *const IndirectCommandsStreamNV,
    pub sequences_count: u32,
    pub preprocess_buffer: Buffer,
    pub preprocess_offset: DeviceSize,
    pub preprocess_size: DeviceSize,
    pub sequences_count_buffer: Buffer,
    pub sequences_count_offset: DeviceSize,
    pub sequences_index_buffer: Buffer,
    pub sequences_index_offset: DeviceSize,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for GeneratedCommandsInfoNV<'_> {}
unsafe impl Sync for GeneratedCommandsInfoNV<'_> {}
impl ::core::default::Default for GeneratedCommandsInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            pipeline_bind_point: PipelineBindPoint::default(),
            pipeline: Pipeline::default(),
            indirect_commands_layout: IndirectCommandsLayoutNV::default(),
            stream_count: u32::default(),
            p_streams: ::core::ptr::null(),
            sequences_count: u32::default(),
            preprocess_buffer: Buffer::default(),
            preprocess_offset: DeviceSize::default(),
            preprocess_size: DeviceSize::default(),
            sequences_count_buffer: Buffer::default(),
            sequences_count_offset: DeviceSize::default(),
            sequences_index_buffer: Buffer::default(),
            sequences_index_offset: DeviceSize::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for GeneratedCommandsInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::GENERATED_COMMANDS_INFO_NV;
}
impl<'a> GeneratedCommandsInfoNV<'a> {
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.pipeline_bind_point = pipeline_bind_point;
        self
    }
    #[inline]
    pub fn pipeline(mut self, pipeline: Pipeline) -> Self {
        self.pipeline = pipeline;
        self
    }
    #[inline]
    pub fn indirect_commands_layout(
        mut self,
        indirect_commands_layout: IndirectCommandsLayoutNV,
    ) -> Self {
        self.indirect_commands_layout = indirect_commands_layout;
        self
    }
    #[inline]
    pub fn streams(mut self, streams: &'a [IndirectCommandsStreamNV]) -> Self {
        self.stream_count = streams.len() as _;
        self.p_streams = streams.as_ptr();
        self
    }
    #[inline]
    pub fn sequences_count(mut self, sequences_count: u32) -> Self {
        self.sequences_count = sequences_count;
        self
    }
    #[inline]
    pub fn preprocess_buffer(mut self, preprocess_buffer: Buffer) -> Self {
        self.preprocess_buffer = preprocess_buffer;
        self
    }
    #[inline]
    pub fn preprocess_offset(mut self, preprocess_offset: DeviceSize) -> Self {
        self.preprocess_offset = preprocess_offset;
        self
    }
    #[inline]
    pub fn preprocess_size(mut self, preprocess_size: DeviceSize) -> Self {
        self.preprocess_size = preprocess_size;
        self
    }
    #[inline]
    pub fn sequences_count_buffer(mut self, sequences_count_buffer: Buffer) -> Self {
        self.sequences_count_buffer = sequences_count_buffer;
        self
    }
    #[inline]
    pub fn sequences_count_offset(mut self, sequences_count_offset: DeviceSize) -> Self {
        self.sequences_count_offset = sequences_count_offset;
        self
    }
    #[inline]
    pub fn sequences_index_buffer(mut self, sequences_index_buffer: Buffer) -> Self {
        self.sequences_index_buffer = sequences_index_buffer;
        self
    }
    #[inline]
    pub fn sequences_index_offset(mut self, sequences_index_offset: DeviceSize) -> Self {
        self.sequences_index_offset = sequences_index_offset;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkGeneratedCommandsMemoryRequirementsInfoNV.html>"]
#[must_use]
pub struct GeneratedCommandsMemoryRequirementsInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub pipeline_bind_point: PipelineBindPoint,
    pub pipeline: Pipeline,
    pub indirect_commands_layout: IndirectCommandsLayoutNV,
    pub max_sequences_count: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for GeneratedCommandsMemoryRequirementsInfoNV<'_> {}
unsafe impl Sync for GeneratedCommandsMemoryRequirementsInfoNV<'_> {}
impl ::core::default::Default for GeneratedCommandsMemoryRequirementsInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            pipeline_bind_point: PipelineBindPoint::default(),
            pipeline: Pipeline::default(),
            indirect_commands_layout: IndirectCommandsLayoutNV::default(),
            max_sequences_count: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for GeneratedCommandsMemoryRequirementsInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV;
}
impl<'a> GeneratedCommandsMemoryRequirementsInfoNV<'a> {
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.pipeline_bind_point = pipeline_bind_point;
        self
    }
    #[inline]
    pub fn pipeline(mut self, pipeline: Pipeline) -> Self {
        self.pipeline = pipeline;
        self
    }
    #[inline]
    pub fn indirect_commands_layout(
        mut self,
        indirect_commands_layout: IndirectCommandsLayoutNV,
    ) -> Self {
        self.indirect_commands_layout = indirect_commands_layout;
        self
    }
    #[inline]
    pub fn max_sequences_count(mut self, max_sequences_count: u32) -> Self {
        self.max_sequences_count = max_sequences_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineIndirectDeviceAddressInfoNV.html>"]
#[must_use]
pub struct PipelineIndirectDeviceAddressInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub pipeline_bind_point: PipelineBindPoint,
    pub pipeline: Pipeline,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineIndirectDeviceAddressInfoNV<'_> {}
unsafe impl Sync for PipelineIndirectDeviceAddressInfoNV<'_> {}
impl ::core::default::Default for PipelineIndirectDeviceAddressInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            pipeline_bind_point: PipelineBindPoint::default(),
            pipeline: Pipeline::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineIndirectDeviceAddressInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_INDIRECT_DEVICE_ADDRESS_INFO_NV;
}
impl<'a> PipelineIndirectDeviceAddressInfoNV<'a> {
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.pipeline_bind_point = pipeline_bind_point;
        self
    }
    #[inline]
    pub fn pipeline(mut self, pipeline: Pipeline) -> Self {
        self.pipeline = pipeline;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBindPipelineIndirectCommandNV.html>"]
#[must_use]
pub struct BindPipelineIndirectCommandNV {
    pub pipeline_address: DeviceAddress,
}
impl BindPipelineIndirectCommandNV {
    #[inline]
    pub fn pipeline_address(mut self, pipeline_address: DeviceAddress) -> Self {
        self.pipeline_address = pipeline_address;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceFeatures2.html>"]
#[must_use]
pub struct PhysicalDeviceFeatures2<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub features: PhysicalDeviceFeatures,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceFeatures2<'_> {}
unsafe impl Sync for PhysicalDeviceFeatures2<'_> {}
impl ::core::default::Default for PhysicalDeviceFeatures2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            features: PhysicalDeviceFeatures::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceFeatures2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_FEATURES_2;
}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFeatures2<'_> {}
pub unsafe trait ExtendsPhysicalDeviceFeatures2 {}
impl<'a> PhysicalDeviceFeatures2<'a> {
    #[inline]
    pub fn features(mut self, features: PhysicalDeviceFeatures) -> Self {
        self.features = features;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceFeatures2 + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceProperties2.html>"]
#[must_use]
pub struct PhysicalDeviceProperties2<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub properties: PhysicalDeviceProperties,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceProperties2<'_> {}
unsafe impl Sync for PhysicalDeviceProperties2<'_> {}
impl ::core::default::Default for PhysicalDeviceProperties2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            properties: PhysicalDeviceProperties::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceProperties2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_PROPERTIES_2;
}
pub unsafe trait ExtendsPhysicalDeviceProperties2 {}
impl<'a> PhysicalDeviceProperties2<'a> {
    #[inline]
    pub fn properties(mut self, properties: PhysicalDeviceProperties) -> Self {
        self.properties = properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceProperties2 + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkFormatProperties2.html>"]
#[must_use]
pub struct FormatProperties2<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub format_properties: FormatProperties,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for FormatProperties2<'_> {}
unsafe impl Sync for FormatProperties2<'_> {}
impl ::core::default::Default for FormatProperties2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            format_properties: FormatProperties::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for FormatProperties2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::FORMAT_PROPERTIES_2;
}
pub unsafe trait ExtendsFormatProperties2 {}
impl<'a> FormatProperties2<'a> {
    #[inline]
    pub fn format_properties(mut self, format_properties: FormatProperties) -> Self {
        self.format_properties = format_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsFormatProperties2 + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageFormatProperties2.html>"]
#[must_use]
pub struct ImageFormatProperties2<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub image_format_properties: ImageFormatProperties,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageFormatProperties2<'_> {}
unsafe impl Sync for ImageFormatProperties2<'_> {}
impl ::core::default::Default for ImageFormatProperties2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            image_format_properties: ImageFormatProperties::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageFormatProperties2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_FORMAT_PROPERTIES_2;
}
pub unsafe trait ExtendsImageFormatProperties2 {}
impl<'a> ImageFormatProperties2<'a> {
    #[inline]
    pub fn image_format_properties(
        mut self,
        image_format_properties: ImageFormatProperties,
    ) -> Self {
        self.image_format_properties = image_format_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageFormatProperties2 + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceImageFormatInfo2.html>"]
#[must_use]
pub struct PhysicalDeviceImageFormatInfo2<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub format: Format,
    pub ty: ImageType,
    pub tiling: ImageTiling,
    pub usage: ImageUsageFlags,
    pub flags: ImageCreateFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceImageFormatInfo2<'_> {}
unsafe impl Sync for PhysicalDeviceImageFormatInfo2<'_> {}
impl ::core::default::Default for PhysicalDeviceImageFormatInfo2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            format: Format::default(),
            ty: ImageType::default(),
            tiling: ImageTiling::default(),
            usage: ImageUsageFlags::default(),
            flags: ImageCreateFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceImageFormatInfo2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2;
}
pub unsafe trait ExtendsPhysicalDeviceImageFormatInfo2 {}
impl<'a> PhysicalDeviceImageFormatInfo2<'a> {
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.format = format;
        self
    }
    #[inline]
    pub fn ty(mut self, ty: ImageType) -> Self {
        self.ty = ty;
        self
    }
    #[inline]
    pub fn tiling(mut self, tiling: ImageTiling) -> Self {
        self.tiling = tiling;
        self
    }
    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.usage = usage;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: ImageCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceImageFormatInfo2 + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkQueueFamilyProperties2.html>"]
#[must_use]
pub struct QueueFamilyProperties2<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub queue_family_properties: QueueFamilyProperties,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for QueueFamilyProperties2<'_> {}
unsafe impl Sync for QueueFamilyProperties2<'_> {}
impl ::core::default::Default for QueueFamilyProperties2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            queue_family_properties: QueueFamilyProperties::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for QueueFamilyProperties2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::QUEUE_FAMILY_PROPERTIES_2;
}
pub unsafe trait ExtendsQueueFamilyProperties2 {}
impl<'a> QueueFamilyProperties2<'a> {
    #[inline]
    pub fn queue_family_properties(
        mut self,
        queue_family_properties: QueueFamilyProperties,
    ) -> Self {
        self.queue_family_properties = queue_family_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsQueueFamilyProperties2 + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMemoryProperties2.html>"]
#[must_use]
pub struct PhysicalDeviceMemoryProperties2<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_properties: PhysicalDeviceMemoryProperties,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMemoryProperties2<'_> {}
unsafe impl Sync for PhysicalDeviceMemoryProperties2<'_> {}
impl ::core::default::Default for PhysicalDeviceMemoryProperties2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            memory_properties: PhysicalDeviceMemoryProperties::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMemoryProperties2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MEMORY_PROPERTIES_2;
}
pub unsafe trait ExtendsPhysicalDeviceMemoryProperties2 {}
impl<'a> PhysicalDeviceMemoryProperties2<'a> {
    #[inline]
    pub fn memory_properties(mut self, memory_properties: PhysicalDeviceMemoryProperties) -> Self {
        self.memory_properties = memory_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceMemoryProperties2 + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSparseImageFormatProperties2.html>"]
#[must_use]
pub struct SparseImageFormatProperties2<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub properties: SparseImageFormatProperties,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SparseImageFormatProperties2<'_> {}
unsafe impl Sync for SparseImageFormatProperties2<'_> {}
impl ::core::default::Default for SparseImageFormatProperties2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            properties: SparseImageFormatProperties::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SparseImageFormatProperties2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SPARSE_IMAGE_FORMAT_PROPERTIES_2;
}
impl<'a> SparseImageFormatProperties2<'a> {
    #[inline]
    pub fn properties(mut self, properties: SparseImageFormatProperties) -> Self {
        self.properties = properties;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSparseImageFormatInfo2.html>"]
#[must_use]
pub struct PhysicalDeviceSparseImageFormatInfo2<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub format: Format,
    pub ty: ImageType,
    pub samples: SampleCountFlags,
    pub usage: ImageUsageFlags,
    pub tiling: ImageTiling,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceSparseImageFormatInfo2<'_> {}
unsafe impl Sync for PhysicalDeviceSparseImageFormatInfo2<'_> {}
impl ::core::default::Default for PhysicalDeviceSparseImageFormatInfo2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            format: Format::default(),
            ty: ImageType::default(),
            samples: SampleCountFlags::default(),
            usage: ImageUsageFlags::default(),
            tiling: ImageTiling::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceSparseImageFormatInfo2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2;
}
impl<'a> PhysicalDeviceSparseImageFormatInfo2<'a> {
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.format = format;
        self
    }
    #[inline]
    pub fn ty(mut self, ty: ImageType) -> Self {
        self.ty = ty;
        self
    }
    #[inline]
    pub fn samples(mut self, samples: SampleCountFlags) -> Self {
        self.samples = samples;
        self
    }
    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.usage = usage;
        self
    }
    #[inline]
    pub fn tiling(mut self, tiling: ImageTiling) -> Self {
        self.tiling = tiling;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevicePushDescriptorPropertiesKHR.html>"]
#[must_use]
pub struct PhysicalDevicePushDescriptorPropertiesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_push_descriptors: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDevicePushDescriptorPropertiesKHR<'_> {}
unsafe impl Sync for PhysicalDevicePushDescriptorPropertiesKHR<'_> {}
impl ::core::default::Default for PhysicalDevicePushDescriptorPropertiesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_push_descriptors: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDevicePushDescriptorPropertiesKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDevicePushDescriptorPropertiesKHR<'_> {}
impl<'a> PhysicalDevicePushDescriptorPropertiesKHR<'a> {
    #[inline]
    pub fn max_push_descriptors(mut self, max_push_descriptors: u32) -> Self {
        self.max_push_descriptors = max_push_descriptors;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkConformanceVersion.html>"]
#[must_use]
pub struct ConformanceVersion {
    pub major: u8,
    pub minor: u8,
    pub subminor: u8,
    pub patch: u8,
}
impl ConformanceVersion {
    #[inline]
    pub fn major(mut self, major: u8) -> Self {
        self.major = major;
        self
    }
    #[inline]
    pub fn minor(mut self, minor: u8) -> Self {
        self.minor = minor;
        self
    }
    #[inline]
    pub fn subminor(mut self, subminor: u8) -> Self {
        self.subminor = subminor;
        self
    }
    #[inline]
    pub fn patch(mut self, patch: u8) -> Self {
        self.patch = patch;
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDriverProperties.html>"]
#[must_use]
pub struct PhysicalDeviceDriverProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub driver_id: DriverId,
    pub driver_name: [c_char; MAX_DRIVER_NAME_SIZE],
    pub driver_info: [c_char; MAX_DRIVER_INFO_SIZE],
    pub conformance_version: ConformanceVersion,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceDriverProperties<'_> {}
unsafe impl Sync for PhysicalDeviceDriverProperties<'_> {}
#[cfg(feature = "debug")]
impl fmt::Debug for PhysicalDeviceDriverProperties<'_> {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("PhysicalDeviceDriverProperties")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("driver_id", &self.driver_id)
            .field("driver_name", &self.driver_name_as_c_str())
            .field("driver_info", &self.driver_info_as_c_str())
            .field("conformance_version", &self.conformance_version)
            .finish()
    }
}
impl ::core::default::Default for PhysicalDeviceDriverProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            driver_id: DriverId::default(),
            driver_name: unsafe { ::core::mem::zeroed() },
            driver_info: unsafe { ::core::mem::zeroed() },
            conformance_version: ConformanceVersion::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceDriverProperties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_DRIVER_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDriverProperties<'_> {}
impl<'a> PhysicalDeviceDriverProperties<'a> {
    #[inline]
    pub fn driver_id(mut self, driver_id: DriverId) -> Self {
        self.driver_id = driver_id;
        self
    }
    #[inline]
    pub fn driver_name(
        mut self,
        driver_name: &CStr,
    ) -> core::result::Result<Self, CStrTooLargeForStaticArray> {
        write_c_str_slice_with_nul(&mut self.driver_name, driver_name).map(|()| self)
    }
    #[inline]
    pub fn driver_name_as_c_str(&self) -> core::result::Result<&CStr, FromBytesUntilNulError> {
        wrap_c_str_slice_until_nul(&self.driver_name)
    }
    #[inline]
    pub fn driver_info(
        mut self,
        driver_info: &CStr,
    ) -> core::result::Result<Self, CStrTooLargeForStaticArray> {
        write_c_str_slice_with_nul(&mut self.driver_info, driver_info).map(|()| self)
    }
    #[inline]
    pub fn driver_info_as_c_str(&self) -> core::result::Result<&CStr, FromBytesUntilNulError> {
        wrap_c_str_slice_until_nul(&self.driver_info)
    }
    #[inline]
    pub fn conformance_version(mut self, conformance_version: ConformanceVersion) -> Self {
        self.conformance_version = conformance_version;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPresentRegionsKHR.html>"]
#[must_use]
pub struct PresentRegionsKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain_count: u32,
    pub p_regions: *const PresentRegionKHR<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PresentRegionsKHR<'_> {}
unsafe impl Sync for PresentRegionsKHR<'_> {}
impl ::core::default::Default for PresentRegionsKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            swapchain_count: u32::default(),
            p_regions: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PresentRegionsKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PRESENT_REGIONS_KHR;
}
unsafe impl ExtendsPresentInfoKHR for PresentRegionsKHR<'_> {}
impl<'a> PresentRegionsKHR<'a> {
    #[inline]
    pub fn regions(mut self, regions: &'a [PresentRegionKHR<'a>]) -> Self {
        self.swapchain_count = regions.len() as _;
        self.p_regions = regions.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPresentRegionKHR.html>"]
#[must_use]
pub struct PresentRegionKHR<'a> {
    pub rectangle_count: u32,
    pub p_rectangles: *const RectLayerKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PresentRegionKHR<'_> {}
unsafe impl Sync for PresentRegionKHR<'_> {}
impl ::core::default::Default for PresentRegionKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            rectangle_count: u32::default(),
            p_rectangles: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
impl<'a> PresentRegionKHR<'a> {
    #[inline]
    pub fn rectangles(mut self, rectangles: &'a [RectLayerKHR]) -> Self {
        self.rectangle_count = rectangles.len() as _;
        self.p_rectangles = rectangles.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRectLayerKHR.html>"]
#[must_use]
pub struct RectLayerKHR {
    pub offset: Offset2D,
    pub extent: Extent2D,
    pub layer: u32,
}
impl RectLayerKHR {
    #[inline]
    pub fn offset(mut self, offset: Offset2D) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn extent(mut self, extent: Extent2D) -> Self {
        self.extent = extent;
        self
    }
    #[inline]
    pub fn layer(mut self, layer: u32) -> Self {
        self.layer = layer;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceVariablePointersFeatures.html>"]
#[must_use]
pub struct PhysicalDeviceVariablePointersFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub variable_pointers_storage_buffer: Bool32,
    pub variable_pointers: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceVariablePointersFeatures<'_> {}
unsafe impl Sync for PhysicalDeviceVariablePointersFeatures<'_> {}
impl ::core::default::Default for PhysicalDeviceVariablePointersFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            variable_pointers_storage_buffer: Bool32::default(),
            variable_pointers: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceVariablePointersFeatures<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceVariablePointersFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVariablePointersFeatures<'_> {}
impl<'a> PhysicalDeviceVariablePointersFeatures<'a> {
    #[inline]
    pub fn variable_pointers_storage_buffer(
        mut self,
        variable_pointers_storage_buffer: bool,
    ) -> Self {
        self.variable_pointers_storage_buffer = variable_pointers_storage_buffer.into();
        self
    }
    #[inline]
    pub fn variable_pointers(mut self, variable_pointers: bool) -> Self {
        self.variable_pointers = variable_pointers.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExternalMemoryProperties.html>"]
#[must_use]
pub struct ExternalMemoryProperties {
    pub external_memory_features: ExternalMemoryFeatureFlags,
    pub export_from_imported_handle_types: ExternalMemoryHandleTypeFlags,
    pub compatible_handle_types: ExternalMemoryHandleTypeFlags,
}
impl ExternalMemoryProperties {
    #[inline]
    pub fn external_memory_features(
        mut self,
        external_memory_features: ExternalMemoryFeatureFlags,
    ) -> Self {
        self.external_memory_features = external_memory_features;
        self
    }
    #[inline]
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalMemoryHandleTypeFlags,
    ) -> Self {
        self.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }
    #[inline]
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalMemoryHandleTypeFlags,
    ) -> Self {
        self.compatible_handle_types = compatible_handle_types;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceExternalImageFormatInfo.html>"]
#[must_use]
pub struct PhysicalDeviceExternalImageFormatInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceExternalImageFormatInfo<'_> {}
unsafe impl Sync for PhysicalDeviceExternalImageFormatInfo<'_> {}
impl ::core::default::Default for PhysicalDeviceExternalImageFormatInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceExternalImageFormatInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO;
}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2 for PhysicalDeviceExternalImageFormatInfo<'_> {}
impl<'a> PhysicalDeviceExternalImageFormatInfo<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExternalImageFormatProperties.html>"]
#[must_use]
pub struct ExternalImageFormatProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub external_memory_properties: ExternalMemoryProperties,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExternalImageFormatProperties<'_> {}
unsafe impl Sync for ExternalImageFormatProperties<'_> {}
impl ::core::default::Default for ExternalImageFormatProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            external_memory_properties: ExternalMemoryProperties::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExternalImageFormatProperties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_IMAGE_FORMAT_PROPERTIES;
}
unsafe impl ExtendsImageFormatProperties2 for ExternalImageFormatProperties<'_> {}
impl<'a> ExternalImageFormatProperties<'a> {
    #[inline]
    pub fn external_memory_properties(
        mut self,
        external_memory_properties: ExternalMemoryProperties,
    ) -> Self {
        self.external_memory_properties = external_memory_properties;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceExternalBufferInfo.html>"]
#[must_use]
pub struct PhysicalDeviceExternalBufferInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: BufferCreateFlags,
    pub usage: BufferUsageFlags,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceExternalBufferInfo<'_> {}
unsafe impl Sync for PhysicalDeviceExternalBufferInfo<'_> {}
impl ::core::default::Default for PhysicalDeviceExternalBufferInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: BufferCreateFlags::default(),
            usage: BufferUsageFlags::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceExternalBufferInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO;
}
pub unsafe trait ExtendsPhysicalDeviceExternalBufferInfo {}
impl<'a> PhysicalDeviceExternalBufferInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: BufferCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn usage(mut self, usage: BufferUsageFlags) -> Self {
        self.usage = usage;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceExternalBufferInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExternalBufferProperties.html>"]
#[must_use]
pub struct ExternalBufferProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub external_memory_properties: ExternalMemoryProperties,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExternalBufferProperties<'_> {}
unsafe impl Sync for ExternalBufferProperties<'_> {}
impl ::core::default::Default for ExternalBufferProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            external_memory_properties: ExternalMemoryProperties::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExternalBufferProperties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_BUFFER_PROPERTIES;
}
impl<'a> ExternalBufferProperties<'a> {
    #[inline]
    pub fn external_memory_properties(
        mut self,
        external_memory_properties: ExternalMemoryProperties,
    ) -> Self {
        self.external_memory_properties = external_memory_properties;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceIDProperties.html>"]
#[must_use]
pub struct PhysicalDeviceIDProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub device_uuid: [u8; UUID_SIZE],
    pub driver_uuid: [u8; UUID_SIZE],
    pub device_luid: [u8; LUID_SIZE],
    pub device_node_mask: u32,
    pub device_luid_valid: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceIDProperties<'_> {}
unsafe impl Sync for PhysicalDeviceIDProperties<'_> {}
impl ::core::default::Default for PhysicalDeviceIDProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            device_uuid: unsafe { ::core::mem::zeroed() },
            driver_uuid: unsafe { ::core::mem::zeroed() },
            device_luid: unsafe { ::core::mem::zeroed() },
            device_node_mask: u32::default(),
            device_luid_valid: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceIDProperties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_ID_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceIDProperties<'_> {}
impl<'a> PhysicalDeviceIDProperties<'a> {
    #[inline]
    pub fn device_uuid(mut self, device_uuid: [u8; UUID_SIZE]) -> Self {
        self.device_uuid = device_uuid;
        self
    }
    #[inline]
    pub fn driver_uuid(mut self, driver_uuid: [u8; UUID_SIZE]) -> Self {
        self.driver_uuid = driver_uuid;
        self
    }
    #[inline]
    pub fn device_luid(mut self, device_luid: [u8; LUID_SIZE]) -> Self {
        self.device_luid = device_luid;
        self
    }
    #[inline]
    pub fn device_node_mask(mut self, device_node_mask: u32) -> Self {
        self.device_node_mask = device_node_mask;
        self
    }
    #[inline]
    pub fn device_luid_valid(mut self, device_luid_valid: bool) -> Self {
        self.device_luid_valid = device_luid_valid.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExternalMemoryImageCreateInfo.html>"]
#[must_use]
pub struct ExternalMemoryImageCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExternalMemoryImageCreateInfo<'_> {}
unsafe impl Sync for ExternalMemoryImageCreateInfo<'_> {}
impl ::core::default::Default for ExternalMemoryImageCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExternalMemoryImageCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_MEMORY_IMAGE_CREATE_INFO;
}
unsafe impl ExtendsImageCreateInfo for ExternalMemoryImageCreateInfo<'_> {}
impl<'a> ExternalMemoryImageCreateInfo<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlags) -> Self {
        self.handle_types = handle_types;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExternalMemoryBufferCreateInfo.html>"]
#[must_use]
pub struct ExternalMemoryBufferCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExternalMemoryBufferCreateInfo<'_> {}
unsafe impl Sync for ExternalMemoryBufferCreateInfo<'_> {}
impl ::core::default::Default for ExternalMemoryBufferCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExternalMemoryBufferCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_MEMORY_BUFFER_CREATE_INFO;
}
unsafe impl ExtendsBufferCreateInfo for ExternalMemoryBufferCreateInfo<'_> {}
impl<'a> ExternalMemoryBufferCreateInfo<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlags) -> Self {
        self.handle_types = handle_types;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExportMemoryAllocateInfo.html>"]
#[must_use]
pub struct ExportMemoryAllocateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExportMemoryAllocateInfo<'_> {}
unsafe impl Sync for ExportMemoryAllocateInfo<'_> {}
impl ::core::default::Default for ExportMemoryAllocateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExportMemoryAllocateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_MEMORY_ALLOCATE_INFO;
}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryAllocateInfo<'_> {}
impl<'a> ExportMemoryAllocateInfo<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlags) -> Self {
        self.handle_types = handle_types;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImportMemoryWin32HandleInfoKHR.html>"]
#[must_use]
pub struct ImportMemoryWin32HandleInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub handle: HANDLE,
    pub name: LPCWSTR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImportMemoryWin32HandleInfoKHR<'_> {}
unsafe impl Sync for ImportMemoryWin32HandleInfoKHR<'_> {}
impl ::core::default::Default for ImportMemoryWin32HandleInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            handle: unsafe { ::core::mem::zeroed() },
            name: unsafe { ::core::mem::zeroed() },
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImportMemoryWin32HandleInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR;
}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryWin32HandleInfoKHR<'_> {}
impl<'a> ImportMemoryWin32HandleInfoKHR<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn handle(mut self, handle: HANDLE) -> Self {
        self.handle = handle;
        self
    }
    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.name = name;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExportMemoryWin32HandleInfoKHR.html>"]
#[must_use]
pub struct ExportMemoryWin32HandleInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
    pub name: LPCWSTR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExportMemoryWin32HandleInfoKHR<'_> {}
unsafe impl Sync for ExportMemoryWin32HandleInfoKHR<'_> {}
impl ::core::default::Default for ExportMemoryWin32HandleInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            p_attributes: ::core::ptr::null(),
            dw_access: DWORD::default(),
            name: unsafe { ::core::mem::zeroed() },
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExportMemoryWin32HandleInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR;
}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryWin32HandleInfoKHR<'_> {}
impl<'a> ExportMemoryWin32HandleInfoKHR<'a> {
    #[inline]
    pub fn attributes(mut self, attributes: &'a SECURITY_ATTRIBUTES) -> Self {
        self.p_attributes = attributes;
        self
    }
    #[inline]
    pub fn dw_access(mut self, dw_access: DWORD) -> Self {
        self.dw_access = dw_access;
        self
    }
    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.name = name;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImportMemoryZirconHandleInfoFUCHSIA.html>"]
#[must_use]
pub struct ImportMemoryZirconHandleInfoFUCHSIA<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub handle: zx_handle_t,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImportMemoryZirconHandleInfoFUCHSIA<'_> {}
unsafe impl Sync for ImportMemoryZirconHandleInfoFUCHSIA<'_> {}
impl ::core::default::Default for ImportMemoryZirconHandleInfoFUCHSIA<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            handle: zx_handle_t::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImportMemoryZirconHandleInfoFUCHSIA<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA;
}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryZirconHandleInfoFUCHSIA<'_> {}
impl<'a> ImportMemoryZirconHandleInfoFUCHSIA<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn handle(mut self, handle: zx_handle_t) -> Self {
        self.handle = handle;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryZirconHandlePropertiesFUCHSIA.html>"]
#[must_use]
pub struct MemoryZirconHandlePropertiesFUCHSIA<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_type_bits: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryZirconHandlePropertiesFUCHSIA<'_> {}
unsafe impl Sync for MemoryZirconHandlePropertiesFUCHSIA<'_> {}
impl ::core::default::Default for MemoryZirconHandlePropertiesFUCHSIA<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            memory_type_bits: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryZirconHandlePropertiesFUCHSIA<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA;
}
impl<'a> MemoryZirconHandlePropertiesFUCHSIA<'a> {
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.memory_type_bits = memory_type_bits;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryGetZirconHandleInfoFUCHSIA.html>"]
#[must_use]
pub struct MemoryGetZirconHandleInfoFUCHSIA<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub memory: DeviceMemory,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryGetZirconHandleInfoFUCHSIA<'_> {}
unsafe impl Sync for MemoryGetZirconHandleInfoFUCHSIA<'_> {}
impl ::core::default::Default for MemoryGetZirconHandleInfoFUCHSIA<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            memory: DeviceMemory::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryGetZirconHandleInfoFUCHSIA<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA;
}
impl<'a> MemoryGetZirconHandleInfoFUCHSIA<'a> {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.memory = memory;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryWin32HandlePropertiesKHR.html>"]
#[must_use]
pub struct MemoryWin32HandlePropertiesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_type_bits: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryWin32HandlePropertiesKHR<'_> {}
unsafe impl Sync for MemoryWin32HandlePropertiesKHR<'_> {}
impl ::core::default::Default for MemoryWin32HandlePropertiesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            memory_type_bits: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryWin32HandlePropertiesKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_WIN32_HANDLE_PROPERTIES_KHR;
}
impl<'a> MemoryWin32HandlePropertiesKHR<'a> {
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.memory_type_bits = memory_type_bits;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryGetWin32HandleInfoKHR.html>"]
#[must_use]
pub struct MemoryGetWin32HandleInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub memory: DeviceMemory,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryGetWin32HandleInfoKHR<'_> {}
unsafe impl Sync for MemoryGetWin32HandleInfoKHR<'_> {}
impl ::core::default::Default for MemoryGetWin32HandleInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            memory: DeviceMemory::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryGetWin32HandleInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_GET_WIN32_HANDLE_INFO_KHR;
}
impl<'a> MemoryGetWin32HandleInfoKHR<'a> {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.memory = memory;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImportMemoryFdInfoKHR.html>"]
#[must_use]
pub struct ImportMemoryFdInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub fd: c_int,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImportMemoryFdInfoKHR<'_> {}
unsafe impl Sync for ImportMemoryFdInfoKHR<'_> {}
impl ::core::default::Default for ImportMemoryFdInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            fd: c_int::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImportMemoryFdInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_MEMORY_FD_INFO_KHR;
}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryFdInfoKHR<'_> {}
impl<'a> ImportMemoryFdInfoKHR<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn fd(mut self, fd: c_int) -> Self {
        self.fd = fd;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryFdPropertiesKHR.html>"]
#[must_use]
pub struct MemoryFdPropertiesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_type_bits: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryFdPropertiesKHR<'_> {}
unsafe impl Sync for MemoryFdPropertiesKHR<'_> {}
impl ::core::default::Default for MemoryFdPropertiesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            memory_type_bits: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryFdPropertiesKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_FD_PROPERTIES_KHR;
}
impl<'a> MemoryFdPropertiesKHR<'a> {
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.memory_type_bits = memory_type_bits;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryGetFdInfoKHR.html>"]
#[must_use]
pub struct MemoryGetFdInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub memory: DeviceMemory,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryGetFdInfoKHR<'_> {}
unsafe impl Sync for MemoryGetFdInfoKHR<'_> {}
impl ::core::default::Default for MemoryGetFdInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            memory: DeviceMemory::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryGetFdInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_GET_FD_INFO_KHR;
}
impl<'a> MemoryGetFdInfoKHR<'a> {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.memory = memory;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkWin32KeyedMutexAcquireReleaseInfoKHR.html>"]
#[must_use]
pub struct Win32KeyedMutexAcquireReleaseInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub acquire_count: u32,
    pub p_acquire_syncs: *const DeviceMemory,
    pub p_acquire_keys: *const u64,
    pub p_acquire_timeouts: *const u32,
    pub release_count: u32,
    pub p_release_syncs: *const DeviceMemory,
    pub p_release_keys: *const u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for Win32KeyedMutexAcquireReleaseInfoKHR<'_> {}
unsafe impl Sync for Win32KeyedMutexAcquireReleaseInfoKHR<'_> {}
impl ::core::default::Default for Win32KeyedMutexAcquireReleaseInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            acquire_count: u32::default(),
            p_acquire_syncs: ::core::ptr::null(),
            p_acquire_keys: ::core::ptr::null(),
            p_acquire_timeouts: ::core::ptr::null(),
            release_count: u32::default(),
            p_release_syncs: ::core::ptr::null(),
            p_release_keys: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for Win32KeyedMutexAcquireReleaseInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR;
}
unsafe impl ExtendsSubmitInfo for Win32KeyedMutexAcquireReleaseInfoKHR<'_> {}
unsafe impl ExtendsSubmitInfo2 for Win32KeyedMutexAcquireReleaseInfoKHR<'_> {}
impl<'a> Win32KeyedMutexAcquireReleaseInfoKHR<'a> {
    #[inline]
    pub fn acquire_syncs(mut self, acquire_syncs: &'a [DeviceMemory]) -> Self {
        self.acquire_count = acquire_syncs.len() as _;
        self.p_acquire_syncs = acquire_syncs.as_ptr();
        self
    }
    #[inline]
    pub fn acquire_keys(mut self, acquire_keys: &'a [u64]) -> Self {
        self.acquire_count = acquire_keys.len() as _;
        self.p_acquire_keys = acquire_keys.as_ptr();
        self
    }
    #[inline]
    pub fn acquire_timeouts(mut self, acquire_timeouts: &'a [u32]) -> Self {
        self.acquire_count = acquire_timeouts.len() as _;
        self.p_acquire_timeouts = acquire_timeouts.as_ptr();
        self
    }
    #[inline]
    pub fn release_syncs(mut self, release_syncs: &'a [DeviceMemory]) -> Self {
        self.release_count = release_syncs.len() as _;
        self.p_release_syncs = release_syncs.as_ptr();
        self
    }
    #[inline]
    pub fn release_keys(mut self, release_keys: &'a [u64]) -> Self {
        self.release_count = release_keys.len() as _;
        self.p_release_keys = release_keys.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceExternalSemaphoreInfo.html>"]
#[must_use]
pub struct PhysicalDeviceExternalSemaphoreInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceExternalSemaphoreInfo<'_> {}
unsafe impl Sync for PhysicalDeviceExternalSemaphoreInfo<'_> {}
impl ::core::default::Default for PhysicalDeviceExternalSemaphoreInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceExternalSemaphoreInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO;
}
pub unsafe trait ExtendsPhysicalDeviceExternalSemaphoreInfo {}
impl<'a> PhysicalDeviceExternalSemaphoreInfo<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceExternalSemaphoreInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExternalSemaphoreProperties.html>"]
#[must_use]
pub struct ExternalSemaphoreProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub export_from_imported_handle_types: ExternalSemaphoreHandleTypeFlags,
    pub compatible_handle_types: ExternalSemaphoreHandleTypeFlags,
    pub external_semaphore_features: ExternalSemaphoreFeatureFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExternalSemaphoreProperties<'_> {}
unsafe impl Sync for ExternalSemaphoreProperties<'_> {}
impl ::core::default::Default for ExternalSemaphoreProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            export_from_imported_handle_types: ExternalSemaphoreHandleTypeFlags::default(),
            compatible_handle_types: ExternalSemaphoreHandleTypeFlags::default(),
            external_semaphore_features: ExternalSemaphoreFeatureFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExternalSemaphoreProperties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_SEMAPHORE_PROPERTIES;
}
impl<'a> ExternalSemaphoreProperties<'a> {
    #[inline]
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalSemaphoreHandleTypeFlags,
    ) -> Self {
        self.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }
    #[inline]
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalSemaphoreHandleTypeFlags,
    ) -> Self {
        self.compatible_handle_types = compatible_handle_types;
        self
    }
    #[inline]
    pub fn external_semaphore_features(
        mut self,
        external_semaphore_features: ExternalSemaphoreFeatureFlags,
    ) -> Self {
        self.external_semaphore_features = external_semaphore_features;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExportSemaphoreCreateInfo.html>"]
#[must_use]
pub struct ExportSemaphoreCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalSemaphoreHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExportSemaphoreCreateInfo<'_> {}
unsafe impl Sync for ExportSemaphoreCreateInfo<'_> {}
impl ::core::default::Default for ExportSemaphoreCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_types: ExternalSemaphoreHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExportSemaphoreCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_SEMAPHORE_CREATE_INFO;
}
unsafe impl ExtendsSemaphoreCreateInfo for ExportSemaphoreCreateInfo<'_> {}
impl<'a> ExportSemaphoreCreateInfo<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.handle_types = handle_types;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImportSemaphoreWin32HandleInfoKHR.html>"]
#[must_use]
pub struct ImportSemaphoreWin32HandleInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub flags: SemaphoreImportFlags,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub handle: HANDLE,
    pub name: LPCWSTR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImportSemaphoreWin32HandleInfoKHR<'_> {}
unsafe impl Sync for ImportSemaphoreWin32HandleInfoKHR<'_> {}
impl ::core::default::Default for ImportSemaphoreWin32HandleInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            semaphore: Semaphore::default(),
            flags: SemaphoreImportFlags::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            handle: unsafe { ::core::mem::zeroed() },
            name: unsafe { ::core::mem::zeroed() },
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImportSemaphoreWin32HandleInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR;
}
impl<'a> ImportSemaphoreWin32HandleInfoKHR<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: SemaphoreImportFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn handle(mut self, handle: HANDLE) -> Self {
        self.handle = handle;
        self
    }
    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.name = name;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExportSemaphoreWin32HandleInfoKHR.html>"]
#[must_use]
pub struct ExportSemaphoreWin32HandleInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
    pub name: LPCWSTR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExportSemaphoreWin32HandleInfoKHR<'_> {}
unsafe impl Sync for ExportSemaphoreWin32HandleInfoKHR<'_> {}
impl ::core::default::Default for ExportSemaphoreWin32HandleInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            p_attributes: ::core::ptr::null(),
            dw_access: DWORD::default(),
            name: unsafe { ::core::mem::zeroed() },
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExportSemaphoreWin32HandleInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR;
}
unsafe impl ExtendsSemaphoreCreateInfo for ExportSemaphoreWin32HandleInfoKHR<'_> {}
impl<'a> ExportSemaphoreWin32HandleInfoKHR<'a> {
    #[inline]
    pub fn attributes(mut self, attributes: &'a SECURITY_ATTRIBUTES) -> Self {
        self.p_attributes = attributes;
        self
    }
    #[inline]
    pub fn dw_access(mut self, dw_access: DWORD) -> Self {
        self.dw_access = dw_access;
        self
    }
    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.name = name;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkD3D12FenceSubmitInfoKHR.html>"]
#[must_use]
pub struct D3D12FenceSubmitInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_values_count: u32,
    pub p_wait_semaphore_values: *const u64,
    pub signal_semaphore_values_count: u32,
    pub p_signal_semaphore_values: *const u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for D3D12FenceSubmitInfoKHR<'_> {}
unsafe impl Sync for D3D12FenceSubmitInfoKHR<'_> {}
impl ::core::default::Default for D3D12FenceSubmitInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            wait_semaphore_values_count: u32::default(),
            p_wait_semaphore_values: ::core::ptr::null(),
            signal_semaphore_values_count: u32::default(),
            p_signal_semaphore_values: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for D3D12FenceSubmitInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::D3D12_FENCE_SUBMIT_INFO_KHR;
}
unsafe impl ExtendsSubmitInfo for D3D12FenceSubmitInfoKHR<'_> {}
impl<'a> D3D12FenceSubmitInfoKHR<'a> {
    #[inline]
    pub fn wait_semaphore_values(mut self, wait_semaphore_values: &'a [u64]) -> Self {
        self.wait_semaphore_values_count = wait_semaphore_values.len() as _;
        self.p_wait_semaphore_values = wait_semaphore_values.as_ptr();
        self
    }
    #[inline]
    pub fn signal_semaphore_values(mut self, signal_semaphore_values: &'a [u64]) -> Self {
        self.signal_semaphore_values_count = signal_semaphore_values.len() as _;
        self.p_signal_semaphore_values = signal_semaphore_values.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSemaphoreGetWin32HandleInfoKHR.html>"]
#[must_use]
pub struct SemaphoreGetWin32HandleInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SemaphoreGetWin32HandleInfoKHR<'_> {}
unsafe impl Sync for SemaphoreGetWin32HandleInfoKHR<'_> {}
impl ::core::default::Default for SemaphoreGetWin32HandleInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            semaphore: Semaphore::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SemaphoreGetWin32HandleInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR;
}
impl<'a> SemaphoreGetWin32HandleInfoKHR<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImportSemaphoreFdInfoKHR.html>"]
#[must_use]
pub struct ImportSemaphoreFdInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub flags: SemaphoreImportFlags,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub fd: c_int,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImportSemaphoreFdInfoKHR<'_> {}
unsafe impl Sync for ImportSemaphoreFdInfoKHR<'_> {}
impl ::core::default::Default for ImportSemaphoreFdInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            semaphore: Semaphore::default(),
            flags: SemaphoreImportFlags::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            fd: c_int::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImportSemaphoreFdInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_SEMAPHORE_FD_INFO_KHR;
}
impl<'a> ImportSemaphoreFdInfoKHR<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: SemaphoreImportFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn fd(mut self, fd: c_int) -> Self {
        self.fd = fd;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSemaphoreGetFdInfoKHR.html>"]
#[must_use]
pub struct SemaphoreGetFdInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SemaphoreGetFdInfoKHR<'_> {}
unsafe impl Sync for SemaphoreGetFdInfoKHR<'_> {}
impl ::core::default::Default for SemaphoreGetFdInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            semaphore: Semaphore::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SemaphoreGetFdInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SEMAPHORE_GET_FD_INFO_KHR;
}
impl<'a> SemaphoreGetFdInfoKHR<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImportSemaphoreZirconHandleInfoFUCHSIA.html>"]
#[must_use]
pub struct ImportSemaphoreZirconHandleInfoFUCHSIA<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub flags: SemaphoreImportFlags,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub zircon_handle: zx_handle_t,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImportSemaphoreZirconHandleInfoFUCHSIA<'_> {}
unsafe impl Sync for ImportSemaphoreZirconHandleInfoFUCHSIA<'_> {}
impl ::core::default::Default for ImportSemaphoreZirconHandleInfoFUCHSIA<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            semaphore: Semaphore::default(),
            flags: SemaphoreImportFlags::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            zircon_handle: zx_handle_t::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImportSemaphoreZirconHandleInfoFUCHSIA<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA;
}
impl<'a> ImportSemaphoreZirconHandleInfoFUCHSIA<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: SemaphoreImportFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn zircon_handle(mut self, zircon_handle: zx_handle_t) -> Self {
        self.zircon_handle = zircon_handle;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSemaphoreGetZirconHandleInfoFUCHSIA.html>"]
#[must_use]
pub struct SemaphoreGetZirconHandleInfoFUCHSIA<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SemaphoreGetZirconHandleInfoFUCHSIA<'_> {}
unsafe impl Sync for SemaphoreGetZirconHandleInfoFUCHSIA<'_> {}
impl ::core::default::Default for SemaphoreGetZirconHandleInfoFUCHSIA<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            semaphore: Semaphore::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SemaphoreGetZirconHandleInfoFUCHSIA<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA;
}
impl<'a> SemaphoreGetZirconHandleInfoFUCHSIA<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceExternalFenceInfo.html>"]
#[must_use]
pub struct PhysicalDeviceExternalFenceInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalFenceHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceExternalFenceInfo<'_> {}
unsafe impl Sync for PhysicalDeviceExternalFenceInfo<'_> {}
impl ::core::default::Default for PhysicalDeviceExternalFenceInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceExternalFenceInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO;
}
impl<'a> PhysicalDeviceExternalFenceInfo<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExternalFenceProperties.html>"]
#[must_use]
pub struct ExternalFenceProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub export_from_imported_handle_types: ExternalFenceHandleTypeFlags,
    pub compatible_handle_types: ExternalFenceHandleTypeFlags,
    pub external_fence_features: ExternalFenceFeatureFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExternalFenceProperties<'_> {}
unsafe impl Sync for ExternalFenceProperties<'_> {}
impl ::core::default::Default for ExternalFenceProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            export_from_imported_handle_types: ExternalFenceHandleTypeFlags::default(),
            compatible_handle_types: ExternalFenceHandleTypeFlags::default(),
            external_fence_features: ExternalFenceFeatureFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExternalFenceProperties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_FENCE_PROPERTIES;
}
impl<'a> ExternalFenceProperties<'a> {
    #[inline]
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalFenceHandleTypeFlags,
    ) -> Self {
        self.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }
    #[inline]
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalFenceHandleTypeFlags,
    ) -> Self {
        self.compatible_handle_types = compatible_handle_types;
        self
    }
    #[inline]
    pub fn external_fence_features(
        mut self,
        external_fence_features: ExternalFenceFeatureFlags,
    ) -> Self {
        self.external_fence_features = external_fence_features;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExportFenceCreateInfo.html>"]
#[must_use]
pub struct ExportFenceCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalFenceHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExportFenceCreateInfo<'_> {}
unsafe impl Sync for ExportFenceCreateInfo<'_> {}
impl ::core::default::Default for ExportFenceCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_types: ExternalFenceHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExportFenceCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_FENCE_CREATE_INFO;
}
unsafe impl ExtendsFenceCreateInfo for ExportFenceCreateInfo<'_> {}
impl<'a> ExportFenceCreateInfo<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalFenceHandleTypeFlags) -> Self {
        self.handle_types = handle_types;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImportFenceWin32HandleInfoKHR.html>"]
#[must_use]
pub struct ImportFenceWin32HandleInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub fence: Fence,
    pub flags: FenceImportFlags,
    pub handle_type: ExternalFenceHandleTypeFlags,
    pub handle: HANDLE,
    pub name: LPCWSTR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImportFenceWin32HandleInfoKHR<'_> {}
unsafe impl Sync for ImportFenceWin32HandleInfoKHR<'_> {}
impl ::core::default::Default for ImportFenceWin32HandleInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            fence: Fence::default(),
            flags: FenceImportFlags::default(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
            handle: unsafe { ::core::mem::zeroed() },
            name: unsafe { ::core::mem::zeroed() },
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImportFenceWin32HandleInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_FENCE_WIN32_HANDLE_INFO_KHR;
}
impl<'a> ImportFenceWin32HandleInfoKHR<'a> {
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.fence = fence;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: FenceImportFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn handle(mut self, handle: HANDLE) -> Self {
        self.handle = handle;
        self
    }
    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.name = name;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExportFenceWin32HandleInfoKHR.html>"]
#[must_use]
pub struct ExportFenceWin32HandleInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
    pub name: LPCWSTR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExportFenceWin32HandleInfoKHR<'_> {}
unsafe impl Sync for ExportFenceWin32HandleInfoKHR<'_> {}
impl ::core::default::Default for ExportFenceWin32HandleInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            p_attributes: ::core::ptr::null(),
            dw_access: DWORD::default(),
            name: unsafe { ::core::mem::zeroed() },
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExportFenceWin32HandleInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_FENCE_WIN32_HANDLE_INFO_KHR;
}
unsafe impl ExtendsFenceCreateInfo for ExportFenceWin32HandleInfoKHR<'_> {}
impl<'a> ExportFenceWin32HandleInfoKHR<'a> {
    #[inline]
    pub fn attributes(mut self, attributes: &'a SECURITY_ATTRIBUTES) -> Self {
        self.p_attributes = attributes;
        self
    }
    #[inline]
    pub fn dw_access(mut self, dw_access: DWORD) -> Self {
        self.dw_access = dw_access;
        self
    }
    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.name = name;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkFenceGetWin32HandleInfoKHR.html>"]
#[must_use]
pub struct FenceGetWin32HandleInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub fence: Fence,
    pub handle_type: ExternalFenceHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for FenceGetWin32HandleInfoKHR<'_> {}
unsafe impl Sync for FenceGetWin32HandleInfoKHR<'_> {}
impl ::core::default::Default for FenceGetWin32HandleInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            fence: Fence::default(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for FenceGetWin32HandleInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::FENCE_GET_WIN32_HANDLE_INFO_KHR;
}
impl<'a> FenceGetWin32HandleInfoKHR<'a> {
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.fence = fence;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImportFenceFdInfoKHR.html>"]
#[must_use]
pub struct ImportFenceFdInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub fence: Fence,
    pub flags: FenceImportFlags,
    pub handle_type: ExternalFenceHandleTypeFlags,
    pub fd: c_int,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImportFenceFdInfoKHR<'_> {}
unsafe impl Sync for ImportFenceFdInfoKHR<'_> {}
impl ::core::default::Default for ImportFenceFdInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            fence: Fence::default(),
            flags: FenceImportFlags::default(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
            fd: c_int::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImportFenceFdInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_FENCE_FD_INFO_KHR;
}
impl<'a> ImportFenceFdInfoKHR<'a> {
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.fence = fence;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: FenceImportFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn fd(mut self, fd: c_int) -> Self {
        self.fd = fd;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkFenceGetFdInfoKHR.html>"]
#[must_use]
pub struct FenceGetFdInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub fence: Fence,
    pub handle_type: ExternalFenceHandleTypeFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for FenceGetFdInfoKHR<'_> {}
unsafe impl Sync for FenceGetFdInfoKHR<'_> {}
impl ::core::default::Default for FenceGetFdInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            fence: Fence::default(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for FenceGetFdInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::FENCE_GET_FD_INFO_KHR;
}
impl<'a> FenceGetFdInfoKHR<'a> {
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.fence = fence;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMultiviewFeatures.html>"]
#[must_use]
pub struct PhysicalDeviceMultiviewFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub multiview: Bool32,
    pub multiview_geometry_shader: Bool32,
    pub multiview_tessellation_shader: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMultiviewFeatures<'_> {}
unsafe impl Sync for PhysicalDeviceMultiviewFeatures<'_> {}
impl ::core::default::Default for PhysicalDeviceMultiviewFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            multiview: Bool32::default(),
            multiview_geometry_shader: Bool32::default(),
            multiview_tessellation_shader: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMultiviewFeatures<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MULTIVIEW_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMultiviewFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMultiviewFeatures<'_> {}
impl<'a> PhysicalDeviceMultiviewFeatures<'a> {
    #[inline]
    pub fn multiview(mut self, multiview: bool) -> Self {
        self.multiview = multiview.into();
        self
    }
    #[inline]
    pub fn multiview_geometry_shader(mut self, multiview_geometry_shader: bool) -> Self {
        self.multiview_geometry_shader = multiview_geometry_shader.into();
        self
    }
    #[inline]
    pub fn multiview_tessellation_shader(mut self, multiview_tessellation_shader: bool) -> Self {
        self.multiview_tessellation_shader = multiview_tessellation_shader.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMultiviewProperties.html>"]
#[must_use]
pub struct PhysicalDeviceMultiviewProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_multiview_view_count: u32,
    pub max_multiview_instance_index: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMultiviewProperties<'_> {}
unsafe impl Sync for PhysicalDeviceMultiviewProperties<'_> {}
impl ::core::default::Default for PhysicalDeviceMultiviewProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_multiview_view_count: u32::default(),
            max_multiview_instance_index: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMultiviewProperties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMultiviewProperties<'_> {}
impl<'a> PhysicalDeviceMultiviewProperties<'a> {
    #[inline]
    pub fn max_multiview_view_count(mut self, max_multiview_view_count: u32) -> Self {
        self.max_multiview_view_count = max_multiview_view_count;
        self
    }
    #[inline]
    pub fn max_multiview_instance_index(mut self, max_multiview_instance_index: u32) -> Self {
        self.max_multiview_instance_index = max_multiview_instance_index;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRenderPassMultiviewCreateInfo.html>"]
#[must_use]
pub struct RenderPassMultiviewCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub subpass_count: u32,
    pub p_view_masks: *const u32,
    pub dependency_count: u32,
    pub p_view_offsets: *const i32,
    pub correlation_mask_count: u32,
    pub p_correlation_masks: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for RenderPassMultiviewCreateInfo<'_> {}
unsafe impl Sync for RenderPassMultiviewCreateInfo<'_> {}
impl ::core::default::Default for RenderPassMultiviewCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            subpass_count: u32::default(),
            p_view_masks: ::core::ptr::null(),
            dependency_count: u32::default(),
            p_view_offsets: ::core::ptr::null(),
            correlation_mask_count: u32::default(),
            p_correlation_masks: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for RenderPassMultiviewCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::RENDER_PASS_MULTIVIEW_CREATE_INFO;
}
unsafe impl ExtendsRenderPassCreateInfo for RenderPassMultiviewCreateInfo<'_> {}
impl<'a> RenderPassMultiviewCreateInfo<'a> {
    #[inline]
    pub fn view_masks(mut self, view_masks: &'a [u32]) -> Self {
        self.subpass_count = view_masks.len() as _;
        self.p_view_masks = view_masks.as_ptr();
        self
    }
    #[inline]
    pub fn view_offsets(mut self, view_offsets: &'a [i32]) -> Self {
        self.dependency_count = view_offsets.len() as _;
        self.p_view_offsets = view_offsets.as_ptr();
        self
    }
    #[inline]
    pub fn correlation_masks(mut self, correlation_masks: &'a [u32]) -> Self {
        self.correlation_mask_count = correlation_masks.len() as _;
        self.p_correlation_masks = correlation_masks.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSurfaceCapabilities2EXT.html>"]
#[must_use]
pub struct SurfaceCapabilities2EXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub min_image_count: u32,
    pub max_image_count: u32,
    pub current_extent: Extent2D,
    pub min_image_extent: Extent2D,
    pub max_image_extent: Extent2D,
    pub max_image_array_layers: u32,
    pub supported_transforms: SurfaceTransformFlagsKHR,
    pub current_transform: SurfaceTransformFlagsKHR,
    pub supported_composite_alpha: CompositeAlphaFlagsKHR,
    pub supported_usage_flags: ImageUsageFlags,
    pub supported_surface_counters: SurfaceCounterFlagsEXT,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SurfaceCapabilities2EXT<'_> {}
unsafe impl Sync for SurfaceCapabilities2EXT<'_> {}
impl ::core::default::Default for SurfaceCapabilities2EXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            min_image_count: u32::default(),
            max_image_count: u32::default(),
            current_extent: Extent2D::default(),
            min_image_extent: Extent2D::default(),
            max_image_extent: Extent2D::default(),
            max_image_array_layers: u32::default(),
            supported_transforms: SurfaceTransformFlagsKHR::default(),
            current_transform: SurfaceTransformFlagsKHR::default(),
            supported_composite_alpha: CompositeAlphaFlagsKHR::default(),
            supported_usage_flags: ImageUsageFlags::default(),
            supported_surface_counters: SurfaceCounterFlagsEXT::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SurfaceCapabilities2EXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SURFACE_CAPABILITIES_2_EXT;
}
impl<'a> SurfaceCapabilities2EXT<'a> {
    #[inline]
    pub fn min_image_count(mut self, min_image_count: u32) -> Self {
        self.min_image_count = min_image_count;
        self
    }
    #[inline]
    pub fn max_image_count(mut self, max_image_count: u32) -> Self {
        self.max_image_count = max_image_count;
        self
    }
    #[inline]
    pub fn current_extent(mut self, current_extent: Extent2D) -> Self {
        self.current_extent = current_extent;
        self
    }
    #[inline]
    pub fn min_image_extent(mut self, min_image_extent: Extent2D) -> Self {
        self.min_image_extent = min_image_extent;
        self
    }
    #[inline]
    pub fn max_image_extent(mut self, max_image_extent: Extent2D) -> Self {
        self.max_image_extent = max_image_extent;
        self
    }
    #[inline]
    pub fn max_image_array_layers(mut self, max_image_array_layers: u32) -> Self {
        self.max_image_array_layers = max_image_array_layers;
        self
    }
    #[inline]
    pub fn supported_transforms(mut self, supported_transforms: SurfaceTransformFlagsKHR) -> Self {
        self.supported_transforms = supported_transforms;
        self
    }
    #[inline]
    pub fn current_transform(mut self, current_transform: SurfaceTransformFlagsKHR) -> Self {
        self.current_transform = current_transform;
        self
    }
    #[inline]
    pub fn supported_composite_alpha(
        mut self,
        supported_composite_alpha: CompositeAlphaFlagsKHR,
    ) -> Self {
        self.supported_composite_alpha = supported_composite_alpha;
        self
    }
    #[inline]
    pub fn supported_usage_flags(mut self, supported_usage_flags: ImageUsageFlags) -> Self {
        self.supported_usage_flags = supported_usage_flags;
        self
    }
    #[inline]
    pub fn supported_surface_counters(
        mut self,
        supported_surface_counters: SurfaceCounterFlagsEXT,
    ) -> Self {
        self.supported_surface_counters = supported_surface_counters;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayPowerInfoEXT.html>"]
#[must_use]
pub struct DisplayPowerInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub power_state: DisplayPowerStateEXT,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DisplayPowerInfoEXT<'_> {}
unsafe impl Sync for DisplayPowerInfoEXT<'_> {}
impl ::core::default::Default for DisplayPowerInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            power_state: DisplayPowerStateEXT::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DisplayPowerInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_POWER_INFO_EXT;
}
impl<'a> DisplayPowerInfoEXT<'a> {
    #[inline]
    pub fn power_state(mut self, power_state: DisplayPowerStateEXT) -> Self {
        self.power_state = power_state;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceEventInfoEXT.html>"]
#[must_use]
pub struct DeviceEventInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub device_event: DeviceEventTypeEXT,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceEventInfoEXT<'_> {}
unsafe impl Sync for DeviceEventInfoEXT<'_> {}
impl ::core::default::Default for DeviceEventInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            device_event: DeviceEventTypeEXT::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceEventInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_EVENT_INFO_EXT;
}
impl<'a> DeviceEventInfoEXT<'a> {
    #[inline]
    pub fn device_event(mut self, device_event: DeviceEventTypeEXT) -> Self {
        self.device_event = device_event;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayEventInfoEXT.html>"]
#[must_use]
pub struct DisplayEventInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub display_event: DisplayEventTypeEXT,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DisplayEventInfoEXT<'_> {}
unsafe impl Sync for DisplayEventInfoEXT<'_> {}
impl ::core::default::Default for DisplayEventInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            display_event: DisplayEventTypeEXT::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DisplayEventInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_EVENT_INFO_EXT;
}
impl<'a> DisplayEventInfoEXT<'a> {
    #[inline]
    pub fn display_event(mut self, display_event: DisplayEventTypeEXT) -> Self {
        self.display_event = display_event;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSwapchainCounterCreateInfoEXT.html>"]
#[must_use]
pub struct SwapchainCounterCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub surface_counters: SurfaceCounterFlagsEXT,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SwapchainCounterCreateInfoEXT<'_> {}
unsafe impl Sync for SwapchainCounterCreateInfoEXT<'_> {}
impl ::core::default::Default for SwapchainCounterCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            surface_counters: SurfaceCounterFlagsEXT::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SwapchainCounterCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SWAPCHAIN_COUNTER_CREATE_INFO_EXT;
}
unsafe impl ExtendsSwapchainCreateInfoKHR for SwapchainCounterCreateInfoEXT<'_> {}
impl<'a> SwapchainCounterCreateInfoEXT<'a> {
    #[inline]
    pub fn surface_counters(mut self, surface_counters: SurfaceCounterFlagsEXT) -> Self {
        self.surface_counters = surface_counters;
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceGroupProperties.html>"]
#[must_use]
pub struct PhysicalDeviceGroupProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub physical_device_count: u32,
    pub physical_devices: [PhysicalDevice; MAX_DEVICE_GROUP_SIZE],
    pub subset_allocation: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceGroupProperties<'_> {}
unsafe impl Sync for PhysicalDeviceGroupProperties<'_> {}
#[cfg(feature = "debug")]
impl fmt::Debug for PhysicalDeviceGroupProperties<'_> {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("PhysicalDeviceGroupProperties")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("physical_device_count", &self.physical_device_count)
            .field("physical_devices", &self.physical_devices_as_slice())
            .field("subset_allocation", &self.subset_allocation)
            .finish()
    }
}
impl ::core::default::Default for PhysicalDeviceGroupProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            physical_device_count: u32::default(),
            physical_devices: unsafe { ::core::mem::zeroed() },
            subset_allocation: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceGroupProperties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_GROUP_PROPERTIES;
}
impl<'a> PhysicalDeviceGroupProperties<'a> {
    #[inline]
    pub fn physical_devices(mut self, physical_devices: &'_ [PhysicalDevice]) -> Self {
        self.physical_device_count = physical_devices.len() as _;
        self.physical_devices[..physical_devices.len()].copy_from_slice(physical_devices);
        self
    }
    #[inline]
    pub fn physical_devices_as_slice(&self) -> &[PhysicalDevice] {
        &self.physical_devices[..self.physical_device_count as _]
    }
    #[inline]
    pub fn subset_allocation(mut self, subset_allocation: bool) -> Self {
        self.subset_allocation = subset_allocation.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryAllocateFlagsInfo.html>"]
#[must_use]
pub struct MemoryAllocateFlagsInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: MemoryAllocateFlags,
    pub device_mask: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryAllocateFlagsInfo<'_> {}
unsafe impl Sync for MemoryAllocateFlagsInfo<'_> {}
impl ::core::default::Default for MemoryAllocateFlagsInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: MemoryAllocateFlags::default(),
            device_mask: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryAllocateFlagsInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_ALLOCATE_FLAGS_INFO;
}
unsafe impl ExtendsMemoryAllocateInfo for MemoryAllocateFlagsInfo<'_> {}
impl<'a> MemoryAllocateFlagsInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: MemoryAllocateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.device_mask = device_mask;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBindBufferMemoryInfo.html>"]
#[must_use]
pub struct BindBufferMemoryInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub buffer: Buffer,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BindBufferMemoryInfo<'_> {}
unsafe impl Sync for BindBufferMemoryInfo<'_> {}
impl ::core::default::Default for BindBufferMemoryInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            buffer: Buffer::default(),
            memory: DeviceMemory::default(),
            memory_offset: DeviceSize::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BindBufferMemoryInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_BUFFER_MEMORY_INFO;
}
pub unsafe trait ExtendsBindBufferMemoryInfo {}
impl<'a> BindBufferMemoryInfo<'a> {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.buffer = buffer;
        self
    }
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.memory = memory;
        self
    }
    #[inline]
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> Self {
        self.memory_offset = memory_offset;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBindBufferMemoryInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBindBufferMemoryDeviceGroupInfo.html>"]
#[must_use]
pub struct BindBufferMemoryDeviceGroupInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub device_index_count: u32,
    pub p_device_indices: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BindBufferMemoryDeviceGroupInfo<'_> {}
unsafe impl Sync for BindBufferMemoryDeviceGroupInfo<'_> {}
impl ::core::default::Default for BindBufferMemoryDeviceGroupInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            device_index_count: u32::default(),
            p_device_indices: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BindBufferMemoryDeviceGroupInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO;
}
unsafe impl ExtendsBindBufferMemoryInfo for BindBufferMemoryDeviceGroupInfo<'_> {}
impl<'a> BindBufferMemoryDeviceGroupInfo<'a> {
    #[inline]
    pub fn device_indices(mut self, device_indices: &'a [u32]) -> Self {
        self.device_index_count = device_indices.len() as _;
        self.p_device_indices = device_indices.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBindImageMemoryInfo.html>"]
#[must_use]
pub struct BindImageMemoryInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub image: Image,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BindImageMemoryInfo<'_> {}
unsafe impl Sync for BindImageMemoryInfo<'_> {}
impl ::core::default::Default for BindImageMemoryInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            image: Image::default(),
            memory: DeviceMemory::default(),
            memory_offset: DeviceSize::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BindImageMemoryInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_IMAGE_MEMORY_INFO;
}
pub unsafe trait ExtendsBindImageMemoryInfo {}
impl<'a> BindImageMemoryInfo<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.image = image;
        self
    }
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.memory = memory;
        self
    }
    #[inline]
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> Self {
        self.memory_offset = memory_offset;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBindImageMemoryInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBindImageMemoryDeviceGroupInfo.html>"]
#[must_use]
pub struct BindImageMemoryDeviceGroupInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub device_index_count: u32,
    pub p_device_indices: *const u32,
    pub split_instance_bind_region_count: u32,
    pub p_split_instance_bind_regions: *const Rect2D,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BindImageMemoryDeviceGroupInfo<'_> {}
unsafe impl Sync for BindImageMemoryDeviceGroupInfo<'_> {}
impl ::core::default::Default for BindImageMemoryDeviceGroupInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            device_index_count: u32::default(),
            p_device_indices: ::core::ptr::null(),
            split_instance_bind_region_count: u32::default(),
            p_split_instance_bind_regions: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BindImageMemoryDeviceGroupInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO;
}
unsafe impl ExtendsBindImageMemoryInfo for BindImageMemoryDeviceGroupInfo<'_> {}
impl<'a> BindImageMemoryDeviceGroupInfo<'a> {
    #[inline]
    pub fn device_indices(mut self, device_indices: &'a [u32]) -> Self {
        self.device_index_count = device_indices.len() as _;
        self.p_device_indices = device_indices.as_ptr();
        self
    }
    #[inline]
    pub fn split_instance_bind_regions(
        mut self,
        split_instance_bind_regions: &'a [Rect2D],
    ) -> Self {
        self.split_instance_bind_region_count = split_instance_bind_regions.len() as _;
        self.p_split_instance_bind_regions = split_instance_bind_regions.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupRenderPassBeginInfo.html>"]
#[must_use]
pub struct DeviceGroupRenderPassBeginInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub device_mask: u32,
    pub device_render_area_count: u32,
    pub p_device_render_areas: *const Rect2D,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceGroupRenderPassBeginInfo<'_> {}
unsafe impl Sync for DeviceGroupRenderPassBeginInfo<'_> {}
impl ::core::default::Default for DeviceGroupRenderPassBeginInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            device_mask: u32::default(),
            device_render_area_count: u32::default(),
            p_device_render_areas: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceGroupRenderPassBeginInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_RENDER_PASS_BEGIN_INFO;
}
unsafe impl ExtendsRenderPassBeginInfo for DeviceGroupRenderPassBeginInfo<'_> {}
unsafe impl ExtendsRenderingInfo for DeviceGroupRenderPassBeginInfo<'_> {}
impl<'a> DeviceGroupRenderPassBeginInfo<'a> {
    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.device_mask = device_mask;
        self
    }
    #[inline]
    pub fn device_render_areas(mut self, device_render_areas: &'a [Rect2D]) -> Self {
        self.device_render_area_count = device_render_areas.len() as _;
        self.p_device_render_areas = device_render_areas.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupCommandBufferBeginInfo.html>"]
#[must_use]
pub struct DeviceGroupCommandBufferBeginInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub device_mask: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceGroupCommandBufferBeginInfo<'_> {}
unsafe impl Sync for DeviceGroupCommandBufferBeginInfo<'_> {}
impl ::core::default::Default for DeviceGroupCommandBufferBeginInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            device_mask: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceGroupCommandBufferBeginInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO;
}
unsafe impl ExtendsCommandBufferBeginInfo for DeviceGroupCommandBufferBeginInfo<'_> {}
impl<'a> DeviceGroupCommandBufferBeginInfo<'a> {
    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.device_mask = device_mask;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupSubmitInfo.html>"]
#[must_use]
pub struct DeviceGroupSubmitInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_count: u32,
    pub p_wait_semaphore_device_indices: *const u32,
    pub command_buffer_count: u32,
    pub p_command_buffer_device_masks: *const u32,
    pub signal_semaphore_count: u32,
    pub p_signal_semaphore_device_indices: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceGroupSubmitInfo<'_> {}
unsafe impl Sync for DeviceGroupSubmitInfo<'_> {}
impl ::core::default::Default for DeviceGroupSubmitInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            wait_semaphore_count: u32::default(),
            p_wait_semaphore_device_indices: ::core::ptr::null(),
            command_buffer_count: u32::default(),
            p_command_buffer_device_masks: ::core::ptr::null(),
            signal_semaphore_count: u32::default(),
            p_signal_semaphore_device_indices: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceGroupSubmitInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_SUBMIT_INFO;
}
unsafe impl ExtendsSubmitInfo for DeviceGroupSubmitInfo<'_> {}
impl<'a> DeviceGroupSubmitInfo<'a> {
    #[inline]
    pub fn wait_semaphore_device_indices(
        mut self,
        wait_semaphore_device_indices: &'a [u32],
    ) -> Self {
        self.wait_semaphore_count = wait_semaphore_device_indices.len() as _;
        self.p_wait_semaphore_device_indices = wait_semaphore_device_indices.as_ptr();
        self
    }
    #[inline]
    pub fn command_buffer_device_masks(mut self, command_buffer_device_masks: &'a [u32]) -> Self {
        self.command_buffer_count = command_buffer_device_masks.len() as _;
        self.p_command_buffer_device_masks = command_buffer_device_masks.as_ptr();
        self
    }
    #[inline]
    pub fn signal_semaphore_device_indices(
        mut self,
        signal_semaphore_device_indices: &'a [u32],
    ) -> Self {
        self.signal_semaphore_count = signal_semaphore_device_indices.len() as _;
        self.p_signal_semaphore_device_indices = signal_semaphore_device_indices.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupBindSparseInfo.html>"]
#[must_use]
pub struct DeviceGroupBindSparseInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub resource_device_index: u32,
    pub memory_device_index: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceGroupBindSparseInfo<'_> {}
unsafe impl Sync for DeviceGroupBindSparseInfo<'_> {}
impl ::core::default::Default for DeviceGroupBindSparseInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            resource_device_index: u32::default(),
            memory_device_index: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceGroupBindSparseInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_BIND_SPARSE_INFO;
}
unsafe impl ExtendsBindSparseInfo for DeviceGroupBindSparseInfo<'_> {}
impl<'a> DeviceGroupBindSparseInfo<'a> {
    #[inline]
    pub fn resource_device_index(mut self, resource_device_index: u32) -> Self {
        self.resource_device_index = resource_device_index;
        self
    }
    #[inline]
    pub fn memory_device_index(mut self, memory_device_index: u32) -> Self {
        self.memory_device_index = memory_device_index;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupPresentCapabilitiesKHR.html>"]
#[must_use]
pub struct DeviceGroupPresentCapabilitiesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub present_mask: [u32; MAX_DEVICE_GROUP_SIZE],
    pub modes: DeviceGroupPresentModeFlagsKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceGroupPresentCapabilitiesKHR<'_> {}
unsafe impl Sync for DeviceGroupPresentCapabilitiesKHR<'_> {}
impl ::core::default::Default for DeviceGroupPresentCapabilitiesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            present_mask: unsafe { ::core::mem::zeroed() },
            modes: DeviceGroupPresentModeFlagsKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceGroupPresentCapabilitiesKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_PRESENT_CAPABILITIES_KHR;
}
impl<'a> DeviceGroupPresentCapabilitiesKHR<'a> {
    #[inline]
    pub fn present_mask(mut self, present_mask: [u32; MAX_DEVICE_GROUP_SIZE]) -> Self {
        self.present_mask = present_mask;
        self
    }
    #[inline]
    pub fn modes(mut self, modes: DeviceGroupPresentModeFlagsKHR) -> Self {
        self.modes = modes;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageSwapchainCreateInfoKHR.html>"]
#[must_use]
pub struct ImageSwapchainCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain: SwapchainKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageSwapchainCreateInfoKHR<'_> {}
unsafe impl Sync for ImageSwapchainCreateInfoKHR<'_> {}
impl ::core::default::Default for ImageSwapchainCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            swapchain: SwapchainKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageSwapchainCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_SWAPCHAIN_CREATE_INFO_KHR;
}
unsafe impl ExtendsImageCreateInfo for ImageSwapchainCreateInfoKHR<'_> {}
impl<'a> ImageSwapchainCreateInfoKHR<'a> {
    #[inline]
    pub fn swapchain(mut self, swapchain: SwapchainKHR) -> Self {
        self.swapchain = swapchain;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBindImageMemorySwapchainInfoKHR.html>"]
#[must_use]
pub struct BindImageMemorySwapchainInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain: SwapchainKHR,
    pub image_index: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BindImageMemorySwapchainInfoKHR<'_> {}
unsafe impl Sync for BindImageMemorySwapchainInfoKHR<'_> {}
impl ::core::default::Default for BindImageMemorySwapchainInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            swapchain: SwapchainKHR::default(),
            image_index: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BindImageMemorySwapchainInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR;
}
unsafe impl ExtendsBindImageMemoryInfo for BindImageMemorySwapchainInfoKHR<'_> {}
impl<'a> BindImageMemorySwapchainInfoKHR<'a> {
    #[inline]
    pub fn swapchain(mut self, swapchain: SwapchainKHR) -> Self {
        self.swapchain = swapchain;
        self
    }
    #[inline]
    pub fn image_index(mut self, image_index: u32) -> Self {
        self.image_index = image_index;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAcquireNextImageInfoKHR.html>"]
#[must_use]
pub struct AcquireNextImageInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain: SwapchainKHR,
    pub timeout: u64,
    pub semaphore: Semaphore,
    pub fence: Fence,
    pub device_mask: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for AcquireNextImageInfoKHR<'_> {}
unsafe impl Sync for AcquireNextImageInfoKHR<'_> {}
impl ::core::default::Default for AcquireNextImageInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            swapchain: SwapchainKHR::default(),
            timeout: u64::default(),
            semaphore: Semaphore::default(),
            fence: Fence::default(),
            device_mask: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for AcquireNextImageInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::ACQUIRE_NEXT_IMAGE_INFO_KHR;
}
impl<'a> AcquireNextImageInfoKHR<'a> {
    #[inline]
    pub fn swapchain(mut self, swapchain: SwapchainKHR) -> Self {
        self.swapchain = swapchain;
        self
    }
    #[inline]
    pub fn timeout(mut self, timeout: u64) -> Self {
        self.timeout = timeout;
        self
    }
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.fence = fence;
        self
    }
    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.device_mask = device_mask;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupPresentInfoKHR.html>"]
#[must_use]
pub struct DeviceGroupPresentInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain_count: u32,
    pub p_device_masks: *const u32,
    pub mode: DeviceGroupPresentModeFlagsKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceGroupPresentInfoKHR<'_> {}
unsafe impl Sync for DeviceGroupPresentInfoKHR<'_> {}
impl ::core::default::Default for DeviceGroupPresentInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            swapchain_count: u32::default(),
            p_device_masks: ::core::ptr::null(),
            mode: DeviceGroupPresentModeFlagsKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceGroupPresentInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_PRESENT_INFO_KHR;
}
unsafe impl ExtendsPresentInfoKHR for DeviceGroupPresentInfoKHR<'_> {}
impl<'a> DeviceGroupPresentInfoKHR<'a> {
    #[inline]
    pub fn device_masks(mut self, device_masks: &'a [u32]) -> Self {
        self.swapchain_count = device_masks.len() as _;
        self.p_device_masks = device_masks.as_ptr();
        self
    }
    #[inline]
    pub fn mode(mut self, mode: DeviceGroupPresentModeFlagsKHR) -> Self {
        self.mode = mode;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupDeviceCreateInfo.html>"]
#[must_use]
pub struct DeviceGroupDeviceCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub physical_device_count: u32,
    pub p_physical_devices: *const PhysicalDevice,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceGroupDeviceCreateInfo<'_> {}
unsafe impl Sync for DeviceGroupDeviceCreateInfo<'_> {}
impl ::core::default::Default for DeviceGroupDeviceCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            physical_device_count: u32::default(),
            p_physical_devices: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceGroupDeviceCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_DEVICE_CREATE_INFO;
}
unsafe impl ExtendsDeviceCreateInfo for DeviceGroupDeviceCreateInfo<'_> {}
impl<'a> DeviceGroupDeviceCreateInfo<'a> {
    #[inline]
    pub fn physical_devices(mut self, physical_devices: &'a [PhysicalDevice]) -> Self {
        self.physical_device_count = physical_devices.len() as _;
        self.p_physical_devices = physical_devices.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupSwapchainCreateInfoKHR.html>"]
#[must_use]
pub struct DeviceGroupSwapchainCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub modes: DeviceGroupPresentModeFlagsKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceGroupSwapchainCreateInfoKHR<'_> {}
unsafe impl Sync for DeviceGroupSwapchainCreateInfoKHR<'_> {}
impl ::core::default::Default for DeviceGroupSwapchainCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            modes: DeviceGroupPresentModeFlagsKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceGroupSwapchainCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR;
}
unsafe impl ExtendsSwapchainCreateInfoKHR for DeviceGroupSwapchainCreateInfoKHR<'_> {}
impl<'a> DeviceGroupSwapchainCreateInfoKHR<'a> {
    #[inline]
    pub fn modes(mut self, modes: DeviceGroupPresentModeFlagsKHR) -> Self {
        self.modes = modes;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorUpdateTemplateEntry.html>"]
#[must_use]
pub struct DescriptorUpdateTemplateEntry {
    pub dst_binding: u32,
    pub dst_array_element: u32,
    pub descriptor_count: u32,
    pub descriptor_type: DescriptorType,
    pub offset: usize,
    pub stride: usize,
}
impl DescriptorUpdateTemplateEntry {
    #[inline]
    pub fn dst_binding(mut self, dst_binding: u32) -> Self {
        self.dst_binding = dst_binding;
        self
    }
    #[inline]
    pub fn dst_array_element(mut self, dst_array_element: u32) -> Self {
        self.dst_array_element = dst_array_element;
        self
    }
    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.descriptor_count = descriptor_count;
        self
    }
    #[inline]
    pub fn descriptor_type(mut self, descriptor_type: DescriptorType) -> Self {
        self.descriptor_type = descriptor_type;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: usize) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn stride(mut self, stride: usize) -> Self {
        self.stride = stride;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorUpdateTemplateCreateInfo.html>"]
#[must_use]
pub struct DescriptorUpdateTemplateCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DescriptorUpdateTemplateCreateFlags,
    pub descriptor_update_entry_count: u32,
    pub p_descriptor_update_entries: *const DescriptorUpdateTemplateEntry,
    pub template_type: DescriptorUpdateTemplateType,
    pub descriptor_set_layout: DescriptorSetLayout,
    pub pipeline_bind_point: PipelineBindPoint,
    pub pipeline_layout: PipelineLayout,
    pub set: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DescriptorUpdateTemplateCreateInfo<'_> {}
unsafe impl Sync for DescriptorUpdateTemplateCreateInfo<'_> {}
impl ::core::default::Default for DescriptorUpdateTemplateCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DescriptorUpdateTemplateCreateFlags::default(),
            descriptor_update_entry_count: u32::default(),
            p_descriptor_update_entries: ::core::ptr::null(),
            template_type: DescriptorUpdateTemplateType::default(),
            descriptor_set_layout: DescriptorSetLayout::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            pipeline_layout: PipelineLayout::default(),
            set: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DescriptorUpdateTemplateCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO;
}
impl<'a> DescriptorUpdateTemplateCreateInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: DescriptorUpdateTemplateCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn descriptor_update_entries(
        mut self,
        descriptor_update_entries: &'a [DescriptorUpdateTemplateEntry],
    ) -> Self {
        self.descriptor_update_entry_count = descriptor_update_entries.len() as _;
        self.p_descriptor_update_entries = descriptor_update_entries.as_ptr();
        self
    }
    #[inline]
    pub fn template_type(mut self, template_type: DescriptorUpdateTemplateType) -> Self {
        self.template_type = template_type;
        self
    }
    #[inline]
    pub fn descriptor_set_layout(mut self, descriptor_set_layout: DescriptorSetLayout) -> Self {
        self.descriptor_set_layout = descriptor_set_layout;
        self
    }
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.pipeline_bind_point = pipeline_bind_point;
        self
    }
    #[inline]
    pub fn pipeline_layout(mut self, pipeline_layout: PipelineLayout) -> Self {
        self.pipeline_layout = pipeline_layout;
        self
    }
    #[inline]
    pub fn set(mut self, set: u32) -> Self {
        self.set = set;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkXYColorEXT.html>"]
#[must_use]
pub struct XYColorEXT {
    pub x: f32,
    pub y: f32,
}
impl XYColorEXT {
    #[inline]
    pub fn x(mut self, x: f32) -> Self {
        self.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: f32) -> Self {
        self.y = y;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevicePresentIdFeaturesKHR.html>"]
#[must_use]
pub struct PhysicalDevicePresentIdFeaturesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub present_id: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDevicePresentIdFeaturesKHR<'_> {}
unsafe impl Sync for PhysicalDevicePresentIdFeaturesKHR<'_> {}
impl ::core::default::Default for PhysicalDevicePresentIdFeaturesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            present_id: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDevicePresentIdFeaturesKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePresentIdFeaturesKHR<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePresentIdFeaturesKHR<'_> {}
impl<'a> PhysicalDevicePresentIdFeaturesKHR<'a> {
    #[inline]
    pub fn present_id(mut self, present_id: bool) -> Self {
        self.present_id = present_id.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPresentIdKHR.html>"]
#[must_use]
pub struct PresentIdKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain_count: u32,
    pub p_present_ids: *const u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PresentIdKHR<'_> {}
unsafe impl Sync for PresentIdKHR<'_> {}
impl ::core::default::Default for PresentIdKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            swapchain_count: u32::default(),
            p_present_ids: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PresentIdKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PRESENT_ID_KHR;
}
unsafe impl ExtendsPresentInfoKHR for PresentIdKHR<'_> {}
impl<'a> PresentIdKHR<'a> {
    #[inline]
    pub fn present_ids(mut self, present_ids: &'a [u64]) -> Self {
        self.swapchain_count = present_ids.len() as _;
        self.p_present_ids = present_ids.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevicePresentWaitFeaturesKHR.html>"]
#[must_use]
pub struct PhysicalDevicePresentWaitFeaturesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub present_wait: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDevicePresentWaitFeaturesKHR<'_> {}
unsafe impl Sync for PhysicalDevicePresentWaitFeaturesKHR<'_> {}
impl ::core::default::Default for PhysicalDevicePresentWaitFeaturesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            present_wait: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDevicePresentWaitFeaturesKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePresentWaitFeaturesKHR<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePresentWaitFeaturesKHR<'_> {}
impl<'a> PhysicalDevicePresentWaitFeaturesKHR<'a> {
    #[inline]
    pub fn present_wait(mut self, present_wait: bool) -> Self {
        self.present_wait = present_wait.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkHdrMetadataEXT.html>"]
#[must_use]
pub struct HdrMetadataEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub display_primary_red: XYColorEXT,
    pub display_primary_green: XYColorEXT,
    pub display_primary_blue: XYColorEXT,
    pub white_point: XYColorEXT,
    pub max_luminance: f32,
    pub min_luminance: f32,
    pub max_content_light_level: f32,
    pub max_frame_average_light_level: f32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for HdrMetadataEXT<'_> {}
unsafe impl Sync for HdrMetadataEXT<'_> {}
impl ::core::default::Default for HdrMetadataEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            display_primary_red: XYColorEXT::default(),
            display_primary_green: XYColorEXT::default(),
            display_primary_blue: XYColorEXT::default(),
            white_point: XYColorEXT::default(),
            max_luminance: f32::default(),
            min_luminance: f32::default(),
            max_content_light_level: f32::default(),
            max_frame_average_light_level: f32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for HdrMetadataEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::HDR_METADATA_EXT;
}
impl<'a> HdrMetadataEXT<'a> {
    #[inline]
    pub fn display_primary_red(mut self, display_primary_red: XYColorEXT) -> Self {
        self.display_primary_red = display_primary_red;
        self
    }
    #[inline]
    pub fn display_primary_green(mut self, display_primary_green: XYColorEXT) -> Self {
        self.display_primary_green = display_primary_green;
        self
    }
    #[inline]
    pub fn display_primary_blue(mut self, display_primary_blue: XYColorEXT) -> Self {
        self.display_primary_blue = display_primary_blue;
        self
    }
    #[inline]
    pub fn white_point(mut self, white_point: XYColorEXT) -> Self {
        self.white_point = white_point;
        self
    }
    #[inline]
    pub fn max_luminance(mut self, max_luminance: f32) -> Self {
        self.max_luminance = max_luminance;
        self
    }
    #[inline]
    pub fn min_luminance(mut self, min_luminance: f32) -> Self {
        self.min_luminance = min_luminance;
        self
    }
    #[inline]
    pub fn max_content_light_level(mut self, max_content_light_level: f32) -> Self {
        self.max_content_light_level = max_content_light_level;
        self
    }
    #[inline]
    pub fn max_frame_average_light_level(mut self, max_frame_average_light_level: f32) -> Self {
        self.max_frame_average_light_level = max_frame_average_light_level;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayNativeHdrSurfaceCapabilitiesAMD.html>"]
#[must_use]
pub struct DisplayNativeHdrSurfaceCapabilitiesAMD<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub local_dimming_support: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DisplayNativeHdrSurfaceCapabilitiesAMD<'_> {}
unsafe impl Sync for DisplayNativeHdrSurfaceCapabilitiesAMD<'_> {}
impl ::core::default::Default for DisplayNativeHdrSurfaceCapabilitiesAMD<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            local_dimming_support: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DisplayNativeHdrSurfaceCapabilitiesAMD<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD;
}
unsafe impl ExtendsSurfaceCapabilities2KHR for DisplayNativeHdrSurfaceCapabilitiesAMD<'_> {}
impl<'a> DisplayNativeHdrSurfaceCapabilitiesAMD<'a> {
    #[inline]
    pub fn local_dimming_support(mut self, local_dimming_support: bool) -> Self {
        self.local_dimming_support = local_dimming_support.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSwapchainDisplayNativeHdrCreateInfoAMD.html>"]
#[must_use]
pub struct SwapchainDisplayNativeHdrCreateInfoAMD<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub local_dimming_enable: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SwapchainDisplayNativeHdrCreateInfoAMD<'_> {}
unsafe impl Sync for SwapchainDisplayNativeHdrCreateInfoAMD<'_> {}
impl ::core::default::Default for SwapchainDisplayNativeHdrCreateInfoAMD<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            local_dimming_enable: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SwapchainDisplayNativeHdrCreateInfoAMD<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD;
}
unsafe impl ExtendsSwapchainCreateInfoKHR for SwapchainDisplayNativeHdrCreateInfoAMD<'_> {}
impl<'a> SwapchainDisplayNativeHdrCreateInfoAMD<'a> {
    #[inline]
    pub fn local_dimming_enable(mut self, local_dimming_enable: bool) -> Self {
        self.local_dimming_enable = local_dimming_enable.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRefreshCycleDurationGOOGLE.html>"]
#[must_use]
pub struct RefreshCycleDurationGOOGLE {
    pub refresh_duration: u64,
}
impl RefreshCycleDurationGOOGLE {
    #[inline]
    pub fn refresh_duration(mut self, refresh_duration: u64) -> Self {
        self.refresh_duration = refresh_duration;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPastPresentationTimingGOOGLE.html>"]
#[must_use]
pub struct PastPresentationTimingGOOGLE {
    pub present_id: u32,
    pub desired_present_time: u64,
    pub actual_present_time: u64,
    pub earliest_present_time: u64,
    pub present_margin: u64,
}
impl PastPresentationTimingGOOGLE {
    #[inline]
    pub fn present_id(mut self, present_id: u32) -> Self {
        self.present_id = present_id;
        self
    }
    #[inline]
    pub fn desired_present_time(mut self, desired_present_time: u64) -> Self {
        self.desired_present_time = desired_present_time;
        self
    }
    #[inline]
    pub fn actual_present_time(mut self, actual_present_time: u64) -> Self {
        self.actual_present_time = actual_present_time;
        self
    }
    #[inline]
    pub fn earliest_present_time(mut self, earliest_present_time: u64) -> Self {
        self.earliest_present_time = earliest_present_time;
        self
    }
    #[inline]
    pub fn present_margin(mut self, present_margin: u64) -> Self {
        self.present_margin = present_margin;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPresentTimesInfoGOOGLE.html>"]
#[must_use]
pub struct PresentTimesInfoGOOGLE<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain_count: u32,
    pub p_times: *const PresentTimeGOOGLE,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PresentTimesInfoGOOGLE<'_> {}
unsafe impl Sync for PresentTimesInfoGOOGLE<'_> {}
impl ::core::default::Default for PresentTimesInfoGOOGLE<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            swapchain_count: u32::default(),
            p_times: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PresentTimesInfoGOOGLE<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PRESENT_TIMES_INFO_GOOGLE;
}
unsafe impl ExtendsPresentInfoKHR for PresentTimesInfoGOOGLE<'_> {}
impl<'a> PresentTimesInfoGOOGLE<'a> {
    #[inline]
    pub fn times(mut self, times: &'a [PresentTimeGOOGLE]) -> Self {
        self.swapchain_count = times.len() as _;
        self.p_times = times.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPresentTimeGOOGLE.html>"]
#[must_use]
pub struct PresentTimeGOOGLE {
    pub present_id: u32,
    pub desired_present_time: u64,
}
impl PresentTimeGOOGLE {
    #[inline]
    pub fn present_id(mut self, present_id: u32) -> Self {
        self.present_id = present_id;
        self
    }
    #[inline]
    pub fn desired_present_time(mut self, desired_present_time: u64) -> Self {
        self.desired_present_time = desired_present_time;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkIOSSurfaceCreateInfoMVK.html>"]
#[must_use]
pub struct IOSSurfaceCreateInfoMVK<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: IOSSurfaceCreateFlagsMVK,
    pub p_view: *const c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for IOSSurfaceCreateInfoMVK<'_> {}
unsafe impl Sync for IOSSurfaceCreateInfoMVK<'_> {}
impl ::core::default::Default for IOSSurfaceCreateInfoMVK<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: IOSSurfaceCreateFlagsMVK::default(),
            p_view: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for IOSSurfaceCreateInfoMVK<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IOS_SURFACE_CREATE_INFO_MVK;
}
impl<'a> IOSSurfaceCreateInfoMVK<'a> {
    #[inline]
    pub fn flags(mut self, flags: IOSSurfaceCreateFlagsMVK) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn view(mut self, view: *const c_void) -> Self {
        self.p_view = view;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMacOSSurfaceCreateInfoMVK.html>"]
#[must_use]
pub struct MacOSSurfaceCreateInfoMVK<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: MacOSSurfaceCreateFlagsMVK,
    pub p_view: *const c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MacOSSurfaceCreateInfoMVK<'_> {}
unsafe impl Sync for MacOSSurfaceCreateInfoMVK<'_> {}
impl ::core::default::Default for MacOSSurfaceCreateInfoMVK<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: MacOSSurfaceCreateFlagsMVK::default(),
            p_view: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MacOSSurfaceCreateInfoMVK<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MACOS_SURFACE_CREATE_INFO_MVK;
}
impl<'a> MacOSSurfaceCreateInfoMVK<'a> {
    #[inline]
    pub fn flags(mut self, flags: MacOSSurfaceCreateFlagsMVK) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn view(mut self, view: *const c_void) -> Self {
        self.p_view = view;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMetalSurfaceCreateInfoEXT.html>"]
#[must_use]
pub struct MetalSurfaceCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: MetalSurfaceCreateFlagsEXT,
    pub p_layer: *const CAMetalLayer,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MetalSurfaceCreateInfoEXT<'_> {}
unsafe impl Sync for MetalSurfaceCreateInfoEXT<'_> {}
impl ::core::default::Default for MetalSurfaceCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: MetalSurfaceCreateFlagsEXT::default(),
            p_layer: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MetalSurfaceCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::METAL_SURFACE_CREATE_INFO_EXT;
}
impl<'a> MetalSurfaceCreateInfoEXT<'a> {
    #[inline]
    pub fn flags(mut self, flags: MetalSurfaceCreateFlagsEXT) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn layer(mut self, layer: *const CAMetalLayer) -> Self {
        self.p_layer = layer;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkViewportWScalingNV.html>"]
#[must_use]
pub struct ViewportWScalingNV {
    pub xcoeff: f32,
    pub ycoeff: f32,
}
impl ViewportWScalingNV {
    #[inline]
    pub fn xcoeff(mut self, xcoeff: f32) -> Self {
        self.xcoeff = xcoeff;
        self
    }
    #[inline]
    pub fn ycoeff(mut self, ycoeff: f32) -> Self {
        self.ycoeff = ycoeff;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportWScalingStateCreateInfoNV.html>"]
#[must_use]
pub struct PipelineViewportWScalingStateCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub viewport_w_scaling_enable: Bool32,
    pub viewport_count: u32,
    pub p_viewport_w_scalings: *const ViewportWScalingNV,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineViewportWScalingStateCreateInfoNV<'_> {}
unsafe impl Sync for PipelineViewportWScalingStateCreateInfoNV<'_> {}
impl ::core::default::Default for PipelineViewportWScalingStateCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            viewport_w_scaling_enable: Bool32::default(),
            viewport_count: u32::default(),
            p_viewport_w_scalings: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineViewportWScalingStateCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV;
}
unsafe impl ExtendsPipelineViewportStateCreateInfo
    for PipelineViewportWScalingStateCreateInfoNV<'_>
{
}
impl<'a> PipelineViewportWScalingStateCreateInfoNV<'a> {
    #[inline]
    pub fn viewport_w_scaling_enable(mut self, viewport_w_scaling_enable: bool) -> Self {
        self.viewport_w_scaling_enable = viewport_w_scaling_enable.into();
        self
    }
    #[inline]
    pub fn viewport_w_scalings(mut self, viewport_w_scalings: &'a [ViewportWScalingNV]) -> Self {
        self.viewport_count = viewport_w_scalings.len() as _;
        self.p_viewport_w_scalings = viewport_w_scalings.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkViewportSwizzleNV.html>"]
#[must_use]
pub struct ViewportSwizzleNV {
    pub x: ViewportCoordinateSwizzleNV,
    pub y: ViewportCoordinateSwizzleNV,
    pub z: ViewportCoordinateSwizzleNV,
    pub w: ViewportCoordinateSwizzleNV,
}
impl ViewportSwizzleNV {
    #[inline]
    pub fn x(mut self, x: ViewportCoordinateSwizzleNV) -> Self {
        self.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: ViewportCoordinateSwizzleNV) -> Self {
        self.y = y;
        self
    }
    #[inline]
    pub fn z(mut self, z: ViewportCoordinateSwizzleNV) -> Self {
        self.z = z;
        self
    }
    #[inline]
    pub fn w(mut self, w: ViewportCoordinateSwizzleNV) -> Self {
        self.w = w;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportSwizzleStateCreateInfoNV.html>"]
#[must_use]
pub struct PipelineViewportSwizzleStateCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineViewportSwizzleStateCreateFlagsNV,
    pub viewport_count: u32,
    pub p_viewport_swizzles: *const ViewportSwizzleNV,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineViewportSwizzleStateCreateInfoNV<'_> {}
unsafe impl Sync for PipelineViewportSwizzleStateCreateInfoNV<'_> {}
impl ::core::default::Default for PipelineViewportSwizzleStateCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineViewportSwizzleStateCreateFlagsNV::default(),
            viewport_count: u32::default(),
            p_viewport_swizzles: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineViewportSwizzleStateCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV;
}
unsafe impl ExtendsPipelineViewportStateCreateInfo
    for PipelineViewportSwizzleStateCreateInfoNV<'_>
{
}
impl<'a> PipelineViewportSwizzleStateCreateInfoNV<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineViewportSwizzleStateCreateFlagsNV) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn viewport_swizzles(mut self, viewport_swizzles: &'a [ViewportSwizzleNV]) -> Self {
        self.viewport_count = viewport_swizzles.len() as _;
        self.p_viewport_swizzles = viewport_swizzles.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDiscardRectanglePropertiesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceDiscardRectanglePropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_discard_rectangles: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceDiscardRectanglePropertiesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceDiscardRectanglePropertiesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceDiscardRectanglePropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_discard_rectangles: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceDiscardRectanglePropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDiscardRectanglePropertiesEXT<'_> {}
impl<'a> PhysicalDeviceDiscardRectanglePropertiesEXT<'a> {
    #[inline]
    pub fn max_discard_rectangles(mut self, max_discard_rectangles: u32) -> Self {
        self.max_discard_rectangles = max_discard_rectangles;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineDiscardRectangleStateCreateInfoEXT.html>"]
#[must_use]
pub struct PipelineDiscardRectangleStateCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineDiscardRectangleStateCreateFlagsEXT,
    pub discard_rectangle_mode: DiscardRectangleModeEXT,
    pub discard_rectangle_count: u32,
    pub p_discard_rectangles: *const Rect2D,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineDiscardRectangleStateCreateInfoEXT<'_> {}
unsafe impl Sync for PipelineDiscardRectangleStateCreateInfoEXT<'_> {}
impl ::core::default::Default for PipelineDiscardRectangleStateCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineDiscardRectangleStateCreateFlagsEXT::default(),
            discard_rectangle_mode: DiscardRectangleModeEXT::default(),
            discard_rectangle_count: u32::default(),
            p_discard_rectangles: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineDiscardRectangleStateCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT;
}
unsafe impl ExtendsGraphicsPipelineCreateInfo for PipelineDiscardRectangleStateCreateInfoEXT<'_> {}
impl<'a> PipelineDiscardRectangleStateCreateInfoEXT<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineDiscardRectangleStateCreateFlagsEXT) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn discard_rectangle_mode(
        mut self,
        discard_rectangle_mode: DiscardRectangleModeEXT,
    ) -> Self {
        self.discard_rectangle_mode = discard_rectangle_mode;
        self
    }
    #[inline]
    pub fn discard_rectangles(mut self, discard_rectangles: &'a [Rect2D]) -> Self {
        self.discard_rectangle_count = discard_rectangles.len() as _;
        self.p_discard_rectangles = discard_rectangles.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX.html>"]
#[must_use]
pub struct PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub per_view_position_all_components: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX<'_> {}
unsafe impl Sync for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX<'_> {}
impl ::core::default::Default for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            per_view_position_all_components: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX;
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX<'_>
{
}
impl<'a> PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX<'a> {
    #[inline]
    pub fn per_view_position_all_components(
        mut self,
        per_view_position_all_components: bool,
    ) -> Self {
        self.per_view_position_all_components = per_view_position_all_components.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkInputAttachmentAspectReference.html>"]
#[must_use]
pub struct InputAttachmentAspectReference {
    pub subpass: u32,
    pub input_attachment_index: u32,
    pub aspect_mask: ImageAspectFlags,
}
impl InputAttachmentAspectReference {
    #[inline]
    pub fn subpass(mut self, subpass: u32) -> Self {
        self.subpass = subpass;
        self
    }
    #[inline]
    pub fn input_attachment_index(mut self, input_attachment_index: u32) -> Self {
        self.input_attachment_index = input_attachment_index;
        self
    }
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.aspect_mask = aspect_mask;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRenderPassInputAttachmentAspectCreateInfo.html>"]
#[must_use]
pub struct RenderPassInputAttachmentAspectCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub aspect_reference_count: u32,
    pub p_aspect_references: *const InputAttachmentAspectReference,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for RenderPassInputAttachmentAspectCreateInfo<'_> {}
unsafe impl Sync for RenderPassInputAttachmentAspectCreateInfo<'_> {}
impl ::core::default::Default for RenderPassInputAttachmentAspectCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            aspect_reference_count: u32::default(),
            p_aspect_references: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for RenderPassInputAttachmentAspectCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO;
}
unsafe impl ExtendsRenderPassCreateInfo for RenderPassInputAttachmentAspectCreateInfo<'_> {}
impl<'a> RenderPassInputAttachmentAspectCreateInfo<'a> {
    #[inline]
    pub fn aspect_references(
        mut self,
        aspect_references: &'a [InputAttachmentAspectReference],
    ) -> Self {
        self.aspect_reference_count = aspect_references.len() as _;
        self.p_aspect_references = aspect_references.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSurfaceInfo2KHR.html>"]
#[must_use]
pub struct PhysicalDeviceSurfaceInfo2KHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub surface: SurfaceKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceSurfaceInfo2KHR<'_> {}
unsafe impl Sync for PhysicalDeviceSurfaceInfo2KHR<'_> {}
impl ::core::default::Default for PhysicalDeviceSurfaceInfo2KHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            surface: SurfaceKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceSurfaceInfo2KHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_SURFACE_INFO_2_KHR;
}
pub unsafe trait ExtendsPhysicalDeviceSurfaceInfo2KHR {}
impl<'a> PhysicalDeviceSurfaceInfo2KHR<'a> {
    #[inline]
    pub fn surface(mut self, surface: SurfaceKHR) -> Self {
        self.surface = surface;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceSurfaceInfo2KHR + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSurfaceCapabilities2KHR.html>"]
#[must_use]
pub struct SurfaceCapabilities2KHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub surface_capabilities: SurfaceCapabilitiesKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SurfaceCapabilities2KHR<'_> {}
unsafe impl Sync for SurfaceCapabilities2KHR<'_> {}
impl ::core::default::Default for SurfaceCapabilities2KHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            surface_capabilities: SurfaceCapabilitiesKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SurfaceCapabilities2KHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SURFACE_CAPABILITIES_2_KHR;
}
pub unsafe trait ExtendsSurfaceCapabilities2KHR {}
impl<'a> SurfaceCapabilities2KHR<'a> {
    #[inline]
    pub fn surface_capabilities(mut self, surface_capabilities: SurfaceCapabilitiesKHR) -> Self {
        self.surface_capabilities = surface_capabilities;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSurfaceCapabilities2KHR + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSurfaceFormat2KHR.html>"]
#[must_use]
pub struct SurfaceFormat2KHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub surface_format: SurfaceFormatKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SurfaceFormat2KHR<'_> {}
unsafe impl Sync for SurfaceFormat2KHR<'_> {}
impl ::core::default::Default for SurfaceFormat2KHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            surface_format: SurfaceFormatKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SurfaceFormat2KHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SURFACE_FORMAT_2_KHR;
}
pub unsafe trait ExtendsSurfaceFormat2KHR {}
impl<'a> SurfaceFormat2KHR<'a> {
    #[inline]
    pub fn surface_format(mut self, surface_format: SurfaceFormatKHR) -> Self {
        self.surface_format = surface_format;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSurfaceFormat2KHR + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayProperties2KHR.html>"]
#[must_use]
pub struct DisplayProperties2KHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub display_properties: DisplayPropertiesKHR<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DisplayProperties2KHR<'_> {}
unsafe impl Sync for DisplayProperties2KHR<'_> {}
impl ::core::default::Default for DisplayProperties2KHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            display_properties: DisplayPropertiesKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DisplayProperties2KHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_PROPERTIES_2_KHR;
}
impl<'a> DisplayProperties2KHR<'a> {
    #[inline]
    pub fn display_properties(mut self, display_properties: DisplayPropertiesKHR<'a>) -> Self {
        self.display_properties = display_properties;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayPlaneProperties2KHR.html>"]
#[must_use]
pub struct DisplayPlaneProperties2KHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub display_plane_properties: DisplayPlanePropertiesKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DisplayPlaneProperties2KHR<'_> {}
unsafe impl Sync for DisplayPlaneProperties2KHR<'_> {}
impl ::core::default::Default for DisplayPlaneProperties2KHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            display_plane_properties: DisplayPlanePropertiesKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DisplayPlaneProperties2KHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_PLANE_PROPERTIES_2_KHR;
}
impl<'a> DisplayPlaneProperties2KHR<'a> {
    #[inline]
    pub fn display_plane_properties(
        mut self,
        display_plane_properties: DisplayPlanePropertiesKHR,
    ) -> Self {
        self.display_plane_properties = display_plane_properties;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayModeProperties2KHR.html>"]
#[must_use]
pub struct DisplayModeProperties2KHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub display_mode_properties: DisplayModePropertiesKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DisplayModeProperties2KHR<'_> {}
unsafe impl Sync for DisplayModeProperties2KHR<'_> {}
impl ::core::default::Default for DisplayModeProperties2KHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            display_mode_properties: DisplayModePropertiesKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DisplayModeProperties2KHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_MODE_PROPERTIES_2_KHR;
}
impl<'a> DisplayModeProperties2KHR<'a> {
    #[inline]
    pub fn display_mode_properties(
        mut self,
        display_mode_properties: DisplayModePropertiesKHR,
    ) -> Self {
        self.display_mode_properties = display_mode_properties;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayPlaneInfo2KHR.html>"]
#[must_use]
pub struct DisplayPlaneInfo2KHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub mode: DisplayModeKHR,
    pub plane_index: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DisplayPlaneInfo2KHR<'_> {}
unsafe impl Sync for DisplayPlaneInfo2KHR<'_> {}
impl ::core::default::Default for DisplayPlaneInfo2KHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            mode: DisplayModeKHR::default(),
            plane_index: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DisplayPlaneInfo2KHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_PLANE_INFO_2_KHR;
}
impl<'a> DisplayPlaneInfo2KHR<'a> {
    #[inline]
    pub fn mode(mut self, mode: DisplayModeKHR) -> Self {
        self.mode = mode;
        self
    }
    #[inline]
    pub fn plane_index(mut self, plane_index: u32) -> Self {
        self.plane_index = plane_index;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDisplayPlaneCapabilities2KHR.html>"]
#[must_use]
pub struct DisplayPlaneCapabilities2KHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub capabilities: DisplayPlaneCapabilitiesKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DisplayPlaneCapabilities2KHR<'_> {}
unsafe impl Sync for DisplayPlaneCapabilities2KHR<'_> {}
impl ::core::default::Default for DisplayPlaneCapabilities2KHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            capabilities: DisplayPlaneCapabilitiesKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DisplayPlaneCapabilities2KHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_PLANE_CAPABILITIES_2_KHR;
}
impl<'a> DisplayPlaneCapabilities2KHR<'a> {
    #[inline]
    pub fn capabilities(mut self, capabilities: DisplayPlaneCapabilitiesKHR) -> Self {
        self.capabilities = capabilities;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSharedPresentSurfaceCapabilitiesKHR.html>"]
#[must_use]
pub struct SharedPresentSurfaceCapabilitiesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shared_present_supported_usage_flags: ImageUsageFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SharedPresentSurfaceCapabilitiesKHR<'_> {}
unsafe impl Sync for SharedPresentSurfaceCapabilitiesKHR<'_> {}
impl ::core::default::Default for SharedPresentSurfaceCapabilitiesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shared_present_supported_usage_flags: ImageUsageFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SharedPresentSurfaceCapabilitiesKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SHARED_PRESENT_SURFACE_CAPABILITIES_KHR;
}
unsafe impl ExtendsSurfaceCapabilities2KHR for SharedPresentSurfaceCapabilitiesKHR<'_> {}
impl<'a> SharedPresentSurfaceCapabilitiesKHR<'a> {
    #[inline]
    pub fn shared_present_supported_usage_flags(
        mut self,
        shared_present_supported_usage_flags: ImageUsageFlags,
    ) -> Self {
        self.shared_present_supported_usage_flags = shared_present_supported_usage_flags;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevice16BitStorageFeatures.html>"]
#[must_use]
pub struct PhysicalDevice16BitStorageFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub storage_buffer16_bit_access: Bool32,
    pub uniform_and_storage_buffer16_bit_access: Bool32,
    pub storage_push_constant16: Bool32,
    pub storage_input_output16: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDevice16BitStorageFeatures<'_> {}
unsafe impl Sync for PhysicalDevice16BitStorageFeatures<'_> {}
impl ::core::default::Default for PhysicalDevice16BitStorageFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            storage_buffer16_bit_access: Bool32::default(),
            uniform_and_storage_buffer16_bit_access: Bool32::default(),
            storage_push_constant16: Bool32::default(),
            storage_input_output16: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDevice16BitStorageFeatures<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevice16BitStorageFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevice16BitStorageFeatures<'_> {}
impl<'a> PhysicalDevice16BitStorageFeatures<'a> {
    #[inline]
    pub fn storage_buffer16_bit_access(mut self, storage_buffer16_bit_access: bool) -> Self {
        self.storage_buffer16_bit_access = storage_buffer16_bit_access.into();
        self
    }
    #[inline]
    pub fn uniform_and_storage_buffer16_bit_access(
        mut self,
        uniform_and_storage_buffer16_bit_access: bool,
    ) -> Self {
        self.uniform_and_storage_buffer16_bit_access =
            uniform_and_storage_buffer16_bit_access.into();
        self
    }
    #[inline]
    pub fn storage_push_constant16(mut self, storage_push_constant16: bool) -> Self {
        self.storage_push_constant16 = storage_push_constant16.into();
        self
    }
    #[inline]
    pub fn storage_input_output16(mut self, storage_input_output16: bool) -> Self {
        self.storage_input_output16 = storage_input_output16.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSubgroupProperties.html>"]
#[must_use]
pub struct PhysicalDeviceSubgroupProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub subgroup_size: u32,
    pub supported_stages: ShaderStageFlags,
    pub supported_operations: SubgroupFeatureFlags,
    pub quad_operations_in_all_stages: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceSubgroupProperties<'_> {}
unsafe impl Sync for PhysicalDeviceSubgroupProperties<'_> {}
impl ::core::default::Default for PhysicalDeviceSubgroupProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            subgroup_size: u32::default(),
            supported_stages: ShaderStageFlags::default(),
            supported_operations: SubgroupFeatureFlags::default(),
            quad_operations_in_all_stages: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceSubgroupProperties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_SUBGROUP_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceSubgroupProperties<'_> {}
impl<'a> PhysicalDeviceSubgroupProperties<'a> {
    #[inline]
    pub fn subgroup_size(mut self, subgroup_size: u32) -> Self {
        self.subgroup_size = subgroup_size;
        self
    }
    #[inline]
    pub fn supported_stages(mut self, supported_stages: ShaderStageFlags) -> Self {
        self.supported_stages = supported_stages;
        self
    }
    #[inline]
    pub fn supported_operations(mut self, supported_operations: SubgroupFeatureFlags) -> Self {
        self.supported_operations = supported_operations;
        self
    }
    #[inline]
    pub fn quad_operations_in_all_stages(mut self, quad_operations_in_all_stages: bool) -> Self {
        self.quad_operations_in_all_stages = quad_operations_in_all_stages.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures.html>"]
#[must_use]
pub struct PhysicalDeviceShaderSubgroupExtendedTypesFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_subgroup_extended_types: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceShaderSubgroupExtendedTypesFeatures<'_> {}
unsafe impl Sync for PhysicalDeviceShaderSubgroupExtendedTypesFeatures<'_> {}
impl ::core::default::Default for PhysicalDeviceShaderSubgroupExtendedTypesFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shader_subgroup_extended_types: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceShaderSubgroupExtendedTypesFeatures<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceShaderSubgroupExtendedTypesFeatures<'_>
{
}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderSubgroupExtendedTypesFeatures<'_> {}
impl<'a> PhysicalDeviceShaderSubgroupExtendedTypesFeatures<'a> {
    #[inline]
    pub fn shader_subgroup_extended_types(mut self, shader_subgroup_extended_types: bool) -> Self {
        self.shader_subgroup_extended_types = shader_subgroup_extended_types.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBufferMemoryRequirementsInfo2.html>"]
#[must_use]
pub struct BufferMemoryRequirementsInfo2<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub buffer: Buffer,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BufferMemoryRequirementsInfo2<'_> {}
unsafe impl Sync for BufferMemoryRequirementsInfo2<'_> {}
impl ::core::default::Default for BufferMemoryRequirementsInfo2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            buffer: Buffer::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BufferMemoryRequirementsInfo2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BUFFER_MEMORY_REQUIREMENTS_INFO_2;
}
impl<'a> BufferMemoryRequirementsInfo2<'a> {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.buffer = buffer;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceBufferMemoryRequirements.html>"]
#[must_use]
pub struct DeviceBufferMemoryRequirements<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_create_info: *const BufferCreateInfo<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceBufferMemoryRequirements<'_> {}
unsafe impl Sync for DeviceBufferMemoryRequirements<'_> {}
impl ::core::default::Default for DeviceBufferMemoryRequirements<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            p_create_info: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceBufferMemoryRequirements<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_BUFFER_MEMORY_REQUIREMENTS;
}
impl<'a> DeviceBufferMemoryRequirements<'a> {
    #[inline]
    pub fn create_info(mut self, create_info: &'a BufferCreateInfo<'a>) -> Self {
        self.p_create_info = create_info;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageMemoryRequirementsInfo2.html>"]
#[must_use]
pub struct ImageMemoryRequirementsInfo2<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub image: Image,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageMemoryRequirementsInfo2<'_> {}
unsafe impl Sync for ImageMemoryRequirementsInfo2<'_> {}
impl ::core::default::Default for ImageMemoryRequirementsInfo2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            image: Image::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageMemoryRequirementsInfo2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_MEMORY_REQUIREMENTS_INFO_2;
}
pub unsafe trait ExtendsImageMemoryRequirementsInfo2 {}
impl<'a> ImageMemoryRequirementsInfo2<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.image = image;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageMemoryRequirementsInfo2 + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageSparseMemoryRequirementsInfo2.html>"]
#[must_use]
pub struct ImageSparseMemoryRequirementsInfo2<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub image: Image,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageSparseMemoryRequirementsInfo2<'_> {}
unsafe impl Sync for ImageSparseMemoryRequirementsInfo2<'_> {}
impl ::core::default::Default for ImageSparseMemoryRequirementsInfo2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            image: Image::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageSparseMemoryRequirementsInfo2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2;
}
impl<'a> ImageSparseMemoryRequirementsInfo2<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.image = image;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceImageMemoryRequirements.html>"]
#[must_use]
pub struct DeviceImageMemoryRequirements<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_create_info: *const ImageCreateInfo<'a>,
    pub plane_aspect: ImageAspectFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceImageMemoryRequirements<'_> {}
unsafe impl Sync for DeviceImageMemoryRequirements<'_> {}
impl ::core::default::Default for DeviceImageMemoryRequirements<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            p_create_info: ::core::ptr::null(),
            plane_aspect: ImageAspectFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceImageMemoryRequirements<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_IMAGE_MEMORY_REQUIREMENTS;
}
impl<'a> DeviceImageMemoryRequirements<'a> {
    #[inline]
    pub fn create_info(mut self, create_info: &'a ImageCreateInfo<'a>) -> Self {
        self.p_create_info = create_info;
        self
    }
    #[inline]
    pub fn plane_aspect(mut self, plane_aspect: ImageAspectFlags) -> Self {
        self.plane_aspect = plane_aspect;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryRequirements2.html>"]
#[must_use]
pub struct MemoryRequirements2<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_requirements: MemoryRequirements,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryRequirements2<'_> {}
unsafe impl Sync for MemoryRequirements2<'_> {}
impl ::core::default::Default for MemoryRequirements2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            memory_requirements: MemoryRequirements::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryRequirements2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_REQUIREMENTS_2;
}
pub unsafe trait ExtendsMemoryRequirements2 {}
impl<'a> MemoryRequirements2<'a> {
    #[inline]
    pub fn memory_requirements(mut self, memory_requirements: MemoryRequirements) -> Self {
        self.memory_requirements = memory_requirements;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsMemoryRequirements2 + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSparseImageMemoryRequirements2.html>"]
#[must_use]
pub struct SparseImageMemoryRequirements2<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_requirements: SparseImageMemoryRequirements,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SparseImageMemoryRequirements2<'_> {}
unsafe impl Sync for SparseImageMemoryRequirements2<'_> {}
impl ::core::default::Default for SparseImageMemoryRequirements2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            memory_requirements: SparseImageMemoryRequirements::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SparseImageMemoryRequirements2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SPARSE_IMAGE_MEMORY_REQUIREMENTS_2;
}
impl<'a> SparseImageMemoryRequirements2<'a> {
    #[inline]
    pub fn memory_requirements(
        mut self,
        memory_requirements: SparseImageMemoryRequirements,
    ) -> Self {
        self.memory_requirements = memory_requirements;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevicePointClippingProperties.html>"]
#[must_use]
pub struct PhysicalDevicePointClippingProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub point_clipping_behavior: PointClippingBehavior,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDevicePointClippingProperties<'_> {}
unsafe impl Sync for PhysicalDevicePointClippingProperties<'_> {}
impl ::core::default::Default for PhysicalDevicePointClippingProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            point_clipping_behavior: PointClippingBehavior::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDevicePointClippingProperties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDevicePointClippingProperties<'_> {}
impl<'a> PhysicalDevicePointClippingProperties<'a> {
    #[inline]
    pub fn point_clipping_behavior(
        mut self,
        point_clipping_behavior: PointClippingBehavior,
    ) -> Self {
        self.point_clipping_behavior = point_clipping_behavior;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryDedicatedRequirements.html>"]
#[must_use]
pub struct MemoryDedicatedRequirements<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub prefers_dedicated_allocation: Bool32,
    pub requires_dedicated_allocation: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryDedicatedRequirements<'_> {}
unsafe impl Sync for MemoryDedicatedRequirements<'_> {}
impl ::core::default::Default for MemoryDedicatedRequirements<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            prefers_dedicated_allocation: Bool32::default(),
            requires_dedicated_allocation: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryDedicatedRequirements<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_DEDICATED_REQUIREMENTS;
}
unsafe impl ExtendsMemoryRequirements2 for MemoryDedicatedRequirements<'_> {}
impl<'a> MemoryDedicatedRequirements<'a> {
    #[inline]
    pub fn prefers_dedicated_allocation(mut self, prefers_dedicated_allocation: bool) -> Self {
        self.prefers_dedicated_allocation = prefers_dedicated_allocation.into();
        self
    }
    #[inline]
    pub fn requires_dedicated_allocation(mut self, requires_dedicated_allocation: bool) -> Self {
        self.requires_dedicated_allocation = requires_dedicated_allocation.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryDedicatedAllocateInfo.html>"]
#[must_use]
pub struct MemoryDedicatedAllocateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub image: Image,
    pub buffer: Buffer,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryDedicatedAllocateInfo<'_> {}
unsafe impl Sync for MemoryDedicatedAllocateInfo<'_> {}
impl ::core::default::Default for MemoryDedicatedAllocateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            image: Image::default(),
            buffer: Buffer::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryDedicatedAllocateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_DEDICATED_ALLOCATE_INFO;
}
unsafe impl ExtendsMemoryAllocateInfo for MemoryDedicatedAllocateInfo<'_> {}
impl<'a> MemoryDedicatedAllocateInfo<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.image = image;
        self
    }
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.buffer = buffer;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageViewUsageCreateInfo.html>"]
#[must_use]
pub struct ImageViewUsageCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub usage: ImageUsageFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageViewUsageCreateInfo<'_> {}
unsafe impl Sync for ImageViewUsageCreateInfo<'_> {}
impl ::core::default::Default for ImageViewUsageCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            usage: ImageUsageFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageViewUsageCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_VIEW_USAGE_CREATE_INFO;
}
unsafe impl ExtendsImageViewCreateInfo for ImageViewUsageCreateInfo<'_> {}
impl<'a> ImageViewUsageCreateInfo<'a> {
    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.usage = usage;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageViewSlicedCreateInfoEXT.html>"]
#[must_use]
pub struct ImageViewSlicedCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub slice_offset: u32,
    pub slice_count: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageViewSlicedCreateInfoEXT<'_> {}
unsafe impl Sync for ImageViewSlicedCreateInfoEXT<'_> {}
impl ::core::default::Default for ImageViewSlicedCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            slice_offset: u32::default(),
            slice_count: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageViewSlicedCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_VIEW_SLICED_CREATE_INFO_EXT;
}
unsafe impl ExtendsImageViewCreateInfo for ImageViewSlicedCreateInfoEXT<'_> {}
impl<'a> ImageViewSlicedCreateInfoEXT<'a> {
    #[inline]
    pub fn slice_offset(mut self, slice_offset: u32) -> Self {
        self.slice_offset = slice_offset;
        self
    }
    #[inline]
    pub fn slice_count(mut self, slice_count: u32) -> Self {
        self.slice_count = slice_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineTessellationDomainOriginStateCreateInfo.html>"]
#[must_use]
pub struct PipelineTessellationDomainOriginStateCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub domain_origin: TessellationDomainOrigin,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineTessellationDomainOriginStateCreateInfo<'_> {}
unsafe impl Sync for PipelineTessellationDomainOriginStateCreateInfo<'_> {}
impl ::core::default::Default for PipelineTessellationDomainOriginStateCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            domain_origin: TessellationDomainOrigin::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineTessellationDomainOriginStateCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO;
}
unsafe impl ExtendsPipelineTessellationStateCreateInfo
    for PipelineTessellationDomainOriginStateCreateInfo<'_>
{
}
impl<'a> PipelineTessellationDomainOriginStateCreateInfo<'a> {
    #[inline]
    pub fn domain_origin(mut self, domain_origin: TessellationDomainOrigin) -> Self {
        self.domain_origin = domain_origin;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSamplerYcbcrConversionInfo.html>"]
#[must_use]
pub struct SamplerYcbcrConversionInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub conversion: SamplerYcbcrConversion,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SamplerYcbcrConversionInfo<'_> {}
unsafe impl Sync for SamplerYcbcrConversionInfo<'_> {}
impl ::core::default::Default for SamplerYcbcrConversionInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            conversion: SamplerYcbcrConversion::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SamplerYcbcrConversionInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SAMPLER_YCBCR_CONVERSION_INFO;
}
unsafe impl ExtendsSamplerCreateInfo for SamplerYcbcrConversionInfo<'_> {}
unsafe impl ExtendsImageViewCreateInfo for SamplerYcbcrConversionInfo<'_> {}
impl<'a> SamplerYcbcrConversionInfo<'a> {
    #[inline]
    pub fn conversion(mut self, conversion: SamplerYcbcrConversion) -> Self {
        self.conversion = conversion;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSamplerYcbcrConversionCreateInfo.html>"]
#[must_use]
pub struct SamplerYcbcrConversionCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub format: Format,
    pub ycbcr_model: SamplerYcbcrModelConversion,
    pub ycbcr_range: SamplerYcbcrRange,
    pub components: ComponentMapping,
    pub x_chroma_offset: ChromaLocation,
    pub y_chroma_offset: ChromaLocation,
    pub chroma_filter: Filter,
    pub force_explicit_reconstruction: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SamplerYcbcrConversionCreateInfo<'_> {}
unsafe impl Sync for SamplerYcbcrConversionCreateInfo<'_> {}
impl ::core::default::Default for SamplerYcbcrConversionCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            format: Format::default(),
            ycbcr_model: SamplerYcbcrModelConversion::default(),
            ycbcr_range: SamplerYcbcrRange::default(),
            components: ComponentMapping::default(),
            x_chroma_offset: ChromaLocation::default(),
            y_chroma_offset: ChromaLocation::default(),
            chroma_filter: Filter::default(),
            force_explicit_reconstruction: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SamplerYcbcrConversionCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SAMPLER_YCBCR_CONVERSION_CREATE_INFO;
}
pub unsafe trait ExtendsSamplerYcbcrConversionCreateInfo {}
impl<'a> SamplerYcbcrConversionCreateInfo<'a> {
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.format = format;
        self
    }
    #[inline]
    pub fn ycbcr_model(mut self, ycbcr_model: SamplerYcbcrModelConversion) -> Self {
        self.ycbcr_model = ycbcr_model;
        self
    }
    #[inline]
    pub fn ycbcr_range(mut self, ycbcr_range: SamplerYcbcrRange) -> Self {
        self.ycbcr_range = ycbcr_range;
        self
    }
    #[inline]
    pub fn components(mut self, components: ComponentMapping) -> Self {
        self.components = components;
        self
    }
    #[inline]
    pub fn x_chroma_offset(mut self, x_chroma_offset: ChromaLocation) -> Self {
        self.x_chroma_offset = x_chroma_offset;
        self
    }
    #[inline]
    pub fn y_chroma_offset(mut self, y_chroma_offset: ChromaLocation) -> Self {
        self.y_chroma_offset = y_chroma_offset;
        self
    }
    #[inline]
    pub fn chroma_filter(mut self, chroma_filter: Filter) -> Self {
        self.chroma_filter = chroma_filter;
        self
    }
    #[inline]
    pub fn force_explicit_reconstruction(mut self, force_explicit_reconstruction: bool) -> Self {
        self.force_explicit_reconstruction = force_explicit_reconstruction.into();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSamplerYcbcrConversionCreateInfo + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBindImagePlaneMemoryInfo.html>"]
#[must_use]
pub struct BindImagePlaneMemoryInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub plane_aspect: ImageAspectFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BindImagePlaneMemoryInfo<'_> {}
unsafe impl Sync for BindImagePlaneMemoryInfo<'_> {}
impl ::core::default::Default for BindImagePlaneMemoryInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            plane_aspect: ImageAspectFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BindImagePlaneMemoryInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_IMAGE_PLANE_MEMORY_INFO;
}
unsafe impl ExtendsBindImageMemoryInfo for BindImagePlaneMemoryInfo<'_> {}
impl<'a> BindImagePlaneMemoryInfo<'a> {
    #[inline]
    pub fn plane_aspect(mut self, plane_aspect: ImageAspectFlags) -> Self {
        self.plane_aspect = plane_aspect;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImagePlaneMemoryRequirementsInfo.html>"]
#[must_use]
pub struct ImagePlaneMemoryRequirementsInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub plane_aspect: ImageAspectFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImagePlaneMemoryRequirementsInfo<'_> {}
unsafe impl Sync for ImagePlaneMemoryRequirementsInfo<'_> {}
impl ::core::default::Default for ImagePlaneMemoryRequirementsInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            plane_aspect: ImageAspectFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImagePlaneMemoryRequirementsInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO;
}
unsafe impl ExtendsImageMemoryRequirementsInfo2 for ImagePlaneMemoryRequirementsInfo<'_> {}
impl<'a> ImagePlaneMemoryRequirementsInfo<'a> {
    #[inline]
    pub fn plane_aspect(mut self, plane_aspect: ImageAspectFlags) -> Self {
        self.plane_aspect = plane_aspect;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSamplerYcbcrConversionFeatures.html>"]
#[must_use]
pub struct PhysicalDeviceSamplerYcbcrConversionFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub sampler_ycbcr_conversion: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceSamplerYcbcrConversionFeatures<'_> {}
unsafe impl Sync for PhysicalDeviceSamplerYcbcrConversionFeatures<'_> {}
impl ::core::default::Default for PhysicalDeviceSamplerYcbcrConversionFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            sampler_ycbcr_conversion: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceSamplerYcbcrConversionFeatures<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceSamplerYcbcrConversionFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceSamplerYcbcrConversionFeatures<'_> {}
impl<'a> PhysicalDeviceSamplerYcbcrConversionFeatures<'a> {
    #[inline]
    pub fn sampler_ycbcr_conversion(mut self, sampler_ycbcr_conversion: bool) -> Self {
        self.sampler_ycbcr_conversion = sampler_ycbcr_conversion.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSamplerYcbcrConversionImageFormatProperties.html>"]
#[must_use]
pub struct SamplerYcbcrConversionImageFormatProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub combined_image_sampler_descriptor_count: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SamplerYcbcrConversionImageFormatProperties<'_> {}
unsafe impl Sync for SamplerYcbcrConversionImageFormatProperties<'_> {}
impl ::core::default::Default for SamplerYcbcrConversionImageFormatProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            combined_image_sampler_descriptor_count: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SamplerYcbcrConversionImageFormatProperties<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES;
}
unsafe impl ExtendsImageFormatProperties2 for SamplerYcbcrConversionImageFormatProperties<'_> {}
impl<'a> SamplerYcbcrConversionImageFormatProperties<'a> {
    #[inline]
    pub fn combined_image_sampler_descriptor_count(
        mut self,
        combined_image_sampler_descriptor_count: u32,
    ) -> Self {
        self.combined_image_sampler_descriptor_count = combined_image_sampler_descriptor_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkTextureLODGatherFormatPropertiesAMD.html>"]
#[must_use]
pub struct TextureLODGatherFormatPropertiesAMD<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub supports_texture_gather_lod_bias_amd: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for TextureLODGatherFormatPropertiesAMD<'_> {}
unsafe impl Sync for TextureLODGatherFormatPropertiesAMD<'_> {}
impl ::core::default::Default for TextureLODGatherFormatPropertiesAMD<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            supports_texture_gather_lod_bias_amd: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for TextureLODGatherFormatPropertiesAMD<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD;
}
unsafe impl ExtendsImageFormatProperties2 for TextureLODGatherFormatPropertiesAMD<'_> {}
impl<'a> TextureLODGatherFormatPropertiesAMD<'a> {
    #[inline]
    pub fn supports_texture_gather_lod_bias_amd(
        mut self,
        supports_texture_gather_lod_bias_amd: bool,
    ) -> Self {
        self.supports_texture_gather_lod_bias_amd = supports_texture_gather_lod_bias_amd.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkConditionalRenderingBeginInfoEXT.html>"]
#[must_use]
pub struct ConditionalRenderingBeginInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub flags: ConditionalRenderingFlagsEXT,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ConditionalRenderingBeginInfoEXT<'_> {}
unsafe impl Sync for ConditionalRenderingBeginInfoEXT<'_> {}
impl ::core::default::Default for ConditionalRenderingBeginInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            buffer: Buffer::default(),
            offset: DeviceSize::default(),
            flags: ConditionalRenderingFlagsEXT::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ConditionalRenderingBeginInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::CONDITIONAL_RENDERING_BEGIN_INFO_EXT;
}
impl<'a> ConditionalRenderingBeginInfoEXT<'a> {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.buffer = buffer;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.offset = offset;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: ConditionalRenderingFlagsEXT) -> Self {
        self.flags = flags;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkProtectedSubmitInfo.html>"]
#[must_use]
pub struct ProtectedSubmitInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub protected_submit: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ProtectedSubmitInfo<'_> {}
unsafe impl Sync for ProtectedSubmitInfo<'_> {}
impl ::core::default::Default for ProtectedSubmitInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            protected_submit: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ProtectedSubmitInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PROTECTED_SUBMIT_INFO;
}
unsafe impl ExtendsSubmitInfo for ProtectedSubmitInfo<'_> {}
impl<'a> ProtectedSubmitInfo<'a> {
    #[inline]
    pub fn protected_submit(mut self, protected_submit: bool) -> Self {
        self.protected_submit = protected_submit.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceProtectedMemoryFeatures.html>"]
#[must_use]
pub struct PhysicalDeviceProtectedMemoryFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub protected_memory: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceProtectedMemoryFeatures<'_> {}
unsafe impl Sync for PhysicalDeviceProtectedMemoryFeatures<'_> {}
impl ::core::default::Default for PhysicalDeviceProtectedMemoryFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            protected_memory: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceProtectedMemoryFeatures<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceProtectedMemoryFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceProtectedMemoryFeatures<'_> {}
impl<'a> PhysicalDeviceProtectedMemoryFeatures<'a> {
    #[inline]
    pub fn protected_memory(mut self, protected_memory: bool) -> Self {
        self.protected_memory = protected_memory.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceProtectedMemoryProperties.html>"]
#[must_use]
pub struct PhysicalDeviceProtectedMemoryProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub protected_no_fault: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceProtectedMemoryProperties<'_> {}
unsafe impl Sync for PhysicalDeviceProtectedMemoryProperties<'_> {}
impl ::core::default::Default for PhysicalDeviceProtectedMemoryProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            protected_no_fault: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceProtectedMemoryProperties<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceProtectedMemoryProperties<'_> {}
impl<'a> PhysicalDeviceProtectedMemoryProperties<'a> {
    #[inline]
    pub fn protected_no_fault(mut self, protected_no_fault: bool) -> Self {
        self.protected_no_fault = protected_no_fault.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceQueueInfo2.html>"]
#[must_use]
pub struct DeviceQueueInfo2<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DeviceQueueCreateFlags,
    pub queue_family_index: u32,
    pub queue_index: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceQueueInfo2<'_> {}
unsafe impl Sync for DeviceQueueInfo2<'_> {}
impl ::core::default::Default for DeviceQueueInfo2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DeviceQueueCreateFlags::default(),
            queue_family_index: u32::default(),
            queue_index: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceQueueInfo2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_QUEUE_INFO_2;
}
impl<'a> DeviceQueueInfo2<'a> {
    #[inline]
    pub fn flags(mut self, flags: DeviceQueueCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn queue_family_index(mut self, queue_family_index: u32) -> Self {
        self.queue_family_index = queue_family_index;
        self
    }
    #[inline]
    pub fn queue_index(mut self, queue_index: u32) -> Self {
        self.queue_index = queue_index;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineCoverageToColorStateCreateInfoNV.html>"]
#[must_use]
pub struct PipelineCoverageToColorStateCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCoverageToColorStateCreateFlagsNV,
    pub coverage_to_color_enable: Bool32,
    pub coverage_to_color_location: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineCoverageToColorStateCreateInfoNV<'_> {}
unsafe impl Sync for PipelineCoverageToColorStateCreateInfoNV<'_> {}
impl ::core::default::Default for PipelineCoverageToColorStateCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineCoverageToColorStateCreateFlagsNV::default(),
            coverage_to_color_enable: Bool32::default(),
            coverage_to_color_location: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineCoverageToColorStateCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV;
}
unsafe impl ExtendsPipelineMultisampleStateCreateInfo
    for PipelineCoverageToColorStateCreateInfoNV<'_>
{
}
impl<'a> PipelineCoverageToColorStateCreateInfoNV<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCoverageToColorStateCreateFlagsNV) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn coverage_to_color_enable(mut self, coverage_to_color_enable: bool) -> Self {
        self.coverage_to_color_enable = coverage_to_color_enable.into();
        self
    }
    #[inline]
    pub fn coverage_to_color_location(mut self, coverage_to_color_location: u32) -> Self {
        self.coverage_to_color_location = coverage_to_color_location;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSamplerFilterMinmaxProperties.html>"]
#[must_use]
pub struct PhysicalDeviceSamplerFilterMinmaxProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub filter_minmax_single_component_formats: Bool32,
    pub filter_minmax_image_component_mapping: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceSamplerFilterMinmaxProperties<'_> {}
unsafe impl Sync for PhysicalDeviceSamplerFilterMinmaxProperties<'_> {}
impl ::core::default::Default for PhysicalDeviceSamplerFilterMinmaxProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            filter_minmax_single_component_formats: Bool32::default(),
            filter_minmax_image_component_mapping: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceSamplerFilterMinmaxProperties<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceSamplerFilterMinmaxProperties<'_> {}
impl<'a> PhysicalDeviceSamplerFilterMinmaxProperties<'a> {
    #[inline]
    pub fn filter_minmax_single_component_formats(
        mut self,
        filter_minmax_single_component_formats: bool,
    ) -> Self {
        self.filter_minmax_single_component_formats = filter_minmax_single_component_formats.into();
        self
    }
    #[inline]
    pub fn filter_minmax_image_component_mapping(
        mut self,
        filter_minmax_image_component_mapping: bool,
    ) -> Self {
        self.filter_minmax_image_component_mapping = filter_minmax_image_component_mapping.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSampleLocationEXT.html>"]
#[must_use]
pub struct SampleLocationEXT {
    pub x: f32,
    pub y: f32,
}
impl SampleLocationEXT {
    #[inline]
    pub fn x(mut self, x: f32) -> Self {
        self.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: f32) -> Self {
        self.y = y;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSampleLocationsInfoEXT.html>"]
#[must_use]
pub struct SampleLocationsInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub sample_locations_per_pixel: SampleCountFlags,
    pub sample_location_grid_size: Extent2D,
    pub sample_locations_count: u32,
    pub p_sample_locations: *const SampleLocationEXT,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SampleLocationsInfoEXT<'_> {}
unsafe impl Sync for SampleLocationsInfoEXT<'_> {}
impl ::core::default::Default for SampleLocationsInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            sample_locations_per_pixel: SampleCountFlags::default(),
            sample_location_grid_size: Extent2D::default(),
            sample_locations_count: u32::default(),
            p_sample_locations: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SampleLocationsInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SAMPLE_LOCATIONS_INFO_EXT;
}
unsafe impl ExtendsImageMemoryBarrier for SampleLocationsInfoEXT<'_> {}
unsafe impl ExtendsImageMemoryBarrier2 for SampleLocationsInfoEXT<'_> {}
impl<'a> SampleLocationsInfoEXT<'a> {
    #[inline]
    pub fn sample_locations_per_pixel(
        mut self,
        sample_locations_per_pixel: SampleCountFlags,
    ) -> Self {
        self.sample_locations_per_pixel = sample_locations_per_pixel;
        self
    }
    #[inline]
    pub fn sample_location_grid_size(mut self, sample_location_grid_size: Extent2D) -> Self {
        self.sample_location_grid_size = sample_location_grid_size;
        self
    }
    #[inline]
    pub fn sample_locations(mut self, sample_locations: &'a [SampleLocationEXT]) -> Self {
        self.sample_locations_count = sample_locations.len() as _;
        self.p_sample_locations = sample_locations.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAttachmentSampleLocationsEXT.html>"]
#[must_use]
pub struct AttachmentSampleLocationsEXT<'a> {
    pub attachment_index: u32,
    pub sample_locations_info: SampleLocationsInfoEXT<'a>,
    pub _marker: PhantomData<&'a ()>,
}
impl<'a> AttachmentSampleLocationsEXT<'a> {
    #[inline]
    pub fn attachment_index(mut self, attachment_index: u32) -> Self {
        self.attachment_index = attachment_index;
        self
    }
    #[inline]
    pub fn sample_locations_info(
        mut self,
        sample_locations_info: SampleLocationsInfoEXT<'a>,
    ) -> Self {
        self.sample_locations_info = sample_locations_info;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSubpassSampleLocationsEXT.html>"]
#[must_use]
pub struct SubpassSampleLocationsEXT<'a> {
    pub subpass_index: u32,
    pub sample_locations_info: SampleLocationsInfoEXT<'a>,
    pub _marker: PhantomData<&'a ()>,
}
impl<'a> SubpassSampleLocationsEXT<'a> {
    #[inline]
    pub fn subpass_index(mut self, subpass_index: u32) -> Self {
        self.subpass_index = subpass_index;
        self
    }
    #[inline]
    pub fn sample_locations_info(
        mut self,
        sample_locations_info: SampleLocationsInfoEXT<'a>,
    ) -> Self {
        self.sample_locations_info = sample_locations_info;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRenderPassSampleLocationsBeginInfoEXT.html>"]
#[must_use]
pub struct RenderPassSampleLocationsBeginInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub attachment_initial_sample_locations_count: u32,
    pub p_attachment_initial_sample_locations: *const AttachmentSampleLocationsEXT<'a>,
    pub post_subpass_sample_locations_count: u32,
    pub p_post_subpass_sample_locations: *const SubpassSampleLocationsEXT<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for RenderPassSampleLocationsBeginInfoEXT<'_> {}
unsafe impl Sync for RenderPassSampleLocationsBeginInfoEXT<'_> {}
impl ::core::default::Default for RenderPassSampleLocationsBeginInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            attachment_initial_sample_locations_count: u32::default(),
            p_attachment_initial_sample_locations: ::core::ptr::null(),
            post_subpass_sample_locations_count: u32::default(),
            p_post_subpass_sample_locations: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for RenderPassSampleLocationsBeginInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT;
}
unsafe impl ExtendsRenderPassBeginInfo for RenderPassSampleLocationsBeginInfoEXT<'_> {}
impl<'a> RenderPassSampleLocationsBeginInfoEXT<'a> {
    #[inline]
    pub fn attachment_initial_sample_locations(
        mut self,
        attachment_initial_sample_locations: &'a [AttachmentSampleLocationsEXT<'a>],
    ) -> Self {
        self.attachment_initial_sample_locations_count =
            attachment_initial_sample_locations.len() as _;
        self.p_attachment_initial_sample_locations = attachment_initial_sample_locations.as_ptr();
        self
    }
    #[inline]
    pub fn post_subpass_sample_locations(
        mut self,
        post_subpass_sample_locations: &'a [SubpassSampleLocationsEXT<'a>],
    ) -> Self {
        self.post_subpass_sample_locations_count = post_subpass_sample_locations.len() as _;
        self.p_post_subpass_sample_locations = post_subpass_sample_locations.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineSampleLocationsStateCreateInfoEXT.html>"]
#[must_use]
pub struct PipelineSampleLocationsStateCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub sample_locations_enable: Bool32,
    pub sample_locations_info: SampleLocationsInfoEXT<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineSampleLocationsStateCreateInfoEXT<'_> {}
unsafe impl Sync for PipelineSampleLocationsStateCreateInfoEXT<'_> {}
impl ::core::default::Default for PipelineSampleLocationsStateCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            sample_locations_enable: Bool32::default(),
            sample_locations_info: SampleLocationsInfoEXT::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineSampleLocationsStateCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT;
}
unsafe impl ExtendsPipelineMultisampleStateCreateInfo
    for PipelineSampleLocationsStateCreateInfoEXT<'_>
{
}
impl<'a> PipelineSampleLocationsStateCreateInfoEXT<'a> {
    #[inline]
    pub fn sample_locations_enable(mut self, sample_locations_enable: bool) -> Self {
        self.sample_locations_enable = sample_locations_enable.into();
        self
    }
    #[inline]
    pub fn sample_locations_info(
        mut self,
        sample_locations_info: SampleLocationsInfoEXT<'a>,
    ) -> Self {
        self.sample_locations_info = sample_locations_info;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSampleLocationsPropertiesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceSampleLocationsPropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub sample_location_sample_counts: SampleCountFlags,
    pub max_sample_location_grid_size: Extent2D,
    pub sample_location_coordinate_range: [f32; 2],
    pub sample_location_sub_pixel_bits: u32,
    pub variable_sample_locations: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceSampleLocationsPropertiesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceSampleLocationsPropertiesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceSampleLocationsPropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            sample_location_sample_counts: SampleCountFlags::default(),
            max_sample_location_grid_size: Extent2D::default(),
            sample_location_coordinate_range: unsafe { ::core::mem::zeroed() },
            sample_location_sub_pixel_bits: u32::default(),
            variable_sample_locations: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceSampleLocationsPropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceSampleLocationsPropertiesEXT<'_> {}
impl<'a> PhysicalDeviceSampleLocationsPropertiesEXT<'a> {
    #[inline]
    pub fn sample_location_sample_counts(
        mut self,
        sample_location_sample_counts: SampleCountFlags,
    ) -> Self {
        self.sample_location_sample_counts = sample_location_sample_counts;
        self
    }
    #[inline]
    pub fn max_sample_location_grid_size(
        mut self,
        max_sample_location_grid_size: Extent2D,
    ) -> Self {
        self.max_sample_location_grid_size = max_sample_location_grid_size;
        self
    }
    #[inline]
    pub fn sample_location_coordinate_range(
        mut self,
        sample_location_coordinate_range: [f32; 2],
    ) -> Self {
        self.sample_location_coordinate_range = sample_location_coordinate_range;
        self
    }
    #[inline]
    pub fn sample_location_sub_pixel_bits(mut self, sample_location_sub_pixel_bits: u32) -> Self {
        self.sample_location_sub_pixel_bits = sample_location_sub_pixel_bits;
        self
    }
    #[inline]
    pub fn variable_sample_locations(mut self, variable_sample_locations: bool) -> Self {
        self.variable_sample_locations = variable_sample_locations.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMultisamplePropertiesEXT.html>"]
#[must_use]
pub struct MultisamplePropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_sample_location_grid_size: Extent2D,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MultisamplePropertiesEXT<'_> {}
unsafe impl Sync for MultisamplePropertiesEXT<'_> {}
impl ::core::default::Default for MultisamplePropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_sample_location_grid_size: Extent2D::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MultisamplePropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MULTISAMPLE_PROPERTIES_EXT;
}
impl<'a> MultisamplePropertiesEXT<'a> {
    #[inline]
    pub fn max_sample_location_grid_size(
        mut self,
        max_sample_location_grid_size: Extent2D,
    ) -> Self {
        self.max_sample_location_grid_size = max_sample_location_grid_size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSamplerReductionModeCreateInfo.html>"]
#[must_use]
pub struct SamplerReductionModeCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub reduction_mode: SamplerReductionMode,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SamplerReductionModeCreateInfo<'_> {}
unsafe impl Sync for SamplerReductionModeCreateInfo<'_> {}
impl ::core::default::Default for SamplerReductionModeCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            reduction_mode: SamplerReductionMode::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SamplerReductionModeCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SAMPLER_REDUCTION_MODE_CREATE_INFO;
}
unsafe impl ExtendsSamplerCreateInfo for SamplerReductionModeCreateInfo<'_> {}
impl<'a> SamplerReductionModeCreateInfo<'a> {
    #[inline]
    pub fn reduction_mode(mut self, reduction_mode: SamplerReductionMode) -> Self {
        self.reduction_mode = reduction_mode;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceBlendOperationAdvancedFeaturesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub advanced_blend_coherent_operations: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceBlendOperationAdvancedFeaturesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceBlendOperationAdvancedFeaturesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceBlendOperationAdvancedFeaturesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            advanced_blend_coherent_operations: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceBlendOperationAdvancedFeaturesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceBlendOperationAdvancedFeaturesEXT<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceBlendOperationAdvancedFeaturesEXT<'_> {}
impl<'a> PhysicalDeviceBlendOperationAdvancedFeaturesEXT<'a> {
    #[inline]
    pub fn advanced_blend_coherent_operations(
        mut self,
        advanced_blend_coherent_operations: bool,
    ) -> Self {
        self.advanced_blend_coherent_operations = advanced_blend_coherent_operations.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMultiDrawFeaturesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceMultiDrawFeaturesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub multi_draw: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMultiDrawFeaturesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceMultiDrawFeaturesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceMultiDrawFeaturesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            multi_draw: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMultiDrawFeaturesEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMultiDrawFeaturesEXT<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMultiDrawFeaturesEXT<'_> {}
impl<'a> PhysicalDeviceMultiDrawFeaturesEXT<'a> {
    #[inline]
    pub fn multi_draw(mut self, multi_draw: bool) -> Self {
        self.multi_draw = multi_draw.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceBlendOperationAdvancedPropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub advanced_blend_max_color_attachments: u32,
    pub advanced_blend_independent_blend: Bool32,
    pub advanced_blend_non_premultiplied_src_color: Bool32,
    pub advanced_blend_non_premultiplied_dst_color: Bool32,
    pub advanced_blend_correlated_overlap: Bool32,
    pub advanced_blend_all_operations: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceBlendOperationAdvancedPropertiesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceBlendOperationAdvancedPropertiesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceBlendOperationAdvancedPropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            advanced_blend_max_color_attachments: u32::default(),
            advanced_blend_independent_blend: Bool32::default(),
            advanced_blend_non_premultiplied_src_color: Bool32::default(),
            advanced_blend_non_premultiplied_dst_color: Bool32::default(),
            advanced_blend_correlated_overlap: Bool32::default(),
            advanced_blend_all_operations: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceBlendOperationAdvancedPropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT;
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceBlendOperationAdvancedPropertiesEXT<'_>
{
}
impl<'a> PhysicalDeviceBlendOperationAdvancedPropertiesEXT<'a> {
    #[inline]
    pub fn advanced_blend_max_color_attachments(
        mut self,
        advanced_blend_max_color_attachments: u32,
    ) -> Self {
        self.advanced_blend_max_color_attachments = advanced_blend_max_color_attachments;
        self
    }
    #[inline]
    pub fn advanced_blend_independent_blend(
        mut self,
        advanced_blend_independent_blend: bool,
    ) -> Self {
        self.advanced_blend_independent_blend = advanced_blend_independent_blend.into();
        self
    }
    #[inline]
    pub fn advanced_blend_non_premultiplied_src_color(
        mut self,
        advanced_blend_non_premultiplied_src_color: bool,
    ) -> Self {
        self.advanced_blend_non_premultiplied_src_color =
            advanced_blend_non_premultiplied_src_color.into();
        self
    }
    #[inline]
    pub fn advanced_blend_non_premultiplied_dst_color(
        mut self,
        advanced_blend_non_premultiplied_dst_color: bool,
    ) -> Self {
        self.advanced_blend_non_premultiplied_dst_color =
            advanced_blend_non_premultiplied_dst_color.into();
        self
    }
    #[inline]
    pub fn advanced_blend_correlated_overlap(
        mut self,
        advanced_blend_correlated_overlap: bool,
    ) -> Self {
        self.advanced_blend_correlated_overlap = advanced_blend_correlated_overlap.into();
        self
    }
    #[inline]
    pub fn advanced_blend_all_operations(mut self, advanced_blend_all_operations: bool) -> Self {
        self.advanced_blend_all_operations = advanced_blend_all_operations.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineColorBlendAdvancedStateCreateInfoEXT.html>"]
#[must_use]
pub struct PipelineColorBlendAdvancedStateCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_premultiplied: Bool32,
    pub dst_premultiplied: Bool32,
    pub blend_overlap: BlendOverlapEXT,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineColorBlendAdvancedStateCreateInfoEXT<'_> {}
unsafe impl Sync for PipelineColorBlendAdvancedStateCreateInfoEXT<'_> {}
impl ::core::default::Default for PipelineColorBlendAdvancedStateCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            src_premultiplied: Bool32::default(),
            dst_premultiplied: Bool32::default(),
            blend_overlap: BlendOverlapEXT::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineColorBlendAdvancedStateCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT;
}
unsafe impl ExtendsPipelineColorBlendStateCreateInfo
    for PipelineColorBlendAdvancedStateCreateInfoEXT<'_>
{
}
impl<'a> PipelineColorBlendAdvancedStateCreateInfoEXT<'a> {
    #[inline]
    pub fn src_premultiplied(mut self, src_premultiplied: bool) -> Self {
        self.src_premultiplied = src_premultiplied.into();
        self
    }
    #[inline]
    pub fn dst_premultiplied(mut self, dst_premultiplied: bool) -> Self {
        self.dst_premultiplied = dst_premultiplied.into();
        self
    }
    #[inline]
    pub fn blend_overlap(mut self, blend_overlap: BlendOverlapEXT) -> Self {
        self.blend_overlap = blend_overlap;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceInlineUniformBlockFeatures.html>"]
#[must_use]
pub struct PhysicalDeviceInlineUniformBlockFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub inline_uniform_block: Bool32,
    pub descriptor_binding_inline_uniform_block_update_after_bind: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceInlineUniformBlockFeatures<'_> {}
unsafe impl Sync for PhysicalDeviceInlineUniformBlockFeatures<'_> {}
impl ::core::default::Default for PhysicalDeviceInlineUniformBlockFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            inline_uniform_block: Bool32::default(),
            descriptor_binding_inline_uniform_block_update_after_bind: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceInlineUniformBlockFeatures<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceInlineUniformBlockFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceInlineUniformBlockFeatures<'_> {}
impl<'a> PhysicalDeviceInlineUniformBlockFeatures<'a> {
    #[inline]
    pub fn inline_uniform_block(mut self, inline_uniform_block: bool) -> Self {
        self.inline_uniform_block = inline_uniform_block.into();
        self
    }
    #[inline]
    pub fn descriptor_binding_inline_uniform_block_update_after_bind(
        mut self,
        descriptor_binding_inline_uniform_block_update_after_bind: bool,
    ) -> Self {
        self.descriptor_binding_inline_uniform_block_update_after_bind =
            descriptor_binding_inline_uniform_block_update_after_bind.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceInlineUniformBlockProperties.html>"]
#[must_use]
pub struct PhysicalDeviceInlineUniformBlockProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_inline_uniform_block_size: u32,
    pub max_per_stage_descriptor_inline_uniform_blocks: u32,
    pub max_per_stage_descriptor_update_after_bind_inline_uniform_blocks: u32,
    pub max_descriptor_set_inline_uniform_blocks: u32,
    pub max_descriptor_set_update_after_bind_inline_uniform_blocks: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceInlineUniformBlockProperties<'_> {}
unsafe impl Sync for PhysicalDeviceInlineUniformBlockProperties<'_> {}
impl ::core::default::Default for PhysicalDeviceInlineUniformBlockProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_inline_uniform_block_size: u32::default(),
            max_per_stage_descriptor_inline_uniform_blocks: u32::default(),
            max_per_stage_descriptor_update_after_bind_inline_uniform_blocks: u32::default(),
            max_descriptor_set_inline_uniform_blocks: u32::default(),
            max_descriptor_set_update_after_bind_inline_uniform_blocks: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceInlineUniformBlockProperties<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceInlineUniformBlockProperties<'_> {}
impl<'a> PhysicalDeviceInlineUniformBlockProperties<'a> {
    #[inline]
    pub fn max_inline_uniform_block_size(mut self, max_inline_uniform_block_size: u32) -> Self {
        self.max_inline_uniform_block_size = max_inline_uniform_block_size;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_inline_uniform_blocks(
        mut self,
        max_per_stage_descriptor_inline_uniform_blocks: u32,
    ) -> Self {
        self.max_per_stage_descriptor_inline_uniform_blocks =
            max_per_stage_descriptor_inline_uniform_blocks;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_inline_uniform_blocks(
        mut self,
        max_per_stage_descriptor_update_after_bind_inline_uniform_blocks: u32,
    ) -> Self {
        self.max_per_stage_descriptor_update_after_bind_inline_uniform_blocks =
            max_per_stage_descriptor_update_after_bind_inline_uniform_blocks;
        self
    }
    #[inline]
    pub fn max_descriptor_set_inline_uniform_blocks(
        mut self,
        max_descriptor_set_inline_uniform_blocks: u32,
    ) -> Self {
        self.max_descriptor_set_inline_uniform_blocks = max_descriptor_set_inline_uniform_blocks;
        self
    }
    #[inline]
    pub fn max_descriptor_set_update_after_bind_inline_uniform_blocks(
        mut self,
        max_descriptor_set_update_after_bind_inline_uniform_blocks: u32,
    ) -> Self {
        self.max_descriptor_set_update_after_bind_inline_uniform_blocks =
            max_descriptor_set_update_after_bind_inline_uniform_blocks;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkWriteDescriptorSetInlineUniformBlock.html>"]
#[must_use]
pub struct WriteDescriptorSetInlineUniformBlock<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub data_size: u32,
    pub p_data: *const c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for WriteDescriptorSetInlineUniformBlock<'_> {}
unsafe impl Sync for WriteDescriptorSetInlineUniformBlock<'_> {}
impl ::core::default::Default for WriteDescriptorSetInlineUniformBlock<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            data_size: u32::default(),
            p_data: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for WriteDescriptorSetInlineUniformBlock<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK;
}
unsafe impl ExtendsWriteDescriptorSet for WriteDescriptorSetInlineUniformBlock<'_> {}
impl<'a> WriteDescriptorSetInlineUniformBlock<'a> {
    #[inline]
    pub fn data(mut self, data: &'a [u8]) -> Self {
        self.data_size = data.len() as _;
        self.p_data = data.as_ptr().cast();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorPoolInlineUniformBlockCreateInfo.html>"]
#[must_use]
pub struct DescriptorPoolInlineUniformBlockCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub max_inline_uniform_block_bindings: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DescriptorPoolInlineUniformBlockCreateInfo<'_> {}
unsafe impl Sync for DescriptorPoolInlineUniformBlockCreateInfo<'_> {}
impl ::core::default::Default for DescriptorPoolInlineUniformBlockCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            max_inline_uniform_block_bindings: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DescriptorPoolInlineUniformBlockCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO;
}
unsafe impl ExtendsDescriptorPoolCreateInfo for DescriptorPoolInlineUniformBlockCreateInfo<'_> {}
impl<'a> DescriptorPoolInlineUniformBlockCreateInfo<'a> {
    #[inline]
    pub fn max_inline_uniform_block_bindings(
        mut self,
        max_inline_uniform_block_bindings: u32,
    ) -> Self {
        self.max_inline_uniform_block_bindings = max_inline_uniform_block_bindings;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineCoverageModulationStateCreateInfoNV.html>"]
#[must_use]
pub struct PipelineCoverageModulationStateCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCoverageModulationStateCreateFlagsNV,
    pub coverage_modulation_mode: CoverageModulationModeNV,
    pub coverage_modulation_table_enable: Bool32,
    pub coverage_modulation_table_count: u32,
    pub p_coverage_modulation_table: *const f32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineCoverageModulationStateCreateInfoNV<'_> {}
unsafe impl Sync for PipelineCoverageModulationStateCreateInfoNV<'_> {}
impl ::core::default::Default for PipelineCoverageModulationStateCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineCoverageModulationStateCreateFlagsNV::default(),
            coverage_modulation_mode: CoverageModulationModeNV::default(),
            coverage_modulation_table_enable: Bool32::default(),
            coverage_modulation_table_count: u32::default(),
            p_coverage_modulation_table: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineCoverageModulationStateCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV;
}
unsafe impl ExtendsPipelineMultisampleStateCreateInfo
    for PipelineCoverageModulationStateCreateInfoNV<'_>
{
}
impl<'a> PipelineCoverageModulationStateCreateInfoNV<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCoverageModulationStateCreateFlagsNV) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn coverage_modulation_mode(
        mut self,
        coverage_modulation_mode: CoverageModulationModeNV,
    ) -> Self {
        self.coverage_modulation_mode = coverage_modulation_mode;
        self
    }
    #[inline]
    pub fn coverage_modulation_table_enable(
        mut self,
        coverage_modulation_table_enable: bool,
    ) -> Self {
        self.coverage_modulation_table_enable = coverage_modulation_table_enable.into();
        self
    }
    #[inline]
    pub fn coverage_modulation_table(mut self, coverage_modulation_table: &'a [f32]) -> Self {
        self.coverage_modulation_table_count = coverage_modulation_table.len() as _;
        self.p_coverage_modulation_table = coverage_modulation_table.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageFormatListCreateInfo.html>"]
#[must_use]
pub struct ImageFormatListCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub view_format_count: u32,
    pub p_view_formats: *const Format,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageFormatListCreateInfo<'_> {}
unsafe impl Sync for ImageFormatListCreateInfo<'_> {}
impl ::core::default::Default for ImageFormatListCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            view_format_count: u32::default(),
            p_view_formats: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageFormatListCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_FORMAT_LIST_CREATE_INFO;
}
unsafe impl ExtendsImageCreateInfo for ImageFormatListCreateInfo<'_> {}
unsafe impl ExtendsSwapchainCreateInfoKHR for ImageFormatListCreateInfo<'_> {}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2 for ImageFormatListCreateInfo<'_> {}
impl<'a> ImageFormatListCreateInfo<'a> {
    #[inline]
    pub fn view_formats(mut self, view_formats: &'a [Format]) -> Self {
        self.view_format_count = view_formats.len() as _;
        self.p_view_formats = view_formats.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkValidationCacheCreateInfoEXT.html>"]
#[must_use]
pub struct ValidationCacheCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ValidationCacheCreateFlagsEXT,
    pub initial_data_size: usize,
    pub p_initial_data: *const c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ValidationCacheCreateInfoEXT<'_> {}
unsafe impl Sync for ValidationCacheCreateInfoEXT<'_> {}
impl ::core::default::Default for ValidationCacheCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: ValidationCacheCreateFlagsEXT::default(),
            initial_data_size: usize::default(),
            p_initial_data: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ValidationCacheCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::VALIDATION_CACHE_CREATE_INFO_EXT;
}
impl<'a> ValidationCacheCreateInfoEXT<'a> {
    #[inline]
    pub fn flags(mut self, flags: ValidationCacheCreateFlagsEXT) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn initial_data(mut self, initial_data: &'a [u8]) -> Self {
        self.initial_data_size = initial_data.len();
        self.p_initial_data = initial_data.as_ptr().cast();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkShaderModuleValidationCacheCreateInfoEXT.html>"]
#[must_use]
pub struct ShaderModuleValidationCacheCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub validation_cache: ValidationCacheEXT,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ShaderModuleValidationCacheCreateInfoEXT<'_> {}
unsafe impl Sync for ShaderModuleValidationCacheCreateInfoEXT<'_> {}
impl ::core::default::Default for ShaderModuleValidationCacheCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            validation_cache: ValidationCacheEXT::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ShaderModuleValidationCacheCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT;
}
unsafe impl ExtendsShaderModuleCreateInfo for ShaderModuleValidationCacheCreateInfoEXT<'_> {}
unsafe impl ExtendsPipelineShaderStageCreateInfo for ShaderModuleValidationCacheCreateInfoEXT<'_> {}
impl<'a> ShaderModuleValidationCacheCreateInfoEXT<'a> {
    #[inline]
    pub fn validation_cache(mut self, validation_cache: ValidationCacheEXT) -> Self {
        self.validation_cache = validation_cache;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMaintenance3Properties.html>"]
#[must_use]
pub struct PhysicalDeviceMaintenance3Properties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_per_set_descriptors: u32,
    pub max_memory_allocation_size: DeviceSize,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMaintenance3Properties<'_> {}
unsafe impl Sync for PhysicalDeviceMaintenance3Properties<'_> {}
impl ::core::default::Default for PhysicalDeviceMaintenance3Properties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_per_set_descriptors: u32::default(),
            max_memory_allocation_size: DeviceSize::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMaintenance3Properties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMaintenance3Properties<'_> {}
impl<'a> PhysicalDeviceMaintenance3Properties<'a> {
    #[inline]
    pub fn max_per_set_descriptors(mut self, max_per_set_descriptors: u32) -> Self {
        self.max_per_set_descriptors = max_per_set_descriptors;
        self
    }
    #[inline]
    pub fn max_memory_allocation_size(mut self, max_memory_allocation_size: DeviceSize) -> Self {
        self.max_memory_allocation_size = max_memory_allocation_size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMaintenance4Features.html>"]
#[must_use]
pub struct PhysicalDeviceMaintenance4Features<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub maintenance4: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMaintenance4Features<'_> {}
unsafe impl Sync for PhysicalDeviceMaintenance4Features<'_> {}
impl ::core::default::Default for PhysicalDeviceMaintenance4Features<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            maintenance4: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMaintenance4Features<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMaintenance4Features<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMaintenance4Features<'_> {}
impl<'a> PhysicalDeviceMaintenance4Features<'a> {
    #[inline]
    pub fn maintenance4(mut self, maintenance4: bool) -> Self {
        self.maintenance4 = maintenance4.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMaintenance4Properties.html>"]
#[must_use]
pub struct PhysicalDeviceMaintenance4Properties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_buffer_size: DeviceSize,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMaintenance4Properties<'_> {}
unsafe impl Sync for PhysicalDeviceMaintenance4Properties<'_> {}
impl ::core::default::Default for PhysicalDeviceMaintenance4Properties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_buffer_size: DeviceSize::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMaintenance4Properties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMaintenance4Properties<'_> {}
impl<'a> PhysicalDeviceMaintenance4Properties<'a> {
    #[inline]
    pub fn max_buffer_size(mut self, max_buffer_size: DeviceSize) -> Self {
        self.max_buffer_size = max_buffer_size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMaintenance5FeaturesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceMaintenance5FeaturesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub maintenance5: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMaintenance5FeaturesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceMaintenance5FeaturesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceMaintenance5FeaturesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            maintenance5: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMaintenance5FeaturesKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES_KHR;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMaintenance5FeaturesKHR<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMaintenance5FeaturesKHR<'_> {}
impl<'a> PhysicalDeviceMaintenance5FeaturesKHR<'a> {
    #[inline]
    pub fn maintenance5(mut self, maintenance5: bool) -> Self {
        self.maintenance5 = maintenance5.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMaintenance5PropertiesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceMaintenance5PropertiesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub early_fragment_multisample_coverage_after_sample_counting: Bool32,
    pub early_fragment_sample_mask_test_before_sample_counting: Bool32,
    pub depth_stencil_swizzle_one_support: Bool32,
    pub polygon_mode_point_size: Bool32,
    pub non_strict_single_pixel_wide_lines_use_parallelogram: Bool32,
    pub non_strict_wide_lines_use_parallelogram: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMaintenance5PropertiesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceMaintenance5PropertiesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceMaintenance5PropertiesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            early_fragment_multisample_coverage_after_sample_counting: Bool32::default(),
            early_fragment_sample_mask_test_before_sample_counting: Bool32::default(),
            depth_stencil_swizzle_one_support: Bool32::default(),
            polygon_mode_point_size: Bool32::default(),
            non_strict_single_pixel_wide_lines_use_parallelogram: Bool32::default(),
            non_strict_wide_lines_use_parallelogram: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMaintenance5PropertiesKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES_KHR;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMaintenance5PropertiesKHR<'_> {}
impl<'a> PhysicalDeviceMaintenance5PropertiesKHR<'a> {
    #[inline]
    pub fn early_fragment_multisample_coverage_after_sample_counting(
        mut self,
        early_fragment_multisample_coverage_after_sample_counting: bool,
    ) -> Self {
        self.early_fragment_multisample_coverage_after_sample_counting =
            early_fragment_multisample_coverage_after_sample_counting.into();
        self
    }
    #[inline]
    pub fn early_fragment_sample_mask_test_before_sample_counting(
        mut self,
        early_fragment_sample_mask_test_before_sample_counting: bool,
    ) -> Self {
        self.early_fragment_sample_mask_test_before_sample_counting =
            early_fragment_sample_mask_test_before_sample_counting.into();
        self
    }
    #[inline]
    pub fn depth_stencil_swizzle_one_support(
        mut self,
        depth_stencil_swizzle_one_support: bool,
    ) -> Self {
        self.depth_stencil_swizzle_one_support = depth_stencil_swizzle_one_support.into();
        self
    }
    #[inline]
    pub fn polygon_mode_point_size(mut self, polygon_mode_point_size: bool) -> Self {
        self.polygon_mode_point_size = polygon_mode_point_size.into();
        self
    }
    #[inline]
    pub fn non_strict_single_pixel_wide_lines_use_parallelogram(
        mut self,
        non_strict_single_pixel_wide_lines_use_parallelogram: bool,
    ) -> Self {
        self.non_strict_single_pixel_wide_lines_use_parallelogram =
            non_strict_single_pixel_wide_lines_use_parallelogram.into();
        self
    }
    #[inline]
    pub fn non_strict_wide_lines_use_parallelogram(
        mut self,
        non_strict_wide_lines_use_parallelogram: bool,
    ) -> Self {
        self.non_strict_wide_lines_use_parallelogram =
            non_strict_wide_lines_use_parallelogram.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMaintenance6FeaturesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceMaintenance6FeaturesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub maintenance6: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMaintenance6FeaturesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceMaintenance6FeaturesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceMaintenance6FeaturesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            maintenance6: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMaintenance6FeaturesKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES_KHR;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMaintenance6FeaturesKHR<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMaintenance6FeaturesKHR<'_> {}
impl<'a> PhysicalDeviceMaintenance6FeaturesKHR<'a> {
    #[inline]
    pub fn maintenance6(mut self, maintenance6: bool) -> Self {
        self.maintenance6 = maintenance6.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMaintenance6PropertiesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceMaintenance6PropertiesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub block_texel_view_compatible_multiple_layers: Bool32,
    pub max_combined_image_sampler_descriptor_count: u32,
    pub fragment_shading_rate_clamp_combiner_inputs: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMaintenance6PropertiesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceMaintenance6PropertiesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceMaintenance6PropertiesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            block_texel_view_compatible_multiple_layers: Bool32::default(),
            max_combined_image_sampler_descriptor_count: u32::default(),
            fragment_shading_rate_clamp_combiner_inputs: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMaintenance6PropertiesKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES_KHR;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMaintenance6PropertiesKHR<'_> {}
impl<'a> PhysicalDeviceMaintenance6PropertiesKHR<'a> {
    #[inline]
    pub fn block_texel_view_compatible_multiple_layers(
        mut self,
        block_texel_view_compatible_multiple_layers: bool,
    ) -> Self {
        self.block_texel_view_compatible_multiple_layers =
            block_texel_view_compatible_multiple_layers.into();
        self
    }
    #[inline]
    pub fn max_combined_image_sampler_descriptor_count(
        mut self,
        max_combined_image_sampler_descriptor_count: u32,
    ) -> Self {
        self.max_combined_image_sampler_descriptor_count =
            max_combined_image_sampler_descriptor_count;
        self
    }
    #[inline]
    pub fn fragment_shading_rate_clamp_combiner_inputs(
        mut self,
        fragment_shading_rate_clamp_combiner_inputs: bool,
    ) -> Self {
        self.fragment_shading_rate_clamp_combiner_inputs =
            fragment_shading_rate_clamp_combiner_inputs.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRenderingAreaInfoKHR.html>"]
#[must_use]
pub struct RenderingAreaInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub view_mask: u32,
    pub color_attachment_count: u32,
    pub p_color_attachment_formats: *const Format,
    pub depth_attachment_format: Format,
    pub stencil_attachment_format: Format,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for RenderingAreaInfoKHR<'_> {}
unsafe impl Sync for RenderingAreaInfoKHR<'_> {}
impl ::core::default::Default for RenderingAreaInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            view_mask: u32::default(),
            color_attachment_count: u32::default(),
            p_color_attachment_formats: ::core::ptr::null(),
            depth_attachment_format: Format::default(),
            stencil_attachment_format: Format::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for RenderingAreaInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::RENDERING_AREA_INFO_KHR;
}
impl<'a> RenderingAreaInfoKHR<'a> {
    #[inline]
    pub fn view_mask(mut self, view_mask: u32) -> Self {
        self.view_mask = view_mask;
        self
    }
    #[inline]
    pub fn color_attachment_formats(mut self, color_attachment_formats: &'a [Format]) -> Self {
        self.color_attachment_count = color_attachment_formats.len() as _;
        self.p_color_attachment_formats = color_attachment_formats.as_ptr();
        self
    }
    #[inline]
    pub fn depth_attachment_format(mut self, depth_attachment_format: Format) -> Self {
        self.depth_attachment_format = depth_attachment_format;
        self
    }
    #[inline]
    pub fn stencil_attachment_format(mut self, stencil_attachment_format: Format) -> Self {
        self.stencil_attachment_format = stencil_attachment_format;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetLayoutSupport.html>"]
#[must_use]
pub struct DescriptorSetLayoutSupport<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub supported: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DescriptorSetLayoutSupport<'_> {}
unsafe impl Sync for DescriptorSetLayoutSupport<'_> {}
impl ::core::default::Default for DescriptorSetLayoutSupport<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            supported: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DescriptorSetLayoutSupport<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DESCRIPTOR_SET_LAYOUT_SUPPORT;
}
pub unsafe trait ExtendsDescriptorSetLayoutSupport {}
impl<'a> DescriptorSetLayoutSupport<'a> {
    #[inline]
    pub fn supported(mut self, supported: bool) -> Self {
        self.supported = supported.into();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDescriptorSetLayoutSupport + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShaderDrawParametersFeatures.html>"]
#[must_use]
pub struct PhysicalDeviceShaderDrawParametersFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_draw_parameters: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceShaderDrawParametersFeatures<'_> {}
unsafe impl Sync for PhysicalDeviceShaderDrawParametersFeatures<'_> {}
impl ::core::default::Default for PhysicalDeviceShaderDrawParametersFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shader_draw_parameters: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceShaderDrawParametersFeatures<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderDrawParametersFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderDrawParametersFeatures<'_> {}
impl<'a> PhysicalDeviceShaderDrawParametersFeatures<'a> {
    #[inline]
    pub fn shader_draw_parameters(mut self, shader_draw_parameters: bool) -> Self {
        self.shader_draw_parameters = shader_draw_parameters.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShaderFloat16Int8Features.html>"]
#[must_use]
pub struct PhysicalDeviceShaderFloat16Int8Features<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_float16: Bool32,
    pub shader_int8: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceShaderFloat16Int8Features<'_> {}
unsafe impl Sync for PhysicalDeviceShaderFloat16Int8Features<'_> {}
impl ::core::default::Default for PhysicalDeviceShaderFloat16Int8Features<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shader_float16: Bool32::default(),
            shader_int8: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceShaderFloat16Int8Features<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderFloat16Int8Features<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderFloat16Int8Features<'_> {}
impl<'a> PhysicalDeviceShaderFloat16Int8Features<'a> {
    #[inline]
    pub fn shader_float16(mut self, shader_float16: bool) -> Self {
        self.shader_float16 = shader_float16.into();
        self
    }
    #[inline]
    pub fn shader_int8(mut self, shader_int8: bool) -> Self {
        self.shader_int8 = shader_int8.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceFloatControlsProperties.html>"]
#[must_use]
pub struct PhysicalDeviceFloatControlsProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub denorm_behavior_independence: ShaderFloatControlsIndependence,
    pub rounding_mode_independence: ShaderFloatControlsIndependence,
    pub shader_signed_zero_inf_nan_preserve_float16: Bool32,
    pub shader_signed_zero_inf_nan_preserve_float32: Bool32,
    pub shader_signed_zero_inf_nan_preserve_float64: Bool32,
    pub shader_denorm_preserve_float16: Bool32,
    pub shader_denorm_preserve_float32: Bool32,
    pub shader_denorm_preserve_float64: Bool32,
    pub shader_denorm_flush_to_zero_float16: Bool32,
    pub shader_denorm_flush_to_zero_float32: Bool32,
    pub shader_denorm_flush_to_zero_float64: Bool32,
    pub shader_rounding_mode_rte_float16: Bool32,
    pub shader_rounding_mode_rte_float32: Bool32,
    pub shader_rounding_mode_rte_float64: Bool32,
    pub shader_rounding_mode_rtz_float16: Bool32,
    pub shader_rounding_mode_rtz_float32: Bool32,
    pub shader_rounding_mode_rtz_float64: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceFloatControlsProperties<'_> {}
unsafe impl Sync for PhysicalDeviceFloatControlsProperties<'_> {}
impl ::core::default::Default for PhysicalDeviceFloatControlsProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            denorm_behavior_independence: ShaderFloatControlsIndependence::default(),
            rounding_mode_independence: ShaderFloatControlsIndependence::default(),
            shader_signed_zero_inf_nan_preserve_float16: Bool32::default(),
            shader_signed_zero_inf_nan_preserve_float32: Bool32::default(),
            shader_signed_zero_inf_nan_preserve_float64: Bool32::default(),
            shader_denorm_preserve_float16: Bool32::default(),
            shader_denorm_preserve_float32: Bool32::default(),
            shader_denorm_preserve_float64: Bool32::default(),
            shader_denorm_flush_to_zero_float16: Bool32::default(),
            shader_denorm_flush_to_zero_float32: Bool32::default(),
            shader_denorm_flush_to_zero_float64: Bool32::default(),
            shader_rounding_mode_rte_float16: Bool32::default(),
            shader_rounding_mode_rte_float32: Bool32::default(),
            shader_rounding_mode_rte_float64: Bool32::default(),
            shader_rounding_mode_rtz_float16: Bool32::default(),
            shader_rounding_mode_rtz_float32: Bool32::default(),
            shader_rounding_mode_rtz_float64: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceFloatControlsProperties<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceFloatControlsProperties<'_> {}
impl<'a> PhysicalDeviceFloatControlsProperties<'a> {
    #[inline]
    pub fn denorm_behavior_independence(
        mut self,
        denorm_behavior_independence: ShaderFloatControlsIndependence,
    ) -> Self {
        self.denorm_behavior_independence = denorm_behavior_independence;
        self
    }
    #[inline]
    pub fn rounding_mode_independence(
        mut self,
        rounding_mode_independence: ShaderFloatControlsIndependence,
    ) -> Self {
        self.rounding_mode_independence = rounding_mode_independence;
        self
    }
    #[inline]
    pub fn shader_signed_zero_inf_nan_preserve_float16(
        mut self,
        shader_signed_zero_inf_nan_preserve_float16: bool,
    ) -> Self {
        self.shader_signed_zero_inf_nan_preserve_float16 =
            shader_signed_zero_inf_nan_preserve_float16.into();
        self
    }
    #[inline]
    pub fn shader_signed_zero_inf_nan_preserve_float32(
        mut self,
        shader_signed_zero_inf_nan_preserve_float32: bool,
    ) -> Self {
        self.shader_signed_zero_inf_nan_preserve_float32 =
            shader_signed_zero_inf_nan_preserve_float32.into();
        self
    }
    #[inline]
    pub fn shader_signed_zero_inf_nan_preserve_float64(
        mut self,
        shader_signed_zero_inf_nan_preserve_float64: bool,
    ) -> Self {
        self.shader_signed_zero_inf_nan_preserve_float64 =
            shader_signed_zero_inf_nan_preserve_float64.into();
        self
    }
    #[inline]
    pub fn shader_denorm_preserve_float16(mut self, shader_denorm_preserve_float16: bool) -> Self {
        self.shader_denorm_preserve_float16 = shader_denorm_preserve_float16.into();
        self
    }
    #[inline]
    pub fn shader_denorm_preserve_float32(mut self, shader_denorm_preserve_float32: bool) -> Self {
        self.shader_denorm_preserve_float32 = shader_denorm_preserve_float32.into();
        self
    }
    #[inline]
    pub fn shader_denorm_preserve_float64(mut self, shader_denorm_preserve_float64: bool) -> Self {
        self.shader_denorm_preserve_float64 = shader_denorm_preserve_float64.into();
        self
    }
    #[inline]
    pub fn shader_denorm_flush_to_zero_float16(
        mut self,
        shader_denorm_flush_to_zero_float16: bool,
    ) -> Self {
        self.shader_denorm_flush_to_zero_float16 = shader_denorm_flush_to_zero_float16.into();
        self
    }
    #[inline]
    pub fn shader_denorm_flush_to_zero_float32(
        mut self,
        shader_denorm_flush_to_zero_float32: bool,
    ) -> Self {
        self.shader_denorm_flush_to_zero_float32 = shader_denorm_flush_to_zero_float32.into();
        self
    }
    #[inline]
    pub fn shader_denorm_flush_to_zero_float64(
        mut self,
        shader_denorm_flush_to_zero_float64: bool,
    ) -> Self {
        self.shader_denorm_flush_to_zero_float64 = shader_denorm_flush_to_zero_float64.into();
        self
    }
    #[inline]
    pub fn shader_rounding_mode_rte_float16(
        mut self,
        shader_rounding_mode_rte_float16: bool,
    ) -> Self {
        self.shader_rounding_mode_rte_float16 = shader_rounding_mode_rte_float16.into();
        self
    }
    #[inline]
    pub fn shader_rounding_mode_rte_float32(
        mut self,
        shader_rounding_mode_rte_float32: bool,
    ) -> Self {
        self.shader_rounding_mode_rte_float32 = shader_rounding_mode_rte_float32.into();
        self
    }
    #[inline]
    pub fn shader_rounding_mode_rte_float64(
        mut self,
        shader_rounding_mode_rte_float64: bool,
    ) -> Self {
        self.shader_rounding_mode_rte_float64 = shader_rounding_mode_rte_float64.into();
        self
    }
    #[inline]
    pub fn shader_rounding_mode_rtz_float16(
        mut self,
        shader_rounding_mode_rtz_float16: bool,
    ) -> Self {
        self.shader_rounding_mode_rtz_float16 = shader_rounding_mode_rtz_float16.into();
        self
    }
    #[inline]
    pub fn shader_rounding_mode_rtz_float32(
        mut self,
        shader_rounding_mode_rtz_float32: bool,
    ) -> Self {
        self.shader_rounding_mode_rtz_float32 = shader_rounding_mode_rtz_float32.into();
        self
    }
    #[inline]
    pub fn shader_rounding_mode_rtz_float64(
        mut self,
        shader_rounding_mode_rtz_float64: bool,
    ) -> Self {
        self.shader_rounding_mode_rtz_float64 = shader_rounding_mode_rtz_float64.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceHostQueryResetFeatures.html>"]
#[must_use]
pub struct PhysicalDeviceHostQueryResetFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub host_query_reset: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceHostQueryResetFeatures<'_> {}
unsafe impl Sync for PhysicalDeviceHostQueryResetFeatures<'_> {}
impl ::core::default::Default for PhysicalDeviceHostQueryResetFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            host_query_reset: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceHostQueryResetFeatures<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceHostQueryResetFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceHostQueryResetFeatures<'_> {}
impl<'a> PhysicalDeviceHostQueryResetFeatures<'a> {
    #[inline]
    pub fn host_query_reset(mut self, host_query_reset: bool) -> Self {
        self.host_query_reset = host_query_reset.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkNativeBufferUsage2ANDROID.html>"]
#[must_use]
pub struct NativeBufferUsage2ANDROID {
    pub consumer: u64,
    pub producer: u64,
}
impl NativeBufferUsage2ANDROID {
    #[inline]
    pub fn consumer(mut self, consumer: u64) -> Self {
        self.consumer = consumer;
        self
    }
    #[inline]
    pub fn producer(mut self, producer: u64) -> Self {
        self.producer = producer;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkNativeBufferANDROID.html>"]
#[must_use]
pub struct NativeBufferANDROID<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle: *const c_void,
    pub stride: c_int,
    pub format: c_int,
    pub usage: c_int,
    pub usage2: NativeBufferUsage2ANDROID,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for NativeBufferANDROID<'_> {}
unsafe impl Sync for NativeBufferANDROID<'_> {}
impl ::core::default::Default for NativeBufferANDROID<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle: ::core::ptr::null(),
            stride: c_int::default(),
            format: c_int::default(),
            usage: c_int::default(),
            usage2: NativeBufferUsage2ANDROID::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for NativeBufferANDROID<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::NATIVE_BUFFER_ANDROID;
}
impl<'a> NativeBufferANDROID<'a> {
    #[inline]
    pub fn handle(mut self, handle: *const c_void) -> Self {
        self.handle = handle;
        self
    }
    #[inline]
    pub fn stride(mut self, stride: c_int) -> Self {
        self.stride = stride;
        self
    }
    #[inline]
    pub fn format(mut self, format: c_int) -> Self {
        self.format = format;
        self
    }
    #[inline]
    pub fn usage(mut self, usage: c_int) -> Self {
        self.usage = usage;
        self
    }
    #[inline]
    pub fn usage2(mut self, usage2: NativeBufferUsage2ANDROID) -> Self {
        self.usage2 = usage2;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSwapchainImageCreateInfoANDROID.html>"]
#[must_use]
pub struct SwapchainImageCreateInfoANDROID<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub usage: SwapchainImageUsageFlagsANDROID,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SwapchainImageCreateInfoANDROID<'_> {}
unsafe impl Sync for SwapchainImageCreateInfoANDROID<'_> {}
impl ::core::default::Default for SwapchainImageCreateInfoANDROID<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            usage: SwapchainImageUsageFlagsANDROID::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SwapchainImageCreateInfoANDROID<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SWAPCHAIN_IMAGE_CREATE_INFO_ANDROID;
}
impl<'a> SwapchainImageCreateInfoANDROID<'a> {
    #[inline]
    pub fn usage(mut self, usage: SwapchainImageUsageFlagsANDROID) -> Self {
        self.usage = usage;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevicePresentationPropertiesANDROID.html>"]
#[must_use]
pub struct PhysicalDevicePresentationPropertiesANDROID<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub shared_image: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDevicePresentationPropertiesANDROID<'_> {}
unsafe impl Sync for PhysicalDevicePresentationPropertiesANDROID<'_> {}
impl ::core::default::Default for PhysicalDevicePresentationPropertiesANDROID<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            shared_image: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDevicePresentationPropertiesANDROID<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_PRESENTATION_PROPERTIES_ANDROID;
}
impl<'a> PhysicalDevicePresentationPropertiesANDROID<'a> {
    #[inline]
    pub fn shared_image(mut self, shared_image: bool) -> Self {
        self.shared_image = shared_image.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkShaderResourceUsageAMD.html>"]
#[must_use]
pub struct ShaderResourceUsageAMD {
    pub num_used_vgprs: u32,
    pub num_used_sgprs: u32,
    pub lds_size_per_local_work_group: u32,
    pub lds_usage_size_in_bytes: usize,
    pub scratch_mem_usage_in_bytes: usize,
}
impl ShaderResourceUsageAMD {
    #[inline]
    pub fn num_used_vgprs(mut self, num_used_vgprs: u32) -> Self {
        self.num_used_vgprs = num_used_vgprs;
        self
    }
    #[inline]
    pub fn num_used_sgprs(mut self, num_used_sgprs: u32) -> Self {
        self.num_used_sgprs = num_used_sgprs;
        self
    }
    #[inline]
    pub fn lds_size_per_local_work_group(mut self, lds_size_per_local_work_group: u32) -> Self {
        self.lds_size_per_local_work_group = lds_size_per_local_work_group;
        self
    }
    #[inline]
    pub fn lds_usage_size_in_bytes(mut self, lds_usage_size_in_bytes: usize) -> Self {
        self.lds_usage_size_in_bytes = lds_usage_size_in_bytes;
        self
    }
    #[inline]
    pub fn scratch_mem_usage_in_bytes(mut self, scratch_mem_usage_in_bytes: usize) -> Self {
        self.scratch_mem_usage_in_bytes = scratch_mem_usage_in_bytes;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkShaderStatisticsInfoAMD.html>"]
#[must_use]
pub struct ShaderStatisticsInfoAMD {
    pub shader_stage_mask: ShaderStageFlags,
    pub resource_usage: ShaderResourceUsageAMD,
    pub num_physical_vgprs: u32,
    pub num_physical_sgprs: u32,
    pub num_available_vgprs: u32,
    pub num_available_sgprs: u32,
    pub compute_work_group_size: [u32; 3],
}
impl ::core::default::Default for ShaderStatisticsInfoAMD {
    #[inline]
    fn default() -> Self {
        Self {
            shader_stage_mask: ShaderStageFlags::default(),
            resource_usage: ShaderResourceUsageAMD::default(),
            num_physical_vgprs: u32::default(),
            num_physical_sgprs: u32::default(),
            num_available_vgprs: u32::default(),
            num_available_sgprs: u32::default(),
            compute_work_group_size: unsafe { ::core::mem::zeroed() },
        }
    }
}
impl ShaderStatisticsInfoAMD {
    #[inline]
    pub fn shader_stage_mask(mut self, shader_stage_mask: ShaderStageFlags) -> Self {
        self.shader_stage_mask = shader_stage_mask;
        self
    }
    #[inline]
    pub fn resource_usage(mut self, resource_usage: ShaderResourceUsageAMD) -> Self {
        self.resource_usage = resource_usage;
        self
    }
    #[inline]
    pub fn num_physical_vgprs(mut self, num_physical_vgprs: u32) -> Self {
        self.num_physical_vgprs = num_physical_vgprs;
        self
    }
    #[inline]
    pub fn num_physical_sgprs(mut self, num_physical_sgprs: u32) -> Self {
        self.num_physical_sgprs = num_physical_sgprs;
        self
    }
    #[inline]
    pub fn num_available_vgprs(mut self, num_available_vgprs: u32) -> Self {
        self.num_available_vgprs = num_available_vgprs;
        self
    }
    #[inline]
    pub fn num_available_sgprs(mut self, num_available_sgprs: u32) -> Self {
        self.num_available_sgprs = num_available_sgprs;
        self
    }
    #[inline]
    pub fn compute_work_group_size(mut self, compute_work_group_size: [u32; 3]) -> Self {
        self.compute_work_group_size = compute_work_group_size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceQueueGlobalPriorityCreateInfoKHR.html>"]
#[must_use]
pub struct DeviceQueueGlobalPriorityCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub global_priority: QueueGlobalPriorityKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceQueueGlobalPriorityCreateInfoKHR<'_> {}
unsafe impl Sync for DeviceQueueGlobalPriorityCreateInfoKHR<'_> {}
impl ::core::default::Default for DeviceQueueGlobalPriorityCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            global_priority: QueueGlobalPriorityKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceQueueGlobalPriorityCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_KHR;
}
unsafe impl ExtendsDeviceQueueCreateInfo for DeviceQueueGlobalPriorityCreateInfoKHR<'_> {}
impl<'a> DeviceQueueGlobalPriorityCreateInfoKHR<'a> {
    #[inline]
    pub fn global_priority(mut self, global_priority: QueueGlobalPriorityKHR) -> Self {
        self.global_priority = global_priority;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceGlobalPriorityQueryFeaturesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub global_priority_query: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceGlobalPriorityQueryFeaturesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceGlobalPriorityQueryFeaturesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceGlobalPriorityQueryFeaturesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            global_priority_query: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceGlobalPriorityQueryFeaturesKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_KHR;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceGlobalPriorityQueryFeaturesKHR<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceGlobalPriorityQueryFeaturesKHR<'_> {}
impl<'a> PhysicalDeviceGlobalPriorityQueryFeaturesKHR<'a> {
    #[inline]
    pub fn global_priority_query(mut self, global_priority_query: bool) -> Self {
        self.global_priority_query = global_priority_query.into();
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkQueueFamilyGlobalPriorityPropertiesKHR.html>"]
#[must_use]
pub struct QueueFamilyGlobalPriorityPropertiesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub priority_count: u32,
    pub priorities: [QueueGlobalPriorityKHR; MAX_GLOBAL_PRIORITY_SIZE_KHR],
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for QueueFamilyGlobalPriorityPropertiesKHR<'_> {}
unsafe impl Sync for QueueFamilyGlobalPriorityPropertiesKHR<'_> {}
#[cfg(feature = "debug")]
impl fmt::Debug for QueueFamilyGlobalPriorityPropertiesKHR<'_> {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("QueueFamilyGlobalPriorityPropertiesKHR")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("priority_count", &self.priority_count)
            .field("priorities", &self.priorities_as_slice())
            .finish()
    }
}
impl ::core::default::Default for QueueFamilyGlobalPriorityPropertiesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            priority_count: u32::default(),
            priorities: unsafe { ::core::mem::zeroed() },
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for QueueFamilyGlobalPriorityPropertiesKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_KHR;
}
unsafe impl ExtendsQueueFamilyProperties2 for QueueFamilyGlobalPriorityPropertiesKHR<'_> {}
impl<'a> QueueFamilyGlobalPriorityPropertiesKHR<'a> {
    #[inline]
    pub fn priorities(mut self, priorities: &'_ [QueueGlobalPriorityKHR]) -> Self {
        self.priority_count = priorities.len() as _;
        self.priorities[..priorities.len()].copy_from_slice(priorities);
        self
    }
    #[inline]
    pub fn priorities_as_slice(&self) -> &[QueueGlobalPriorityKHR] {
        &self.priorities[..self.priority_count as _]
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugUtilsObjectNameInfoEXT.html>"]
#[must_use]
pub struct DebugUtilsObjectNameInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub object_type: ObjectType,
    pub object_handle: u64,
    pub p_object_name: *const c_char,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DebugUtilsObjectNameInfoEXT<'_> {}
unsafe impl Sync for DebugUtilsObjectNameInfoEXT<'_> {}
impl ::core::default::Default for DebugUtilsObjectNameInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            object_type: ObjectType::default(),
            object_handle: u64::default(),
            p_object_name: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DebugUtilsObjectNameInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_UTILS_OBJECT_NAME_INFO_EXT;
}
unsafe impl ExtendsPipelineShaderStageCreateInfo for DebugUtilsObjectNameInfoEXT<'_> {}
impl<'a> DebugUtilsObjectNameInfoEXT<'a> {
    #[inline]
    pub fn object_handle<T: Handle>(mut self, object_handle: T) -> Self {
        self.object_handle = object_handle.as_raw();
        self.object_type = T::TYPE;
        self
    }
    #[inline]
    pub fn object_name(mut self, object_name: &'a CStr) -> Self {
        self.p_object_name = object_name.as_ptr();
        self
    }
    #[inline]
    pub unsafe fn object_name_as_c_str(&self) -> Option<&CStr> {
        if self.p_object_name.is_null() {
            None
        } else {
            Some(CStr::from_ptr(self.p_object_name))
        }
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugUtilsObjectTagInfoEXT.html>"]
#[must_use]
pub struct DebugUtilsObjectTagInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub object_type: ObjectType,
    pub object_handle: u64,
    pub tag_name: u64,
    pub tag_size: usize,
    pub p_tag: *const c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DebugUtilsObjectTagInfoEXT<'_> {}
unsafe impl Sync for DebugUtilsObjectTagInfoEXT<'_> {}
impl ::core::default::Default for DebugUtilsObjectTagInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            object_type: ObjectType::default(),
            object_handle: u64::default(),
            tag_name: u64::default(),
            tag_size: usize::default(),
            p_tag: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DebugUtilsObjectTagInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_UTILS_OBJECT_TAG_INFO_EXT;
}
impl<'a> DebugUtilsObjectTagInfoEXT<'a> {
    #[inline]
    pub fn object_handle<T: Handle>(mut self, object_handle: T) -> Self {
        self.object_handle = object_handle.as_raw();
        self.object_type = T::TYPE;
        self
    }
    #[inline]
    pub fn tag_name(mut self, tag_name: u64) -> Self {
        self.tag_name = tag_name;
        self
    }
    #[inline]
    pub fn tag(mut self, tag: &'a [u8]) -> Self {
        self.tag_size = tag.len();
        self.p_tag = tag.as_ptr().cast();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugUtilsLabelEXT.html>"]
#[must_use]
pub struct DebugUtilsLabelEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_label_name: *const c_char,
    pub color: [f32; 4],
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DebugUtilsLabelEXT<'_> {}
unsafe impl Sync for DebugUtilsLabelEXT<'_> {}
impl ::core::default::Default for DebugUtilsLabelEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            p_label_name: ::core::ptr::null(),
            color: unsafe { ::core::mem::zeroed() },
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DebugUtilsLabelEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_UTILS_LABEL_EXT;
}
impl<'a> DebugUtilsLabelEXT<'a> {
    #[inline]
    pub fn label_name(mut self, label_name: &'a CStr) -> Self {
        self.p_label_name = label_name.as_ptr();
        self
    }
    #[inline]
    pub unsafe fn label_name_as_c_str(&self) -> Option<&CStr> {
        if self.p_label_name.is_null() {
            None
        } else {
            Some(CStr::from_ptr(self.p_label_name))
        }
    }
    #[inline]
    pub fn color(mut self, color: [f32; 4]) -> Self {
        self.color = color;
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugUtilsMessengerCreateInfoEXT.html>"]
#[must_use]
pub struct DebugUtilsMessengerCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DebugUtilsMessengerCreateFlagsEXT,
    pub message_severity: DebugUtilsMessageSeverityFlagsEXT,
    pub message_type: DebugUtilsMessageTypeFlagsEXT,
    pub pfn_user_callback: PFN_vkDebugUtilsMessengerCallbackEXT,
    pub p_user_data: *mut c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DebugUtilsMessengerCreateInfoEXT<'_> {}
unsafe impl Sync for DebugUtilsMessengerCreateInfoEXT<'_> {}
#[cfg(feature = "debug")]
impl fmt::Debug for DebugUtilsMessengerCreateInfoEXT<'_> {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("DebugUtilsMessengerCreateInfoEXT")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("flags", &self.flags)
            .field("message_severity", &self.message_severity)
            .field("message_type", &self.message_type)
            .field(
                "pfn_user_callback",
                &(self.pfn_user_callback.map(|x| x as *const ())),
            )
            .field("p_user_data", &self.p_user_data)
            .finish()
    }
}
impl ::core::default::Default for DebugUtilsMessengerCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DebugUtilsMessengerCreateFlagsEXT::default(),
            message_severity: DebugUtilsMessageSeverityFlagsEXT::default(),
            message_type: DebugUtilsMessageTypeFlagsEXT::default(),
            pfn_user_callback: PFN_vkDebugUtilsMessengerCallbackEXT::default(),
            p_user_data: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DebugUtilsMessengerCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT;
}
unsafe impl ExtendsInstanceCreateInfo for DebugUtilsMessengerCreateInfoEXT<'_> {}
impl<'a> DebugUtilsMessengerCreateInfoEXT<'a> {
    #[inline]
    pub fn flags(mut self, flags: DebugUtilsMessengerCreateFlagsEXT) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn message_severity(mut self, message_severity: DebugUtilsMessageSeverityFlagsEXT) -> Self {
        self.message_severity = message_severity;
        self
    }
    #[inline]
    pub fn message_type(mut self, message_type: DebugUtilsMessageTypeFlagsEXT) -> Self {
        self.message_type = message_type;
        self
    }
    #[inline]
    pub fn pfn_user_callback(
        mut self,
        pfn_user_callback: PFN_vkDebugUtilsMessengerCallbackEXT,
    ) -> Self {
        self.pfn_user_callback = pfn_user_callback;
        self
    }
    #[inline]
    pub fn user_data(mut self, user_data: *mut c_void) -> Self {
        self.p_user_data = user_data;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDebugUtilsMessengerCallbackDataEXT.html>"]
#[must_use]
pub struct DebugUtilsMessengerCallbackDataEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DebugUtilsMessengerCallbackDataFlagsEXT,
    pub p_message_id_name: *const c_char,
    pub message_id_number: i32,
    pub p_message: *const c_char,
    pub queue_label_count: u32,
    pub p_queue_labels: *const DebugUtilsLabelEXT<'a>,
    pub cmd_buf_label_count: u32,
    pub p_cmd_buf_labels: *const DebugUtilsLabelEXT<'a>,
    pub object_count: u32,
    pub p_objects: *const DebugUtilsObjectNameInfoEXT<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DebugUtilsMessengerCallbackDataEXT<'_> {}
unsafe impl Sync for DebugUtilsMessengerCallbackDataEXT<'_> {}
impl ::core::default::Default for DebugUtilsMessengerCallbackDataEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DebugUtilsMessengerCallbackDataFlagsEXT::default(),
            p_message_id_name: ::core::ptr::null(),
            message_id_number: i32::default(),
            p_message: ::core::ptr::null(),
            queue_label_count: u32::default(),
            p_queue_labels: ::core::ptr::null(),
            cmd_buf_label_count: u32::default(),
            p_cmd_buf_labels: ::core::ptr::null(),
            object_count: u32::default(),
            p_objects: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DebugUtilsMessengerCallbackDataEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT;
}
pub unsafe trait ExtendsDebugUtilsMessengerCallbackDataEXT {}
impl<'a> DebugUtilsMessengerCallbackDataEXT<'a> {
    #[inline]
    pub fn flags(mut self, flags: DebugUtilsMessengerCallbackDataFlagsEXT) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn message_id_name(mut self, message_id_name: &'a CStr) -> Self {
        self.p_message_id_name = message_id_name.as_ptr();
        self
    }
    #[inline]
    pub unsafe fn message_id_name_as_c_str(&self) -> Option<&CStr> {
        if self.p_message_id_name.is_null() {
            None
        } else {
            Some(CStr::from_ptr(self.p_message_id_name))
        }
    }
    #[inline]
    pub fn message_id_number(mut self, message_id_number: i32) -> Self {
        self.message_id_number = message_id_number;
        self
    }
    #[inline]
    pub fn message(mut self, message: &'a CStr) -> Self {
        self.p_message = message.as_ptr();
        self
    }
    #[inline]
    pub unsafe fn message_as_c_str(&self) -> Option<&CStr> {
        if self.p_message.is_null() {
            None
        } else {
            Some(CStr::from_ptr(self.p_message))
        }
    }
    #[inline]
    pub fn queue_labels(mut self, queue_labels: &'a [DebugUtilsLabelEXT<'a>]) -> Self {
        self.queue_label_count = queue_labels.len() as _;
        self.p_queue_labels = queue_labels.as_ptr();
        self
    }
    #[inline]
    pub fn cmd_buf_labels(mut self, cmd_buf_labels: &'a [DebugUtilsLabelEXT<'a>]) -> Self {
        self.cmd_buf_label_count = cmd_buf_labels.len() as _;
        self.p_cmd_buf_labels = cmd_buf_labels.as_ptr();
        self
    }
    #[inline]
    pub fn objects(mut self, objects: &'a [DebugUtilsObjectNameInfoEXT<'a>]) -> Self {
        self.object_count = objects.len() as _;
        self.p_objects = objects.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDebugUtilsMessengerCallbackDataEXT + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDeviceMemoryReportFeaturesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceDeviceMemoryReportFeaturesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub device_memory_report: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceDeviceMemoryReportFeaturesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceDeviceMemoryReportFeaturesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceDeviceMemoryReportFeaturesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            device_memory_report: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceDeviceMemoryReportFeaturesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceDeviceMemoryReportFeaturesEXT<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDeviceMemoryReportFeaturesEXT<'_> {}
impl<'a> PhysicalDeviceDeviceMemoryReportFeaturesEXT<'a> {
    #[inline]
    pub fn device_memory_report(mut self, device_memory_report: bool) -> Self {
        self.device_memory_report = device_memory_report.into();
        self
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceDeviceMemoryReportCreateInfoEXT.html>"]
#[must_use]
pub struct DeviceDeviceMemoryReportCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DeviceMemoryReportFlagsEXT,
    pub pfn_user_callback: PFN_vkDeviceMemoryReportCallbackEXT,
    pub p_user_data: *mut c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceDeviceMemoryReportCreateInfoEXT<'_> {}
unsafe impl Sync for DeviceDeviceMemoryReportCreateInfoEXT<'_> {}
#[cfg(feature = "debug")]
impl fmt::Debug for DeviceDeviceMemoryReportCreateInfoEXT<'_> {
    fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt.debug_struct("DeviceDeviceMemoryReportCreateInfoEXT")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("flags", &self.flags)
            .field(
                "pfn_user_callback",
                &(self.pfn_user_callback.map(|x| x as *const ())),
            )
            .field("p_user_data", &self.p_user_data)
            .finish()
    }
}
impl ::core::default::Default for DeviceDeviceMemoryReportCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: DeviceMemoryReportFlagsEXT::default(),
            pfn_user_callback: PFN_vkDeviceMemoryReportCallbackEXT::default(),
            p_user_data: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceDeviceMemoryReportCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT;
}
unsafe impl ExtendsDeviceCreateInfo for DeviceDeviceMemoryReportCreateInfoEXT<'_> {}
impl<'a> DeviceDeviceMemoryReportCreateInfoEXT<'a> {
    #[inline]
    pub fn flags(mut self, flags: DeviceMemoryReportFlagsEXT) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn pfn_user_callback(
        mut self,
        pfn_user_callback: PFN_vkDeviceMemoryReportCallbackEXT,
    ) -> Self {
        self.pfn_user_callback = pfn_user_callback;
        self
    }
    #[inline]
    pub fn user_data(mut self, user_data: *mut c_void) -> Self {
        self.p_user_data = user_data;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceMemoryReportCallbackDataEXT.html>"]
#[must_use]
pub struct DeviceMemoryReportCallbackDataEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub flags: DeviceMemoryReportFlagsEXT,
    pub ty: DeviceMemoryReportEventTypeEXT,
    pub memory_object_id: u64,
    pub size: DeviceSize,
    pub object_type: ObjectType,
    pub object_handle: u64,
    pub heap_index: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceMemoryReportCallbackDataEXT<'_> {}
unsafe impl Sync for DeviceMemoryReportCallbackDataEXT<'_> {}
impl ::core::default::Default for DeviceMemoryReportCallbackDataEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            flags: DeviceMemoryReportFlagsEXT::default(),
            ty: DeviceMemoryReportEventTypeEXT::default(),
            memory_object_id: u64::default(),
            size: DeviceSize::default(),
            object_type: ObjectType::default(),
            object_handle: u64::default(),
            heap_index: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceMemoryReportCallbackDataEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT;
}
impl<'a> DeviceMemoryReportCallbackDataEXT<'a> {
    #[inline]
    pub fn flags(mut self, flags: DeviceMemoryReportFlagsEXT) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn ty(mut self, ty: DeviceMemoryReportEventTypeEXT) -> Self {
        self.ty = ty;
        self
    }
    #[inline]
    pub fn memory_object_id(mut self, memory_object_id: u64) -> Self {
        self.memory_object_id = memory_object_id;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.size = size;
        self
    }
    #[inline]
    pub fn object_handle<T: Handle>(mut self, object_handle: T) -> Self {
        self.object_handle = object_handle.as_raw();
        self.object_type = T::TYPE;
        self
    }
    #[inline]
    pub fn heap_index(mut self, heap_index: u32) -> Self {
        self.heap_index = heap_index;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImportMemoryHostPointerInfoEXT.html>"]
#[must_use]
pub struct ImportMemoryHostPointerInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub p_host_pointer: *mut c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImportMemoryHostPointerInfoEXT<'_> {}
unsafe impl Sync for ImportMemoryHostPointerInfoEXT<'_> {}
impl ::core::default::Default for ImportMemoryHostPointerInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            p_host_pointer: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImportMemoryHostPointerInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_MEMORY_HOST_POINTER_INFO_EXT;
}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryHostPointerInfoEXT<'_> {}
impl<'a> ImportMemoryHostPointerInfoEXT<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn host_pointer(mut self, host_pointer: *mut c_void) -> Self {
        self.p_host_pointer = host_pointer;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryHostPointerPropertiesEXT.html>"]
#[must_use]
pub struct MemoryHostPointerPropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_type_bits: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryHostPointerPropertiesEXT<'_> {}
unsafe impl Sync for MemoryHostPointerPropertiesEXT<'_> {}
impl ::core::default::Default for MemoryHostPointerPropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            memory_type_bits: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryHostPointerPropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_HOST_POINTER_PROPERTIES_EXT;
}
impl<'a> MemoryHostPointerPropertiesEXT<'a> {
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.memory_type_bits = memory_type_bits;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceExternalMemoryHostPropertiesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceExternalMemoryHostPropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub min_imported_host_pointer_alignment: DeviceSize,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceExternalMemoryHostPropertiesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceExternalMemoryHostPropertiesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceExternalMemoryHostPropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            min_imported_host_pointer_alignment: DeviceSize::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceExternalMemoryHostPropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceExternalMemoryHostPropertiesEXT<'_> {}
impl<'a> PhysicalDeviceExternalMemoryHostPropertiesEXT<'a> {
    #[inline]
    pub fn min_imported_host_pointer_alignment(
        mut self,
        min_imported_host_pointer_alignment: DeviceSize,
    ) -> Self {
        self.min_imported_host_pointer_alignment = min_imported_host_pointer_alignment;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceConservativeRasterizationPropertiesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceConservativeRasterizationPropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub primitive_overestimation_size: f32,
    pub max_extra_primitive_overestimation_size: f32,
    pub extra_primitive_overestimation_size_granularity: f32,
    pub primitive_underestimation: Bool32,
    pub conservative_point_and_line_rasterization: Bool32,
    pub degenerate_triangles_rasterized: Bool32,
    pub degenerate_lines_rasterized: Bool32,
    pub fully_covered_fragment_shader_input_variable: Bool32,
    pub conservative_rasterization_post_depth_coverage: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceConservativeRasterizationPropertiesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceConservativeRasterizationPropertiesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceConservativeRasterizationPropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            primitive_overestimation_size: f32::default(),
            max_extra_primitive_overestimation_size: f32::default(),
            extra_primitive_overestimation_size_granularity: f32::default(),
            primitive_underestimation: Bool32::default(),
            conservative_point_and_line_rasterization: Bool32::default(),
            degenerate_triangles_rasterized: Bool32::default(),
            degenerate_lines_rasterized: Bool32::default(),
            fully_covered_fragment_shader_input_variable: Bool32::default(),
            conservative_rasterization_post_depth_coverage: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceConservativeRasterizationPropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT;
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceConservativeRasterizationPropertiesEXT<'_>
{
}
impl<'a> PhysicalDeviceConservativeRasterizationPropertiesEXT<'a> {
    #[inline]
    pub fn primitive_overestimation_size(mut self, primitive_overestimation_size: f32) -> Self {
        self.primitive_overestimation_size = primitive_overestimation_size;
        self
    }
    #[inline]
    pub fn max_extra_primitive_overestimation_size(
        mut self,
        max_extra_primitive_overestimation_size: f32,
    ) -> Self {
        self.max_extra_primitive_overestimation_size = max_extra_primitive_overestimation_size;
        self
    }
    #[inline]
    pub fn extra_primitive_overestimation_size_granularity(
        mut self,
        extra_primitive_overestimation_size_granularity: f32,
    ) -> Self {
        self.extra_primitive_overestimation_size_granularity =
            extra_primitive_overestimation_size_granularity;
        self
    }
    #[inline]
    pub fn primitive_underestimation(mut self, primitive_underestimation: bool) -> Self {
        self.primitive_underestimation = primitive_underestimation.into();
        self
    }
    #[inline]
    pub fn conservative_point_and_line_rasterization(
        mut self,
        conservative_point_and_line_rasterization: bool,
    ) -> Self {
        self.conservative_point_and_line_rasterization =
            conservative_point_and_line_rasterization.into();
        self
    }
    #[inline]
    pub fn degenerate_triangles_rasterized(
        mut self,
        degenerate_triangles_rasterized: bool,
    ) -> Self {
        self.degenerate_triangles_rasterized = degenerate_triangles_rasterized.into();
        self
    }
    #[inline]
    pub fn degenerate_lines_rasterized(mut self, degenerate_lines_rasterized: bool) -> Self {
        self.degenerate_lines_rasterized = degenerate_lines_rasterized.into();
        self
    }
    #[inline]
    pub fn fully_covered_fragment_shader_input_variable(
        mut self,
        fully_covered_fragment_shader_input_variable: bool,
    ) -> Self {
        self.fully_covered_fragment_shader_input_variable =
            fully_covered_fragment_shader_input_variable.into();
        self
    }
    #[inline]
    pub fn conservative_rasterization_post_depth_coverage(
        mut self,
        conservative_rasterization_post_depth_coverage: bool,
    ) -> Self {
        self.conservative_rasterization_post_depth_coverage =
            conservative_rasterization_post_depth_coverage.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCalibratedTimestampInfoKHR.html>"]
#[must_use]
pub struct CalibratedTimestampInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub time_domain: TimeDomainKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for CalibratedTimestampInfoKHR<'_> {}
unsafe impl Sync for CalibratedTimestampInfoKHR<'_> {}
impl ::core::default::Default for CalibratedTimestampInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            time_domain: TimeDomainKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for CalibratedTimestampInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::CALIBRATED_TIMESTAMP_INFO_KHR;
}
impl<'a> CalibratedTimestampInfoKHR<'a> {
    #[inline]
    pub fn time_domain(mut self, time_domain: TimeDomainKHR) -> Self {
        self.time_domain = time_domain;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShaderCorePropertiesAMD.html>"]
#[must_use]
pub struct PhysicalDeviceShaderCorePropertiesAMD<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_engine_count: u32,
    pub shader_arrays_per_engine_count: u32,
    pub compute_units_per_shader_array: u32,
    pub simd_per_compute_unit: u32,
    pub wavefronts_per_simd: u32,
    pub wavefront_size: u32,
    pub sgprs_per_simd: u32,
    pub min_sgpr_allocation: u32,
    pub max_sgpr_allocation: u32,
    pub sgpr_allocation_granularity: u32,
    pub vgprs_per_simd: u32,
    pub min_vgpr_allocation: u32,
    pub max_vgpr_allocation: u32,
    pub vgpr_allocation_granularity: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceShaderCorePropertiesAMD<'_> {}
unsafe impl Sync for PhysicalDeviceShaderCorePropertiesAMD<'_> {}
impl ::core::default::Default for PhysicalDeviceShaderCorePropertiesAMD<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shader_engine_count: u32::default(),
            shader_arrays_per_engine_count: u32::default(),
            compute_units_per_shader_array: u32::default(),
            simd_per_compute_unit: u32::default(),
            wavefronts_per_simd: u32::default(),
            wavefront_size: u32::default(),
            sgprs_per_simd: u32::default(),
            min_sgpr_allocation: u32::default(),
            max_sgpr_allocation: u32::default(),
            sgpr_allocation_granularity: u32::default(),
            vgprs_per_simd: u32::default(),
            min_vgpr_allocation: u32::default(),
            max_vgpr_allocation: u32::default(),
            vgpr_allocation_granularity: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceShaderCorePropertiesAMD<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceShaderCorePropertiesAMD<'_> {}
impl<'a> PhysicalDeviceShaderCorePropertiesAMD<'a> {
    #[inline]
    pub fn shader_engine_count(mut self, shader_engine_count: u32) -> Self {
        self.shader_engine_count = shader_engine_count;
        self
    }
    #[inline]
    pub fn shader_arrays_per_engine_count(mut self, shader_arrays_per_engine_count: u32) -> Self {
        self.shader_arrays_per_engine_count = shader_arrays_per_engine_count;
        self
    }
    #[inline]
    pub fn compute_units_per_shader_array(mut self, compute_units_per_shader_array: u32) -> Self {
        self.compute_units_per_shader_array = compute_units_per_shader_array;
        self
    }
    #[inline]
    pub fn simd_per_compute_unit(mut self, simd_per_compute_unit: u32) -> Self {
        self.simd_per_compute_unit = simd_per_compute_unit;
        self
    }
    #[inline]
    pub fn wavefronts_per_simd(mut self, wavefronts_per_simd: u32) -> Self {
        self.wavefronts_per_simd = wavefronts_per_simd;
        self
    }
    #[inline]
    pub fn wavefront_size(mut self, wavefront_size: u32) -> Self {
        self.wavefront_size = wavefront_size;
        self
    }
    #[inline]
    pub fn sgprs_per_simd(mut self, sgprs_per_simd: u32) -> Self {
        self.sgprs_per_simd = sgprs_per_simd;
        self
    }
    #[inline]
    pub fn min_sgpr_allocation(mut self, min_sgpr_allocation: u32) -> Self {
        self.min_sgpr_allocation = min_sgpr_allocation;
        self
    }
    #[inline]
    pub fn max_sgpr_allocation(mut self, max_sgpr_allocation: u32) -> Self {
        self.max_sgpr_allocation = max_sgpr_allocation;
        self
    }
    #[inline]
    pub fn sgpr_allocation_granularity(mut self, sgpr_allocation_granularity: u32) -> Self {
        self.sgpr_allocation_granularity = sgpr_allocation_granularity;
        self
    }
    #[inline]
    pub fn vgprs_per_simd(mut self, vgprs_per_simd: u32) -> Self {
        self.vgprs_per_simd = vgprs_per_simd;
        self
    }
    #[inline]
    pub fn min_vgpr_allocation(mut self, min_vgpr_allocation: u32) -> Self {
        self.min_vgpr_allocation = min_vgpr_allocation;
        self
    }
    #[inline]
    pub fn max_vgpr_allocation(mut self, max_vgpr_allocation: u32) -> Self {
        self.max_vgpr_allocation = max_vgpr_allocation;
        self
    }
    #[inline]
    pub fn vgpr_allocation_granularity(mut self, vgpr_allocation_granularity: u32) -> Self {
        self.vgpr_allocation_granularity = vgpr_allocation_granularity;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShaderCoreProperties2AMD.html>"]
#[must_use]
pub struct PhysicalDeviceShaderCoreProperties2AMD<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_core_features: ShaderCorePropertiesFlagsAMD,
    pub active_compute_unit_count: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceShaderCoreProperties2AMD<'_> {}
unsafe impl Sync for PhysicalDeviceShaderCoreProperties2AMD<'_> {}
impl ::core::default::Default for PhysicalDeviceShaderCoreProperties2AMD<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shader_core_features: ShaderCorePropertiesFlagsAMD::default(),
            active_compute_unit_count: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceShaderCoreProperties2AMD<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceShaderCoreProperties2AMD<'_> {}
impl<'a> PhysicalDeviceShaderCoreProperties2AMD<'a> {
    #[inline]
    pub fn shader_core_features(
        mut self,
        shader_core_features: ShaderCorePropertiesFlagsAMD,
    ) -> Self {
        self.shader_core_features = shader_core_features;
        self
    }
    #[inline]
    pub fn active_compute_unit_count(mut self, active_compute_unit_count: u32) -> Self {
        self.active_compute_unit_count = active_compute_unit_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationConservativeStateCreateInfoEXT.html>"]
#[must_use]
pub struct PipelineRasterizationConservativeStateCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineRasterizationConservativeStateCreateFlagsEXT,
    pub conservative_rasterization_mode: ConservativeRasterizationModeEXT,
    pub extra_primitive_overestimation_size: f32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineRasterizationConservativeStateCreateInfoEXT<'_> {}
unsafe impl Sync for PipelineRasterizationConservativeStateCreateInfoEXT<'_> {}
impl ::core::default::Default for PipelineRasterizationConservativeStateCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineRasterizationConservativeStateCreateFlagsEXT::default(),
            conservative_rasterization_mode: ConservativeRasterizationModeEXT::default(),
            extra_primitive_overestimation_size: f32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineRasterizationConservativeStateCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT;
}
unsafe impl ExtendsPipelineRasterizationStateCreateInfo
    for PipelineRasterizationConservativeStateCreateInfoEXT<'_>
{
}
impl<'a> PipelineRasterizationConservativeStateCreateInfoEXT<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineRasterizationConservativeStateCreateFlagsEXT) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn conservative_rasterization_mode(
        mut self,
        conservative_rasterization_mode: ConservativeRasterizationModeEXT,
    ) -> Self {
        self.conservative_rasterization_mode = conservative_rasterization_mode;
        self
    }
    #[inline]
    pub fn extra_primitive_overestimation_size(
        mut self,
        extra_primitive_overestimation_size: f32,
    ) -> Self {
        self.extra_primitive_overestimation_size = extra_primitive_overestimation_size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html>"]
#[must_use]
pub struct PhysicalDeviceDescriptorIndexingFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_input_attachment_array_dynamic_indexing: Bool32,
    pub shader_uniform_texel_buffer_array_dynamic_indexing: Bool32,
    pub shader_storage_texel_buffer_array_dynamic_indexing: Bool32,
    pub shader_uniform_buffer_array_non_uniform_indexing: Bool32,
    pub shader_sampled_image_array_non_uniform_indexing: Bool32,
    pub shader_storage_buffer_array_non_uniform_indexing: Bool32,
    pub shader_storage_image_array_non_uniform_indexing: Bool32,
    pub shader_input_attachment_array_non_uniform_indexing: Bool32,
    pub shader_uniform_texel_buffer_array_non_uniform_indexing: Bool32,
    pub shader_storage_texel_buffer_array_non_uniform_indexing: Bool32,
    pub descriptor_binding_uniform_buffer_update_after_bind: Bool32,
    pub descriptor_binding_sampled_image_update_after_bind: Bool32,
    pub descriptor_binding_storage_image_update_after_bind: Bool32,
    pub descriptor_binding_storage_buffer_update_after_bind: Bool32,
    pub descriptor_binding_uniform_texel_buffer_update_after_bind: Bool32,
    pub descriptor_binding_storage_texel_buffer_update_after_bind: Bool32,
    pub descriptor_binding_update_unused_while_pending: Bool32,
    pub descriptor_binding_partially_bound: Bool32,
    pub descriptor_binding_variable_descriptor_count: Bool32,
    pub runtime_descriptor_array: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceDescriptorIndexingFeatures<'_> {}
unsafe impl Sync for PhysicalDeviceDescriptorIndexingFeatures<'_> {}
impl ::core::default::Default for PhysicalDeviceDescriptorIndexingFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shader_input_attachment_array_dynamic_indexing: Bool32::default(),
            shader_uniform_texel_buffer_array_dynamic_indexing: Bool32::default(),
            shader_storage_texel_buffer_array_dynamic_indexing: Bool32::default(),
            shader_uniform_buffer_array_non_uniform_indexing: Bool32::default(),
            shader_sampled_image_array_non_uniform_indexing: Bool32::default(),
            shader_storage_buffer_array_non_uniform_indexing: Bool32::default(),
            shader_storage_image_array_non_uniform_indexing: Bool32::default(),
            shader_input_attachment_array_non_uniform_indexing: Bool32::default(),
            shader_uniform_texel_buffer_array_non_uniform_indexing: Bool32::default(),
            shader_storage_texel_buffer_array_non_uniform_indexing: Bool32::default(),
            descriptor_binding_uniform_buffer_update_after_bind: Bool32::default(),
            descriptor_binding_sampled_image_update_after_bind: Bool32::default(),
            descriptor_binding_storage_image_update_after_bind: Bool32::default(),
            descriptor_binding_storage_buffer_update_after_bind: Bool32::default(),
            descriptor_binding_uniform_texel_buffer_update_after_bind: Bool32::default(),
            descriptor_binding_storage_texel_buffer_update_after_bind: Bool32::default(),
            descriptor_binding_update_unused_while_pending: Bool32::default(),
            descriptor_binding_partially_bound: Bool32::default(),
            descriptor_binding_variable_descriptor_count: Bool32::default(),
            runtime_descriptor_array: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceDescriptorIndexingFeatures<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceDescriptorIndexingFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDescriptorIndexingFeatures<'_> {}
impl<'a> PhysicalDeviceDescriptorIndexingFeatures<'a> {
    #[inline]
    pub fn shader_input_attachment_array_dynamic_indexing(
        mut self,
        shader_input_attachment_array_dynamic_indexing: bool,
    ) -> Self {
        self.shader_input_attachment_array_dynamic_indexing =
            shader_input_attachment_array_dynamic_indexing.into();
        self
    }
    #[inline]
    pub fn shader_uniform_texel_buffer_array_dynamic_indexing(
        mut self,
        shader_uniform_texel_buffer_array_dynamic_indexing: bool,
    ) -> Self {
        self.shader_uniform_texel_buffer_array_dynamic_indexing =
            shader_uniform_texel_buffer_array_dynamic_indexing.into();
        self
    }
    #[inline]
    pub fn shader_storage_texel_buffer_array_dynamic_indexing(
        mut self,
        shader_storage_texel_buffer_array_dynamic_indexing: bool,
    ) -> Self {
        self.shader_storage_texel_buffer_array_dynamic_indexing =
            shader_storage_texel_buffer_array_dynamic_indexing.into();
        self
    }
    #[inline]
    pub fn shader_uniform_buffer_array_non_uniform_indexing(
        mut self,
        shader_uniform_buffer_array_non_uniform_indexing: bool,
    ) -> Self {
        self.shader_uniform_buffer_array_non_uniform_indexing =
            shader_uniform_buffer_array_non_uniform_indexing.into();
        self
    }
    #[inline]
    pub fn shader_sampled_image_array_non_uniform_indexing(
        mut self,
        shader_sampled_image_array_non_uniform_indexing: bool,
    ) -> Self {
        self.shader_sampled_image_array_non_uniform_indexing =
            shader_sampled_image_array_non_uniform_indexing.into();
        self
    }
    #[inline]
    pub fn shader_storage_buffer_array_non_uniform_indexing(
        mut self,
        shader_storage_buffer_array_non_uniform_indexing: bool,
    ) -> Self {
        self.shader_storage_buffer_array_non_uniform_indexing =
            shader_storage_buffer_array_non_uniform_indexing.into();
        self
    }
    #[inline]
    pub fn shader_storage_image_array_non_uniform_indexing(
        mut self,
        shader_storage_image_array_non_uniform_indexing: bool,
    ) -> Self {
        self.shader_storage_image_array_non_uniform_indexing =
            shader_storage_image_array_non_uniform_indexing.into();
        self
    }
    #[inline]
    pub fn shader_input_attachment_array_non_uniform_indexing(
        mut self,
        shader_input_attachment_array_non_uniform_indexing: bool,
    ) -> Self {
        self.shader_input_attachment_array_non_uniform_indexing =
            shader_input_attachment_array_non_uniform_indexing.into();
        self
    }
    #[inline]
    pub fn shader_uniform_texel_buffer_array_non_uniform_indexing(
        mut self,
        shader_uniform_texel_buffer_array_non_uniform_indexing: bool,
    ) -> Self {
        self.shader_uniform_texel_buffer_array_non_uniform_indexing =
            shader_uniform_texel_buffer_array_non_uniform_indexing.into();
        self
    }
    #[inline]
    pub fn shader_storage_texel_buffer_array_non_uniform_indexing(
        mut self,
        shader_storage_texel_buffer_array_non_uniform_indexing: bool,
    ) -> Self {
        self.shader_storage_texel_buffer_array_non_uniform_indexing =
            shader_storage_texel_buffer_array_non_uniform_indexing.into();
        self
    }
    #[inline]
    pub fn descriptor_binding_uniform_buffer_update_after_bind(
        mut self,
        descriptor_binding_uniform_buffer_update_after_bind: bool,
    ) -> Self {
        self.descriptor_binding_uniform_buffer_update_after_bind =
            descriptor_binding_uniform_buffer_update_after_bind.into();
        self
    }
    #[inline]
    pub fn descriptor_binding_sampled_image_update_after_bind(
        mut self,
        descriptor_binding_sampled_image_update_after_bind: bool,
    ) -> Self {
        self.descriptor_binding_sampled_image_update_after_bind =
            descriptor_binding_sampled_image_update_after_bind.into();
        self
    }
    #[inline]
    pub fn descriptor_binding_storage_image_update_after_bind(
        mut self,
        descriptor_binding_storage_image_update_after_bind: bool,
    ) -> Self {
        self.descriptor_binding_storage_image_update_after_bind =
            descriptor_binding_storage_image_update_after_bind.into();
        self
    }
    #[inline]
    pub fn descriptor_binding_storage_buffer_update_after_bind(
        mut self,
        descriptor_binding_storage_buffer_update_after_bind: bool,
    ) -> Self {
        self.descriptor_binding_storage_buffer_update_after_bind =
            descriptor_binding_storage_buffer_update_after_bind.into();
        self
    }
    #[inline]
    pub fn descriptor_binding_uniform_texel_buffer_update_after_bind(
        mut self,
        descriptor_binding_uniform_texel_buffer_update_after_bind: bool,
    ) -> Self {
        self.descriptor_binding_uniform_texel_buffer_update_after_bind =
            descriptor_binding_uniform_texel_buffer_update_after_bind.into();
        self
    }
    #[inline]
    pub fn descriptor_binding_storage_texel_buffer_update_after_bind(
        mut self,
        descriptor_binding_storage_texel_buffer_update_after_bind: bool,
    ) -> Self {
        self.descriptor_binding_storage_texel_buffer_update_after_bind =
            descriptor_binding_storage_texel_buffer_update_after_bind.into();
        self
    }
    #[inline]
    pub fn descriptor_binding_update_unused_while_pending(
        mut self,
        descriptor_binding_update_unused_while_pending: bool,
    ) -> Self {
        self.descriptor_binding_update_unused_while_pending =
            descriptor_binding_update_unused_while_pending.into();
        self
    }
    #[inline]
    pub fn descriptor_binding_partially_bound(
        mut self,
        descriptor_binding_partially_bound: bool,
    ) -> Self {
        self.descriptor_binding_partially_bound = descriptor_binding_partially_bound.into();
        self
    }
    #[inline]
    pub fn descriptor_binding_variable_descriptor_count(
        mut self,
        descriptor_binding_variable_descriptor_count: bool,
    ) -> Self {
        self.descriptor_binding_variable_descriptor_count =
            descriptor_binding_variable_descriptor_count.into();
        self
    }
    #[inline]
    pub fn runtime_descriptor_array(mut self, runtime_descriptor_array: bool) -> Self {
        self.runtime_descriptor_array = runtime_descriptor_array.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDescriptorIndexingProperties.html>"]
#[must_use]
pub struct PhysicalDeviceDescriptorIndexingProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_update_after_bind_descriptors_in_all_pools: u32,
    pub shader_uniform_buffer_array_non_uniform_indexing_native: Bool32,
    pub shader_sampled_image_array_non_uniform_indexing_native: Bool32,
    pub shader_storage_buffer_array_non_uniform_indexing_native: Bool32,
    pub shader_storage_image_array_non_uniform_indexing_native: Bool32,
    pub shader_input_attachment_array_non_uniform_indexing_native: Bool32,
    pub robust_buffer_access_update_after_bind: Bool32,
    pub quad_divergent_implicit_lod: Bool32,
    pub max_per_stage_descriptor_update_after_bind_samplers: u32,
    pub max_per_stage_descriptor_update_after_bind_uniform_buffers: u32,
    pub max_per_stage_descriptor_update_after_bind_storage_buffers: u32,
    pub max_per_stage_descriptor_update_after_bind_sampled_images: u32,
    pub max_per_stage_descriptor_update_after_bind_storage_images: u32,
    pub max_per_stage_descriptor_update_after_bind_input_attachments: u32,
    pub max_per_stage_update_after_bind_resources: u32,
    pub max_descriptor_set_update_after_bind_samplers: u32,
    pub max_descriptor_set_update_after_bind_uniform_buffers: u32,
    pub max_descriptor_set_update_after_bind_uniform_buffers_dynamic: u32,
    pub max_descriptor_set_update_after_bind_storage_buffers: u32,
    pub max_descriptor_set_update_after_bind_storage_buffers_dynamic: u32,
    pub max_descriptor_set_update_after_bind_sampled_images: u32,
    pub max_descriptor_set_update_after_bind_storage_images: u32,
    pub max_descriptor_set_update_after_bind_input_attachments: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceDescriptorIndexingProperties<'_> {}
unsafe impl Sync for PhysicalDeviceDescriptorIndexingProperties<'_> {}
impl ::core::default::Default for PhysicalDeviceDescriptorIndexingProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_update_after_bind_descriptors_in_all_pools: u32::default(),
            shader_uniform_buffer_array_non_uniform_indexing_native: Bool32::default(),
            shader_sampled_image_array_non_uniform_indexing_native: Bool32::default(),
            shader_storage_buffer_array_non_uniform_indexing_native: Bool32::default(),
            shader_storage_image_array_non_uniform_indexing_native: Bool32::default(),
            shader_input_attachment_array_non_uniform_indexing_native: Bool32::default(),
            robust_buffer_access_update_after_bind: Bool32::default(),
            quad_divergent_implicit_lod: Bool32::default(),
            max_per_stage_descriptor_update_after_bind_samplers: u32::default(),
            max_per_stage_descriptor_update_after_bind_uniform_buffers: u32::default(),
            max_per_stage_descriptor_update_after_bind_storage_buffers: u32::default(),
            max_per_stage_descriptor_update_after_bind_sampled_images: u32::default(),
            max_per_stage_descriptor_update_after_bind_storage_images: u32::default(),
            max_per_stage_descriptor_update_after_bind_input_attachments: u32::default(),
            max_per_stage_update_after_bind_resources: u32::default(),
            max_descriptor_set_update_after_bind_samplers: u32::default(),
            max_descriptor_set_update_after_bind_uniform_buffers: u32::default(),
            max_descriptor_set_update_after_bind_uniform_buffers_dynamic: u32::default(),
            max_descriptor_set_update_after_bind_storage_buffers: u32::default(),
            max_descriptor_set_update_after_bind_storage_buffers_dynamic: u32::default(),
            max_descriptor_set_update_after_bind_sampled_images: u32::default(),
            max_descriptor_set_update_after_bind_storage_images: u32::default(),
            max_descriptor_set_update_after_bind_input_attachments: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceDescriptorIndexingProperties<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDescriptorIndexingProperties<'_> {}
impl<'a> PhysicalDeviceDescriptorIndexingProperties<'a> {
    #[inline]
    pub fn max_update_after_bind_descriptors_in_all_pools(
        mut self,
        max_update_after_bind_descriptors_in_all_pools: u32,
    ) -> Self {
        self.max_update_after_bind_descriptors_in_all_pools =
            max_update_after_bind_descriptors_in_all_pools;
        self
    }
    #[inline]
    pub fn shader_uniform_buffer_array_non_uniform_indexing_native(
        mut self,
        shader_uniform_buffer_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.shader_uniform_buffer_array_non_uniform_indexing_native =
            shader_uniform_buffer_array_non_uniform_indexing_native.into();
        self
    }
    #[inline]
    pub fn shader_sampled_image_array_non_uniform_indexing_native(
        mut self,
        shader_sampled_image_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.shader_sampled_image_array_non_uniform_indexing_native =
            shader_sampled_image_array_non_uniform_indexing_native.into();
        self
    }
    #[inline]
    pub fn shader_storage_buffer_array_non_uniform_indexing_native(
        mut self,
        shader_storage_buffer_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.shader_storage_buffer_array_non_uniform_indexing_native =
            shader_storage_buffer_array_non_uniform_indexing_native.into();
        self
    }
    #[inline]
    pub fn shader_storage_image_array_non_uniform_indexing_native(
        mut self,
        shader_storage_image_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.shader_storage_image_array_non_uniform_indexing_native =
            shader_storage_image_array_non_uniform_indexing_native.into();
        self
    }
    #[inline]
    pub fn shader_input_attachment_array_non_uniform_indexing_native(
        mut self,
        shader_input_attachment_array_non_uniform_indexing_native: bool,
    ) -> Self {
        self.shader_input_attachment_array_non_uniform_indexing_native =
            shader_input_attachment_array_non_uniform_indexing_native.into();
        self
    }
    #[inline]
    pub fn robust_buffer_access_update_after_bind(
        mut self,
        robust_buffer_access_update_after_bind: bool,
    ) -> Self {
        self.robust_buffer_access_update_after_bind = robust_buffer_access_update_after_bind.into();
        self
    }
    #[inline]
    pub fn quad_divergent_implicit_lod(mut self, quad_divergent_implicit_lod: bool) -> Self {
        self.quad_divergent_implicit_lod = quad_divergent_implicit_lod.into();
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_samplers(
        mut self,
        max_per_stage_descriptor_update_after_bind_samplers: u32,
    ) -> Self {
        self.max_per_stage_descriptor_update_after_bind_samplers =
            max_per_stage_descriptor_update_after_bind_samplers;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_uniform_buffers(
        mut self,
        max_per_stage_descriptor_update_after_bind_uniform_buffers: u32,
    ) -> Self {
        self.max_per_stage_descriptor_update_after_bind_uniform_buffers =
            max_per_stage_descriptor_update_after_bind_uniform_buffers;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_storage_buffers(
        mut self,
        max_per_stage_descriptor_update_after_bind_storage_buffers: u32,
    ) -> Self {
        self.max_per_stage_descriptor_update_after_bind_storage_buffers =
            max_per_stage_descriptor_update_after_bind_storage_buffers;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_sampled_images(
        mut self,
        max_per_stage_descriptor_update_after_bind_sampled_images: u32,
    ) -> Self {
        self.max_per_stage_descriptor_update_after_bind_sampled_images =
            max_per_stage_descriptor_update_after_bind_sampled_images;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_storage_images(
        mut self,
        max_per_stage_descriptor_update_after_bind_storage_images: u32,
    ) -> Self {
        self.max_per_stage_descriptor_update_after_bind_storage_images =
            max_per_stage_descriptor_update_after_bind_storage_images;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_input_attachments(
        mut self,
        max_per_stage_descriptor_update_after_bind_input_attachments: u32,
    ) -> Self {
        self.max_per_stage_descriptor_update_after_bind_input_attachments =
            max_per_stage_descriptor_update_after_bind_input_attachments;
        self
    }
    #[inline]
    pub fn max_per_stage_update_after_bind_resources(
        mut self,
        max_per_stage_update_after_bind_resources: u32,
    ) -> Self {
        self.max_per_stage_update_after_bind_resources = max_per_stage_update_after_bind_resources;
        self
    }
    #[inline]
    pub fn max_descriptor_set_update_after_bind_samplers(
        mut self,
        max_descriptor_set_update_after_bind_samplers: u32,
    ) -> Self {
        self.max_descriptor_set_update_after_bind_samplers =
            max_descriptor_set_update_after_bind_samplers;
        self
    }
    #[inline]
    pub fn max_descriptor_set_update_after_bind_uniform_buffers(
        mut self,
        max_descriptor_set_update_after_bind_uniform_buffers: u32,
    ) -> Self {
        self.max_descriptor_set_update_after_bind_uniform_buffers =
            max_descriptor_set_update_after_bind_uniform_buffers;
        self
    }
    #[inline]
    pub fn max_descriptor_set_update_after_bind_uniform_buffers_dynamic(
        mut self,
        max_descriptor_set_update_after_bind_uniform_buffers_dynamic: u32,
    ) -> Self {
        self.max_descriptor_set_update_after_bind_uniform_buffers_dynamic =
            max_descriptor_set_update_after_bind_uniform_buffers_dynamic;
        self
    }
    #[inline]
    pub fn max_descriptor_set_update_after_bind_storage_buffers(
        mut self,
        max_descriptor_set_update_after_bind_storage_buffers: u32,
    ) -> Self {
        self.max_descriptor_set_update_after_bind_storage_buffers =
            max_descriptor_set_update_after_bind_storage_buffers;
        self
    }
    #[inline]
    pub fn max_descriptor_set_update_after_bind_storage_buffers_dynamic(
        mut self,
        max_descriptor_set_update_after_bind_storage_buffers_dynamic: u32,
    ) -> Self {
        self.max_descriptor_set_update_after_bind_storage_buffers_dynamic =
            max_descriptor_set_update_after_bind_storage_buffers_dynamic;
        self
    }
    #[inline]
    pub fn max_descriptor_set_update_after_bind_sampled_images(
        mut self,
        max_descriptor_set_update_after_bind_sampled_images: u32,
    ) -> Self {
        self.max_descriptor_set_update_after_bind_sampled_images =
            max_descriptor_set_update_after_bind_sampled_images;
        self
    }
    #[inline]
    pub fn max_descriptor_set_update_after_bind_storage_images(
        mut self,
        max_descriptor_set_update_after_bind_storage_images: u32,
    ) -> Self {
        self.max_descriptor_set_update_after_bind_storage_images =
            max_descriptor_set_update_after_bind_storage_images;
        self
    }
    #[inline]
    pub fn max_descriptor_set_update_after_bind_input_attachments(
        mut self,
        max_descriptor_set_update_after_bind_input_attachments: u32,
    ) -> Self {
        self.max_descriptor_set_update_after_bind_input_attachments =
            max_descriptor_set_update_after_bind_input_attachments;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetLayoutBindingFlagsCreateInfo.html>"]
#[must_use]
pub struct DescriptorSetLayoutBindingFlagsCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub binding_count: u32,
    pub p_binding_flags: *const DescriptorBindingFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DescriptorSetLayoutBindingFlagsCreateInfo<'_> {}
unsafe impl Sync for DescriptorSetLayoutBindingFlagsCreateInfo<'_> {}
impl ::core::default::Default for DescriptorSetLayoutBindingFlagsCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            binding_count: u32::default(),
            p_binding_flags: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DescriptorSetLayoutBindingFlagsCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO;
}
unsafe impl ExtendsDescriptorSetLayoutCreateInfo for DescriptorSetLayoutBindingFlagsCreateInfo<'_> {}
impl<'a> DescriptorSetLayoutBindingFlagsCreateInfo<'a> {
    #[inline]
    pub fn binding_flags(mut self, binding_flags: &'a [DescriptorBindingFlags]) -> Self {
        self.binding_count = binding_flags.len() as _;
        self.p_binding_flags = binding_flags.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetVariableDescriptorCountAllocateInfo.html>"]
#[must_use]
pub struct DescriptorSetVariableDescriptorCountAllocateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub descriptor_set_count: u32,
    pub p_descriptor_counts: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DescriptorSetVariableDescriptorCountAllocateInfo<'_> {}
unsafe impl Sync for DescriptorSetVariableDescriptorCountAllocateInfo<'_> {}
impl ::core::default::Default for DescriptorSetVariableDescriptorCountAllocateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            descriptor_set_count: u32::default(),
            p_descriptor_counts: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DescriptorSetVariableDescriptorCountAllocateInfo<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO;
}
unsafe impl ExtendsDescriptorSetAllocateInfo
    for DescriptorSetVariableDescriptorCountAllocateInfo<'_>
{
}
impl<'a> DescriptorSetVariableDescriptorCountAllocateInfo<'a> {
    #[inline]
    pub fn descriptor_counts(mut self, descriptor_counts: &'a [u32]) -> Self {
        self.descriptor_set_count = descriptor_counts.len() as _;
        self.p_descriptor_counts = descriptor_counts.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetVariableDescriptorCountLayoutSupport.html>"]
#[must_use]
pub struct DescriptorSetVariableDescriptorCountLayoutSupport<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_variable_descriptor_count: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DescriptorSetVariableDescriptorCountLayoutSupport<'_> {}
unsafe impl Sync for DescriptorSetVariableDescriptorCountLayoutSupport<'_> {}
impl ::core::default::Default for DescriptorSetVariableDescriptorCountLayoutSupport<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_variable_descriptor_count: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DescriptorSetVariableDescriptorCountLayoutSupport<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT;
}
unsafe impl ExtendsDescriptorSetLayoutSupport
    for DescriptorSetVariableDescriptorCountLayoutSupport<'_>
{
}
impl<'a> DescriptorSetVariableDescriptorCountLayoutSupport<'a> {
    #[inline]
    pub fn max_variable_descriptor_count(mut self, max_variable_descriptor_count: u32) -> Self {
        self.max_variable_descriptor_count = max_variable_descriptor_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAttachmentDescription2.html>"]
#[must_use]
pub struct AttachmentDescription2<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: AttachmentDescriptionFlags,
    pub format: Format,
    pub samples: SampleCountFlags,
    pub load_op: AttachmentLoadOp,
    pub store_op: AttachmentStoreOp,
    pub stencil_load_op: AttachmentLoadOp,
    pub stencil_store_op: AttachmentStoreOp,
    pub initial_layout: ImageLayout,
    pub final_layout: ImageLayout,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for AttachmentDescription2<'_> {}
unsafe impl Sync for AttachmentDescription2<'_> {}
impl ::core::default::Default for AttachmentDescription2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: AttachmentDescriptionFlags::default(),
            format: Format::default(),
            samples: SampleCountFlags::default(),
            load_op: AttachmentLoadOp::default(),
            store_op: AttachmentStoreOp::default(),
            stencil_load_op: AttachmentLoadOp::default(),
            stencil_store_op: AttachmentStoreOp::default(),
            initial_layout: ImageLayout::default(),
            final_layout: ImageLayout::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for AttachmentDescription2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::ATTACHMENT_DESCRIPTION_2;
}
pub unsafe trait ExtendsAttachmentDescription2 {}
impl<'a> AttachmentDescription2<'a> {
    #[inline]
    pub fn flags(mut self, flags: AttachmentDescriptionFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.format = format;
        self
    }
    #[inline]
    pub fn samples(mut self, samples: SampleCountFlags) -> Self {
        self.samples = samples;
        self
    }
    #[inline]
    pub fn load_op(mut self, load_op: AttachmentLoadOp) -> Self {
        self.load_op = load_op;
        self
    }
    #[inline]
    pub fn store_op(mut self, store_op: AttachmentStoreOp) -> Self {
        self.store_op = store_op;
        self
    }
    #[inline]
    pub fn stencil_load_op(mut self, stencil_load_op: AttachmentLoadOp) -> Self {
        self.stencil_load_op = stencil_load_op;
        self
    }
    #[inline]
    pub fn stencil_store_op(mut self, stencil_store_op: AttachmentStoreOp) -> Self {
        self.stencil_store_op = stencil_store_op;
        self
    }
    #[inline]
    pub fn initial_layout(mut self, initial_layout: ImageLayout) -> Self {
        self.initial_layout = initial_layout;
        self
    }
    #[inline]
    pub fn final_layout(mut self, final_layout: ImageLayout) -> Self {
        self.final_layout = final_layout;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsAttachmentDescription2 + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAttachmentReference2.html>"]
#[must_use]
pub struct AttachmentReference2<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub attachment: u32,
    pub layout: ImageLayout,
    pub aspect_mask: ImageAspectFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for AttachmentReference2<'_> {}
unsafe impl Sync for AttachmentReference2<'_> {}
impl ::core::default::Default for AttachmentReference2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            attachment: u32::default(),
            layout: ImageLayout::default(),
            aspect_mask: ImageAspectFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for AttachmentReference2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::ATTACHMENT_REFERENCE_2;
}
pub unsafe trait ExtendsAttachmentReference2 {}
impl<'a> AttachmentReference2<'a> {
    #[inline]
    pub fn attachment(mut self, attachment: u32) -> Self {
        self.attachment = attachment;
        self
    }
    #[inline]
    pub fn layout(mut self, layout: ImageLayout) -> Self {
        self.layout = layout;
        self
    }
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.aspect_mask = aspect_mask;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsAttachmentReference2 + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSubpassDescription2.html>"]
#[must_use]
pub struct SubpassDescription2<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: SubpassDescriptionFlags,
    pub pipeline_bind_point: PipelineBindPoint,
    pub view_mask: u32,
    pub input_attachment_count: u32,
    pub p_input_attachments: *const AttachmentReference2<'a>,
    pub color_attachment_count: u32,
    pub p_color_attachments: *const AttachmentReference2<'a>,
    pub p_resolve_attachments: *const AttachmentReference2<'a>,
    pub p_depth_stencil_attachment: *const AttachmentReference2<'a>,
    pub preserve_attachment_count: u32,
    pub p_preserve_attachments: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SubpassDescription2<'_> {}
unsafe impl Sync for SubpassDescription2<'_> {}
impl ::core::default::Default for SubpassDescription2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: SubpassDescriptionFlags::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            view_mask: u32::default(),
            input_attachment_count: u32::default(),
            p_input_attachments: ::core::ptr::null(),
            color_attachment_count: u32::default(),
            p_color_attachments: ::core::ptr::null(),
            p_resolve_attachments: ::core::ptr::null(),
            p_depth_stencil_attachment: ::core::ptr::null(),
            preserve_attachment_count: u32::default(),
            p_preserve_attachments: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SubpassDescription2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SUBPASS_DESCRIPTION_2;
}
pub unsafe trait ExtendsSubpassDescription2 {}
impl<'a> SubpassDescription2<'a> {
    #[inline]
    pub fn flags(mut self, flags: SubpassDescriptionFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.pipeline_bind_point = pipeline_bind_point;
        self
    }
    #[inline]
    pub fn view_mask(mut self, view_mask: u32) -> Self {
        self.view_mask = view_mask;
        self
    }
    #[inline]
    pub fn input_attachments(mut self, input_attachments: &'a [AttachmentReference2<'a>]) -> Self {
        self.input_attachment_count = input_attachments.len() as _;
        self.p_input_attachments = input_attachments.as_ptr();
        self
    }
    #[inline]
    pub fn color_attachments(mut self, color_attachments: &'a [AttachmentReference2<'a>]) -> Self {
        self.color_attachment_count = color_attachments.len() as _;
        self.p_color_attachments = color_attachments.as_ptr();
        self
    }
    #[inline]
    pub fn resolve_attachments(
        mut self,
        resolve_attachments: &'a [AttachmentReference2<'a>],
    ) -> Self {
        self.color_attachment_count = resolve_attachments.len() as _;
        self.p_resolve_attachments = resolve_attachments.as_ptr();
        self
    }
    #[inline]
    pub fn depth_stencil_attachment(
        mut self,
        depth_stencil_attachment: &'a AttachmentReference2<'a>,
    ) -> Self {
        self.p_depth_stencil_attachment = depth_stencil_attachment;
        self
    }
    #[inline]
    pub fn preserve_attachments(mut self, preserve_attachments: &'a [u32]) -> Self {
        self.preserve_attachment_count = preserve_attachments.len() as _;
        self.p_preserve_attachments = preserve_attachments.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSubpassDescription2 + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSubpassDependency2.html>"]
#[must_use]
pub struct SubpassDependency2<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_subpass: u32,
    pub dst_subpass: u32,
    pub src_stage_mask: PipelineStageFlags,
    pub dst_stage_mask: PipelineStageFlags,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub dependency_flags: DependencyFlags,
    pub view_offset: i32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SubpassDependency2<'_> {}
unsafe impl Sync for SubpassDependency2<'_> {}
impl ::core::default::Default for SubpassDependency2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            src_subpass: u32::default(),
            dst_subpass: u32::default(),
            src_stage_mask: PipelineStageFlags::default(),
            dst_stage_mask: PipelineStageFlags::default(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
            dependency_flags: DependencyFlags::default(),
            view_offset: i32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SubpassDependency2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SUBPASS_DEPENDENCY_2;
}
pub unsafe trait ExtendsSubpassDependency2 {}
impl<'a> SubpassDependency2<'a> {
    #[inline]
    pub fn src_subpass(mut self, src_subpass: u32) -> Self {
        self.src_subpass = src_subpass;
        self
    }
    #[inline]
    pub fn dst_subpass(mut self, dst_subpass: u32) -> Self {
        self.dst_subpass = dst_subpass;
        self
    }
    #[inline]
    pub fn src_stage_mask(mut self, src_stage_mask: PipelineStageFlags) -> Self {
        self.src_stage_mask = src_stage_mask;
        self
    }
    #[inline]
    pub fn dst_stage_mask(mut self, dst_stage_mask: PipelineStageFlags) -> Self {
        self.dst_stage_mask = dst_stage_mask;
        self
    }
    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> Self {
        self.src_access_mask = src_access_mask;
        self
    }
    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> Self {
        self.dst_access_mask = dst_access_mask;
        self
    }
    #[inline]
    pub fn dependency_flags(mut self, dependency_flags: DependencyFlags) -> Self {
        self.dependency_flags = dependency_flags;
        self
    }
    #[inline]
    pub fn view_offset(mut self, view_offset: i32) -> Self {
        self.view_offset = view_offset;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSubpassDependency2 + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRenderPassCreateInfo2.html>"]
#[must_use]
pub struct RenderPassCreateInfo2<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: RenderPassCreateFlags,
    pub attachment_count: u32,
    pub p_attachments: *const AttachmentDescription2<'a>,
    pub subpass_count: u32,
    pub p_subpasses: *const SubpassDescription2<'a>,
    pub dependency_count: u32,
    pub p_dependencies: *const SubpassDependency2<'a>,
    pub correlated_view_mask_count: u32,
    pub p_correlated_view_masks: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for RenderPassCreateInfo2<'_> {}
unsafe impl Sync for RenderPassCreateInfo2<'_> {}
impl ::core::default::Default for RenderPassCreateInfo2<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: RenderPassCreateFlags::default(),
            attachment_count: u32::default(),
            p_attachments: ::core::ptr::null(),
            subpass_count: u32::default(),
            p_subpasses: ::core::ptr::null(),
            dependency_count: u32::default(),
            p_dependencies: ::core::ptr::null(),
            correlated_view_mask_count: u32::default(),
            p_correlated_view_masks: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for RenderPassCreateInfo2<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::RENDER_PASS_CREATE_INFO_2;
}
pub unsafe trait ExtendsRenderPassCreateInfo2 {}
impl<'a> RenderPassCreateInfo2<'a> {
    #[inline]
    pub fn flags(mut self, flags: RenderPassCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn attachments(mut self, attachments: &'a [AttachmentDescription2<'a>]) -> Self {
        self.attachment_count = attachments.len() as _;
        self.p_attachments = attachments.as_ptr();
        self
    }
    #[inline]
    pub fn subpasses(mut self, subpasses: &'a [SubpassDescription2<'a>]) -> Self {
        self.subpass_count = subpasses.len() as _;
        self.p_subpasses = subpasses.as_ptr();
        self
    }
    #[inline]
    pub fn dependencies(mut self, dependencies: &'a [SubpassDependency2<'a>]) -> Self {
        self.dependency_count = dependencies.len() as _;
        self.p_dependencies = dependencies.as_ptr();
        self
    }
    #[inline]
    pub fn correlated_view_masks(mut self, correlated_view_masks: &'a [u32]) -> Self {
        self.correlated_view_mask_count = correlated_view_masks.len() as _;
        self.p_correlated_view_masks = correlated_view_masks.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsRenderPassCreateInfo2 + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSubpassBeginInfo.html>"]
#[must_use]
pub struct SubpassBeginInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub contents: SubpassContents,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SubpassBeginInfo<'_> {}
unsafe impl Sync for SubpassBeginInfo<'_> {}
impl ::core::default::Default for SubpassBeginInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            contents: SubpassContents::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SubpassBeginInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SUBPASS_BEGIN_INFO;
}
impl<'a> SubpassBeginInfo<'a> {
    #[inline]
    pub fn contents(mut self, contents: SubpassContents) -> Self {
        self.contents = contents;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSubpassEndInfo.html>"]
#[must_use]
pub struct SubpassEndInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SubpassEndInfo<'_> {}
unsafe impl Sync for SubpassEndInfo<'_> {}
impl ::core::default::Default for SubpassEndInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SubpassEndInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SUBPASS_END_INFO;
}
pub unsafe trait ExtendsSubpassEndInfo {}
impl<'a> SubpassEndInfo<'a> {
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSubpassEndInfo + ?Sized>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceTimelineSemaphoreFeatures.html>"]
#[must_use]
pub struct PhysicalDeviceTimelineSemaphoreFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub timeline_semaphore: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceTimelineSemaphoreFeatures<'_> {}
unsafe impl Sync for PhysicalDeviceTimelineSemaphoreFeatures<'_> {}
impl ::core::default::Default for PhysicalDeviceTimelineSemaphoreFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            timeline_semaphore: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceTimelineSemaphoreFeatures<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceTimelineSemaphoreFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceTimelineSemaphoreFeatures<'_> {}
impl<'a> PhysicalDeviceTimelineSemaphoreFeatures<'a> {
    #[inline]
    pub fn timeline_semaphore(mut self, timeline_semaphore: bool) -> Self {
        self.timeline_semaphore = timeline_semaphore.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceTimelineSemaphoreProperties.html>"]
#[must_use]
pub struct PhysicalDeviceTimelineSemaphoreProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_timeline_semaphore_value_difference: u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceTimelineSemaphoreProperties<'_> {}
unsafe impl Sync for PhysicalDeviceTimelineSemaphoreProperties<'_> {}
impl ::core::default::Default for PhysicalDeviceTimelineSemaphoreProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_timeline_semaphore_value_difference: u64::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceTimelineSemaphoreProperties<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceTimelineSemaphoreProperties<'_> {}
impl<'a> PhysicalDeviceTimelineSemaphoreProperties<'a> {
    #[inline]
    pub fn max_timeline_semaphore_value_difference(
        mut self,
        max_timeline_semaphore_value_difference: u64,
    ) -> Self {
        self.max_timeline_semaphore_value_difference = max_timeline_semaphore_value_difference;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSemaphoreTypeCreateInfo.html>"]
#[must_use]
pub struct SemaphoreTypeCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore_type: SemaphoreType,
    pub initial_value: u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SemaphoreTypeCreateInfo<'_> {}
unsafe impl Sync for SemaphoreTypeCreateInfo<'_> {}
impl ::core::default::Default for SemaphoreTypeCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            semaphore_type: SemaphoreType::default(),
            initial_value: u64::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SemaphoreTypeCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SEMAPHORE_TYPE_CREATE_INFO;
}
unsafe impl ExtendsSemaphoreCreateInfo for SemaphoreTypeCreateInfo<'_> {}
unsafe impl ExtendsPhysicalDeviceExternalSemaphoreInfo for SemaphoreTypeCreateInfo<'_> {}
impl<'a> SemaphoreTypeCreateInfo<'a> {
    #[inline]
    pub fn semaphore_type(mut self, semaphore_type: SemaphoreType) -> Self {
        self.semaphore_type = semaphore_type;
        self
    }
    #[inline]
    pub fn initial_value(mut self, initial_value: u64) -> Self {
        self.initial_value = initial_value;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkTimelineSemaphoreSubmitInfo.html>"]
#[must_use]
pub struct TimelineSemaphoreSubmitInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_value_count: u32,
    pub p_wait_semaphore_values: *const u64,
    pub signal_semaphore_value_count: u32,
    pub p_signal_semaphore_values: *const u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for TimelineSemaphoreSubmitInfo<'_> {}
unsafe impl Sync for TimelineSemaphoreSubmitInfo<'_> {}
impl ::core::default::Default for TimelineSemaphoreSubmitInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            wait_semaphore_value_count: u32::default(),
            p_wait_semaphore_values: ::core::ptr::null(),
            signal_semaphore_value_count: u32::default(),
            p_signal_semaphore_values: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for TimelineSemaphoreSubmitInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::TIMELINE_SEMAPHORE_SUBMIT_INFO;
}
unsafe impl ExtendsSubmitInfo for TimelineSemaphoreSubmitInfo<'_> {}
unsafe impl ExtendsBindSparseInfo for TimelineSemaphoreSubmitInfo<'_> {}
impl<'a> TimelineSemaphoreSubmitInfo<'a> {
    #[inline]
    pub fn wait_semaphore_values(mut self, wait_semaphore_values: &'a [u64]) -> Self {
        self.wait_semaphore_value_count = wait_semaphore_values.len() as _;
        self.p_wait_semaphore_values = wait_semaphore_values.as_ptr();
        self
    }
    #[inline]
    pub fn signal_semaphore_values(mut self, signal_semaphore_values: &'a [u64]) -> Self {
        self.signal_semaphore_value_count = signal_semaphore_values.len() as _;
        self.p_signal_semaphore_values = signal_semaphore_values.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSemaphoreWaitInfo.html>"]
#[must_use]
pub struct SemaphoreWaitInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: SemaphoreWaitFlags,
    pub semaphore_count: u32,
    pub p_semaphores: *const Semaphore,
    pub p_values: *const u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SemaphoreWaitInfo<'_> {}
unsafe impl Sync for SemaphoreWaitInfo<'_> {}
impl ::core::default::Default for SemaphoreWaitInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: SemaphoreWaitFlags::default(),
            semaphore_count: u32::default(),
            p_semaphores: ::core::ptr::null(),
            p_values: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SemaphoreWaitInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SEMAPHORE_WAIT_INFO;
}
impl<'a> SemaphoreWaitInfo<'a> {
    #[inline]
    pub fn flags(mut self, flags: SemaphoreWaitFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn semaphores(mut self, semaphores: &'a [Semaphore]) -> Self {
        self.semaphore_count = semaphores.len() as _;
        self.p_semaphores = semaphores.as_ptr();
        self
    }
    #[inline]
    pub fn values(mut self, values: &'a [u64]) -> Self {
        self.semaphore_count = values.len() as _;
        self.p_values = values.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSemaphoreSignalInfo.html>"]
#[must_use]
pub struct SemaphoreSignalInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub value: u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SemaphoreSignalInfo<'_> {}
unsafe impl Sync for SemaphoreSignalInfo<'_> {}
impl ::core::default::Default for SemaphoreSignalInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            semaphore: Semaphore::default(),
            value: u64::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SemaphoreSignalInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SEMAPHORE_SIGNAL_INFO;
}
impl<'a> SemaphoreSignalInfo<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn value(mut self, value: u64) -> Self {
        self.value = value;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkVertexInputBindingDivisorDescriptionKHR.html>"]
#[must_use]
pub struct VertexInputBindingDivisorDescriptionKHR {
    pub binding: u32,
    pub divisor: u32,
}
impl VertexInputBindingDivisorDescriptionKHR {
    #[inline]
    pub fn binding(mut self, binding: u32) -> Self {
        self.binding = binding;
        self
    }
    #[inline]
    pub fn divisor(mut self, divisor: u32) -> Self {
        self.divisor = divisor;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineVertexInputDivisorStateCreateInfoKHR.html>"]
#[must_use]
pub struct PipelineVertexInputDivisorStateCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub vertex_binding_divisor_count: u32,
    pub p_vertex_binding_divisors: *const VertexInputBindingDivisorDescriptionKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineVertexInputDivisorStateCreateInfoKHR<'_> {}
unsafe impl Sync for PipelineVertexInputDivisorStateCreateInfoKHR<'_> {}
impl ::core::default::Default for PipelineVertexInputDivisorStateCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            vertex_binding_divisor_count: u32::default(),
            p_vertex_binding_divisors: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineVertexInputDivisorStateCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_KHR;
}
unsafe impl ExtendsPipelineVertexInputStateCreateInfo
    for PipelineVertexInputDivisorStateCreateInfoKHR<'_>
{
}
impl<'a> PipelineVertexInputDivisorStateCreateInfoKHR<'a> {
    #[inline]
    pub fn vertex_binding_divisors(
        mut self,
        vertex_binding_divisors: &'a [VertexInputBindingDivisorDescriptionKHR],
    ) -> Self {
        self.vertex_binding_divisor_count = vertex_binding_divisors.len() as _;
        self.p_vertex_binding_divisors = vertex_binding_divisors.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceVertexAttributeDivisorPropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_vertex_attrib_divisor: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceVertexAttributeDivisorPropertiesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceVertexAttributeDivisorPropertiesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceVertexAttributeDivisorPropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_vertex_attrib_divisor: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceVertexAttributeDivisorPropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT;
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceVertexAttributeDivisorPropertiesEXT<'_>
{
}
impl<'a> PhysicalDeviceVertexAttributeDivisorPropertiesEXT<'a> {
    #[inline]
    pub fn max_vertex_attrib_divisor(mut self, max_vertex_attrib_divisor: u32) -> Self {
        self.max_vertex_attrib_divisor = max_vertex_attrib_divisor;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceVertexAttributeDivisorPropertiesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceVertexAttributeDivisorPropertiesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_vertex_attrib_divisor: u32,
    pub supports_non_zero_first_instance: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceVertexAttributeDivisorPropertiesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceVertexAttributeDivisorPropertiesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceVertexAttributeDivisorPropertiesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_vertex_attrib_divisor: u32::default(),
            supports_non_zero_first_instance: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceVertexAttributeDivisorPropertiesKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_KHR;
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceVertexAttributeDivisorPropertiesKHR<'_>
{
}
impl<'a> PhysicalDeviceVertexAttributeDivisorPropertiesKHR<'a> {
    #[inline]
    pub fn max_vertex_attrib_divisor(mut self, max_vertex_attrib_divisor: u32) -> Self {
        self.max_vertex_attrib_divisor = max_vertex_attrib_divisor;
        self
    }
    #[inline]
    pub fn supports_non_zero_first_instance(
        mut self,
        supports_non_zero_first_instance: bool,
    ) -> Self {
        self.supports_non_zero_first_instance = supports_non_zero_first_instance.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevicePCIBusInfoPropertiesEXT.html>"]
#[must_use]
pub struct PhysicalDevicePCIBusInfoPropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub pci_domain: u32,
    pub pci_bus: u32,
    pub pci_device: u32,
    pub pci_function: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDevicePCIBusInfoPropertiesEXT<'_> {}
unsafe impl Sync for PhysicalDevicePCIBusInfoPropertiesEXT<'_> {}
impl ::core::default::Default for PhysicalDevicePCIBusInfoPropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            pci_domain: u32::default(),
            pci_bus: u32::default(),
            pci_device: u32::default(),
            pci_function: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDevicePCIBusInfoPropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDevicePCIBusInfoPropertiesEXT<'_> {}
impl<'a> PhysicalDevicePCIBusInfoPropertiesEXT<'a> {
    #[inline]
    pub fn pci_domain(mut self, pci_domain: u32) -> Self {
        self.pci_domain = pci_domain;
        self
    }
    #[inline]
    pub fn pci_bus(mut self, pci_bus: u32) -> Self {
        self.pci_bus = pci_bus;
        self
    }
    #[inline]
    pub fn pci_device(mut self, pci_device: u32) -> Self {
        self.pci_device = pci_device;
        self
    }
    #[inline]
    pub fn pci_function(mut self, pci_function: u32) -> Self {
        self.pci_function = pci_function;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImportAndroidHardwareBufferInfoANDROID.html>"]
#[must_use]
pub struct ImportAndroidHardwareBufferInfoANDROID<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub buffer: *mut AHardwareBuffer,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImportAndroidHardwareBufferInfoANDROID<'_> {}
unsafe impl Sync for ImportAndroidHardwareBufferInfoANDROID<'_> {}
impl ::core::default::Default for ImportAndroidHardwareBufferInfoANDROID<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            buffer: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImportAndroidHardwareBufferInfoANDROID<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID;
}
unsafe impl ExtendsMemoryAllocateInfo for ImportAndroidHardwareBufferInfoANDROID<'_> {}
impl<'a> ImportAndroidHardwareBufferInfoANDROID<'a> {
    #[inline]
    pub fn buffer(mut self, buffer: *mut AHardwareBuffer) -> Self {
        self.buffer = buffer;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAndroidHardwareBufferUsageANDROID.html>"]
#[must_use]
pub struct AndroidHardwareBufferUsageANDROID<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub android_hardware_buffer_usage: u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for AndroidHardwareBufferUsageANDROID<'_> {}
unsafe impl Sync for AndroidHardwareBufferUsageANDROID<'_> {}
impl ::core::default::Default for AndroidHardwareBufferUsageANDROID<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            android_hardware_buffer_usage: u64::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for AndroidHardwareBufferUsageANDROID<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::ANDROID_HARDWARE_BUFFER_USAGE_ANDROID;
}
unsafe impl ExtendsImageFormatProperties2 for AndroidHardwareBufferUsageANDROID<'_> {}
impl<'a> AndroidHardwareBufferUsageANDROID<'a> {
    #[inline]
    pub fn android_hardware_buffer_usage(mut self, android_hardware_buffer_usage: u64) -> Self {
        self.android_hardware_buffer_usage = android_hardware_buffer_usage;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAndroidHardwareBufferPropertiesANDROID.html>"]
#[must_use]
pub struct AndroidHardwareBufferPropertiesANDROID<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub allocation_size: DeviceSize,
    pub memory_type_bits: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for AndroidHardwareBufferPropertiesANDROID<'_> {}
unsafe impl Sync for AndroidHardwareBufferPropertiesANDROID<'_> {}
impl ::core::default::Default for AndroidHardwareBufferPropertiesANDROID<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            allocation_size: DeviceSize::default(),
            memory_type_bits: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for AndroidHardwareBufferPropertiesANDROID<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID;
}
pub unsafe trait ExtendsAndroidHardwareBufferPropertiesANDROID {}
impl<'a> AndroidHardwareBufferPropertiesANDROID<'a> {
    #[inline]
    pub fn allocation_size(mut self, allocation_size: DeviceSize) -> Self {
        self.allocation_size = allocation_size;
        self
    }
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.memory_type_bits = memory_type_bits;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsAndroidHardwareBufferPropertiesANDROID + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkMemoryGetAndroidHardwareBufferInfoANDROID.html>"]
#[must_use]
pub struct MemoryGetAndroidHardwareBufferInfoANDROID<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub memory: DeviceMemory,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for MemoryGetAndroidHardwareBufferInfoANDROID<'_> {}
unsafe impl Sync for MemoryGetAndroidHardwareBufferInfoANDROID<'_> {}
impl ::core::default::Default for MemoryGetAndroidHardwareBufferInfoANDROID<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            memory: DeviceMemory::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for MemoryGetAndroidHardwareBufferInfoANDROID<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID;
}
impl<'a> MemoryGetAndroidHardwareBufferInfoANDROID<'a> {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.memory = memory;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAndroidHardwareBufferFormatPropertiesANDROID.html>"]
#[must_use]
pub struct AndroidHardwareBufferFormatPropertiesANDROID<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub format: Format,
    pub external_format: u64,
    pub format_features: FormatFeatureFlags,
    pub sampler_ycbcr_conversion_components: ComponentMapping,
    pub suggested_ycbcr_model: SamplerYcbcrModelConversion,
    pub suggested_ycbcr_range: SamplerYcbcrRange,
    pub suggested_x_chroma_offset: ChromaLocation,
    pub suggested_y_chroma_offset: ChromaLocation,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for AndroidHardwareBufferFormatPropertiesANDROID<'_> {}
unsafe impl Sync for AndroidHardwareBufferFormatPropertiesANDROID<'_> {}
impl ::core::default::Default for AndroidHardwareBufferFormatPropertiesANDROID<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            format: Format::default(),
            external_format: u64::default(),
            format_features: FormatFeatureFlags::default(),
            sampler_ycbcr_conversion_components: ComponentMapping::default(),
            suggested_ycbcr_model: SamplerYcbcrModelConversion::default(),
            suggested_ycbcr_range: SamplerYcbcrRange::default(),
            suggested_x_chroma_offset: ChromaLocation::default(),
            suggested_y_chroma_offset: ChromaLocation::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for AndroidHardwareBufferFormatPropertiesANDROID<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID;
}
unsafe impl ExtendsAndroidHardwareBufferPropertiesANDROID
    for AndroidHardwareBufferFormatPropertiesANDROID<'_>
{
}
impl<'a> AndroidHardwareBufferFormatPropertiesANDROID<'a> {
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.format = format;
        self
    }
    #[inline]
    pub fn external_format(mut self, external_format: u64) -> Self {
        self.external_format = external_format;
        self
    }
    #[inline]
    pub fn format_features(mut self, format_features: FormatFeatureFlags) -> Self {
        self.format_features = format_features;
        self
    }
    #[inline]
    pub fn sampler_ycbcr_conversion_components(
        mut self,
        sampler_ycbcr_conversion_components: ComponentMapping,
    ) -> Self {
        self.sampler_ycbcr_conversion_components = sampler_ycbcr_conversion_components;
        self
    }
    #[inline]
    pub fn suggested_ycbcr_model(
        mut self,
        suggested_ycbcr_model: SamplerYcbcrModelConversion,
    ) -> Self {
        self.suggested_ycbcr_model = suggested_ycbcr_model;
        self
    }
    #[inline]
    pub fn suggested_ycbcr_range(mut self, suggested_ycbcr_range: SamplerYcbcrRange) -> Self {
        self.suggested_ycbcr_range = suggested_ycbcr_range;
        self
    }
    #[inline]
    pub fn suggested_x_chroma_offset(mut self, suggested_x_chroma_offset: ChromaLocation) -> Self {
        self.suggested_x_chroma_offset = suggested_x_chroma_offset;
        self
    }
    #[inline]
    pub fn suggested_y_chroma_offset(mut self, suggested_y_chroma_offset: ChromaLocation) -> Self {
        self.suggested_y_chroma_offset = suggested_y_chroma_offset;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCommandBufferInheritanceConditionalRenderingInfoEXT.html>"]
#[must_use]
pub struct CommandBufferInheritanceConditionalRenderingInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub conditional_rendering_enable: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for CommandBufferInheritanceConditionalRenderingInfoEXT<'_> {}
unsafe impl Sync for CommandBufferInheritanceConditionalRenderingInfoEXT<'_> {}
impl ::core::default::Default for CommandBufferInheritanceConditionalRenderingInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            conditional_rendering_enable: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for CommandBufferInheritanceConditionalRenderingInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT;
}
unsafe impl ExtendsCommandBufferInheritanceInfo
    for CommandBufferInheritanceConditionalRenderingInfoEXT<'_>
{
}
impl<'a> CommandBufferInheritanceConditionalRenderingInfoEXT<'a> {
    #[inline]
    pub fn conditional_rendering_enable(mut self, conditional_rendering_enable: bool) -> Self {
        self.conditional_rendering_enable = conditional_rendering_enable.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkExternalFormatANDROID.html>"]
#[must_use]
pub struct ExternalFormatANDROID<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub external_format: u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ExternalFormatANDROID<'_> {}
unsafe impl Sync for ExternalFormatANDROID<'_> {}
impl ::core::default::Default for ExternalFormatANDROID<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            external_format: u64::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ExternalFormatANDROID<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_FORMAT_ANDROID;
}
unsafe impl ExtendsImageCreateInfo for ExternalFormatANDROID<'_> {}
unsafe impl ExtendsSamplerYcbcrConversionCreateInfo for ExternalFormatANDROID<'_> {}
unsafe impl ExtendsAttachmentDescription2 for ExternalFormatANDROID<'_> {}
unsafe impl ExtendsGraphicsPipelineCreateInfo for ExternalFormatANDROID<'_> {}
unsafe impl ExtendsCommandBufferInheritanceInfo for ExternalFormatANDROID<'_> {}
impl<'a> ExternalFormatANDROID<'a> {
    #[inline]
    pub fn external_format(mut self, external_format: u64) -> Self {
        self.external_format = external_format;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevice8BitStorageFeatures.html>"]
#[must_use]
pub struct PhysicalDevice8BitStorageFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub storage_buffer8_bit_access: Bool32,
    pub uniform_and_storage_buffer8_bit_access: Bool32,
    pub storage_push_constant8: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDevice8BitStorageFeatures<'_> {}
unsafe impl Sync for PhysicalDevice8BitStorageFeatures<'_> {}
impl ::core::default::Default for PhysicalDevice8BitStorageFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            storage_buffer8_bit_access: Bool32::default(),
            uniform_and_storage_buffer8_bit_access: Bool32::default(),
            storage_push_constant8: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDevice8BitStorageFeatures<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevice8BitStorageFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevice8BitStorageFeatures<'_> {}
impl<'a> PhysicalDevice8BitStorageFeatures<'a> {
    #[inline]
    pub fn storage_buffer8_bit_access(mut self, storage_buffer8_bit_access: bool) -> Self {
        self.storage_buffer8_bit_access = storage_buffer8_bit_access.into();
        self
    }
    #[inline]
    pub fn uniform_and_storage_buffer8_bit_access(
        mut self,
        uniform_and_storage_buffer8_bit_access: bool,
    ) -> Self {
        self.uniform_and_storage_buffer8_bit_access = uniform_and_storage_buffer8_bit_access.into();
        self
    }
    #[inline]
    pub fn storage_push_constant8(mut self, storage_push_constant8: bool) -> Self {
        self.storage_push_constant8 = storage_push_constant8.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceConditionalRenderingFeaturesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceConditionalRenderingFeaturesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub conditional_rendering: Bool32,
    pub inherited_conditional_rendering: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceConditionalRenderingFeaturesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceConditionalRenderingFeaturesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceConditionalRenderingFeaturesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            conditional_rendering: Bool32::default(),
            inherited_conditional_rendering: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceConditionalRenderingFeaturesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceConditionalRenderingFeaturesEXT<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceConditionalRenderingFeaturesEXT<'_> {}
impl<'a> PhysicalDeviceConditionalRenderingFeaturesEXT<'a> {
    #[inline]
    pub fn conditional_rendering(mut self, conditional_rendering: bool) -> Self {
        self.conditional_rendering = conditional_rendering.into();
        self
    }
    #[inline]
    pub fn inherited_conditional_rendering(
        mut self,
        inherited_conditional_rendering: bool,
    ) -> Self {
        self.inherited_conditional_rendering = inherited_conditional_rendering.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceVulkanMemoryModelFeatures.html>"]
#[must_use]
pub struct PhysicalDeviceVulkanMemoryModelFeatures<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub vulkan_memory_model: Bool32,
    pub vulkan_memory_model_device_scope: Bool32,
    pub vulkan_memory_model_availability_visibility_chains: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceVulkanMemoryModelFeatures<'_> {}
unsafe impl Sync for PhysicalDeviceVulkanMemoryModelFeatures<'_> {}
impl ::core::default::Default for PhysicalDeviceVulkanMemoryModelFeatures<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            vulkan_memory_model: Bool32::default(),
            vulkan_memory_model_device_scope: Bool32::default(),
            vulkan_memory_model_availability_visibility_chains: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceVulkanMemoryModelFeatures<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceVulkanMemoryModelFeatures<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVulkanMemoryModelFeatures<'_> {}
impl<'a> PhysicalDeviceVulkanMemoryModelFeatures<'a> {
    #[inline]
    pub fn vulkan_memory_model(mut self, vulkan_memory_model: bool) -> Self {
        self.vulkan_memory_model = vulkan_memory_model.into();
        self
    }
    #[inline]
    pub fn vulkan_memory_model_device_scope(
        mut self,
        vulkan_memory_model_device_scope: bool,
    ) -> Self {
        self.vulkan_memory_model_device_scope = vulkan_memory_model_device_scope.into();
        self
    }
    #[inline]
    pub fn vulkan_memory_model_availability_visibility_chains(
        mut self,
        vulkan_memory_model_availability_visibility_chains: bool,
    ) -> Self {
        self.vulkan_memory_model_availability_visibility_chains =
            vulkan_memory_model_availability_visibility_chains.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShaderAtomicInt64Features.html>"]
#[must_use]
pub struct PhysicalDeviceShaderAtomicInt64Features<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_buffer_int64_atomics: Bool32,
    pub shader_shared_int64_atomics: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceShaderAtomicInt64Features<'_> {}
unsafe impl Sync for PhysicalDeviceShaderAtomicInt64Features<'_> {}
impl ::core::default::Default for PhysicalDeviceShaderAtomicInt64Features<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shader_buffer_int64_atomics: Bool32::default(),
            shader_shared_int64_atomics: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceShaderAtomicInt64Features<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderAtomicInt64Features<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderAtomicInt64Features<'_> {}
impl<'a> PhysicalDeviceShaderAtomicInt64Features<'a> {
    #[inline]
    pub fn shader_buffer_int64_atomics(mut self, shader_buffer_int64_atomics: bool) -> Self {
        self.shader_buffer_int64_atomics = shader_buffer_int64_atomics.into();
        self
    }
    #[inline]
    pub fn shader_shared_int64_atomics(mut self, shader_shared_int64_atomics: bool) -> Self {
        self.shader_shared_int64_atomics = shader_shared_int64_atomics.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShaderAtomicFloatFeaturesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceShaderAtomicFloatFeaturesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_buffer_float32_atomics: Bool32,
    pub shader_buffer_float32_atomic_add: Bool32,
    pub shader_buffer_float64_atomics: Bool32,
    pub shader_buffer_float64_atomic_add: Bool32,
    pub shader_shared_float32_atomics: Bool32,
    pub shader_shared_float32_atomic_add: Bool32,
    pub shader_shared_float64_atomics: Bool32,
    pub shader_shared_float64_atomic_add: Bool32,
    pub shader_image_float32_atomics: Bool32,
    pub shader_image_float32_atomic_add: Bool32,
    pub sparse_image_float32_atomics: Bool32,
    pub sparse_image_float32_atomic_add: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceShaderAtomicFloatFeaturesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceShaderAtomicFloatFeaturesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceShaderAtomicFloatFeaturesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shader_buffer_float32_atomics: Bool32::default(),
            shader_buffer_float32_atomic_add: Bool32::default(),
            shader_buffer_float64_atomics: Bool32::default(),
            shader_buffer_float64_atomic_add: Bool32::default(),
            shader_shared_float32_atomics: Bool32::default(),
            shader_shared_float32_atomic_add: Bool32::default(),
            shader_shared_float64_atomics: Bool32::default(),
            shader_shared_float64_atomic_add: Bool32::default(),
            shader_image_float32_atomics: Bool32::default(),
            shader_image_float32_atomic_add: Bool32::default(),
            sparse_image_float32_atomics: Bool32::default(),
            sparse_image_float32_atomic_add: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceShaderAtomicFloatFeaturesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderAtomicFloatFeaturesEXT<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderAtomicFloatFeaturesEXT<'_> {}
impl<'a> PhysicalDeviceShaderAtomicFloatFeaturesEXT<'a> {
    #[inline]
    pub fn shader_buffer_float32_atomics(mut self, shader_buffer_float32_atomics: bool) -> Self {
        self.shader_buffer_float32_atomics = shader_buffer_float32_atomics.into();
        self
    }
    #[inline]
    pub fn shader_buffer_float32_atomic_add(
        mut self,
        shader_buffer_float32_atomic_add: bool,
    ) -> Self {
        self.shader_buffer_float32_atomic_add = shader_buffer_float32_atomic_add.into();
        self
    }
    #[inline]
    pub fn shader_buffer_float64_atomics(mut self, shader_buffer_float64_atomics: bool) -> Self {
        self.shader_buffer_float64_atomics = shader_buffer_float64_atomics.into();
        self
    }
    #[inline]
    pub fn shader_buffer_float64_atomic_add(
        mut self,
        shader_buffer_float64_atomic_add: bool,
    ) -> Self {
        self.shader_buffer_float64_atomic_add = shader_buffer_float64_atomic_add.into();
        self
    }
    #[inline]
    pub fn shader_shared_float32_atomics(mut self, shader_shared_float32_atomics: bool) -> Self {
        self.shader_shared_float32_atomics = shader_shared_float32_atomics.into();
        self
    }
    #[inline]
    pub fn shader_shared_float32_atomic_add(
        mut self,
        shader_shared_float32_atomic_add: bool,
    ) -> Self {
        self.shader_shared_float32_atomic_add = shader_shared_float32_atomic_add.into();
        self
    }
    #[inline]
    pub fn shader_shared_float64_atomics(mut self, shader_shared_float64_atomics: bool) -> Self {
        self.shader_shared_float64_atomics = shader_shared_float64_atomics.into();
        self
    }
    #[inline]
    pub fn shader_shared_float64_atomic_add(
        mut self,
        shader_shared_float64_atomic_add: bool,
    ) -> Self {
        self.shader_shared_float64_atomic_add = shader_shared_float64_atomic_add.into();
        self
    }
    #[inline]
    pub fn shader_image_float32_atomics(mut self, shader_image_float32_atomics: bool) -> Self {
        self.shader_image_float32_atomics = shader_image_float32_atomics.into();
        self
    }
    #[inline]
    pub fn shader_image_float32_atomic_add(
        mut self,
        shader_image_float32_atomic_add: bool,
    ) -> Self {
        self.shader_image_float32_atomic_add = shader_image_float32_atomic_add.into();
        self
    }
    #[inline]
    pub fn sparse_image_float32_atomics(mut self, sparse_image_float32_atomics: bool) -> Self {
        self.sparse_image_float32_atomics = sparse_image_float32_atomics.into();
        self
    }
    #[inline]
    pub fn sparse_image_float32_atomic_add(
        mut self,
        sparse_image_float32_atomic_add: bool,
    ) -> Self {
        self.sparse_image_float32_atomic_add = sparse_image_float32_atomic_add.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceShaderAtomicFloat2FeaturesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_buffer_float16_atomics: Bool32,
    pub shader_buffer_float16_atomic_add: Bool32,
    pub shader_buffer_float16_atomic_min_max: Bool32,
    pub shader_buffer_float32_atomic_min_max: Bool32,
    pub shader_buffer_float64_atomic_min_max: Bool32,
    pub shader_shared_float16_atomics: Bool32,
    pub shader_shared_float16_atomic_add: Bool32,
    pub shader_shared_float16_atomic_min_max: Bool32,
    pub shader_shared_float32_atomic_min_max: Bool32,
    pub shader_shared_float64_atomic_min_max: Bool32,
    pub shader_image_float32_atomic_min_max: Bool32,
    pub sparse_image_float32_atomic_min_max: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceShaderAtomicFloat2FeaturesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceShaderAtomicFloat2FeaturesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceShaderAtomicFloat2FeaturesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shader_buffer_float16_atomics: Bool32::default(),
            shader_buffer_float16_atomic_add: Bool32::default(),
            shader_buffer_float16_atomic_min_max: Bool32::default(),
            shader_buffer_float32_atomic_min_max: Bool32::default(),
            shader_buffer_float64_atomic_min_max: Bool32::default(),
            shader_shared_float16_atomics: Bool32::default(),
            shader_shared_float16_atomic_add: Bool32::default(),
            shader_shared_float16_atomic_min_max: Bool32::default(),
            shader_shared_float32_atomic_min_max: Bool32::default(),
            shader_shared_float64_atomic_min_max: Bool32::default(),
            shader_image_float32_atomic_min_max: Bool32::default(),
            sparse_image_float32_atomic_min_max: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceShaderAtomicFloat2FeaturesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderAtomicFloat2FeaturesEXT<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderAtomicFloat2FeaturesEXT<'_> {}
impl<'a> PhysicalDeviceShaderAtomicFloat2FeaturesEXT<'a> {
    #[inline]
    pub fn shader_buffer_float16_atomics(mut self, shader_buffer_float16_atomics: bool) -> Self {
        self.shader_buffer_float16_atomics = shader_buffer_float16_atomics.into();
        self
    }
    #[inline]
    pub fn shader_buffer_float16_atomic_add(
        mut self,
        shader_buffer_float16_atomic_add: bool,
    ) -> Self {
        self.shader_buffer_float16_atomic_add = shader_buffer_float16_atomic_add.into();
        self
    }
    #[inline]
    pub fn shader_buffer_float16_atomic_min_max(
        mut self,
        shader_buffer_float16_atomic_min_max: bool,
    ) -> Self {
        self.shader_buffer_float16_atomic_min_max = shader_buffer_float16_atomic_min_max.into();
        self
    }
    #[inline]
    pub fn shader_buffer_float32_atomic_min_max(
        mut self,
        shader_buffer_float32_atomic_min_max: bool,
    ) -> Self {
        self.shader_buffer_float32_atomic_min_max = shader_buffer_float32_atomic_min_max.into();
        self
    }
    #[inline]
    pub fn shader_buffer_float64_atomic_min_max(
        mut self,
        shader_buffer_float64_atomic_min_max: bool,
    ) -> Self {
        self.shader_buffer_float64_atomic_min_max = shader_buffer_float64_atomic_min_max.into();
        self
    }
    #[inline]
    pub fn shader_shared_float16_atomics(mut self, shader_shared_float16_atomics: bool) -> Self {
        self.shader_shared_float16_atomics = shader_shared_float16_atomics.into();
        self
    }
    #[inline]
    pub fn shader_shared_float16_atomic_add(
        mut self,
        shader_shared_float16_atomic_add: bool,
    ) -> Self {
        self.shader_shared_float16_atomic_add = shader_shared_float16_atomic_add.into();
        self
    }
    #[inline]
    pub fn shader_shared_float16_atomic_min_max(
        mut self,
        shader_shared_float16_atomic_min_max: bool,
    ) -> Self {
        self.shader_shared_float16_atomic_min_max = shader_shared_float16_atomic_min_max.into();
        self
    }
    #[inline]
    pub fn shader_shared_float32_atomic_min_max(
        mut self,
        shader_shared_float32_atomic_min_max: bool,
    ) -> Self {
        self.shader_shared_float32_atomic_min_max = shader_shared_float32_atomic_min_max.into();
        self
    }
    #[inline]
    pub fn shader_shared_float64_atomic_min_max(
        mut self,
        shader_shared_float64_atomic_min_max: bool,
    ) -> Self {
        self.shader_shared_float64_atomic_min_max = shader_shared_float64_atomic_min_max.into();
        self
    }
    #[inline]
    pub fn shader_image_float32_atomic_min_max(
        mut self,
        shader_image_float32_atomic_min_max: bool,
    ) -> Self {
        self.shader_image_float32_atomic_min_max = shader_image_float32_atomic_min_max.into();
        self
    }
    #[inline]
    pub fn sparse_image_float32_atomic_min_max(
        mut self,
        sparse_image_float32_atomic_min_max: bool,
    ) -> Self {
        self.sparse_image_float32_atomic_min_max = sparse_image_float32_atomic_min_max.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceVertexAttributeDivisorFeaturesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub vertex_attribute_instance_rate_divisor: Bool32,
    pub vertex_attribute_instance_rate_zero_divisor: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceVertexAttributeDivisorFeaturesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceVertexAttributeDivisorFeaturesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceVertexAttributeDivisorFeaturesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            vertex_attribute_instance_rate_divisor: Bool32::default(),
            vertex_attribute_instance_rate_zero_divisor: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceVertexAttributeDivisorFeaturesKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_KHR;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceVertexAttributeDivisorFeaturesKHR<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVertexAttributeDivisorFeaturesKHR<'_> {}
impl<'a> PhysicalDeviceVertexAttributeDivisorFeaturesKHR<'a> {
    #[inline]
    pub fn vertex_attribute_instance_rate_divisor(
        mut self,
        vertex_attribute_instance_rate_divisor: bool,
    ) -> Self {
        self.vertex_attribute_instance_rate_divisor = vertex_attribute_instance_rate_divisor.into();
        self
    }
    #[inline]
    pub fn vertex_attribute_instance_rate_zero_divisor(
        mut self,
        vertex_attribute_instance_rate_zero_divisor: bool,
    ) -> Self {
        self.vertex_attribute_instance_rate_zero_divisor =
            vertex_attribute_instance_rate_zero_divisor.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkQueueFamilyCheckpointPropertiesNV.html>"]
#[must_use]
pub struct QueueFamilyCheckpointPropertiesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub checkpoint_execution_stage_mask: PipelineStageFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for QueueFamilyCheckpointPropertiesNV<'_> {}
unsafe impl Sync for QueueFamilyCheckpointPropertiesNV<'_> {}
impl ::core::default::Default for QueueFamilyCheckpointPropertiesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            checkpoint_execution_stage_mask: PipelineStageFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for QueueFamilyCheckpointPropertiesNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV;
}
unsafe impl ExtendsQueueFamilyProperties2 for QueueFamilyCheckpointPropertiesNV<'_> {}
impl<'a> QueueFamilyCheckpointPropertiesNV<'a> {
    #[inline]
    pub fn checkpoint_execution_stage_mask(
        mut self,
        checkpoint_execution_stage_mask: PipelineStageFlags,
    ) -> Self {
        self.checkpoint_execution_stage_mask = checkpoint_execution_stage_mask;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCheckpointDataNV.html>"]
#[must_use]
pub struct CheckpointDataNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub stage: PipelineStageFlags,
    pub p_checkpoint_marker: *mut c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for CheckpointDataNV<'_> {}
unsafe impl Sync for CheckpointDataNV<'_> {}
impl ::core::default::Default for CheckpointDataNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            stage: PipelineStageFlags::default(),
            p_checkpoint_marker: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for CheckpointDataNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::CHECKPOINT_DATA_NV;
}
impl<'a> CheckpointDataNV<'a> {
    #[inline]
    pub fn stage(mut self, stage: PipelineStageFlags) -> Self {
        self.stage = stage;
        self
    }
    #[inline]
    pub fn checkpoint_marker(mut self, checkpoint_marker: *mut c_void) -> Self {
        self.p_checkpoint_marker = checkpoint_marker;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDepthStencilResolveProperties.html>"]
#[must_use]
pub struct PhysicalDeviceDepthStencilResolveProperties<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub supported_depth_resolve_modes: ResolveModeFlags,
    pub supported_stencil_resolve_modes: ResolveModeFlags,
    pub independent_resolve_none: Bool32,
    pub independent_resolve: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceDepthStencilResolveProperties<'_> {}
unsafe impl Sync for PhysicalDeviceDepthStencilResolveProperties<'_> {}
impl ::core::default::Default for PhysicalDeviceDepthStencilResolveProperties<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            supported_depth_resolve_modes: ResolveModeFlags::default(),
            supported_stencil_resolve_modes: ResolveModeFlags::default(),
            independent_resolve_none: Bool32::default(),
            independent_resolve: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceDepthStencilResolveProperties<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDepthStencilResolveProperties<'_> {}
impl<'a> PhysicalDeviceDepthStencilResolveProperties<'a> {
    #[inline]
    pub fn supported_depth_resolve_modes(
        mut self,
        supported_depth_resolve_modes: ResolveModeFlags,
    ) -> Self {
        self.supported_depth_resolve_modes = supported_depth_resolve_modes;
        self
    }
    #[inline]
    pub fn supported_stencil_resolve_modes(
        mut self,
        supported_stencil_resolve_modes: ResolveModeFlags,
    ) -> Self {
        self.supported_stencil_resolve_modes = supported_stencil_resolve_modes;
        self
    }
    #[inline]
    pub fn independent_resolve_none(mut self, independent_resolve_none: bool) -> Self {
        self.independent_resolve_none = independent_resolve_none.into();
        self
    }
    #[inline]
    pub fn independent_resolve(mut self, independent_resolve: bool) -> Self {
        self.independent_resolve = independent_resolve.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSubpassDescriptionDepthStencilResolve.html>"]
#[must_use]
pub struct SubpassDescriptionDepthStencilResolve<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub depth_resolve_mode: ResolveModeFlags,
    pub stencil_resolve_mode: ResolveModeFlags,
    pub p_depth_stencil_resolve_attachment: *const AttachmentReference2<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for SubpassDescriptionDepthStencilResolve<'_> {}
unsafe impl Sync for SubpassDescriptionDepthStencilResolve<'_> {}
impl ::core::default::Default for SubpassDescriptionDepthStencilResolve<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            depth_resolve_mode: ResolveModeFlags::default(),
            stencil_resolve_mode: ResolveModeFlags::default(),
            p_depth_stencil_resolve_attachment: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for SubpassDescriptionDepthStencilResolve<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE;
}
unsafe impl ExtendsSubpassDescription2 for SubpassDescriptionDepthStencilResolve<'_> {}
impl<'a> SubpassDescriptionDepthStencilResolve<'a> {
    #[inline]
    pub fn depth_resolve_mode(mut self, depth_resolve_mode: ResolveModeFlags) -> Self {
        self.depth_resolve_mode = depth_resolve_mode;
        self
    }
    #[inline]
    pub fn stencil_resolve_mode(mut self, stencil_resolve_mode: ResolveModeFlags) -> Self {
        self.stencil_resolve_mode = stencil_resolve_mode;
        self
    }
    #[inline]
    pub fn depth_stencil_resolve_attachment(
        mut self,
        depth_stencil_resolve_attachment: &'a AttachmentReference2<'a>,
    ) -> Self {
        self.p_depth_stencil_resolve_attachment = depth_stencil_resolve_attachment;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageViewASTCDecodeModeEXT.html>"]
#[must_use]
pub struct ImageViewASTCDecodeModeEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub decode_mode: Format,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageViewASTCDecodeModeEXT<'_> {}
unsafe impl Sync for ImageViewASTCDecodeModeEXT<'_> {}
impl ::core::default::Default for ImageViewASTCDecodeModeEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            decode_mode: Format::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageViewASTCDecodeModeEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_VIEW_ASTC_DECODE_MODE_EXT;
}
unsafe impl ExtendsImageViewCreateInfo for ImageViewASTCDecodeModeEXT<'_> {}
impl<'a> ImageViewASTCDecodeModeEXT<'a> {
    #[inline]
    pub fn decode_mode(mut self, decode_mode: Format) -> Self {
        self.decode_mode = decode_mode;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceASTCDecodeFeaturesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceASTCDecodeFeaturesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub decode_mode_shared_exponent: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceASTCDecodeFeaturesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceASTCDecodeFeaturesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceASTCDecodeFeaturesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            decode_mode_shared_exponent: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceASTCDecodeFeaturesEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceASTCDecodeFeaturesEXT<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceASTCDecodeFeaturesEXT<'_> {}
impl<'a> PhysicalDeviceASTCDecodeFeaturesEXT<'a> {
    #[inline]
    pub fn decode_mode_shared_exponent(mut self, decode_mode_shared_exponent: bool) -> Self {
        self.decode_mode_shared_exponent = decode_mode_shared_exponent.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceTransformFeedbackFeaturesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceTransformFeedbackFeaturesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub transform_feedback: Bool32,
    pub geometry_streams: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceTransformFeedbackFeaturesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceTransformFeedbackFeaturesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceTransformFeedbackFeaturesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            transform_feedback: Bool32::default(),
            geometry_streams: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceTransformFeedbackFeaturesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceTransformFeedbackFeaturesEXT<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceTransformFeedbackFeaturesEXT<'_> {}
impl<'a> PhysicalDeviceTransformFeedbackFeaturesEXT<'a> {
    #[inline]
    pub fn transform_feedback(mut self, transform_feedback: bool) -> Self {
        self.transform_feedback = transform_feedback.into();
        self
    }
    #[inline]
    pub fn geometry_streams(mut self, geometry_streams: bool) -> Self {
        self.geometry_streams = geometry_streams.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceTransformFeedbackPropertiesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceTransformFeedbackPropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_transform_feedback_streams: u32,
    pub max_transform_feedback_buffers: u32,
    pub max_transform_feedback_buffer_size: DeviceSize,
    pub max_transform_feedback_stream_data_size: u32,
    pub max_transform_feedback_buffer_data_size: u32,
    pub max_transform_feedback_buffer_data_stride: u32,
    pub transform_feedback_queries: Bool32,
    pub transform_feedback_streams_lines_triangles: Bool32,
    pub transform_feedback_rasterization_stream_select: Bool32,
    pub transform_feedback_draw: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceTransformFeedbackPropertiesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceTransformFeedbackPropertiesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceTransformFeedbackPropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_transform_feedback_streams: u32::default(),
            max_transform_feedback_buffers: u32::default(),
            max_transform_feedback_buffer_size: DeviceSize::default(),
            max_transform_feedback_stream_data_size: u32::default(),
            max_transform_feedback_buffer_data_size: u32::default(),
            max_transform_feedback_buffer_data_stride: u32::default(),
            transform_feedback_queries: Bool32::default(),
            transform_feedback_streams_lines_triangles: Bool32::default(),
            transform_feedback_rasterization_stream_select: Bool32::default(),
            transform_feedback_draw: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceTransformFeedbackPropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceTransformFeedbackPropertiesEXT<'_> {}
impl<'a> PhysicalDeviceTransformFeedbackPropertiesEXT<'a> {
    #[inline]
    pub fn max_transform_feedback_streams(mut self, max_transform_feedback_streams: u32) -> Self {
        self.max_transform_feedback_streams = max_transform_feedback_streams;
        self
    }
    #[inline]
    pub fn max_transform_feedback_buffers(mut self, max_transform_feedback_buffers: u32) -> Self {
        self.max_transform_feedback_buffers = max_transform_feedback_buffers;
        self
    }
    #[inline]
    pub fn max_transform_feedback_buffer_size(
        mut self,
        max_transform_feedback_buffer_size: DeviceSize,
    ) -> Self {
        self.max_transform_feedback_buffer_size = max_transform_feedback_buffer_size;
        self
    }
    #[inline]
    pub fn max_transform_feedback_stream_data_size(
        mut self,
        max_transform_feedback_stream_data_size: u32,
    ) -> Self {
        self.max_transform_feedback_stream_data_size = max_transform_feedback_stream_data_size;
        self
    }
    #[inline]
    pub fn max_transform_feedback_buffer_data_size(
        mut self,
        max_transform_feedback_buffer_data_size: u32,
    ) -> Self {
        self.max_transform_feedback_buffer_data_size = max_transform_feedback_buffer_data_size;
        self
    }
    #[inline]
    pub fn max_transform_feedback_buffer_data_stride(
        mut self,
        max_transform_feedback_buffer_data_stride: u32,
    ) -> Self {
        self.max_transform_feedback_buffer_data_stride = max_transform_feedback_buffer_data_stride;
        self
    }
    #[inline]
    pub fn transform_feedback_queries(mut self, transform_feedback_queries: bool) -> Self {
        self.transform_feedback_queries = transform_feedback_queries.into();
        self
    }
    #[inline]
    pub fn transform_feedback_streams_lines_triangles(
        mut self,
        transform_feedback_streams_lines_triangles: bool,
    ) -> Self {
        self.transform_feedback_streams_lines_triangles =
            transform_feedback_streams_lines_triangles.into();
        self
    }
    #[inline]
    pub fn transform_feedback_rasterization_stream_select(
        mut self,
        transform_feedback_rasterization_stream_select: bool,
    ) -> Self {
        self.transform_feedback_rasterization_stream_select =
            transform_feedback_rasterization_stream_select.into();
        self
    }
    #[inline]
    pub fn transform_feedback_draw(mut self, transform_feedback_draw: bool) -> Self {
        self.transform_feedback_draw = transform_feedback_draw.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationStateStreamCreateInfoEXT.html>"]
#[must_use]
pub struct PipelineRasterizationStateStreamCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineRasterizationStateStreamCreateFlagsEXT,
    pub rasterization_stream: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineRasterizationStateStreamCreateInfoEXT<'_> {}
unsafe impl Sync for PipelineRasterizationStateStreamCreateInfoEXT<'_> {}
impl ::core::default::Default for PipelineRasterizationStateStreamCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineRasterizationStateStreamCreateFlagsEXT::default(),
            rasterization_stream: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineRasterizationStateStreamCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT;
}
unsafe impl ExtendsPipelineRasterizationStateCreateInfo
    for PipelineRasterizationStateStreamCreateInfoEXT<'_>
{
}
impl<'a> PipelineRasterizationStateStreamCreateInfoEXT<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineRasterizationStateStreamCreateFlagsEXT) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn rasterization_stream(mut self, rasterization_stream: u32) -> Self {
        self.rasterization_stream = rasterization_stream;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV.html>"]
#[must_use]
pub struct PhysicalDeviceRepresentativeFragmentTestFeaturesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub representative_fragment_test: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceRepresentativeFragmentTestFeaturesNV<'_> {}
unsafe impl Sync for PhysicalDeviceRepresentativeFragmentTestFeaturesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceRepresentativeFragmentTestFeaturesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            representative_fragment_test: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceRepresentativeFragmentTestFeaturesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV;
}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceRepresentativeFragmentTestFeaturesNV<'_>
{
}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceRepresentativeFragmentTestFeaturesNV<'_> {}
impl<'a> PhysicalDeviceRepresentativeFragmentTestFeaturesNV<'a> {
    #[inline]
    pub fn representative_fragment_test(mut self, representative_fragment_test: bool) -> Self {
        self.representative_fragment_test = representative_fragment_test.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineRepresentativeFragmentTestStateCreateInfoNV.html>"]
#[must_use]
pub struct PipelineRepresentativeFragmentTestStateCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub representative_fragment_test_enable: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineRepresentativeFragmentTestStateCreateInfoNV<'_> {}
unsafe impl Sync for PipelineRepresentativeFragmentTestStateCreateInfoNV<'_> {}
impl ::core::default::Default for PipelineRepresentativeFragmentTestStateCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            representative_fragment_test_enable: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineRepresentativeFragmentTestStateCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV;
}
unsafe impl ExtendsGraphicsPipelineCreateInfo
    for PipelineRepresentativeFragmentTestStateCreateInfoNV<'_>
{
}
impl<'a> PipelineRepresentativeFragmentTestStateCreateInfoNV<'a> {
    #[inline]
    pub fn representative_fragment_test_enable(
        mut self,
        representative_fragment_test_enable: bool,
    ) -> Self {
        self.representative_fragment_test_enable = representative_fragment_test_enable.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceExclusiveScissorFeaturesNV.html>"]
#[must_use]
pub struct PhysicalDeviceExclusiveScissorFeaturesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub exclusive_scissor: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceExclusiveScissorFeaturesNV<'_> {}
unsafe impl Sync for PhysicalDeviceExclusiveScissorFeaturesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceExclusiveScissorFeaturesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            exclusive_scissor: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceExclusiveScissorFeaturesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceExclusiveScissorFeaturesNV<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceExclusiveScissorFeaturesNV<'_> {}
impl<'a> PhysicalDeviceExclusiveScissorFeaturesNV<'a> {
    #[inline]
    pub fn exclusive_scissor(mut self, exclusive_scissor: bool) -> Self {
        self.exclusive_scissor = exclusive_scissor.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportExclusiveScissorStateCreateInfoNV.html>"]
#[must_use]
pub struct PipelineViewportExclusiveScissorStateCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub exclusive_scissor_count: u32,
    pub p_exclusive_scissors: *const Rect2D,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineViewportExclusiveScissorStateCreateInfoNV<'_> {}
unsafe impl Sync for PipelineViewportExclusiveScissorStateCreateInfoNV<'_> {}
impl ::core::default::Default for PipelineViewportExclusiveScissorStateCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            exclusive_scissor_count: u32::default(),
            p_exclusive_scissors: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineViewportExclusiveScissorStateCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV;
}
unsafe impl ExtendsPipelineViewportStateCreateInfo
    for PipelineViewportExclusiveScissorStateCreateInfoNV<'_>
{
}
impl<'a> PipelineViewportExclusiveScissorStateCreateInfoNV<'a> {
    #[inline]
    pub fn exclusive_scissors(mut self, exclusive_scissors: &'a [Rect2D]) -> Self {
        self.exclusive_scissor_count = exclusive_scissors.len() as _;
        self.p_exclusive_scissors = exclusive_scissors.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceCornerSampledImageFeaturesNV.html>"]
#[must_use]
pub struct PhysicalDeviceCornerSampledImageFeaturesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub corner_sampled_image: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceCornerSampledImageFeaturesNV<'_> {}
unsafe impl Sync for PhysicalDeviceCornerSampledImageFeaturesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceCornerSampledImageFeaturesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            corner_sampled_image: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceCornerSampledImageFeaturesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceCornerSampledImageFeaturesNV<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceCornerSampledImageFeaturesNV<'_> {}
impl<'a> PhysicalDeviceCornerSampledImageFeaturesNV<'a> {
    #[inline]
    pub fn corner_sampled_image(mut self, corner_sampled_image: bool) -> Self {
        self.corner_sampled_image = corner_sampled_image.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceComputeShaderDerivativesFeaturesNV.html>"]
#[must_use]
pub struct PhysicalDeviceComputeShaderDerivativesFeaturesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub compute_derivative_group_quads: Bool32,
    pub compute_derivative_group_linear: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceComputeShaderDerivativesFeaturesNV<'_> {}
unsafe impl Sync for PhysicalDeviceComputeShaderDerivativesFeaturesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceComputeShaderDerivativesFeaturesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            compute_derivative_group_quads: Bool32::default(),
            compute_derivative_group_linear: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceComputeShaderDerivativesFeaturesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV;
}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceComputeShaderDerivativesFeaturesNV<'_>
{
}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceComputeShaderDerivativesFeaturesNV<'_> {}
impl<'a> PhysicalDeviceComputeShaderDerivativesFeaturesNV<'a> {
    #[inline]
    pub fn compute_derivative_group_quads(mut self, compute_derivative_group_quads: bool) -> Self {
        self.compute_derivative_group_quads = compute_derivative_group_quads.into();
        self
    }
    #[inline]
    pub fn compute_derivative_group_linear(
        mut self,
        compute_derivative_group_linear: bool,
    ) -> Self {
        self.compute_derivative_group_linear = compute_derivative_group_linear.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShaderImageFootprintFeaturesNV.html>"]
#[must_use]
pub struct PhysicalDeviceShaderImageFootprintFeaturesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub image_footprint: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceShaderImageFootprintFeaturesNV<'_> {}
unsafe impl Sync for PhysicalDeviceShaderImageFootprintFeaturesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceShaderImageFootprintFeaturesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            image_footprint: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceShaderImageFootprintFeaturesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderImageFootprintFeaturesNV<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderImageFootprintFeaturesNV<'_> {}
impl<'a> PhysicalDeviceShaderImageFootprintFeaturesNV<'a> {
    #[inline]
    pub fn image_footprint(mut self, image_footprint: bool) -> Self {
        self.image_footprint = image_footprint.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV.html>"]
#[must_use]
pub struct PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub dedicated_allocation_image_aliasing: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV<'_> {}
unsafe impl Sync for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            dedicated_allocation_image_aliasing: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV;
}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV<'_>
{
}
unsafe impl ExtendsDeviceCreateInfo
    for PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV<'_>
{
}
impl<'a> PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV<'a> {
    #[inline]
    pub fn dedicated_allocation_image_aliasing(
        mut self,
        dedicated_allocation_image_aliasing: bool,
    ) -> Self {
        self.dedicated_allocation_image_aliasing = dedicated_allocation_image_aliasing.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceCopyMemoryIndirectFeaturesNV.html>"]
#[must_use]
pub struct PhysicalDeviceCopyMemoryIndirectFeaturesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub indirect_copy: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceCopyMemoryIndirectFeaturesNV<'_> {}
unsafe impl Sync for PhysicalDeviceCopyMemoryIndirectFeaturesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceCopyMemoryIndirectFeaturesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            indirect_copy: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceCopyMemoryIndirectFeaturesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceCopyMemoryIndirectFeaturesNV<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceCopyMemoryIndirectFeaturesNV<'_> {}
impl<'a> PhysicalDeviceCopyMemoryIndirectFeaturesNV<'a> {
    #[inline]
    pub fn indirect_copy(mut self, indirect_copy: bool) -> Self {
        self.indirect_copy = indirect_copy.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceCopyMemoryIndirectPropertiesNV.html>"]
#[must_use]
pub struct PhysicalDeviceCopyMemoryIndirectPropertiesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub supported_queues: QueueFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceCopyMemoryIndirectPropertiesNV<'_> {}
unsafe impl Sync for PhysicalDeviceCopyMemoryIndirectPropertiesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceCopyMemoryIndirectPropertiesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            supported_queues: QueueFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceCopyMemoryIndirectPropertiesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_PROPERTIES_NV;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceCopyMemoryIndirectPropertiesNV<'_> {}
impl<'a> PhysicalDeviceCopyMemoryIndirectPropertiesNV<'a> {
    #[inline]
    pub fn supported_queues(mut self, supported_queues: QueueFlags) -> Self {
        self.supported_queues = supported_queues;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMemoryDecompressionFeaturesNV.html>"]
#[must_use]
pub struct PhysicalDeviceMemoryDecompressionFeaturesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_decompression: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMemoryDecompressionFeaturesNV<'_> {}
unsafe impl Sync for PhysicalDeviceMemoryDecompressionFeaturesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceMemoryDecompressionFeaturesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            memory_decompression: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMemoryDecompressionFeaturesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_NV;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMemoryDecompressionFeaturesNV<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMemoryDecompressionFeaturesNV<'_> {}
impl<'a> PhysicalDeviceMemoryDecompressionFeaturesNV<'a> {
    #[inline]
    pub fn memory_decompression(mut self, memory_decompression: bool) -> Self {
        self.memory_decompression = memory_decompression.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMemoryDecompressionPropertiesNV.html>"]
#[must_use]
pub struct PhysicalDeviceMemoryDecompressionPropertiesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub decompression_methods: MemoryDecompressionMethodFlagsNV,
    pub max_decompression_indirect_count: u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMemoryDecompressionPropertiesNV<'_> {}
unsafe impl Sync for PhysicalDeviceMemoryDecompressionPropertiesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceMemoryDecompressionPropertiesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            decompression_methods: MemoryDecompressionMethodFlagsNV::default(),
            max_decompression_indirect_count: u64::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMemoryDecompressionPropertiesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_PROPERTIES_NV;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMemoryDecompressionPropertiesNV<'_> {}
impl<'a> PhysicalDeviceMemoryDecompressionPropertiesNV<'a> {
    #[inline]
    pub fn decompression_methods(
        mut self,
        decompression_methods: MemoryDecompressionMethodFlagsNV,
    ) -> Self {
        self.decompression_methods = decompression_methods;
        self
    }
    #[inline]
    pub fn max_decompression_indirect_count(
        mut self,
        max_decompression_indirect_count: u64,
    ) -> Self {
        self.max_decompression_indirect_count = max_decompression_indirect_count;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkShadingRatePaletteNV.html>"]
#[must_use]
pub struct ShadingRatePaletteNV<'a> {
    pub shading_rate_palette_entry_count: u32,
    pub p_shading_rate_palette_entries: *const ShadingRatePaletteEntryNV,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ShadingRatePaletteNV<'_> {}
unsafe impl Sync for ShadingRatePaletteNV<'_> {}
impl ::core::default::Default for ShadingRatePaletteNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            shading_rate_palette_entry_count: u32::default(),
            p_shading_rate_palette_entries: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
impl<'a> ShadingRatePaletteNV<'a> {
    #[inline]
    pub fn shading_rate_palette_entries(
        mut self,
        shading_rate_palette_entries: &'a [ShadingRatePaletteEntryNV],
    ) -> Self {
        self.shading_rate_palette_entry_count = shading_rate_palette_entries.len() as _;
        self.p_shading_rate_palette_entries = shading_rate_palette_entries.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportShadingRateImageStateCreateInfoNV.html>"]
#[must_use]
pub struct PipelineViewportShadingRateImageStateCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub shading_rate_image_enable: Bool32,
    pub viewport_count: u32,
    pub p_shading_rate_palettes: *const ShadingRatePaletteNV<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineViewportShadingRateImageStateCreateInfoNV<'_> {}
unsafe impl Sync for PipelineViewportShadingRateImageStateCreateInfoNV<'_> {}
impl ::core::default::Default for PipelineViewportShadingRateImageStateCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            shading_rate_image_enable: Bool32::default(),
            viewport_count: u32::default(),
            p_shading_rate_palettes: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineViewportShadingRateImageStateCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV;
}
unsafe impl ExtendsPipelineViewportStateCreateInfo
    for PipelineViewportShadingRateImageStateCreateInfoNV<'_>
{
}
impl<'a> PipelineViewportShadingRateImageStateCreateInfoNV<'a> {
    #[inline]
    pub fn shading_rate_image_enable(mut self, shading_rate_image_enable: bool) -> Self {
        self.shading_rate_image_enable = shading_rate_image_enable.into();
        self
    }
    #[inline]
    pub fn shading_rate_palettes(
        mut self,
        shading_rate_palettes: &'a [ShadingRatePaletteNV<'a>],
    ) -> Self {
        self.viewport_count = shading_rate_palettes.len() as _;
        self.p_shading_rate_palettes = shading_rate_palettes.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShadingRateImageFeaturesNV.html>"]
#[must_use]
pub struct PhysicalDeviceShadingRateImageFeaturesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shading_rate_image: Bool32,
    pub shading_rate_coarse_sample_order: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceShadingRateImageFeaturesNV<'_> {}
unsafe impl Sync for PhysicalDeviceShadingRateImageFeaturesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceShadingRateImageFeaturesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shading_rate_image: Bool32::default(),
            shading_rate_coarse_sample_order: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceShadingRateImageFeaturesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShadingRateImageFeaturesNV<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShadingRateImageFeaturesNV<'_> {}
impl<'a> PhysicalDeviceShadingRateImageFeaturesNV<'a> {
    #[inline]
    pub fn shading_rate_image(mut self, shading_rate_image: bool) -> Self {
        self.shading_rate_image = shading_rate_image.into();
        self
    }
    #[inline]
    pub fn shading_rate_coarse_sample_order(
        mut self,
        shading_rate_coarse_sample_order: bool,
    ) -> Self {
        self.shading_rate_coarse_sample_order = shading_rate_coarse_sample_order.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShadingRateImagePropertiesNV.html>"]
#[must_use]
pub struct PhysicalDeviceShadingRateImagePropertiesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shading_rate_texel_size: Extent2D,
    pub shading_rate_palette_size: u32,
    pub shading_rate_max_coarse_samples: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceShadingRateImagePropertiesNV<'_> {}
unsafe impl Sync for PhysicalDeviceShadingRateImagePropertiesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceShadingRateImagePropertiesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shading_rate_texel_size: Extent2D::default(),
            shading_rate_palette_size: u32::default(),
            shading_rate_max_coarse_samples: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceShadingRateImagePropertiesNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceShadingRateImagePropertiesNV<'_> {}
impl<'a> PhysicalDeviceShadingRateImagePropertiesNV<'a> {
    #[inline]
    pub fn shading_rate_texel_size(mut self, shading_rate_texel_size: Extent2D) -> Self {
        self.shading_rate_texel_size = shading_rate_texel_size;
        self
    }
    #[inline]
    pub fn shading_rate_palette_size(mut self, shading_rate_palette_size: u32) -> Self {
        self.shading_rate_palette_size = shading_rate_palette_size;
        self
    }
    #[inline]
    pub fn shading_rate_max_coarse_samples(mut self, shading_rate_max_coarse_samples: u32) -> Self {
        self.shading_rate_max_coarse_samples = shading_rate_max_coarse_samples;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceInvocationMaskFeaturesHUAWEI.html>"]
#[must_use]
pub struct PhysicalDeviceInvocationMaskFeaturesHUAWEI<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub invocation_mask: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceInvocationMaskFeaturesHUAWEI<'_> {}
unsafe impl Sync for PhysicalDeviceInvocationMaskFeaturesHUAWEI<'_> {}
impl ::core::default::Default for PhysicalDeviceInvocationMaskFeaturesHUAWEI<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            invocation_mask: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceInvocationMaskFeaturesHUAWEI<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceInvocationMaskFeaturesHUAWEI<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceInvocationMaskFeaturesHUAWEI<'_> {}
impl<'a> PhysicalDeviceInvocationMaskFeaturesHUAWEI<'a> {
    #[inline]
    pub fn invocation_mask(mut self, invocation_mask: bool) -> Self {
        self.invocation_mask = invocation_mask.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCoarseSampleLocationNV.html>"]
#[must_use]
pub struct CoarseSampleLocationNV {
    pub pixel_x: u32,
    pub pixel_y: u32,
    pub sample: u32,
}
impl CoarseSampleLocationNV {
    #[inline]
    pub fn pixel_x(mut self, pixel_x: u32) -> Self {
        self.pixel_x = pixel_x;
        self
    }
    #[inline]
    pub fn pixel_y(mut self, pixel_y: u32) -> Self {
        self.pixel_y = pixel_y;
        self
    }
    #[inline]
    pub fn sample(mut self, sample: u32) -> Self {
        self.sample = sample;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkCoarseSampleOrderCustomNV.html>"]
#[must_use]
pub struct CoarseSampleOrderCustomNV<'a> {
    pub shading_rate: ShadingRatePaletteEntryNV,
    pub sample_count: u32,
    pub sample_location_count: u32,
    pub p_sample_locations: *const CoarseSampleLocationNV,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for CoarseSampleOrderCustomNV<'_> {}
unsafe impl Sync for CoarseSampleOrderCustomNV<'_> {}
impl ::core::default::Default for CoarseSampleOrderCustomNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            shading_rate: ShadingRatePaletteEntryNV::default(),
            sample_count: u32::default(),
            sample_location_count: u32::default(),
            p_sample_locations: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
impl<'a> CoarseSampleOrderCustomNV<'a> {
    #[inline]
    pub fn shading_rate(mut self, shading_rate: ShadingRatePaletteEntryNV) -> Self {
        self.shading_rate = shading_rate;
        self
    }
    #[inline]
    pub fn sample_count(mut self, sample_count: u32) -> Self {
        self.sample_count = sample_count;
        self
    }
    #[inline]
    pub fn sample_locations(mut self, sample_locations: &'a [CoarseSampleLocationNV]) -> Self {
        self.sample_location_count = sample_locations.len() as _;
        self.p_sample_locations = sample_locations.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportCoarseSampleOrderStateCreateInfoNV.html>"]
#[must_use]
pub struct PipelineViewportCoarseSampleOrderStateCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub sample_order_type: CoarseSampleOrderTypeNV,
    pub custom_sample_order_count: u32,
    pub p_custom_sample_orders: *const CoarseSampleOrderCustomNV<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PipelineViewportCoarseSampleOrderStateCreateInfoNV<'_> {}
unsafe impl Sync for PipelineViewportCoarseSampleOrderStateCreateInfoNV<'_> {}
impl ::core::default::Default for PipelineViewportCoarseSampleOrderStateCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            sample_order_type: CoarseSampleOrderTypeNV::default(),
            custom_sample_order_count: u32::default(),
            p_custom_sample_orders: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PipelineViewportCoarseSampleOrderStateCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV;
}
unsafe impl ExtendsPipelineViewportStateCreateInfo
    for PipelineViewportCoarseSampleOrderStateCreateInfoNV<'_>
{
}
impl<'a> PipelineViewportCoarseSampleOrderStateCreateInfoNV<'a> {
    #[inline]
    pub fn sample_order_type(mut self, sample_order_type: CoarseSampleOrderTypeNV) -> Self {
        self.sample_order_type = sample_order_type;
        self
    }
    #[inline]
    pub fn custom_sample_orders(
        mut self,
        custom_sample_orders: &'a [CoarseSampleOrderCustomNV<'a>],
    ) -> Self {
        self.custom_sample_order_count = custom_sample_orders.len() as _;
        self.p_custom_sample_orders = custom_sample_orders.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMeshShaderFeaturesNV.html>"]
#[must_use]
pub struct PhysicalDeviceMeshShaderFeaturesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub task_shader: Bool32,
    pub mesh_shader: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMeshShaderFeaturesNV<'_> {}
unsafe impl Sync for PhysicalDeviceMeshShaderFeaturesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceMeshShaderFeaturesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            task_shader: Bool32::default(),
            mesh_shader: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMeshShaderFeaturesNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMeshShaderFeaturesNV<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMeshShaderFeaturesNV<'_> {}
impl<'a> PhysicalDeviceMeshShaderFeaturesNV<'a> {
    #[inline]
    pub fn task_shader(mut self, task_shader: bool) -> Self {
        self.task_shader = task_shader.into();
        self
    }
    #[inline]
    pub fn mesh_shader(mut self, mesh_shader: bool) -> Self {
        self.mesh_shader = mesh_shader.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMeshShaderPropertiesNV.html>"]
#[must_use]
pub struct PhysicalDeviceMeshShaderPropertiesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_draw_mesh_tasks_count: u32,
    pub max_task_work_group_invocations: u32,
    pub max_task_work_group_size: [u32; 3],
    pub max_task_total_memory_size: u32,
    pub max_task_output_count: u32,
    pub max_mesh_work_group_invocations: u32,
    pub max_mesh_work_group_size: [u32; 3],
    pub max_mesh_total_memory_size: u32,
    pub max_mesh_output_vertices: u32,
    pub max_mesh_output_primitives: u32,
    pub max_mesh_multiview_view_count: u32,
    pub mesh_output_per_vertex_granularity: u32,
    pub mesh_output_per_primitive_granularity: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMeshShaderPropertiesNV<'_> {}
unsafe impl Sync for PhysicalDeviceMeshShaderPropertiesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceMeshShaderPropertiesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_draw_mesh_tasks_count: u32::default(),
            max_task_work_group_invocations: u32::default(),
            max_task_work_group_size: unsafe { ::core::mem::zeroed() },
            max_task_total_memory_size: u32::default(),
            max_task_output_count: u32::default(),
            max_mesh_work_group_invocations: u32::default(),
            max_mesh_work_group_size: unsafe { ::core::mem::zeroed() },
            max_mesh_total_memory_size: u32::default(),
            max_mesh_output_vertices: u32::default(),
            max_mesh_output_primitives: u32::default(),
            max_mesh_multiview_view_count: u32::default(),
            mesh_output_per_vertex_granularity: u32::default(),
            mesh_output_per_primitive_granularity: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMeshShaderPropertiesNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMeshShaderPropertiesNV<'_> {}
impl<'a> PhysicalDeviceMeshShaderPropertiesNV<'a> {
    #[inline]
    pub fn max_draw_mesh_tasks_count(mut self, max_draw_mesh_tasks_count: u32) -> Self {
        self.max_draw_mesh_tasks_count = max_draw_mesh_tasks_count;
        self
    }
    #[inline]
    pub fn max_task_work_group_invocations(mut self, max_task_work_group_invocations: u32) -> Self {
        self.max_task_work_group_invocations = max_task_work_group_invocations;
        self
    }
    #[inline]
    pub fn max_task_work_group_size(mut self, max_task_work_group_size: [u32; 3]) -> Self {
        self.max_task_work_group_size = max_task_work_group_size;
        self
    }
    #[inline]
    pub fn max_task_total_memory_size(mut self, max_task_total_memory_size: u32) -> Self {
        self.max_task_total_memory_size = max_task_total_memory_size;
        self
    }
    #[inline]
    pub fn max_task_output_count(mut self, max_task_output_count: u32) -> Self {
        self.max_task_output_count = max_task_output_count;
        self
    }
    #[inline]
    pub fn max_mesh_work_group_invocations(mut self, max_mesh_work_group_invocations: u32) -> Self {
        self.max_mesh_work_group_invocations = max_mesh_work_group_invocations;
        self
    }
    #[inline]
    pub fn max_mesh_work_group_size(mut self, max_mesh_work_group_size: [u32; 3]) -> Self {
        self.max_mesh_work_group_size = max_mesh_work_group_size;
        self
    }
    #[inline]
    pub fn max_mesh_total_memory_size(mut self, max_mesh_total_memory_size: u32) -> Self {
        self.max_mesh_total_memory_size = max_mesh_total_memory_size;
        self
    }
    #[inline]
    pub fn max_mesh_output_vertices(mut self, max_mesh_output_vertices: u32) -> Self {
        self.max_mesh_output_vertices = max_mesh_output_vertices;
        self
    }
    #[inline]
    pub fn max_mesh_output_primitives(mut self, max_mesh_output_primitives: u32) -> Self {
        self.max_mesh_output_primitives = max_mesh_output_primitives;
        self
    }
    #[inline]
    pub fn max_mesh_multiview_view_count(mut self, max_mesh_multiview_view_count: u32) -> Self {
        self.max_mesh_multiview_view_count = max_mesh_multiview_view_count;
        self
    }
    #[inline]
    pub fn mesh_output_per_vertex_granularity(
        mut self,
        mesh_output_per_vertex_granularity: u32,
    ) -> Self {
        self.mesh_output_per_vertex_granularity = mesh_output_per_vertex_granularity;
        self
    }
    #[inline]
    pub fn mesh_output_per_primitive_granularity(
        mut self,
        mesh_output_per_primitive_granularity: u32,
    ) -> Self {
        self.mesh_output_per_primitive_granularity = mesh_output_per_primitive_granularity;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDrawMeshTasksIndirectCommandNV.html>"]
#[must_use]
pub struct DrawMeshTasksIndirectCommandNV {
    pub task_count: u32,
    pub first_task: u32,
}
impl DrawMeshTasksIndirectCommandNV {
    #[inline]
    pub fn task_count(mut self, task_count: u32) -> Self {
        self.task_count = task_count;
        self
    }
    #[inline]
    pub fn first_task(mut self, first_task: u32) -> Self {
        self.first_task = first_task;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMeshShaderFeaturesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceMeshShaderFeaturesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub task_shader: Bool32,
    pub mesh_shader: Bool32,
    pub multiview_mesh_shader: Bool32,
    pub primitive_fragment_shading_rate_mesh_shader: Bool32,
    pub mesh_shader_queries: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMeshShaderFeaturesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceMeshShaderFeaturesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceMeshShaderFeaturesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            task_shader: Bool32::default(),
            mesh_shader: Bool32::default(),
            multiview_mesh_shader: Bool32::default(),
            primitive_fragment_shading_rate_mesh_shader: Bool32::default(),
            mesh_shader_queries: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMeshShaderFeaturesEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMeshShaderFeaturesEXT<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMeshShaderFeaturesEXT<'_> {}
impl<'a> PhysicalDeviceMeshShaderFeaturesEXT<'a> {
    #[inline]
    pub fn task_shader(mut self, task_shader: bool) -> Self {
        self.task_shader = task_shader.into();
        self
    }
    #[inline]
    pub fn mesh_shader(mut self, mesh_shader: bool) -> Self {
        self.mesh_shader = mesh_shader.into();
        self
    }
    #[inline]
    pub fn multiview_mesh_shader(mut self, multiview_mesh_shader: bool) -> Self {
        self.multiview_mesh_shader = multiview_mesh_shader.into();
        self
    }
    #[inline]
    pub fn primitive_fragment_shading_rate_mesh_shader(
        mut self,
        primitive_fragment_shading_rate_mesh_shader: bool,
    ) -> Self {
        self.primitive_fragment_shading_rate_mesh_shader =
            primitive_fragment_shading_rate_mesh_shader.into();
        self
    }
    #[inline]
    pub fn mesh_shader_queries(mut self, mesh_shader_queries: bool) -> Self {
        self.mesh_shader_queries = mesh_shader_queries.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMeshShaderPropertiesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceMeshShaderPropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_task_work_group_total_count: u32,
    pub max_task_work_group_count: [u32; 3],
    pub max_task_work_group_invocations: u32,
    pub max_task_work_group_size: [u32; 3],
    pub max_task_payload_size: u32,
    pub max_task_shared_memory_size: u32,
    pub max_task_payload_and_shared_memory_size: u32,
    pub max_mesh_work_group_total_count: u32,
    pub max_mesh_work_group_count: [u32; 3],
    pub max_mesh_work_group_invocations: u32,
    pub max_mesh_work_group_size: [u32; 3],
    pub max_mesh_shared_memory_size: u32,
    pub max_mesh_payload_and_shared_memory_size: u32,
    pub max_mesh_output_memory_size: u32,
    pub max_mesh_payload_and_output_memory_size: u32,
    pub max_mesh_output_components: u32,
    pub max_mesh_output_vertices: u32,
    pub max_mesh_output_primitives: u32,
    pub max_mesh_output_layers: u32,
    pub max_mesh_multiview_view_count: u32,
    pub mesh_output_per_vertex_granularity: u32,
    pub mesh_output_per_primitive_granularity: u32,
    pub max_preferred_task_work_group_invocations: u32,
    pub max_preferred_mesh_work_group_invocations: u32,
    pub prefers_local_invocation_vertex_output: Bool32,
    pub prefers_local_invocation_primitive_output: Bool32,
    pub prefers_compact_vertex_output: Bool32,
    pub prefers_compact_primitive_output: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceMeshShaderPropertiesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceMeshShaderPropertiesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceMeshShaderPropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_task_work_group_total_count: u32::default(),
            max_task_work_group_count: unsafe { ::core::mem::zeroed() },
            max_task_work_group_invocations: u32::default(),
            max_task_work_group_size: unsafe { ::core::mem::zeroed() },
            max_task_payload_size: u32::default(),
            max_task_shared_memory_size: u32::default(),
            max_task_payload_and_shared_memory_size: u32::default(),
            max_mesh_work_group_total_count: u32::default(),
            max_mesh_work_group_count: unsafe { ::core::mem::zeroed() },
            max_mesh_work_group_invocations: u32::default(),
            max_mesh_work_group_size: unsafe { ::core::mem::zeroed() },
            max_mesh_shared_memory_size: u32::default(),
            max_mesh_payload_and_shared_memory_size: u32::default(),
            max_mesh_output_memory_size: u32::default(),
            max_mesh_payload_and_output_memory_size: u32::default(),
            max_mesh_output_components: u32::default(),
            max_mesh_output_vertices: u32::default(),
            max_mesh_output_primitives: u32::default(),
            max_mesh_output_layers: u32::default(),
            max_mesh_multiview_view_count: u32::default(),
            mesh_output_per_vertex_granularity: u32::default(),
            mesh_output_per_primitive_granularity: u32::default(),
            max_preferred_task_work_group_invocations: u32::default(),
            max_preferred_mesh_work_group_invocations: u32::default(),
            prefers_local_invocation_vertex_output: Bool32::default(),
            prefers_local_invocation_primitive_output: Bool32::default(),
            prefers_compact_vertex_output: Bool32::default(),
            prefers_compact_primitive_output: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceMeshShaderPropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_EXT;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMeshShaderPropertiesEXT<'_> {}
impl<'a> PhysicalDeviceMeshShaderPropertiesEXT<'a> {
    #[inline]
    pub fn max_task_work_group_total_count(mut self, max_task_work_group_total_count: u32) -> Self {
        self.max_task_work_group_total_count = max_task_work_group_total_count;
        self
    }
    #[inline]
    pub fn max_task_work_group_count(mut self, max_task_work_group_count: [u32; 3]) -> Self {
        self.max_task_work_group_count = max_task_work_group_count;
        self
    }
    #[inline]
    pub fn max_task_work_group_invocations(mut self, max_task_work_group_invocations: u32) -> Self {
        self.max_task_work_group_invocations = max_task_work_group_invocations;
        self
    }
    #[inline]
    pub fn max_task_work_group_size(mut self, max_task_work_group_size: [u32; 3]) -> Self {
        self.max_task_work_group_size = max_task_work_group_size;
        self
    }
    #[inline]
    pub fn max_task_payload_size(mut self, max_task_payload_size: u32) -> Self {
        self.max_task_payload_size = max_task_payload_size;
        self
    }
    #[inline]
    pub fn max_task_shared_memory_size(mut self, max_task_shared_memory_size: u32) -> Self {
        self.max_task_shared_memory_size = max_task_shared_memory_size;
        self
    }
    #[inline]
    pub fn max_task_payload_and_shared_memory_size(
        mut self,
        max_task_payload_and_shared_memory_size: u32,
    ) -> Self {
        self.max_task_payload_and_shared_memory_size = max_task_payload_and_shared_memory_size;
        self
    }
    #[inline]
    pub fn max_mesh_work_group_total_count(mut self, max_mesh_work_group_total_count: u32) -> Self {
        self.max_mesh_work_group_total_count = max_mesh_work_group_total_count;
        self
    }
    #[inline]
    pub fn max_mesh_work_group_count(mut self, max_mesh_work_group_count: [u32; 3]) -> Self {
        self.max_mesh_work_group_count = max_mesh_work_group_count;
        self
    }
    #[inline]
    pub fn max_mesh_work_group_invocations(mut self, max_mesh_work_group_invocations: u32) -> Self {
        self.max_mesh_work_group_invocations = max_mesh_work_group_invocations;
        self
    }
    #[inline]
    pub fn max_mesh_work_group_size(mut self, max_mesh_work_group_size: [u32; 3]) -> Self {
        self.max_mesh_work_group_size = max_mesh_work_group_size;
        self
    }
    #[inline]
    pub fn max_mesh_shared_memory_size(mut self, max_mesh_shared_memory_size: u32) -> Self {
        self.max_mesh_shared_memory_size = max_mesh_shared_memory_size;
        self
    }
    #[inline]
    pub fn max_mesh_payload_and_shared_memory_size(
        mut self,
        max_mesh_payload_and_shared_memory_size: u32,
    ) -> Self {
        self.max_mesh_payload_and_shared_memory_size = max_mesh_payload_and_shared_memory_size;
        self
    }
    #[inline]
    pub fn max_mesh_output_memory_size(mut self, max_mesh_output_memory_size: u32) -> Self {
        self.max_mesh_output_memory_size = max_mesh_output_memory_size;
        self
    }
    #[inline]
    pub fn max_mesh_payload_and_output_memory_size(
        mut self,
        max_mesh_payload_and_output_memory_size: u32,
    ) -> Self {
        self.max_mesh_payload_and_output_memory_size = max_mesh_payload_and_output_memory_size;
        self
    }
    #[inline]
    pub fn max_mesh_output_components(mut self, max_mesh_output_components: u32) -> Self {
        self.max_mesh_output_components = max_mesh_output_components;
        self
    }
    #[inline]
    pub fn max_mesh_output_vertices(mut self, max_mesh_output_vertices: u32) -> Self {
        self.max_mesh_output_vertices = max_mesh_output_vertices;
        self
    }
    #[inline]
    pub fn max_mesh_output_primitives(mut self, max_mesh_output_primitives: u32) -> Self {
        self.max_mesh_output_primitives = max_mesh_output_primitives;
        self
    }
    #[inline]
    pub fn max_mesh_output_layers(mut self, max_mesh_output_layers: u32) -> Self {
        self.max_mesh_output_layers = max_mesh_output_layers;
        self
    }
    #[inline]
    pub fn max_mesh_multiview_view_count(mut self, max_mesh_multiview_view_count: u32) -> Self {
        self.max_mesh_multiview_view_count = max_mesh_multiview_view_count;
        self
    }
    #[inline]
    pub fn mesh_output_per_vertex_granularity(
        mut self,
        mesh_output_per_vertex_granularity: u32,
    ) -> Self {
        self.mesh_output_per_vertex_granularity = mesh_output_per_vertex_granularity;
        self
    }
    #[inline]
    pub fn mesh_output_per_primitive_granularity(
        mut self,
        mesh_output_per_primitive_granularity: u32,
    ) -> Self {
        self.mesh_output_per_primitive_granularity = mesh_output_per_primitive_granularity;
        self
    }
    #[inline]
    pub fn max_preferred_task_work_group_invocations(
        mut self,
        max_preferred_task_work_group_invocations: u32,
    ) -> Self {
        self.max_preferred_task_work_group_invocations = max_preferred_task_work_group_invocations;
        self
    }
    #[inline]
    pub fn max_preferred_mesh_work_group_invocations(
        mut self,
        max_preferred_mesh_work_group_invocations: u32,
    ) -> Self {
        self.max_preferred_mesh_work_group_invocations = max_preferred_mesh_work_group_invocations;
        self
    }
    #[inline]
    pub fn prefers_local_invocation_vertex_output(
        mut self,
        prefers_local_invocation_vertex_output: bool,
    ) -> Self {
        self.prefers_local_invocation_vertex_output = prefers_local_invocation_vertex_output.into();
        self
    }
    #[inline]
    pub fn prefers_local_invocation_primitive_output(
        mut self,
        prefers_local_invocation_primitive_output: bool,
    ) -> Self {
        self.prefers_local_invocation_primitive_output =
            prefers_local_invocation_primitive_output.into();
        self
    }
    #[inline]
    pub fn prefers_compact_vertex_output(mut self, prefers_compact_vertex_output: bool) -> Self {
        self.prefers_compact_vertex_output = prefers_compact_vertex_output.into();
        self
    }
    #[inline]
    pub fn prefers_compact_primitive_output(
        mut self,
        prefers_compact_primitive_output: bool,
    ) -> Self {
        self.prefers_compact_primitive_output = prefers_compact_primitive_output.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDrawMeshTasksIndirectCommandEXT.html>"]
#[must_use]
pub struct DrawMeshTasksIndirectCommandEXT {
    pub group_count_x: u32,
    pub group_count_y: u32,
    pub group_count_z: u32,
}
impl DrawMeshTasksIndirectCommandEXT {
    #[inline]
    pub fn group_count_x(mut self, group_count_x: u32) -> Self {
        self.group_count_x = group_count_x;
        self
    }
    #[inline]
    pub fn group_count_y(mut self, group_count_y: u32) -> Self {
        self.group_count_y = group_count_y;
        self
    }
    #[inline]
    pub fn group_count_z(mut self, group_count_z: u32) -> Self {
        self.group_count_z = group_count_z;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRayTracingShaderGroupCreateInfoNV.html>"]
#[must_use]
pub struct RayTracingShaderGroupCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub ty: RayTracingShaderGroupTypeKHR,
    pub general_shader: u32,
    pub closest_hit_shader: u32,
    pub any_hit_shader: u32,
    pub intersection_shader: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for RayTracingShaderGroupCreateInfoNV<'_> {}
unsafe impl Sync for RayTracingShaderGroupCreateInfoNV<'_> {}
impl ::core::default::Default for RayTracingShaderGroupCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            ty: RayTracingShaderGroupTypeKHR::default(),
            general_shader: u32::default(),
            closest_hit_shader: u32::default(),
            any_hit_shader: u32::default(),
            intersection_shader: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for RayTracingShaderGroupCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV;
}
impl<'a> RayTracingShaderGroupCreateInfoNV<'a> {
    #[inline]
    pub fn ty(mut self, ty: RayTracingShaderGroupTypeKHR) -> Self {
        self.ty = ty;
        self
    }
    #[inline]
    pub fn general_shader(mut self, general_shader: u32) -> Self {
        self.general_shader = general_shader;
        self
    }
    #[inline]
    pub fn closest_hit_shader(mut self, closest_hit_shader: u32) -> Self {
        self.closest_hit_shader = closest_hit_shader;
        self
    }
    #[inline]
    pub fn any_hit_shader(mut self, any_hit_shader: u32) -> Self {
        self.any_hit_shader = any_hit_shader;
        self
    }
    #[inline]
    pub fn intersection_shader(mut self, intersection_shader: u32) -> Self {
        self.intersection_shader = intersection_shader;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRayTracingShaderGroupCreateInfoKHR.html>"]
#[must_use]
pub struct RayTracingShaderGroupCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub ty: RayTracingShaderGroupTypeKHR,
    pub general_shader: u32,
    pub closest_hit_shader: u32,
    pub any_hit_shader: u32,
    pub intersection_shader: u32,
    pub p_shader_group_capture_replay_handle: *const c_void,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for RayTracingShaderGroupCreateInfoKHR<'_> {}
unsafe impl Sync for RayTracingShaderGroupCreateInfoKHR<'_> {}
impl ::core::default::Default for RayTracingShaderGroupCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            ty: RayTracingShaderGroupTypeKHR::default(),
            general_shader: u32::default(),
            closest_hit_shader: u32::default(),
            any_hit_shader: u32::default(),
            intersection_shader: u32::default(),
            p_shader_group_capture_replay_handle: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for RayTracingShaderGroupCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR;
}
impl<'a> RayTracingShaderGroupCreateInfoKHR<'a> {
    #[inline]
    pub fn ty(mut self, ty: RayTracingShaderGroupTypeKHR) -> Self {
        self.ty = ty;
        self
    }
    #[inline]
    pub fn general_shader(mut self, general_shader: u32) -> Self {
        self.general_shader = general_shader;
        self
    }
    #[inline]
    pub fn closest_hit_shader(mut self, closest_hit_shader: u32) -> Self {
        self.closest_hit_shader = closest_hit_shader;
        self
    }
    #[inline]
    pub fn any_hit_shader(mut self, any_hit_shader: u32) -> Self {
        self.any_hit_shader = any_hit_shader;
        self
    }
    #[inline]
    pub fn intersection_shader(mut self, intersection_shader: u32) -> Self {
        self.intersection_shader = intersection_shader;
        self
    }
    #[inline]
    pub fn shader_group_capture_replay_handle(
        mut self,
        shader_group_capture_replay_handle: *const c_void,
    ) -> Self {
        self.p_shader_group_capture_replay_handle = shader_group_capture_replay_handle;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRayTracingPipelineCreateInfoNV.html>"]
#[must_use]
pub struct RayTracingPipelineCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage_count: u32,
    pub p_stages: *const PipelineShaderStageCreateInfo<'a>,
    pub group_count: u32,
    pub p_groups: *const RayTracingShaderGroupCreateInfoNV<'a>,
    pub max_recursion_depth: u32,
    pub layout: PipelineLayout,
    pub base_pipeline_handle: Pipeline,
    pub base_pipeline_index: i32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for RayTracingPipelineCreateInfoNV<'_> {}
unsafe impl Sync for RayTracingPipelineCreateInfoNV<'_> {}
impl ::core::default::Default for RayTracingPipelineCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineCreateFlags::default(),
            stage_count: u32::default(),
            p_stages: ::core::ptr::null(),
            group_count: u32::default(),
            p_groups: ::core::ptr::null(),
            max_recursion_depth: u32::default(),
            layout: PipelineLayout::default(),
            base_pipeline_handle: Pipeline::default(),
            base_pipeline_index: i32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for RayTracingPipelineCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::RAY_TRACING_PIPELINE_CREATE_INFO_NV;
}
pub unsafe trait ExtendsRayTracingPipelineCreateInfoNV {}
impl<'a> RayTracingPipelineCreateInfoNV<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn stages(mut self, stages: &'a [PipelineShaderStageCreateInfo<'a>]) -> Self {
        self.stage_count = stages.len() as _;
        self.p_stages = stages.as_ptr();
        self
    }
    #[inline]
    pub fn groups(mut self, groups: &'a [RayTracingShaderGroupCreateInfoNV<'a>]) -> Self {
        self.group_count = groups.len() as _;
        self.p_groups = groups.as_ptr();
        self
    }
    #[inline]
    pub fn max_recursion_depth(mut self, max_recursion_depth: u32) -> Self {
        self.max_recursion_depth = max_recursion_depth;
        self
    }
    #[inline]
    pub fn layout(mut self, layout: PipelineLayout) -> Self {
        self.layout = layout;
        self
    }
    #[inline]
    pub fn base_pipeline_handle(mut self, base_pipeline_handle: Pipeline) -> Self {
        self.base_pipeline_handle = base_pipeline_handle;
        self
    }
    #[inline]
    pub fn base_pipeline_index(mut self, base_pipeline_index: i32) -> Self {
        self.base_pipeline_index = base_pipeline_index;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsRayTracingPipelineCreateInfoNV + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkRayTracingPipelineCreateInfoKHR.html>"]
#[must_use]
pub struct RayTracingPipelineCreateInfoKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage_count: u32,
    pub p_stages: *const PipelineShaderStageCreateInfo<'a>,
    pub group_count: u32,
    pub p_groups: *const RayTracingShaderGroupCreateInfoKHR<'a>,
    pub max_pipeline_ray_recursion_depth: u32,
    pub p_library_info: *const PipelineLibraryCreateInfoKHR<'a>,
    pub p_library_interface: *const RayTracingPipelineInterfaceCreateInfoKHR<'a>,
    pub p_dynamic_state: *const PipelineDynamicStateCreateInfo<'a>,
    pub layout: PipelineLayout,
    pub base_pipeline_handle: Pipeline,
    pub base_pipeline_index: i32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for RayTracingPipelineCreateInfoKHR<'_> {}
unsafe impl Sync for RayTracingPipelineCreateInfoKHR<'_> {}
impl ::core::default::Default for RayTracingPipelineCreateInfoKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            flags: PipelineCreateFlags::default(),
            stage_count: u32::default(),
            p_stages: ::core::ptr::null(),
            group_count: u32::default(),
            p_groups: ::core::ptr::null(),
            max_pipeline_ray_recursion_depth: u32::default(),
            p_library_info: ::core::ptr::null(),
            p_library_interface: ::core::ptr::null(),
            p_dynamic_state: ::core::ptr::null(),
            layout: PipelineLayout::default(),
            base_pipeline_handle: Pipeline::default(),
            base_pipeline_index: i32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for RayTracingPipelineCreateInfoKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::RAY_TRACING_PIPELINE_CREATE_INFO_KHR;
}
pub unsafe trait ExtendsRayTracingPipelineCreateInfoKHR {}
impl<'a> RayTracingPipelineCreateInfoKHR<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCreateFlags) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn stages(mut self, stages: &'a [PipelineShaderStageCreateInfo<'a>]) -> Self {
        self.stage_count = stages.len() as _;
        self.p_stages = stages.as_ptr();
        self
    }
    #[inline]
    pub fn groups(mut self, groups: &'a [RayTracingShaderGroupCreateInfoKHR<'a>]) -> Self {
        self.group_count = groups.len() as _;
        self.p_groups = groups.as_ptr();
        self
    }
    #[inline]
    pub fn max_pipeline_ray_recursion_depth(
        mut self,
        max_pipeline_ray_recursion_depth: u32,
    ) -> Self {
        self.max_pipeline_ray_recursion_depth = max_pipeline_ray_recursion_depth;
        self
    }
    #[inline]
    pub fn library_info(mut self, library_info: &'a PipelineLibraryCreateInfoKHR<'a>) -> Self {
        self.p_library_info = library_info;
        self
    }
    #[inline]
    pub fn library_interface(
        mut self,
        library_interface: &'a RayTracingPipelineInterfaceCreateInfoKHR<'a>,
    ) -> Self {
        self.p_library_interface = library_interface;
        self
    }
    #[inline]
    pub fn dynamic_state(mut self, dynamic_state: &'a PipelineDynamicStateCreateInfo<'a>) -> Self {
        self.p_dynamic_state = dynamic_state;
        self
    }
    #[inline]
    pub fn layout(mut self, layout: PipelineLayout) -> Self {
        self.layout = layout;
        self
    }
    #[inline]
    pub fn base_pipeline_handle(mut self, base_pipeline_handle: Pipeline) -> Self {
        self.base_pipeline_handle = base_pipeline_handle;
        self
    }
    #[inline]
    pub fn base_pipeline_index(mut self, base_pipeline_index: i32) -> Self {
        self.base_pipeline_index = base_pipeline_index;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsRayTracingPipelineCreateInfoKHR + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkGeometryTrianglesNV.html>"]
#[must_use]
pub struct GeometryTrianglesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub vertex_data: Buffer,
    pub vertex_offset: DeviceSize,
    pub vertex_count: u32,
    pub vertex_stride: DeviceSize,
    pub vertex_format: Format,
    pub index_data: Buffer,
    pub index_offset: DeviceSize,
    pub index_count: u32,
    pub index_type: IndexType,
    pub transform_data: Buffer,
    pub transform_offset: DeviceSize,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for GeometryTrianglesNV<'_> {}
unsafe impl Sync for GeometryTrianglesNV<'_> {}
impl ::core::default::Default for GeometryTrianglesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            vertex_data: Buffer::default(),
            vertex_offset: DeviceSize::default(),
            vertex_count: u32::default(),
            vertex_stride: DeviceSize::default(),
            vertex_format: Format::default(),
            index_data: Buffer::default(),
            index_offset: DeviceSize::default(),
            index_count: u32::default(),
            index_type: IndexType::default(),
            transform_data: Buffer::default(),
            transform_offset: DeviceSize::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for GeometryTrianglesNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::GEOMETRY_TRIANGLES_NV;
}
impl<'a> GeometryTrianglesNV<'a> {
    #[inline]
    pub fn vertex_data(mut self, vertex_data: Buffer) -> Self {
        self.vertex_data = vertex_data;
        self
    }
    #[inline]
    pub fn vertex_offset(mut self, vertex_offset: DeviceSize) -> Self {
        self.vertex_offset = vertex_offset;
        self
    }
    #[inline]
    pub fn vertex_count(mut self, vertex_count: u32) -> Self {
        self.vertex_count = vertex_count;
        self
    }
    #[inline]
    pub fn vertex_stride(mut self, vertex_stride: DeviceSize) -> Self {
        self.vertex_stride = vertex_stride;
        self
    }
    #[inline]
    pub fn vertex_format(mut self, vertex_format: Format) -> Self {
        self.vertex_format = vertex_format;
        self
    }
    #[inline]
    pub fn index_data(mut self, index_data: Buffer) -> Self {
        self.index_data = index_data;
        self
    }
    #[inline]
    pub fn index_offset(mut self, index_offset: DeviceSize) -> Self {
        self.index_offset = index_offset;
        self
    }
    #[inline]
    pub fn index_count(mut self, index_count: u32) -> Self {
        self.index_count = index_count;
        self
    }
    #[inline]
    pub fn index_type(mut self, index_type: IndexType) -> Self {
        self.index_type = index_type;
        self
    }
    #[inline]
    pub fn transform_data(mut self, transform_data: Buffer) -> Self {
        self.transform_data = transform_data;
        self
    }
    #[inline]
    pub fn transform_offset(mut self, transform_offset: DeviceSize) -> Self {
        self.transform_offset = transform_offset;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkGeometryAABBNV.html>"]
#[must_use]
pub struct GeometryAABBNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub aabb_data: Buffer,
    pub num_aab_bs: u32,
    pub stride: u32,
    pub offset: DeviceSize,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for GeometryAABBNV<'_> {}
unsafe impl Sync for GeometryAABBNV<'_> {}
impl ::core::default::Default for GeometryAABBNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            aabb_data: Buffer::default(),
            num_aab_bs: u32::default(),
            stride: u32::default(),
            offset: DeviceSize::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for GeometryAABBNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::GEOMETRY_AABB_NV;
}
impl<'a> GeometryAABBNV<'a> {
    #[inline]
    pub fn aabb_data(mut self, aabb_data: Buffer) -> Self {
        self.aabb_data = aabb_data;
        self
    }
    #[inline]
    pub fn num_aab_bs(mut self, num_aab_bs: u32) -> Self {
        self.num_aab_bs = num_aab_bs;
        self
    }
    #[inline]
    pub fn stride(mut self, stride: u32) -> Self {
        self.stride = stride;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.offset = offset;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkGeometryDataNV.html>"]
#[must_use]
pub struct GeometryDataNV<'a> {
    pub triangles: GeometryTrianglesNV<'a>,
    pub aabbs: GeometryAABBNV<'a>,
    pub _marker: PhantomData<&'a ()>,
}
impl<'a> GeometryDataNV<'a> {
    #[inline]
    pub fn triangles(mut self, triangles: GeometryTrianglesNV<'a>) -> Self {
        self.triangles = triangles;
        self
    }
    #[inline]
    pub fn aabbs(mut self, aabbs: GeometryAABBNV<'a>) -> Self {
        self.aabbs = aabbs;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkGeometryNV.html>"]
#[must_use]
pub struct GeometryNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub geometry_type: GeometryTypeKHR,
    pub geometry: GeometryDataNV<'a>,
    pub flags: GeometryFlagsKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for GeometryNV<'_> {}
unsafe impl Sync for GeometryNV<'_> {}
impl ::core::default::Default for GeometryNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            geometry_type: GeometryTypeKHR::default(),
            geometry: GeometryDataNV::default(),
            flags: GeometryFlagsKHR::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for GeometryNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::GEOMETRY_NV;
}
impl<'a> GeometryNV<'a> {
    #[inline]
    pub fn geometry_type(mut self, geometry_type: GeometryTypeKHR) -> Self {
        self.geometry_type = geometry_type;
        self
    }
    #[inline]
    pub fn geometry(mut self, geometry: GeometryDataNV<'a>) -> Self {
        self.geometry = geometry;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: GeometryFlagsKHR) -> Self {
        self.flags = flags;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAccelerationStructureInfoNV.html>"]
#[must_use]
pub struct AccelerationStructureInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub ty: AccelerationStructureTypeNV,
    pub flags: BuildAccelerationStructureFlagsNV,
    pub instance_count: u32,
    pub geometry_count: u32,
    pub p_geometries: *const GeometryNV<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for AccelerationStructureInfoNV<'_> {}
unsafe impl Sync for AccelerationStructureInfoNV<'_> {}
impl ::core::default::Default for AccelerationStructureInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            ty: AccelerationStructureTypeNV::default(),
            flags: BuildAccelerationStructureFlagsNV::default(),
            instance_count: u32::default(),
            geometry_count: u32::default(),
            p_geometries: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for AccelerationStructureInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::ACCELERATION_STRUCTURE_INFO_NV;
}
impl<'a> AccelerationStructureInfoNV<'a> {
    #[inline]
    pub fn ty(mut self, ty: AccelerationStructureTypeNV) -> Self {
        self.ty = ty;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: BuildAccelerationStructureFlagsNV) -> Self {
        self.flags = flags;
        self
    }
    #[inline]
    pub fn instance_count(mut self, instance_count: u32) -> Self {
        self.instance_count = instance_count;
        self
    }
    #[inline]
    pub fn geometries(mut self, geometries: &'a [GeometryNV<'a>]) -> Self {
        self.geometry_count = geometries.len() as _;
        self.p_geometries = geometries.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAccelerationStructureCreateInfoNV.html>"]
#[must_use]
pub struct AccelerationStructureCreateInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub compacted_size: DeviceSize,
    pub info: AccelerationStructureInfoNV<'a>,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for AccelerationStructureCreateInfoNV<'_> {}
unsafe impl Sync for AccelerationStructureCreateInfoNV<'_> {}
impl ::core::default::Default for AccelerationStructureCreateInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            compacted_size: DeviceSize::default(),
            info: AccelerationStructureInfoNV::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for AccelerationStructureCreateInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::ACCELERATION_STRUCTURE_CREATE_INFO_NV;
}
pub unsafe trait ExtendsAccelerationStructureCreateInfoNV {}
impl<'a> AccelerationStructureCreateInfoNV<'a> {
    #[inline]
    pub fn compacted_size(mut self, compacted_size: DeviceSize) -> Self {
        self.compacted_size = compacted_size;
        self
    }
    #[inline]
    pub fn info(mut self, info: AccelerationStructureInfoNV<'a>) -> Self {
        self.info = info;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `x.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsAccelerationStructureCreateInfoNV + ?Sized>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.p_next as _;
            self.p_next = next_ptr;
        }
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkBindAccelerationStructureMemoryInfoNV.html>"]
#[must_use]
pub struct BindAccelerationStructureMemoryInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub acceleration_structure: AccelerationStructureNV,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
    pub device_index_count: u32,
    pub p_device_indices: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for BindAccelerationStructureMemoryInfoNV<'_> {}
unsafe impl Sync for BindAccelerationStructureMemoryInfoNV<'_> {}
impl ::core::default::Default for BindAccelerationStructureMemoryInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            acceleration_structure: AccelerationStructureNV::default(),
            memory: DeviceMemory::default(),
            memory_offset: DeviceSize::default(),
            device_index_count: u32::default(),
            p_device_indices: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for BindAccelerationStructureMemoryInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV;
}
impl<'a> BindAccelerationStructureMemoryInfoNV<'a> {
    #[inline]
    pub fn acceleration_structure(
        mut self,
        acceleration_structure: AccelerationStructureNV,
    ) -> Self {
        self.acceleration_structure = acceleration_structure;
        self
    }
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.memory = memory;
        self
    }
    #[inline]
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> Self {
        self.memory_offset = memory_offset;
        self
    }
    #[inline]
    pub fn device_indices(mut self, device_indices: &'a [u32]) -> Self {
        self.device_index_count = device_indices.len() as _;
        self.p_device_indices = device_indices.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkWriteDescriptorSetAccelerationStructureKHR.html>"]
#[must_use]
pub struct WriteDescriptorSetAccelerationStructureKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub acceleration_structure_count: u32,
    pub p_acceleration_structures: *const AccelerationStructureKHR,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for WriteDescriptorSetAccelerationStructureKHR<'_> {}
unsafe impl Sync for WriteDescriptorSetAccelerationStructureKHR<'_> {}
impl ::core::default::Default for WriteDescriptorSetAccelerationStructureKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            acceleration_structure_count: u32::default(),
            p_acceleration_structures: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for WriteDescriptorSetAccelerationStructureKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR;
}
unsafe impl ExtendsWriteDescriptorSet for WriteDescriptorSetAccelerationStructureKHR<'_> {}
impl<'a> WriteDescriptorSetAccelerationStructureKHR<'a> {
    #[inline]
    pub fn acceleration_structures(
        mut self,
        acceleration_structures: &'a [AccelerationStructureKHR],
    ) -> Self {
        self.acceleration_structure_count = acceleration_structures.len() as _;
        self.p_acceleration_structures = acceleration_structures.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkWriteDescriptorSetAccelerationStructureNV.html>"]
#[must_use]
pub struct WriteDescriptorSetAccelerationStructureNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub acceleration_structure_count: u32,
    pub p_acceleration_structures: *const AccelerationStructureNV,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for WriteDescriptorSetAccelerationStructureNV<'_> {}
unsafe impl Sync for WriteDescriptorSetAccelerationStructureNV<'_> {}
impl ::core::default::Default for WriteDescriptorSetAccelerationStructureNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            acceleration_structure_count: u32::default(),
            p_acceleration_structures: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for WriteDescriptorSetAccelerationStructureNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV;
}
unsafe impl ExtendsWriteDescriptorSet for WriteDescriptorSetAccelerationStructureNV<'_> {}
impl<'a> WriteDescriptorSetAccelerationStructureNV<'a> {
    #[inline]
    pub fn acceleration_structures(
        mut self,
        acceleration_structures: &'a [AccelerationStructureNV],
    ) -> Self {
        self.acceleration_structure_count = acceleration_structures.len() as _;
        self.p_acceleration_structures = acceleration_structures.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkAccelerationStructureMemoryRequirementsInfoNV.html>"]
#[must_use]
pub struct AccelerationStructureMemoryRequirementsInfoNV<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub ty: AccelerationStructureMemoryRequirementsTypeNV,
    pub acceleration_structure: AccelerationStructureNV,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for AccelerationStructureMemoryRequirementsInfoNV<'_> {}
unsafe impl Sync for AccelerationStructureMemoryRequirementsInfoNV<'_> {}
impl ::core::default::Default for AccelerationStructureMemoryRequirementsInfoNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            ty: AccelerationStructureMemoryRequirementsTypeNV::default(),
            acceleration_structure: AccelerationStructureNV::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for AccelerationStructureMemoryRequirementsInfoNV<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV;
}
impl<'a> AccelerationStructureMemoryRequirementsInfoNV<'a> {
    #[inline]
    pub fn ty(mut self, ty: AccelerationStructureMemoryRequirementsTypeNV) -> Self {
        self.ty = ty;
        self
    }
    #[inline]
    pub fn acceleration_structure(
        mut self,
        acceleration_structure: AccelerationStructureNV,
    ) -> Self {
        self.acceleration_structure = acceleration_structure;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceAccelerationStructureFeaturesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceAccelerationStructureFeaturesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub acceleration_structure: Bool32,
    pub acceleration_structure_capture_replay: Bool32,
    pub acceleration_structure_indirect_build: Bool32,
    pub acceleration_structure_host_commands: Bool32,
    pub descriptor_binding_acceleration_structure_update_after_bind: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceAccelerationStructureFeaturesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceAccelerationStructureFeaturesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceAccelerationStructureFeaturesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            acceleration_structure: Bool32::default(),
            acceleration_structure_capture_replay: Bool32::default(),
            acceleration_structure_indirect_build: Bool32::default(),
            acceleration_structure_host_commands: Bool32::default(),
            descriptor_binding_acceleration_structure_update_after_bind: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceAccelerationStructureFeaturesKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceAccelerationStructureFeaturesKHR<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceAccelerationStructureFeaturesKHR<'_> {}
impl<'a> PhysicalDeviceAccelerationStructureFeaturesKHR<'a> {
    #[inline]
    pub fn acceleration_structure(mut self, acceleration_structure: bool) -> Self {
        self.acceleration_structure = acceleration_structure.into();
        self
    }
    #[inline]
    pub fn acceleration_structure_capture_replay(
        mut self,
        acceleration_structure_capture_replay: bool,
    ) -> Self {
        self.acceleration_structure_capture_replay = acceleration_structure_capture_replay.into();
        self
    }
    #[inline]
    pub fn acceleration_structure_indirect_build(
        mut self,
        acceleration_structure_indirect_build: bool,
    ) -> Self {
        self.acceleration_structure_indirect_build = acceleration_structure_indirect_build.into();
        self
    }
    #[inline]
    pub fn acceleration_structure_host_commands(
        mut self,
        acceleration_structure_host_commands: bool,
    ) -> Self {
        self.acceleration_structure_host_commands = acceleration_structure_host_commands.into();
        self
    }
    #[inline]
    pub fn descriptor_binding_acceleration_structure_update_after_bind(
        mut self,
        descriptor_binding_acceleration_structure_update_after_bind: bool,
    ) -> Self {
        self.descriptor_binding_acceleration_structure_update_after_bind =
            descriptor_binding_acceleration_structure_update_after_bind.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceRayTracingPipelineFeaturesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceRayTracingPipelineFeaturesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub ray_tracing_pipeline: Bool32,
    pub ray_tracing_pipeline_shader_group_handle_capture_replay: Bool32,
    pub ray_tracing_pipeline_shader_group_handle_capture_replay_mixed: Bool32,
    pub ray_tracing_pipeline_trace_rays_indirect: Bool32,
    pub ray_traversal_primitive_culling: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceRayTracingPipelineFeaturesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceRayTracingPipelineFeaturesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceRayTracingPipelineFeaturesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            ray_tracing_pipeline: Bool32::default(),
            ray_tracing_pipeline_shader_group_handle_capture_replay: Bool32::default(),
            ray_tracing_pipeline_shader_group_handle_capture_replay_mixed: Bool32::default(),
            ray_tracing_pipeline_trace_rays_indirect: Bool32::default(),
            ray_traversal_primitive_culling: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceRayTracingPipelineFeaturesKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceRayTracingPipelineFeaturesKHR<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceRayTracingPipelineFeaturesKHR<'_> {}
impl<'a> PhysicalDeviceRayTracingPipelineFeaturesKHR<'a> {
    #[inline]
    pub fn ray_tracing_pipeline(mut self, ray_tracing_pipeline: bool) -> Self {
        self.ray_tracing_pipeline = ray_tracing_pipeline.into();
        self
    }
    #[inline]
    pub fn ray_tracing_pipeline_shader_group_handle_capture_replay(
        mut self,
        ray_tracing_pipeline_shader_group_handle_capture_replay: bool,
    ) -> Self {
        self.ray_tracing_pipeline_shader_group_handle_capture_replay =
            ray_tracing_pipeline_shader_group_handle_capture_replay.into();
        self
    }
    #[inline]
    pub fn ray_tracing_pipeline_shader_group_handle_capture_replay_mixed(
        mut self,
        ray_tracing_pipeline_shader_group_handle_capture_replay_mixed: bool,
    ) -> Self {
        self.ray_tracing_pipeline_shader_group_handle_capture_replay_mixed =
            ray_tracing_pipeline_shader_group_handle_capture_replay_mixed.into();
        self
    }
    #[inline]
    pub fn ray_tracing_pipeline_trace_rays_indirect(
        mut self,
        ray_tracing_pipeline_trace_rays_indirect: bool,
    ) -> Self {
        self.ray_tracing_pipeline_trace_rays_indirect =
            ray_tracing_pipeline_trace_rays_indirect.into();
        self
    }
    #[inline]
    pub fn ray_traversal_primitive_culling(
        mut self,
        ray_traversal_primitive_culling: bool,
    ) -> Self {
        self.ray_traversal_primitive_culling = ray_traversal_primitive_culling.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceRayQueryFeaturesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceRayQueryFeaturesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub ray_query: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceRayQueryFeaturesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceRayQueryFeaturesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceRayQueryFeaturesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            ray_query: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceRayQueryFeaturesKHR<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceRayQueryFeaturesKHR<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceRayQueryFeaturesKHR<'_> {}
impl<'a> PhysicalDeviceRayQueryFeaturesKHR<'a> {
    #[inline]
    pub fn ray_query(mut self, ray_query: bool) -> Self {
        self.ray_query = ray_query.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceAccelerationStructurePropertiesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceAccelerationStructurePropertiesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_geometry_count: u64,
    pub max_instance_count: u64,
    pub max_primitive_count: u64,
    pub max_per_stage_descriptor_acceleration_structures: u32,
    pub max_per_stage_descriptor_update_after_bind_acceleration_structures: u32,
    pub max_descriptor_set_acceleration_structures: u32,
    pub max_descriptor_set_update_after_bind_acceleration_structures: u32,
    pub min_acceleration_structure_scratch_offset_alignment: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceAccelerationStructurePropertiesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceAccelerationStructurePropertiesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceAccelerationStructurePropertiesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            max_geometry_count: u64::default(),
            max_instance_count: u64::default(),
            max_primitive_count: u64::default(),
            max_per_stage_descriptor_acceleration_structures: u32::default(),
            max_per_stage_descriptor_update_after_bind_acceleration_structures: u32::default(),
            max_descriptor_set_acceleration_structures: u32::default(),
            max_descriptor_set_update_after_bind_acceleration_structures: u32::default(),
            min_acceleration_structure_scratch_offset_alignment: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceAccelerationStructurePropertiesKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR;
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceAccelerationStructurePropertiesKHR<'_>
{
}
impl<'a> PhysicalDeviceAccelerationStructurePropertiesKHR<'a> {
    #[inline]
    pub fn max_geometry_count(mut self, max_geometry_count: u64) -> Self {
        self.max_geometry_count = max_geometry_count;
        self
    }
    #[inline]
    pub fn max_instance_count(mut self, max_instance_count: u64) -> Self {
        self.max_instance_count = max_instance_count;
        self
    }
    #[inline]
    pub fn max_primitive_count(mut self, max_primitive_count: u64) -> Self {
        self.max_primitive_count = max_primitive_count;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_acceleration_structures(
        mut self,
        max_per_stage_descriptor_acceleration_structures: u32,
    ) -> Self {
        self.max_per_stage_descriptor_acceleration_structures =
            max_per_stage_descriptor_acceleration_structures;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_acceleration_structures(
        mut self,
        max_per_stage_descriptor_update_after_bind_acceleration_structures: u32,
    ) -> Self {
        self.max_per_stage_descriptor_update_after_bind_acceleration_structures =
            max_per_stage_descriptor_update_after_bind_acceleration_structures;
        self
    }
    #[inline]
    pub fn max_descriptor_set_acceleration_structures(
        mut self,
        max_descriptor_set_acceleration_structures: u32,
    ) -> Self {
        self.max_descriptor_set_acceleration_structures =
            max_descriptor_set_acceleration_structures;
        self
    }
    #[inline]
    pub fn max_descriptor_set_update_after_bind_acceleration_structures(
        mut self,
        max_descriptor_set_update_after_bind_acceleration_structures: u32,
    ) -> Self {
        self.max_descriptor_set_update_after_bind_acceleration_structures =
            max_descriptor_set_update_after_bind_acceleration_structures;
        self
    }
    #[inline]
    pub fn min_acceleration_structure_scratch_offset_alignment(
        mut self,
        min_acceleration_structure_scratch_offset_alignment: u32,
    ) -> Self {
        self.min_acceleration_structure_scratch_offset_alignment =
            min_acceleration_structure_scratch_offset_alignment;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceRayTracingPipelinePropertiesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceRayTracingPipelinePropertiesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_group_handle_size: u32,
    pub max_ray_recursion_depth: u32,
    pub max_shader_group_stride: u32,
    pub shader_group_base_alignment: u32,
    pub shader_group_handle_capture_replay_size: u32,
    pub max_ray_dispatch_invocation_count: u32,
    pub shader_group_handle_alignment: u32,
    pub max_ray_hit_attribute_size: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceRayTracingPipelinePropertiesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceRayTracingPipelinePropertiesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceRayTracingPipelinePropertiesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shader_group_handle_size: u32::default(),
            max_ray_recursion_depth: u32::default(),
            max_shader_group_stride: u32::default(),
            shader_group_base_alignment: u32::default(),
            shader_group_handle_capture_replay_size: u32::default(),
            max_ray_dispatch_invocation_count: u32::default(),
            shader_group_handle_alignment: u32::default(),
            max_ray_hit_attribute_size: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceRayTracingPipelinePropertiesKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceRayTracingPipelinePropertiesKHR<'_> {}
impl<'a> PhysicalDeviceRayTracingPipelinePropertiesKHR<'a> {
    #[inline]
    pub fn shader_group_handle_size(mut self, shader_group_handle_size: u32) -> Self {
        self.shader_group_handle_size = shader_group_handle_size;
        self
    }
    #[inline]
    pub fn max_ray_recursion_depth(mut self, max_ray_recursion_depth: u32) -> Self {
        self.max_ray_recursion_depth = max_ray_recursion_depth;
        self
    }
    #[inline]
    pub fn max_shader_group_stride(mut self, max_shader_group_stride: u32) -> Self {
        self.max_shader_group_stride = max_shader_group_stride;
        self
    }
    #[inline]
    pub fn shader_group_base_alignment(mut self, shader_group_base_alignment: u32) -> Self {
        self.shader_group_base_alignment = shader_group_base_alignment;
        self
    }
    #[inline]
    pub fn shader_group_handle_capture_replay_size(
        mut self,
        shader_group_handle_capture_replay_size: u32,
    ) -> Self {
        self.shader_group_handle_capture_replay_size = shader_group_handle_capture_replay_size;
        self
    }
    #[inline]
    pub fn max_ray_dispatch_invocation_count(
        mut self,
        max_ray_dispatch_invocation_count: u32,
    ) -> Self {
        self.max_ray_dispatch_invocation_count = max_ray_dispatch_invocation_count;
        self
    }
    #[inline]
    pub fn shader_group_handle_alignment(mut self, shader_group_handle_alignment: u32) -> Self {
        self.shader_group_handle_alignment = shader_group_handle_alignment;
        self
    }
    #[inline]
    pub fn max_ray_hit_attribute_size(mut self, max_ray_hit_attribute_size: u32) -> Self {
        self.max_ray_hit_attribute_size = max_ray_hit_attribute_size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceRayTracingPropertiesNV.html>"]
#[must_use]
pub struct PhysicalDeviceRayTracingPropertiesNV<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_group_handle_size: u32,
    pub max_recursion_depth: u32,
    pub max_shader_group_stride: u32,
    pub shader_group_base_alignment: u32,
    pub max_geometry_count: u64,
    pub max_instance_count: u64,
    pub max_triangle_count: u64,
    pub max_descriptor_set_acceleration_structures: u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceRayTracingPropertiesNV<'_> {}
unsafe impl Sync for PhysicalDeviceRayTracingPropertiesNV<'_> {}
impl ::core::default::Default for PhysicalDeviceRayTracingPropertiesNV<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            shader_group_handle_size: u32::default(),
            max_recursion_depth: u32::default(),
            max_shader_group_stride: u32::default(),
            shader_group_base_alignment: u32::default(),
            max_geometry_count: u64::default(),
            max_instance_count: u64::default(),
            max_triangle_count: u64::default(),
            max_descriptor_set_acceleration_structures: u32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceRayTracingPropertiesNV<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV;
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceRayTracingPropertiesNV<'_> {}
impl<'a> PhysicalDeviceRayTracingPropertiesNV<'a> {
    #[inline]
    pub fn shader_group_handle_size(mut self, shader_group_handle_size: u32) -> Self {
        self.shader_group_handle_size = shader_group_handle_size;
        self
    }
    #[inline]
    pub fn max_recursion_depth(mut self, max_recursion_depth: u32) -> Self {
        self.max_recursion_depth = max_recursion_depth;
        self
    }
    #[inline]
    pub fn max_shader_group_stride(mut self, max_shader_group_stride: u32) -> Self {
        self.max_shader_group_stride = max_shader_group_stride;
        self
    }
    #[inline]
    pub fn shader_group_base_alignment(mut self, shader_group_base_alignment: u32) -> Self {
        self.shader_group_base_alignment = shader_group_base_alignment;
        self
    }
    #[inline]
    pub fn max_geometry_count(mut self, max_geometry_count: u64) -> Self {
        self.max_geometry_count = max_geometry_count;
        self
    }
    #[inline]
    pub fn max_instance_count(mut self, max_instance_count: u64) -> Self {
        self.max_instance_count = max_instance_count;
        self
    }
    #[inline]
    pub fn max_triangle_count(mut self, max_triangle_count: u64) -> Self {
        self.max_triangle_count = max_triangle_count;
        self
    }
    #[inline]
    pub fn max_descriptor_set_acceleration_structures(
        mut self,
        max_descriptor_set_acceleration_structures: u32,
    ) -> Self {
        self.max_descriptor_set_acceleration_structures =
            max_descriptor_set_acceleration_structures;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkStridedDeviceAddressRegionKHR.html>"]
#[must_use]
pub struct StridedDeviceAddressRegionKHR {
    pub device_address: DeviceAddress,
    pub stride: DeviceSize,
    pub size: DeviceSize,
}
impl StridedDeviceAddressRegionKHR {
    #[inline]
    pub fn device_address(mut self, device_address: DeviceAddress) -> Self {
        self.device_address = device_address;
        self
    }
    #[inline]
    pub fn stride(mut self, stride: DeviceSize) -> Self {
        self.stride = stride;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.size = size;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkTraceRaysIndirectCommandKHR.html>"]
#[must_use]
pub struct TraceRaysIndirectCommandKHR {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}
impl TraceRaysIndirectCommandKHR {
    #[inline]
    pub fn width(mut self, width: u32) -> Self {
        self.width = width;
        self
    }
    #[inline]
    pub fn height(mut self, height: u32) -> Self {
        self.height = height;
        self
    }
    #[inline]
    pub fn depth(mut self, depth: u32) -> Self {
        self.depth = depth;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkTraceRaysIndirectCommand2KHR.html>"]
#[must_use]
pub struct TraceRaysIndirectCommand2KHR {
    pub raygen_shader_record_address: DeviceAddress,
    pub raygen_shader_record_size: DeviceSize,
    pub miss_shader_binding_table_address: DeviceAddress,
    pub miss_shader_binding_table_size: DeviceSize,
    pub miss_shader_binding_table_stride: DeviceSize,
    pub hit_shader_binding_table_address: DeviceAddress,
    pub hit_shader_binding_table_size: DeviceSize,
    pub hit_shader_binding_table_stride: DeviceSize,
    pub callable_shader_binding_table_address: DeviceAddress,
    pub callable_shader_binding_table_size: DeviceSize,
    pub callable_shader_binding_table_stride: DeviceSize,
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}
impl TraceRaysIndirectCommand2KHR {
    #[inline]
    pub fn raygen_shader_record_address(
        mut self,
        raygen_shader_record_address: DeviceAddress,
    ) -> Self {
        self.raygen_shader_record_address = raygen_shader_record_address;
        self
    }
    #[inline]
    pub fn raygen_shader_record_size(mut self, raygen_shader_record_size: DeviceSize) -> Self {
        self.raygen_shader_record_size = raygen_shader_record_size;
        self
    }
    #[inline]
    pub fn miss_shader_binding_table_address(
        mut self,
        miss_shader_binding_table_address: DeviceAddress,
    ) -> Self {
        self.miss_shader_binding_table_address = miss_shader_binding_table_address;
        self
    }
    #[inline]
    pub fn miss_shader_binding_table_size(
        mut self,
        miss_shader_binding_table_size: DeviceSize,
    ) -> Self {
        self.miss_shader_binding_table_size = miss_shader_binding_table_size;
        self
    }
    #[inline]
    pub fn miss_shader_binding_table_stride(
        mut self,
        miss_shader_binding_table_stride: DeviceSize,
    ) -> Self {
        self.miss_shader_binding_table_stride = miss_shader_binding_table_stride;
        self
    }
    #[inline]
    pub fn hit_shader_binding_table_address(
        mut self,
        hit_shader_binding_table_address: DeviceAddress,
    ) -> Self {
        self.hit_shader_binding_table_address = hit_shader_binding_table_address;
        self
    }
    #[inline]
    pub fn hit_shader_binding_table_size(
        mut self,
        hit_shader_binding_table_size: DeviceSize,
    ) -> Self {
        self.hit_shader_binding_table_size = hit_shader_binding_table_size;
        self
    }
    #[inline]
    pub fn hit_shader_binding_table_stride(
        mut self,
        hit_shader_binding_table_stride: DeviceSize,
    ) -> Self {
        self.hit_shader_binding_table_stride = hit_shader_binding_table_stride;
        self
    }
    #[inline]
    pub fn callable_shader_binding_table_address(
        mut self,
        callable_shader_binding_table_address: DeviceAddress,
    ) -> Self {
        self.callable_shader_binding_table_address = callable_shader_binding_table_address;
        self
    }
    #[inline]
    pub fn callable_shader_binding_table_size(
        mut self,
        callable_shader_binding_table_size: DeviceSize,
    ) -> Self {
        self.callable_shader_binding_table_size = callable_shader_binding_table_size;
        self
    }
    #[inline]
    pub fn callable_shader_binding_table_stride(
        mut self,
        callable_shader_binding_table_stride: DeviceSize,
    ) -> Self {
        self.callable_shader_binding_table_stride = callable_shader_binding_table_stride;
        self
    }
    #[inline]
    pub fn width(mut self, width: u32) -> Self {
        self.width = width;
        self
    }
    #[inline]
    pub fn height(mut self, height: u32) -> Self {
        self.height = height;
        self
    }
    #[inline]
    pub fn depth(mut self, depth: u32) -> Self {
        self.depth = depth;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR.html>"]
#[must_use]
pub struct PhysicalDeviceRayTracingMaintenance1FeaturesKHR<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub ray_tracing_maintenance1: Bool32,
    pub ray_tracing_pipeline_trace_rays_indirect2: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceRayTracingMaintenance1FeaturesKHR<'_> {}
unsafe impl Sync for PhysicalDeviceRayTracingMaintenance1FeaturesKHR<'_> {}
impl ::core::default::Default for PhysicalDeviceRayTracingMaintenance1FeaturesKHR<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            ray_tracing_maintenance1: Bool32::default(),
            ray_tracing_pipeline_trace_rays_indirect2: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceRayTracingMaintenance1FeaturesKHR<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceRayTracingMaintenance1FeaturesKHR<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceRayTracingMaintenance1FeaturesKHR<'_> {}
impl<'a> PhysicalDeviceRayTracingMaintenance1FeaturesKHR<'a> {
    #[inline]
    pub fn ray_tracing_maintenance1(mut self, ray_tracing_maintenance1: bool) -> Self {
        self.ray_tracing_maintenance1 = ray_tracing_maintenance1.into();
        self
    }
    #[inline]
    pub fn ray_tracing_pipeline_trace_rays_indirect2(
        mut self,
        ray_tracing_pipeline_trace_rays_indirect2: bool,
    ) -> Self {
        self.ray_tracing_pipeline_trace_rays_indirect2 =
            ray_tracing_pipeline_trace_rays_indirect2.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDrmFormatModifierPropertiesListEXT.html>"]
#[must_use]
pub struct DrmFormatModifierPropertiesListEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub drm_format_modifier_count: u32,
    pub p_drm_format_modifier_properties: *mut DrmFormatModifierPropertiesEXT,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DrmFormatModifierPropertiesListEXT<'_> {}
unsafe impl Sync for DrmFormatModifierPropertiesListEXT<'_> {}
impl ::core::default::Default for DrmFormatModifierPropertiesListEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            drm_format_modifier_count: u32::default(),
            p_drm_format_modifier_properties: ::core::ptr::null_mut(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DrmFormatModifierPropertiesListEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT;
}
unsafe impl ExtendsFormatProperties2 for DrmFormatModifierPropertiesListEXT<'_> {}
impl<'a> DrmFormatModifierPropertiesListEXT<'a> {
    #[inline]
    pub fn drm_format_modifier_properties(
        mut self,
        drm_format_modifier_properties: &'a mut [DrmFormatModifierPropertiesEXT],
    ) -> Self {
        self.drm_format_modifier_count = drm_format_modifier_properties.len() as _;
        self.p_drm_format_modifier_properties = drm_format_modifier_properties.as_mut_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDrmFormatModifierPropertiesEXT.html>"]
#[must_use]
pub struct DrmFormatModifierPropertiesEXT {
    pub drm_format_modifier: u64,
    pub drm_format_modifier_plane_count: u32,
    pub drm_format_modifier_tiling_features: FormatFeatureFlags,
}
impl DrmFormatModifierPropertiesEXT {
    #[inline]
    pub fn drm_format_modifier(mut self, drm_format_modifier: u64) -> Self {
        self.drm_format_modifier = drm_format_modifier;
        self
    }
    #[inline]
    pub fn drm_format_modifier_plane_count(mut self, drm_format_modifier_plane_count: u32) -> Self {
        self.drm_format_modifier_plane_count = drm_format_modifier_plane_count;
        self
    }
    #[inline]
    pub fn drm_format_modifier_tiling_features(
        mut self,
        drm_format_modifier_tiling_features: FormatFeatureFlags,
    ) -> Self {
        self.drm_format_modifier_tiling_features = drm_format_modifier_tiling_features;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceImageDrmFormatModifierInfoEXT.html>"]
#[must_use]
pub struct PhysicalDeviceImageDrmFormatModifierInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub drm_format_modifier: u64,
    pub sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub p_queue_family_indices: *const u32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceImageDrmFormatModifierInfoEXT<'_> {}
unsafe impl Sync for PhysicalDeviceImageDrmFormatModifierInfoEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceImageDrmFormatModifierInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            drm_format_modifier: u64::default(),
            sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            p_queue_family_indices: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceImageDrmFormatModifierInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT;
}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2
    for PhysicalDeviceImageDrmFormatModifierInfoEXT<'_>
{
}
impl<'a> PhysicalDeviceImageDrmFormatModifierInfoEXT<'a> {
    #[inline]
    pub fn drm_format_modifier(mut self, drm_format_modifier: u64) -> Self {
        self.drm_format_modifier = drm_format_modifier;
        self
    }
    #[inline]
    pub fn sharing_mode(mut self, sharing_mode: SharingMode) -> Self {
        self.sharing_mode = sharing_mode;
        self
    }
    #[inline]
    pub fn queue_family_indices(mut self, queue_family_indices: &'a [u32]) -> Self {
        self.queue_family_index_count = queue_family_indices.len() as _;
        self.p_queue_family_indices = queue_family_indices.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageDrmFormatModifierListCreateInfoEXT.html>"]
#[must_use]
pub struct ImageDrmFormatModifierListCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub drm_format_modifier_count: u32,
    pub p_drm_format_modifiers: *const u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageDrmFormatModifierListCreateInfoEXT<'_> {}
unsafe impl Sync for ImageDrmFormatModifierListCreateInfoEXT<'_> {}
impl ::core::default::Default for ImageDrmFormatModifierListCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            drm_format_modifier_count: u32::default(),
            p_drm_format_modifiers: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageDrmFormatModifierListCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT;
}
unsafe impl ExtendsImageCreateInfo for ImageDrmFormatModifierListCreateInfoEXT<'_> {}
impl<'a> ImageDrmFormatModifierListCreateInfoEXT<'a> {
    #[inline]
    pub fn drm_format_modifiers(mut self, drm_format_modifiers: &'a [u64]) -> Self {
        self.drm_format_modifier_count = drm_format_modifiers.len() as _;
        self.p_drm_format_modifiers = drm_format_modifiers.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageDrmFormatModifierExplicitCreateInfoEXT.html>"]
#[must_use]
pub struct ImageDrmFormatModifierExplicitCreateInfoEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub drm_format_modifier: u64,
    pub drm_format_modifier_plane_count: u32,
    pub p_plane_layouts: *const SubresourceLayout,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageDrmFormatModifierExplicitCreateInfoEXT<'_> {}
unsafe impl Sync for ImageDrmFormatModifierExplicitCreateInfoEXT<'_> {}
impl ::core::default::Default for ImageDrmFormatModifierExplicitCreateInfoEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            drm_format_modifier: u64::default(),
            drm_format_modifier_plane_count: u32::default(),
            p_plane_layouts: ::core::ptr::null(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageDrmFormatModifierExplicitCreateInfoEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT;
}
unsafe impl ExtendsImageCreateInfo for ImageDrmFormatModifierExplicitCreateInfoEXT<'_> {}
impl<'a> ImageDrmFormatModifierExplicitCreateInfoEXT<'a> {
    #[inline]
    pub fn drm_format_modifier(mut self, drm_format_modifier: u64) -> Self {
        self.drm_format_modifier = drm_format_modifier;
        self
    }
    #[inline]
    pub fn plane_layouts(mut self, plane_layouts: &'a [SubresourceLayout]) -> Self {
        self.drm_format_modifier_plane_count = plane_layouts.len() as _;
        self.p_plane_layouts = plane_layouts.as_ptr();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageDrmFormatModifierPropertiesEXT.html>"]
#[must_use]
pub struct ImageDrmFormatModifierPropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub drm_format_modifier: u64,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageDrmFormatModifierPropertiesEXT<'_> {}
unsafe impl Sync for ImageDrmFormatModifierPropertiesEXT<'_> {}
impl ::core::default::Default for ImageDrmFormatModifierPropertiesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            drm_format_modifier: u64::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageDrmFormatModifierPropertiesEXT<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT;
}
impl<'a> ImageDrmFormatModifierPropertiesEXT<'a> {
    #[inline]
    pub fn drm_format_modifier(mut self, drm_format_modifier: u64) -> Self {
        self.drm_format_modifier = drm_format_modifier;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkImageStencilUsageCreateInfo.html>"]
#[must_use]
pub struct ImageStencilUsageCreateInfo<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub stencil_usage: ImageUsageFlags,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for ImageStencilUsageCreateInfo<'_> {}
unsafe impl Sync for ImageStencilUsageCreateInfo<'_> {}
impl ::core::default::Default for ImageStencilUsageCreateInfo<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            stencil_usage: ImageUsageFlags::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for ImageStencilUsageCreateInfo<'a> {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_STENCIL_USAGE_CREATE_INFO;
}
unsafe impl ExtendsImageCreateInfo for ImageStencilUsageCreateInfo<'_> {}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2 for ImageStencilUsageCreateInfo<'_> {}
impl<'a> ImageStencilUsageCreateInfo<'a> {
    #[inline]
    pub fn stencil_usage(mut self, stencil_usage: ImageUsageFlags) -> Self {
        self.stencil_usage = stencil_usage;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDeviceMemoryOverallocationCreateInfoAMD.html>"]
#[must_use]
pub struct DeviceMemoryOverallocationCreateInfoAMD<'a> {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub overallocation_behavior: MemoryOverallocationBehaviorAMD,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for DeviceMemoryOverallocationCreateInfoAMD<'_> {}
unsafe impl Sync for DeviceMemoryOverallocationCreateInfoAMD<'_> {}
impl ::core::default::Default for DeviceMemoryOverallocationCreateInfoAMD<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null(),
            overallocation_behavior: MemoryOverallocationBehaviorAMD::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for DeviceMemoryOverallocationCreateInfoAMD<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD;
}
unsafe impl ExtendsDeviceCreateInfo for DeviceMemoryOverallocationCreateInfoAMD<'_> {}
impl<'a> DeviceMemoryOverallocationCreateInfoAMD<'a> {
    #[inline]
    pub fn overallocation_behavior(
        mut self,
        overallocation_behavior: MemoryOverallocationBehaviorAMD,
    ) -> Self {
        self.overallocation_behavior = overallocation_behavior;
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceFragmentDensityMapFeaturesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceFragmentDensityMapFeaturesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub fragment_density_map: Bool32,
    pub fragment_density_map_dynamic: Bool32,
    pub fragment_density_map_non_subsampled_images: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceFragmentDensityMapFeaturesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceFragmentDensityMapFeaturesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceFragmentDensityMapFeaturesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            fragment_density_map: Bool32::default(),
            fragment_density_map_dynamic: Bool32::default(),
            fragment_density_map_non_subsampled_images: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceFragmentDensityMapFeaturesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceFragmentDensityMapFeaturesEXT<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFragmentDensityMapFeaturesEXT<'_> {}
impl<'a> PhysicalDeviceFragmentDensityMapFeaturesEXT<'a> {
    #[inline]
    pub fn fragment_density_map(mut self, fragment_density_map: bool) -> Self {
        self.fragment_density_map = fragment_density_map.into();
        self
    }
    #[inline]
    pub fn fragment_density_map_dynamic(mut self, fragment_density_map_dynamic: bool) -> Self {
        self.fragment_density_map_dynamic = fragment_density_map_dynamic.into();
        self
    }
    #[inline]
    pub fn fragment_density_map_non_subsampled_images(
        mut self,
        fragment_density_map_non_subsampled_images: bool,
    ) -> Self {
        self.fragment_density_map_non_subsampled_images =
            fragment_density_map_non_subsampled_images.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceFragmentDensityMap2FeaturesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceFragmentDensityMap2FeaturesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub fragment_density_map_deferred: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceFragmentDensityMap2FeaturesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceFragmentDensityMap2FeaturesEXT<'_> {}
impl ::core::default::Default for PhysicalDeviceFragmentDensityMap2FeaturesEXT<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            fragment_density_map_deferred: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceFragmentDensityMap2FeaturesEXT<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT;
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceFragmentDensityMap2FeaturesEXT<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFragmentDensityMap2FeaturesEXT<'_> {}
impl<'a> PhysicalDeviceFragmentDensityMap2FeaturesEXT<'a> {
    #[inline]
    pub fn fragment_density_map_deferred(mut self, fragment_density_map_deferred: bool) -> Self {
        self.fragment_density_map_deferred = fragment_density_map_deferred.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM.html>"]
#[must_use]
pub struct PhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub fragment_density_map_offset: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM<'_> {}
unsafe impl Sync for PhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM<'_> {}
impl ::core::default::Default for PhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM<'_> {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::core::ptr::null_mut(),
            fragment_density_map_offset: Bool32::default(),
            _marker: PhantomData,
        }
    }
}
unsafe impl<'a> TaggedStructure for PhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM<'a> {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM;
}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM<'_>
{
}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM<'_> {}
impl<'a> PhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM<'a> {
    #[inline]
    pub fn fragment_density_map_offset(mut self, fragment_density_map_offset: bool) -> Self {
        self.fragment_density_map_offset = fragment_density_map_offset.into();
        self
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceFragmentDensityMapPropertiesEXT.html>"]
#[must_use]
pub struct PhysicalDeviceFragmentDensityMapPropertiesEXT<'a> {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub min_fragment_density_texel_size: Extent2D,
    pub max_fragment_density_texel_size: Extent2D,
    pub fragment_density_invocations: Bool32,
    pub _marker: PhantomData<&'a ()>,
}
unsafe impl Send for PhysicalDeviceFragmentDensityMapPropertiesEXT<'_> {}
unsafe impl Sync for PhysicalDeviceFragmentDensityMapP