﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/auditmanager/AuditManager_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AuditManager {
namespace Model {

/**
 * <p> The notification that informs a user of an update in Audit Manager. For
 * example, this includes the notification that's sent when a control set is
 * delegated for review. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/Notification">AWS
 * API Reference</a></p>
 */
class Notification {
 public:
  AWS_AUDITMANAGER_API Notification() = default;
  AWS_AUDITMANAGER_API Notification(Aws::Utils::Json::JsonView jsonValue);
  AWS_AUDITMANAGER_API Notification& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_AUDITMANAGER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The unique identifier for the notification. </p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  Notification& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The identifier for the assessment. </p>
   */
  inline const Aws::String& GetAssessmentId() const { return m_assessmentId; }
  inline bool AssessmentIdHasBeenSet() const { return m_assessmentIdHasBeenSet; }
  template <typename AssessmentIdT = Aws::String>
  void SetAssessmentId(AssessmentIdT&& value) {
    m_assessmentIdHasBeenSet = true;
    m_assessmentId = std::forward<AssessmentIdT>(value);
  }
  template <typename AssessmentIdT = Aws::String>
  Notification& WithAssessmentId(AssessmentIdT&& value) {
    SetAssessmentId(std::forward<AssessmentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The name of the related assessment. </p>
   */
  inline const Aws::String& GetAssessmentName() const { return m_assessmentName; }
  inline bool AssessmentNameHasBeenSet() const { return m_assessmentNameHasBeenSet; }
  template <typename AssessmentNameT = Aws::String>
  void SetAssessmentName(AssessmentNameT&& value) {
    m_assessmentNameHasBeenSet = true;
    m_assessmentName = std::forward<AssessmentNameT>(value);
  }
  template <typename AssessmentNameT = Aws::String>
  Notification& WithAssessmentName(AssessmentNameT&& value) {
    SetAssessmentName(std::forward<AssessmentNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The identifier for the control set. </p>
   */
  inline const Aws::String& GetControlSetId() const { return m_controlSetId; }
  inline bool ControlSetIdHasBeenSet() const { return m_controlSetIdHasBeenSet; }
  template <typename ControlSetIdT = Aws::String>
  void SetControlSetId(ControlSetIdT&& value) {
    m_controlSetIdHasBeenSet = true;
    m_controlSetId = std::forward<ControlSetIdT>(value);
  }
  template <typename ControlSetIdT = Aws::String>
  Notification& WithControlSetId(ControlSetIdT&& value) {
    SetControlSetId(std::forward<ControlSetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Specifies the name of the control set that the notification is about. </p>
   */
  inline const Aws::String& GetControlSetName() const { return m_controlSetName; }
  inline bool ControlSetNameHasBeenSet() const { return m_controlSetNameHasBeenSet; }
  template <typename ControlSetNameT = Aws::String>
  void SetControlSetName(ControlSetNameT&& value) {
    m_controlSetNameHasBeenSet = true;
    m_controlSetName = std::forward<ControlSetNameT>(value);
  }
  template <typename ControlSetNameT = Aws::String>
  Notification& WithControlSetName(ControlSetNameT&& value) {
    SetControlSetName(std::forward<ControlSetNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The description of the notification. </p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  Notification& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The time when the notification was sent. </p>
   */
  inline const Aws::Utils::DateTime& GetEventTime() const { return m_eventTime; }
  inline bool EventTimeHasBeenSet() const { return m_eventTimeHasBeenSet; }
  template <typename EventTimeT = Aws::Utils::DateTime>
  void SetEventTime(EventTimeT&& value) {
    m_eventTimeHasBeenSet = true;
    m_eventTime = std::forward<EventTimeT>(value);
  }
  template <typename EventTimeT = Aws::Utils::DateTime>
  Notification& WithEventTime(EventTimeT&& value) {
    SetEventTime(std::forward<EventTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The sender of the notification. </p>
   */
  inline const Aws::String& GetSource() const { return m_source; }
  inline bool SourceHasBeenSet() const { return m_sourceHasBeenSet; }
  template <typename SourceT = Aws::String>
  void SetSource(SourceT&& value) {
    m_sourceHasBeenSet = true;
    m_source = std::forward<SourceT>(value);
  }
  template <typename SourceT = Aws::String>
  Notification& WithSource(SourceT&& value) {
    SetSource(std::forward<SourceT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_assessmentId;
  bool m_assessmentIdHasBeenSet = false;

  Aws::String m_assessmentName;
  bool m_assessmentNameHasBeenSet = false;

  Aws::String m_controlSetId;
  bool m_controlSetIdHasBeenSet = false;

  Aws::String m_controlSetName;
  bool m_controlSetNameHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::Utils::DateTime m_eventTime{};
  bool m_eventTimeHasBeenSet = false;

  Aws::String m_source;
  bool m_sourceHasBeenSet = false;
};

}  // namespace Model
}  // namespace AuditManager
}  // namespace Aws
