﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/awstransfer/model/UpdateHostKeyRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Transfer::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateHostKeyRequest::SerializePayload() const {
  JsonValue payload;

  if (m_serverIdHasBeenSet) {
    payload.WithString("ServerId", m_serverId);
  }

  if (m_hostKeyIdHasBeenSet) {
    payload.WithString("HostKeyId", m_hostKeyId);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("Description", m_description);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdateHostKeyRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "TransferService.UpdateHostKey"));
  return headers;
}
