﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codepipeline/model/ActionConfiguration.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CodePipeline {
namespace Model {

ActionConfiguration::ActionConfiguration(JsonView jsonValue) { *this = jsonValue; }

ActionConfiguration& ActionConfiguration::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("configuration")) {
    Aws::Map<Aws::String, JsonView> configurationJsonMap = jsonValue.GetObject("configuration").GetAllObjects();
    for (auto& configurationItem : configurationJsonMap) {
      m_configuration[configurationItem.first] = configurationItem.second.AsString();
    }
    m_configurationHasBeenSet = true;
  }
  return *this;
}

JsonValue ActionConfiguration::Jsonize() const {
  JsonValue payload;

  if (m_configurationHasBeenSet) {
    JsonValue configurationJsonMap;
    for (auto& configurationItem : m_configuration) {
      configurationJsonMap.WithString(configurationItem.first, configurationItem.second);
    }
    payload.WithObject("configuration", std::move(configurationJsonMap));
  }

  return payload;
}

}  // namespace Model
}  // namespace CodePipeline
}  // namespace Aws
